/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.afm.AfmFont;
import org.pentaho.reporting.libraries.fonts.afm.AfmFontRecord;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class AfmFontRegistry
extends AbstractFontFileRegistry {
    private static final Log logger = LogFactory.getLog(AfmFontRegistry.class);
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();

    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException();
    }

    public FontCache getSecondLevelCache() {
        throw new UnsupportedOperationException();
    }

    public boolean addFont(File file, String string) throws IOException {
        String string2 = file.getCanonicalPath();
        String string3 = string2.substring(0, string2.length() - 3) + "pfb";
        File file2 = new File(string3);
        boolean bl = true;
        if (!(file2.exists() && file2.isFile() && file2.canRead())) {
            logger.warn((Object)("Cannot embedd font: " + file2 + " is missing for " + file));
            bl = false;
        }
        AfmFont afmFont = new AfmFont(file, bl);
        this.registerFont(afmFont);
        afmFont.dispose();
        return true;
    }

    private void registerFont(AfmFont afmFont) throws IOException {
        String string = afmFont.getFamilyName();
        String string2 = afmFont.getFontName();
        DefaultFontFamily defaultFontFamily = this.createFamily(string);
        this.alternateFamilyNames.put(string, defaultFontFamily);
        this.alternateFamilyNames.put(string2, defaultFontFamily);
        this.fullFontNames.put(string, defaultFontFamily);
        this.fullFontNames.put(string2, defaultFontFamily);
        AfmFontRecord afmFontRecord = new AfmFontRecord(afmFont, defaultFontFamily);
        defaultFontFamily.addFontRecord(afmFontRecord);
    }

    private DefaultFontFamily createFamily(String string) {
        DefaultFontFamily defaultFontFamily = (DefaultFontFamily)this.fontFamilies.get(string);
        if (defaultFontFamily != null) {
            return defaultFontFamily;
        }
        DefaultFontFamily defaultFontFamily2 = new DefaultFontFamily(string);
        this.fontFamilies.put(string, defaultFontFamily2);
        return defaultFontFamily2;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    public FontFamily getFontFamily(String string) {
        FontFamily fontFamily = (FontFamily)this.fontFamilies.get(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        FontFamily fontFamily2 = (FontFamily)this.alternateFamilyNames.get(string);
        if (fontFamily2 != null) {
            return fontFamily2;
        }
        return (FontFamily)this.fullFontNames.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromCache(String string) {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        File file = this.createStorageLocation();
        if (file == null) {
            return;
        }
        File file2 = new File(file, "afm-fontcache.ser");
        try {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            ResourceKey resourceKey = resourceManager.createKey((Object)file2);
            ResourceData resourceData = resourceManager.load(resourceKey);
            InputStream inputStream = resourceData.getResourceAsStream(resourceManager);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object[] objectArray = (Object[])objectInputStream.readObject();
                if (objectArray.length != 5) {
                    return;
                }
                if (!ObjectUtilities.equal((Object)string, (Object)objectArray[0])) {
                    return;
                }
                hashMap4 = (HashMap)objectArray[1];
                hashMap3 = (HashMap)objectArray[2];
                hashMap2 = (HashMap)objectArray[3];
                hashMap = (HashMap)objectArray[4];
            }
            finally {
                inputStream.close();
            }
            if (this.isCacheValid(hashMap4)) {
                this.getSeenFiles().putAll(hashMap4);
                this.fontFamilies.putAll(hashMap3);
                this.fullFontNames.putAll(hashMap2);
                this.alternateFamilyNames.putAll(hashMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug((Object)"Failed to restore the cache: Cache was created by a different version of LibFonts");
        }
        catch (Exception exception) {
            logger.debug((Object)"Failed to restore the cache:", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeToCache(String string) {
        File file = this.createStorageLocation();
        if (file == null) {
            return;
        }
        file.mkdirs();
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File file2 = new File(file, "afm-fontcache.ser");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                Object[] objectArray = new Object[]{string, this.getSeenFiles(), this.fontFamilies, this.fullFontNames, this.alternateFamilyNames};
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                objectOutputStream.writeObject(objectArray);
                objectOutputStream.close();
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.debug((Object)"Failed to store cached font data", (Throwable)iOException);
                }
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)"Failed to store cached font data", (Throwable)iOException);
        }
    }

    private static class FontPathFilter
    implements FileFilter {
        protected FontPathFilter() {
        }

        public boolean accept(File file) {
            if (!file.canRead()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return StringUtils.endsWithIgnoreCase((String)string, (String)".afm");
        }
    }
}

