/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.afm.AfmParseUtilities;

public class AfmHeader {
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final String METRICS_SETS = "MetricsSets ";
    private static final String FONT_NAME = "FontName ";
    private static final String FULL_NAME = "FullName ";
    private static final String FAMILY_NAME = "FamilyName ";
    private static final String WEIGHT = "Weight ";
    private static final String FONT_BBOX = "FontBBox ";
    private static final String VERSION = "Version ";
    private static final String NOTICE = "Notice ";
    private static final String ENCODING_SCHEME = "EncodingScheme ";
    private static final String MAPPING_SCHEME = "MappingScheme ";
    private static final String ESC_CHAR = "EscChar ";
    private static final String CHARACTERSET = "CharacterSet ";
    private static final String CHARACTERS = "Characters ";
    private static final String ISBASEFONT = "IsBaseFont ";
    private static final String VVECTOR = "VVector ";
    private static final String ISFIXEDV = "IsFixedV ";
    private static final String CAPHEIGHT = "CapHeight ";
    private static final String XHEIGHT = "XHeight ";
    private static final String ASCENDER = "Ascender ";
    private static final String DESCENDER = "Descender ";
    private String fontName;
    private int metricsSets;
    private String familyName;
    private String fullName;
    private int weight;
    private double[] bbox = new double[4];
    private String version;
    private String notice;
    private String encodingScheme;
    private int mappingScheme;
    private int escChar;
    private String characterSet;
    private int characters;
    private boolean baseFont;
    private double[] vvector;
    private boolean fixedV;
    private double capHeight;
    private double xHeight;
    private double ascender;
    private double descender;

    public void addData(String string) throws IOException {
        if (string.startsWith(METRICS_SETS)) {
            this.metricsSets = AfmParseUtilities.parseInt(METRICS_SETS, string);
        } else if (string.startsWith(FONT_NAME)) {
            this.fontName = string.substring(FONT_NAME.length());
        } else if (string.startsWith(FULL_NAME)) {
            this.fullName = string.substring(FULL_NAME.length());
        } else if (string.startsWith(FAMILY_NAME)) {
            this.familyName = string.substring(FAMILY_NAME.length());
        } else if (string.startsWith(WEIGHT)) {
            String string2 = string.substring(WEIGHT.length());
            this.weight = "bold".equalsIgnoreCase(string2) ? 700 : ("light".equalsIgnoreCase(string2) ? 200 : 400);
        } else if (string.startsWith(FONT_BBOX)) {
            this.bbox = AfmParseUtilities.parseDoubleArray(string, 4);
        } else if (string.startsWith(VERSION)) {
            this.version = string.substring(VERSION.length());
        } else if (string.startsWith(NOTICE)) {
            this.notice = string.substring(NOTICE.length());
        } else if (string.startsWith(ENCODING_SCHEME)) {
            this.encodingScheme = string.substring(ENCODING_SCHEME.length());
        } else if (string.startsWith(MAPPING_SCHEME)) {
            this.mappingScheme = AfmParseUtilities.parseInt(MAPPING_SCHEME, string);
        } else if (string.startsWith(ESC_CHAR)) {
            this.escChar = AfmParseUtilities.parseInt(ESC_CHAR, string);
        } else if (string.startsWith(CHARACTERSET)) {
            this.characterSet = string.substring(CHARACTERSET.length());
        } else if (string.startsWith(CHARACTERS)) {
            this.characters = AfmParseUtilities.parseInt(CHARACTERS, string);
        } else if (string.startsWith(ISBASEFONT)) {
            String string3 = string.substring(ISBASEFONT.length());
            this.baseFont = "true".equalsIgnoreCase(string3);
        } else if (string.startsWith(VVECTOR)) {
            this.vvector = AfmParseUtilities.parseDoubleArray(string, 2);
        } else if (string.startsWith(ISFIXEDV)) {
            String string4 = string.substring(ISFIXEDV.length());
            this.fixedV = "true".equalsIgnoreCase(string4);
        } else if (string.startsWith(CAPHEIGHT)) {
            this.capHeight = AfmParseUtilities.parseDouble(CAPHEIGHT, string);
        } else if (string.startsWith(XHEIGHT)) {
            this.xHeight = AfmParseUtilities.parseDouble(XHEIGHT, string);
        } else if (string.startsWith(ASCENDER)) {
            this.ascender = AfmParseUtilities.parseDouble(ASCENDER, string);
        } else if (string.startsWith(DESCENDER)) {
            this.descender = AfmParseUtilities.parseDouble(DESCENDER, string);
        }
    }

    public double getDescender() {
        return this.descender;
    }

    public double getAscender() {
        return this.ascender;
    }

    public double getxHeight() {
        return this.xHeight;
    }

    public double getCapHeight() {
        return this.capHeight;
    }

    public boolean isFixedV() {
        return this.fixedV;
    }

    public double[] getVvector() {
        if (this.vvector == null) {
            return EMPTY_DOUBLES;
        }
        return (double[])this.vvector.clone();
    }

    public boolean isBaseFont() {
        return this.baseFont;
    }

    public int getCharacters() {
        return this.characters;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public int getEscChar() {
        return this.escChar;
    }

    public int getMappingScheme() {
        return this.mappingScheme;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getVersion() {
        return this.version;
    }

    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    public int getWeight() {
        return this.weight;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getMetricsSets() {
        return this.metricsSets;
    }

    public String getFontName() {
        return this.fontName;
    }
}

