/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointUtilities;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;

public class AWTFontMetrics
implements FontMetrics {
    private static final Graphics2D[] graphics = new Graphics2D[4];
    private Font font;
    private long maxCharAdvance;
    private char[] cpBuffer;
    private FontRenderContext frc;
    private long xheight;
    private long ascent;
    private long descent;
    private long[] cachedWidths;
    private BaselineInfo[] cachedBaselines;
    private long leading;
    private long maxAscent;
    private long maxDescent;
    private boolean uniformLineMetrics;

    private static Graphics2D produce(boolean bl, boolean bl2) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (bl2) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return graphics2D;
    }

    public AWTFontMetrics(Font font, FontContext fontContext) {
        this.font = font;
        this.frc = new FontRenderContext(null, fontContext.isAntiAliased(), fontContext.isFractionalMetrics());
        Graphics2D graphics2D = this.createGraphics(fontContext);
        java.awt.FontMetrics fontMetrics = graphics2D.getFontMetrics(font.deriveFont(font.getSize2D() * 1000.0f));
        this.leading = fontMetrics.getLeading();
        this.maxAscent = fontMetrics.getMaxAscent();
        this.maxDescent = fontMetrics.getMaxDescent();
        this.uniformLineMetrics = fontMetrics.hasUniformLineMetrics();
        Rectangle2D rectangle2D = this.font.getMaxCharBounds(this.frc);
        this.maxCharAdvance = StrictGeomUtility.toInternalValue(rectangle2D.getWidth());
        this.ascent = StrictGeomUtility.toInternalValue(-rectangle2D.getY());
        this.descent = StrictGeomUtility.toInternalValue(rectangle2D.getHeight() + rectangle2D.getY());
        GlyphVector glyphVector = font.createGlyphVector(this.frc, "x");
        Rectangle2D rectangle2D2 = glyphVector.getVisualBounds();
        this.xheight = StrictGeomUtility.toInternalValue(rectangle2D2.getHeight());
        this.cpBuffer = new char[4];
        this.cachedBaselines = new BaselineInfo[224];
        this.cachedWidths = new long[224];
        Arrays.fill(this.cachedWidths, -1L);
    }

    protected Graphics2D createGraphics(FontContext fontContext) {
        int n = 0;
        if (fontContext.isAntiAliased()) {
            ++n;
        }
        if (fontContext.isFractionalMetrics()) {
            n += 2;
        }
        return graphics[n];
    }

    public Font getFont() {
        return this.font;
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getDescent() {
        return this.descent;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getXHeight() {
        return this.xheight;
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.getMaxHeight() / 20L);
    }

    public long getUnderlinePosition() {
        return this.getLeading() + this.getMaxAscent() + Math.max(1000L, this.getMaxHeight() / 20L);
    }

    public long getStrikeThroughPosition() {
        return this.getMaxAscent() - (long)(0.5 * (double)this.getXHeight());
    }

    public long getMaxAscent() {
        return this.maxAscent;
    }

    public long getMaxDescent() {
        return this.maxDescent;
    }

    public long getMaxHeight() {
        return this.getMaxAscent() + this.getMaxDescent() + this.getLeading();
    }

    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }

    public long getCharWidth(int n) {
        if (n >= 32 && n < 256) {
            int n2 = n - 32;
            long l = this.cachedWidths[n2];
            if (l >= 0L) {
                return l;
            }
            int n3 = CodePointUtilities.toChars(n, this.cpBuffer, 0);
            if (n3 > 0) {
                long l2;
                Rectangle2D rectangle2D = this.font.getStringBounds(this.cpBuffer, 0, n3, this.frc);
                this.cachedWidths[n2] = l2 = StrictGeomUtility.toInternalValue(rectangle2D.getWidth());
                return l2;
            }
            this.cachedWidths[n2] = 0L;
            return 0L;
        }
        int n4 = CodePointUtilities.toChars(n, this.cpBuffer, 0);
        if (n4 > 0) {
            Rectangle2D rectangle2D = this.font.getStringBounds(this.cpBuffer, 0, n4, this.frc);
            return StrictGeomUtility.toInternalValue(rectangle2D.getWidth());
        }
        return 0L;
    }

    public long getKerning(int n, int n2) {
        int n3 = CodePointUtilities.toChars(n, this.cpBuffer, 0);
        if (n3 <= 0) {
            return 0L;
        }
        int n4 = CodePointUtilities.toChars(n2, this.cpBuffer, n3);
        if (n4 > 0) {
            int n5 = n3 + n4;
            GlyphVector glyphVector = this.font.createGlyphVector(this.frc, new String(this.cpBuffer, 0, n5));
            long l = StrictGeomUtility.toInternalValue(glyphVector.getGlyphPosition(n5).getX());
            long l2 = StrictGeomUtility.toInternalValue(glyphVector.getOutline().getBounds2D().getWidth());
            return l - l2;
        }
        return 0L;
    }

    public BaselineInfo getBaselines(int n, BaselineInfo baselineInfo) {
        Object object;
        boolean bl;
        boolean bl2 = bl = n >= 32 && n < 256;
        if (bl && (object = this.cachedBaselines[n - 32]) != null) {
            if (baselineInfo == null) {
                baselineInfo = new BaselineInfo();
            }
            baselineInfo.update((BaselineInfo)object);
            return baselineInfo;
        }
        this.cpBuffer[0] = (char)(n & 0xFFFF);
        object = this.font.getLineMetrics(this.cpBuffer, 0, 1, this.frc);
        float[] fArray = ((LineMetrics)object).getBaselineOffsets();
        int n2 = ((LineMetrics)object).getBaselineIndex();
        if (baselineInfo == null) {
            baselineInfo = new BaselineInfo();
        }
        long l = this.getMaxAscent();
        long l2 = StrictGeomUtility.toInternalValue(((LineMetrics)object).getAscent());
        long l3 = l - l2;
        baselineInfo.setBaseline(1, l3 + l - this.getXHeight());
        baselineInfo.setBaseline(5, this.getMaxHeight());
        baselineInfo.setBaseline(3, l / 2L);
        long l4 = l3 + l2;
        switch (n2) {
            case 1: {
                baselineInfo.setBaseline(2, l4);
                baselineInfo.setBaseline(4, l4 + StrictGeomUtility.toInternalValue(fArray[0]));
                baselineInfo.setBaseline(0, l4 + StrictGeomUtility.toInternalValue(fArray[2]));
                baselineInfo.setDominantBaseline(2);
                break;
            }
            case 2: {
                baselineInfo.setBaseline(2, l4 + StrictGeomUtility.toInternalValue(fArray[1]));
                baselineInfo.setBaseline(4, l4 + StrictGeomUtility.toInternalValue(fArray[0]));
                baselineInfo.setBaseline(0, l4);
                baselineInfo.setDominantBaseline(0);
                break;
            }
            default: {
                baselineInfo.setBaseline(4, l4);
                baselineInfo.setBaseline(2, l4 + StrictGeomUtility.toInternalValue(fArray[1]));
                baselineInfo.setBaseline(0, l4 + StrictGeomUtility.toInternalValue(fArray[2]));
                baselineInfo.setDominantBaseline(4);
            }
        }
        if (bl) {
            BaselineInfo baselineInfo2 = new BaselineInfo();
            baselineInfo2.update(baselineInfo);
            this.cachedBaselines[n - 32] = baselineInfo2;
        }
        return baselineInfo;
    }

    public boolean isUniformFontMetrics() {
        return this.uniformLineMetrics;
    }

    public long getItalicAngle() {
        return 0L;
    }

    static {
        AWTFontMetrics.graphics[0] = AWTFontMetrics.produce(false, false);
        AWTFontMetrics.graphics[1] = AWTFontMetrics.produce(true, false);
        AWTFontMetrics.graphics[2] = AWTFontMetrics.produce(false, true);
        AWTFontMetrics.graphics[3] = AWTFontMetrics.produce(true, true);
    }
}

