/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class MonospaceFontRecord
implements FontRecord,
FontIdentifier {
    private MonospaceFontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public MonospaceFontRecord(MonospaceFontFamily monospaceFontFamily, boolean bl, boolean bl2) {
        if (monospaceFontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = monospaceFontFamily;
        this.bold = bl;
        this.italics = bl2;
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return false;
    }

    public boolean isOblique() {
        return this.italics;
    }

    public boolean isScalable() {
        return false;
    }

    public FontType getFontType() {
        return FontType.MONOSPACE;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MonospaceFontRecord monospaceFontRecord = (MonospaceFontRecord)object;
        if (this.bold != monospaceFontRecord.bold) {
            return false;
        }
        if (this.italics != monospaceFontRecord.italics) {
            return false;
        }
        return this.fontFamily.equals(monospaceFontRecord.fontFamily);
    }

    public int hashCode() {
        int n = this.fontFamily.hashCode();
        n = 29 * n + (this.bold ? 1 : 0);
        n = 29 * n + (this.italics ? 1 : 0);
        return n;
    }
}

