/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingUtility;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.fonts.pfm.PfmExtension;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontHeader;

public class PfmFont {
    private String filename;
    private FontDataInputSource input;
    private transient byte[] readBuffer;
    private PfmFontHeader header;
    private PfmExtension extension;
    private String fontName;
    private String familyName;
    private boolean embeddable;

    public PfmFont(File file, boolean bl) throws IOException {
        this(new FileFontDataInputSource(file), bl);
    }

    public PfmFont(FontDataInputSource fontDataInputSource, boolean bl) throws IOException {
        this.embeddable = bl;
        this.input = fontDataInputSource;
        this.filename = fontDataInputSource.getFileName();
        this.header = new PfmFontHeader(this.readFully(0L, 117));
        this.extension = new PfmExtension(this.readFully(117L, 30));
        int n = this.header.getFacePtr();
        if (n == 0) {
            throw new IOException("This font is not valid, it does not define a font-name");
        }
        byte[] byArray = this.readZString(n);
        this.familyName = EncodingUtility.encode(byArray, this.header.getEncoding());
        int n2 = this.extension.getDriverInfo();
        if (n2 > 0) {
            byte[] byArray2 = this.readZString(n2);
            this.fontName = EncodingUtility.encode(byArray2, "ASCII");
        } else {
            this.fontName = this.familyName;
        }
    }

    public boolean isItextCompatible() {
        int n = this.extension.getDriverInfo();
        if (n < 75 || n > 512) {
            this.embeddable = false;
            return false;
        }
        return true;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public PfmFontHeader getHeader() {
        return this.header;
    }

    public String getFilename() {
        return this.filename;
    }

    public FontDataInputSource getInput() {
        return this.input;
    }

    public void dispose() {
        this.input.dispose();
    }

    protected byte[] readFully(long l, int n) throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[Math.max(8192, n)];
        } else if (this.readBuffer.length < n) {
            this.readBuffer = new byte[n];
        }
        this.input.readFullyAt(l, this.readBuffer, n);
        if (this.readBuffer.length - n > 0) {
            Arrays.fill(this.readBuffer, n, this.readBuffer.length, (byte)0);
        }
        return this.readBuffer;
    }

    protected byte[] readZString(long l) throws IOException {
        int n;
        long l2 = l;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.input.readAt(l2)) > 0) {
            byteArrayOutputStream.write(n);
            ++l2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }
}

