/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontFileRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public abstract class AbstractFontFileRegistry
implements FontRegistry {
    private static Log logger = LogFactory.getLog(AbstractFontFileRegistry.class);
    private HashMap seenFiles = new HashMap();

    protected AbstractFontFileRegistry() {
    }

    protected HashMap getSeenFiles() {
        return this.seenFiles;
    }

    protected abstract FileFilter getFileFilter();

    public void initialize() {
        this.registerDefaultFontPath();
    }

    protected String getDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.fonts.itext.FontEncoding", EncodingRegistry.getPlatformDefaultEncoding());
    }

    public void registerDefaultFontPath() {
        String string = this.getDefaultEncoding();
        this.loadFromCache(string);
        String string2 = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String string3 = this.safeSystemGetProperty("java.home", ".");
        String string4 = this.safeSystemGetProperty("file.separator", File.separator);
        logger.debug((Object)("Running on operating system: " + string2));
        logger.debug((Object)("Character encoding used as default: " + string));
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String string5 = this.safeSystemGetProperty("user.home", ".");
            logger.debug((Object)"Detected MacOS (Property 'mrj.version' is present.");
            this.registerFontPath(new File(string5 + "/Library/Fonts"), string);
            this.registerFontPath(new File("/Library/Fonts"), string);
            this.registerFontPath(new File("/Network/Library/Fonts"), string);
            this.registerFontPath(new File("/System/Library/Fonts"), string);
        } else if (StringUtils.startsWithIgnoreCase((String)string2, (String)"windows")) {
            this.registerWindowsFontPath(string);
        } else {
            logger.debug((Object)"Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), string);
            this.registerFontPath(new File("/usr/share/fonts"), string);
        }
        this.registerFontPath(new File(string3, "lib" + string4 + "fonts"), string);
        this.storeToCache(string);
        logger.info((Object)"Completed font registration.");
    }

    protected void storeToCache(String string) {
    }

    protected void loadFromCache(String string) {
    }

    private void registerWindowsFontPath(String string) {
        Object object;
        logger.debug((Object)"Found 'Windows' in the OS name, assuming DOS/Win32 structures");
        String string2 = null;
        String string3 = this.safeSystemGetProperty("java.library.path", null);
        String string4 = this.safeSystemGetProperty("file.separator", File.separator);
        if (string3 != null) {
            object = new StringTokenizer(string3, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string5 = ((StringTokenizer)object).nextToken();
                if (!StringUtils.endsWithIgnoreCase((String)string5, (String)"System32")) continue;
                int n = string5.lastIndexOf(string4);
                if (n != -1) {
                    string2 = string5.substring(0, n) + string4 + "Fonts";
                    break;
                }
                int n2 = string5.lastIndexOf(47);
                if (n2 == -1) continue;
                string2 = string5.substring(0, n2) + n2 + "Fonts";
                break;
            }
        }
        logger.debug((Object)("Fonts located in \"" + string2 + '\"'));
        if (string2 != null) {
            object = new File(string2);
            this.registerFontPath((File)object, string);
        }
    }

    public void registerFontPath(File file, String string) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            for (File file2 : file.listFiles(this.getFileFilter())) {
                if (file2.isDirectory()) {
                    this.registerFontPath(file2, string);
                    continue;
                }
                if (this.isCached(file2)) continue;
                this.registerFontFile(file2, string);
            }
        }
    }

    protected boolean isCached(File file) {
        try {
            FontFileRecord fontFileRecord = (FontFileRecord)this.seenFiles.get(file.getCanonicalPath());
            if (fontFileRecord == null) {
                return false;
            }
            FontFileRecord fontFileRecord2 = new FontFileRecord(file);
            if (!fontFileRecord.equals(fontFileRecord2)) {
                this.seenFiles.remove(fontFileRecord2);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void registerFontFile(String string, String string2) {
        File file = new File(string);
        this.registerFontFile(file, string2);
    }

    public synchronized void registerFontFile(File file, String string) {
        if (this.getFileFilter().accept(file) && file.exists() && file.isFile() && file.canRead()) {
            try {
                if (this.addFont(file, string)) {
                    FontFileRecord fontFileRecord = new FontFileRecord(file);
                    this.seenFiles.put(file.getCanonicalPath(), fontFileRecord);
                }
            }
            catch (Exception exception) {
                logger.warn((Object)("Font " + file + " is invalid. Message:" + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    protected abstract boolean addFont(File var1, String var2) throws IOException;

    protected String safeSystemGetProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    protected boolean isCacheValid(HashMap hashMap) {
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            FontFileRecord fontFileRecord = (FontFileRecord)entry.getValue();
            File file = new File(string);
            if (!file.isFile() || !file.exists()) {
                return false;
            }
            if (file.length() != fontFileRecord.getFileSize()) {
                return false;
            }
            if (file.lastModified() == fontFileRecord.getLastAccessTime()) continue;
            return false;
        }
        return true;
    }

    protected File createStorageLocation() {
        String string = this.safeSystemGetProperty("user.home", null);
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        return new File(file, ".pentaho/caches/libfonts");
    }
}

