/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text;

public class Spacing {
    public static final Spacing EMPTY_SPACING = new Spacing(0, 0, 0);
    private int minimum;
    private int maximum;
    private int optimum;

    public Spacing(int n, int n2, int n3) {
        if (n > n3) {
            this.minimum = n;
            this.maximum = n;
            this.optimum = n;
        } else {
            this.minimum = n;
            this.maximum = n3;
            this.optimum = n2 < this.minimum ? this.minimum : (n2 > this.maximum ? this.maximum : n2);
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getOptimum() {
        return this.optimum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Spacing spacing = (Spacing)object;
        if (this.maximum != spacing.maximum) {
            return false;
        }
        if (this.minimum != spacing.minimum) {
            return false;
        }
        return this.optimum == spacing.optimum;
    }

    public int hashCode() {
        int n = this.minimum;
        n = 29 * n + this.maximum;
        n = 29 * n + this.optimum;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("={minimum=");
        stringBuffer.append(this.minimum);
        stringBuffer.append(", optimum=");
        stringBuffer.append(this.optimum);
        stringBuffer.append(", maximum=");
        stringBuffer.append(this.maximum);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

