/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.HorizontalHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.PostscriptInformationTable;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;

public class ScalableTrueTypeFontMetrics {
    private TrueTypeFont font;
    private long ascent;
    private long descent;
    private long leading;
    private long xHeight;
    private long strikethroughPosition;
    private long maxAscent;
    private long maxDescent;
    private long underlinePosition;
    private long italicAngle;
    private long maxCharAdvance;

    public ScalableTrueTypeFontMetrics(TrueTypeFont trueTypeFont) throws IOException {
        PostscriptInformationTable postscriptInformationTable;
        if (trueTypeFont == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.font = trueTypeFont;
        FontHeaderTable fontHeaderTable = (FontHeaderTable)trueTypeFont.getTable(1751474532L);
        int n = fontHeaderTable.getUnitsPerEm();
        long l = StrictGeomUtility.toInternalValue(1.0);
        this.maxAscent = l * (long)fontHeaderTable.getyMax() / (long)n;
        this.maxDescent = l * (long)(-fontHeaderTable.getyMin()) / (long)n;
        HorizontalHeaderTable horizontalHeaderTable = (HorizontalHeaderTable)trueTypeFont.getTable(1751672161L);
        if (horizontalHeaderTable == null) {
            throw new IllegalStateException("The font has no HHEA table and is not a valid font.");
        }
        this.createMacMetrics(horizontalHeaderTable, n, l);
        OS2Table oS2Table = (OS2Table)trueTypeFont.getTable(1330851634L);
        if (oS2Table != null) {
            this.computeWindowsMetrics(oS2Table, n, l);
        }
        if ((postscriptInformationTable = (PostscriptInformationTable)trueTypeFont.getTable(1886352244L)) != null) {
            this.italicAngle = StrictGeomUtility.toInternalValue(postscriptInformationTable.getItalicAngle());
            this.underlinePosition = this.getAscent() + l * (long)(-postscriptInformationTable.getUnderlinePosition() + postscriptInformationTable.getUnderlineThickness() / 2) / (long)n;
        }
        trueTypeFont.dispose();
    }

    private void createMacMetrics(HorizontalHeaderTable horizontalHeaderTable, int n, long l) {
        this.maxCharAdvance = l * (long)horizontalHeaderTable.getMaxAdvanceWidth() / (long)n;
        this.ascent = l * (long)horizontalHeaderTable.getAscender() / (long)n;
        this.descent = l * (long)(-horizontalHeaderTable.getDescender()) / (long)n;
        this.leading = l * (long)horizontalHeaderTable.getLineGap() / (long)n;
        this.xHeight = (long)((double)this.ascent * 0.5 / 0.7);
        this.strikethroughPosition = this.getMaxAscent() - (long)((double)this.xHeight * 0.5);
        this.italicAngle = StrictGeomUtility.toInternalValue(-StrictMath.atan2(horizontalHeaderTable.getCaretSlopeRun(), horizontalHeaderTable.getCaretSlopeRise()) * 180.0 / Math.PI);
    }

    private void computeWindowsMetrics(OS2Table oS2Table, int n, long l) {
        short s;
        short s2 = oS2Table.getxHeight();
        if (s2 != 0) {
            this.xHeight = l * (long)s2 / (long)n;
        }
        if ((s = oS2Table.getyStrikeoutPosition()) != 0) {
            this.strikethroughPosition = this.getMaxAscent() - l * (long)s / (long)n;
        }
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getDescent() {
        return this.descent;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getXHeight() {
        return this.xHeight;
    }

    public long getUnderlinePosition() {
        return this.underlinePosition;
    }

    public long getStrikeThroughPosition() {
        return this.strikethroughPosition;
    }

    public TrueTypeFont getFont() {
        return this.font;
    }

    public long getItalicAngle() {
        return this.italicAngle;
    }

    public long getMaxAscent() {
        return this.maxAscent;
    }

    public long getMaxDescent() {
        return this.maxDescent;
    }

    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }
}

