/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontType;
import org.pentaho.reporting.libraries.fonts.truetype.ScalableTrueTypeFontMetrics;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetrics;

public class TrueTypeFontMetricsFactory
implements FontMetricsFactory {
    private static Log logger = LogFactory.getLog(TrueTypeFontMetricsFactory.class);
    private HashMap fontRecords = new HashMap();

    public FontMetrics createMetrics(FontIdentifier fontIdentifier, FontContext fontContext) {
        if (!FontType.OPENTYPE.equals(fontIdentifier.getFontType())) {
            throw new IllegalArgumentException("This identifier does not belong to the OpenType-font system.");
        }
        TrueTypeFontIdentifier trueTypeFontIdentifier = (TrueTypeFontIdentifier)fontIdentifier;
        ScalableTrueTypeFontMetrics scalableTrueTypeFontMetrics = (ScalableTrueTypeFontMetrics)this.fontRecords.get(trueTypeFontIdentifier);
        if (scalableTrueTypeFontMetrics != null) {
            return new TrueTypeFontMetrics(scalableTrueTypeFontMetrics, fontContext.getFontSize());
        }
        try {
            String string = trueTypeFontIdentifier.getFontSource();
            FileFontDataInputSource fileFontDataInputSource = new FileFontDataInputSource(new File(string));
            TrueTypeFont trueTypeFont = new TrueTypeFont(fileFontDataInputSource);
            ScalableTrueTypeFontMetrics scalableTrueTypeFontMetrics2 = new ScalableTrueTypeFontMetrics(trueTypeFont);
            this.fontRecords.put(trueTypeFontIdentifier, scalableTrueTypeFontMetrics2);
            return new TrueTypeFontMetrics(scalableTrueTypeFontMetrics2, fontContext.getFontSize());
        }
        catch (IOException iOException) {
            logger.warn((Object)"Unable to read the font.", (Throwable)iOException);
            throw new IllegalStateException();
        }
    }
}

