/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.layoutprocessor;

import com.sun.star.report.pentaho.model.FormattedTextElement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;

public class FormatValueUtility {
    private static final String BOOLEAN_VALUE = "boolean-value";
    private static final String STRING_VALUE = "string-value";
    public static final String VALUE_TYPE = "value-type";
    public static final String VALUE = "value";
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat timeFormat;

    private FormatValueUtility() {
    }

    public static String applyValueForVariable(Object object, AttributeMap attributeMap) {
        String string = null;
        if (object instanceof Time) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"time");
            string = FormatValueUtility.formatTime((Time)object);
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)string);
        } else if (object instanceof java.sql.Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            string = FormatValueUtility.formatDate((Date)object);
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)string);
        } else if (object instanceof Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            string = HSSFDateUtil.getExcelDate((Date)((Date)object), (boolean)false, (int)2).toString();
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)string);
        } else if (object instanceof Number) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
        } else if (object instanceof Boolean) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"boolean");
            if (Boolean.TRUE.equals(object)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
            } else {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
        } else if (object != null) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)String.valueOf(object));
        } else {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)"");
        }
        return string;
    }

    public static void applyValueForCell(Object object, AttributeMap attributeMap, String string) {
        if (object instanceof Time) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)FormatValueUtility.formatTime((Time)object));
        } else if (object instanceof java.sql.Date) {
            if ("float".equals(string)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)HSSFDateUtil.getExcelDate((Date)((Date)object), (boolean)false, (int)2).toString());
            } else {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)FormatValueUtility.formatDate((Date)object));
            }
        } else if (object instanceof Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)HSSFDateUtil.getExcelDate((Date)((Date)object), (boolean)false, (int)2).toString());
        } else if (object instanceof Number) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
        } else if (object instanceof Boolean) {
            if (Boolean.TRUE.equals(object)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
            } else {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
        } else if (object != null) {
            try {
                Float f = Float.valueOf(String.valueOf(object));
                FormatValueUtility.applyValueForCell(f, attributeMap, string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                if (!"string".equals(string)) {
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
                }
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)String.valueOf(object));
            }
        } else {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)"");
        }
    }

    private static synchronized String formatDate(Date date) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'");
        }
        return dateFormat.format(date);
    }

    private static synchronized String formatTime(Date date) {
        if (timeFormat == null) {
            timeFormat = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
        }
        return timeFormat.format(date);
    }

    public static DataFlags computeDataFlag(FormattedTextElement formattedTextElement, FlowController flowController) throws DataSourceException {
        FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
        Object object = LayoutControllerUtil.evaluateExpression((FlowController)flowController, (Object)((Object)formattedTextElement), (Expression)formulaExpression);
        if (object == null) {
            return null;
        }
        if (object instanceof DataFlags) {
            return (DataFlags)object;
        }
        return new DefaultDataFlags(null, object, true);
    }
}

