//===- TableGen'erated file -------------------------------------*- C++ -*-===//
//
// ARM NEON Header
//
// Automatically generated file, do not edit!
//
//===----------------------------------------------------------------------===//

#ifndef __ARM_NEON_H
#define __ARM_NEON_H

#ifndef __ARM_NEON__
#error "NEON support not enabled"
#endif

#include <stdint.h>

typedef float float32_t;
typedef uint8_t poly8_t;
typedef uint16_t poly16_t;
typedef uint16_t float16_t;
typedef __attribute__(( __vector_size__(8) ))  int8_t __neon_int8x8_t;
typedef __attribute__(( __vector_size__(16) )) int8_t __neon_int8x16_t;
typedef __attribute__(( __vector_size__(8) ))  int16_t __neon_int16x4_t;
typedef __attribute__(( __vector_size__(16) )) int16_t __neon_int16x8_t;
typedef __attribute__(( __vector_size__(8) ))  int32_t __neon_int32x2_t;
typedef __attribute__(( __vector_size__(16) )) int32_t __neon_int32x4_t;
typedef __attribute__(( __vector_size__(8) ))  int64_t __neon_int64x1_t;
typedef __attribute__(( __vector_size__(16) )) int64_t __neon_int64x2_t;
typedef __attribute__(( __vector_size__(8) ))  uint8_t __neon_uint8x8_t;
typedef __attribute__(( __vector_size__(16) )) uint8_t __neon_uint8x16_t;
typedef __attribute__(( __vector_size__(8) ))  uint16_t __neon_uint16x4_t;
typedef __attribute__(( __vector_size__(16) )) uint16_t __neon_uint16x8_t;
typedef __attribute__(( __vector_size__(8) ))  uint32_t __neon_uint32x2_t;
typedef __attribute__(( __vector_size__(16) )) uint32_t __neon_uint32x4_t;
typedef __attribute__(( __vector_size__(8) ))  uint64_t __neon_uint64x1_t;
typedef __attribute__(( __vector_size__(16) )) uint64_t __neon_uint64x2_t;
typedef __attribute__(( __vector_size__(8) ))  float16_t __neon_float16x4_t;
typedef __attribute__(( __vector_size__(16) )) float16_t __neon_float16x8_t;
typedef __attribute__(( __vector_size__(8) ))  float32_t __neon_float32x2_t;
typedef __attribute__(( __vector_size__(16) )) float32_t __neon_float32x4_t;
typedef __attribute__(( __vector_size__(8) ))  poly8_t __neon_poly8x8_t;
typedef __attribute__(( __vector_size__(16) )) poly8_t __neon_poly8x16_t;
typedef __attribute__(( __vector_size__(8) ))  poly16_t __neon_poly16x4_t;
typedef __attribute__(( __vector_size__(16) )) poly16_t __neon_poly16x8_t;
typedef __attribute__(( __vector_size__(16) ))  int8_t __neon_int8x8x2_t;
typedef __attribute__(( __vector_size__(32) )) int8_t __neon_int8x16x2_t;
typedef __attribute__(( __vector_size__(16) ))  int16_t __neon_int16x4x2_t;
typedef __attribute__(( __vector_size__(32) )) int16_t __neon_int16x8x2_t;
typedef __attribute__(( __vector_size__(16) ))  int32_t __neon_int32x2x2_t;
typedef __attribute__(( __vector_size__(32) )) int32_t __neon_int32x4x2_t;
typedef __attribute__(( __vector_size__(16) ))  int64_t __neon_int64x1x2_t;
typedef __attribute__(( __vector_size__(32) )) int64_t __neon_int64x2x2_t;
typedef __attribute__(( __vector_size__(16) ))  uint8_t __neon_uint8x8x2_t;
typedef __attribute__(( __vector_size__(32) )) uint8_t __neon_uint8x16x2_t;
typedef __attribute__(( __vector_size__(16) ))  uint16_t __neon_uint16x4x2_t;
typedef __attribute__(( __vector_size__(32) )) uint16_t __neon_uint16x8x2_t;
typedef __attribute__(( __vector_size__(16) ))  uint32_t __neon_uint32x2x2_t;
typedef __attribute__(( __vector_size__(32) )) uint32_t __neon_uint32x4x2_t;
typedef __attribute__(( __vector_size__(16) ))  uint64_t __neon_uint64x1x2_t;
typedef __attribute__(( __vector_size__(32) )) uint64_t __neon_uint64x2x2_t;
typedef __attribute__(( __vector_size__(16) ))  float16_t __neon_float16x4x2_t;
typedef __attribute__(( __vector_size__(32) )) float16_t __neon_float16x8x2_t;
typedef __attribute__(( __vector_size__(16) ))  float32_t __neon_float32x2x2_t;
typedef __attribute__(( __vector_size__(32) )) float32_t __neon_float32x4x2_t;
typedef __attribute__(( __vector_size__(16) ))  poly8_t __neon_poly8x8x2_t;
typedef __attribute__(( __vector_size__(32) )) poly8_t __neon_poly8x16x2_t;
typedef __attribute__(( __vector_size__(16) ))  poly16_t __neon_poly16x4x2_t;
typedef __attribute__(( __vector_size__(32) )) poly16_t __neon_poly16x8x2_t;
typedef __attribute__(( __vector_size__(24) ))  int8_t __neon_int8x8x3_t;
typedef __attribute__(( __vector_size__(48) )) int8_t __neon_int8x16x3_t;
typedef __attribute__(( __vector_size__(24) ))  int16_t __neon_int16x4x3_t;
typedef __attribute__(( __vector_size__(48) )) int16_t __neon_int16x8x3_t;
typedef __attribute__(( __vector_size__(24) ))  int32_t __neon_int32x2x3_t;
typedef __attribute__(( __vector_size__(48) )) int32_t __neon_int32x4x3_t;
typedef __attribute__(( __vector_size__(24) ))  int64_t __neon_int64x1x3_t;
typedef __attribute__(( __vector_size__(48) )) int64_t __neon_int64x2x3_t;
typedef __attribute__(( __vector_size__(24) ))  uint8_t __neon_uint8x8x3_t;
typedef __attribute__(( __vector_size__(48) )) uint8_t __neon_uint8x16x3_t;
typedef __attribute__(( __vector_size__(24) ))  uint16_t __neon_uint16x4x3_t;
typedef __attribute__(( __vector_size__(48) )) uint16_t __neon_uint16x8x3_t;
typedef __attribute__(( __vector_size__(24) ))  uint32_t __neon_uint32x2x3_t;
typedef __attribute__(( __vector_size__(48) )) uint32_t __neon_uint32x4x3_t;
typedef __attribute__(( __vector_size__(24) ))  uint64_t __neon_uint64x1x3_t;
typedef __attribute__(( __vector_size__(48) )) uint64_t __neon_uint64x2x3_t;
typedef __attribute__(( __vector_size__(24) ))  float16_t __neon_float16x4x3_t;
typedef __attribute__(( __vector_size__(48) )) float16_t __neon_float16x8x3_t;
typedef __attribute__(( __vector_size__(24) ))  float32_t __neon_float32x2x3_t;
typedef __attribute__(( __vector_size__(48) )) float32_t __neon_float32x4x3_t;
typedef __attribute__(( __vector_size__(24) ))  poly8_t __neon_poly8x8x3_t;
typedef __attribute__(( __vector_size__(48) )) poly8_t __neon_poly8x16x3_t;
typedef __attribute__(( __vector_size__(24) ))  poly16_t __neon_poly16x4x3_t;
typedef __attribute__(( __vector_size__(48) )) poly16_t __neon_poly16x8x3_t;
typedef __attribute__(( __vector_size__(32) ))  int8_t __neon_int8x8x4_t;
typedef __attribute__(( __vector_size__(64) )) int8_t __neon_int8x16x4_t;
typedef __attribute__(( __vector_size__(32) ))  int16_t __neon_int16x4x4_t;
typedef __attribute__(( __vector_size__(64) )) int16_t __neon_int16x8x4_t;
typedef __attribute__(( __vector_size__(32) ))  int32_t __neon_int32x2x4_t;
typedef __attribute__(( __vector_size__(64) )) int32_t __neon_int32x4x4_t;
typedef __attribute__(( __vector_size__(32) ))  int64_t __neon_int64x1x4_t;
typedef __attribute__(( __vector_size__(64) )) int64_t __neon_int64x2x4_t;
typedef __attribute__(( __vector_size__(32) ))  uint8_t __neon_uint8x8x4_t;
typedef __attribute__(( __vector_size__(64) )) uint8_t __neon_uint8x16x4_t;
typedef __attribute__(( __vector_size__(32) ))  uint16_t __neon_uint16x4x4_t;
typedef __attribute__(( __vector_size__(64) )) uint16_t __neon_uint16x8x4_t;
typedef __attribute__(( __vector_size__(32) ))  uint32_t __neon_uint32x2x4_t;
typedef __attribute__(( __vector_size__(64) )) uint32_t __neon_uint32x4x4_t;
typedef __attribute__(( __vector_size__(32) ))  uint64_t __neon_uint64x1x4_t;
typedef __attribute__(( __vector_size__(64) )) uint64_t __neon_uint64x2x4_t;
typedef __attribute__(( __vector_size__(32) ))  float16_t __neon_float16x4x4_t;
typedef __attribute__(( __vector_size__(64) )) float16_t __neon_float16x8x4_t;
typedef __attribute__(( __vector_size__(32) ))  float32_t __neon_float32x2x4_t;
typedef __attribute__(( __vector_size__(64) )) float32_t __neon_float32x4x4_t;
typedef __attribute__(( __vector_size__(32) ))  poly8_t __neon_poly8x8x4_t;
typedef __attribute__(( __vector_size__(64) )) poly8_t __neon_poly8x16x4_t;
typedef __attribute__(( __vector_size__(32) ))  poly16_t __neon_poly16x4x4_t;
typedef __attribute__(( __vector_size__(64) )) poly16_t __neon_poly16x8x4_t;

typedef struct __simd64_int8_t {
  __neon_int8x8_t val;
} int8x8_t;

typedef struct __simd128_int8_t {
  __neon_int8x16_t val;
} int8x16_t;

typedef struct __simd64_int16_t {
  __neon_int16x4_t val;
} int16x4_t;

typedef struct __simd128_int16_t {
  __neon_int16x8_t val;
} int16x8_t;

typedef struct __simd64_int32_t {
  __neon_int32x2_t val;
} int32x2_t;

typedef struct __simd128_int32_t {
  __neon_int32x4_t val;
} int32x4_t;

typedef struct __simd64_int64_t {
  __neon_int64x1_t val;
} int64x1_t;

typedef struct __simd128_int64_t {
  __neon_int64x2_t val;
} int64x2_t;

typedef struct __simd64_uint8_t {
  __neon_uint8x8_t val;
} uint8x8_t;

typedef struct __simd128_uint8_t {
  __neon_uint8x16_t val;
} uint8x16_t;

typedef struct __simd64_uint16_t {
  __neon_uint16x4_t val;
} uint16x4_t;

typedef struct __simd128_uint16_t {
  __neon_uint16x8_t val;
} uint16x8_t;

typedef struct __simd64_uint32_t {
  __neon_uint32x2_t val;
} uint32x2_t;

typedef struct __simd128_uint32_t {
  __neon_uint32x4_t val;
} uint32x4_t;

typedef struct __simd64_uint64_t {
  __neon_uint64x1_t val;
} uint64x1_t;

typedef struct __simd128_uint64_t {
  __neon_uint64x2_t val;
} uint64x2_t;

typedef struct __simd64_float16_t {
  __neon_float16x4_t val;
} float16x4_t;

typedef struct __simd128_float16_t {
  __neon_float16x8_t val;
} float16x8_t;

typedef struct __simd64_float32_t {
  __neon_float32x2_t val;
} float32x2_t;

typedef struct __simd128_float32_t {
  __neon_float32x4_t val;
} float32x4_t;

typedef struct __simd64_poly8_t {
  __neon_poly8x8_t val;
} poly8x8_t;

typedef struct __simd128_poly8_t {
  __neon_poly8x16_t val;
} poly8x16_t;

typedef struct __simd64_poly16_t {
  __neon_poly16x4_t val;
} poly16x4_t;

typedef struct __simd128_poly16_t {
  __neon_poly16x8_t val;
} poly16x8_t;

typedef struct int8x8x2_t {
  int8x8_t val[2];
} int8x8x2_t;

typedef struct int8x16x2_t {
  int8x16_t val[2];
} int8x16x2_t;

typedef struct int16x4x2_t {
  int16x4_t val[2];
} int16x4x2_t;

typedef struct int16x8x2_t {
  int16x8_t val[2];
} int16x8x2_t;

typedef struct int32x2x2_t {
  int32x2_t val[2];
} int32x2x2_t;

typedef struct int32x4x2_t {
  int32x4_t val[2];
} int32x4x2_t;

typedef struct int64x1x2_t {
  int64x1_t val[2];
} int64x1x2_t;

typedef struct int64x2x2_t {
  int64x2_t val[2];
} int64x2x2_t;

typedef struct uint8x8x2_t {
  uint8x8_t val[2];
} uint8x8x2_t;

typedef struct uint8x16x2_t {
  uint8x16_t val[2];
} uint8x16x2_t;

typedef struct uint16x4x2_t {
  uint16x4_t val[2];
} uint16x4x2_t;

typedef struct uint16x8x2_t {
  uint16x8_t val[2];
} uint16x8x2_t;

typedef struct uint32x2x2_t {
  uint32x2_t val[2];
} uint32x2x2_t;

typedef struct uint32x4x2_t {
  uint32x4_t val[2];
} uint32x4x2_t;

typedef struct uint64x1x2_t {
  uint64x1_t val[2];
} uint64x1x2_t;

typedef struct uint64x2x2_t {
  uint64x2_t val[2];
} uint64x2x2_t;

typedef struct float16x4x2_t {
  float16x4_t val[2];
} float16x4x2_t;

typedef struct float16x8x2_t {
  float16x8_t val[2];
} float16x8x2_t;

typedef struct float32x2x2_t {
  float32x2_t val[2];
} float32x2x2_t;

typedef struct float32x4x2_t {
  float32x4_t val[2];
} float32x4x2_t;

typedef struct poly8x8x2_t {
  poly8x8_t val[2];
} poly8x8x2_t;

typedef struct poly8x16x2_t {
  poly8x16_t val[2];
} poly8x16x2_t;

typedef struct poly16x4x2_t {
  poly16x4_t val[2];
} poly16x4x2_t;

typedef struct poly16x8x2_t {
  poly16x8_t val[2];
} poly16x8x2_t;

typedef struct int8x8x3_t {
  int8x8_t val[3];
} int8x8x3_t;

typedef struct int8x16x3_t {
  int8x16_t val[3];
} int8x16x3_t;

typedef struct int16x4x3_t {
  int16x4_t val[3];
} int16x4x3_t;

typedef struct int16x8x3_t {
  int16x8_t val[3];
} int16x8x3_t;

typedef struct int32x2x3_t {
  int32x2_t val[3];
} int32x2x3_t;

typedef struct int32x4x3_t {
  int32x4_t val[3];
} int32x4x3_t;

typedef struct int64x1x3_t {
  int64x1_t val[3];
} int64x1x3_t;

typedef struct int64x2x3_t {
  int64x2_t val[3];
} int64x2x3_t;

typedef struct uint8x8x3_t {
  uint8x8_t val[3];
} uint8x8x3_t;

typedef struct uint8x16x3_t {
  uint8x16_t val[3];
} uint8x16x3_t;

typedef struct uint16x4x3_t {
  uint16x4_t val[3];
} uint16x4x3_t;

typedef struct uint16x8x3_t {
  uint16x8_t val[3];
} uint16x8x3_t;

typedef struct uint32x2x3_t {
  uint32x2_t val[3];
} uint32x2x3_t;

typedef struct uint32x4x3_t {
  uint32x4_t val[3];
} uint32x4x3_t;

typedef struct uint64x1x3_t {
  uint64x1_t val[3];
} uint64x1x3_t;

typedef struct uint64x2x3_t {
  uint64x2_t val[3];
} uint64x2x3_t;

typedef struct float16x4x3_t {
  float16x4_t val[3];
} float16x4x3_t;

typedef struct float16x8x3_t {
  float16x8_t val[3];
} float16x8x3_t;

typedef struct float32x2x3_t {
  float32x2_t val[3];
} float32x2x3_t;

typedef struct float32x4x3_t {
  float32x4_t val[3];
} float32x4x3_t;

typedef struct poly8x8x3_t {
  poly8x8_t val[3];
} poly8x8x3_t;

typedef struct poly8x16x3_t {
  poly8x16_t val[3];
} poly8x16x3_t;

typedef struct poly16x4x3_t {
  poly16x4_t val[3];
} poly16x4x3_t;

typedef struct poly16x8x3_t {
  poly16x8_t val[3];
} poly16x8x3_t;

typedef struct int8x8x4_t {
  int8x8_t val[4];
} int8x8x4_t;

typedef struct int8x16x4_t {
  int8x16_t val[4];
} int8x16x4_t;

typedef struct int16x4x4_t {
  int16x4_t val[4];
} int16x4x4_t;

typedef struct int16x8x4_t {
  int16x8_t val[4];
} int16x8x4_t;

typedef struct int32x2x4_t {
  int32x2_t val[4];
} int32x2x4_t;

typedef struct int32x4x4_t {
  int32x4_t val[4];
} int32x4x4_t;

typedef struct int64x1x4_t {
  int64x1_t val[4];
} int64x1x4_t;

typedef struct int64x2x4_t {
  int64x2_t val[4];
} int64x2x4_t;

typedef struct uint8x8x4_t {
  uint8x8_t val[4];
} uint8x8x4_t;

typedef struct uint8x16x4_t {
  uint8x16_t val[4];
} uint8x16x4_t;

typedef struct uint16x4x4_t {
  uint16x4_t val[4];
} uint16x4x4_t;

typedef struct uint16x8x4_t {
  uint16x8_t val[4];
} uint16x8x4_t;

typedef struct uint32x2x4_t {
  uint32x2_t val[4];
} uint32x2x4_t;

typedef struct uint32x4x4_t {
  uint32x4_t val[4];
} uint32x4x4_t;

typedef struct uint64x1x4_t {
  uint64x1_t val[4];
} uint64x1x4_t;

typedef struct uint64x2x4_t {
  uint64x2_t val[4];
} uint64x2x4_t;

typedef struct float16x4x4_t {
  float16x4_t val[4];
} float16x4x4_t;

typedef struct float16x8x4_t {
  float16x8_t val[4];
} float16x8x4_t;

typedef struct float32x2x4_t {
  float32x2_t val[4];
} float32x2x4_t;

typedef struct float32x4x4_t {
  float32x4_t val[4];
} float32x4x4_t;

typedef struct poly8x8x4_t {
  poly8x8_t val[4];
} poly8x8x4_t;

typedef struct poly8x16x4_t {
  poly8x16_t val[4];
} poly8x16x4_t;

typedef struct poly16x4x4_t {
  poly16x4_t val[4];
} poly16x4x4_t;

typedef struct poly16x8x4_t {
  poly16x8_t val[4];
} poly16x8x4_t;

#define __ai static __attribute__((__always_inline__))

__ai int8x8_t vaba_s8(int8x8_t a, int8x8_t b, int8x8_t c) { int8x8_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 0); return r; }
__ai int16x4_t vaba_s16(int16x4_t a, int16x4_t b, int16x4_t c) { int16x4_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 1); return r; }
__ai int32x2_t vaba_s32(int32x2_t a, int32x2_t b, int32x2_t c) { int32x2_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 2); return r; }
__ai uint8x8_t vaba_u8(uint8x8_t a, uint8x8_t b, uint8x8_t c) { uint8x8_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 8); return r; }
__ai uint16x4_t vaba_u16(uint16x4_t a, uint16x4_t b, uint16x4_t c) { uint16x4_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 9); return r; }
__ai uint32x2_t vaba_u32(uint32x2_t a, uint32x2_t b, uint32x2_t c) { uint32x2_t r; r.val = __builtin_neon_vaba_v(a.val, b.val, c.val, 10); return r; }
__ai int8x16_t vabaq_s8(int8x16_t a, int8x16_t b, int8x16_t c) { int8x16_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 16); return r; }
__ai int16x8_t vabaq_s16(int16x8_t a, int16x8_t b, int16x8_t c) { int16x8_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 17); return r; }
__ai int32x4_t vabaq_s32(int32x4_t a, int32x4_t b, int32x4_t c) { int32x4_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 18); return r; }
__ai uint8x16_t vabaq_u8(uint8x16_t a, uint8x16_t b, uint8x16_t c) { uint8x16_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 24); return r; }
__ai uint16x8_t vabaq_u16(uint16x8_t a, uint16x8_t b, uint16x8_t c) { uint16x8_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 25); return r; }
__ai uint32x4_t vabaq_u32(uint32x4_t a, uint32x4_t b, uint32x4_t c) { uint32x4_t r; r.val = __builtin_neon_vabaq_v(a.val, b.val, c.val, 26); return r; }

__ai int16x8_t vabal_s8(int16x8_t a, int8x8_t b, int8x8_t c) { int16x8_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 17); return r; }
__ai int32x4_t vabal_s16(int32x4_t a, int16x4_t b, int16x4_t c) { int32x4_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 18); return r; }
__ai int64x2_t vabal_s32(int64x2_t a, int32x2_t b, int32x2_t c) { int64x2_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 19); return r; }
__ai uint16x8_t vabal_u8(uint16x8_t a, uint8x8_t b, uint8x8_t c) { uint16x8_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 25); return r; }
__ai uint32x4_t vabal_u16(uint32x4_t a, uint16x4_t b, uint16x4_t c) { uint32x4_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 26); return r; }
__ai uint64x2_t vabal_u32(uint64x2_t a, uint32x2_t b, uint32x2_t c) { uint64x2_t r; r.val = __builtin_neon_vabal_v(a.val, b.val, c.val, 27); return r; }

__ai int8x8_t vabd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 0); return r; }
__ai int16x4_t vabd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 1); return r; }
__ai int32x2_t vabd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vabd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vabd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vabd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 10); return r; }
__ai float32x2_t vabd_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vabd_v(a.val, b.val, 4); return r; }
__ai int8x16_t vabdq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vabdq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vabdq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vabdq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vabdq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vabdq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 26); return r; }
__ai float32x4_t vabdq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = __builtin_neon_vabdq_v(a.val, b.val, 20); return r; }

__ai int16x8_t vabdl_s8(int8x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 17); return r; }
__ai int32x4_t vabdl_s16(int16x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 18); return r; }
__ai int64x2_t vabdl_s32(int32x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vabdl_u8(uint8x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vabdl_u16(uint16x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vabdl_u32(uint32x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vabdl_v(a.val, b.val, 27); return r; }

__ai int8x8_t vabs_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vabs_v(a.val, 0); return r; }
__ai int16x4_t vabs_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_neon_vabs_v(a.val, 1); return r; }
__ai int32x2_t vabs_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_neon_vabs_v(a.val, 2); return r; }
__ai float32x2_t vabs_f32(float32x2_t a) { float32x2_t r; r.val = __builtin_neon_vabs_v(a.val, 4); return r; }
__ai int8x16_t vabsq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vabsq_v(a.val, 16); return r; }
__ai int16x8_t vabsq_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_neon_vabsq_v(a.val, 17); return r; }
__ai int32x4_t vabsq_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_neon_vabsq_v(a.val, 18); return r; }
__ai float32x4_t vabsq_f32(float32x4_t a) { float32x4_t r; r.val = __builtin_neon_vabsq_v(a.val, 20); return r; }

__ai int8x8_t vadd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val + b.val; return r; }
__ai int16x4_t vadd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val + b.val; return r; }
__ai int32x2_t vadd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val + b.val; return r; }
__ai int64x1_t vadd_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val + b.val; return r; }
__ai float32x2_t vadd_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = a.val + b.val; return r; }
__ai uint8x8_t vadd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val + b.val; return r; }
__ai uint16x4_t vadd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val + b.val; return r; }
__ai uint32x2_t vadd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val + b.val; return r; }
__ai uint64x1_t vadd_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val + b.val; return r; }
__ai int8x16_t vaddq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val + b.val; return r; }
__ai int16x8_t vaddq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val + b.val; return r; }
__ai int32x4_t vaddq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val + b.val; return r; }
__ai int64x2_t vaddq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val + b.val; return r; }
__ai float32x4_t vaddq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = a.val + b.val; return r; }
__ai uint8x16_t vaddq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val + b.val; return r; }
__ai uint16x8_t vaddq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val + b.val; return r; }
__ai uint32x4_t vaddq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val + b.val; return r; }
__ai uint64x2_t vaddq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val + b.val; return r; }

__ai int8x8_t vaddhn_s8(int16x8_t a, int16x8_t b) { int8x8_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 0); return r; }
__ai int16x4_t vaddhn_s16(int32x4_t a, int32x4_t b) { int16x4_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 1); return r; }
__ai int32x2_t vaddhn_s32(int64x2_t a, int64x2_t b) { int32x2_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vaddhn_u8(uint16x8_t a, uint16x8_t b) { uint8x8_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vaddhn_u16(uint32x4_t a, uint32x4_t b) { uint16x4_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vaddhn_u32(uint64x2_t a, uint64x2_t b) { uint32x2_t r; r.val = __builtin_neon_vaddhn_v(a.val, b.val, 10); return r; }

__ai int16x8_t vaddl_s8(int8x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 17); return r; }
__ai int32x4_t vaddl_s16(int16x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 18); return r; }
__ai int64x2_t vaddl_s32(int32x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vaddl_u8(uint8x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vaddl_u16(uint16x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vaddl_u32(uint32x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vaddl_v(a.val, b.val, 27); return r; }

__ai int16x8_t vaddw_s8(int16x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 17); return r; }
__ai int32x4_t vaddw_s16(int32x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 18); return r; }
__ai int64x2_t vaddw_s32(int64x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vaddw_u8(uint16x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vaddw_u16(uint32x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vaddw_u32(uint64x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vaddw_v(a.val, b.val, 27); return r; }

__ai int8x8_t vand_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val & b.val; return r; }
__ai int16x4_t vand_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val & b.val; return r; }
__ai int32x2_t vand_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val & b.val; return r; }
__ai int64x1_t vand_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val & b.val; return r; }
__ai uint8x8_t vand_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val & b.val; return r; }
__ai uint16x4_t vand_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val & b.val; return r; }
__ai uint32x2_t vand_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val & b.val; return r; }
__ai uint64x1_t vand_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val & b.val; return r; }
__ai int8x16_t vandq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val & b.val; return r; }
__ai int16x8_t vandq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val & b.val; return r; }
__ai int32x4_t vandq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val & b.val; return r; }
__ai int64x2_t vandq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val & b.val; return r; }
__ai uint8x16_t vandq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val & b.val; return r; }
__ai uint16x8_t vandq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val & b.val; return r; }
__ai uint32x4_t vandq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val & b.val; return r; }
__ai uint64x2_t vandq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val & b.val; return r; }

__ai int8x8_t vbic_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val & ~b.val; return r; }
__ai int16x4_t vbic_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val & ~b.val; return r; }
__ai int32x2_t vbic_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val & ~b.val; return r; }
__ai int64x1_t vbic_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val & ~b.val; return r; }
__ai uint8x8_t vbic_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val & ~b.val; return r; }
__ai uint16x4_t vbic_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val & ~b.val; return r; }
__ai uint32x2_t vbic_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val & ~b.val; return r; }
__ai uint64x1_t vbic_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val & ~b.val; return r; }
__ai int8x16_t vbicq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val & ~b.val; return r; }
__ai int16x8_t vbicq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val & ~b.val; return r; }
__ai int32x4_t vbicq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val & ~b.val; return r; }
__ai int64x2_t vbicq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val & ~b.val; return r; }
__ai uint8x16_t vbicq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val & ~b.val; return r; }
__ai uint16x8_t vbicq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val & ~b.val; return r; }
__ai uint32x4_t vbicq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val & ~b.val; return r; }
__ai uint64x2_t vbicq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val & ~b.val; return r; }

__ai int8x8_t vbsl_s8(uint8x8_t a, int8x8_t b, int8x8_t c) { int8x8_t r; r.val = ( a.val & (__neon_uint8x8_t)b.val) | (~a.val & (__neon_uint8x8_t)c.val); return r; }
__ai int16x4_t vbsl_s16(uint16x4_t a, int16x4_t b, int16x4_t c) { int16x4_t r; r.val = ( a.val & (__neon_uint16x4_t)b.val) | (~a.val & (__neon_uint16x4_t)c.val); return r; }
__ai int32x2_t vbsl_s32(uint32x2_t a, int32x2_t b, int32x2_t c) { int32x2_t r; r.val = ( a.val & (__neon_uint32x2_t)b.val) | (~a.val & (__neon_uint32x2_t)c.val); return r; }
__ai int64x1_t vbsl_s64(uint64x1_t a, int64x1_t b, int64x1_t c) { int64x1_t r; r.val = ( a.val & (__neon_uint64x1_t)b.val) | (~a.val & (__neon_uint64x1_t)c.val); return r; }
__ai uint8x8_t vbsl_u8(uint8x8_t a, uint8x8_t b, uint8x8_t c) { uint8x8_t r; r.val = ( a.val & (__neon_uint8x8_t)b.val) | (~a.val & (__neon_uint8x8_t)c.val); return r; }
__ai uint16x4_t vbsl_u16(uint16x4_t a, uint16x4_t b, uint16x4_t c) { uint16x4_t r; r.val = ( a.val & (__neon_uint16x4_t)b.val) | (~a.val & (__neon_uint16x4_t)c.val); return r; }
__ai uint32x2_t vbsl_u32(uint32x2_t a, uint32x2_t b, uint32x2_t c) { uint32x2_t r; r.val = ( a.val & (__neon_uint32x2_t)b.val) | (~a.val & (__neon_uint32x2_t)c.val); return r; }
__ai uint64x1_t vbsl_u64(uint64x1_t a, uint64x1_t b, uint64x1_t c) { uint64x1_t r; r.val = ( a.val & (__neon_uint64x1_t)b.val) | (~a.val & (__neon_uint64x1_t)c.val); return r; }
__ai float32x2_t vbsl_f32(uint32x2_t a, float32x2_t b, float32x2_t c) { float32x2_t r; r.val = ( a.val & (__neon_uint32x2_t)b.val) | (~a.val & (__neon_uint32x2_t)c.val); return r; }
__ai poly8x8_t vbsl_p8(uint8x8_t a, poly8x8_t b, poly8x8_t c) { poly8x8_t r; r.val = ( a.val & (__neon_uint8x8_t)b.val) | (~a.val & (__neon_uint8x8_t)c.val); return r; }
__ai poly16x4_t vbsl_p16(uint16x4_t a, poly16x4_t b, poly16x4_t c) { poly16x4_t r; r.val = ( a.val & (__neon_uint16x4_t)b.val) | (~a.val & (__neon_uint16x4_t)c.val); return r; }
__ai int8x16_t vbslq_s8(uint8x16_t a, int8x16_t b, int8x16_t c) { int8x16_t r; r.val = ( a.val & (__neon_uint8x16_t)b.val) | (~a.val & (__neon_uint8x16_t)c.val); return r; }
__ai int16x8_t vbslq_s16(uint16x8_t a, int16x8_t b, int16x8_t c) { int16x8_t r; r.val = ( a.val & (__neon_uint16x8_t)b.val) | (~a.val & (__neon_uint16x8_t)c.val); return r; }
__ai int32x4_t vbslq_s32(uint32x4_t a, int32x4_t b, int32x4_t c) { int32x4_t r; r.val = ( a.val & (__neon_uint32x4_t)b.val) | (~a.val & (__neon_uint32x4_t)c.val); return r; }
__ai int64x2_t vbslq_s64(uint64x2_t a, int64x2_t b, int64x2_t c) { int64x2_t r; r.val = ( a.val & (__neon_uint64x2_t)b.val) | (~a.val & (__neon_uint64x2_t)c.val); return r; }
__ai uint8x16_t vbslq_u8(uint8x16_t a, uint8x16_t b, uint8x16_t c) { uint8x16_t r; r.val = ( a.val & (__neon_uint8x16_t)b.val) | (~a.val & (__neon_uint8x16_t)c.val); return r; }
__ai uint16x8_t vbslq_u16(uint16x8_t a, uint16x8_t b, uint16x8_t c) { uint16x8_t r; r.val = ( a.val & (__neon_uint16x8_t)b.val) | (~a.val & (__neon_uint16x8_t)c.val); return r; }
__ai uint32x4_t vbslq_u32(uint32x4_t a, uint32x4_t b, uint32x4_t c) { uint32x4_t r; r.val = ( a.val & (__neon_uint32x4_t)b.val) | (~a.val & (__neon_uint32x4_t)c.val); return r; }
__ai uint64x2_t vbslq_u64(uint64x2_t a, uint64x2_t b, uint64x2_t c) { uint64x2_t r; r.val = ( a.val & (__neon_uint64x2_t)b.val) | (~a.val & (__neon_uint64x2_t)c.val); return r; }
__ai float32x4_t vbslq_f32(uint32x4_t a, float32x4_t b, float32x4_t c) { float32x4_t r; r.val = ( a.val & (__neon_uint32x4_t)b.val) | (~a.val & (__neon_uint32x4_t)c.val); return r; }
__ai poly8x16_t vbslq_p8(uint8x16_t a, poly8x16_t b, poly8x16_t c) { poly8x16_t r; r.val = ( a.val & (__neon_uint8x16_t)b.val) | (~a.val & (__neon_uint8x16_t)c.val); return r; }
__ai poly16x8_t vbslq_p16(uint16x8_t a, poly16x8_t b, poly16x8_t c) { poly16x8_t r; r.val = ( a.val & (__neon_uint16x8_t)b.val) | (~a.val & (__neon_uint16x8_t)c.val); return r; }

__ai uint32x2_t vcage_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vcage_v(a.val, b.val, 10); return r; }
__ai uint32x4_t vcageq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vcageq_v(a.val, b.val, 26); return r; }

__ai uint32x2_t vcagt_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vcagt_v(a.val, b.val, 10); return r; }
__ai uint32x4_t vcagtq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vcagtq_v(a.val, b.val, 26); return r; }

__ai uint32x2_t vcale_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vcale_v(a.val, b.val, 10); return r; }
__ai uint32x4_t vcaleq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vcaleq_v(a.val, b.val, 26); return r; }

__ai uint32x2_t vcalt_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vcalt_v(a.val, b.val, 10); return r; }
__ai uint32x4_t vcaltq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vcaltq_v(a.val, b.val, 26); return r; }

__ai uint8x8_t vceq_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val == b.val); return r; }
__ai uint16x4_t vceq_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val == b.val); return r; }
__ai uint32x2_t vceq_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val == b.val); return r; }
__ai uint32x2_t vceq_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val == b.val); return r; }
__ai uint8x8_t vceq_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val == b.val); return r; }
__ai uint16x4_t vceq_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val == b.val); return r; }
__ai uint32x2_t vceq_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val == b.val); return r; }
__ai uint8x8_t vceq_p8(poly8x8_t a, poly8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val == b.val); return r; }
__ai uint8x16_t vceqq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val == b.val); return r; }
__ai uint16x8_t vceqq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val == b.val); return r; }
__ai uint32x4_t vceqq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val == b.val); return r; }
__ai uint32x4_t vceqq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val == b.val); return r; }
__ai uint8x16_t vceqq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val == b.val); return r; }
__ai uint16x8_t vceqq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val == b.val); return r; }
__ai uint32x4_t vceqq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val == b.val); return r; }
__ai uint8x16_t vceqq_p8(poly8x16_t a, poly8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val == b.val); return r; }

__ai uint8x8_t vcge_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val >= b.val); return r; }
__ai uint16x4_t vcge_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val >= b.val); return r; }
__ai uint32x2_t vcge_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val >= b.val); return r; }
__ai uint32x2_t vcge_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val >= b.val); return r; }
__ai uint8x8_t vcge_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val >= b.val); return r; }
__ai uint16x4_t vcge_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val >= b.val); return r; }
__ai uint32x2_t vcge_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val >= b.val); return r; }
__ai uint8x16_t vcgeq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val >= b.val); return r; }
__ai uint16x8_t vcgeq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val >= b.val); return r; }
__ai uint32x4_t vcgeq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val >= b.val); return r; }
__ai uint32x4_t vcgeq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val >= b.val); return r; }
__ai uint8x16_t vcgeq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val >= b.val); return r; }
__ai uint16x8_t vcgeq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val >= b.val); return r; }
__ai uint32x4_t vcgeq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val >= b.val); return r; }

__ai uint8x8_t vcgt_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val > b.val); return r; }
__ai uint16x4_t vcgt_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val > b.val); return r; }
__ai uint32x2_t vcgt_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val > b.val); return r; }
__ai uint32x2_t vcgt_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val > b.val); return r; }
__ai uint8x8_t vcgt_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val > b.val); return r; }
__ai uint16x4_t vcgt_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val > b.val); return r; }
__ai uint32x2_t vcgt_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val > b.val); return r; }
__ai uint8x16_t vcgtq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val > b.val); return r; }
__ai uint16x8_t vcgtq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val > b.val); return r; }
__ai uint32x4_t vcgtq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val > b.val); return r; }
__ai uint32x4_t vcgtq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val > b.val); return r; }
__ai uint8x16_t vcgtq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val > b.val); return r; }
__ai uint16x8_t vcgtq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val > b.val); return r; }
__ai uint32x4_t vcgtq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val > b.val); return r; }

__ai uint8x8_t vcle_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val <= b.val); return r; }
__ai uint16x4_t vcle_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val <= b.val); return r; }
__ai uint32x2_t vcle_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val <= b.val); return r; }
__ai uint32x2_t vcle_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val <= b.val); return r; }
__ai uint8x8_t vcle_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val <= b.val); return r; }
__ai uint16x4_t vcle_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val <= b.val); return r; }
__ai uint32x2_t vcle_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val <= b.val); return r; }
__ai uint8x16_t vcleq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val <= b.val); return r; }
__ai uint16x8_t vcleq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val <= b.val); return r; }
__ai uint32x4_t vcleq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val <= b.val); return r; }
__ai uint32x4_t vcleq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val <= b.val); return r; }
__ai uint8x16_t vcleq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val <= b.val); return r; }
__ai uint16x8_t vcleq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val <= b.val); return r; }
__ai uint32x4_t vcleq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val <= b.val); return r; }

__ai int8x8_t vcls_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vcls_v(a.val, 0); return r; }
__ai int16x4_t vcls_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_neon_vcls_v(a.val, 1); return r; }
__ai int32x2_t vcls_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_neon_vcls_v(a.val, 2); return r; }
__ai int8x16_t vclsq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vclsq_v(a.val, 16); return r; }
__ai int16x8_t vclsq_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_neon_vclsq_v(a.val, 17); return r; }
__ai int32x4_t vclsq_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_neon_vclsq_v(a.val, 18); return r; }

__ai uint8x8_t vclt_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val < b.val); return r; }
__ai uint16x4_t vclt_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val < b.val); return r; }
__ai uint32x2_t vclt_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val < b.val); return r; }
__ai uint32x2_t vclt_f32(float32x2_t a, float32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val < b.val); return r; }
__ai uint8x8_t vclt_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = (__neon_uint8x8_t)(a.val < b.val); return r; }
__ai uint16x4_t vclt_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = (__neon_uint16x4_t)(a.val < b.val); return r; }
__ai uint32x2_t vclt_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = (__neon_uint32x2_t)(a.val < b.val); return r; }
__ai uint8x16_t vcltq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val < b.val); return r; }
__ai uint16x8_t vcltq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val < b.val); return r; }
__ai uint32x4_t vcltq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val < b.val); return r; }
__ai uint32x4_t vcltq_f32(float32x4_t a, float32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val < b.val); return r; }
__ai uint8x16_t vcltq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = (__neon_uint8x16_t)(a.val < b.val); return r; }
__ai uint16x8_t vcltq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = (__neon_uint16x8_t)(a.val < b.val); return r; }
__ai uint32x4_t vcltq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = (__neon_uint32x4_t)(a.val < b.val); return r; }

__ai int8x8_t vclz_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vclz_v(a.val, 0); return r; }
__ai int16x4_t vclz_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_neon_vclz_v(a.val, 1); return r; }
__ai int32x2_t vclz_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_neon_vclz_v(a.val, 2); return r; }
__ai uint8x8_t vclz_u8(uint8x8_t a) { uint8x8_t r; r.val = __builtin_neon_vclz_v(a.val, 8); return r; }
__ai uint16x4_t vclz_u16(uint16x4_t a) { uint16x4_t r; r.val = __builtin_neon_vclz_v(a.val, 9); return r; }
__ai uint32x2_t vclz_u32(uint32x2_t a) { uint32x2_t r; r.val = __builtin_neon_vclz_v(a.val, 10); return r; }
__ai int8x16_t vclzq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vclzq_v(a.val, 16); return r; }
__ai int16x8_t vclzq_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_neon_vclzq_v(a.val, 17); return r; }
__ai int32x4_t vclzq_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_neon_vclzq_v(a.val, 18); return r; }
__ai uint8x16_t vclzq_u8(uint8x16_t a) { uint8x16_t r; r.val = __builtin_neon_vclzq_v(a.val, 24); return r; }
__ai uint16x8_t vclzq_u16(uint16x8_t a) { uint16x8_t r; r.val = __builtin_neon_vclzq_v(a.val, 25); return r; }
__ai uint32x4_t vclzq_u32(uint32x4_t a) { uint32x4_t r; r.val = __builtin_neon_vclzq_v(a.val, 26); return r; }

__ai uint8x8_t vcnt_u8(uint8x8_t a) { uint8x8_t r; r.val = __builtin_neon_vcnt_v(a.val, 8); return r; }
__ai int8x8_t vcnt_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vcnt_v(a.val, 0); return r; }
__ai poly8x8_t vcnt_p8(poly8x8_t a) { poly8x8_t r; r.val = __builtin_neon_vcnt_v(a.val, 5); return r; }
__ai uint8x16_t vcntq_u8(uint8x16_t a) { uint8x16_t r; r.val = __builtin_neon_vcntq_v(a.val, 24); return r; }
__ai int8x16_t vcntq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vcntq_v(a.val, 16); return r; }
__ai poly8x16_t vcntq_p8(poly8x16_t a) { poly8x16_t r; r.val = __builtin_neon_vcntq_v(a.val, 21); return r; }

__ai int8x16_t vcombine_s8(int8x8_t a, int8x8_t b) { int8x16_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai int16x8_t vcombine_s16(int16x4_t a, int16x4_t b) { int16x8_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai int32x4_t vcombine_s32(int32x2_t a, int32x2_t b) { int32x4_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai int64x2_t vcombine_s64(int64x1_t a, int64x1_t b) { int64x2_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai float16x8_t vcombine_f16(float16x4_t a, float16x4_t b) { float16x8_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai float32x4_t vcombine_f32(float32x2_t a, float32x2_t b) { float32x4_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai uint8x16_t vcombine_u8(uint8x8_t a, uint8x8_t b) { uint8x16_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai uint16x8_t vcombine_u16(uint16x4_t a, uint16x4_t b) { uint16x8_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai uint32x4_t vcombine_u32(uint32x2_t a, uint32x2_t b) { uint32x4_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai uint64x2_t vcombine_u64(uint64x1_t a, uint64x1_t b) { uint64x2_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai poly8x16_t vcombine_p8(poly8x8_t a, poly8x8_t b) { poly8x16_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }
__ai poly16x8_t vcombine_p16(poly16x4_t a, poly16x4_t b) { poly16x8_t r; r.val = __builtin_shufflevector((__neon_int64x1_t)a.val, (__neon_int64x1_t)b.val, 0, 1); return r; }

__ai int8x8_t vcreate_s8(uint64_t a) { int8x8_t r; r.val = (__neon_int8x8_t)a; return r; }
__ai int16x4_t vcreate_s16(uint64_t a) { int16x4_t r; r.val = (__neon_int16x4_t)a; return r; }
__ai int32x2_t vcreate_s32(uint64_t a) { int32x2_t r; r.val = (__neon_int32x2_t)a; return r; }
__ai float16x4_t vcreate_f16(uint64_t a) { float16x4_t r; r.val = (__neon_float16x4_t)a; return r; }
__ai float32x2_t vcreate_f32(uint64_t a) { float32x2_t r; r.val = (__neon_float32x2_t)a; return r; }
__ai uint8x8_t vcreate_u8(uint64_t a) { uint8x8_t r; r.val = (__neon_uint8x8_t)a; return r; }
__ai uint16x4_t vcreate_u16(uint64_t a) { uint16x4_t r; r.val = (__neon_uint16x4_t)a; return r; }
__ai uint32x2_t vcreate_u32(uint64_t a) { uint32x2_t r; r.val = (__neon_uint32x2_t)a; return r; }
__ai uint64x1_t vcreate_u64(uint64_t a) { uint64x1_t r; r.val = (__neon_uint64x1_t)a; return r; }
__ai poly8x8_t vcreate_p8(uint64_t a) { poly8x8_t r; r.val = (__neon_poly8x8_t)a; return r; }
__ai poly16x4_t vcreate_p16(uint64_t a) { poly16x4_t r; r.val = (__neon_poly16x4_t)a; return r; }
__ai int64x1_t vcreate_s64(uint64_t a) { int64x1_t r; r.val = (__neon_int64x1_t)a; return r; }

__ai float16x4_t vcvt_f16_f32(float32x4_t a) { float16x4_t r; r.val = __builtin_neon_vcvt_f16_v(a.val, 7); return r; }

__ai float32x2_t vcvt_f32_s32(int32x2_t a) { float32x2_t r; r.val = __builtin_neon_vcvt_f32_v(a.val, 2); return r; }
__ai float32x2_t vcvt_f32_u32(uint32x2_t a) { float32x2_t r; r.val = __builtin_neon_vcvt_f32_v(a.val, 10); return r; }
__ai float32x4_t vcvtq_f32_s32(int32x4_t a) { float32x4_t r; r.val = __builtin_neon_vcvtq_f32_v(a.val, 18); return r; }
__ai float32x4_t vcvtq_f32_u32(uint32x4_t a) { float32x4_t r; r.val = __builtin_neon_vcvtq_f32_v(a.val, 26); return r; }

__ai float32x4_t vcvt_f32_f16(float16x4_t a) { float32x4_t r; r.val = __builtin_neon_vcvt_f32_f16(a.val, 20); return r; }

#define vcvt_n_f32_s32(a, b) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vcvt_n_f32_v((a).val, (b), 2)}
#define vcvt_n_f32_u32(a, b) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vcvt_n_f32_v((a).val, (b), 10)}
#define vcvtq_n_f32_s32(a, b) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vcvtq_n_f32_v((a).val, (b), 18)}
#define vcvtq_n_f32_u32(a, b) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vcvtq_n_f32_v((a).val, (b), 26)}

#define vcvt_n_s32_f32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vcvt_n_s32_v((a).val, (b), 2)}
#define vcvtq_n_s32_f32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vcvtq_n_s32_v((a).val, (b), 18)}

#define vcvt_n_u32_f32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vcvt_n_u32_v((a).val, (b), 10)}
#define vcvtq_n_u32_f32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vcvtq_n_u32_v((a).val, (b), 26)}

__ai int32x2_t vcvt_s32_f32(float32x2_t a) { int32x2_t r; r.val = __builtin_neon_vcvt_s32_v(a.val, 2); return r; }
__ai int32x4_t vcvtq_s32_f32(float32x4_t a) { int32x4_t r; r.val = __builtin_neon_vcvtq_s32_v(a.val, 18); return r; }

__ai uint32x2_t vcvt_u32_f32(float32x2_t a) { uint32x2_t r; r.val = __builtin_neon_vcvt_u32_v(a.val, 10); return r; }
__ai uint32x4_t vcvtq_u32_f32(float32x4_t a) { uint32x4_t r; r.val = __builtin_neon_vcvtq_u32_v(a.val, 26); return r; }

#define vdup_lane_u8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vdup_lane_v((a).val, (b), 8)}
#define vdup_lane_u16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vdup_lane_v((a).val, (b), 9)}
#define vdup_lane_u32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vdup_lane_v((a).val, (b), 10)}
#define vdup_lane_s8(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vdup_lane_v((a).val, (b), 0)}
#define vdup_lane_s16(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vdup_lane_v((a).val, (b), 1)}
#define vdup_lane_s32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vdup_lane_v((a).val, (b), 2)}
#define vdup_lane_p8(a, b) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vdup_lane_v((a).val, (b), 5)}
#define vdup_lane_p16(a, b) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vdup_lane_v((a).val, (b), 6)}
#define vdup_lane_f32(a, b) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vdup_lane_v((a).val, (b), 4)}
#define vdupq_lane_u8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vdupq_lane_v((a).val, (b), 8)}
#define vdupq_lane_u16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vdupq_lane_v((a).val, (b), 9)}
#define vdupq_lane_u32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vdupq_lane_v((a).val, (b), 10)}
#define vdupq_lane_s8(a, b) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vdupq_lane_v((a).val, (b), 0)}
#define vdupq_lane_s16(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vdupq_lane_v((a).val, (b), 1)}
#define vdupq_lane_s32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vdupq_lane_v((a).val, (b), 2)}
#define vdupq_lane_p8(a, b) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vdupq_lane_v((a).val, (b), 5)}
#define vdupq_lane_p16(a, b) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vdupq_lane_v((a).val, (b), 6)}
#define vdupq_lane_f32(a, b) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vdupq_lane_v((a).val, (b), 4)}
#define vdup_lane_s64(a, b) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vdup_lane_v((a).val, (b), 3)}
#define vdup_lane_u64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vdup_lane_v((a).val, (b), 11)}
#define vdupq_lane_s64(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vdupq_lane_v((a).val, (b), 3)}
#define vdupq_lane_u64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vdupq_lane_v((a).val, (b), 11)}

__ai uint8x8_t vdup_n_u8(uint8_t a) { uint8x8_t r; r.val = (__neon_uint8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai uint16x4_t vdup_n_u16(uint16_t a) { uint16x4_t r; r.val = (__neon_uint16x4_t){ a, a, a, a }; return r; }
__ai uint32x2_t vdup_n_u32(uint32_t a) { uint32x2_t r; r.val = (__neon_uint32x2_t){ a, a }; return r; }
__ai int8x8_t vdup_n_s8(int8_t a) { int8x8_t r; r.val = (__neon_int8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai int16x4_t vdup_n_s16(int16_t a) { int16x4_t r; r.val = (__neon_int16x4_t){ a, a, a, a }; return r; }
__ai int32x2_t vdup_n_s32(int32_t a) { int32x2_t r; r.val = (__neon_int32x2_t){ a, a }; return r; }
__ai poly8x8_t vdup_n_p8(poly8_t a) { poly8x8_t r; r.val = (__neon_poly8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai poly16x4_t vdup_n_p16(poly16_t a) { poly16x4_t r; r.val = (__neon_poly16x4_t){ a, a, a, a }; return r; }
__ai float32x2_t vdup_n_f32(float32_t a) { float32x2_t r; r.val = (__neon_float32x2_t){ a, a }; return r; }
__ai uint8x16_t vdupq_n_u8(uint8_t a) { uint8x16_t r; r.val = (__neon_uint8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai uint16x8_t vdupq_n_u16(uint16_t a) { uint16x8_t r; r.val = (__neon_uint16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai uint32x4_t vdupq_n_u32(uint32_t a) { uint32x4_t r; r.val = (__neon_uint32x4_t){ a, a, a, a }; return r; }
__ai int8x16_t vdupq_n_s8(int8_t a) { int8x16_t r; r.val = (__neon_int8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai int16x8_t vdupq_n_s16(int16_t a) { int16x8_t r; r.val = (__neon_int16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai int32x4_t vdupq_n_s32(int32_t a) { int32x4_t r; r.val = (__neon_int32x4_t){ a, a, a, a }; return r; }
__ai poly8x16_t vdupq_n_p8(poly8_t a) { poly8x16_t r; r.val = (__neon_poly8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai poly16x8_t vdupq_n_p16(poly16_t a) { poly16x8_t r; r.val = (__neon_poly16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai float32x4_t vdupq_n_f32(float32_t a) { float32x4_t r; r.val = (__neon_float32x4_t){ a, a, a, a }; return r; }
__ai int64x1_t vdup_n_s64(int64_t a) { int64x1_t r; r.val = (__neon_int64x1_t){ a }; return r; }
__ai uint64x1_t vdup_n_u64(uint64_t a) { uint64x1_t r; r.val = (__neon_uint64x1_t){ a }; return r; }
__ai int64x2_t vdupq_n_s64(int64_t a) { int64x2_t r; r.val = (__neon_int64x2_t){ a, a }; return r; }
__ai uint64x2_t vdupq_n_u64(uint64_t a) { uint64x2_t r; r.val = (__neon_uint64x2_t){ a, a }; return r; }

__ai int8x8_t veor_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val ^ b.val; return r; }
__ai int16x4_t veor_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val ^ b.val; return r; }
__ai int32x2_t veor_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val ^ b.val; return r; }
__ai int64x1_t veor_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val ^ b.val; return r; }
__ai uint8x8_t veor_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val ^ b.val; return r; }
__ai uint16x4_t veor_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val ^ b.val; return r; }
__ai uint32x2_t veor_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val ^ b.val; return r; }
__ai uint64x1_t veor_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val ^ b.val; return r; }
__ai int8x16_t veorq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val ^ b.val; return r; }
__ai int16x8_t veorq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val ^ b.val; return r; }
__ai int32x4_t veorq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val ^ b.val; return r; }
__ai int64x2_t veorq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val ^ b.val; return r; }
__ai uint8x16_t veorq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val ^ b.val; return r; }
__ai uint16x8_t veorq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val ^ b.val; return r; }
__ai uint32x4_t veorq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val ^ b.val; return r; }
__ai uint64x2_t veorq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val ^ b.val; return r; }

#define vext_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vext_v((a).val, (b).val, (c), 0)}
#define vext_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vext_v((a).val, (b).val, (c), 8)}
#define vext_p8(a, b, c) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vext_v((a).val, (b).val, (c), 5)}
#define vext_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vext_v((a).val, (b).val, (c), 1)}
#define vext_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vext_v((a).val, (b).val, (c), 9)}
#define vext_p16(a, b, c) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vext_v((a).val, (b).val, (c), 6)}
#define vext_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vext_v((a).val, (b).val, (c), 2)}
#define vext_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vext_v((a).val, (b).val, (c), 10)}
#define vext_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vext_v((a).val, (b).val, (c), 3)}
#define vext_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vext_v((a).val, (b).val, (c), 11)}
#define vextq_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 16)}
#define vextq_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 24)}
#define vextq_p8(a, b, c) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 21)}
#define vextq_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 17)}
#define vextq_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 25)}
#define vextq_p16(a, b, c) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 22)}
#define vextq_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 18)}
#define vextq_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 26)}
#define vextq_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 19)}
#define vextq_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vextq_v((a).val, (b).val, (c), 27)}

__ai int8x8_t vget_high_s8(int8x16_t a) { int8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai int16x4_t vget_high_s16(int16x8_t a) { int16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai int32x2_t vget_high_s32(int32x4_t a) { int32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai int64x1_t vget_high_s64(int64x2_t a) { int64x1_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai float16x4_t vget_high_f16(float16x8_t a) { float16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai float32x2_t vget_high_f32(float32x4_t a) { float32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai uint8x8_t vget_high_u8(uint8x16_t a) { uint8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai uint16x4_t vget_high_u16(uint16x8_t a) { uint16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai uint32x2_t vget_high_u32(uint32x4_t a) { uint32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai uint64x1_t vget_high_u64(uint64x2_t a) { uint64x1_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai poly8x8_t vget_high_p8(poly8x16_t a) { poly8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }
__ai poly16x4_t vget_high_p16(poly16x8_t a) { poly16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[1]); return r; }

#define vget_lane_u8(a, b) __builtin_neon_vget_lane_i8((a).val, (b))
#define vget_lane_u16(a, b) __builtin_neon_vget_lane_i16((a).val, (b))
#define vget_lane_u32(a, b) __builtin_neon_vget_lane_i32((a).val, (b))
#define vget_lane_s8(a, b) __builtin_neon_vget_lane_i8((a).val, (b))
#define vget_lane_s16(a, b) __builtin_neon_vget_lane_i16((a).val, (b))
#define vget_lane_s32(a, b) __builtin_neon_vget_lane_i32((a).val, (b))
#define vget_lane_p8(a, b) __builtin_neon_vget_lane_i8((a).val, (b))
#define vget_lane_p16(a, b) __builtin_neon_vget_lane_i16((a).val, (b))
#define vget_lane_f32(a, b) __builtin_neon_vget_lane_f32((a).val, (b))
#define vgetq_lane_u8(a, b) __builtin_neon_vgetq_lane_i8((a).val, (b))
#define vgetq_lane_u16(a, b) __builtin_neon_vgetq_lane_i16((a).val, (b))
#define vgetq_lane_u32(a, b) __builtin_neon_vgetq_lane_i32((a).val, (b))
#define vgetq_lane_s8(a, b) __builtin_neon_vgetq_lane_i8((a).val, (b))
#define vgetq_lane_s16(a, b) __builtin_neon_vgetq_lane_i16((a).val, (b))
#define vgetq_lane_s32(a, b) __builtin_neon_vgetq_lane_i32((a).val, (b))
#define vgetq_lane_p8(a, b) __builtin_neon_vgetq_lane_i8((a).val, (b))
#define vgetq_lane_p16(a, b) __builtin_neon_vgetq_lane_i16((a).val, (b))
#define vgetq_lane_f32(a, b) __builtin_neon_vgetq_lane_f32((a).val, (b))
#define vget_lane_s64(a, b) __builtin_neon_vget_lane_i64((a).val, (b))
#define vget_lane_u64(a, b) __builtin_neon_vget_lane_i64((a).val, (b))
#define vgetq_lane_s64(a, b) __builtin_neon_vgetq_lane_i64((a).val, (b))
#define vgetq_lane_u64(a, b) __builtin_neon_vgetq_lane_i64((a).val, (b))

__ai int8x8_t vget_low_s8(int8x16_t a) { int8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai int16x4_t vget_low_s16(int16x8_t a) { int16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai int32x2_t vget_low_s32(int32x4_t a) { int32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai int64x1_t vget_low_s64(int64x2_t a) { int64x1_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai float16x4_t vget_low_f16(float16x8_t a) { float16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai float32x2_t vget_low_f32(float32x4_t a) { float32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai uint8x8_t vget_low_u8(uint8x16_t a) { uint8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai uint16x4_t vget_low_u16(uint16x8_t a) { uint16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai uint32x2_t vget_low_u32(uint32x4_t a) { uint32x2_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai uint64x1_t vget_low_u64(uint64x2_t a) { uint64x1_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai poly8x8_t vget_low_p8(poly8x16_t a) { poly8x8_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }
__ai poly16x4_t vget_low_p16(poly16x8_t a) { poly16x4_t r; r.val = (__neon_int64x1_t)(((__neon_int64x2_t)a.val)[0]); return r; }

__ai int8x8_t vhadd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 0); return r; }
__ai int16x4_t vhadd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 1); return r; }
__ai int32x2_t vhadd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vhadd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vhadd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vhadd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vhadd_v(a.val, b.val, 10); return r; }
__ai int8x16_t vhaddq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vhaddq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vhaddq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vhaddq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vhaddq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vhaddq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vhaddq_v(a.val, b.val, 26); return r; }

__ai int8x8_t vhsub_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 0); return r; }
__ai int16x4_t vhsub_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 1); return r; }
__ai int32x2_t vhsub_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vhsub_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vhsub_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vhsub_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vhsub_v(a.val, b.val, 10); return r; }
__ai int8x16_t vhsubq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vhsubq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vhsubq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vhsubq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vhsubq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vhsubq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vhsubq_v(a.val, b.val, 26); return r; }

__ai uint8x16_t vld1q_u8(uint8_t const * a) { uint8x16_t r; r.val = __builtin_neon_vld1q_v(a, 24); return r; }
__ai uint16x8_t vld1q_u16(uint16_t const * a) { uint16x8_t r; r.val = __builtin_neon_vld1q_v(a, 25); return r; }
__ai uint32x4_t vld1q_u32(uint32_t const * a) { uint32x4_t r; r.val = __builtin_neon_vld1q_v(a, 26); return r; }
__ai uint64x2_t vld1q_u64(uint64_t const * a) { uint64x2_t r; r.val = __builtin_neon_vld1q_v(a, 27); return r; }
__ai int8x16_t vld1q_s8(int8_t const * a) { int8x16_t r; r.val = __builtin_neon_vld1q_v(a, 16); return r; }
__ai int16x8_t vld1q_s16(int16_t const * a) { int16x8_t r; r.val = __builtin_neon_vld1q_v(a, 17); return r; }
__ai int32x4_t vld1q_s32(int32_t const * a) { int32x4_t r; r.val = __builtin_neon_vld1q_v(a, 18); return r; }
__ai int64x2_t vld1q_s64(int64_t const * a) { int64x2_t r; r.val = __builtin_neon_vld1q_v(a, 19); return r; }
__ai float16x8_t vld1q_f16(float16_t const * a) { float16x8_t r; r.val = __builtin_neon_vld1q_v(a, 23); return r; }
__ai float32x4_t vld1q_f32(float32_t const * a) { float32x4_t r; r.val = __builtin_neon_vld1q_v(a, 20); return r; }
__ai poly8x16_t vld1q_p8(poly8_t const * a) { poly8x16_t r; r.val = __builtin_neon_vld1q_v(a, 21); return r; }
__ai poly16x8_t vld1q_p16(poly16_t const * a) { poly16x8_t r; r.val = __builtin_neon_vld1q_v(a, 22); return r; }
__ai uint8x8_t vld1_u8(uint8_t const * a) { uint8x8_t r; r.val = __builtin_neon_vld1_v(a, 8); return r; }
__ai uint16x4_t vld1_u16(uint16_t const * a) { uint16x4_t r; r.val = __builtin_neon_vld1_v(a, 9); return r; }
__ai uint32x2_t vld1_u32(uint32_t const * a) { uint32x2_t r; r.val = __builtin_neon_vld1_v(a, 10); return r; }
__ai uint64x1_t vld1_u64(uint64_t const * a) { uint64x1_t r; r.val = __builtin_neon_vld1_v(a, 11); return r; }
__ai int8x8_t vld1_s8(int8_t const * a) { int8x8_t r; r.val = __builtin_neon_vld1_v(a, 0); return r; }
__ai int16x4_t vld1_s16(int16_t const * a) { int16x4_t r; r.val = __builtin_neon_vld1_v(a, 1); return r; }
__ai int32x2_t vld1_s32(int32_t const * a) { int32x2_t r; r.val = __builtin_neon_vld1_v(a, 2); return r; }
__ai int64x1_t vld1_s64(int64_t const * a) { int64x1_t r; r.val = __builtin_neon_vld1_v(a, 3); return r; }
__ai float16x4_t vld1_f16(float16_t const * a) { float16x4_t r; r.val = __builtin_neon_vld1_v(a, 7); return r; }
__ai float32x2_t vld1_f32(float32_t const * a) { float32x2_t r; r.val = __builtin_neon_vld1_v(a, 4); return r; }
__ai poly8x8_t vld1_p8(poly8_t const * a) { poly8x8_t r; r.val = __builtin_neon_vld1_v(a, 5); return r; }
__ai poly16x4_t vld1_p16(poly16_t const * a) { poly16x4_t r; r.val = __builtin_neon_vld1_v(a, 6); return r; }

__ai uint8x16_t vld1q_dup_u8(uint8_t const * a) { uint8x16_t r; r.val = __builtin_neon_vld1q_dup_v(a, 24); return r; }
__ai uint16x8_t vld1q_dup_u16(uint16_t const * a) { uint16x8_t r; r.val = __builtin_neon_vld1q_dup_v(a, 25); return r; }
__ai uint32x4_t vld1q_dup_u32(uint32_t const * a) { uint32x4_t r; r.val = __builtin_neon_vld1q_dup_v(a, 26); return r; }
__ai uint64x2_t vld1q_dup_u64(uint64_t const * a) { uint64x2_t r; r.val = __builtin_neon_vld1q_dup_v(a, 27); return r; }
__ai int8x16_t vld1q_dup_s8(int8_t const * a) { int8x16_t r; r.val = __builtin_neon_vld1q_dup_v(a, 16); return r; }
__ai int16x8_t vld1q_dup_s16(int16_t const * a) { int16x8_t r; r.val = __builtin_neon_vld1q_dup_v(a, 17); return r; }
__ai int32x4_t vld1q_dup_s32(int32_t const * a) { int32x4_t r; r.val = __builtin_neon_vld1q_dup_v(a, 18); return r; }
__ai int64x2_t vld1q_dup_s64(int64_t const * a) { int64x2_t r; r.val = __builtin_neon_vld1q_dup_v(a, 19); return r; }
__ai float16x8_t vld1q_dup_f16(float16_t const * a) { float16x8_t r; r.val = __builtin_neon_vld1q_dup_v(a, 23); return r; }
__ai float32x4_t vld1q_dup_f32(float32_t const * a) { float32x4_t r; r.val = __builtin_neon_vld1q_dup_v(a, 20); return r; }
__ai poly8x16_t vld1q_dup_p8(poly8_t const * a) { poly8x16_t r; r.val = __builtin_neon_vld1q_dup_v(a, 21); return r; }
__ai poly16x8_t vld1q_dup_p16(poly16_t const * a) { poly16x8_t r; r.val = __builtin_neon_vld1q_dup_v(a, 22); return r; }
__ai uint8x8_t vld1_dup_u8(uint8_t const * a) { uint8x8_t r; r.val = __builtin_neon_vld1_dup_v(a, 8); return r; }
__ai uint16x4_t vld1_dup_u16(uint16_t const * a) { uint16x4_t r; r.val = __builtin_neon_vld1_dup_v(a, 9); return r; }
__ai uint32x2_t vld1_dup_u32(uint32_t const * a) { uint32x2_t r; r.val = __builtin_neon_vld1_dup_v(a, 10); return r; }
__ai uint64x1_t vld1_dup_u64(uint64_t const * a) { uint64x1_t r; r.val = __builtin_neon_vld1_dup_v(a, 11); return r; }
__ai int8x8_t vld1_dup_s8(int8_t const * a) { int8x8_t r; r.val = __builtin_neon_vld1_dup_v(a, 0); return r; }
__ai int16x4_t vld1_dup_s16(int16_t const * a) { int16x4_t r; r.val = __builtin_neon_vld1_dup_v(a, 1); return r; }
__ai int32x2_t vld1_dup_s32(int32_t const * a) { int32x2_t r; r.val = __builtin_neon_vld1_dup_v(a, 2); return r; }
__ai int64x1_t vld1_dup_s64(int64_t const * a) { int64x1_t r; r.val = __builtin_neon_vld1_dup_v(a, 3); return r; }
__ai float16x4_t vld1_dup_f16(float16_t const * a) { float16x4_t r; r.val = __builtin_neon_vld1_dup_v(a, 7); return r; }
__ai float32x2_t vld1_dup_f32(float32_t const * a) { float32x2_t r; r.val = __builtin_neon_vld1_dup_v(a, 4); return r; }
__ai poly8x8_t vld1_dup_p8(poly8_t const * a) { poly8x8_t r; r.val = __builtin_neon_vld1_dup_v(a, 5); return r; }
__ai poly16x4_t vld1_dup_p16(poly16_t const * a) { poly16x4_t r; r.val = __builtin_neon_vld1_dup_v(a, 6); return r; }

#define vld1q_lane_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 24)}
#define vld1q_lane_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 25)}
#define vld1q_lane_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 26)}
#define vld1q_lane_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 27)}
#define vld1q_lane_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 16)}
#define vld1q_lane_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 17)}
#define vld1q_lane_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 18)}
#define vld1q_lane_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 19)}
#define vld1q_lane_f16(a, b, c) (float16x8_t){(__neon_float16x8_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 23)}
#define vld1q_lane_f32(a, b, c) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 20)}
#define vld1q_lane_p8(a, b, c) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 21)}
#define vld1q_lane_p16(a, b, c) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vld1q_lane_v((a), (b).val, (c), 22)}
#define vld1_lane_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 8)}
#define vld1_lane_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 9)}
#define vld1_lane_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 10)}
#define vld1_lane_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 11)}
#define vld1_lane_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 0)}
#define vld1_lane_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 1)}
#define vld1_lane_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 2)}
#define vld1_lane_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 3)}
#define vld1_lane_f16(a, b, c) (float16x4_t){(__neon_float16x4_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 7)}
#define vld1_lane_f32(a, b, c) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 4)}
#define vld1_lane_p8(a, b, c) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 5)}
#define vld1_lane_p16(a, b, c) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vld1_lane_v((a), (b).val, (c), 6)}

__ai uint8x16x2_t vld2q_u8(uint8_t const * a) { uint8x16x2_t r; __builtin_neon_vld2q_v(&r, a, 24); return r; }
__ai uint16x8x2_t vld2q_u16(uint16_t const * a) { uint16x8x2_t r; __builtin_neon_vld2q_v(&r, a, 25); return r; }
__ai uint32x4x2_t vld2q_u32(uint32_t const * a) { uint32x4x2_t r; __builtin_neon_vld2q_v(&r, a, 26); return r; }
__ai int8x16x2_t vld2q_s8(int8_t const * a) { int8x16x2_t r; __builtin_neon_vld2q_v(&r, a, 16); return r; }
__ai int16x8x2_t vld2q_s16(int16_t const * a) { int16x8x2_t r; __builtin_neon_vld2q_v(&r, a, 17); return r; }
__ai int32x4x2_t vld2q_s32(int32_t const * a) { int32x4x2_t r; __builtin_neon_vld2q_v(&r, a, 18); return r; }
__ai float16x8x2_t vld2q_f16(float16_t const * a) { float16x8x2_t r; __builtin_neon_vld2q_v(&r, a, 23); return r; }
__ai float32x4x2_t vld2q_f32(float32_t const * a) { float32x4x2_t r; __builtin_neon_vld2q_v(&r, a, 20); return r; }
__ai poly8x16x2_t vld2q_p8(poly8_t const * a) { poly8x16x2_t r; __builtin_neon_vld2q_v(&r, a, 21); return r; }
__ai poly16x8x2_t vld2q_p16(poly16_t const * a) { poly16x8x2_t r; __builtin_neon_vld2q_v(&r, a, 22); return r; }
__ai uint8x8x2_t vld2_u8(uint8_t const * a) { uint8x8x2_t r; __builtin_neon_vld2_v(&r, a, 8); return r; }
__ai uint16x4x2_t vld2_u16(uint16_t const * a) { uint16x4x2_t r; __builtin_neon_vld2_v(&r, a, 9); return r; }
__ai uint32x2x2_t vld2_u32(uint32_t const * a) { uint32x2x2_t r; __builtin_neon_vld2_v(&r, a, 10); return r; }
__ai uint64x1x2_t vld2_u64(uint64_t const * a) { uint64x1x2_t r; __builtin_neon_vld2_v(&r, a, 11); return r; }
__ai int8x8x2_t vld2_s8(int8_t const * a) { int8x8x2_t r; __builtin_neon_vld2_v(&r, a, 0); return r; }
__ai int16x4x2_t vld2_s16(int16_t const * a) { int16x4x2_t r; __builtin_neon_vld2_v(&r, a, 1); return r; }
__ai int32x2x2_t vld2_s32(int32_t const * a) { int32x2x2_t r; __builtin_neon_vld2_v(&r, a, 2); return r; }
__ai int64x1x2_t vld2_s64(int64_t const * a) { int64x1x2_t r; __builtin_neon_vld2_v(&r, a, 3); return r; }
__ai float16x4x2_t vld2_f16(float16_t const * a) { float16x4x2_t r; __builtin_neon_vld2_v(&r, a, 7); return r; }
__ai float32x2x2_t vld2_f32(float32_t const * a) { float32x2x2_t r; __builtin_neon_vld2_v(&r, a, 4); return r; }
__ai poly8x8x2_t vld2_p8(poly8_t const * a) { poly8x8x2_t r; __builtin_neon_vld2_v(&r, a, 5); return r; }
__ai poly16x4x2_t vld2_p16(poly16_t const * a) { poly16x4x2_t r; __builtin_neon_vld2_v(&r, a, 6); return r; }

__ai uint8x8x2_t vld2_dup_u8(uint8_t const * a) { uint8x8x2_t r; __builtin_neon_vld2_dup_v(&r, a, 8); return r; }
__ai uint16x4x2_t vld2_dup_u16(uint16_t const * a) { uint16x4x2_t r; __builtin_neon_vld2_dup_v(&r, a, 9); return r; }
__ai uint32x2x2_t vld2_dup_u32(uint32_t const * a) { uint32x2x2_t r; __builtin_neon_vld2_dup_v(&r, a, 10); return r; }
__ai uint64x1x2_t vld2_dup_u64(uint64_t const * a) { uint64x1x2_t r; __builtin_neon_vld2_dup_v(&r, a, 11); return r; }
__ai int8x8x2_t vld2_dup_s8(int8_t const * a) { int8x8x2_t r; __builtin_neon_vld2_dup_v(&r, a, 0); return r; }
__ai int16x4x2_t vld2_dup_s16(int16_t const * a) { int16x4x2_t r; __builtin_neon_vld2_dup_v(&r, a, 1); return r; }
__ai int32x2x2_t vld2_dup_s32(int32_t const * a) { int32x2x2_t r; __builtin_neon_vld2_dup_v(&r, a, 2); return r; }
__ai int64x1x2_t vld2_dup_s64(int64_t const * a) { int64x1x2_t r; __builtin_neon_vld2_dup_v(&r, a, 3); return r; }
__ai float16x4x2_t vld2_dup_f16(float16_t const * a) { float16x4x2_t r; __builtin_neon_vld2_dup_v(&r, a, 7); return r; }
__ai float32x2x2_t vld2_dup_f32(float32_t const * a) { float32x2x2_t r; __builtin_neon_vld2_dup_v(&r, a, 4); return r; }
__ai poly8x8x2_t vld2_dup_p8(poly8_t const * a) { poly8x8x2_t r; __builtin_neon_vld2_dup_v(&r, a, 5); return r; }
__ai poly16x4x2_t vld2_dup_p16(poly16_t const * a) { poly16x4x2_t r; __builtin_neon_vld2_dup_v(&r, a, 6); return r; }

#define vld2q_lane_u16(a, b, c) ({ uint16x8x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 25); r; })
#define vld2q_lane_u32(a, b, c) ({ uint32x4x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 26); r; })
#define vld2q_lane_s16(a, b, c) ({ int16x8x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 17); r; })
#define vld2q_lane_s32(a, b, c) ({ int32x4x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 18); r; })
#define vld2q_lane_f16(a, b, c) ({ float16x8x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 23); r; })
#define vld2q_lane_f32(a, b, c) ({ float32x4x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 20); r; })
#define vld2q_lane_p16(a, b, c) ({ poly16x8x2_t r; __builtin_neon_vld2q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 22); r; })
#define vld2_lane_u8(a, b, c) ({ uint8x8x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 8); r; })
#define vld2_lane_u16(a, b, c) ({ uint16x4x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 9); r; })
#define vld2_lane_u32(a, b, c) ({ uint32x2x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 10); r; })
#define vld2_lane_s8(a, b, c) ({ int8x8x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 0); r; })
#define vld2_lane_s16(a, b, c) ({ int16x4x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 1); r; })
#define vld2_lane_s32(a, b, c) ({ int32x2x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 2); r; })
#define vld2_lane_f16(a, b, c) ({ float16x4x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 7); r; })
#define vld2_lane_f32(a, b, c) ({ float32x2x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 4); r; })
#define vld2_lane_p8(a, b, c) ({ poly8x8x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 5); r; })
#define vld2_lane_p16(a, b, c) ({ poly16x4x2_t r; __builtin_neon_vld2_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (c), 6); r; })

__ai uint8x16x3_t vld3q_u8(uint8_t const * a) { uint8x16x3_t r; __builtin_neon_vld3q_v(&r, a, 24); return r; }
__ai uint16x8x3_t vld3q_u16(uint16_t const * a) { uint16x8x3_t r; __builtin_neon_vld3q_v(&r, a, 25); return r; }
__ai uint32x4x3_t vld3q_u32(uint32_t const * a) { uint32x4x3_t r; __builtin_neon_vld3q_v(&r, a, 26); return r; }
__ai int8x16x3_t vld3q_s8(int8_t const * a) { int8x16x3_t r; __builtin_neon_vld3q_v(&r, a, 16); return r; }
__ai int16x8x3_t vld3q_s16(int16_t const * a) { int16x8x3_t r; __builtin_neon_vld3q_v(&r, a, 17); return r; }
__ai int32x4x3_t vld3q_s32(int32_t const * a) { int32x4x3_t r; __builtin_neon_vld3q_v(&r, a, 18); return r; }
__ai float16x8x3_t vld3q_f16(float16_t const * a) { float16x8x3_t r; __builtin_neon_vld3q_v(&r, a, 23); return r; }
__ai float32x4x3_t vld3q_f32(float32_t const * a) { float32x4x3_t r; __builtin_neon_vld3q_v(&r, a, 20); return r; }
__ai poly8x16x3_t vld3q_p8(poly8_t const * a) { poly8x16x3_t r; __builtin_neon_vld3q_v(&r, a, 21); return r; }
__ai poly16x8x3_t vld3q_p16(poly16_t const * a) { poly16x8x3_t r; __builtin_neon_vld3q_v(&r, a, 22); return r; }
__ai uint8x8x3_t vld3_u8(uint8_t const * a) { uint8x8x3_t r; __builtin_neon_vld3_v(&r, a, 8); return r; }
__ai uint16x4x3_t vld3_u16(uint16_t const * a) { uint16x4x3_t r; __builtin_neon_vld3_v(&r, a, 9); return r; }
__ai uint32x2x3_t vld3_u32(uint32_t const * a) { uint32x2x3_t r; __builtin_neon_vld3_v(&r, a, 10); return r; }
__ai uint64x1x3_t vld3_u64(uint64_t const * a) { uint64x1x3_t r; __builtin_neon_vld3_v(&r, a, 11); return r; }
__ai int8x8x3_t vld3_s8(int8_t const * a) { int8x8x3_t r; __builtin_neon_vld3_v(&r, a, 0); return r; }
__ai int16x4x3_t vld3_s16(int16_t const * a) { int16x4x3_t r; __builtin_neon_vld3_v(&r, a, 1); return r; }
__ai int32x2x3_t vld3_s32(int32_t const * a) { int32x2x3_t r; __builtin_neon_vld3_v(&r, a, 2); return r; }
__ai int64x1x3_t vld3_s64(int64_t const * a) { int64x1x3_t r; __builtin_neon_vld3_v(&r, a, 3); return r; }
__ai float16x4x3_t vld3_f16(float16_t const * a) { float16x4x3_t r; __builtin_neon_vld3_v(&r, a, 7); return r; }
__ai float32x2x3_t vld3_f32(float32_t const * a) { float32x2x3_t r; __builtin_neon_vld3_v(&r, a, 4); return r; }
__ai poly8x8x3_t vld3_p8(poly8_t const * a) { poly8x8x3_t r; __builtin_neon_vld3_v(&r, a, 5); return r; }
__ai poly16x4x3_t vld3_p16(poly16_t const * a) { poly16x4x3_t r; __builtin_neon_vld3_v(&r, a, 6); return r; }

__ai uint8x8x3_t vld3_dup_u8(uint8_t const * a) { uint8x8x3_t r; __builtin_neon_vld3_dup_v(&r, a, 8); return r; }
__ai uint16x4x3_t vld3_dup_u16(uint16_t const * a) { uint16x4x3_t r; __builtin_neon_vld3_dup_v(&r, a, 9); return r; }
__ai uint32x2x3_t vld3_dup_u32(uint32_t const * a) { uint32x2x3_t r; __builtin_neon_vld3_dup_v(&r, a, 10); return r; }
__ai uint64x1x3_t vld3_dup_u64(uint64_t const * a) { uint64x1x3_t r; __builtin_neon_vld3_dup_v(&r, a, 11); return r; }
__ai int8x8x3_t vld3_dup_s8(int8_t const * a) { int8x8x3_t r; __builtin_neon_vld3_dup_v(&r, a, 0); return r; }
__ai int16x4x3_t vld3_dup_s16(int16_t const * a) { int16x4x3_t r; __builtin_neon_vld3_dup_v(&r, a, 1); return r; }
__ai int32x2x3_t vld3_dup_s32(int32_t const * a) { int32x2x3_t r; __builtin_neon_vld3_dup_v(&r, a, 2); return r; }
__ai int64x1x3_t vld3_dup_s64(int64_t const * a) { int64x1x3_t r; __builtin_neon_vld3_dup_v(&r, a, 3); return r; }
__ai float16x4x3_t vld3_dup_f16(float16_t const * a) { float16x4x3_t r; __builtin_neon_vld3_dup_v(&r, a, 7); return r; }
__ai float32x2x3_t vld3_dup_f32(float32_t const * a) { float32x2x3_t r; __builtin_neon_vld3_dup_v(&r, a, 4); return r; }
__ai poly8x8x3_t vld3_dup_p8(poly8_t const * a) { poly8x8x3_t r; __builtin_neon_vld3_dup_v(&r, a, 5); return r; }
__ai poly16x4x3_t vld3_dup_p16(poly16_t const * a) { poly16x4x3_t r; __builtin_neon_vld3_dup_v(&r, a, 6); return r; }

#define vld3q_lane_u16(a, b, c) ({ uint16x8x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 25); r; })
#define vld3q_lane_u32(a, b, c) ({ uint32x4x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 26); r; })
#define vld3q_lane_s16(a, b, c) ({ int16x8x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 17); r; })
#define vld3q_lane_s32(a, b, c) ({ int32x4x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 18); r; })
#define vld3q_lane_f16(a, b, c) ({ float16x8x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 23); r; })
#define vld3q_lane_f32(a, b, c) ({ float32x4x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 20); r; })
#define vld3q_lane_p16(a, b, c) ({ poly16x8x3_t r; __builtin_neon_vld3q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 22); r; })
#define vld3_lane_u8(a, b, c) ({ uint8x8x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 8); r; })
#define vld3_lane_u16(a, b, c) ({ uint16x4x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 9); r; })
#define vld3_lane_u32(a, b, c) ({ uint32x2x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 10); r; })
#define vld3_lane_s8(a, b, c) ({ int8x8x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 0); r; })
#define vld3_lane_s16(a, b, c) ({ int16x4x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 1); r; })
#define vld3_lane_s32(a, b, c) ({ int32x2x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 2); r; })
#define vld3_lane_f16(a, b, c) ({ float16x4x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 7); r; })
#define vld3_lane_f32(a, b, c) ({ float32x2x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 4); r; })
#define vld3_lane_p8(a, b, c) ({ poly8x8x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 5); r; })
#define vld3_lane_p16(a, b, c) ({ poly16x4x3_t r; __builtin_neon_vld3_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 6); r; })

__ai uint8x16x4_t vld4q_u8(uint8_t const * a) { uint8x16x4_t r; __builtin_neon_vld4q_v(&r, a, 24); return r; }
__ai uint16x8x4_t vld4q_u16(uint16_t const * a) { uint16x8x4_t r; __builtin_neon_vld4q_v(&r, a, 25); return r; }
__ai uint32x4x4_t vld4q_u32(uint32_t const * a) { uint32x4x4_t r; __builtin_neon_vld4q_v(&r, a, 26); return r; }
__ai int8x16x4_t vld4q_s8(int8_t const * a) { int8x16x4_t r; __builtin_neon_vld4q_v(&r, a, 16); return r; }
__ai int16x8x4_t vld4q_s16(int16_t const * a) { int16x8x4_t r; __builtin_neon_vld4q_v(&r, a, 17); return r; }
__ai int32x4x4_t vld4q_s32(int32_t const * a) { int32x4x4_t r; __builtin_neon_vld4q_v(&r, a, 18); return r; }
__ai float16x8x4_t vld4q_f16(float16_t const * a) { float16x8x4_t r; __builtin_neon_vld4q_v(&r, a, 23); return r; }
__ai float32x4x4_t vld4q_f32(float32_t const * a) { float32x4x4_t r; __builtin_neon_vld4q_v(&r, a, 20); return r; }
__ai poly8x16x4_t vld4q_p8(poly8_t const * a) { poly8x16x4_t r; __builtin_neon_vld4q_v(&r, a, 21); return r; }
__ai poly16x8x4_t vld4q_p16(poly16_t const * a) { poly16x8x4_t r; __builtin_neon_vld4q_v(&r, a, 22); return r; }
__ai uint8x8x4_t vld4_u8(uint8_t const * a) { uint8x8x4_t r; __builtin_neon_vld4_v(&r, a, 8); return r; }
__ai uint16x4x4_t vld4_u16(uint16_t const * a) { uint16x4x4_t r; __builtin_neon_vld4_v(&r, a, 9); return r; }
__ai uint32x2x4_t vld4_u32(uint32_t const * a) { uint32x2x4_t r; __builtin_neon_vld4_v(&r, a, 10); return r; }
__ai uint64x1x4_t vld4_u64(uint64_t const * a) { uint64x1x4_t r; __builtin_neon_vld4_v(&r, a, 11); return r; }
__ai int8x8x4_t vld4_s8(int8_t const * a) { int8x8x4_t r; __builtin_neon_vld4_v(&r, a, 0); return r; }
__ai int16x4x4_t vld4_s16(int16_t const * a) { int16x4x4_t r; __builtin_neon_vld4_v(&r, a, 1); return r; }
__ai int32x2x4_t vld4_s32(int32_t const * a) { int32x2x4_t r; __builtin_neon_vld4_v(&r, a, 2); return r; }
__ai int64x1x4_t vld4_s64(int64_t const * a) { int64x1x4_t r; __builtin_neon_vld4_v(&r, a, 3); return r; }
__ai float16x4x4_t vld4_f16(float16_t const * a) { float16x4x4_t r; __builtin_neon_vld4_v(&r, a, 7); return r; }
__ai float32x2x4_t vld4_f32(float32_t const * a) { float32x2x4_t r; __builtin_neon_vld4_v(&r, a, 4); return r; }
__ai poly8x8x4_t vld4_p8(poly8_t const * a) { poly8x8x4_t r; __builtin_neon_vld4_v(&r, a, 5); return r; }
__ai poly16x4x4_t vld4_p16(poly16_t const * a) { poly16x4x4_t r; __builtin_neon_vld4_v(&r, a, 6); return r; }

__ai uint8x8x4_t vld4_dup_u8(uint8_t const * a) { uint8x8x4_t r; __builtin_neon_vld4_dup_v(&r, a, 8); return r; }
__ai uint16x4x4_t vld4_dup_u16(uint16_t const * a) { uint16x4x4_t r; __builtin_neon_vld4_dup_v(&r, a, 9); return r; }
__ai uint32x2x4_t vld4_dup_u32(uint32_t const * a) { uint32x2x4_t r; __builtin_neon_vld4_dup_v(&r, a, 10); return r; }
__ai uint64x1x4_t vld4_dup_u64(uint64_t const * a) { uint64x1x4_t r; __builtin_neon_vld4_dup_v(&r, a, 11); return r; }
__ai int8x8x4_t vld4_dup_s8(int8_t const * a) { int8x8x4_t r; __builtin_neon_vld4_dup_v(&r, a, 0); return r; }
__ai int16x4x4_t vld4_dup_s16(int16_t const * a) { int16x4x4_t r; __builtin_neon_vld4_dup_v(&r, a, 1); return r; }
__ai int32x2x4_t vld4_dup_s32(int32_t const * a) { int32x2x4_t r; __builtin_neon_vld4_dup_v(&r, a, 2); return r; }
__ai int64x1x4_t vld4_dup_s64(int64_t const * a) { int64x1x4_t r; __builtin_neon_vld4_dup_v(&r, a, 3); return r; }
__ai float16x4x4_t vld4_dup_f16(float16_t const * a) { float16x4x4_t r; __builtin_neon_vld4_dup_v(&r, a, 7); return r; }
__ai float32x2x4_t vld4_dup_f32(float32_t const * a) { float32x2x4_t r; __builtin_neon_vld4_dup_v(&r, a, 4); return r; }
__ai poly8x8x4_t vld4_dup_p8(poly8_t const * a) { poly8x8x4_t r; __builtin_neon_vld4_dup_v(&r, a, 5); return r; }
__ai poly16x4x4_t vld4_dup_p16(poly16_t const * a) { poly16x4x4_t r; __builtin_neon_vld4_dup_v(&r, a, 6); return r; }

#define vld4q_lane_u16(a, b, c) ({ uint16x8x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 25); r; })
#define vld4q_lane_u32(a, b, c) ({ uint32x4x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 26); r; })
#define vld4q_lane_s16(a, b, c) ({ int16x8x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 17); r; })
#define vld4q_lane_s32(a, b, c) ({ int32x4x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 18); r; })
#define vld4q_lane_f16(a, b, c) ({ float16x8x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 23); r; })
#define vld4q_lane_f32(a, b, c) ({ float32x4x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 20); r; })
#define vld4q_lane_p16(a, b, c) ({ poly16x8x4_t r; __builtin_neon_vld4q_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 22); r; })
#define vld4_lane_u8(a, b, c) ({ uint8x8x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 8); r; })
#define vld4_lane_u16(a, b, c) ({ uint16x4x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 9); r; })
#define vld4_lane_u32(a, b, c) ({ uint32x2x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 10); r; })
#define vld4_lane_s8(a, b, c) ({ int8x8x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 0); r; })
#define vld4_lane_s16(a, b, c) ({ int16x4x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 1); r; })
#define vld4_lane_s32(a, b, c) ({ int32x2x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 2); r; })
#define vld4_lane_f16(a, b, c) ({ float16x4x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 7); r; })
#define vld4_lane_f32(a, b, c) ({ float32x2x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 4); r; })
#define vld4_lane_p8(a, b, c) ({ poly8x8x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 5); r; })
#define vld4_lane_p16(a, b, c) ({ poly16x4x4_t r; __builtin_neon_vld4_lane_v(&r, (a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 6); r; })

__ai int8x8_t vmax_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 0); return r; }
__ai int16x4_t vmax_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 1); return r; }
__ai int32x2_t vmax_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vmax_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vmax_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vmax_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 10); return r; }
__ai float32x2_t vmax_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vmax_v(a.val, b.val, 4); return r; }
__ai int8x16_t vmaxq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vmaxq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vmaxq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vmaxq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vmaxq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vmaxq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 26); return r; }
__ai float32x4_t vmaxq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = __builtin_neon_vmaxq_v(a.val, b.val, 20); return r; }

__ai int8x8_t vmin_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 0); return r; }
__ai int16x4_t vmin_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 1); return r; }
__ai int32x2_t vmin_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vmin_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vmin_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vmin_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 10); return r; }
__ai float32x2_t vmin_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vmin_v(a.val, b.val, 4); return r; }
__ai int8x16_t vminq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vminq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vminq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vminq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vminq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vminq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 26); return r; }
__ai float32x4_t vminq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = __builtin_neon_vminq_v(a.val, b.val, 20); return r; }

__ai int8x8_t vmla_s8(int8x8_t a, int8x8_t b, int8x8_t c) { int8x8_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai int16x4_t vmla_s16(int16x4_t a, int16x4_t b, int16x4_t c) { int16x4_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai int32x2_t vmla_s32(int32x2_t a, int32x2_t b, int32x2_t c) { int32x2_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai float32x2_t vmla_f32(float32x2_t a, float32x2_t b, float32x2_t c) { float32x2_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint8x8_t vmla_u8(uint8x8_t a, uint8x8_t b, uint8x8_t c) { uint8x8_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint16x4_t vmla_u16(uint16x4_t a, uint16x4_t b, uint16x4_t c) { uint16x4_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint32x2_t vmla_u32(uint32x2_t a, uint32x2_t b, uint32x2_t c) { uint32x2_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai int8x16_t vmlaq_s8(int8x16_t a, int8x16_t b, int8x16_t c) { int8x16_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai int16x8_t vmlaq_s16(int16x8_t a, int16x8_t b, int16x8_t c) { int16x8_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai int32x4_t vmlaq_s32(int32x4_t a, int32x4_t b, int32x4_t c) { int32x4_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai float32x4_t vmlaq_f32(float32x4_t a, float32x4_t b, float32x4_t c) { float32x4_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint8x16_t vmlaq_u8(uint8x16_t a, uint8x16_t b, uint8x16_t c) { uint8x16_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint16x8_t vmlaq_u16(uint16x8_t a, uint16x8_t b, uint16x8_t c) { uint16x8_t r; r.val = a.val + ( b.val * c.val ); return r; }
__ai uint32x4_t vmlaq_u32(uint32x4_t a, uint32x4_t b, uint32x4_t c) { uint32x4_t r; r.val = a.val + ( b.val * c.val ); return r; }

__ai int16x8_t vmlal_s8(int16x8_t a, int8x8_t b, int8x8_t c) { int16x8_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 17); return r; }
__ai int32x4_t vmlal_s16(int32x4_t a, int16x4_t b, int16x4_t c) { int32x4_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 18); return r; }
__ai int64x2_t vmlal_s32(int64x2_t a, int32x2_t b, int32x2_t c) { int64x2_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 19); return r; }
__ai uint16x8_t vmlal_u8(uint16x8_t a, uint8x8_t b, uint8x8_t c) { uint16x8_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 25); return r; }
__ai uint32x4_t vmlal_u16(uint32x4_t a, uint16x4_t b, uint16x4_t c) { uint32x4_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 26); return r; }
__ai uint64x2_t vmlal_u32(uint64x2_t a, uint32x2_t b, uint32x2_t c) { uint64x2_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, c.val, 27); return r; }

#define vmlal_lane_s16(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vmlal_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vmlal_lane_s32(a, b, c, d) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vmlal_lane_v((a).val, (b).val, (c).val, (d), 19)}
#define vmlal_lane_u16(a, b, c, d) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vmlal_lane_v((a).val, (b).val, (c).val, (d), 26)}
#define vmlal_lane_u32(a, b, c, d) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vmlal_lane_v((a).val, (b).val, (c).val, (d), 27)}

__ai int32x4_t vmlal_n_s16(int32x4_t a, int16x4_t b, int16_t c) { int32x4_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, (__neon_int16x4_t){ c, c, c, c }, 18); return r; }
__ai int64x2_t vmlal_n_s32(int64x2_t a, int32x2_t b, int32_t c) { int64x2_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, (__neon_int32x2_t){ c, c }, 19); return r; }
__ai uint32x4_t vmlal_n_u16(uint32x4_t a, uint16x4_t b, uint16_t c) { uint32x4_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, (__neon_uint16x4_t){ c, c, c, c }, 26); return r; }
__ai uint64x2_t vmlal_n_u32(uint64x2_t a, uint32x2_t b, uint32_t c) { uint64x2_t r; r.val = __builtin_neon_vmlal_v(a.val, b.val, (__neon_uint32x2_t){ c, c }, 27); return r; }

#define vmla_lane_s16(a, b, c, d) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vmla_lane_v((a).val, (b).val, (c).val, (d), 1)}
#define vmla_lane_s32(a, b, c, d) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vmla_lane_v((a).val, (b).val, (c).val, (d), 2)}
#define vmla_lane_u16(a, b, c, d) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vmla_lane_v((a).val, (b).val, (c).val, (d), 9)}
#define vmla_lane_u32(a, b, c, d) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vmla_lane_v((a).val, (b).val, (c).val, (d), 10)}
#define vmla_lane_f32(a, b, c, d) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vmla_lane_v((a).val, (b).val, (c).val, (d), 4)}
#define vmlaq_lane_s16(a, b, c, d) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vmlaq_lane_v((a).val, (b).val, (c).val, (d), 17)}
#define vmlaq_lane_s32(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vmlaq_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vmlaq_lane_u16(a, b, c, d) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vmlaq_lane_v((a).val, (b).val, (c).val, (d), 25)}
#define vmlaq_lane_u32(a, b, c, d) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vmlaq_lane_v((a).val, (b).val, (c).val, (d), 26)}
#define vmlaq_lane_f32(a, b, c, d) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vmlaq_lane_v((a).val, (b).val, (c).val, (d), 20)}

__ai int16x4_t vmla_n_s16(int16x4_t a, int16x4_t b, int16_t c) { int16x4_t r; r.val = a.val + ( b.val * (__neon_int16x4_t){ c, c, c, c } ); return r; }
__ai int32x2_t vmla_n_s32(int32x2_t a, int32x2_t b, int32_t c) { int32x2_t r; r.val = a.val + ( b.val * (__neon_int32x2_t){ c, c } ); return r; }
__ai uint16x4_t vmla_n_u16(uint16x4_t a, uint16x4_t b, uint16_t c) { uint16x4_t r; r.val = a.val + ( b.val * (__neon_uint16x4_t){ c, c, c, c } ); return r; }
__ai uint32x2_t vmla_n_u32(uint32x2_t a, uint32x2_t b, uint32_t c) { uint32x2_t r; r.val = a.val + ( b.val * (__neon_uint32x2_t){ c, c } ); return r; }
__ai float32x2_t vmla_n_f32(float32x2_t a, float32x2_t b, float32_t c) { float32x2_t r; r.val = a.val + ( b.val * (__neon_float32x2_t){ c, c } ); return r; }
__ai int16x8_t vmlaq_n_s16(int16x8_t a, int16x8_t b, int16_t c) { int16x8_t r; r.val = a.val + ( b.val * (__neon_int16x8_t){ c, c, c, c, c, c, c, c } ); return r; }
__ai int32x4_t vmlaq_n_s32(int32x4_t a, int32x4_t b, int32_t c) { int32x4_t r; r.val = a.val + ( b.val * (__neon_int32x4_t){ c, c, c, c } ); return r; }
__ai uint16x8_t vmlaq_n_u16(uint16x8_t a, uint16x8_t b, uint16_t c) { uint16x8_t r; r.val = a.val + ( b.val * (__neon_uint16x8_t){ c, c, c, c, c, c, c, c } ); return r; }
__ai uint32x4_t vmlaq_n_u32(uint32x4_t a, uint32x4_t b, uint32_t c) { uint32x4_t r; r.val = a.val + ( b.val * (__neon_uint32x4_t){ c, c, c, c } ); return r; }
__ai float32x4_t vmlaq_n_f32(float32x4_t a, float32x4_t b, float32_t c) { float32x4_t r; r.val = a.val + ( b.val * (__neon_float32x4_t){ c, c, c, c } ); return r; }

__ai int8x8_t vmls_s8(int8x8_t a, int8x8_t b, int8x8_t c) { int8x8_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai int16x4_t vmls_s16(int16x4_t a, int16x4_t b, int16x4_t c) { int16x4_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai int32x2_t vmls_s32(int32x2_t a, int32x2_t b, int32x2_t c) { int32x2_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai float32x2_t vmls_f32(float32x2_t a, float32x2_t b, float32x2_t c) { float32x2_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint8x8_t vmls_u8(uint8x8_t a, uint8x8_t b, uint8x8_t c) { uint8x8_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint16x4_t vmls_u16(uint16x4_t a, uint16x4_t b, uint16x4_t c) { uint16x4_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint32x2_t vmls_u32(uint32x2_t a, uint32x2_t b, uint32x2_t c) { uint32x2_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai int8x16_t vmlsq_s8(int8x16_t a, int8x16_t b, int8x16_t c) { int8x16_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai int16x8_t vmlsq_s16(int16x8_t a, int16x8_t b, int16x8_t c) { int16x8_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai int32x4_t vmlsq_s32(int32x4_t a, int32x4_t b, int32x4_t c) { int32x4_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai float32x4_t vmlsq_f32(float32x4_t a, float32x4_t b, float32x4_t c) { float32x4_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint8x16_t vmlsq_u8(uint8x16_t a, uint8x16_t b, uint8x16_t c) { uint8x16_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint16x8_t vmlsq_u16(uint16x8_t a, uint16x8_t b, uint16x8_t c) { uint16x8_t r; r.val = a.val - ( b.val * c.val ); return r; }
__ai uint32x4_t vmlsq_u32(uint32x4_t a, uint32x4_t b, uint32x4_t c) { uint32x4_t r; r.val = a.val - ( b.val * c.val ); return r; }

__ai int16x8_t vmlsl_s8(int16x8_t a, int8x8_t b, int8x8_t c) { int16x8_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 17); return r; }
__ai int32x4_t vmlsl_s16(int32x4_t a, int16x4_t b, int16x4_t c) { int32x4_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 18); return r; }
__ai int64x2_t vmlsl_s32(int64x2_t a, int32x2_t b, int32x2_t c) { int64x2_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 19); return r; }
__ai uint16x8_t vmlsl_u8(uint16x8_t a, uint8x8_t b, uint8x8_t c) { uint16x8_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 25); return r; }
__ai uint32x4_t vmlsl_u16(uint32x4_t a, uint16x4_t b, uint16x4_t c) { uint32x4_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 26); return r; }
__ai uint64x2_t vmlsl_u32(uint64x2_t a, uint32x2_t b, uint32x2_t c) { uint64x2_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, c.val, 27); return r; }

#define vmlsl_lane_s16(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vmlsl_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vmlsl_lane_s32(a, b, c, d) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vmlsl_lane_v((a).val, (b).val, (c).val, (d), 19)}
#define vmlsl_lane_u16(a, b, c, d) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vmlsl_lane_v((a).val, (b).val, (c).val, (d), 26)}
#define vmlsl_lane_u32(a, b, c, d) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vmlsl_lane_v((a).val, (b).val, (c).val, (d), 27)}

__ai int32x4_t vmlsl_n_s16(int32x4_t a, int16x4_t b, int16_t c) { int32x4_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, (__neon_int16x4_t){ c, c, c, c }, 18); return r; }
__ai int64x2_t vmlsl_n_s32(int64x2_t a, int32x2_t b, int32_t c) { int64x2_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, (__neon_int32x2_t){ c, c }, 19); return r; }
__ai uint32x4_t vmlsl_n_u16(uint32x4_t a, uint16x4_t b, uint16_t c) { uint32x4_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, (__neon_uint16x4_t){ c, c, c, c }, 26); return r; }
__ai uint64x2_t vmlsl_n_u32(uint64x2_t a, uint32x2_t b, uint32_t c) { uint64x2_t r; r.val = __builtin_neon_vmlsl_v(a.val, b.val, (__neon_uint32x2_t){ c, c }, 27); return r; }

#define vmls_lane_s16(a, b, c, d) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vmls_lane_v((a).val, (b).val, (c).val, (d), 1)}
#define vmls_lane_s32(a, b, c, d) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vmls_lane_v((a).val, (b).val, (c).val, (d), 2)}
#define vmls_lane_u16(a, b, c, d) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vmls_lane_v((a).val, (b).val, (c).val, (d), 9)}
#define vmls_lane_u32(a, b, c, d) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vmls_lane_v((a).val, (b).val, (c).val, (d), 10)}
#define vmls_lane_f32(a, b, c, d) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vmls_lane_v((a).val, (b).val, (c).val, (d), 4)}
#define vmlsq_lane_s16(a, b, c, d) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vmlsq_lane_v((a).val, (b).val, (c).val, (d), 17)}
#define vmlsq_lane_s32(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vmlsq_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vmlsq_lane_u16(a, b, c, d) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vmlsq_lane_v((a).val, (b).val, (c).val, (d), 25)}
#define vmlsq_lane_u32(a, b, c, d) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vmlsq_lane_v((a).val, (b).val, (c).val, (d), 26)}
#define vmlsq_lane_f32(a, b, c, d) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vmlsq_lane_v((a).val, (b).val, (c).val, (d), 20)}

__ai int16x4_t vmls_n_s16(int16x4_t a, int16x4_t b, int16_t c) { int16x4_t r; r.val = a.val - ( b.val * (__neon_int16x4_t){ c, c, c, c } ); return r; }
__ai int32x2_t vmls_n_s32(int32x2_t a, int32x2_t b, int32_t c) { int32x2_t r; r.val = a.val - ( b.val * (__neon_int32x2_t){ c, c } ); return r; }
__ai uint16x4_t vmls_n_u16(uint16x4_t a, uint16x4_t b, uint16_t c) { uint16x4_t r; r.val = a.val - ( b.val * (__neon_uint16x4_t){ c, c, c, c } ); return r; }
__ai uint32x2_t vmls_n_u32(uint32x2_t a, uint32x2_t b, uint32_t c) { uint32x2_t r; r.val = a.val - ( b.val * (__neon_uint32x2_t){ c, c } ); return r; }
__ai float32x2_t vmls_n_f32(float32x2_t a, float32x2_t b, float32_t c) { float32x2_t r; r.val = a.val - ( b.val * (__neon_float32x2_t){ c, c } ); return r; }
__ai int16x8_t vmlsq_n_s16(int16x8_t a, int16x8_t b, int16_t c) { int16x8_t r; r.val = a.val - ( b.val * (__neon_int16x8_t){ c, c, c, c, c, c, c, c } ); return r; }
__ai int32x4_t vmlsq_n_s32(int32x4_t a, int32x4_t b, int32_t c) { int32x4_t r; r.val = a.val - ( b.val * (__neon_int32x4_t){ c, c, c, c } ); return r; }
__ai uint16x8_t vmlsq_n_u16(uint16x8_t a, uint16x8_t b, uint16_t c) { uint16x8_t r; r.val = a.val - ( b.val * (__neon_uint16x8_t){ c, c, c, c, c, c, c, c } ); return r; }
__ai uint32x4_t vmlsq_n_u32(uint32x4_t a, uint32x4_t b, uint32_t c) { uint32x4_t r; r.val = a.val - ( b.val * (__neon_uint32x4_t){ c, c, c, c } ); return r; }
__ai float32x4_t vmlsq_n_f32(float32x4_t a, float32x4_t b, float32_t c) { float32x4_t r; r.val = a.val - ( b.val * (__neon_float32x4_t){ c, c, c, c } ); return r; }

__ai int16x8_t vmovl_s8(int8x8_t a) { int16x8_t r; r.val = __builtin_neon_vmovl_v(a.val, 17); return r; }
__ai int32x4_t vmovl_s16(int16x4_t a) { int32x4_t r; r.val = __builtin_neon_vmovl_v(a.val, 18); return r; }
__ai int64x2_t vmovl_s32(int32x2_t a) { int64x2_t r; r.val = __builtin_neon_vmovl_v(a.val, 19); return r; }
__ai uint16x8_t vmovl_u8(uint8x8_t a) { uint16x8_t r; r.val = __builtin_neon_vmovl_v(a.val, 25); return r; }
__ai uint32x4_t vmovl_u16(uint16x4_t a) { uint32x4_t r; r.val = __builtin_neon_vmovl_v(a.val, 26); return r; }
__ai uint64x2_t vmovl_u32(uint32x2_t a) { uint64x2_t r; r.val = __builtin_neon_vmovl_v(a.val, 27); return r; }

__ai int8x8_t vmovn_s16(int16x8_t a) { int8x8_t r; r.val = __builtin_neon_vmovn_v(a.val, 0); return r; }
__ai int16x4_t vmovn_s32(int32x4_t a) { int16x4_t r; r.val = __builtin_neon_vmovn_v(a.val, 1); return r; }
__ai int32x2_t vmovn_s64(int64x2_t a) { int32x2_t r; r.val = __builtin_neon_vmovn_v(a.val, 2); return r; }
__ai uint8x8_t vmovn_u16(uint16x8_t a) { uint8x8_t r; r.val = __builtin_neon_vmovn_v(a.val, 8); return r; }
__ai uint16x4_t vmovn_u32(uint32x4_t a) { uint16x4_t r; r.val = __builtin_neon_vmovn_v(a.val, 9); return r; }
__ai uint32x2_t vmovn_u64(uint64x2_t a) { uint32x2_t r; r.val = __builtin_neon_vmovn_v(a.val, 10); return r; }

__ai uint8x8_t vmov_n_u8(uint8_t a) { uint8x8_t r; r.val = (__neon_uint8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai uint16x4_t vmov_n_u16(uint16_t a) { uint16x4_t r; r.val = (__neon_uint16x4_t){ a, a, a, a }; return r; }
__ai uint32x2_t vmov_n_u32(uint32_t a) { uint32x2_t r; r.val = (__neon_uint32x2_t){ a, a }; return r; }
__ai int8x8_t vmov_n_s8(int8_t a) { int8x8_t r; r.val = (__neon_int8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai int16x4_t vmov_n_s16(int16_t a) { int16x4_t r; r.val = (__neon_int16x4_t){ a, a, a, a }; return r; }
__ai int32x2_t vmov_n_s32(int32_t a) { int32x2_t r; r.val = (__neon_int32x2_t){ a, a }; return r; }
__ai poly8x8_t vmov_n_p8(poly8_t a) { poly8x8_t r; r.val = (__neon_poly8x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai poly16x4_t vmov_n_p16(poly16_t a) { poly16x4_t r; r.val = (__neon_poly16x4_t){ a, a, a, a }; return r; }
__ai float32x2_t vmov_n_f32(float32_t a) { float32x2_t r; r.val = (__neon_float32x2_t){ a, a }; return r; }
__ai uint8x16_t vmovq_n_u8(uint8_t a) { uint8x16_t r; r.val = (__neon_uint8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai uint16x8_t vmovq_n_u16(uint16_t a) { uint16x8_t r; r.val = (__neon_uint16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai uint32x4_t vmovq_n_u32(uint32_t a) { uint32x4_t r; r.val = (__neon_uint32x4_t){ a, a, a, a }; return r; }
__ai int8x16_t vmovq_n_s8(int8_t a) { int8x16_t r; r.val = (__neon_int8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai int16x8_t vmovq_n_s16(int16_t a) { int16x8_t r; r.val = (__neon_int16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai int32x4_t vmovq_n_s32(int32_t a) { int32x4_t r; r.val = (__neon_int32x4_t){ a, a, a, a }; return r; }
__ai poly8x16_t vmovq_n_p8(poly8_t a) { poly8x16_t r; r.val = (__neon_poly8x16_t){ a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a }; return r; }
__ai poly16x8_t vmovq_n_p16(poly16_t a) { poly16x8_t r; r.val = (__neon_poly16x8_t){ a, a, a, a, a, a, a, a }; return r; }
__ai float32x4_t vmovq_n_f32(float32_t a) { float32x4_t r; r.val = (__neon_float32x4_t){ a, a, a, a }; return r; }
__ai int64x1_t vmov_n_s64(int64_t a) { int64x1_t r; r.val = (__neon_int64x1_t){ a }; return r; }
__ai uint64x1_t vmov_n_u64(uint64_t a) { uint64x1_t r; r.val = (__neon_uint64x1_t){ a }; return r; }
__ai int64x2_t vmovq_n_s64(int64_t a) { int64x2_t r; r.val = (__neon_int64x2_t){ a, a }; return r; }
__ai uint64x2_t vmovq_n_u64(uint64_t a) { uint64x2_t r; r.val = (__neon_uint64x2_t){ a, a }; return r; }

__ai int8x8_t vmul_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val * b.val; return r; }
__ai int16x4_t vmul_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val * b.val; return r; }
__ai int32x2_t vmul_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val * b.val; return r; }
__ai float32x2_t vmul_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = a.val * b.val; return r; }
__ai uint8x8_t vmul_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val * b.val; return r; }
__ai uint16x4_t vmul_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val * b.val; return r; }
__ai uint32x2_t vmul_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val * b.val; return r; }
__ai poly8x8_t vmul_p8(poly8x8_t a, poly8x8_t b) { poly8x8_t r; r.val = a.val * b.val; return r; }
__ai int8x16_t vmulq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val * b.val; return r; }
__ai int16x8_t vmulq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val * b.val; return r; }
__ai int32x4_t vmulq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val * b.val; return r; }
__ai float32x4_t vmulq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = a.val * b.val; return r; }
__ai uint8x16_t vmulq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val * b.val; return r; }
__ai uint16x8_t vmulq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val * b.val; return r; }
__ai uint32x4_t vmulq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val * b.val; return r; }
__ai poly8x16_t vmulq_p8(poly8x16_t a, poly8x16_t b) { poly8x16_t r; r.val = a.val * b.val; return r; }

__ai int16x8_t vmull_s8(int8x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 17); return r; }
__ai int32x4_t vmull_s16(int16x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 18); return r; }
__ai int64x2_t vmull_s32(int32x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vmull_u8(uint8x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vmull_u16(uint16x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vmull_u32(uint32x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 27); return r; }
__ai poly16x8_t vmull_p8(poly8x8_t a, poly8x8_t b) { poly16x8_t r; r.val = __builtin_neon_vmull_v(a.val, b.val, 22); return r; }

#define vmull_lane_s16(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vmull_lane_v((a).val, (b).val, (c), 18)}
#define vmull_lane_s32(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vmull_lane_v((a).val, (b).val, (c), 19)}
#define vmull_lane_u16(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vmull_lane_v((a).val, (b).val, (c), 26)}
#define vmull_lane_u32(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vmull_lane_v((a).val, (b).val, (c), 27)}

__ai int32x4_t vmull_n_s16(int16x4_t a, int16_t b) { int32x4_t r; r.val = __builtin_neon_vmull_v(a.val, (__neon_int16x4_t){ b, b, b, b }, 18); return r; }
__ai int64x2_t vmull_n_s32(int32x2_t a, int32_t b) { int64x2_t r; r.val = __builtin_neon_vmull_v(a.val, (__neon_int32x2_t){ b, b }, 19); return r; }
__ai uint32x4_t vmull_n_u16(uint16x4_t a, uint16_t b) { uint32x4_t r; r.val = __builtin_neon_vmull_v(a.val, (__neon_uint16x4_t){ b, b, b, b }, 26); return r; }
__ai uint64x2_t vmull_n_u32(uint32x2_t a, uint32_t b) { uint64x2_t r; r.val = __builtin_neon_vmull_v(a.val, (__neon_uint32x2_t){ b, b }, 27); return r; }

__ai int16x4_t vmul_n_s16(int16x4_t a, int16_t b) { int16x4_t r; r.val = a.val * (__neon_int16x4_t){ b, b, b, b }; return r; }
__ai int32x2_t vmul_n_s32(int32x2_t a, int32_t b) { int32x2_t r; r.val = a.val * (__neon_int32x2_t){ b, b }; return r; }
__ai float32x2_t vmul_n_f32(float32x2_t a, float32_t b) { float32x2_t r; r.val = a.val * (__neon_float32x2_t){ b, b }; return r; }
__ai uint16x4_t vmul_n_u16(uint16x4_t a, uint16_t b) { uint16x4_t r; r.val = a.val * (__neon_uint16x4_t){ b, b, b, b }; return r; }
__ai uint32x2_t vmul_n_u32(uint32x2_t a, uint32_t b) { uint32x2_t r; r.val = a.val * (__neon_uint32x2_t){ b, b }; return r; }
__ai int16x8_t vmulq_n_s16(int16x8_t a, int16_t b) { int16x8_t r; r.val = a.val * (__neon_int16x8_t){ b, b, b, b, b, b, b, b }; return r; }
__ai int32x4_t vmulq_n_s32(int32x4_t a, int32_t b) { int32x4_t r; r.val = a.val * (__neon_int32x4_t){ b, b, b, b }; return r; }
__ai float32x4_t vmulq_n_f32(float32x4_t a, float32_t b) { float32x4_t r; r.val = a.val * (__neon_float32x4_t){ b, b, b, b }; return r; }
__ai uint16x8_t vmulq_n_u16(uint16x8_t a, uint16_t b) { uint16x8_t r; r.val = a.val * (__neon_uint16x8_t){ b, b, b, b, b, b, b, b }; return r; }
__ai uint32x4_t vmulq_n_u32(uint32x4_t a, uint32_t b) { uint32x4_t r; r.val = a.val * (__neon_uint32x4_t){ b, b, b, b }; return r; }

__ai int8x8_t vmvn_s8(int8x8_t a) { int8x8_t r; r.val =  ~a.val; return r; }
__ai int16x4_t vmvn_s16(int16x4_t a) { int16x4_t r; r.val =  ~a.val; return r; }
__ai int32x2_t vmvn_s32(int32x2_t a) { int32x2_t r; r.val =  ~a.val; return r; }
__ai uint8x8_t vmvn_u8(uint8x8_t a) { uint8x8_t r; r.val =  ~a.val; return r; }
__ai uint16x4_t vmvn_u16(uint16x4_t a) { uint16x4_t r; r.val =  ~a.val; return r; }
__ai uint32x2_t vmvn_u32(uint32x2_t a) { uint32x2_t r; r.val =  ~a.val; return r; }
__ai poly8x8_t vmvn_p8(poly8x8_t a) { poly8x8_t r; r.val =  ~a.val; return r; }
__ai int8x16_t vmvnq_s8(int8x16_t a) { int8x16_t r; r.val =  ~a.val; return r; }
__ai int16x8_t vmvnq_s16(int16x8_t a) { int16x8_t r; r.val =  ~a.val; return r; }
__ai int32x4_t vmvnq_s32(int32x4_t a) { int32x4_t r; r.val =  ~a.val; return r; }
__ai uint8x16_t vmvnq_u8(uint8x16_t a) { uint8x16_t r; r.val =  ~a.val; return r; }
__ai uint16x8_t vmvnq_u16(uint16x8_t a) { uint16x8_t r; r.val =  ~a.val; return r; }
__ai uint32x4_t vmvnq_u32(uint32x4_t a) { uint32x4_t r; r.val =  ~a.val; return r; }
__ai poly8x16_t vmvnq_p8(poly8x16_t a) { poly8x16_t r; r.val =  ~a.val; return r; }

__ai int8x8_t vneg_s8(int8x8_t a) { int8x8_t r; r.val =  -a.val; return r; }
__ai int16x4_t vneg_s16(int16x4_t a) { int16x4_t r; r.val =  -a.val; return r; }
__ai int32x2_t vneg_s32(int32x2_t a) { int32x2_t r; r.val =  -a.val; return r; }
__ai float32x2_t vneg_f32(float32x2_t a) { float32x2_t r; r.val =  -a.val; return r; }
__ai int8x16_t vnegq_s8(int8x16_t a) { int8x16_t r; r.val =  -a.val; return r; }
__ai int16x8_t vnegq_s16(int16x8_t a) { int16x8_t r; r.val =  -a.val; return r; }
__ai int32x4_t vnegq_s32(int32x4_t a) { int32x4_t r; r.val =  -a.val; return r; }
__ai float32x4_t vnegq_f32(float32x4_t a) { float32x4_t r; r.val =  -a.val; return r; }

__ai int8x8_t vorn_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val | ~b.val; return r; }
__ai int16x4_t vorn_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val | ~b.val; return r; }
__ai int32x2_t vorn_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val | ~b.val; return r; }
__ai int64x1_t vorn_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val | ~b.val; return r; }
__ai uint8x8_t vorn_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val | ~b.val; return r; }
__ai uint16x4_t vorn_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val | ~b.val; return r; }
__ai uint32x2_t vorn_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val | ~b.val; return r; }
__ai uint64x1_t vorn_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val | ~b.val; return r; }
__ai int8x16_t vornq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val | ~b.val; return r; }
__ai int16x8_t vornq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val | ~b.val; return r; }
__ai int32x4_t vornq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val | ~b.val; return r; }
__ai int64x2_t vornq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val | ~b.val; return r; }
__ai uint8x16_t vornq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val | ~b.val; return r; }
__ai uint16x8_t vornq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val | ~b.val; return r; }
__ai uint32x4_t vornq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val | ~b.val; return r; }
__ai uint64x2_t vornq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val | ~b.val; return r; }

__ai int8x8_t vorr_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val | b.val; return r; }
__ai int16x4_t vorr_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val | b.val; return r; }
__ai int32x2_t vorr_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val | b.val; return r; }
__ai int64x1_t vorr_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val | b.val; return r; }
__ai uint8x8_t vorr_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val | b.val; return r; }
__ai uint16x4_t vorr_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val | b.val; return r; }
__ai uint32x2_t vorr_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val | b.val; return r; }
__ai uint64x1_t vorr_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val | b.val; return r; }
__ai int8x16_t vorrq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val | b.val; return r; }
__ai int16x8_t vorrq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val | b.val; return r; }
__ai int32x4_t vorrq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val | b.val; return r; }
__ai int64x2_t vorrq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val | b.val; return r; }
__ai uint8x16_t vorrq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val | b.val; return r; }
__ai uint16x8_t vorrq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val | b.val; return r; }
__ai uint32x4_t vorrq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val | b.val; return r; }
__ai uint64x2_t vorrq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val | b.val; return r; }

__ai int16x4_t vpadal_s8(int16x4_t a, int8x8_t b) { int16x4_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 1); return r; }
__ai int32x2_t vpadal_s16(int32x2_t a, int16x4_t b) { int32x2_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 2); return r; }
__ai int64x1_t vpadal_s32(int64x1_t a, int32x2_t b) { int64x1_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 3); return r; }
__ai uint16x4_t vpadal_u8(uint16x4_t a, uint8x8_t b) { uint16x4_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vpadal_u16(uint32x2_t a, uint16x4_t b) { uint32x2_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vpadal_u32(uint64x1_t a, uint32x2_t b) { uint64x1_t r; r.val = __builtin_neon_vpadal_v(a.val, b.val, 11); return r; }
__ai int16x8_t vpadalq_s8(int16x8_t a, int8x16_t b) { int16x8_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vpadalq_s16(int32x4_t a, int16x8_t b) { int32x4_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vpadalq_s32(int64x2_t a, int32x4_t b) { int64x2_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vpadalq_u8(uint16x8_t a, uint8x16_t b) { uint16x8_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vpadalq_u16(uint32x4_t a, uint16x8_t b) { uint32x4_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vpadalq_u32(uint64x2_t a, uint32x4_t b) { uint64x2_t r; r.val = __builtin_neon_vpadalq_v(a.val, b.val, 27); return r; }

__ai int8x8_t vpadd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 0); return r; }
__ai int16x4_t vpadd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 1); return r; }
__ai int32x2_t vpadd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vpadd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vpadd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vpadd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 10); return r; }
__ai float32x2_t vpadd_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vpadd_v(a.val, b.val, 4); return r; }

__ai int16x4_t vpaddl_s8(int8x8_t a) { int16x4_t r; r.val = __builtin_neon_vpaddl_v(a.val, 1); return r; }
__ai int32x2_t vpaddl_s16(int16x4_t a) { int32x2_t r; r.val = __builtin_neon_vpaddl_v(a.val, 2); return r; }
__ai int64x1_t vpaddl_s32(int32x2_t a) { int64x1_t r; r.val = __builtin_neon_vpaddl_v(a.val, 3); return r; }
__ai uint16x4_t vpaddl_u8(uint8x8_t a) { uint16x4_t r; r.val = __builtin_neon_vpaddl_v(a.val, 9); return r; }
__ai uint32x2_t vpaddl_u16(uint16x4_t a) { uint32x2_t r; r.val = __builtin_neon_vpaddl_v(a.val, 10); return r; }
__ai uint64x1_t vpaddl_u32(uint32x2_t a) { uint64x1_t r; r.val = __builtin_neon_vpaddl_v(a.val, 11); return r; }
__ai int16x8_t vpaddlq_s8(int8x16_t a) { int16x8_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 17); return r; }
__ai int32x4_t vpaddlq_s16(int16x8_t a) { int32x4_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 18); return r; }
__ai int64x2_t vpaddlq_s32(int32x4_t a) { int64x2_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 19); return r; }
__ai uint16x8_t vpaddlq_u8(uint8x16_t a) { uint16x8_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 25); return r; }
__ai uint32x4_t vpaddlq_u16(uint16x8_t a) { uint32x4_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 26); return r; }
__ai uint64x2_t vpaddlq_u32(uint32x4_t a) { uint64x2_t r; r.val = __builtin_neon_vpaddlq_v(a.val, 27); return r; }

__ai int8x8_t vpmax_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 0); return r; }
__ai int16x4_t vpmax_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 1); return r; }
__ai int32x2_t vpmax_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vpmax_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vpmax_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vpmax_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 10); return r; }
__ai float32x2_t vpmax_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vpmax_v(a.val, b.val, 4); return r; }

__ai int8x8_t vpmin_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 0); return r; }
__ai int16x4_t vpmin_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 1); return r; }
__ai int32x2_t vpmin_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vpmin_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vpmin_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vpmin_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 10); return r; }
__ai float32x2_t vpmin_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vpmin_v(a.val, b.val, 4); return r; }

__ai int8x8_t vqabs_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vqabs_v(a.val, 0); return r; }
__ai int16x4_t vqabs_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_neon_vqabs_v(a.val, 1); return r; }
__ai int32x2_t vqabs_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_neon_vqabs_v(a.val, 2); return r; }
__ai int8x16_t vqabsq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vqabsq_v(a.val, 16); return r; }
__ai int16x8_t vqabsq_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_neon_vqabsq_v(a.val, 17); return r; }
__ai int32x4_t vqabsq_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_neon_vqabsq_v(a.val, 18); return r; }

__ai int8x8_t vqadd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 0); return r; }
__ai int16x4_t vqadd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqadd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 2); return r; }
__ai int64x1_t vqadd_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vqadd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vqadd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vqadd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vqadd_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vqadd_v(a.val, b.val, 11); return r; }
__ai int8x16_t vqaddq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vqaddq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqaddq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vqaddq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vqaddq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vqaddq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vqaddq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vqaddq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vqaddq_v(a.val, b.val, 27); return r; }

__ai int32x4_t vqdmlal_s16(int32x4_t a, int16x4_t b, int16x4_t c) { int32x4_t r; r.val = __builtin_neon_vqdmlal_v(a.val, b.val, c.val, 18); return r; }
__ai int64x2_t vqdmlal_s32(int64x2_t a, int32x2_t b, int32x2_t c) { int64x2_t r; r.val = __builtin_neon_vqdmlal_v(a.val, b.val, c.val, 19); return r; }

#define vqdmlal_lane_s16(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqdmlal_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vqdmlal_lane_s32(a, b, c, d) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vqdmlal_lane_v((a).val, (b).val, (c).val, (d), 19)}

__ai int32x4_t vqdmlal_n_s16(int32x4_t a, int16x4_t b, int16_t c) { int32x4_t r; r.val = __builtin_neon_vqdmlal_v(a.val, b.val, (__neon_int16x4_t){ c, c, c, c }, 18); return r; }
__ai int64x2_t vqdmlal_n_s32(int64x2_t a, int32x2_t b, int32_t c) { int64x2_t r; r.val = __builtin_neon_vqdmlal_v(a.val, b.val, (__neon_int32x2_t){ c, c }, 19); return r; }

__ai int32x4_t vqdmlsl_s16(int32x4_t a, int16x4_t b, int16x4_t c) { int32x4_t r; r.val = __builtin_neon_vqdmlsl_v(a.val, b.val, c.val, 18); return r; }
__ai int64x2_t vqdmlsl_s32(int64x2_t a, int32x2_t b, int32x2_t c) { int64x2_t r; r.val = __builtin_neon_vqdmlsl_v(a.val, b.val, c.val, 19); return r; }

#define vqdmlsl_lane_s16(a, b, c, d) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqdmlsl_lane_v((a).val, (b).val, (c).val, (d), 18)}
#define vqdmlsl_lane_s32(a, b, c, d) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vqdmlsl_lane_v((a).val, (b).val, (c).val, (d), 19)}

__ai int32x4_t vqdmlsl_n_s16(int32x4_t a, int16x4_t b, int16_t c) { int32x4_t r; r.val = __builtin_neon_vqdmlsl_v(a.val, b.val, (__neon_int16x4_t){ c, c, c, c }, 18); return r; }
__ai int64x2_t vqdmlsl_n_s32(int64x2_t a, int32x2_t b, int32_t c) { int64x2_t r; r.val = __builtin_neon_vqdmlsl_v(a.val, b.val, (__neon_int32x2_t){ c, c }, 19); return r; }

__ai int16x4_t vqdmulh_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqdmulh_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqdmulh_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqdmulh_v(a.val, b.val, 2); return r; }
__ai int16x8_t vqdmulhq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqdmulhq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqdmulhq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqdmulhq_v(a.val, b.val, 18); return r; }

#define vqdmulh_lane_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vqdmulh_lane_v((a).val, (b).val, (c), 1)}
#define vqdmulh_lane_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vqdmulh_lane_v((a).val, (b).val, (c), 2)}
#define vqdmulhq_lane_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vqdmulhq_lane_v((a).val, (b).val, (c), 17)}
#define vqdmulhq_lane_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqdmulhq_lane_v((a).val, (b).val, (c), 18)}

__ai int16x4_t vqdmulh_n_s16(int16x4_t a, int16_t b) { int16x4_t r; r.val = __builtin_neon_vqdmulh_v(a.val, (__neon_int16x4_t){ b, b, b, b }, 1); return r; }
__ai int32x2_t vqdmulh_n_s32(int32x2_t a, int32_t b) { int32x2_t r; r.val = __builtin_neon_vqdmulh_v(a.val, (__neon_int32x2_t){ b, b }, 2); return r; }
__ai int16x8_t vqdmulhq_n_s16(int16x8_t a, int16_t b) { int16x8_t r; r.val = __builtin_neon_vqdmulhq_v(a.val, (__neon_int16x8_t){ b, b, b, b, b, b, b, b }, 17); return r; }
__ai int32x4_t vqdmulhq_n_s32(int32x4_t a, int32_t b) { int32x4_t r; r.val = __builtin_neon_vqdmulhq_v(a.val, (__neon_int32x4_t){ b, b, b, b }, 18); return r; }

__ai int32x4_t vqdmull_s16(int16x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vqdmull_v(a.val, b.val, 18); return r; }
__ai int64x2_t vqdmull_s32(int32x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vqdmull_v(a.val, b.val, 19); return r; }

#define vqdmull_lane_s16(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqdmull_lane_v((a).val, (b).val, (c), 18)}
#define vqdmull_lane_s32(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vqdmull_lane_v((a).val, (b).val, (c), 19)}

__ai int32x4_t vqdmull_n_s16(int16x4_t a, int16_t b) { int32x4_t r; r.val = __builtin_neon_vqdmull_v(a.val, (__neon_int16x4_t){ b, b, b, b }, 18); return r; }
__ai int64x2_t vqdmull_n_s32(int32x2_t a, int32_t b) { int64x2_t r; r.val = __builtin_neon_vqdmull_v(a.val, (__neon_int32x2_t){ b, b }, 19); return r; }

__ai int8x8_t vqmovn_s16(int16x8_t a) { int8x8_t r; r.val = __builtin_neon_vqmovn_v(a.val, 0); return r; }
__ai int16x4_t vqmovn_s32(int32x4_t a) { int16x4_t r; r.val = __builtin_neon_vqmovn_v(a.val, 1); return r; }
__ai int32x2_t vqmovn_s64(int64x2_t a) { int32x2_t r; r.val = __builtin_neon_vqmovn_v(a.val, 2); return r; }
__ai uint8x8_t vqmovn_u16(uint16x8_t a) { uint8x8_t r; r.val = __builtin_neon_vqmovn_v(a.val, 8); return r; }
__ai uint16x4_t vqmovn_u32(uint32x4_t a) { uint16x4_t r; r.val = __builtin_neon_vqmovn_v(a.val, 9); return r; }
__ai uint32x2_t vqmovn_u64(uint64x2_t a) { uint32x2_t r; r.val = __builtin_neon_vqmovn_v(a.val, 10); return r; }

__ai uint8x8_t vqmovun_s16(int16x8_t a) { uint8x8_t r; r.val = __builtin_neon_vqmovun_v(a.val, 8); return r; }
__ai uint16x4_t vqmovun_s32(int32x4_t a) { uint16x4_t r; r.val = __builtin_neon_vqmovun_v(a.val, 9); return r; }
__ai uint32x2_t vqmovun_s64(int64x2_t a) { uint32x2_t r; r.val = __builtin_neon_vqmovun_v(a.val, 10); return r; }

__ai int8x8_t vqneg_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_neon_vqneg_v(a.val, 0); return r; }
__ai int16x4_t vqneg_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_neon_vqneg_v(a.val, 1); return r; }
__ai int32x2_t vqneg_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_neon_vqneg_v(a.val, 2); return r; }
__ai int8x16_t vqnegq_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_neon_vqnegq_v(a.val, 16); return r; }
__ai int16x8_t vqnegq_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_neon_vqnegq_v(a.val, 17); return r; }
__ai int32x4_t vqnegq_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_neon_vqnegq_v(a.val, 18); return r; }

__ai int16x4_t vqrdmulh_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqrdmulh_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqrdmulh_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqrdmulh_v(a.val, b.val, 2); return r; }
__ai int16x8_t vqrdmulhq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqrdmulhq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqrdmulhq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqrdmulhq_v(a.val, b.val, 18); return r; }

#define vqrdmulh_lane_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vqrdmulh_lane_v((a).val, (b).val, (c), 1)}
#define vqrdmulh_lane_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vqrdmulh_lane_v((a).val, (b).val, (c), 2)}
#define vqrdmulhq_lane_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vqrdmulhq_lane_v((a).val, (b).val, (c), 17)}
#define vqrdmulhq_lane_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqrdmulhq_lane_v((a).val, (b).val, (c), 18)}

__ai int16x4_t vqrdmulh_n_s16(int16x4_t a, int16_t b) { int16x4_t r; r.val = __builtin_neon_vqrdmulh_v(a.val, (__neon_int16x4_t){ b, b, b, b }, 1); return r; }
__ai int32x2_t vqrdmulh_n_s32(int32x2_t a, int32_t b) { int32x2_t r; r.val = __builtin_neon_vqrdmulh_v(a.val, (__neon_int32x2_t){ b, b }, 2); return r; }
__ai int16x8_t vqrdmulhq_n_s16(int16x8_t a, int16_t b) { int16x8_t r; r.val = __builtin_neon_vqrdmulhq_v(a.val, (__neon_int16x8_t){ b, b, b, b, b, b, b, b }, 17); return r; }
__ai int32x4_t vqrdmulhq_n_s32(int32x4_t a, int32_t b) { int32x4_t r; r.val = __builtin_neon_vqrdmulhq_v(a.val, (__neon_int32x4_t){ b, b, b, b }, 18); return r; }

__ai int8x8_t vqrshl_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 0); return r; }
__ai int16x4_t vqrshl_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqrshl_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 2); return r; }
__ai int64x1_t vqrshl_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vqrshl_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vqrshl_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vqrshl_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vqrshl_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vqrshl_v(a.val, b.val, 11); return r; }
__ai int8x16_t vqrshlq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vqrshlq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqrshlq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vqrshlq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vqrshlq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vqrshlq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vqrshlq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vqrshlq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vqrshlq_v(a.val, b.val, 27); return r; }

#define vqrshrn_n_s16(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 0)}
#define vqrshrn_n_s32(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 1)}
#define vqrshrn_n_s64(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 2)}
#define vqrshrn_n_u16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 8)}
#define vqrshrn_n_u32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 9)}
#define vqrshrn_n_u64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqrshrn_n_v((a).val, (b), 10)}

#define vqrshrun_n_s16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqrshrun_n_v((a).val, (b), 8)}
#define vqrshrun_n_s32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqrshrun_n_v((a).val, (b), 9)}
#define vqrshrun_n_s64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqrshrun_n_v((a).val, (b), 10)}

__ai int8x8_t vqshl_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 0); return r; }
__ai int16x4_t vqshl_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqshl_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 2); return r; }
__ai int64x1_t vqshl_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vqshl_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vqshl_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vqshl_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vqshl_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vqshl_v(a.val, b.val, 11); return r; }
__ai int8x16_t vqshlq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vqshlq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqshlq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vqshlq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vqshlq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vqshlq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vqshlq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vqshlq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vqshlq_v(a.val, b.val, 27); return r; }

#define vqshlu_n_s8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqshlu_n_v((a).val, (b), 8)}
#define vqshlu_n_s16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqshlu_n_v((a).val, (b), 9)}
#define vqshlu_n_s32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqshlu_n_v((a).val, (b), 10)}
#define vqshlu_n_s64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vqshlu_n_v((a).val, (b), 11)}
#define vqshluq_n_s8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vqshluq_n_v((a).val, (b), 24)}
#define vqshluq_n_s16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vqshluq_n_v((a).val, (b), 25)}
#define vqshluq_n_s32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vqshluq_n_v((a).val, (b), 26)}
#define vqshluq_n_s64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vqshluq_n_v((a).val, (b), 27)}

#define vqshl_n_s8(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vqshl_n_v((a).val, (b), 0)}
#define vqshl_n_s16(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vqshl_n_v((a).val, (b), 1)}
#define vqshl_n_s32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vqshl_n_v((a).val, (b), 2)}
#define vqshl_n_s64(a, b) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vqshl_n_v((a).val, (b), 3)}
#define vqshl_n_u8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqshl_n_v((a).val, (b), 8)}
#define vqshl_n_u16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqshl_n_v((a).val, (b), 9)}
#define vqshl_n_u32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqshl_n_v((a).val, (b), 10)}
#define vqshl_n_u64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vqshl_n_v((a).val, (b), 11)}
#define vqshlq_n_s8(a, b) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vqshlq_n_v((a).val, (b), 16)}
#define vqshlq_n_s16(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vqshlq_n_v((a).val, (b), 17)}
#define vqshlq_n_s32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vqshlq_n_v((a).val, (b), 18)}
#define vqshlq_n_s64(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vqshlq_n_v((a).val, (b), 19)}
#define vqshlq_n_u8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vqshlq_n_v((a).val, (b), 24)}
#define vqshlq_n_u16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vqshlq_n_v((a).val, (b), 25)}
#define vqshlq_n_u32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vqshlq_n_v((a).val, (b), 26)}
#define vqshlq_n_u64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vqshlq_n_v((a).val, (b), 27)}

#define vqshrn_n_s16(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vqshrn_n_v((a).val, (b), 0)}
#define vqshrn_n_s32(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vqshrn_n_v((a).val, (b), 1)}
#define vqshrn_n_s64(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vqshrn_n_v((a).val, (b), 2)}
#define vqshrn_n_u16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqshrn_n_v((a).val, (b), 8)}
#define vqshrn_n_u32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqshrn_n_v((a).val, (b), 9)}
#define vqshrn_n_u64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqshrn_n_v((a).val, (b), 10)}

#define vqshrun_n_s16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vqshrun_n_v((a).val, (b), 8)}
#define vqshrun_n_s32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vqshrun_n_v((a).val, (b), 9)}
#define vqshrun_n_s64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vqshrun_n_v((a).val, (b), 10)}

__ai int8x8_t vqsub_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 0); return r; }
__ai int16x4_t vqsub_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 1); return r; }
__ai int32x2_t vqsub_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 2); return r; }
__ai int64x1_t vqsub_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vqsub_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vqsub_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vqsub_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vqsub_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vqsub_v(a.val, b.val, 11); return r; }
__ai int8x16_t vqsubq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vqsubq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vqsubq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vqsubq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vqsubq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vqsubq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vqsubq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vqsubq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vqsubq_v(a.val, b.val, 27); return r; }

__ai int8x8_t vraddhn_s8(int16x8_t a, int16x8_t b) { int8x8_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 0); return r; }
__ai int16x4_t vraddhn_s16(int32x4_t a, int32x4_t b) { int16x4_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 1); return r; }
__ai int32x2_t vraddhn_s32(int64x2_t a, int64x2_t b) { int32x2_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vraddhn_u8(uint16x8_t a, uint16x8_t b) { uint8x8_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vraddhn_u16(uint32x4_t a, uint32x4_t b) { uint16x4_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vraddhn_u32(uint64x2_t a, uint64x2_t b) { uint32x2_t r; r.val = __builtin_neon_vraddhn_v(a.val, b.val, 10); return r; }

__ai float32x2_t vrecpe_f32(float32x2_t a) { float32x2_t r; r.val = __builtin_neon_vrecpe_v(a.val, 4); return r; }
__ai uint32x2_t vrecpe_u32(uint32x2_t a) { uint32x2_t r; r.val = __builtin_neon_vrecpe_v(a.val, 10); return r; }
__ai float32x4_t vrecpeq_f32(float32x4_t a) { float32x4_t r; r.val = __builtin_neon_vrecpeq_v(a.val, 20); return r; }
__ai uint32x4_t vrecpeq_u32(uint32x4_t a) { uint32x4_t r; r.val = __builtin_neon_vrecpeq_v(a.val, 26); return r; }

__ai float32x2_t vrecps_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vrecps_v(a.val, b.val, 4); return r; }
__ai float32x4_t vrecpsq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = __builtin_neon_vrecpsq_v(a.val, b.val, 20); return r; }

__ai int8x8_t vrev16_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6); return r; }
__ai uint8x8_t vrev16_u8(uint8x8_t a) { uint8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6); return r; }
__ai poly8x8_t vrev16_p8(poly8x8_t a) { poly8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6); return r; }
__ai int8x16_t vrev16q_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14); return r; }
__ai uint8x16_t vrev16q_u8(uint8x16_t a) { uint8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14); return r; }
__ai poly8x16_t vrev16q_p8(poly8x16_t a) { poly8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14); return r; }

__ai int8x8_t vrev32_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai int16x4_t vrev32_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2); return r; }
__ai uint8x8_t vrev32_u8(uint8x8_t a) { uint8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai uint16x4_t vrev32_u16(uint16x4_t a) { uint16x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2); return r; }
__ai poly8x8_t vrev32_p8(poly8x8_t a) { poly8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai int8x16_t vrev32q_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8, 15, 14, 13, 12); return r; }
__ai int16x8_t vrev32q_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6); return r; }
__ai uint8x16_t vrev32q_u8(uint8x16_t a) { uint8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8, 15, 14, 13, 12); return r; }
__ai uint16x8_t vrev32q_u16(uint16x8_t a) { uint16x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2, 5, 4, 7, 6); return r; }
__ai poly8x16_t vrev32q_p8(poly8x16_t a) { poly8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8, 15, 14, 13, 12); return r; }

__ai int8x8_t vrev64_s8(int8x8_t a) { int8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0); return r; }
__ai int16x4_t vrev64_s16(int16x4_t a) { int16x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0); return r; }
__ai int32x2_t vrev64_s32(int32x2_t a) { int32x2_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0); return r; }
__ai uint8x8_t vrev64_u8(uint8x8_t a) { uint8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0); return r; }
__ai uint16x4_t vrev64_u16(uint16x4_t a) { uint16x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0); return r; }
__ai uint32x2_t vrev64_u32(uint32x2_t a) { uint32x2_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0); return r; }
__ai poly8x8_t vrev64_p8(poly8x8_t a) { poly8x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0); return r; }
__ai poly16x4_t vrev64_p16(poly16x4_t a) { poly16x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0); return r; }
__ai float32x2_t vrev64_f32(float32x2_t a) { float32x2_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0); return r; }
__ai int8x16_t vrev64q_s8(int8x16_t a) { int8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8); return r; }
__ai int16x8_t vrev64q_s16(int16x8_t a) { int16x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai int32x4_t vrev64q_s32(int32x4_t a) { int32x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2); return r; }
__ai uint8x16_t vrev64q_u8(uint8x16_t a) { uint8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8); return r; }
__ai uint16x8_t vrev64q_u16(uint16x8_t a) { uint16x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai uint32x4_t vrev64q_u32(uint32x4_t a) { uint32x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2); return r; }
__ai poly8x16_t vrev64q_p8(poly8x16_t a) { poly8x16_t r; r.val = __builtin_shufflevector(a.val, a.val, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8); return r; }
__ai poly16x8_t vrev64q_p16(poly16x8_t a) { poly16x8_t r; r.val = __builtin_shufflevector(a.val, a.val, 3, 2, 1, 0, 7, 6, 5, 4); return r; }
__ai float32x4_t vrev64q_f32(float32x4_t a) { float32x4_t r; r.val = __builtin_shufflevector(a.val, a.val, 1, 0, 3, 2); return r; }

__ai int8x8_t vrhadd_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 0); return r; }
__ai int16x4_t vrhadd_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 1); return r; }
__ai int32x2_t vrhadd_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vrhadd_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vrhadd_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vrhadd_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vrhadd_v(a.val, b.val, 10); return r; }
__ai int8x16_t vrhaddq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vrhaddq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vrhaddq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 18); return r; }
__ai uint8x16_t vrhaddq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vrhaddq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vrhaddq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vrhaddq_v(a.val, b.val, 26); return r; }

__ai int8x8_t vrshl_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 0); return r; }
__ai int16x4_t vrshl_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 1); return r; }
__ai int32x2_t vrshl_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 2); return r; }
__ai int64x1_t vrshl_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vrshl_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vrshl_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vrshl_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vrshl_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vrshl_v(a.val, b.val, 11); return r; }
__ai int8x16_t vrshlq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vrshlq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vrshlq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vrshlq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vrshlq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vrshlq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vrshlq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vrshlq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vrshlq_v(a.val, b.val, 27); return r; }

#define vrshrn_n_s16(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vrshrn_n_v((a).val, (b), 0)}
#define vrshrn_n_s32(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vrshrn_n_v((a).val, (b), 1)}
#define vrshrn_n_s64(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vrshrn_n_v((a).val, (b), 2)}
#define vrshrn_n_u16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vrshrn_n_v((a).val, (b), 8)}
#define vrshrn_n_u32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vrshrn_n_v((a).val, (b), 9)}
#define vrshrn_n_u64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vrshrn_n_v((a).val, (b), 10)}

#define vrshr_n_s8(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vrshr_n_v((a).val, (b), 0)}
#define vrshr_n_s16(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vrshr_n_v((a).val, (b), 1)}
#define vrshr_n_s32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vrshr_n_v((a).val, (b), 2)}
#define vrshr_n_s64(a, b) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vrshr_n_v((a).val, (b), 3)}
#define vrshr_n_u8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vrshr_n_v((a).val, (b), 8)}
#define vrshr_n_u16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vrshr_n_v((a).val, (b), 9)}
#define vrshr_n_u32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vrshr_n_v((a).val, (b), 10)}
#define vrshr_n_u64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vrshr_n_v((a).val, (b), 11)}
#define vrshrq_n_s8(a, b) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vrshrq_n_v((a).val, (b), 16)}
#define vrshrq_n_s16(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vrshrq_n_v((a).val, (b), 17)}
#define vrshrq_n_s32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vrshrq_n_v((a).val, (b), 18)}
#define vrshrq_n_s64(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vrshrq_n_v((a).val, (b), 19)}
#define vrshrq_n_u8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vrshrq_n_v((a).val, (b), 24)}
#define vrshrq_n_u16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vrshrq_n_v((a).val, (b), 25)}
#define vrshrq_n_u32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vrshrq_n_v((a).val, (b), 26)}
#define vrshrq_n_u64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vrshrq_n_v((a).val, (b), 27)}

__ai float32x2_t vrsqrte_f32(float32x2_t a) { float32x2_t r; r.val = __builtin_neon_vrsqrte_v(a.val, 4); return r; }
__ai uint32x2_t vrsqrte_u32(uint32x2_t a) { uint32x2_t r; r.val = __builtin_neon_vrsqrte_v(a.val, 10); return r; }
__ai float32x4_t vrsqrteq_f32(float32x4_t a) { float32x4_t r; r.val = __builtin_neon_vrsqrteq_v(a.val, 20); return r; }
__ai uint32x4_t vrsqrteq_u32(uint32x4_t a) { uint32x4_t r; r.val = __builtin_neon_vrsqrteq_v(a.val, 26); return r; }

__ai float32x2_t vrsqrts_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = __builtin_neon_vrsqrts_v(a.val, b.val, 4); return r; }
__ai float32x4_t vrsqrtsq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = __builtin_neon_vrsqrtsq_v(a.val, b.val, 20); return r; }

#define vrsra_n_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 0)}
#define vrsra_n_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 1)}
#define vrsra_n_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 2)}
#define vrsra_n_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 3)}
#define vrsra_n_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 8)}
#define vrsra_n_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 9)}
#define vrsra_n_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 10)}
#define vrsra_n_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vrsra_n_v((a).val, (b).val, (c), 11)}
#define vrsraq_n_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 16)}
#define vrsraq_n_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 17)}
#define vrsraq_n_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 18)}
#define vrsraq_n_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 19)}
#define vrsraq_n_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 24)}
#define vrsraq_n_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 25)}
#define vrsraq_n_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 26)}
#define vrsraq_n_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vrsraq_n_v((a).val, (b).val, (c), 27)}

__ai int8x8_t vrsubhn_s8(int16x8_t a, int16x8_t b) { int8x8_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 0); return r; }
__ai int16x4_t vrsubhn_s16(int32x4_t a, int32x4_t b) { int16x4_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 1); return r; }
__ai int32x2_t vrsubhn_s32(int64x2_t a, int64x2_t b) { int32x2_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vrsubhn_u8(uint16x8_t a, uint16x8_t b) { uint8x8_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vrsubhn_u16(uint32x4_t a, uint32x4_t b) { uint16x4_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vrsubhn_u32(uint64x2_t a, uint64x2_t b) { uint32x2_t r; r.val = __builtin_neon_vrsubhn_v(a.val, b.val, 10); return r; }

#define vset_lane_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vset_lane_i8((a), (b).val, (c))}
#define vset_lane_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vset_lane_i16((a), (b).val, (c))}
#define vset_lane_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vset_lane_i32((a), (b).val, (c))}
#define vset_lane_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vset_lane_i8((a), (b).val, (c))}
#define vset_lane_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vset_lane_i16((a), (b).val, (c))}
#define vset_lane_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vset_lane_i32((a), (b).val, (c))}
#define vset_lane_p8(a, b, c) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vset_lane_i8((a), (b).val, (c))}
#define vset_lane_p16(a, b, c) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vset_lane_i16((a), (b).val, (c))}
#define vset_lane_f32(a, b, c) (float32x2_t){(__neon_float32x2_t)__builtin_neon_vset_lane_f32((a), (b).val, (c))}
#define vsetq_lane_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vsetq_lane_i8((a), (b).val, (c))}
#define vsetq_lane_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vsetq_lane_i16((a), (b).val, (c))}
#define vsetq_lane_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vsetq_lane_i32((a), (b).val, (c))}
#define vsetq_lane_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vsetq_lane_i8((a), (b).val, (c))}
#define vsetq_lane_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vsetq_lane_i16((a), (b).val, (c))}
#define vsetq_lane_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vsetq_lane_i32((a), (b).val, (c))}
#define vsetq_lane_p8(a, b, c) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vsetq_lane_i8((a), (b).val, (c))}
#define vsetq_lane_p16(a, b, c) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vsetq_lane_i16((a), (b).val, (c))}
#define vsetq_lane_f32(a, b, c) (float32x4_t){(__neon_float32x4_t)__builtin_neon_vsetq_lane_f32((a), (b).val, (c))}
#define vset_lane_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vset_lane_i64((a), (b).val, (c))}
#define vset_lane_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vset_lane_i64((a), (b).val, (c))}
#define vsetq_lane_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vsetq_lane_i64((a), (b).val, (c))}
#define vsetq_lane_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vsetq_lane_i64((a), (b).val, (c))}

__ai int8x8_t vshl_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 0); return r; }
__ai int16x4_t vshl_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 1); return r; }
__ai int32x2_t vshl_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 2); return r; }
__ai int64x1_t vshl_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 3); return r; }
__ai uint8x8_t vshl_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vshl_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vshl_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 10); return r; }
__ai uint64x1_t vshl_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = __builtin_neon_vshl_v(a.val, b.val, 11); return r; }
__ai int8x16_t vshlq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 16); return r; }
__ai int16x8_t vshlq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 17); return r; }
__ai int32x4_t vshlq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 18); return r; }
__ai int64x2_t vshlq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 19); return r; }
__ai uint8x16_t vshlq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vshlq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vshlq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vshlq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = __builtin_neon_vshlq_v(a.val, b.val, 27); return r; }

#define vshll_n_s8(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vshll_n_v((a).val, (b), 17)}
#define vshll_n_s16(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vshll_n_v((a).val, (b), 18)}
#define vshll_n_s32(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vshll_n_v((a).val, (b), 19)}
#define vshll_n_u8(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vshll_n_v((a).val, (b), 25)}
#define vshll_n_u16(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vshll_n_v((a).val, (b), 26)}
#define vshll_n_u32(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vshll_n_v((a).val, (b), 27)}

#define vshl_n_s8(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vshl_n_v((a).val, (b), 0)}
#define vshl_n_s16(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vshl_n_v((a).val, (b), 1)}
#define vshl_n_s32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vshl_n_v((a).val, (b), 2)}
#define vshl_n_s64(a, b) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vshl_n_v((a).val, (b), 3)}
#define vshl_n_u8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vshl_n_v((a).val, (b), 8)}
#define vshl_n_u16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vshl_n_v((a).val, (b), 9)}
#define vshl_n_u32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vshl_n_v((a).val, (b), 10)}
#define vshl_n_u64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vshl_n_v((a).val, (b), 11)}
#define vshlq_n_s8(a, b) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vshlq_n_v((a).val, (b), 16)}
#define vshlq_n_s16(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vshlq_n_v((a).val, (b), 17)}
#define vshlq_n_s32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vshlq_n_v((a).val, (b), 18)}
#define vshlq_n_s64(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vshlq_n_v((a).val, (b), 19)}
#define vshlq_n_u8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vshlq_n_v((a).val, (b), 24)}
#define vshlq_n_u16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vshlq_n_v((a).val, (b), 25)}
#define vshlq_n_u32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vshlq_n_v((a).val, (b), 26)}
#define vshlq_n_u64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vshlq_n_v((a).val, (b), 27)}

#define vshrn_n_s16(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vshrn_n_v((a).val, (b), 0)}
#define vshrn_n_s32(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vshrn_n_v((a).val, (b), 1)}
#define vshrn_n_s64(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vshrn_n_v((a).val, (b), 2)}
#define vshrn_n_u16(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vshrn_n_v((a).val, (b), 8)}
#define vshrn_n_u32(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vshrn_n_v((a).val, (b), 9)}
#define vshrn_n_u64(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vshrn_n_v((a).val, (b), 10)}

#define vshr_n_s8(a, b) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vshr_n_v((a).val, (b), 0)}
#define vshr_n_s16(a, b) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vshr_n_v((a).val, (b), 1)}
#define vshr_n_s32(a, b) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vshr_n_v((a).val, (b), 2)}
#define vshr_n_s64(a, b) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vshr_n_v((a).val, (b), 3)}
#define vshr_n_u8(a, b) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vshr_n_v((a).val, (b), 8)}
#define vshr_n_u16(a, b) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vshr_n_v((a).val, (b), 9)}
#define vshr_n_u32(a, b) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vshr_n_v((a).val, (b), 10)}
#define vshr_n_u64(a, b) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vshr_n_v((a).val, (b), 11)}
#define vshrq_n_s8(a, b) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vshrq_n_v((a).val, (b), 16)}
#define vshrq_n_s16(a, b) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vshrq_n_v((a).val, (b), 17)}
#define vshrq_n_s32(a, b) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vshrq_n_v((a).val, (b), 18)}
#define vshrq_n_s64(a, b) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vshrq_n_v((a).val, (b), 19)}
#define vshrq_n_u8(a, b) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vshrq_n_v((a).val, (b), 24)}
#define vshrq_n_u16(a, b) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vshrq_n_v((a).val, (b), 25)}
#define vshrq_n_u32(a, b) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vshrq_n_v((a).val, (b), 26)}
#define vshrq_n_u64(a, b) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vshrq_n_v((a).val, (b), 27)}

#define vsli_n_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 0)}
#define vsli_n_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 1)}
#define vsli_n_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 2)}
#define vsli_n_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 3)}
#define vsli_n_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 8)}
#define vsli_n_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 9)}
#define vsli_n_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 10)}
#define vsli_n_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 11)}
#define vsli_n_p8(a, b, c) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 5)}
#define vsli_n_p16(a, b, c) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vsli_n_v((a).val, (b).val, (c), 6)}
#define vsliq_n_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 16)}
#define vsliq_n_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 17)}
#define vsliq_n_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 18)}
#define vsliq_n_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 19)}
#define vsliq_n_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 24)}
#define vsliq_n_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 25)}
#define vsliq_n_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 26)}
#define vsliq_n_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 27)}
#define vsliq_n_p8(a, b, c) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 21)}
#define vsliq_n_p16(a, b, c) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vsliq_n_v((a).val, (b).val, (c), 22)}

#define vsra_n_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 0)}
#define vsra_n_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 1)}
#define vsra_n_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 2)}
#define vsra_n_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 3)}
#define vsra_n_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 8)}
#define vsra_n_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 9)}
#define vsra_n_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 10)}
#define vsra_n_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vsra_n_v((a).val, (b).val, (c), 11)}
#define vsraq_n_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 16)}
#define vsraq_n_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 17)}
#define vsraq_n_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 18)}
#define vsraq_n_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 19)}
#define vsraq_n_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 24)}
#define vsraq_n_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 25)}
#define vsraq_n_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 26)}
#define vsraq_n_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vsraq_n_v((a).val, (b).val, (c), 27)}

#define vsri_n_s8(a, b, c) (int8x8_t){(__neon_int8x8_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 0)}
#define vsri_n_s16(a, b, c) (int16x4_t){(__neon_int16x4_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 1)}
#define vsri_n_s32(a, b, c) (int32x2_t){(__neon_int32x2_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 2)}
#define vsri_n_s64(a, b, c) (int64x1_t){(__neon_int64x1_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 3)}
#define vsri_n_u8(a, b, c) (uint8x8_t){(__neon_uint8x8_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 8)}
#define vsri_n_u16(a, b, c) (uint16x4_t){(__neon_uint16x4_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 9)}
#define vsri_n_u32(a, b, c) (uint32x2_t){(__neon_uint32x2_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 10)}
#define vsri_n_u64(a, b, c) (uint64x1_t){(__neon_uint64x1_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 11)}
#define vsri_n_p8(a, b, c) (poly8x8_t){(__neon_poly8x8_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 5)}
#define vsri_n_p16(a, b, c) (poly16x4_t){(__neon_poly16x4_t)__builtin_neon_vsri_n_v((a).val, (b).val, (c), 6)}
#define vsriq_n_s8(a, b, c) (int8x16_t){(__neon_int8x16_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 16)}
#define vsriq_n_s16(a, b, c) (int16x8_t){(__neon_int16x8_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 17)}
#define vsriq_n_s32(a, b, c) (int32x4_t){(__neon_int32x4_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 18)}
#define vsriq_n_s64(a, b, c) (int64x2_t){(__neon_int64x2_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 19)}
#define vsriq_n_u8(a, b, c) (uint8x16_t){(__neon_uint8x16_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 24)}
#define vsriq_n_u16(a, b, c) (uint16x8_t){(__neon_uint16x8_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 25)}
#define vsriq_n_u32(a, b, c) (uint32x4_t){(__neon_uint32x4_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 26)}
#define vsriq_n_u64(a, b, c) (uint64x2_t){(__neon_uint64x2_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 27)}
#define vsriq_n_p8(a, b, c) (poly8x16_t){(__neon_poly8x16_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 21)}
#define vsriq_n_p16(a, b, c) (poly16x8_t){(__neon_poly16x8_t)__builtin_neon_vsriq_n_v((a).val, (b).val, (c), 22)}

__ai void vst1q_u8(uint8_t * a, uint8x16_t b) { __builtin_neon_vst1q_v(a, b.val, 24); }
__ai void vst1q_u16(uint16_t * a, uint16x8_t b) { __builtin_neon_vst1q_v(a, b.val, 25); }
__ai void vst1q_u32(uint32_t * a, uint32x4_t b) { __builtin_neon_vst1q_v(a, b.val, 26); }
__ai void vst1q_u64(uint64_t * a, uint64x2_t b) { __builtin_neon_vst1q_v(a, b.val, 27); }
__ai void vst1q_s8(int8_t * a, int8x16_t b) { __builtin_neon_vst1q_v(a, b.val, 16); }
__ai void vst1q_s16(int16_t * a, int16x8_t b) { __builtin_neon_vst1q_v(a, b.val, 17); }
__ai void vst1q_s32(int32_t * a, int32x4_t b) { __builtin_neon_vst1q_v(a, b.val, 18); }
__ai void vst1q_s64(int64_t * a, int64x2_t b) { __builtin_neon_vst1q_v(a, b.val, 19); }
__ai void vst1q_f16(float16_t * a, float16x8_t b) { __builtin_neon_vst1q_v(a, b.val, 23); }
__ai void vst1q_f32(float32_t * a, float32x4_t b) { __builtin_neon_vst1q_v(a, b.val, 20); }
__ai void vst1q_p8(poly8_t * a, poly8x16_t b) { __builtin_neon_vst1q_v(a, b.val, 21); }
__ai void vst1q_p16(poly16_t * a, poly16x8_t b) { __builtin_neon_vst1q_v(a, b.val, 22); }
__ai void vst1_u8(uint8_t * a, uint8x8_t b) { __builtin_neon_vst1_v(a, b.val, 8); }
__ai void vst1_u16(uint16_t * a, uint16x4_t b) { __builtin_neon_vst1_v(a, b.val, 9); }
__ai void vst1_u32(uint32_t * a, uint32x2_t b) { __builtin_neon_vst1_v(a, b.val, 10); }
__ai void vst1_u64(uint64_t * a, uint64x1_t b) { __builtin_neon_vst1_v(a, b.val, 11); }
__ai void vst1_s8(int8_t * a, int8x8_t b) { __builtin_neon_vst1_v(a, b.val, 0); }
__ai void vst1_s16(int16_t * a, int16x4_t b) { __builtin_neon_vst1_v(a, b.val, 1); }
__ai void vst1_s32(int32_t * a, int32x2_t b) { __builtin_neon_vst1_v(a, b.val, 2); }
__ai void vst1_s64(int64_t * a, int64x1_t b) { __builtin_neon_vst1_v(a, b.val, 3); }
__ai void vst1_f16(float16_t * a, float16x4_t b) { __builtin_neon_vst1_v(a, b.val, 7); }
__ai void vst1_f32(float32_t * a, float32x2_t b) { __builtin_neon_vst1_v(a, b.val, 4); }
__ai void vst1_p8(poly8_t * a, poly8x8_t b) { __builtin_neon_vst1_v(a, b.val, 5); }
__ai void vst1_p16(poly16_t * a, poly16x4_t b) { __builtin_neon_vst1_v(a, b.val, 6); }

#define vst1q_lane_u8(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 24)
#define vst1q_lane_u16(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 25)
#define vst1q_lane_u32(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 26)
#define vst1q_lane_u64(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 27)
#define vst1q_lane_s8(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 16)
#define vst1q_lane_s16(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 17)
#define vst1q_lane_s32(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 18)
#define vst1q_lane_s64(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 19)
#define vst1q_lane_f16(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 23)
#define vst1q_lane_f32(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 20)
#define vst1q_lane_p8(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 21)
#define vst1q_lane_p16(a, b, c) __builtin_neon_vst1q_lane_v((a), (b).val, (c), 22)
#define vst1_lane_u8(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 8)
#define vst1_lane_u16(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 9)
#define vst1_lane_u32(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 10)
#define vst1_lane_u64(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 11)
#define vst1_lane_s8(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 0)
#define vst1_lane_s16(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 1)
#define vst1_lane_s32(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 2)
#define vst1_lane_s64(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 3)
#define vst1_lane_f16(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 7)
#define vst1_lane_f32(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 4)
#define vst1_lane_p8(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 5)
#define vst1_lane_p16(a, b, c) __builtin_neon_vst1_lane_v((a), (b).val, (c), 6)

__ai void vst2q_u8(uint8_t * a, uint8x16x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 24); }
__ai void vst2q_u16(uint16_t * a, uint16x8x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 25); }
__ai void vst2q_u32(uint32_t * a, uint32x4x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 26); }
__ai void vst2q_s8(int8_t * a, int8x16x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 16); }
__ai void vst2q_s16(int16_t * a, int16x8x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 17); }
__ai void vst2q_s32(int32_t * a, int32x4x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 18); }
__ai void vst2q_f16(float16_t * a, float16x8x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 23); }
__ai void vst2q_f32(float32_t * a, float32x4x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 20); }
__ai void vst2q_p8(poly8_t * a, poly8x16x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 21); }
__ai void vst2q_p16(poly16_t * a, poly16x8x2_t b) { __builtin_neon_vst2q_v(a, b.val[0].val, b.val[1].val, 22); }
__ai void vst2_u8(uint8_t * a, uint8x8x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 8); }
__ai void vst2_u16(uint16_t * a, uint16x4x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 9); }
__ai void vst2_u32(uint32_t * a, uint32x2x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 10); }
__ai void vst2_u64(uint64_t * a, uint64x1x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 11); }
__ai void vst2_s8(int8_t * a, int8x8x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 0); }
__ai void vst2_s16(int16_t * a, int16x4x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 1); }
__ai void vst2_s32(int32_t * a, int32x2x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 2); }
__ai void vst2_s64(int64_t * a, int64x1x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 3); }
__ai void vst2_f16(float16_t * a, float16x4x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 7); }
__ai void vst2_f32(float32_t * a, float32x2x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 4); }
__ai void vst2_p8(poly8_t * a, poly8x8x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 5); }
__ai void vst2_p16(poly16_t * a, poly16x4x2_t b) { __builtin_neon_vst2_v(a, b.val[0].val, b.val[1].val, 6); }

#define vst2q_lane_u16(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 25)
#define vst2q_lane_u32(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 26)
#define vst2q_lane_s16(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 17)
#define vst2q_lane_s32(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 18)
#define vst2q_lane_f16(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 23)
#define vst2q_lane_f32(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 20)
#define vst2q_lane_p16(a, b, c) __builtin_neon_vst2q_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 22)
#define vst2_lane_u8(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 8)
#define vst2_lane_u16(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 9)
#define vst2_lane_u32(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 10)
#define vst2_lane_s8(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 0)
#define vst2_lane_s16(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 1)
#define vst2_lane_s32(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 2)
#define vst2_lane_f16(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 7)
#define vst2_lane_f32(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 4)
#define vst2_lane_p8(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 5)
#define vst2_lane_p16(a, b, c) __builtin_neon_vst2_lane_v((a), (b).val[0].val, (b).val[1].val, (c), 6)

__ai void vst3q_u8(uint8_t * a, uint8x16x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 24); }
__ai void vst3q_u16(uint16_t * a, uint16x8x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 25); }
__ai void vst3q_u32(uint32_t * a, uint32x4x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 26); }
__ai void vst3q_s8(int8_t * a, int8x16x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 16); }
__ai void vst3q_s16(int16_t * a, int16x8x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 17); }
__ai void vst3q_s32(int32_t * a, int32x4x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 18); }
__ai void vst3q_f16(float16_t * a, float16x8x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 23); }
__ai void vst3q_f32(float32_t * a, float32x4x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 20); }
__ai void vst3q_p8(poly8_t * a, poly8x16x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 21); }
__ai void vst3q_p16(poly16_t * a, poly16x8x3_t b) { __builtin_neon_vst3q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 22); }
__ai void vst3_u8(uint8_t * a, uint8x8x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 8); }
__ai void vst3_u16(uint16_t * a, uint16x4x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 9); }
__ai void vst3_u32(uint32_t * a, uint32x2x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 10); }
__ai void vst3_u64(uint64_t * a, uint64x1x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 11); }
__ai void vst3_s8(int8_t * a, int8x8x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 0); }
__ai void vst3_s16(int16_t * a, int16x4x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 1); }
__ai void vst3_s32(int32_t * a, int32x2x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 2); }
__ai void vst3_s64(int64_t * a, int64x1x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 3); }
__ai void vst3_f16(float16_t * a, float16x4x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 7); }
__ai void vst3_f32(float32_t * a, float32x2x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 4); }
__ai void vst3_p8(poly8_t * a, poly8x8x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 5); }
__ai void vst3_p16(poly16_t * a, poly16x4x3_t b) { __builtin_neon_vst3_v(a, b.val[0].val, b.val[1].val, b.val[2].val, 6); }

#define vst3q_lane_u16(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 25)
#define vst3q_lane_u32(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 26)
#define vst3q_lane_s16(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 17)
#define vst3q_lane_s32(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 18)
#define vst3q_lane_f16(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 23)
#define vst3q_lane_f32(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 20)
#define vst3q_lane_p16(a, b, c) __builtin_neon_vst3q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 22)
#define vst3_lane_u8(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 8)
#define vst3_lane_u16(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 9)
#define vst3_lane_u32(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 10)
#define vst3_lane_s8(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 0)
#define vst3_lane_s16(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 1)
#define vst3_lane_s32(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 2)
#define vst3_lane_f16(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 7)
#define vst3_lane_f32(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 4)
#define vst3_lane_p8(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 5)
#define vst3_lane_p16(a, b, c) __builtin_neon_vst3_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (c), 6)

__ai void vst4q_u8(uint8_t * a, uint8x16x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 24); }
__ai void vst4q_u16(uint16_t * a, uint16x8x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 25); }
__ai void vst4q_u32(uint32_t * a, uint32x4x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 26); }
__ai void vst4q_s8(int8_t * a, int8x16x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 16); }
__ai void vst4q_s16(int16_t * a, int16x8x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 17); }
__ai void vst4q_s32(int32_t * a, int32x4x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 18); }
__ai void vst4q_f16(float16_t * a, float16x8x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 23); }
__ai void vst4q_f32(float32_t * a, float32x4x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 20); }
__ai void vst4q_p8(poly8_t * a, poly8x16x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 21); }
__ai void vst4q_p16(poly16_t * a, poly16x8x4_t b) { __builtin_neon_vst4q_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 22); }
__ai void vst4_u8(uint8_t * a, uint8x8x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 8); }
__ai void vst4_u16(uint16_t * a, uint16x4x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 9); }
__ai void vst4_u32(uint32_t * a, uint32x2x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 10); }
__ai void vst4_u64(uint64_t * a, uint64x1x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 11); }
__ai void vst4_s8(int8_t * a, int8x8x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 0); }
__ai void vst4_s16(int16_t * a, int16x4x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 1); }
__ai void vst4_s32(int32_t * a, int32x2x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 2); }
__ai void vst4_s64(int64_t * a, int64x1x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 3); }
__ai void vst4_f16(float16_t * a, float16x4x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 7); }
__ai void vst4_f32(float32_t * a, float32x2x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 4); }
__ai void vst4_p8(poly8_t * a, poly8x8x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 5); }
__ai void vst4_p16(poly16_t * a, poly16x4x4_t b) { __builtin_neon_vst4_v(a, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, 6); }

#define vst4q_lane_u16(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 25)
#define vst4q_lane_u32(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 26)
#define vst4q_lane_s16(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 17)
#define vst4q_lane_s32(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 18)
#define vst4q_lane_f16(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 23)
#define vst4q_lane_f32(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 20)
#define vst4q_lane_p16(a, b, c) __builtin_neon_vst4q_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 22)
#define vst4_lane_u8(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 8)
#define vst4_lane_u16(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 9)
#define vst4_lane_u32(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 10)
#define vst4_lane_s8(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 0)
#define vst4_lane_s16(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 1)
#define vst4_lane_s32(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 2)
#define vst4_lane_f16(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 7)
#define vst4_lane_f32(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 4)
#define vst4_lane_p8(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 5)
#define vst4_lane_p16(a, b, c) __builtin_neon_vst4_lane_v((a), (b).val[0].val, (b).val[1].val, (b).val[2].val, (b).val[3].val, (c), 6)

__ai int8x8_t vsub_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = a.val - b.val; return r; }
__ai int16x4_t vsub_s16(int16x4_t a, int16x4_t b) { int16x4_t r; r.val = a.val - b.val; return r; }
__ai int32x2_t vsub_s32(int32x2_t a, int32x2_t b) { int32x2_t r; r.val = a.val - b.val; return r; }
__ai int64x1_t vsub_s64(int64x1_t a, int64x1_t b) { int64x1_t r; r.val = a.val - b.val; return r; }
__ai float32x2_t vsub_f32(float32x2_t a, float32x2_t b) { float32x2_t r; r.val = a.val - b.val; return r; }
__ai uint8x8_t vsub_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = a.val - b.val; return r; }
__ai uint16x4_t vsub_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = a.val - b.val; return r; }
__ai uint32x2_t vsub_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = a.val - b.val; return r; }
__ai uint64x1_t vsub_u64(uint64x1_t a, uint64x1_t b) { uint64x1_t r; r.val = a.val - b.val; return r; }
__ai int8x16_t vsubq_s8(int8x16_t a, int8x16_t b) { int8x16_t r; r.val = a.val - b.val; return r; }
__ai int16x8_t vsubq_s16(int16x8_t a, int16x8_t b) { int16x8_t r; r.val = a.val - b.val; return r; }
__ai int32x4_t vsubq_s32(int32x4_t a, int32x4_t b) { int32x4_t r; r.val = a.val - b.val; return r; }
__ai int64x2_t vsubq_s64(int64x2_t a, int64x2_t b) { int64x2_t r; r.val = a.val - b.val; return r; }
__ai float32x4_t vsubq_f32(float32x4_t a, float32x4_t b) { float32x4_t r; r.val = a.val - b.val; return r; }
__ai uint8x16_t vsubq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = a.val - b.val; return r; }
__ai uint16x8_t vsubq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = a.val - b.val; return r; }
__ai uint32x4_t vsubq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = a.val - b.val; return r; }
__ai uint64x2_t vsubq_u64(uint64x2_t a, uint64x2_t b) { uint64x2_t r; r.val = a.val - b.val; return r; }

__ai int8x8_t vsubhn_s8(int16x8_t a, int16x8_t b) { int8x8_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 0); return r; }
__ai int16x4_t vsubhn_s16(int32x4_t a, int32x4_t b) { int16x4_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 1); return r; }
__ai int32x2_t vsubhn_s32(int64x2_t a, int64x2_t b) { int32x2_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 2); return r; }
__ai uint8x8_t vsubhn_u8(uint16x8_t a, uint16x8_t b) { uint8x8_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vsubhn_u16(uint32x4_t a, uint32x4_t b) { uint16x4_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vsubhn_u32(uint64x2_t a, uint64x2_t b) { uint32x2_t r; r.val = __builtin_neon_vsubhn_v(a.val, b.val, 10); return r; }

__ai int16x8_t vsubl_s8(int8x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 17); return r; }
__ai int32x4_t vsubl_s16(int16x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 18); return r; }
__ai int64x2_t vsubl_s32(int32x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vsubl_u8(uint8x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vsubl_u16(uint16x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vsubl_u32(uint32x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vsubl_v(a.val, b.val, 27); return r; }

__ai int16x8_t vsubw_s8(int16x8_t a, int8x8_t b) { int16x8_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 17); return r; }
__ai int32x4_t vsubw_s16(int32x4_t a, int16x4_t b) { int32x4_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 18); return r; }
__ai int64x2_t vsubw_s32(int64x2_t a, int32x2_t b) { int64x2_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 19); return r; }
__ai uint16x8_t vsubw_u8(uint16x8_t a, uint8x8_t b) { uint16x8_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vsubw_u16(uint32x4_t a, uint16x4_t b) { uint32x4_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 26); return r; }
__ai uint64x2_t vsubw_u32(uint64x2_t a, uint32x2_t b) { uint64x2_t r; r.val = __builtin_neon_vsubw_v(a.val, b.val, 27); return r; }

__ai uint8x8_t vtbl1_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtbl1_v(a.val, b.val, 8); return r; }
__ai int8x8_t vtbl1_s8(int8x8_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vtbl1_v(a.val, b.val, 0); return r; }
__ai poly8x8_t vtbl1_p8(poly8x8_t a, uint8x8_t b) { poly8x8_t r; r.val = __builtin_neon_vtbl1_v(a.val, b.val, 5); return r; }

__ai uint8x8_t vtbl2_u8(uint8x8x2_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtbl2_v(a.val[0].val, a.val[1].val, b.val, 8); return r; }
__ai int8x8_t vtbl2_s8(int8x8x2_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vtbl2_v(a.val[0].val, a.val[1].val, b.val, 0); return r; }
__ai poly8x8_t vtbl2_p8(poly8x8x2_t a, uint8x8_t b) { poly8x8_t r; r.val = __builtin_neon_vtbl2_v(a.val[0].val, a.val[1].val, b.val, 5); return r; }

__ai uint8x8_t vtbl3_u8(uint8x8x3_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtbl3_v(a.val[0].val, a.val[1].val, a.val[2].val, b.val, 8); return r; }
__ai int8x8_t vtbl3_s8(int8x8x3_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vtbl3_v(a.val[0].val, a.val[1].val, a.val[2].val, b.val, 0); return r; }
__ai poly8x8_t vtbl3_p8(poly8x8x3_t a, uint8x8_t b) { poly8x8_t r; r.val = __builtin_neon_vtbl3_v(a.val[0].val, a.val[1].val, a.val[2].val, b.val, 5); return r; }

__ai uint8x8_t vtbl4_u8(uint8x8x4_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtbl4_v(a.val[0].val, a.val[1].val, a.val[2].val, a.val[3].val, b.val, 8); return r; }
__ai int8x8_t vtbl4_s8(int8x8x4_t a, int8x8_t b) { int8x8_t r; r.val = __builtin_neon_vtbl4_v(a.val[0].val, a.val[1].val, a.val[2].val, a.val[3].val, b.val, 0); return r; }
__ai poly8x8_t vtbl4_p8(poly8x8x4_t a, uint8x8_t b) { poly8x8_t r; r.val = __builtin_neon_vtbl4_v(a.val[0].val, a.val[1].val, a.val[2].val, a.val[3].val, b.val, 5); return r; }

__ai uint8x8_t vtbx1_u8(uint8x8_t a, uint8x8_t b, uint8x8_t c) { uint8x8_t r; r.val = __builtin_neon_vtbx1_v(a.val, b.val, c.val, 8); return r; }
__ai int8x8_t vtbx1_s8(int8x8_t a, int8x8_t b, int8x8_t c) { int8x8_t r; r.val = __builtin_neon_vtbx1_v(a.val, b.val, c.val, 0); return r; }
__ai poly8x8_t vtbx1_p8(poly8x8_t a, poly8x8_t b, uint8x8_t c) { poly8x8_t r; r.val = __builtin_neon_vtbx1_v(a.val, b.val, c.val, 5); return r; }

__ai uint8x8_t vtbx2_u8(uint8x8_t a, uint8x8x2_t b, uint8x8_t c) { uint8x8_t r; r.val = __builtin_neon_vtbx2_v(a.val, b.val[0].val, b.val[1].val, c.val, 8); return r; }
__ai int8x8_t vtbx2_s8(int8x8_t a, int8x8x2_t b, int8x8_t c) { int8x8_t r; r.val = __builtin_neon_vtbx2_v(a.val, b.val[0].val, b.val[1].val, c.val, 0); return r; }
__ai poly8x8_t vtbx2_p8(poly8x8_t a, poly8x8x2_t b, uint8x8_t c) { poly8x8_t r; r.val = __builtin_neon_vtbx2_v(a.val, b.val[0].val, b.val[1].val, c.val, 5); return r; }

__ai uint8x8_t vtbx3_u8(uint8x8_t a, uint8x8x3_t b, uint8x8_t c) { uint8x8_t r; r.val = __builtin_neon_vtbx3_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, c.val, 8); return r; }
__ai int8x8_t vtbx3_s8(int8x8_t a, int8x8x3_t b, int8x8_t c) { int8x8_t r; r.val = __builtin_neon_vtbx3_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, c.val, 0); return r; }
__ai poly8x8_t vtbx3_p8(poly8x8_t a, poly8x8x3_t b, uint8x8_t c) { poly8x8_t r; r.val = __builtin_neon_vtbx3_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, c.val, 5); return r; }

__ai uint8x8_t vtbx4_u8(uint8x8_t a, uint8x8x4_t b, uint8x8_t c) { uint8x8_t r; r.val = __builtin_neon_vtbx4_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, c.val, 8); return r; }
__ai int8x8_t vtbx4_s8(int8x8_t a, int8x8x4_t b, int8x8_t c) { int8x8_t r; r.val = __builtin_neon_vtbx4_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, c.val, 0); return r; }
__ai poly8x8_t vtbx4_p8(poly8x8_t a, poly8x8x4_t b, uint8x8_t c) { poly8x8_t r; r.val = __builtin_neon_vtbx4_v(a.val, b.val[0].val, b.val[1].val, b.val[2].val, b.val[3].val, c.val, 5); return r; }

__ai int8x8x2_t vtrn_s8(int8x8_t a, int8x8_t b) { int8x8x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 0); return r; }
__ai int16x4x2_t vtrn_s16(int16x4_t a, int16x4_t b) { int16x4x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 1); return r; }
__ai int32x2x2_t vtrn_s32(int32x2_t a, int32x2_t b) { int32x2x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 2); return r; }
__ai uint8x8x2_t vtrn_u8(uint8x8_t a, uint8x8_t b) { uint8x8x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 8); return r; }
__ai uint16x4x2_t vtrn_u16(uint16x4_t a, uint16x4_t b) { uint16x4x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 9); return r; }
__ai uint32x2x2_t vtrn_u32(uint32x2_t a, uint32x2_t b) { uint32x2x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 10); return r; }
__ai float32x2x2_t vtrn_f32(float32x2_t a, float32x2_t b) { float32x2x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 4); return r; }
__ai poly8x8x2_t vtrn_p8(poly8x8_t a, poly8x8_t b) { poly8x8x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 5); return r; }
__ai poly16x4x2_t vtrn_p16(poly16x4_t a, poly16x4_t b) { poly16x4x2_t r; __builtin_neon_vtrn_v(&r, a.val, b.val, 6); return r; }
__ai int8x16x2_t vtrnq_s8(int8x16_t a, int8x16_t b) { int8x16x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 16); return r; }
__ai int16x8x2_t vtrnq_s16(int16x8_t a, int16x8_t b) { int16x8x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 17); return r; }
__ai int32x4x2_t vtrnq_s32(int32x4_t a, int32x4_t b) { int32x4x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 18); return r; }
__ai uint8x16x2_t vtrnq_u8(uint8x16_t a, uint8x16_t b) { uint8x16x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 24); return r; }
__ai uint16x8x2_t vtrnq_u16(uint16x8_t a, uint16x8_t b) { uint16x8x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 25); return r; }
__ai uint32x4x2_t vtrnq_u32(uint32x4_t a, uint32x4_t b) { uint32x4x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 26); return r; }
__ai float32x4x2_t vtrnq_f32(float32x4_t a, float32x4_t b) { float32x4x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 20); return r; }
__ai poly8x16x2_t vtrnq_p8(poly8x16_t a, poly8x16_t b) { poly8x16x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 21); return r; }
__ai poly16x8x2_t vtrnq_p16(poly16x8_t a, poly16x8_t b) { poly16x8x2_t r; __builtin_neon_vtrnq_v(&r, a.val, b.val, 22); return r; }

__ai uint8x8_t vtst_s8(int8x8_t a, int8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vtst_s16(int16x4_t a, int16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vtst_s32(int32x2_t a, int32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 10); return r; }
__ai uint8x8_t vtst_u8(uint8x8_t a, uint8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 8); return r; }
__ai uint16x4_t vtst_u16(uint16x4_t a, uint16x4_t b) { uint16x4_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 9); return r; }
__ai uint32x2_t vtst_u32(uint32x2_t a, uint32x2_t b) { uint32x2_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 10); return r; }
__ai uint8x8_t vtst_p8(poly8x8_t a, poly8x8_t b) { uint8x8_t r; r.val = __builtin_neon_vtst_v(a.val, b.val, 8); return r; }
__ai uint8x16_t vtstq_s8(int8x16_t a, int8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vtstq_s16(int16x8_t a, int16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vtstq_s32(int32x4_t a, int32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 26); return r; }
__ai uint8x16_t vtstq_u8(uint8x16_t a, uint8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 24); return r; }
__ai uint16x8_t vtstq_u16(uint16x8_t a, uint16x8_t b) { uint16x8_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 25); return r; }
__ai uint32x4_t vtstq_u32(uint32x4_t a, uint32x4_t b) { uint32x4_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 26); return r; }
__ai uint8x16_t vtstq_p8(poly8x16_t a, poly8x16_t b) { uint8x16_t r; r.val = __builtin_neon_vtstq_v(a.val, b.val, 24); return r; }

__ai int8x8x2_t vuzp_s8(int8x8_t a, int8x8_t b) { int8x8x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 0); return r; }
__ai int16x4x2_t vuzp_s16(int16x4_t a, int16x4_t b) { int16x4x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 1); return r; }
__ai int32x2x2_t vuzp_s32(int32x2_t a, int32x2_t b) { int32x2x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 2); return r; }
__ai uint8x8x2_t vuzp_u8(uint8x8_t a, uint8x8_t b) { uint8x8x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 8); return r; }
__ai uint16x4x2_t vuzp_u16(uint16x4_t a, uint16x4_t b) { uint16x4x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 9); return r; }
__ai uint32x2x2_t vuzp_u32(uint32x2_t a, uint32x2_t b) { uint32x2x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 10); return r; }
__ai float32x2x2_t vuzp_f32(float32x2_t a, float32x2_t b) { float32x2x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 4); return r; }
__ai poly8x8x2_t vuzp_p8(poly8x8_t a, poly8x8_t b) { poly8x8x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 5); return r; }
__ai poly16x4x2_t vuzp_p16(poly16x4_t a, poly16x4_t b) { poly16x4x2_t r; __builtin_neon_vuzp_v(&r, a.val, b.val, 6); return r; }
__ai int8x16x2_t vuzpq_s8(int8x16_t a, int8x16_t b) { int8x16x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 16); return r; }
__ai int16x8x2_t vuzpq_s16(int16x8_t a, int16x8_t b) { int16x8x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 17); return r; }
__ai int32x4x2_t vuzpq_s32(int32x4_t a, int32x4_t b) { int32x4x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 18); return r; }
__ai uint8x16x2_t vuzpq_u8(uint8x16_t a, uint8x16_t b) { uint8x16x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 24); return r; }
__ai uint16x8x2_t vuzpq_u16(uint16x8_t a, uint16x8_t b) { uint16x8x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 25); return r; }
__ai uint32x4x2_t vuzpq_u32(uint32x4_t a, uint32x4_t b) { uint32x4x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 26); return r; }
__ai float32x4x2_t vuzpq_f32(float32x4_t a, float32x4_t b) { float32x4x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 20); return r; }
__ai poly8x16x2_t vuzpq_p8(poly8x16_t a, poly8x16_t b) { poly8x16x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 21); return r; }
__ai poly16x8x2_t vuzpq_p16(poly16x8_t a, poly16x8_t b) { poly16x8x2_t r; __builtin_neon_vuzpq_v(&r, a.val, b.val, 22); return r; }

__ai int8x8x2_t vzip_s8(int8x8_t a, int8x8_t b) { int8x8x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 0); return r; }
__ai int16x4x2_t vzip_s16(int16x4_t a, int16x4_t b) { int16x4x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 1); return r; }
__ai uint8x8x2_t vzip_u8(uint8x8_t a, uint8x8_t b) { uint8x8x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 8); return r; }
__ai uint16x4x2_t vzip_u16(uint16x4_t a, uint16x4_t b) { uint16x4x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 9); return r; }
__ai float32x2x2_t vzip_f32(float32x2_t a, float32x2_t b) { float32x2x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 4); return r; }
__ai poly8x8x2_t vzip_p8(poly8x8_t a, poly8x8_t b) { poly8x8x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 5); return r; }
__ai poly16x4x2_t vzip_p16(poly16x4_t a, poly16x4_t b) { poly16x4x2_t r; __builtin_neon_vzip_v(&r, a.val, b.val, 6); return r; }
__ai int8x16x2_t vzipq_s8(int8x16_t a, int8x16_t b) { int8x16x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 16); return r; }
__ai int16x8x2_t vzipq_s16(int16x8_t a, int16x8_t b) { int16x8x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 17); return r; }
__ai int32x4x2_t vzipq_s32(int32x4_t a, int32x4_t b) { int32x4x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 18); return r; }
__ai uint8x16x2_t vzipq_u8(uint8x16_t a, uint8x16_t b) { uint8x16x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 24); return r; }
__ai uint16x8x2_t vzipq_u16(uint16x8_t a, uint16x8_t b) { uint16x8x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 25); return r; }
__ai uint32x4x2_t vzipq_u32(uint32x4_t a, uint32x4_t b) { uint32x4x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 26); return r; }
__ai float32x4x2_t vzipq_f32(float32x4_t a, float32x4_t b) { float32x4x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 20); return r; }
__ai poly8x16x2_t vzipq_p8(poly8x16_t a, poly8x16_t b) { poly8x16x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 21); return r; }
__ai poly16x8x2_t vzipq_p16(poly16x8_t a, poly16x8_t b) { poly16x8x2_t r; __builtin_neon_vzipq_v(&r, a.val, b.val, 22); return r; }

#undef __ai

#endif /* __ARM_NEON_H */
