<?php

/**
 * @file
 * Filled installation of Drupal 6.17, for test purposes.
 *
 * This file was generated by the dump-database-d6.sh tool, from an
 * installation of Drupal 6, filled with data using the generate-d6-content.sh
 * tool. It has the following modules installed:
 *  - block
 *  - color
 *  - comment
 *  - dblog
 *  - filter
 *  - help
 *  - menu
 *  - node
 *  - path
 *  - poll
 *  - system
 *  - taxonomy
 *  - update
 *  - user
 */

db_create_table('access', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'mask' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'module' => 'user',
  'name' => 'access',
));

db_create_table('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'description' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'module' => 'system',
  'name' => 'actions',
));
db_insert('actions')->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'description',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'description' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish comment',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'description' => 'Make post sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'description' => 'Make post unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'description' => 'Promote post to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'description' => 'Publish post',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'description' => 'Save post',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'description' => 'Remove post from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish post',
))
->values(array(
  'aid' => 'user_block_ip_action',
  'type' => 'user',
  'callback' => 'user_block_ip_action',
  'parameters' => '',
  'description' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'description' => 'Block current user',
))
->execute();

db_create_table('actions_aid', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'module' => 'system',
  'name' => 'actions_aid',
));

db_create_table('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'authname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'unique keys' => array(
    'authname' => array(
      'authname',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'module' => 'user',
  'name' => 'authmap',
));

db_create_table('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
    ),
    'batch' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'indexes' => array(
    'token' => array(
      'token',
    ),
  ),
  'module' => 'system',
  'name' => 'batch',
));

db_create_table('blocks', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'region' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'tmd' => array(
      'theme',
      'module',
      'delta',
    ),
  ),
  'indexes' => array(
    'list' => array(
      'theme',
      'status',
      'region',
      'weight',
      'module',
    ),
  ),
  'module' => 'block',
  'name' => 'blocks',
));
db_insert('blocks')->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'throttle',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'user',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '10',
  'region' => 'footer',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();

db_create_table('blocks_roles', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'delta' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'module' => 'block',
  'name' => 'blocks_roles',
));

db_create_table('boxes', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'info' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'format' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'unique keys' => array(
    'info' => array(
      'info',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'module' => 'block',
  'name' => 'boxes',
));

db_create_table('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache',
));

db_create_table('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'block',
  'name' => 'cache_block',
));

db_create_table('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'filter',
  'name' => 'cache_filter',
));

db_create_table('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_form',
));

db_create_table('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_menu',
));

db_create_table('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_page',
));

db_create_table('cache_update', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'update',
  'name' => 'cache_update',
));

db_create_table('comments', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'subject' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'comment' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'format' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
    'thread' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => FALSE,
    ),
    'mail' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => FALSE,
    ),
    'homepage' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'indexes' => array(
    'pid' => array(
      'pid',
    ),
    'nid' => array(
      'nid',
    ),
    'status' => array(
      'status',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'comment',
  'name' => 'comments',
));

db_create_table('files', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'filepath' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'timestamp' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'uid' => array(
      'uid',
    ),
    'status' => array(
      'status',
    ),
    'timestamp' => array(
      'timestamp',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'module' => 'system',
  'name' => 'files',
));

db_create_table('filter_formats', array(
  'fields' => array(
    'format' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'roles' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'module' => 'filter',
  'name' => 'filter_formats',
));
db_insert('filter_formats')->fields(array(
  'format',
  'name',
  'roles',
  'cache',
))
->values(array(
  'format' => '1',
  'name' => 'Filtered HTML',
  'roles' => ',1,2,',
  'cache' => '1',
))
->values(array(
  'format' => '2',
  'name' => 'Full HTML',
  'roles' => '',
  'cache' => '1',
))
->values(array(
  'format' => '3',
  'name' => 'Escape HTML Filter',
  'roles' => '',
  'cache' => '1',
))
->execute();

db_create_table('filters', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'fmd' => array(
      'format',
      'module',
      'delta',
    ),
  ),
  'indexes' => array(
    'list' => array(
      'format',
      'weight',
      'module',
      'delta',
    ),
  ),
  'module' => 'filter',
  'name' => 'filters',
));
db_insert('filters')->fields(array(
  'fid',
  'format',
  'module',
  'delta',
  'weight',
))
->values(array(
  'fid' => '1',
  'format' => '1',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '2',
  'format' => '1',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '3',
  'format' => '1',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '4',
  'format' => '1',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '5',
  'format' => '2',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '6',
  'format' => '2',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '1',
))
->values(array(
  'fid' => '7',
  'format' => '2',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->execute();

db_create_table('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'event' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'indexes' => array(
    'allow' => array(
      'event',
      'hostname',
      'timestamp',
    ),
  ),
  'module' => 'system',
  'name' => 'flood',
));

db_create_table('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'module' => 'system',
  'name' => 'history',
));

db_create_table('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'module' => 'menu',
  'name' => 'menu_custom',
));
db_insert('menu_custom')->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.',
))
->values(array(
  'menu_name' => 'primary-links',
  'title' => 'Primary links',
  'description' => 'Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.',
))
->values(array(
  'menu_name' => 'secondary-links',
  'title' => 'Secondary links',
  'description' => 'Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links',
))
->execute();

db_create_table('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'p1' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p2' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p3' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p4' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p5' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p6' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p7' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p8' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p9' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
  ),
  'indexes' => array(
    'path_menu' => array(
      array(
        'link_path',
        128,
      ),
      'menu_name',
    ),
    'menu_plid_expand_child' => array(
      'menu_name',
      'plid',
      'expanded',
      'has_children',
    ),
    'menu_parents' => array(
      'menu_name',
      'p1',
      'p2',
      'p3',
      'p4',
      'p5',
      'p6',
      'p7',
      'p8',
      'p9',
    ),
    'router_path' => array(
      array(
        'router_path',
        128,
      ),
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'module' => 'system',
  'name' => 'menu_links',
));
db_insert('menu_links')->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'batch',
  'router_path' => 'batch',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administer',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'node',
  'router_path' => 'node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'logout',
  'router_path' => 'logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'rss.xml',
  'router_path' => 'rss.xml',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '6',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '6',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '7',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '7',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '8',
  'plid' => '2',
  'link_path' => 'admin/compact',
  'router_path' => 'admin/compact',
  'link_title' => 'Compact mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '9',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '9',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '10',
  'plid' => '2',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:27:\"Manage your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '11',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Create content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '11',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '12',
  'plid' => '0',
  'link_path' => 'comment/delete',
  'router_path' => 'comment/delete',
  'link_title' => 'Delete comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '12',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '13',
  'plid' => '0',
  'link_path' => 'comment/edit',
  'router_path' => 'comment/edit',
  'link_title' => 'Edit comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '13',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'system/files',
  'router_path' => 'system/files',
  'link_title' => 'File download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '15',
  'plid' => '2',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"View reports from system logs and other status information.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '16',
  'plid' => '2',
  'link_path' => 'admin/build',
  'router_path' => 'admin/build',
  'link_title' => 'Site building',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Control how your site looks and feels.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '17',
  'plid' => '2',
  'link_path' => 'admin/settings',
  'router_path' => 'admin/settings',
  'link_title' => 'Site configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Adjust basic site configuration options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '18',
  'plid' => '0',
  'link_path' => 'user/autocomplete',
  'router_path' => 'user/autocomplete',
  'link_title' => 'User autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '18',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '19',
  'plid' => '2',
  'link_path' => 'admin/user',
  'router_path' => 'admin/user',
  'link_title' => 'User management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:61:\"Manage your site's users, groups and access to site features.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '20',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '20',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '21',
  'plid' => '19',
  'link_path' => 'admin/user/rules',
  'router_path' => 'admin/user/rules',
  'link_title' => 'Access rules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:80:"List and create rules to disallow usernames, e-mail addresses, and IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '21',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '22',
  'plid' => '17',
  'link_path' => 'admin/settings/actions',
  'router_path' => 'admin/settings/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '22',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '17',
  'link_path' => 'admin/settings/admin',
  'router_path' => 'admin/settings/admin',
  'link_title' => 'Administration theme',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Settings for how your administrative pages should look.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '23',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '24',
  'plid' => '16',
  'link_path' => 'admin/build/block',
  'router_path' => 'admin/build/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '24',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '25',
  'plid' => '17',
  'link_path' => 'admin/settings/clean-urls',
  'router_path' => 'admin/settings/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '25',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '26',
  'plid' => '10',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"List and edit site comments and the comment moderation queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '26',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '27',
  'plid' => '10',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View, edit, and delete your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '27',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '28',
  'plid' => '10',
  'link_path' => 'admin/content/types',
  'router_path' => 'admin/content/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Manage posts by content type, including default status, front page promotion, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '17',
  'link_path' => 'admin/settings/date-time',
  'router_path' => 'admin/settings/date-time',
  'link_title' => 'Date and time',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Settings for how Drupal displays date and time, as well as the system's default timezone.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '29',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '30',
  'plid' => '0',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '30',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '31',
  'plid' => '20',
  'link_path' => 'user/%/delete',
  'router_path' => 'user/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '20',
  'p2' => '31',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '32',
  'plid' => '17',
  'link_path' => 'admin/settings/error-reporting',
  'router_path' => 'admin/settings/error-reporting',
  'link_title' => 'Error reporting',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:93:"Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '33',
  'plid' => '17',
  'link_path' => 'admin/settings/file-system',
  'router_path' => 'admin/settings/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '34',
  'plid' => '17',
  'link_path' => 'admin/settings/image-toolkit',
  'router_path' => 'admin/settings/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '35',
  'plid' => '17',
  'link_path' => 'admin/settings/filters',
  'router_path' => 'admin/settings/filters',
  'link_title' => 'Input formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '35',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '36',
  'plid' => '17',
  'link_path' => 'admin/settings/logging',
  'router_path' => 'admin/settings/logging',
  'link_title' => 'Logging and alerts',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:156:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '36',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '37',
  'plid' => '16',
  'link_path' => 'admin/build/menu',
  'router_path' => 'admin/build/menu',
  'link_title' => 'Menus',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Control your site's navigation menu, primary links and secondary links. as well as rename and reorganize menu items.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '38',
  'plid' => '16',
  'link_path' => 'admin/build/modules',
  'router_path' => 'admin/build/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Enable or disable add-on modules for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '38',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '17',
  'link_path' => 'admin/settings/performance',
  'router_path' => 'admin/settings/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '39',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '40',
  'plid' => '19',
  'link_path' => 'admin/user/permissions',
  'router_path' => 'admin/user/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '41',
  'plid' => '10',
  'link_path' => 'admin/content/node-settings',
  'router_path' => 'admin/content/node-settings',
  'link_title' => 'Post settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:126:"Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '42',
  'plid' => '10',
  'link_path' => 'admin/content/rss-publishing',
  'router_path' => 'admin/content/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Configure the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '43',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Reply to comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '43',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '44',
  'plid' => '19',
  'link_path' => 'admin/user/roles',
  'router_path' => 'admin/user/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '45',
  'plid' => '17',
  'link_path' => 'admin/settings/site-information',
  'router_path' => 'admin/settings/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:107:"Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '46',
  'plid' => '17',
  'link_path' => 'admin/settings/site-maintenance',
  'router_path' => 'admin/settings/site-maintenance',
  'link_title' => 'Site maintenance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Take the site off-line for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '47',
  'plid' => '15',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '47',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '48',
  'plid' => '16',
  'link_path' => 'admin/build/themes',
  'router_path' => 'admin/build/themes',
  'link_title' => 'Themes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Change which theme your site uses or allows users to set.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '48',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '19',
  'link_path' => 'admin/user/settings',
  'router_path' => 'admin/user/settings',
  'link_title' => 'User settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Configure default behavior of users, including registration requirements, e-mails, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '49',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '50',
  'plid' => '19',
  'link_path' => 'admin/user/user',
  'router_path' => 'admin/user/user',
  'link_title' => 'Users',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"List, add, and edit users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '51',
  'plid' => '35',
  'link_path' => 'admin/settings/filters/%',
  'router_path' => 'admin/settings/filters/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '35',
  'p4' => '51',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '52',
  'plid' => '25',
  'link_path' => 'admin/settings/clean-urls/check',
  'router_path' => 'admin/settings/clean-urls/check',
  'link_title' => 'Clean URL check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '25',
  'p4' => '52',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '53',
  'plid' => '22',
  'link_path' => 'admin/settings/actions/configure',
  'router_path' => 'admin/settings/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '22',
  'p4' => '53',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '54',
  'plid' => '24',
  'link_path' => 'admin/build/block/configure',
  'router_path' => 'admin/build/block/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '24',
  'p4' => '54',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '55',
  'plid' => '16',
  'link_path' => 'admin/build/menu-customize/%',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '55',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '56',
  'plid' => '29',
  'link_path' => 'admin/settings/date-time/lookup',
  'router_path' => 'admin/settings/date-time/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '29',
  'p4' => '56',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '57',
  'plid' => '24',
  'link_path' => 'admin/build/block/delete',
  'router_path' => 'admin/build/block/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '24',
  'p4' => '57',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '58',
  'plid' => '35',
  'link_path' => 'admin/settings/filters/delete',
  'router_path' => 'admin/settings/filters/delete',
  'link_title' => 'Delete input format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '35',
  'p4' => '58',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '59',
  'plid' => '21',
  'link_path' => 'admin/user/rules/delete',
  'router_path' => 'admin/user/rules/delete',
  'link_title' => 'Delete rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '21',
  'p4' => '59',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '60',
  'plid' => '44',
  'link_path' => 'admin/user/roles/edit',
  'router_path' => 'admin/user/roles/edit',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '44',
  'p4' => '60',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '61',
  'plid' => '21',
  'link_path' => 'admin/user/rules/edit',
  'router_path' => 'admin/user/rules/edit',
  'link_title' => 'Edit rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '21',
  'p4' => '61',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '62',
  'plid' => '47',
  'link_path' => 'admin/reports/status/php',
  'router_path' => 'admin/reports/status/php',
  'link_title' => 'PHP',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '47',
  'p4' => '62',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '63',
  'plid' => '41',
  'link_path' => 'admin/content/node-settings/rebuild',
  'router_path' => 'admin/content/node-settings/rebuild',
  'link_title' => 'Rebuild permissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '41',
  'p4' => '63',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '64',
  'plid' => '22',
  'link_path' => 'admin/settings/actions/orphan',
  'router_path' => 'admin/settings/actions/orphan',
  'link_title' => 'Remove orphans',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '22',
  'p4' => '64',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '65',
  'plid' => '47',
  'link_path' => 'admin/reports/status/run-cron',
  'router_path' => 'admin/reports/status/run-cron',
  'link_title' => 'Run cron',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '47',
  'p4' => '65',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '66',
  'plid' => '47',
  'link_path' => 'admin/reports/status/sql',
  'router_path' => 'admin/reports/status/sql',
  'link_title' => 'SQL',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '47',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '67',
  'plid' => '22',
  'link_path' => 'admin/settings/actions/delete/%',
  'router_path' => 'admin/settings/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '22',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '68',
  'plid' => '0',
  'link_path' => 'admin/build/menu-customize/%/delete',
  'router_path' => 'admin/build/menu-customize/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '68',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '69',
  'plid' => '24',
  'link_path' => 'admin/build/block/list/js',
  'router_path' => 'admin/build/block/list/js',
  'link_title' => 'JavaScript List Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '24',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '70',
  'plid' => '38',
  'link_path' => 'admin/build/modules/list/confirm',
  'router_path' => 'admin/build/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '38',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '71',
  'plid' => '0',
  'link_path' => 'user/reset/%/%/%',
  'router_path' => 'user/reset/%/%/%',
  'link_title' => 'Reset password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '71',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '72',
  'plid' => '38',
  'link_path' => 'admin/build/modules/uninstall/confirm',
  'router_path' => 'admin/build/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '38',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '73',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '73',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '74',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '74',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '75',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '75',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '76',
  'plid' => '37',
  'link_path' => 'admin/build/menu/item/%/delete',
  'router_path' => 'admin/build/menu/item/%/delete',
  'link_title' => 'Delete menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '77',
  'plid' => '37',
  'link_path' => 'admin/build/menu/item/%/edit',
  'router_path' => 'admin/build/menu/item/%/edit',
  'link_title' => 'Edit menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '77',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '78',
  'plid' => '37',
  'link_path' => 'admin/build/menu/item/%/reset',
  'router_path' => 'admin/build/menu/item/%/reset',
  'link_title' => 'Reset menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '79',
  'plid' => '37',
  'link_path' => 'admin/build/menu-customize/navigation',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Navigation',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '80',
  'plid' => '37',
  'link_path' => 'admin/build/menu-customize/primary-links',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Primary links',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '80',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '81',
  'plid' => '37',
  'link_path' => 'admin/build/menu-customize/secondary-links',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Secondary links',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '37',
  'p4' => '81',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '82',
  'plid' => '0',
  'link_path' => 'taxonomy/autocomplete',
  'router_path' => 'taxonomy/autocomplete',
  'link_title' => 'Autocomplete taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '82',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '83',
  'plid' => '15',
  'link_path' => 'admin/reports/updates',
  'router_path' => 'admin/reports/updates',
  'link_title' => 'Available updates',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Get a status report about available updates for your installed modules and themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '83',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '84',
  'plid' => '11',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '11',
  'p2' => '84',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '85',
  'plid' => '15',
  'link_path' => 'admin/reports/dblog',
  'router_path' => 'admin/reports/dblog',
  'link_title' => 'Recent log entries',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View events that have recently been logged.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '85',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '86',
  'plid' => '11',
  'link_path' => 'node/add/story',
  'router_path' => 'node/add/story',
  'link_title' => 'Story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '11',
  'p2' => '86',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '87',
  'plid' => '10',
  'link_path' => 'admin/content/taxonomy',
  'router_path' => 'admin/content/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '87',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '88',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '88',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '89',
  'plid' => '15',
  'link_path' => 'admin/reports/access-denied',
  'router_path' => 'admin/reports/access-denied',
  'link_title' => "Top 'access denied' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:35:\"View 'access denied' errors (403s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '89',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '90',
  'plid' => '15',
  'link_path' => 'admin/reports/page-not-found',
  'router_path' => 'admin/reports/page-not-found',
  'link_title' => "Top 'page not found' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:36:\"View 'page not found' errors (404s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '90',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '91',
  'plid' => '16',
  'link_path' => 'admin/build/path',
  'router_path' => 'admin/build/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '91',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '92',
  'plid' => '36',
  'link_path' => 'admin/settings/logging/dblog',
  'router_path' => 'admin/settings/logging/dblog',
  'link_title' => 'Database logging',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:169:"Settings for logging to the Drupal database logs. This is the most common method for small to medium sites on shared hosting. The logs are viewable from the admin pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '36',
  'p4' => '92',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '93',
  'plid' => '91',
  'link_path' => 'admin/build/path/delete',
  'router_path' => 'admin/build/path/delete',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '91',
  'p4' => '93',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '94',
  'plid' => '15',
  'link_path' => 'admin/reports/event/%',
  'router_path' => 'admin/reports/event/%',
  'link_title' => 'Details',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '94',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '95',
  'plid' => '91',
  'link_path' => 'admin/build/path/edit',
  'router_path' => 'admin/build/path/edit',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '16',
  'p3' => '91',
  'p4' => '95',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '96',
  'plid' => '87',
  'link_path' => 'admin/content/taxonomy/%',
  'router_path' => 'admin/content/taxonomy/%',
  'link_title' => 'List terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '87',
  'p4' => '96',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '97',
  'plid' => '83',
  'link_path' => 'admin/reports/updates/check',
  'router_path' => 'admin/reports/updates/check',
  'link_title' => 'Manual update check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '15',
  'p3' => '83',
  'p4' => '97',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '98',
  'plid' => '10',
  'link_path' => 'admin/content/node-type/page',
  'router_path' => 'admin/content/node-type/page',
  'link_title' => 'Page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '98',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '99',
  'plid' => '10',
  'link_path' => 'admin/content/node-type/story',
  'router_path' => 'admin/content/node-type/story',
  'link_title' => 'Story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '99',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '100',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/delete',
  'router_path' => 'admin/content/node-type/page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '100',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '101',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/delete',
  'router_path' => 'admin/content/node-type/story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '101',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '102',
  'plid' => '87',
  'link_path' => 'admin/content/taxonomy/edit/term',
  'router_path' => 'admin/content/taxonomy/edit/term',
  'link_title' => 'Edit term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '87',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '103',
  'plid' => '87',
  'link_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'router_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'link_title' => 'Edit vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '87',
  'p4' => '103',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '104',
  'plid' => '0',
  'link_path' => 'poll',
  'router_path' => 'poll',
  'link_title' => 'Polls',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '104',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '105',
  'plid' => '104',
  'link_path' => 'poll/js',
  'router_path' => 'poll/js',
  'link_title' => 'Javascript Choice Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '104',
  'p2' => '105',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '106',
  'plid' => '11',
  'link_path' => 'node/add/poll',
  'router_path' => 'node/add/poll',
  'link_title' => 'Poll',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:191:"A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '11',
  'p2' => '106',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '107',
  'plid' => '10',
  'link_path' => 'admin/content/node-type/poll',
  'router_path' => 'admin/content/node-type/poll',
  'link_title' => 'Poll',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '107',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '108',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/poll/delete',
  'router_path' => 'admin/content/node-type/poll/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '108',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '109',
  'plid' => '2',
  'link_path' => 'admin/help',
  'router_path' => 'admin/help',
  'link_title' => 'Help',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '110',
  'plid' => '109',
  'link_path' => 'admin/help/block',
  'router_path' => 'admin/help/block',
  'link_title' => 'block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '110',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '111',
  'plid' => '109',
  'link_path' => 'admin/help/color',
  'router_path' => 'admin/help/color',
  'link_title' => 'color',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '111',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '112',
  'plid' => '109',
  'link_path' => 'admin/help/comment',
  'router_path' => 'admin/help/comment',
  'link_title' => 'comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '112',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '113',
  'plid' => '109',
  'link_path' => 'admin/help/dblog',
  'router_path' => 'admin/help/dblog',
  'link_title' => 'dblog',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '113',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '114',
  'plid' => '109',
  'link_path' => 'admin/help/filter',
  'router_path' => 'admin/help/filter',
  'link_title' => 'filter',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '114',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '115',
  'plid' => '109',
  'link_path' => 'admin/help/help',
  'router_path' => 'admin/help/help',
  'link_title' => 'help',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '115',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '116',
  'plid' => '109',
  'link_path' => 'admin/help/menu',
  'router_path' => 'admin/help/menu',
  'link_title' => 'menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '116',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '117',
  'plid' => '109',
  'link_path' => 'admin/help/node',
  'router_path' => 'admin/help/node',
  'link_title' => 'node',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '117',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '118',
  'plid' => '109',
  'link_path' => 'admin/help/path',
  'router_path' => 'admin/help/path',
  'link_title' => 'path',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '118',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '119',
  'plid' => '109',
  'link_path' => 'admin/help/poll',
  'router_path' => 'admin/help/poll',
  'link_title' => 'poll',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '119',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '120',
  'plid' => '109',
  'link_path' => 'admin/help/system',
  'router_path' => 'admin/help/system',
  'link_title' => 'system',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '120',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '121',
  'plid' => '109',
  'link_path' => 'admin/help/taxonomy',
  'router_path' => 'admin/help/taxonomy',
  'link_title' => 'taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '121',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '122',
  'plid' => '109',
  'link_path' => 'admin/help/update',
  'router_path' => 'admin/help/update',
  'link_title' => 'update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '122',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '123',
  'plid' => '109',
  'link_path' => 'admin/help/user',
  'router_path' => 'admin/help/user',
  'link_title' => 'user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '2',
  'p2' => '109',
  'p3' => '123',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();

db_create_table('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'to_arg_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'block_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'position' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'file' => array(
      'type' => 'text',
      'size' => 'medium',
    ),
  ),
  'indexes' => array(
    'fit' => array(
      'fit',
    ),
    'tab_parent' => array(
      'tab_parent',
    ),
    'tab_root_weight_title' => array(
      array(
        'tab_root',
        64,
      ),
      'weight',
      'title',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'module' => 'system',
  'name' => 'menu_router',
));
db_insert('menu_router')->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'fit',
  'number_parts',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'type',
  'block_callback',
  'description',
  'position',
  'weight',
  'file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/build',
  'title' => 'Site building',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how your site looks and feels.',
  'position' => 'right',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"block_admin_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/configure',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"block_box_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/list/js',
  'title' => 'JavaScript List Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Control your site's navigation menu, primary links and secondary links. as well as rename and reorganize menu items.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/add',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Add item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/delete',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/edit',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/list',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'List items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/delete',
  'title' => 'Delete menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/edit',
  'title' => 'Edit menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/reset',
  'title' => 'Reset menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable add-on modules for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"path_admin_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/delete',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/edit',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/themes',
  'title' => 'Themes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change which theme your site uses or allows users to set.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/select',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Select the default theme.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-module',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_by_module',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-task',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By task',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's content.",
  'position' => 'left',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/comment',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and edit site comments and the comment moderation queue.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Approval queue',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View, edit, and delete your site's content.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_configure";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings',
  'title' => 'Post settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Page',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/poll',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"name";s:4:"Poll";s:6:"module";s:4:"poll";s:11:"description";s:191:"A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.";s:11:"title_label";s:8:"Question";s:8:"has_body";b:0;s:4:"type";s:4:"poll";s:9:"has_title";b:1;s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:4:"poll";s:6:"is_new";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/poll',
  'title' => 'Poll',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/poll/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"name";s:4:"Poll";s:6:"module";s:4:"poll";s:11:"description";s:191:"A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.";s:11:"title_label";s:8:"Question";s:8:"has_body";b:0;s:4:"type";s:4:"poll";s:9:"has_title";b:1;s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:4:"poll";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/poll/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/poll/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"name";s:4:"Poll";s:6:"module";s:4:"poll";s:11:"description";s:191:"A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.";s:11:"title_label";s:8:"Question";s:8:"has_body";b:0;s:4:"type";s:4:"poll";s:9:"has_title";b:1;s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:4:"poll";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/poll',
  'tab_root' => 'admin/content/node-type/poll',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/node',
  'tab_root' => 'admin/content/node',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List terms',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/add/term',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_add_term_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '59',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/add/vocabulary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_term_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/term',
  'title' => 'Edit term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'load_functions' => 'a:1:{i:5;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_vocabulary_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/vocabulary/%',
  'title' => 'Edit vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage posts by content type, including default status, front page promotion, etc.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_main',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/help',
  'title' => 'Help',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/block',
  'title' => 'block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/color',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/color',
  'title' => 'color',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/comment',
  'title' => 'comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/dblog',
  'title' => 'dblog',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/filter',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/filter',
  'title' => 'filter',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/help',
  'title' => 'help',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/menu',
  'title' => 'menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/node',
  'title' => 'node',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/path',
  'title' => 'path',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/poll',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/poll',
  'title' => 'poll',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/system',
  'title' => 'system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/taxonomy',
  'title' => 'taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/update',
  'title' => 'update',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/help/user',
  'title' => 'user',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View reports from system logs and other status information.',
  'position' => 'left',
  'weight' => '5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/access-denied',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:13:"access denied";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access-denied',
  'title' => "Top 'access denied' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View 'access denied' errors (403s).",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/dblog',
  'title' => 'Recent log entries',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View events that have recently been logged.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/event/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_event',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/event/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/page-not-found',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:14:"page not found";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/page-not-found',
  'title' => "Top 'page not found' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View 'page not found' errors (404s).",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/sql',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_sql',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/sql',
  'title' => 'SQL',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/updates',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Available updates',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Get a status report about available updates for your installed modules and themes.',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/update/update.report.inc',
))
->values(array(
  'path' => 'admin/reports/updates/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_manual_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates/check',
  'title' => 'Manual update check',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/update/update.fetch.inc',
))
->values(array(
  'path' => 'admin/reports/updates/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/update/update.report.inc',
))
->values(array(
  'path' => 'admin/reports/updates/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"update_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/update/update.settings.inc',
))
->values(array(
  'path' => 'admin/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_settings_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/settings',
  'title' => 'Site configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Adjust basic site configuration options.',
  'position' => 'right',
  'weight' => '-5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/actions',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_admin_theme_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/admin',
  'title' => 'Administration theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => 'system_admin_theme_settings',
  'description' => 'Settings for how your administrative pages should look.',
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/error-reporting',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"system_error_reporting_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/error-reporting',
  'title' => 'Error reporting',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Input formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/configure',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_configure_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/edit',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/order',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_order_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Rearrange',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Add input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"filter_admin_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/delete',
  'title' => 'Delete input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_logging_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/logging',
  'title' => 'Logging and alerts',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/logging/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"dblog_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/logging/dblog',
  'title' => 'Database logging',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Settings for logging to the Drupal database logs. This is the most common method for small to medium sites on shared hosting. The logs are viewable from the admin pages.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/settings/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_maintenance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-maintenance',
  'title' => 'Site maintenance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Take the site off-line for maintenance or bring it back online.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/user',
  'title' => 'User management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's users, groups and access to site features.",
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/user/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_perm";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/permissions',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_new_role";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_role";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules',
  'title' => 'Access rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and create rules to disallow usernames, e-mail addresses, and IP addresses.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_add',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Add rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_check',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Check rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"user_admin_access_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/delete',
  'title' => 'Delete rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/edit',
  'title' => 'Edit rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/settings',
  'title' => 'User settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, and user pictures.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/user',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, add, and edit users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'comment/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_delete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/delete',
  'title' => 'Delete comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:13:"post comments";}',
  'page_callback' => 'comment_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/edit',
  'title' => 'Edit comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Reply to comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/results',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_poll_menu_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;s:14:"access content";i:2;b:1;}',
  'page_callback' => 'poll_results',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Results',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/poll/poll.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;N;i:2;b:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => '',
))
->values(array(
  'path' => 'node/%/votes',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_poll_menu_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;s:17:"inspect all votes";i:2;b:0;}',
  'page_callback' => 'poll_votes',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Votes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/poll/poll.pages.inc',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Create content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/poll',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"poll";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/poll',
  'title' => 'Poll',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"story";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/story',
  'title' => 'Story',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'poll',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'poll_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'poll',
  'title' => 'Polls',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/poll/poll.pages.inc',
))
->values(array(
  'path' => 'poll/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'poll_choice_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'poll/js',
  'title' => 'Javascript Choice Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"user_confirm_delete";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'user/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:13:"user_register";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->execute();

db_create_table('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'moderate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'tnid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'node_changed' => array(
      'changed',
    ),
    'node_created' => array(
      'created',
    ),
    'node_moderate' => array(
      'moderate',
    ),
    'node_promote_status' => array(
      'promote',
      'status',
    ),
    'node_status_type' => array(
      'status',
      'type',
      'nid',
    ),
    'node_title_type' => array(
      'title',
      array(
        'type',
        4,
      ),
    ),
    'node_type' => array(
      array(
        'type',
        4,
      ),
    ),
    'uid' => array(
      'uid',
    ),
    'tnid' => array(
      'tnid',
    ),
    'translate' => array(
      'translate',
    ),
  ),
  'unique keys' => array(
    'vid' => array(
      'vid',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'module' => 'node',
  'name' => 'node',
));
db_insert('node')->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'moderate',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 1 rev 1 (i=0) rev2 2',
  'uid' => '3',
  'status' => '0',
  'created' => '1262732400',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 2 rev 3 (i=1) rev2 4',
  'uid' => '3',
  'status' => '0',
  'created' => '1262818800',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 3 rev 5 (i=2) rev2 6',
  'uid' => '3',
  'status' => '0',
  'created' => '1262905200',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 4 rev 7 (i=3) rev2 8',
  'uid' => '3',
  'status' => '0',
  'created' => '1262991600',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 5 rev 9 (i=4) rev2 10',
  'uid' => '3',
  'status' => '1',
  'created' => '1263078000',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 6 rev 11 (i=5) rev2 12',
  'uid' => '3',
  'status' => '1',
  'created' => '1263164400',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 7 rev 13 (i=6) rev2 14',
  'uid' => '3',
  'status' => '1',
  'created' => '1263250800',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 8 rev 15 (i=7) rev2 16',
  'uid' => '3',
  'status' => '1',
  'created' => '1263337200',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 9 rev 17 (i=8) rev2 18',
  'uid' => '4',
  'status' => '0',
  'created' => '1263423600',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 10 rev 19 (i=9) rev2 20',
  'uid' => '4',
  'status' => '0',
  'created' => '1263510000',
  'changed' => '1282936266',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 11 rev 21 (i=10) rev2 22',
  'uid' => '4',
  'status' => '0',
  'created' => '1263596400',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'type' => 'page',
  'language' => '',
  'title' => 'node title 12 rev 23 (i=11) rev2 24',
  'uid' => '4',
  'status' => '0',
  'created' => '1263682800',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 13 rev 25 (i=12)',
  'uid' => '4',
  'status' => '1',
  'created' => '1263769200',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 14 rev 26 (i=13)',
  'uid' => '4',
  'status' => '1',
  'created' => '1263855600',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 15 rev 27 (i=14)',
  'uid' => '4',
  'status' => '1',
  'created' => '1263942000',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 16 rev 28 (i=15)',
  'uid' => '4',
  'status' => '1',
  'created' => '1264028400',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 17 rev 29 (i=16)',
  'uid' => '5',
  'status' => '0',
  'created' => '1264114800',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 18 rev 30 (i=17)',
  'uid' => '5',
  'status' => '0',
  'created' => '1264201200',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 19 rev 31 (i=18)',
  'uid' => '5',
  'status' => '0',
  'created' => '1264287600',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 20 rev 32 (i=19)',
  'uid' => '5',
  'status' => '0',
  'created' => '1264374000',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 21 rev 33 (i=20)',
  'uid' => '5',
  'status' => '1',
  'created' => '1264460400',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 22 rev 34 (i=21)',
  'uid' => '5',
  'status' => '1',
  'created' => '1264546800',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 23 rev 35 (i=22)',
  'uid' => '5',
  'status' => '1',
  'created' => '1264633200',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'type' => 'story',
  'language' => '',
  'title' => 'node title 24 rev 36 (i=23)',
  'uid' => '5',
  'status' => '1',
  'created' => '1264719600',
  'changed' => '1282936267',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '25',
  'vid' => '37',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 0',
  'uid' => '3',
  'status' => '0',
  'created' => '1262732400',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '26',
  'vid' => '38',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 1',
  'uid' => '3',
  'status' => '0',
  'created' => '1262775600',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '27',
  'vid' => '39',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 2',
  'uid' => '3',
  'status' => '1',
  'created' => '1262818800',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '28',
  'vid' => '40',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 3',
  'uid' => '3',
  'status' => '1',
  'created' => '1262862000',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '29',
  'vid' => '41',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 4',
  'uid' => '4',
  'status' => '0',
  'created' => '1262905200',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '30',
  'vid' => '42',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 5',
  'uid' => '4',
  'status' => '0',
  'created' => '1262948400',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '31',
  'vid' => '43',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 6',
  'uid' => '4',
  'status' => '1',
  'created' => '1262991600',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '32',
  'vid' => '44',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 7',
  'uid' => '4',
  'status' => '1',
  'created' => '1263034800',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '33',
  'vid' => '45',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 8',
  'uid' => '5',
  'status' => '0',
  'created' => '1263078000',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '34',
  'vid' => '46',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 9',
  'uid' => '5',
  'status' => '0',
  'created' => '1263121200',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '35',
  'vid' => '47',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 10',
  'uid' => '5',
  'status' => '1',
  'created' => '1263164400',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '36',
  'vid' => '48',
  'type' => 'poll',
  'language' => '',
  'title' => 'poll title 11',
  'uid' => '5',
  'status' => '1',
  'created' => '1263207600',
  'changed' => '1282936268',
  'comment' => '0',
  'promote' => '1',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '37',
  'vid' => '49',
  'type' => 'broken',
  'language' => '',
  'title' => 'node title 24',
  'uid' => '6',
  'status' => '1',
  'created' => '1263769200',
  'changed' => '1279310614',
  'comment' => '0',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();

db_create_table('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'gid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'realm' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'grant_update' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'grant_delete' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'module' => 'node',
  'name' => 'node_access',
));
db_insert('node_access')->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();

db_create_table('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => FALSE,
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'comment_count' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'indexes' => array(
    'node_comment_timestamp' => array(
      'last_comment_timestamp',
    ),
  ),
  'module' => 'comment',
  'name' => 'node_comment_statistics',
));
db_insert('node_comment_statistics')->fields(array(
  'nid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'nid' => '1',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '2',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '3',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '4',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '5',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '6',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '7',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '8',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '9',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '10',
  'last_comment_timestamp' => '1282936266',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '11',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '12',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '13',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '14',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '15',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '16',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '17',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '18',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '19',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '20',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '21',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '22',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '23',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '24',
  'last_comment_timestamp' => '1282936267',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '25',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '26',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '27',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '28',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '3',
  'comment_count' => '0',
))
->values(array(
  'nid' => '29',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '30',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '31',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '32',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '4',
  'comment_count' => '0',
))
->values(array(
  'nid' => '33',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '34',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '35',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '36',
  'last_comment_timestamp' => '1282936268',
  'last_comment_name' => NULL,
  'last_comment_uid' => '5',
  'comment_count' => '0',
))
->values(array(
  'nid' => '37',
  'last_comment_timestamp' => '1279310615',
  'last_comment_name' => NULL,
  'last_comment_uid' => '6',
  'comment_count' => '0',
))
->execute();

db_create_table('node_counter', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'totalcount' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'big',
    ),
    'daycount' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'medium',
    ),
    'timestamp' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'module' => 'node',
  'name' => 'node_counter',
));

db_create_table('node_revisions', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'vid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'body' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'teaser' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'module' => 'node',
  'name' => 'node_revisions',
));
db_insert('node_revisions')->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'body',
  'teaser',
  'log',
  'timestamp',
  'format',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '3',
  'title' => 'node title 1 rev 1 (i=0)',
  'body' => 'node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0',
  'teaser' => 'node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0',
  'log' => 'added 0 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'uid' => '6',
  'title' => 'node title 1 rev 1 (i=0) rev2 2',
  'body' => 'node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0node revision body (page) - 0',
  'teaser' => 'node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0node body (page) - 0',
  'log' => 'added 0 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'uid' => '3',
  'title' => 'node title 2 rev 3 (i=1)',
  'body' => 'node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1',
  'teaser' => 'node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1',
  'log' => 'added 1 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'uid' => '6',
  'title' => 'node title 2 rev 3 (i=1) rev2 4',
  'body' => 'node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1node revision body (page) - 1',
  'teaser' => 'node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1node body (page) - 1',
  'log' => 'added 1 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '5',
  'uid' => '3',
  'title' => 'node title 3 rev 5 (i=2)',
  'body' => 'node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2',
  'teaser' => 'node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2',
  'log' => 'added 2 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'uid' => '6',
  'title' => 'node title 3 rev 5 (i=2) rev2 6',
  'body' => 'node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2node revision body (page) - 2',
  'teaser' => 'node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2node body (page) - 2',
  'log' => 'added 2 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '7',
  'uid' => '3',
  'title' => 'node title 4 rev 7 (i=3)',
  'body' => 'node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3',
  'teaser' => 'node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3',
  'log' => 'added 3 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'uid' => '6',
  'title' => 'node title 4 rev 7 (i=3) rev2 8',
  'body' => 'node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3node revision body (page) - 3',
  'teaser' => 'node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3node body (page) - 3',
  'log' => 'added 3 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '9',
  'uid' => '3',
  'title' => 'node title 5 rev 9 (i=4)',
  'body' => 'node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4',
  'teaser' => 'node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4',
  'log' => 'added 4 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'uid' => '6',
  'title' => 'node title 5 rev 9 (i=4) rev2 10',
  'body' => 'node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4node revision body (page) - 4',
  'teaser' => 'node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4node body (page) - 4',
  'log' => 'added 4 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '11',
  'uid' => '3',
  'title' => 'node title 6 rev 11 (i=5)',
  'body' => 'node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5',
  'teaser' => 'node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5',
  'log' => 'added 5 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'uid' => '6',
  'title' => 'node title 6 rev 11 (i=5) rev2 12',
  'body' => 'node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5node revision body (page) - 5',
  'teaser' => 'node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5node body (page) - 5',
  'log' => 'added 5 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '13',
  'uid' => '3',
  'title' => 'node title 7 rev 13 (i=6)',
  'body' => 'node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6',
  'teaser' => 'node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6',
  'log' => 'added 6 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'uid' => '6',
  'title' => 'node title 7 rev 13 (i=6) rev2 14',
  'body' => 'node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6node revision body (page) - 6',
  'teaser' => 'node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6node body (page) - 6',
  'log' => 'added 6 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '15',
  'uid' => '3',
  'title' => 'node title 8 rev 15 (i=7)',
  'body' => 'node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7',
  'teaser' => 'node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7',
  'log' => 'added 7 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'uid' => '6',
  'title' => 'node title 8 rev 15 (i=7) rev2 16',
  'body' => 'node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7node revision body (page) - 7',
  'teaser' => 'node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7node body (page) - 7',
  'log' => 'added 7 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '17',
  'uid' => '4',
  'title' => 'node title 9 rev 17 (i=8)',
  'body' => 'node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8',
  'teaser' => 'node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8',
  'log' => 'added 8 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'uid' => '7',
  'title' => 'node title 9 rev 17 (i=8) rev2 18',
  'body' => 'node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8node revision body (page) - 8',
  'teaser' => 'node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8node body (page) - 8',
  'log' => 'added 8 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '10',
  'vid' => '19',
  'uid' => '4',
  'title' => 'node title 10 rev 19 (i=9)',
  'body' => 'node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9',
  'teaser' => 'node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9',
  'log' => 'added 9 node',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'uid' => '7',
  'title' => 'node title 10 rev 19 (i=9) rev2 20',
  'body' => 'node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9node revision body (page) - 9',
  'teaser' => 'node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9node body (page) - 9',
  'log' => 'added 9 revision',
  'timestamp' => '1282936266',
  'format' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '21',
  'uid' => '4',
  'title' => 'node title 11 rev 21 (i=10)',
  'body' => 'node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10',
  'teaser' => 'node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (p',
  'log' => 'added 10 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'uid' => '7',
  'title' => 'node title 11 rev 21 (i=10) rev2 22',
  'body' => 'node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10node revision body (page) - 10',
  'teaser' => 'node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (page) - 10node body (p',
  'log' => 'added 10 revision',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '12',
  'vid' => '23',
  'uid' => '4',
  'title' => 'node title 12 rev 23 (i=11)',
  'body' => 'node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11',
  'teaser' => 'node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (p',
  'log' => 'added 11 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'uid' => '7',
  'title' => 'node title 12 rev 23 (i=11) rev2 24',
  'body' => 'node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11node revision body (page) - 11',
  'teaser' => 'node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (page) - 11node body (p',
  'log' => 'added 11 revision',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'uid' => '4',
  'title' => 'node title 13 rev 25 (i=12)',
  'body' => 'node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12',
  'teaser' => 'node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node body (story) - 12node b',
  'log' => 'added 12 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'uid' => '4',
  'title' => 'node title 14 rev 26 (i=13)',
  'body' => 'node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13',
  'teaser' => 'node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node body (story) - 13node b',
  'log' => 'added 13 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'uid' => '4',
  'title' => 'node title 15 rev 27 (i=14)',
  'body' => 'node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14',
  'teaser' => 'node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node body (story) - 14node b',
  'log' => 'added 14 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'uid' => '4',
  'title' => 'node title 16 rev 28 (i=15)',
  'body' => 'node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15',
  'teaser' => 'node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node body (story) - 15node b',
  'log' => 'added 15 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'uid' => '5',
  'title' => 'node title 17 rev 29 (i=16)',
  'body' => 'node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16',
  'teaser' => 'node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node body (story) - 16node b',
  'log' => 'added 16 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'uid' => '5',
  'title' => 'node title 18 rev 30 (i=17)',
  'body' => 'node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17',
  'teaser' => 'node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node body (story) - 17node b',
  'log' => 'added 17 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'uid' => '5',
  'title' => 'node title 19 rev 31 (i=18)',
  'body' => 'node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18',
  'teaser' => 'node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node body (story) - 18node b',
  'log' => 'added 18 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'uid' => '5',
  'title' => 'node title 20 rev 32 (i=19)',
  'body' => 'node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19',
  'teaser' => 'node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node body (story) - 19node b',
  'log' => 'added 19 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'uid' => '5',
  'title' => 'node title 21 rev 33 (i=20)',
  'body' => 'node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20',
  'teaser' => 'node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node body (story) - 20node b',
  'log' => 'added 20 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'uid' => '5',
  'title' => 'node title 22 rev 34 (i=21)',
  'body' => 'node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21',
  'teaser' => 'node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node body (story) - 21node b',
  'log' => 'added 21 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'uid' => '5',
  'title' => 'node title 23 rev 35 (i=22)',
  'body' => 'node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22',
  'teaser' => 'node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node body (story) - 22node b',
  'log' => 'added 22 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'uid' => '5',
  'title' => 'node title 24 rev 36 (i=23)',
  'body' => 'node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23',
  'teaser' => 'node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node body (story) - 23node b',
  'log' => 'added 23 node',
  'timestamp' => '1282936267',
  'format' => '0',
))
->values(array(
  'nid' => '25',
  'vid' => '37',
  'uid' => '3',
  'title' => 'poll title 0',
  'body' => '',
  'teaser' => '',
  'log' => 'added 0 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '26',
  'vid' => '38',
  'uid' => '3',
  'title' => 'poll title 1',
  'body' => '',
  'teaser' => '',
  'log' => 'added 1 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '27',
  'vid' => '39',
  'uid' => '3',
  'title' => 'poll title 2',
  'body' => '',
  'teaser' => '',
  'log' => 'added 2 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '28',
  'vid' => '40',
  'uid' => '3',
  'title' => 'poll title 3',
  'body' => '',
  'teaser' => '',
  'log' => 'added 3 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '29',
  'vid' => '41',
  'uid' => '4',
  'title' => 'poll title 4',
  'body' => '',
  'teaser' => '',
  'log' => 'added 4 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '30',
  'vid' => '42',
  'uid' => '4',
  'title' => 'poll title 5',
  'body' => '',
  'teaser' => '',
  'log' => 'added 5 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '31',
  'vid' => '43',
  'uid' => '4',
  'title' => 'poll title 6',
  'body' => '',
  'teaser' => '',
  'log' => 'added 6 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '32',
  'vid' => '44',
  'uid' => '4',
  'title' => 'poll title 7',
  'body' => '',
  'teaser' => '',
  'log' => 'added 7 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '33',
  'vid' => '45',
  'uid' => '5',
  'title' => 'poll title 8',
  'body' => '',
  'teaser' => '',
  'log' => 'added 8 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '34',
  'vid' => '46',
  'uid' => '5',
  'title' => 'poll title 9',
  'body' => '',
  'teaser' => '',
  'log' => 'added 9 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '35',
  'vid' => '47',
  'uid' => '5',
  'title' => 'poll title 10',
  'body' => '',
  'teaser' => '',
  'log' => 'added 10 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '36',
  'vid' => '48',
  'uid' => '5',
  'title' => 'poll title 11',
  'body' => '',
  'teaser' => '',
  'log' => 'added 11 poll',
  'timestamp' => '1282936268',
  'format' => '0',
))
->values(array(
  'nid' => '37',
  'vid' => '49',
  'uid' => '6',
  'title' => 'node title 24',
  'body' => 'node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37',
  'teaser' => 'node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37node body (broken) - 37no',
  'log' => 'added 12 node',
  'timestamp' => '1279310614',
  'format' => '0',
))
->execute();

db_create_table('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'has_title' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'title_label' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'has_body' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'body_label' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'min_word_count' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'size' => 'small',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'module' => 'node',
  'name' => 'node_type',
));
db_insert('node_type')->fields(array(
  'type',
  'name',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'has_body',
  'body_label',
  'min_word_count',
  'custom',
  'modified',
  'locked',
  'orig_type',
))
->values(array(
  'type' => 'page',
  'name' => 'Page',
  'module' => 'node',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'poll',
  'name' => 'Poll',
  'module' => 'poll',
  'description' => 'A <em>poll</em> is a question with a set of possible responses. A <em>poll</em>, once created, automatically provides a simple running count of the number of votes received for each response.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Question',
  'has_body' => '0',
  'body_label' => '',
  'min_word_count' => '0',
  'custom' => '0',
  'modified' => '0',
  'locked' => '1',
  'orig_type' => 'poll',
))
->values(array(
  'type' => 'story',
  'name' => 'Story',
  'module' => 'node',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
))
->execute();

db_create_table('permission', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'perm' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'module' => 'user',
  'name' => 'permission',
));
db_insert('permission')->fields(array(
  'pid',
  'rid',
  'perm',
  'tid',
))
->values(array(
  'pid' => '1',
  'rid' => '1',
  'perm' => 'access content',
  'tid' => '0',
))
->values(array(
  'pid' => '2',
  'rid' => '2',
  'perm' => 'access comments, access content, post comments, post comments without approval',
  'tid' => '0',
))
->execute();

db_create_table('poll', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'runtime' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'active' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'module' => 'poll',
  'name' => 'poll',
));
db_insert('poll')->fields(array(
  'nid',
  'runtime',
  'active',
))
->values(array(
  'nid' => '25',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '26',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '27',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '28',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '29',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '30',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '31',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '32',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '33',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '34',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '35',
  'runtime' => '0',
  'active' => '1',
))
->values(array(
  'nid' => '36',
  'runtime' => '0',
  'active' => '1',
))
->execute();

db_create_table('poll_choices', array(
  'fields' => array(
    'chid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'chtext' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'chvotes' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'chorder' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'primary key' => array(
    'chid',
  ),
  'module' => 'poll',
  'name' => 'poll_choices',
));
db_insert('poll_choices')->fields(array(
  'chid',
  'nid',
  'chtext',
  'chvotes',
  'chorder',
))
->values(array(
  'chid' => '1',
  'nid' => '25',
  'chtext' => 'Choice 0 for poll 0',
  'chvotes' => '3',
  'chorder' => '0',
))
->values(array(
  'chid' => '2',
  'nid' => '25',
  'chtext' => 'Choice 1 for poll 0',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '3',
  'nid' => '26',
  'chtext' => 'Choice 0 for poll 1',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '4',
  'nid' => '26',
  'chtext' => 'Choice 1 for poll 1',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '5',
  'nid' => '26',
  'chtext' => 'Choice 2 for poll 1',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '6',
  'nid' => '27',
  'chtext' => 'Choice 0 for poll 2',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '7',
  'nid' => '27',
  'chtext' => 'Choice 1 for poll 2',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '8',
  'nid' => '27',
  'chtext' => 'Choice 2 for poll 2',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '9',
  'nid' => '27',
  'chtext' => 'Choice 3 for poll 2',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '10',
  'nid' => '28',
  'chtext' => 'Choice 0 for poll 3',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '11',
  'nid' => '28',
  'chtext' => 'Choice 1 for poll 3',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '12',
  'nid' => '28',
  'chtext' => 'Choice 2 for poll 3',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '13',
  'nid' => '28',
  'chtext' => 'Choice 3 for poll 3',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '14',
  'nid' => '28',
  'chtext' => 'Choice 4 for poll 3',
  'chvotes' => '1',
  'chorder' => '4',
))
->values(array(
  'chid' => '15',
  'nid' => '29',
  'chtext' => 'Choice 0 for poll 4',
  'chvotes' => '3',
  'chorder' => '0',
))
->values(array(
  'chid' => '16',
  'nid' => '29',
  'chtext' => 'Choice 1 for poll 4',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '17',
  'nid' => '30',
  'chtext' => 'Choice 0 for poll 5',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '18',
  'nid' => '30',
  'chtext' => 'Choice 1 for poll 5',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '19',
  'nid' => '30',
  'chtext' => 'Choice 2 for poll 5',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '20',
  'nid' => '31',
  'chtext' => 'Choice 0 for poll 6',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '21',
  'nid' => '31',
  'chtext' => 'Choice 1 for poll 6',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '22',
  'nid' => '31',
  'chtext' => 'Choice 2 for poll 6',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '23',
  'nid' => '31',
  'chtext' => 'Choice 3 for poll 6',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '24',
  'nid' => '32',
  'chtext' => 'Choice 0 for poll 7',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '25',
  'nid' => '32',
  'chtext' => 'Choice 1 for poll 7',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '26',
  'nid' => '32',
  'chtext' => 'Choice 2 for poll 7',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '27',
  'nid' => '32',
  'chtext' => 'Choice 3 for poll 7',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '28',
  'nid' => '32',
  'chtext' => 'Choice 4 for poll 7',
  'chvotes' => '1',
  'chorder' => '4',
))
->values(array(
  'chid' => '29',
  'nid' => '33',
  'chtext' => 'Choice 0 for poll 8',
  'chvotes' => '3',
  'chorder' => '0',
))
->values(array(
  'chid' => '30',
  'nid' => '33',
  'chtext' => 'Choice 1 for poll 8',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '31',
  'nid' => '34',
  'chtext' => 'Choice 0 for poll 9',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '32',
  'nid' => '34',
  'chtext' => 'Choice 1 for poll 9',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '33',
  'nid' => '34',
  'chtext' => 'Choice 2 for poll 9',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '34',
  'nid' => '35',
  'chtext' => 'Choice 0 for poll 10',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '35',
  'nid' => '35',
  'chtext' => 'Choice 1 for poll 10',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '36',
  'nid' => '35',
  'chtext' => 'Choice 2 for poll 10',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '37',
  'nid' => '35',
  'chtext' => 'Choice 3 for poll 10',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '38',
  'nid' => '36',
  'chtext' => 'Choice 0 for poll 11',
  'chvotes' => '2',
  'chorder' => '0',
))
->values(array(
  'chid' => '39',
  'nid' => '36',
  'chtext' => 'Choice 1 for poll 11',
  'chvotes' => '2',
  'chorder' => '1',
))
->values(array(
  'chid' => '40',
  'nid' => '36',
  'chtext' => 'Choice 2 for poll 11',
  'chvotes' => '2',
  'chorder' => '2',
))
->values(array(
  'chid' => '41',
  'nid' => '36',
  'chtext' => 'Choice 3 for poll 11',
  'chvotes' => '1',
  'chorder' => '3',
))
->values(array(
  'chid' => '42',
  'nid' => '36',
  'chtext' => 'Choice 4 for poll 11',
  'chvotes' => '1',
  'chorder' => '4',
))
->execute();

db_create_table('poll_votes', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'chorder' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => -1,
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'nid',
    'uid',
    'hostname',
  ),
  'indexes' => array(
    'hostname' => array(
      'hostname',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'module' => 'poll',
  'name' => 'poll_votes',
));
db_insert('poll_votes')->fields(array(
  'nid',
  'uid',
  'chorder',
  'hostname',
))
->values(array(
  'nid' => '25',
  'uid' => '3',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '26',
  'uid' => '3',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '27',
  'uid' => '3',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '28',
  'uid' => '3',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '29',
  'uid' => '4',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '30',
  'uid' => '4',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '31',
  'uid' => '4',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '32',
  'uid' => '4',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '33',
  'uid' => '5',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '34',
  'uid' => '5',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '35',
  'uid' => '5',
  'chorder' => '0',
  'hostname' => '',
))
->values(array(
  'nid' => '36',
  'uid' => '5',
  'chorder' => '0',
  'hostname' => '',
))
->execute();

db_create_table('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'module' => 'user',
  'name' => 'role',
));
db_insert('role')->fields(array(
  'rid',
  'name',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
))
->execute();

db_create_table('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'expire' => array(
      'type' => 'float',
      'size' => 'big',
      'not null' => TRUE,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'module' => 'system',
  'name' => 'semaphore',
));

db_create_table('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'session' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
  ),
  'indexes' => array(
    'timestamp' => array(
      'timestamp',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'module' => 'system',
  'name' => 'sessions',
));

db_create_table('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => -1,
      'size' => 'small',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'info' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'indexes' => array(
    'modules' => array(
      array(
        'type',
        12,
      ),
      'status',
      'weight',
      'filename',
    ),
    'bootstrap' => array(
      array(
        'type',
        12,
      ),
      'status',
      'bootstrap',
      'weight',
      'filename',
    ),
    'type_name' => array(
      array(
        'type',
        12,
      ),
      'name',
    ),
  ),
  'module' => 'system',
  'name' => 'system',
));
db_insert('system')->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'throttle',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Block";s:11:"description";s:62:"Controls the boxes that are displayed around the main content.";s:7:"package";s:15:"Core - required";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Blog";s:11:"description";s:69:"Enables keeping easily and regularly updated user web pages or blogs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blogapi/blogapi.module',
  'name' => 'blogapi',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Blog API";s:11:"description";s:79:"Allows users to post content using applications that support XML-RPC blog APIs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Book";s:11:"description";s:63:"Allows users to structure site pages in a hierarchy or outline.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Color";s:11:"description";s:61:"Allows the user to change the color scheme of certain themes.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6003',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Filter";s:11:"description";s:60:"Handles the filtering of content in preparation for display.";s:7:"package";s:15:"Core - required";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Forum";s:11:"description";s:50:"Enables threaded discussions about general topics.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:15:"Core - required";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:8:"6.20-dev";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/ping/ping.module',
  'name' => 'ping',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Ping";s:11:"description";s:51:"Alerts other sites when your site has been updated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6055',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:15:"Core - required";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/throttle/throttle.module',
  'name' => 'throttle',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Throttle";s:11:"description";s:66:"Handles the auto-throttling mechanism, to control site congestion.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Tracker";s:11:"description";s:43:"Enables tracking of recent posts for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:13:"Update status";s:11:"description";s:88:"Checks the status of available updates for Drupal and your installed modules and themes.";s:7:"version";s:8:"6.20-dev";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/upload/upload.module',
  'name' => 'upload',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Upload";s:11:"description";s:51:"Allows users to upload and attach files to content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:15:"Core - required";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/admin_menu/admin_menu.module',
  'name' => 'admin_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Administration Menu";s:11:"description";s:90:"Renders a menu tree for administrative purposes as dropdown menu at the top of the window.";s:7:"package";s:14:"Administration";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/content.module',
  'name' => 'content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Content";s:11:"description";s:50:"Allows administrators to define new content types.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_copy/content_copy.module',
  'name' => 'content_copy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:12:"Content Copy";s:11:"description";s:51:"Enables ability to import/export field definitions.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_permissions/content_permissions.module',
  'name' => 'content_permissions',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Content Permissions";s:11:"description";s:43:"Set field-level permissions for CCK fields.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/fieldgroup/fieldgroup.module',
  'name' => 'fieldgroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Fieldgroup";s:11:"description";s:35:"Create field groups for CCK fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/nodereference/nodereference.module',
  'name' => 'nodereference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Node Reference";s:11:"description";s:59:"Defines a field type for referencing one node from another.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/optionwidgets/optionwidgets.module',
  'name' => 'optionwidgets',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Option Widgets";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/userreference/userreference.module',
  'name' => 'userreference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"User Reference";s:11:"description";s:56:"Defines a field type for referencing a user from a node.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel.module',
  'name' => 'devel',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Devel";s:11:"description";s:52:"Various blocks, pages, and functions for developers.";s:7:"package";s:11:"Development";s:12:"dependencies";a:1:{i:0;s:4:"menu";}s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel_generate.module',
  'name' => 'devel_generate',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Devel generate";s:11:"description";s:48:"Generate dummy users, nodes, and taxonomy terms.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel_node_access.module',
  'name' => 'devel_node_access',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:17:"Devel node access";s:11:"description";s:67:"Developer block and page illustrating relevant node_access records.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel_themer.module',
  'name' => 'devel_themer',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:15:"Theme developer";s:11:"description";s:52:"Essential theme API information for theme developers";s:7:"package";s:11:"Development";s:12:"dependencies";a:1:{i:0;s:5:"devel";}s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/macro.module',
  'name' => 'macro',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Macro";s:11:"description";s:62:"Allows administrators to record and playback form submissions.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/devel/performance/performance.module',
  'name' => 'performance',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Performance Logging";s:11:"description";s:91:"Logs detailed and/or summary page generation time and memory consumption for page requests.";s:7:"package";s:11:"Development";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/drush_extras/drush_extras.module',
  'name' => 'drush_extras',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:12:"Drush extras";s:11:"description";s:43:"Useful Drush commands. Requires Drush core.";s:7:"package";s:11:"Development";s:4:"core";s:3:"7.x";s:5:"files";a:7:{i:0;s:19:"drush_extras.module";i:1;s:12:"pm.drush.inc";i:2;s:16:"pm_cvs.drush.inc";i:3;s:16:"pm_svn.drush.inc";i:4;s:20:"simpletest.drush.inc";i:5;s:13:"sql.drush.inc";i:6;s:15:"tools.drush.inc";}s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/mymap/mymap.module',
  'name' => 'mymap',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:7:{s:4:"name";s:6:"My Map";s:11:"description";s:36:"Allows any node to have a Google map";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/plugin_manager.module',
  'name' => 'plugin_manager',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Plugin Manager";s:11:"description";s:72:"Enables the automated installation of modules and themes from drupal.org";s:4:"core";s:3:"6.x";s:3:"php";s:1:"5";s:7:"package";s:14:"Administration";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;}',
))
->values(array(
  'filename' => 'sites/all/modules/schema/schema.module',
  'name' => 'schema',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Schema";s:11:"description";s:65:"The Schema module provides functionality built on the Schema API.";s:7:"package";s:8:"Database";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views.module',
  'name' => 'views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Views";s:11:"description";s:55:"Create customized lists and queries from your database.";s:7:"package";s:5:"Views";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views_export/views_export.module',
  'name' => 'views_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Views exporter";s:11:"description";s:40:"Allows exporting multiple views at once.";s:7:"package";s:5:"Views";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views_ui.module',
  'name' => 'views_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Views UI";s:11:"description";s:93:"Administrative interface to views. Without this module, you cannot create or edit your views.";s:7:"package";s:5:"Views";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/bluemarine/bluemarine.info',
  'name' => 'bluemarine',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/chameleon.info',
  'name' => 'chameleon',
  'type' => 'theme',
  'owner' => 'themes/chameleon/chameleon.theme',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/marvin/marvin.info',
  'name' => 'marvin',
  'type' => 'theme',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/minnelli/minnelli.info',
  'name' => 'minnelli',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}',
))
->values(array(
  'filename' => 'themes/pushbutton/pushbutton.info',
  'name' => 'pushbutton',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:8:"6.20-dev";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->execute();

db_create_table('term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'indexes' => array(
    'taxonomy_tree' => array(
      'vid',
      'weight',
      'name',
    ),
    'vid_name' => array(
      'vid',
      'name',
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'term_data',
));
db_insert('term_data')->fields(array(
  'tid',
  'vid',
  'name',
  'description',
  'weight',
))
->values(array(
  'tid' => '1',
  'vid' => '1',
  'name' => 'term 1 of vocabulary 1 (j=0)',
  'description' => 'description of term 1 of vocabulary 1 (j=0)',
  'weight' => '0',
))
->values(array(
  'tid' => '2',
  'vid' => '2',
  'name' => 'term 2 of vocabulary 2 (j=0)',
  'description' => 'description of term 2 of vocabulary 2 (j=0)',
  'weight' => '3',
))
->values(array(
  'tid' => '3',
  'vid' => '2',
  'name' => 'term 3 of vocabulary 2 (j=1)',
  'description' => 'description of term 3 of vocabulary 2 (j=1)',
  'weight' => '4',
))
->values(array(
  'tid' => '4',
  'vid' => '3',
  'name' => 'term 4 of vocabulary 3 (j=0)',
  'description' => 'description of term 4 of vocabulary 3 (j=0)',
  'weight' => '6',
))
->values(array(
  'tid' => '5',
  'vid' => '3',
  'name' => 'term 5 of vocabulary 3 (j=1)',
  'description' => 'description of term 5 of vocabulary 3 (j=1)',
  'weight' => '7',
))
->values(array(
  'tid' => '6',
  'vid' => '3',
  'name' => 'term 6 of vocabulary 3 (j=2)',
  'description' => 'description of term 6 of vocabulary 3 (j=2)',
  'weight' => '8',
))
->values(array(
  'tid' => '7',
  'vid' => '4',
  'name' => 'term 7 of vocabulary 4 (j=0)',
  'description' => 'description of term 7 of vocabulary 4 (j=0)',
  'weight' => '9',
))
->values(array(
  'tid' => '8',
  'vid' => '5',
  'name' => 'term 8 of vocabulary 5 (j=0)',
  'description' => 'description of term 8 of vocabulary 5 (j=0)',
  'weight' => '12',
))
->values(array(
  'tid' => '9',
  'vid' => '5',
  'name' => 'term 9 of vocabulary 5 (j=1)',
  'description' => 'description of term 9 of vocabulary 5 (j=1)',
  'weight' => '13',
))
->values(array(
  'tid' => '10',
  'vid' => '6',
  'name' => 'term 10 of vocabulary 6 (j=0)',
  'description' => 'description of term 10 of vocabulary 6 (j=0)',
  'weight' => '15',
))
->values(array(
  'tid' => '11',
  'vid' => '6',
  'name' => 'term 11 of vocabulary 6 (j=1)',
  'description' => 'description of term 11 of vocabulary 6 (j=1)',
  'weight' => '16',
))
->values(array(
  'tid' => '12',
  'vid' => '6',
  'name' => 'term 12 of vocabulary 6 (j=2)',
  'description' => 'description of term 12 of vocabulary 6 (j=2)',
  'weight' => '17',
))
->values(array(
  'tid' => '13',
  'vid' => '7',
  'name' => 'term 13 of vocabulary 7 (j=0)',
  'description' => 'description of term 13 of vocabulary 7 (j=0)',
  'weight' => '18',
))
->values(array(
  'tid' => '14',
  'vid' => '8',
  'name' => 'term 14 of vocabulary 8 (j=0)',
  'description' => 'description of term 14 of vocabulary 8 (j=0)',
  'weight' => '21',
))
->values(array(
  'tid' => '15',
  'vid' => '8',
  'name' => 'term 15 of vocabulary 8 (j=1)',
  'description' => 'description of term 15 of vocabulary 8 (j=1)',
  'weight' => '22',
))
->values(array(
  'tid' => '16',
  'vid' => '9',
  'name' => 'term 16 of vocabulary 9 (j=0)',
  'description' => 'description of term 16 of vocabulary 9 (j=0)',
  'weight' => '24',
))
->values(array(
  'tid' => '17',
  'vid' => '9',
  'name' => 'term 17 of vocabulary 9 (j=1)',
  'description' => 'description of term 17 of vocabulary 9 (j=1)',
  'weight' => '25',
))
->values(array(
  'tid' => '18',
  'vid' => '9',
  'name' => 'term 18 of vocabulary 9 (j=2)',
  'description' => 'description of term 18 of vocabulary 9 (j=2)',
  'weight' => '26',
))
->values(array(
  'tid' => '19',
  'vid' => '10',
  'name' => 'term 19 of vocabulary 10 (j=0)',
  'description' => 'description of term 19 of vocabulary 10 (j=0)',
  'weight' => '27',
))
->values(array(
  'tid' => '20',
  'vid' => '11',
  'name' => 'term 20 of vocabulary 11 (j=0)',
  'description' => 'description of term 20 of vocabulary 11 (j=0)',
  'weight' => '30',
))
->values(array(
  'tid' => '21',
  'vid' => '11',
  'name' => 'term 21 of vocabulary 11 (j=1)',
  'description' => 'description of term 21 of vocabulary 11 (j=1)',
  'weight' => '31',
))
->values(array(
  'tid' => '22',
  'vid' => '12',
  'name' => 'term 22 of vocabulary 12 (j=0)',
  'description' => 'description of term 22 of vocabulary 12 (j=0)',
  'weight' => '33',
))
->values(array(
  'tid' => '23',
  'vid' => '12',
  'name' => 'term 23 of vocabulary 12 (j=1)',
  'description' => 'description of term 23 of vocabulary 12 (j=1)',
  'weight' => '34',
))
->values(array(
  'tid' => '24',
  'vid' => '12',
  'name' => 'term 24 of vocabulary 12 (j=2)',
  'description' => 'description of term 24 of vocabulary 12 (j=2)',
  'weight' => '35',
))
->values(array(
  'tid' => '25',
  'vid' => '13',
  'name' => 'term 25 of vocabulary 13 (j=0)',
  'description' => 'description of term 25 of vocabulary 13 (j=0)',
  'weight' => '36',
))
->values(array(
  'tid' => '26',
  'vid' => '14',
  'name' => 'term 26 of vocabulary 14 (j=0)',
  'description' => 'description of term 26 of vocabulary 14 (j=0)',
  'weight' => '39',
))
->values(array(
  'tid' => '27',
  'vid' => '14',
  'name' => 'term 27 of vocabulary 14 (j=1)',
  'description' => 'description of term 27 of vocabulary 14 (j=1)',
  'weight' => '40',
))
->values(array(
  'tid' => '28',
  'vid' => '15',
  'name' => 'term 28 of vocabulary 15 (j=0)',
  'description' => 'description of term 28 of vocabulary 15 (j=0)',
  'weight' => '42',
))
->values(array(
  'tid' => '29',
  'vid' => '15',
  'name' => 'term 29 of vocabulary 15 (j=1)',
  'description' => 'description of term 29 of vocabulary 15 (j=1)',
  'weight' => '43',
))
->values(array(
  'tid' => '30',
  'vid' => '15',
  'name' => 'term 30 of vocabulary 15 (j=2)',
  'description' => 'description of term 30 of vocabulary 15 (j=2)',
  'weight' => '44',
))
->values(array(
  'tid' => '31',
  'vid' => '16',
  'name' => 'term 31 of vocabulary 16 (j=0)',
  'description' => 'description of term 31 of vocabulary 16 (j=0)',
  'weight' => '45',
))
->values(array(
  'tid' => '32',
  'vid' => '17',
  'name' => 'term 32 of vocabulary 17 (j=0)',
  'description' => 'description of term 32 of vocabulary 17 (j=0)',
  'weight' => '48',
))
->values(array(
  'tid' => '33',
  'vid' => '17',
  'name' => 'term 33 of vocabulary 17 (j=1)',
  'description' => 'description of term 33 of vocabulary 17 (j=1)',
  'weight' => '49',
))
->values(array(
  'tid' => '34',
  'vid' => '18',
  'name' => 'term 34 of vocabulary 18 (j=0)',
  'description' => 'description of term 34 of vocabulary 18 (j=0)',
  'weight' => '51',
))
->values(array(
  'tid' => '35',
  'vid' => '18',
  'name' => 'term 35 of vocabulary 18 (j=1)',
  'description' => 'description of term 35 of vocabulary 18 (j=1)',
  'weight' => '52',
))
->values(array(
  'tid' => '36',
  'vid' => '18',
  'name' => 'term 36 of vocabulary 18 (j=2)',
  'description' => 'description of term 36 of vocabulary 18 (j=2)',
  'weight' => '53',
))
->values(array(
  'tid' => '37',
  'vid' => '19',
  'name' => 'term 37 of vocabulary 19 (j=0)',
  'description' => 'description of term 37 of vocabulary 19 (j=0)',
  'weight' => '54',
))
->values(array(
  'tid' => '38',
  'vid' => '20',
  'name' => 'term 38 of vocabulary 20 (j=0)',
  'description' => 'description of term 38 of vocabulary 20 (j=0)',
  'weight' => '57',
))
->values(array(
  'tid' => '39',
  'vid' => '20',
  'name' => 'term 39 of vocabulary 20 (j=1)',
  'description' => 'description of term 39 of vocabulary 20 (j=1)',
  'weight' => '58',
))
->values(array(
  'tid' => '40',
  'vid' => '21',
  'name' => 'term 40 of vocabulary 21 (j=0)',
  'description' => 'description of term 40 of vocabulary 21 (j=0)',
  'weight' => '60',
))
->values(array(
  'tid' => '41',
  'vid' => '21',
  'name' => 'term 41 of vocabulary 21 (j=1)',
  'description' => 'description of term 41 of vocabulary 21 (j=1)',
  'weight' => '61',
))
->values(array(
  'tid' => '42',
  'vid' => '21',
  'name' => 'term 42 of vocabulary 21 (j=2)',
  'description' => 'description of term 42 of vocabulary 21 (j=2)',
  'weight' => '62',
))
->values(array(
  'tid' => '43',
  'vid' => '22',
  'name' => 'term 43 of vocabulary 22 (j=0)',
  'description' => 'description of term 43 of vocabulary 22 (j=0)',
  'weight' => '63',
))
->values(array(
  'tid' => '44',
  'vid' => '23',
  'name' => 'term 44 of vocabulary 23 (j=0)',
  'description' => 'description of term 44 of vocabulary 23 (j=0)',
  'weight' => '66',
))
->values(array(
  'tid' => '45',
  'vid' => '23',
  'name' => 'term 45 of vocabulary 23 (j=1)',
  'description' => 'description of term 45 of vocabulary 23 (j=1)',
  'weight' => '67',
))
->values(array(
  'tid' => '46',
  'vid' => '24',
  'name' => 'term 46 of vocabulary 24 (j=0)',
  'description' => 'description of term 46 of vocabulary 24 (j=0)',
  'weight' => '69',
))
->values(array(
  'tid' => '47',
  'vid' => '24',
  'name' => 'term 47 of vocabulary 24 (j=1)',
  'description' => 'description of term 47 of vocabulary 24 (j=1)',
  'weight' => '70',
))
->values(array(
  'tid' => '48',
  'vid' => '24',
  'name' => 'term 48 of vocabulary 24 (j=2)',
  'description' => 'description of term 48 of vocabulary 24 (j=2)',
  'weight' => '71',
))
->execute();

db_create_table('term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'parent' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'parent' => array(
      'parent',
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'module' => 'taxonomy',
  'name' => 'term_hierarchy',
));
db_insert('term_hierarchy')->fields(array(
  'tid',
  'parent',
))
->values(array(
  'tid' => '1',
  'parent' => '0',
))
->values(array(
  'tid' => '2',
  'parent' => '0',
))
->values(array(
  'tid' => '4',
  'parent' => '0',
))
->values(array(
  'tid' => '7',
  'parent' => '0',
))
->values(array(
  'tid' => '8',
  'parent' => '0',
))
->values(array(
  'tid' => '10',
  'parent' => '0',
))
->values(array(
  'tid' => '13',
  'parent' => '0',
))
->values(array(
  'tid' => '14',
  'parent' => '0',
))
->values(array(
  'tid' => '16',
  'parent' => '0',
))
->values(array(
  'tid' => '19',
  'parent' => '0',
))
->values(array(
  'tid' => '20',
  'parent' => '0',
))
->values(array(
  'tid' => '22',
  'parent' => '0',
))
->values(array(
  'tid' => '25',
  'parent' => '0',
))
->values(array(
  'tid' => '26',
  'parent' => '0',
))
->values(array(
  'tid' => '28',
  'parent' => '0',
))
->values(array(
  'tid' => '31',
  'parent' => '0',
))
->values(array(
  'tid' => '32',
  'parent' => '0',
))
->values(array(
  'tid' => '34',
  'parent' => '0',
))
->values(array(
  'tid' => '37',
  'parent' => '0',
))
->values(array(
  'tid' => '38',
  'parent' => '0',
))
->values(array(
  'tid' => '40',
  'parent' => '0',
))
->values(array(
  'tid' => '43',
  'parent' => '0',
))
->values(array(
  'tid' => '44',
  'parent' => '0',
))
->values(array(
  'tid' => '46',
  'parent' => '0',
))
->values(array(
  'tid' => '3',
  'parent' => '2',
))
->values(array(
  'tid' => '5',
  'parent' => '4',
))
->values(array(
  'tid' => '6',
  'parent' => '4',
))
->values(array(
  'tid' => '6',
  'parent' => '5',
))
->values(array(
  'tid' => '9',
  'parent' => '8',
))
->values(array(
  'tid' => '11',
  'parent' => '10',
))
->values(array(
  'tid' => '12',
  'parent' => '10',
))
->values(array(
  'tid' => '12',
  'parent' => '11',
))
->values(array(
  'tid' => '15',
  'parent' => '14',
))
->values(array(
  'tid' => '17',
  'parent' => '16',
))
->values(array(
  'tid' => '18',
  'parent' => '16',
))
->values(array(
  'tid' => '18',
  'parent' => '17',
))
->values(array(
  'tid' => '21',
  'parent' => '20',
))
->values(array(
  'tid' => '23',
  'parent' => '22',
))
->values(array(
  'tid' => '24',
  'parent' => '22',
))
->values(array(
  'tid' => '24',
  'parent' => '23',
))
->values(array(
  'tid' => '27',
  'parent' => '26',
))
->values(array(
  'tid' => '29',
  'parent' => '28',
))
->values(array(
  'tid' => '30',
  'parent' => '28',
))
->values(array(
  'tid' => '30',
  'parent' => '29',
))
->values(array(
  'tid' => '33',
  'parent' => '32',
))
->values(array(
  'tid' => '35',
  'parent' => '34',
))
->values(array(
  'tid' => '36',
  'parent' => '34',
))
->values(array(
  'tid' => '36',
  'parent' => '35',
))
->values(array(
  'tid' => '39',
  'parent' => '38',
))
->values(array(
  'tid' => '41',
  'parent' => '40',
))
->values(array(
  'tid' => '42',
  'parent' => '40',
))
->values(array(
  'tid' => '42',
  'parent' => '41',
))
->values(array(
  'tid' => '45',
  'parent' => '44',
))
->values(array(
  'tid' => '47',
  'parent' => '46',
))
->values(array(
  'tid' => '48',
  'parent' => '46',
))
->values(array(
  'tid' => '48',
  'parent' => '47',
))
->execute();

db_create_table('term_node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'vid' => array(
      'vid',
    ),
    'nid' => array(
      'nid',
    ),
  ),
  'primary key' => array(
    'tid',
    'vid',
  ),
  'module' => 'taxonomy',
  'name' => 'term_node',
));
db_insert('term_node')->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'tid' => '0',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'tid' => '1',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '2',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '3',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '4',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '5',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '6',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '7',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '8',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '9',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '10',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '11',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '12',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '13',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '14',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '15',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '16',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '17',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '18',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '19',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '20',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '21',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '22',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '23',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '24',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '25',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '26',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '27',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '28',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '29',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '30',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '31',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '32',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '33',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '34',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '35',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '36',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '37',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '38',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '39',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '40',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '41',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '42',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '43',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '44',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '45',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '46',
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'tid' => '47',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'tid' => '48',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '1',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'tid' => '2',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '3',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '4',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '5',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '6',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '7',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '8',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '9',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '10',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '11',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '12',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '13',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '14',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '15',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '16',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '17',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '18',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '19',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '20',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '21',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '22',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '23',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '24',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '25',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '26',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '27',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '28',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '29',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '30',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '31',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '32',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '33',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '34',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '35',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '36',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '37',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '38',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '39',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '40',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '41',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '42',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '43',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '44',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '45',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '46',
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'tid' => '47',
))
->values(array(
  'nid' => '2',
  'vid' => '4',
  'tid' => '48',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '1',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '2',
))
->values(array(
  'nid' => '3',
  'vid' => '5',
  'tid' => '3',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '4',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '5',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '6',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '7',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '8',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '9',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '10',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '11',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '12',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '13',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '14',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '15',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '16',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '17',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '18',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '19',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '20',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '21',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '22',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '23',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '24',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '25',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '26',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '27',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '28',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '29',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '30',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '31',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '32',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '33',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '34',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '35',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '36',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '37',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '38',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '39',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '40',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '41',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '42',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '43',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '44',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '45',
))
->values(array(
  'nid' => '3',
  'vid' => '5',
  'tid' => '46',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '47',
))
->values(array(
  'nid' => '3',
  'vid' => '6',
  'tid' => '48',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '1',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '2',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '3',
))
->values(array(
  'nid' => '4',
  'vid' => '7',
  'tid' => '4',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '5',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '6',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '7',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '8',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '9',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '10',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '11',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '12',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '13',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '14',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '15',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '16',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '17',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '18',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '19',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '20',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '21',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '22',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '23',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '24',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '25',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '26',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '27',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '28',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '29',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '30',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '31',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '32',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '33',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '34',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '35',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '36',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '37',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '38',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '39',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '40',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '41',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '42',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '43',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '44',
))
->values(array(
  'nid' => '4',
  'vid' => '7',
  'tid' => '45',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '46',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '47',
))
->values(array(
  'nid' => '4',
  'vid' => '8',
  'tid' => '48',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '1',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '2',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '3',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '4',
))
->values(array(
  'nid' => '5',
  'vid' => '9',
  'tid' => '5',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '6',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '7',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '8',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '9',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '10',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '11',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '12',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '13',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '14',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '15',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '16',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '17',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '18',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '19',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '20',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '21',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '22',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '23',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '24',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '25',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '26',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '27',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '28',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '29',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '30',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '31',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '32',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '33',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '34',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '35',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '36',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '37',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '38',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '39',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '40',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '41',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '42',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '43',
))
->values(array(
  'nid' => '5',
  'vid' => '9',
  'tid' => '44',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '45',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '46',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '47',
))
->values(array(
  'nid' => '5',
  'vid' => '10',
  'tid' => '48',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '1',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '2',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '3',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '4',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '5',
))
->values(array(
  'nid' => '6',
  'vid' => '11',
  'tid' => '6',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '7',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '8',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '9',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '10',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '11',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '12',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '13',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '14',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '15',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '16',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '17',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '18',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '19',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '20',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '21',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '22',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '23',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '24',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '25',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '26',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '27',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '28',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '29',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '30',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '31',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '32',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '33',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '34',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '35',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '36',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '37',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '38',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '39',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '40',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '41',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '42',
))
->values(array(
  'nid' => '6',
  'vid' => '11',
  'tid' => '43',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '44',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '45',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '46',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '47',
))
->values(array(
  'nid' => '6',
  'vid' => '12',
  'tid' => '48',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '1',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '2',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '3',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '4',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '5',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '6',
))
->values(array(
  'nid' => '7',
  'vid' => '13',
  'tid' => '7',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '8',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '9',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '10',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '11',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '12',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '13',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '14',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '15',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '16',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '17',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '18',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '19',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '20',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '21',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '22',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '23',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '24',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '25',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '26',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '27',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '28',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '29',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '30',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '31',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '32',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '33',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '34',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '35',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '36',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '37',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '38',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '39',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '40',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '41',
))
->values(array(
  'nid' => '7',
  'vid' => '13',
  'tid' => '42',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '43',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '44',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '45',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '46',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '47',
))
->values(array(
  'nid' => '7',
  'vid' => '14',
  'tid' => '48',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '1',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '2',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '3',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '4',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '5',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '6',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '7',
))
->values(array(
  'nid' => '8',
  'vid' => '15',
  'tid' => '8',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '9',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '10',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '11',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '12',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '13',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '14',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '15',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '16',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '17',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '18',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '19',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '20',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '21',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '22',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '23',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '24',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '25',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '26',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '27',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '28',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '29',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '30',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '31',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '32',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '33',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '34',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '35',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '36',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '37',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '38',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '39',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '40',
))
->values(array(
  'nid' => '8',
  'vid' => '15',
  'tid' => '41',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '42',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '43',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '44',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '45',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '46',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '47',
))
->values(array(
  'nid' => '8',
  'vid' => '16',
  'tid' => '48',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '1',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '2',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '3',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '4',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '5',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '6',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '7',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '8',
))
->values(array(
  'nid' => '9',
  'vid' => '17',
  'tid' => '9',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '10',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '11',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '12',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '13',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '14',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '15',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '16',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '17',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '18',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '19',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '20',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '21',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '22',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '23',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '24',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '25',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '26',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '27',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '28',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '29',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '30',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '31',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '32',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '33',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '34',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '35',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '36',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '37',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '38',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '39',
))
->values(array(
  'nid' => '9',
  'vid' => '17',
  'tid' => '40',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '41',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '42',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '43',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '44',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '45',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '46',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '47',
))
->values(array(
  'nid' => '9',
  'vid' => '18',
  'tid' => '48',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '1',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '2',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '3',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '4',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '5',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '6',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '7',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '8',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '9',
))
->values(array(
  'nid' => '10',
  'vid' => '19',
  'tid' => '10',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '11',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '12',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '13',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '14',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '15',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '16',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '17',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '18',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '19',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '20',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '21',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '22',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '23',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '24',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '25',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '26',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '27',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '28',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '29',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '30',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '31',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '32',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '33',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '34',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '35',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '36',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '37',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '38',
))
->values(array(
  'nid' => '10',
  'vid' => '19',
  'tid' => '39',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '40',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '41',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '42',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '43',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '44',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '45',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '46',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '47',
))
->values(array(
  'nid' => '10',
  'vid' => '20',
  'tid' => '48',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '1',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '2',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '3',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '4',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '5',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '6',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '7',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '8',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '9',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '10',
))
->values(array(
  'nid' => '11',
  'vid' => '21',
  'tid' => '11',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '12',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '13',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '14',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '15',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '16',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '17',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '18',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '19',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '20',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '21',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '22',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '23',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '24',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '25',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '26',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '27',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '28',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '29',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '30',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '31',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '32',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '33',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '34',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '35',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '36',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '37',
))
->values(array(
  'nid' => '11',
  'vid' => '21',
  'tid' => '38',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '39',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '40',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '41',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '42',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '43',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '44',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '45',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '46',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '47',
))
->values(array(
  'nid' => '11',
  'vid' => '22',
  'tid' => '48',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '1',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '2',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '3',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '4',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '5',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '6',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '7',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '8',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '9',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '10',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '11',
))
->values(array(
  'nid' => '12',
  'vid' => '23',
  'tid' => '12',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '13',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '14',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '15',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '16',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '17',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '18',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '19',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '20',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '21',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '22',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '23',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '24',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '25',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '26',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '27',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '28',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '29',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '30',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '31',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '32',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '33',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '34',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '35',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '36',
))
->values(array(
  'nid' => '12',
  'vid' => '23',
  'tid' => '37',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '38',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '39',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '40',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '41',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '42',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '43',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '44',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '45',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '46',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '47',
))
->values(array(
  'nid' => '12',
  'vid' => '24',
  'tid' => '48',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '1',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '2',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '3',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '4',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '5',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '6',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '7',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '8',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '9',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '10',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '11',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '12',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '14',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '15',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '16',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '17',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '18',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '19',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '20',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '21',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '22',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '23',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '24',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '25',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '26',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '27',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '28',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '29',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '30',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '31',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '32',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '33',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '34',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '35',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '37',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '38',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '39',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '40',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '41',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '42',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '43',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '44',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '45',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '46',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '47',
))
->values(array(
  'nid' => '13',
  'vid' => '25',
  'tid' => '48',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '1',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '2',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '3',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '4',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '5',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '6',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '7',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '8',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '9',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '10',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '11',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '12',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '13',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '15',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '16',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '17',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '18',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '19',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '20',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '21',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '22',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '23',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '24',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '25',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '26',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '27',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '28',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '29',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '30',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '31',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '32',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '33',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '34',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '36',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '37',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '38',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '39',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '40',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '41',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '42',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '43',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '44',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '45',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '46',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '47',
))
->values(array(
  'nid' => '14',
  'vid' => '26',
  'tid' => '48',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '1',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '2',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '3',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '4',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '5',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '6',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '7',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '8',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '9',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '10',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '11',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '12',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '13',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '14',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '16',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '17',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '18',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '19',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '20',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '21',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '22',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '23',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '24',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '25',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '26',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '27',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '28',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '29',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '30',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '31',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '32',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '33',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '35',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '36',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '37',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '38',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '39',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '40',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '41',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '42',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '43',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '44',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '45',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '46',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '47',
))
->values(array(
  'nid' => '15',
  'vid' => '27',
  'tid' => '48',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '1',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '2',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '3',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '4',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '5',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '6',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '7',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '8',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '9',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '10',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '11',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '12',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '13',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '14',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '15',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '17',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '18',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '19',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '20',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '21',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '22',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '23',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '24',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '25',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '26',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '27',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '28',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '29',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '30',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '31',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '32',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '34',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '35',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '36',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '37',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '38',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '39',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '40',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '41',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '42',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '43',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '44',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '45',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '46',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '47',
))
->values(array(
  'nid' => '16',
  'vid' => '28',
  'tid' => '48',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '1',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '2',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '3',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '4',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '5',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '6',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '7',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '8',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '9',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '10',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '11',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '12',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '13',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '14',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '15',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '16',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '18',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '19',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '20',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '21',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '22',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '23',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '24',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '25',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '26',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '27',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '28',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '29',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '30',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '31',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '33',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '34',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '35',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '36',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '37',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '38',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '39',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '40',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '41',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '42',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '43',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '44',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '45',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '46',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '47',
))
->values(array(
  'nid' => '17',
  'vid' => '29',
  'tid' => '48',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '1',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '2',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '3',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '4',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '5',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '6',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '7',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '8',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '9',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '10',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '11',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '12',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '13',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '14',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '15',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '16',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '17',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '19',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '20',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '21',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '22',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '23',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '24',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '25',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '26',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '27',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '28',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '29',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '30',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '32',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '33',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '34',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '35',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '36',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '37',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '38',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '39',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '40',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '41',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '42',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '43',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '44',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '45',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '46',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '47',
))
->values(array(
  'nid' => '18',
  'vid' => '30',
  'tid' => '48',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '1',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '2',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '3',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '4',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '5',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '6',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '7',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '8',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '9',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '10',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '11',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '12',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '13',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '14',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '15',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '16',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '17',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '18',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '20',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '21',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '22',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '23',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '24',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '25',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '26',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '27',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '28',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '29',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '31',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '32',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '33',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '34',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '35',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '36',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '37',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '38',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '39',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '40',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '41',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '42',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '43',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '44',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '45',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '46',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '47',
))
->values(array(
  'nid' => '19',
  'vid' => '31',
  'tid' => '48',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '1',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '2',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '3',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '4',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '5',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '6',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '7',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '8',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '9',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '10',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '11',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '12',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '13',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '14',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '15',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '16',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '17',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '18',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '19',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '21',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '22',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '23',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '24',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '25',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '26',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '27',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '28',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '30',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '31',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '32',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '33',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '34',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '35',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '36',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '37',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '38',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '39',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '40',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '41',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '42',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '43',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '44',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '45',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '46',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '47',
))
->values(array(
  'nid' => '20',
  'vid' => '32',
  'tid' => '48',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '1',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '2',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '3',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '4',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '5',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '6',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '7',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '8',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '9',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '10',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '11',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '12',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '13',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '14',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '15',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '16',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '17',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '18',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '19',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '20',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '22',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '23',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '24',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '25',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '26',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '27',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '29',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '30',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '31',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '32',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '33',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '34',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '35',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '36',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '37',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '38',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '39',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '40',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '41',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '42',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '43',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '44',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '45',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '46',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '47',
))
->values(array(
  'nid' => '21',
  'vid' => '33',
  'tid' => '48',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '1',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '2',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '3',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '4',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '5',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '6',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '7',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '8',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '9',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '10',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '11',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '12',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '13',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '14',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '15',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '16',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '17',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '18',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '19',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '20',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '21',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '23',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '24',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '25',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '26',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '28',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '29',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '30',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '31',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '32',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '33',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '34',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '35',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '36',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '37',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '38',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '39',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '40',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '41',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '42',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '43',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '44',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '45',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '46',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '47',
))
->values(array(
  'nid' => '22',
  'vid' => '34',
  'tid' => '48',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '1',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '2',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '3',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '4',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '5',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '6',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '7',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '8',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '9',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '10',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '11',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '12',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '13',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '14',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '15',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '16',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '17',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '18',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '19',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '20',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '21',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '22',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '24',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '25',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '27',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '28',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '29',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '30',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '31',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '32',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '33',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '34',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '35',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '36',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '37',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '38',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '39',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '40',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '41',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '42',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '43',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '44',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '45',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '46',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '47',
))
->values(array(
  'nid' => '23',
  'vid' => '35',
  'tid' => '48',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '1',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '2',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '3',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '4',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '5',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '6',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '7',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '8',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '9',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '10',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '11',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '12',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '13',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '14',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '15',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '16',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '17',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '18',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '19',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '20',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '21',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '22',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '23',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '26',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '27',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '28',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '29',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '30',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '31',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '32',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '33',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '34',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '35',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '36',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '37',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '38',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '39',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '40',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '41',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '42',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '43',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '44',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '45',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '46',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '47',
))
->values(array(
  'nid' => '24',
  'vid' => '36',
  'tid' => '48',
))
->execute();

db_create_table('term_relation', array(
  'fields' => array(
    'trid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'tid1' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'tid2' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'unique keys' => array(
    'tid1_tid2' => array(
      'tid1',
      'tid2',
    ),
  ),
  'indexes' => array(
    'tid2' => array(
      'tid2',
    ),
  ),
  'primary key' => array(
    'trid',
  ),
  'module' => 'taxonomy',
  'name' => 'term_relation',
));

db_create_table('term_synonym', array(
  'fields' => array(
    'tsid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'indexes' => array(
    'tid' => array(
      'tid',
    ),
    'name_tid' => array(
      'name',
      'tid',
    ),
  ),
  'primary key' => array(
    'tsid',
  ),
  'module' => 'taxonomy',
  'name' => 'term_synonym',
));

db_create_table('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'src' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'dst' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'unique keys' => array(
    'dst_language_pid' => array(
      'dst',
      'language',
      'pid',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'indexes' => array(
    'src_language_pid' => array(
      'src',
      'language',
      'pid',
    ),
  ),
  'module' => 'system',
  'name' => 'url_alias',
));
db_insert('url_alias')->fields(array(
  'pid',
  'src',
  'dst',
  'language',
))
->values(array(
  'pid' => '1',
  'src' => 'node/1',
  'dst' => 'content/1262732400',
  'language' => '',
))
->values(array(
  'pid' => '2',
  'src' => 'node/2',
  'dst' => 'content/1262818800',
  'language' => '',
))
->values(array(
  'pid' => '3',
  'src' => 'node/3',
  'dst' => 'content/1262905200',
  'language' => '',
))
->values(array(
  'pid' => '4',
  'src' => 'node/4',
  'dst' => 'content/1262991600',
  'language' => '',
))
->values(array(
  'pid' => '5',
  'src' => 'node/5',
  'dst' => 'content/1263078000',
  'language' => '',
))
->values(array(
  'pid' => '6',
  'src' => 'node/6',
  'dst' => 'content/1263164400',
  'language' => '',
))
->values(array(
  'pid' => '7',
  'src' => 'node/7',
  'dst' => 'content/1263250800',
  'language' => '',
))
->values(array(
  'pid' => '8',
  'src' => 'node/8',
  'dst' => 'content/1263337200',
  'language' => '',
))
->values(array(
  'pid' => '9',
  'src' => 'node/9',
  'dst' => 'content/1263423600',
  'language' => '',
))
->values(array(
  'pid' => '10',
  'src' => 'node/10',
  'dst' => 'content/1263510000',
  'language' => '',
))
->values(array(
  'pid' => '11',
  'src' => 'node/11',
  'dst' => 'content/1263596400',
  'language' => '',
))
->values(array(
  'pid' => '12',
  'src' => 'node/12',
  'dst' => 'content/1263682800',
  'language' => '',
))
->values(array(
  'pid' => '13',
  'src' => 'node/13',
  'dst' => 'content/1263769200',
  'language' => '',
))
->values(array(
  'pid' => '14',
  'src' => 'node/14',
  'dst' => 'content/1263855600',
  'language' => '',
))
->values(array(
  'pid' => '15',
  'src' => 'node/15',
  'dst' => 'content/1263942000',
  'language' => '',
))
->values(array(
  'pid' => '16',
  'src' => 'node/16',
  'dst' => 'content/1264028400',
  'language' => '',
))
->values(array(
  'pid' => '17',
  'src' => 'node/17',
  'dst' => 'content/1264114800',
  'language' => '',
))
->values(array(
  'pid' => '18',
  'src' => 'node/18',
  'dst' => 'content/1264201200',
  'language' => '',
))
->values(array(
  'pid' => '19',
  'src' => 'node/19',
  'dst' => 'content/1264287600',
  'language' => '',
))
->values(array(
  'pid' => '20',
  'src' => 'node/20',
  'dst' => 'content/1264374000',
  'language' => '',
))
->values(array(
  'pid' => '21',
  'src' => 'node/21',
  'dst' => 'content/1264460400',
  'language' => '',
))
->values(array(
  'pid' => '22',
  'src' => 'node/22',
  'dst' => 'content/1264546800',
  'language' => '',
))
->values(array(
  'pid' => '23',
  'src' => 'node/23',
  'dst' => 'content/1264633200',
  'language' => '',
))
->values(array(
  'pid' => '24',
  'src' => 'node/24',
  'dst' => 'content/1264719600',
  'language' => '',
))
->values(array(
  'pid' => '25',
  'src' => 'node/25',
  'dst' => 'content/poll/0',
  'language' => '',
))
->values(array(
  'pid' => '26',
  'src' => 'node/25/results',
  'dst' => 'content/poll/0/results',
  'language' => '',
))
->values(array(
  'pid' => '27',
  'src' => 'node/26',
  'dst' => 'content/poll/1',
  'language' => '',
))
->values(array(
  'pid' => '28',
  'src' => 'node/26/results',
  'dst' => 'content/poll/1/results',
  'language' => '',
))
->values(array(
  'pid' => '29',
  'src' => 'node/27',
  'dst' => 'content/poll/2',
  'language' => '',
))
->values(array(
  'pid' => '30',
  'src' => 'node/27/results',
  'dst' => 'content/poll/2/results',
  'language' => '',
))
->values(array(
  'pid' => '31',
  'src' => 'node/28',
  'dst' => 'content/poll/3',
  'language' => '',
))
->values(array(
  'pid' => '32',
  'src' => 'node/28/results',
  'dst' => 'content/poll/3/results',
  'language' => '',
))
->values(array(
  'pid' => '33',
  'src' => 'node/29',
  'dst' => 'content/poll/4',
  'language' => '',
))
->values(array(
  'pid' => '34',
  'src' => 'node/29/results',
  'dst' => 'content/poll/4/results',
  'language' => '',
))
->values(array(
  'pid' => '35',
  'src' => 'node/30',
  'dst' => 'content/poll/5',
  'language' => '',
))
->values(array(
  'pid' => '36',
  'src' => 'node/30/results',
  'dst' => 'content/poll/5/results',
  'language' => '',
))
->values(array(
  'pid' => '37',
  'src' => 'node/31',
  'dst' => 'content/poll/6',
  'language' => '',
))
->values(array(
  'pid' => '38',
  'src' => 'node/31/results',
  'dst' => 'content/poll/6/results',
  'language' => '',
))
->values(array(
  'pid' => '39',
  'src' => 'node/32',
  'dst' => 'content/poll/7',
  'language' => '',
))
->values(array(
  'pid' => '40',
  'src' => 'node/32/results',
  'dst' => 'content/poll/7/results',
  'language' => '',
))
->values(array(
  'pid' => '41',
  'src' => 'node/33',
  'dst' => 'content/poll/8',
  'language' => '',
))
->values(array(
  'pid' => '42',
  'src' => 'node/33/results',
  'dst' => 'content/poll/8/results',
  'language' => '',
))
->values(array(
  'pid' => '43',
  'src' => 'node/34',
  'dst' => 'content/poll/9',
  'language' => '',
))
->values(array(
  'pid' => '44',
  'src' => 'node/34/results',
  'dst' => 'content/poll/9/results',
  'language' => '',
))
->values(array(
  'pid' => '45',
  'src' => 'node/35',
  'dst' => 'content/poll/10',
  'language' => '',
))
->values(array(
  'pid' => '46',
  'src' => 'node/35/results',
  'dst' => 'content/poll/10/results',
  'language' => '',
))
->values(array(
  'pid' => '47',
  'src' => 'node/36',
  'dst' => 'content/poll/11',
  'language' => '',
))
->values(array(
  'pid' => '48',
  'src' => 'node/36/results',
  'dst' => 'content/poll/11/results',
  'language' => '',
))
->values(array(
  'pid' => '49',
  'src' => 'node/37',
  'dst' => 'content/1263769200',
  'language' => '',
))
->execute();

db_create_table('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => TRUE,
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => FALSE,
      'default' => '',
    ),
    'mode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'sort' => array(
      'type' => 'int',
      'not null' => FALSE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'threshold' => array(
      'type' => 'int',
      'not null' => FALSE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'theme' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'length' => 8,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
    'picture' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'init' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => FALSE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'indexes' => array(
    'access' => array(
      'access',
    ),
    'created' => array(
      'created',
    ),
    'mail' => array(
      'mail',
    ),
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'module' => 'user',
  'name' => 'users',
));
db_insert('users')->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'mode',
  'sort',
  'threshold',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
))
->values(array(
  'uid' => 1,
  'name' => '',
  'pass' => '',
  'mail' => '',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '0',
  'access' => '0',
  'login' => '0',
  'status' => '0',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 2,
  'name' => 'admin',
  'pass' => '21232f297a57a5a743894a0e4a801fc3',
  'mail' => 'admin@aexample.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1282936261',
  'access' => '1282936264',
  'login' => '1282936263',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => 'admin@aexample.com',
  'data' => 'a:0:{}',
))
->values(array(
  'uid' => 4,
  'name' => 'test user 0',
  'pass' => '4dd188028f74622e61048f6683208c2f',
  'mail' => 'test0@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262300400',
  'access' => '1262300400',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 5,
  'name' => 'test user 1',
  'pass' => '388ee5249286bf5eed0dae9205743969',
  'mail' => 'test1@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262386800',
  'access' => '1262386800',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 6,
  'name' => 'test user 2',
  'pass' => 'ff8a825362e1e06dca5c13c60fe407c9',
  'mail' => 'test2@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262473200',
  'access' => '1262473200',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 7,
  'name' => 'test user 3',
  'pass' => '9d4bd7b0570cb513dc7c6ea8de15003a',
  'mail' => 'test3@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262559600',
  'access' => '1262559600',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 8,
  'name' => 'test user 4',
  'pass' => '7903c9dd9d71bcd70e3a18141711cb42',
  'mail' => 'test4@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262646000',
  'access' => '1262646000',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => 9,
  'name' => 'test user 5',
  'pass' => '8eb7221204ea80db4e66247b4c748071',
  'mail' => 'test5@example.com',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '1262732400',
  'access' => '1262732400',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => '',
  'data' => NULL,
))
->execute();
db_query('UPDATE {users} SET uid = uid - 1');

db_create_table('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'module' => 'user',
  'name' => 'users_roles',
));

db_create_table('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'module' => 'system',
  'name' => 'variable',
));
db_insert('variable')->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'clean_url',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1282936266;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:20:"i0000000000000000000";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:6:"-39600";',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:64:"c2f015f78636f97527f2ce6c0869fccd1c7a674005ed203d48b106cbd6db3947";',
))
->values(array(
  'name' => 'file_directory_temp',
  'value' => 's:29:"/drupal-6/file/directory/temp";',
))
->values(array(
  'name' => 'file_directory_path',
  'value' => 's:29:"/drupal-6/file/directory/path";',
))
->values(array(
  'name' => 'file_downloads',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'filter_html_1',
  'value' => 'i:1;',
))
// Add the Escape HTML filter to the custom input format 'Escape HTML Filter'
// to test that the filter may be upgraded to its Drupal 7 equivalent.
->values(array(
  'name' => 'filter_html_3',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:7:"default";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1282936263;',
))
->values(array(
  'name' => 'javascript_parsed',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:17:{i:0;i:62;i:1;i:61;i:2;i:59;i:3;i:31;i:4;i:30;i:5;i:29;i:6;i:24;i:7;i:21;i:8;i:15;i:9;i:14;i:10;i:11;i:11;i:7;i:12;i:6;i:13;i:5;i:14;i:3;i:15;i:2;i:16;i:1;}',
))
->values(array(
  'name' => 'node_options_forum',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:21:"site_mail@example.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:9:"site_name";',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:7:"garland";',
))
->values(array(
  'name' => 'theme_settings',
  'value' => 'a:1:{s:21:"toggle_node_info_page";b:0;}',
))
->values(array(
  'name' => 'update_last_check',
  'value' => 'i:1282936266;',
))
->values(array(
  'name' => 'user_email_verification',
  'value' => 'b:1;',
))
->execute();

db_create_table('vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'help' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'relations' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'hierarchy' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'multiple' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'required' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'tags' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'name',
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'vocabulary',
));
db_insert('vocabulary')->fields(array(
  'vid',
  'name',
  'description',
  'help',
  'relations',
  'hierarchy',
  'multiple',
  'required',
  'tags',
  'module',
  'weight',
))
->values(array(
  'vid' => '1',
  'name' => 'vocabulary 1 (i=0)',
  'description' => 'description of vocabulary 1 (i=0)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'vid' => '2',
  'name' => 'vocabulary 2 (i=1)',
  'description' => 'description of vocabulary 2 (i=1)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '1',
))
->values(array(
  'vid' => '3',
  'name' => 'vocabulary 3 (i=2)',
  'description' => 'description of vocabulary 3 (i=2)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '2',
))
->values(array(
  'vid' => '4',
  'name' => 'vocabulary 4 (i=3)',
  'description' => 'description of vocabulary 4 (i=3)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '3',
))
->values(array(
  'vid' => '5',
  'name' => 'vocabulary 5 (i=4)',
  'description' => 'description of vocabulary 5 (i=4)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '4',
))
->values(array(
  'vid' => '6',
  'name' => 'vocabulary 6 (i=5)',
  'description' => 'description of vocabulary 6 (i=5)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '5',
))
->values(array(
  'vid' => '7',
  'name' => 'vocabulary 7 (i=6)',
  'description' => 'description of vocabulary 7 (i=6)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '6',
))
->values(array(
  'vid' => '8',
  'name' => 'vocabulary 8 (i=7)',
  'description' => 'description of vocabulary 8 (i=7)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '7',
))
->values(array(
  'vid' => '9',
  'name' => 'vocabulary 9 (i=8)',
  'description' => 'description of vocabulary 9 (i=8)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '8',
))
->values(array(
  'vid' => '10',
  'name' => 'vocabulary 10 (i=9)',
  'description' => 'description of vocabulary 10 (i=9)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '9',
))
->values(array(
  'vid' => '11',
  'name' => 'vocabulary 11 (i=10)',
  'description' => 'description of vocabulary 11 (i=10)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '10',
))
->values(array(
  'vid' => '12',
  'name' => 'vocabulary 12 (i=11)',
  'description' => 'description of vocabulary 12 (i=11)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '11',
))
->values(array(
  'vid' => '13',
  'name' => 'vocabulary 13 (i=12)',
  'description' => 'description of vocabulary 13 (i=12)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '12',
))
->values(array(
  'vid' => '14',
  'name' => 'vocabulary 14 (i=13)',
  'description' => 'description of vocabulary 14 (i=13)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '13',
))
->values(array(
  'vid' => '15',
  'name' => 'vocabulary 15 (i=14)',
  'description' => 'description of vocabulary 15 (i=14)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '14',
))
->values(array(
  'vid' => '16',
  'name' => 'vocabulary 16 (i=15)',
  'description' => 'description of vocabulary 16 (i=15)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '15',
))
->values(array(
  'vid' => '17',
  'name' => 'vocabulary 17 (i=16)',
  'description' => 'description of vocabulary 17 (i=16)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '16',
))
->values(array(
  'vid' => '18',
  'name' => 'vocabulary 18 (i=17)',
  'description' => 'description of vocabulary 18 (i=17)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '1',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '17',
))
->values(array(
  'vid' => '19',
  'name' => 'vocabulary 19 (i=18)',
  'description' => 'description of vocabulary 19 (i=18)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '18',
))
->values(array(
  'vid' => '20',
  'name' => 'vocabulary 20 (i=19)',
  'description' => 'description of vocabulary 20 (i=19)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '19',
))
->values(array(
  'vid' => '21',
  'name' => 'vocabulary 21 (i=20)',
  'description' => 'description of vocabulary 21 (i=20)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '20',
))
->values(array(
  'vid' => '22',
  'name' => 'vocabulary 22 (i=21)',
  'description' => 'description of vocabulary 22 (i=21)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '21',
))
->values(array(
  'vid' => '23',
  'name' => 'vocabulary 23 (i=22)',
  'description' => 'description of vocabulary 23 (i=22)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '0',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '22',
))
->values(array(
  'vid' => '24',
  'name' => 'vocabulary 24 (i=23)',
  'description' => 'description of vocabulary 24 (i=23)',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '2',
  'multiple' => '1',
  'required' => '1',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '23',
))
->execute();

db_create_table('vocabulary_node_types', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
    'vid',
  ),
  'indexes' => array(
    'vid' => array(
      'vid',
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'vocabulary_node_types',
));
db_insert('vocabulary_node_types')->fields(array(
  'vid',
  'type',
))
->values(array(
  'vid' => '13',
  'type' => 'page',
))
->values(array(
  'vid' => '14',
  'type' => 'page',
))
->values(array(
  'vid' => '15',
  'type' => 'page',
))
->values(array(
  'vid' => '16',
  'type' => 'page',
))
->values(array(
  'vid' => '17',
  'type' => 'page',
))
->values(array(
  'vid' => '18',
  'type' => 'page',
))
->values(array(
  'vid' => '19',
  'type' => 'page',
))
->values(array(
  'vid' => '20',
  'type' => 'page',
))
->values(array(
  'vid' => '21',
  'type' => 'page',
))
->values(array(
  'vid' => '22',
  'type' => 'page',
))
->values(array(
  'vid' => '23',
  'type' => 'page',
))
->values(array(
  'vid' => '24',
  'type' => 'page',
))
->execute();

db_create_table('watchdog', array(
  'fields' => array(
    'wid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 16,
      'not null' => TRUE,
      'default' => '',
    ),
    'message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'variables' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'severity' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'link' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'referer' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'wid',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
  ),
  'module' => 'dblog',
  'name' => 'watchdog',
));

