"""Generated message classes for dataproc version v1.

Manages Hadoop-based clusters and jobs on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'dataproc'


class CancelJobRequest(_messages.Message):
  """A request to cancel a job."""


class Cluster(_messages.Message):
  """Describes the identifying information, config, and status of a cluster of
  Google Compute Engine instances.

  Fields:
    clusterName: [Required] The cluster name. Cluster names within a project
      must be unique. Names of deleted clusters can be reused.
    clusterUuid: [Output-only] A cluster UUID (Unique Universal Identifier).
      Cloud Dataproc generates this value when it creates the cluster.
    config: [Required] The cluster config. Note that Cloud Dataproc may set
      default values, and values may change when clusters are updated.
    projectId: [Required] The Google Cloud Platform project ID that the
      cluster belongs to.
    status: [Output-only] Cluster status.
    statusHistory: [Output-only] The previous cluster status.
  """

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  config = _messages.MessageField('ClusterConfig', 3)
  projectId = _messages.StringField(4)
  status = _messages.MessageField('ClusterStatus', 5)
  statusHistory = _messages.MessageField('ClusterStatus', 6, repeated=True)


class ClusterConfig(_messages.Message):
  """The cluster config.

  Fields:
    configBucket: [Optional] A Google Cloud Storage staging bucket used for
      sharing generated SSH keys and config. If you do not specify a staging
      bucket, Cloud Dataproc will determine an appropriate Cloud Storage
      location (US, ASIA, or EU) for your cluster's staging bucket according
      to the Google Compute Engine zone where your cluster is deployed, and
      then it will create and manage this project-level, per-location bucket
      for you.
    gceClusterConfig: [Required] The shared Google Compute Engine config
      settings for all instances in a cluster.
    initializationActions: [Optional] Commands to execute on each node after
      config is completed. By default, executables are run on master and all
      worker nodes. You can test a node's <code>role</code> metadata to run an
      executable on a master or worker node, as shown below:
      ROLE=$(/usr/share/google/get_metadata_value attributes/role)     if [[
      "${ROLE}" == 'Master' ]]; then       ... master specific actions ...
      else       ... worker specific actions ...     fi
    masterConfig: [Optional] The Google Compute Engine config settings for the
      master instance in a cluster.
    secondaryWorkerConfig: [Optional] The Google Compute Engine config
      settings for additional worker instances in a cluster.
    softwareConfig: [Optional] The config settings for software inside the
      cluster.
    workerConfig: [Optional] The Google Compute Engine config settings for
      worker instances in a cluster.
  """

  configBucket = _messages.StringField(1)
  gceClusterConfig = _messages.MessageField('GceClusterConfig', 2)
  initializationActions = _messages.MessageField('NodeInitializationAction', 3, repeated=True)
  masterConfig = _messages.MessageField('InstanceGroupConfig', 4)
  secondaryWorkerConfig = _messages.MessageField('InstanceGroupConfig', 5)
  softwareConfig = _messages.MessageField('SoftwareConfig', 6)
  workerConfig = _messages.MessageField('InstanceGroupConfig', 7)


class ClusterOperationMetadata(_messages.Message):
  """Metadata describing the operation.

  Fields:
    clusterName: Name of the cluster for the operation.
    clusterUuid: Cluster UUId for the operation.
    description: [Output-only] Short description of operation.
    operationType: [Output-only] The operation type.
    status: [Output-only] Current operation status.
    statusHistory: [Output-only] The previous operation status.
  """

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  description = _messages.StringField(3)
  operationType = _messages.StringField(4)
  status = _messages.MessageField('ClusterOperationStatus', 5)
  statusHistory = _messages.MessageField('ClusterOperationStatus', 6, repeated=True)


class ClusterOperationStatus(_messages.Message):
  """The status of the operation.

  Enums:
    StateValueValuesEnum: A message containing the operation state.

  Fields:
    details: A message containing any operation metadata details.
    innerState: A message containing the detailed operation state.
    state: A message containing the operation state.
    stateStartTime: The time this state was entered.
  """

  class StateValueValuesEnum(_messages.Enum):
    """A message containing the operation state.

    Values:
      UNKNOWN: Unused.
      PENDING: The operation has been created.
      RUNNING: The operation is running.
      DONE: The operation is done; either cancelled or completed.
    """
    UNKNOWN = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  details = _messages.StringField(1)
  innerState = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  stateStartTime = _messages.StringField(4)


class ClusterStatus(_messages.Message):
  """The status of a cluster and its instances.

  Enums:
    StateValueValuesEnum: The cluster's state.

  Fields:
    detail: Optional details of cluster's state.
    state: The cluster's state.
    stateStartTime: Time when this state was entered.
  """

  class StateValueValuesEnum(_messages.Enum):
    """The cluster's state.

    Values:
      UNKNOWN: The cluster state is unknown.
      CREATING: The cluster is being created and set up. It is not ready for
        use.
      RUNNING: The cluster is currently running and healthy. It is ready for
        use.
      ERROR: The cluster encountered an error. It is not ready for use.
      DELETING: The cluster is being deleted. It cannot be used.
      UPDATING: The cluster is being updated. It continues to accept and
        process jobs.
    """
    UNKNOWN = 0
    CREATING = 1
    RUNNING = 2
    ERROR = 3
    DELETING = 4
    UPDATING = 5

  detail = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  stateStartTime = _messages.StringField(3)


class DataprocProjectsRegionsClustersCreateRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  cluster = _messages.MessageField('Cluster', 1)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsClustersDeleteRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersDeleteRequest object.

  Fields:
    clusterName: [Required] The cluster name.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  clusterName = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsClustersDiagnoseRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersDiagnoseRequest object.

  Fields:
    clusterName: [Required] The cluster name.
    diagnoseClusterRequest: A DiagnoseClusterRequest resource to be passed as
      the request body.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  clusterName = _messages.StringField(1, required=True)
  diagnoseClusterRequest = _messages.MessageField('DiagnoseClusterRequest', 2)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class DataprocProjectsRegionsClustersGetRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersGetRequest object.

  Fields:
    clusterName: [Required] The cluster name.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  clusterName = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsClustersListRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersListRequest object.

  Fields:
    pageSize: The standard List page size.
    pageToken: The standard List page token.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class DataprocProjectsRegionsClustersPatchRequest(_messages.Message):
  """A DataprocProjectsRegionsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterName: [Required] The cluster name.
    projectId: [Required] The ID of the Google Cloud Platform project the
      cluster belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
    updateMask: [Required] Specifies the path, relative to
      <code>Cluster</code>, of the field to update. For example, to change the
      number of workers in a cluster to 5, the <code>update_mask</code>
      parameter would be specified as
      <code>config.worker_config.num_instances</code>, and the `PATCH` request
      body would specify the new value, as follows:      {       "config":{
      "workerConfig":{           "numInstances":"5"         }       }     }
      Similarly, to change the number of preemptible workers in a cluster to
      5, the <code>update_mask</code> parameter would be
      <code>config.secondary_worker_config.num_instances</code>, and the
      `PATCH` request body would be set as follows:      {       "config":{
      "secondaryWorkerConfig":{           "numInstances":"5"         }       }
      } <strong>Note:</strong> Currently,
      <code>config.worker_config.num_instances</code> and
      <code>config.secondary_worker_config.num_instances</code> are the only
      fields that can be updated.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterName = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  updateMask = _messages.StringField(5)


class DataprocProjectsRegionsJobsCancelRequest(_messages.Message):
  """A DataprocProjectsRegionsJobsCancelRequest object.

  Fields:
    cancelJobRequest: A CancelJobRequest resource to be passed as the request
      body.
    jobId: [Required] The job ID.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  cancelJobRequest = _messages.MessageField('CancelJobRequest', 1)
  jobId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class DataprocProjectsRegionsJobsDeleteRequest(_messages.Message):
  """A DataprocProjectsRegionsJobsDeleteRequest object.

  Fields:
    jobId: [Required] The job ID.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  jobId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsJobsGetRequest(_messages.Message):
  """A DataprocProjectsRegionsJobsGetRequest object.

  Fields:
    jobId: [Required] The job ID.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  jobId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsJobsListRequest(_messages.Message):
  """A DataprocProjectsRegionsJobsListRequest object.

  Enums:
    JobStateMatcherValueValuesEnum: [Optional] Specifies enumerated categories
      of jobs to list.

  Fields:
    clusterName: [Optional] If set, the returned jobs list includes only jobs
      that were submitted to the named cluster.
    jobStateMatcher: [Optional] Specifies enumerated categories of jobs to
      list.
    pageSize: [Optional] The number of results to return in each response.
    pageToken: [Optional] The page token, returned by a previous call, to
      request the next page of results.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
  """

  class JobStateMatcherValueValuesEnum(_messages.Enum):
    """[Optional] Specifies enumerated categories of jobs to list.

    Values:
      ALL: <no description>
      ACTIVE: <no description>
      NON_ACTIVE: <no description>
    """
    ALL = 0
    ACTIVE = 1
    NON_ACTIVE = 2

  clusterName = _messages.StringField(1)
  jobStateMatcher = _messages.EnumField('JobStateMatcherValueValuesEnum', 2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class DataprocProjectsRegionsJobsSubmitRequest(_messages.Message):
  """A DataprocProjectsRegionsJobsSubmitRequest object.

  Fields:
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
    region: [Required] The Cloud Dataproc region in which to handle the
      request.
    submitJobRequest: A SubmitJobRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  submitJobRequest = _messages.MessageField('SubmitJobRequest', 3)


class DataprocProjectsRegionsOperationsCancelRequest(_messages.Message):
  """A DataprocProjectsRegionsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsDeleteRequest(_messages.Message):
  """A DataprocProjectsRegionsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsGetRequest(_messages.Message):
  """A DataprocProjectsRegionsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsListRequest(_messages.Message):
  """A DataprocProjectsRegionsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DiagnoseClusterOutputLocation(_messages.Message):
  """The location where output from diagnostic command can be found.

  Fields:
    outputUri: [Output-only] The Google Cloud Storage URI of the diagnostic
      output. This will be a plain text file with summary of collected
      diagnostics.
  """

  outputUri = _messages.StringField(1)


class DiagnoseClusterRequest(_messages.Message):
  """A request to collect cluster diagnostic information."""


class DiagnoseClusterResults(_messages.Message):
  """The location of diagnostic output.

  Fields:
    outputUri: [Output-only] The Google Cloud Storage URI of the diagnostic
      output. This is a plain text file with a summary of collected
      diagnostics.
  """

  outputUri = _messages.StringField(1)


class DiskConfig(_messages.Message):
  """Specifies the config of disk options for a group of VM instances.

  Fields:
    bootDiskSizeGb: [Optional] Size in GB of the boot disk (default is 500GB).
    numLocalSsds: [Optional] Number of attached SSDs, from 0 to 4 (default is
      0). If SSDs are not attached, the boot disk is used to store runtime
      logs and HDFS data. If one or more SSDs are attached, this runtime bulk
      data is spread across them, and the boot disk contains only basic config
      and installed binaries.
  """

  bootDiskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  numLocalSsds = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GceClusterConfig(_messages.Message):
  """Common config settings for resources of Google Compute Engine cluster
  instances, applicable to all instances in the cluster.

  Messages:
    MetadataValue: The Google Compute Engine metadata entries to add to all
      instances.

  Fields:
    internalIpOnly: If true, all instances in the cluser will only have
      internal IP addresses. By default, clusters are not restricted to
      internal IP addresses, and will have ephemeral external IP addresses
      assigned to each instance. This restriction can only be enabled for
      subnetwork enabled networks, and all off-cluster dependencies must be
      configured to be accessible without external IP addresses.
    metadata: The Google Compute Engine metadata entries to add to all
      instances.
    networkUri: The Google Compute Engine network to be used for machine
      communications. Cannot be specified with subnetwork_uri. If neither
      network_uri nor subnetwork_uri is specified, the "default" network of
      the project is used, if it exists. Cannot be a "Custom Subnet Network"
      (see [Using Subnetworks](/compute/docs/subnetworks) for more
      information). Example: `https://www.googleapis.com/compute/v1/projects/[
      project_id]/regions/global/default`.
    serviceAccountScopes: The URIs of service account scopes to be included in
      Google Compute Engine instances. The following base set of scopes is
      always included:  *
      https://www.googleapis.com/auth/cloud.useraccounts.readonly *
      https://www.googleapis.com/auth/devstorage.read_write *
      https://www.googleapis.com/auth/logging.write  If no scopes are
      specfied, the following defaults are also provided:  *
      https://www.googleapis.com/auth/bigquery *
      https://www.googleapis.com/auth/bigtable.admin.table *
      https://www.googleapis.com/auth/bigtable.data *
      https://www.googleapis.com/auth/devstorage.full_control
    subnetworkUri: The Google Compute Engine subnetwork to be used for machine
      communications. Cannot be specified with network_uri. Example:
      `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-
      east1/sub0`.
    tags: The Google Compute Engine tags to add to all instances.
    zoneUri: [Required] The zone where the Google Compute Engine cluster will
      be located. Example: `https://www.googleapis.com/compute/v1/projects/[pr
      oject_id]/zones/[zone]`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """The Google Compute Engine metadata entries to add to all instances.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  internalIpOnly = _messages.BooleanField(1)
  metadata = _messages.MessageField('MetadataValue', 2)
  networkUri = _messages.StringField(3)
  serviceAccountScopes = _messages.StringField(4, repeated=True)
  subnetworkUri = _messages.StringField(5)
  tags = _messages.StringField(6, repeated=True)
  zoneUri = _messages.StringField(7)


class HadoopJob(_messages.Message):
  """A Cloud Dataproc job for running Hadoop MapReduce jobs on YARN.

  Messages:
    PropertiesValue: [Optional] A mapping of property names to values, used to
      configure Hadoop. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site and classes in user code.

  Fields:
    archiveUris: [Optional] HCFS URIs of archives to be extracted in the
      working directory of Hadoop drivers and tasks. Supported file types:
      .jar, .tar, .tar.gz, .tgz, or .zip.
    args: [Optional] The arguments to pass to the driver. Do not include
      arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job
      properties, since a collision may occur that causes an incorrect job
      submission.
    fileUris: [Optional] HCFS (Hadoop Compatible Filesystem) URIs of files to
      be copied to the working directory of Hadoop drivers and distributed
      tasks. Useful for naively parallel tasks.
    jarFileUris: [Optional] Jar file URIs to add to the CLASSPATHs of the
      Hadoop driver and tasks.
    loggingConfig: [Optional] The runtime log config for job execution.
    mainClass: The name of the driver's main class. The jar file containing
      the class must be in the default CLASSPATH or specified in
      `jar_file_uris`.
    mainJarFileUri: The HCFS URI of the jar file containing the main class.
      Examples:     'gs://foo-bucket/analytics-binaries/extract-useful-
      metrics-mr.jar'     'hdfs:/tmp/test-samples/custom-wordcount.jar'
      'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
    properties: [Optional] A mapping of property names to values, used to
      configure Hadoop. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site and classes in user code.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names to values, used to configure
    Hadoop. Properties that conflict with values set by the Cloud Dataproc API
    may be overwritten. Can include properties set in /etc/hadoop/conf/*-site
    and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainClass = _messages.StringField(6)
  mainJarFileUri = _messages.StringField(7)
  properties = _messages.MessageField('PropertiesValue', 8)


class HiveJob(_messages.Message):
  """A Cloud Dataproc job for running Hive queries on YARN.

  Messages:
    PropertiesValue: [Optional] A mapping of property names and values, used
      to configure Hive. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes
      in user code.
    ScriptVariablesValue: [Optional] Mapping of query variable names to values
      (equivalent to the Hive command: `SET name="value";`).

  Fields:
    continueOnFailure: [Optional] Whether to continue executing queries if a
      query fails. The default value is `false`. Setting to `true` can be
      useful when executing independent parallel queries.
    jarFileUris: [Optional] HCFS URIs of jar files to add to the CLASSPATH of
      the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes
      and UDFs.
    properties: [Optional] A mapping of property names and values, used to
      configure Hive. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes
      in user code.
    queryFileUri: The HCFS URI of the script that contains Hive queries.
    queryList: A list of queries.
    scriptVariables: [Optional] Mapping of query variable names to values
      (equivalent to the Hive command: `SET name="value";`).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names and values, used to configure
    Hive. Properties that conflict with values set by the Cloud Dataproc API
    may be overwritten. Can include properties set in
    /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in
    user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    """[Optional] Mapping of query variable names to values (equivalent to the
    Hive command: `SET name="value";`).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  continueOnFailure = _messages.BooleanField(1)
  jarFileUris = _messages.StringField(2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)
  queryFileUri = _messages.StringField(4)
  queryList = _messages.MessageField('QueryList', 5)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 6)


class InstanceGroupConfig(_messages.Message):
  """The config settings for Google Compute Engine resources in an instance
  group, such as a master or worker group.

  Fields:
    diskConfig: Disk option config settings.
    imageUri: [Output-only] The Google Compute Engine image resource used for
      cluster instances. Inferred from `SoftwareConfig.image_version`.
    instanceNames: The list of instance names. Cloud Dataproc derives the
      names from `cluster_name`, `num_instances`, and the instance group if
      not set by user (recommended practice is to let Cloud Dataproc derive
      the name).
    isPreemptible: Specifies that this instance group contains Preemptible
      Instances.
    machineTypeUri: The Google Compute Engine machine type used for cluster
      instances. Example:
      `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-
      east1-a/machineTypes/n1-standard-2`.
    managedGroupConfig: [Output-only] The config for Google Compute Engine
      Instance Group Manager that manages this group. This is only used for
      preemptible instance groups.
    numInstances: The number of VM instances in the instance group. For master
      instance groups, must be set to 1.
  """

  diskConfig = _messages.MessageField('DiskConfig', 1)
  imageUri = _messages.StringField(2)
  instanceNames = _messages.StringField(3, repeated=True)
  isPreemptible = _messages.BooleanField(4)
  machineTypeUri = _messages.StringField(5)
  managedGroupConfig = _messages.MessageField('ManagedGroupConfig', 6)
  numInstances = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class Job(_messages.Message):
  """A Cloud Dataproc job resource.

  Fields:
    driverControlFilesUri: [Output-only] If present, the location of
      miscellaneous control files which may be used as part of job setup and
      handling. If not present, control files may be placed in the same
      location as `driver_output_uri`.
    driverOutputResourceUri: [Output-only] A URI pointing to the location of
      the stdout of the job's driver program.
    hadoopJob: Job is a Hadoop job.
    hiveJob: Job is a Hive job.
    pigJob: Job is a Pig job.
    placement: [Required] Job information, including how, when, and where to
      run the job.
    pysparkJob: Job is a Pyspark job.
    reference: [Optional] The fully qualified reference to the job, which can
      be used to obtain the equivalent REST path of the job resource. If this
      property is not specified when a job is created, the server generates a
      <code>job_id</code>.
    sparkJob: Job is a Spark job.
    sparkSqlJob: Job is a SparkSql job.
    status: [Output-only] The job status. Additional application-specific
      status information may be contained in the <code>type_job</code> and
      <code>yarn_applications</code> fields.
    statusHistory: [Output-only] The previous job status.
  """

  driverControlFilesUri = _messages.StringField(1)
  driverOutputResourceUri = _messages.StringField(2)
  hadoopJob = _messages.MessageField('HadoopJob', 3)
  hiveJob = _messages.MessageField('HiveJob', 4)
  pigJob = _messages.MessageField('PigJob', 5)
  placement = _messages.MessageField('JobPlacement', 6)
  pysparkJob = _messages.MessageField('PySparkJob', 7)
  reference = _messages.MessageField('JobReference', 8)
  sparkJob = _messages.MessageField('SparkJob', 9)
  sparkSqlJob = _messages.MessageField('SparkSqlJob', 10)
  status = _messages.MessageField('JobStatus', 11)
  statusHistory = _messages.MessageField('JobStatus', 12, repeated=True)


class JobPlacement(_messages.Message):
  """Cloud Dataproc job config.

  Fields:
    clusterName: [Required] The name of the cluster where the job will be
      submitted.
    clusterUuid: [Output-only] A cluster UUID generated by the Cloud Dataproc
      service when the job is submitted.
  """

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)


class JobReference(_messages.Message):
  """Encapsulates the full scoping used to reference a job.

  Fields:
    jobId: [Required] The job ID, which must be unique within the project. The
      job ID is generated by the server upon job submission or provided by the
      user as a means to perform retries without creating duplicate jobs. The
      ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      or hyphens (-). The maximum length is 512 characters.
    projectId: [Required] The ID of the Google Cloud Platform project that the
      job belongs to.
  """

  jobId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class JobStatus(_messages.Message):
  """Cloud Dataproc job status.

  Enums:
    StateValueValuesEnum: [Required] A state message specifying the overall
      job state.

  Fields:
    details: [Optional] Job state details, such as an error description if the
      state is <code>ERROR</code>.
    state: [Required] A state message specifying the overall job state.
    stateStartTime: [Output-only] The time when this state was entered.
  """

  class StateValueValuesEnum(_messages.Enum):
    """[Required] A state message specifying the overall job state.

    Values:
      STATE_UNSPECIFIED: The job state is unknown.
      PENDING: The job is pending; it has been submitted, but is not yet
        running.
      SETUP_DONE: Job has been received by the service and completed initial
        setup; it will soon be submitted to the cluster.
      RUNNING: The job is running on the cluster.
      CANCEL_PENDING: A CancelJob request has been received, but is pending.
      CANCEL_STARTED: Transient in-flight resources have been canceled, and
        the request to cancel the running job has been issued to the cluster.
      CANCELLED: The job cancellation was successful.
      DONE: The job has completed successfully.
      ERROR: The job has completed, but encountered an error.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    SETUP_DONE = 2
    RUNNING = 3
    CANCEL_PENDING = 4
    CANCEL_STARTED = 5
    CANCELLED = 6
    DONE = 7
    ERROR = 8

  details = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  stateStartTime = _messages.StringField(3)


class ListClustersResponse(_messages.Message):
  """The list of all clusters in a project.

  Fields:
    clusters: [Output-only] The clusters in the project.
    nextPageToken: [Optional] This token is included in the response if there
      are more results to fetch. To fetch additional results, provide this
      value as the `page_token` in a subsequent
      <code>ListClustersRequest</code>.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListJobsResponse(_messages.Message):
  """A list of jobs in a project.

  Fields:
    jobs: [Output-only] Jobs list.
    nextPageToken: [Optional] This token is included in the response if there
      are more results to fetch. To fetch additional results, provide this
      value as the `page_token` in a subsequent <code>ListJobsRequest</code>.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class LoggingConfig(_messages.Message):
  """The runtime logging config of the job.

  Messages:
    DriverLogLevelsValue: The per-package log levels for the driver. This may
      include "root" package name to configure rootLogger. Examples:
      'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'

  Fields:
    driverLogLevels: The per-package log levels for the driver. This may
      include "root" package name to configure rootLogger. Examples:
      'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DriverLogLevelsValue(_messages.Message):
    """The per-package log levels for the driver. This may include "root"
    package name to configure rootLogger. Examples:   'com.google = FATAL',
    'root = INFO', 'org.apache = DEBUG'

    Messages:
      AdditionalProperty: An additional property for a DriverLogLevelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DriverLogLevelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DriverLogLevelsValue object.

      Enums:
        ValueValueValuesEnum:

      Fields:
        key: Name of the additional property.
        value: A ValueValueValuesEnum attribute.
      """

      class ValueValueValuesEnum(_messages.Enum):
        """ValueValueValuesEnum enum type.

        Values:
          LEVEL_UNSPECIFIED: <no description>
          ALL: <no description>
          TRACE: <no description>
          DEBUG: <no description>
          INFO: <no description>
          WARN: <no description>
          ERROR: <no description>
          FATAL: <no description>
          OFF: <no description>
        """
        LEVEL_UNSPECIFIED = 0
        ALL = 1
        TRACE = 2
        DEBUG = 3
        INFO = 4
        WARN = 5
        ERROR = 6
        FATAL = 7
        OFF = 8

      key = _messages.StringField(1)
      value = _messages.EnumField('ValueValueValuesEnum', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  driverLogLevels = _messages.MessageField('DriverLogLevelsValue', 1)


class ManagedGroupConfig(_messages.Message):
  """Specifies the resources used to actively manage an instance group.

  Fields:
    instanceGroupManagerName: [Output-only] The name of the Instance Group
      Manager for this group.
    instanceTemplateName: [Output-only] The name of the Instance Template used
      for the Managed Instance Group.
  """

  instanceGroupManagerName = _messages.StringField(1)
  instanceTemplateName = _messages.StringField(2)


class NodeInitializationAction(_messages.Message):
  """Specifies an executable to run on a fully configured node and a timeout
  period for executable completion.

  Fields:
    executableFile: [Required] Google Cloud Storage URI of executable file.
    executionTimeout: [Optional] Amount of time executable has to complete.
      Default is 10 minutes. Cluster creation fails with an explanatory error
      message (the name of the executable that caused the error and the
      exceeded timeout period) if the executable is not completed at end of
      the timeout period.
  """

  executableFile = _messages.StringField(1)
  executionTimeout = _messages.StringField(2)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  """Metadata describing the operation.

  Enums:
    StateValueValuesEnum: A message containing the operation state.

  Fields:
    clusterName: Name of the cluster for the operation.
    clusterUuid: Cluster UUId for the operation.
    description: [Output-only] Short description of operation.
    details: A message containing any operation metadata details.
    endTime: The time that the operation completed.
    innerState: A message containing the detailed operation state.
    insertTime: The time that the operation was requested.
    operationType: [Output-only] The operation type.
    startTime: The time that the operation was started by the server.
    state: A message containing the operation state.
    status: [Output-only] Current operation status.
    statusHistory: [Output-only] Previous operation status.
  """

  class StateValueValuesEnum(_messages.Enum):
    """A message containing the operation state.

    Values:
      UNKNOWN: Unused.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
    """
    UNKNOWN = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  description = _messages.StringField(3)
  details = _messages.StringField(4)
  endTime = _messages.StringField(5)
  innerState = _messages.StringField(6)
  insertTime = _messages.StringField(7)
  operationType = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  status = _messages.MessageField('OperationStatus', 11)
  statusHistory = _messages.MessageField('OperationStatus', 12, repeated=True)


class OperationStatus(_messages.Message):
  """The status of the operation.

  Enums:
    StateValueValuesEnum: A message containing the operation state.

  Fields:
    details: A message containing any operation metadata details.
    innerState: A message containing the detailed operation state.
    state: A message containing the operation state.
    stateStartTime: The time this state was entered.
  """

  class StateValueValuesEnum(_messages.Enum):
    """A message containing the operation state.

    Values:
      UNKNOWN: Unused.
      PENDING: The operation has been created.
      RUNNING: The operation is running.
      DONE: The operation is done; either cancelled or completed.
    """
    UNKNOWN = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  details = _messages.StringField(1)
  innerState = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  stateStartTime = _messages.StringField(4)


class PigJob(_messages.Message):
  """A Cloud Dataproc job for running Pig queries on YARN.

  Messages:
    PropertiesValue: [Optional] A mapping of property names to values, used to
      configure Pig. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes
      in user code.
    ScriptVariablesValue: [Optional] Mapping of query variable names to values
      (equivalent to the Pig command: `name=[value]`).

  Fields:
    continueOnFailure: [Optional] Whether to continue executing queries if a
      query fails. The default value is `false`. Setting to `true` can be
      useful when executing independent parallel queries.
    jarFileUris: [Optional] HCFS URIs of jar files to add to the CLASSPATH of
      the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
    loggingConfig: [Optional] The runtime log config for job execution.
    properties: [Optional] A mapping of property names to values, used to
      configure Pig. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes
      in user code.
    queryFileUri: The HCFS URI of the script that contains the Pig queries.
    queryList: A list of queries.
    scriptVariables: [Optional] Mapping of query variable names to values
      (equivalent to the Pig command: `name=[value]`).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names to values, used to configure
    Pig. Properties that conflict with values set by the Cloud Dataproc API
    may be overwritten. Can include properties set in
    /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in
    user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    """[Optional] Mapping of query variable names to values (equivalent to the
    Pig command: `name=[value]`).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  continueOnFailure = _messages.BooleanField(1)
  jarFileUris = _messages.StringField(2, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 3)
  properties = _messages.MessageField('PropertiesValue', 4)
  queryFileUri = _messages.StringField(5)
  queryList = _messages.MessageField('QueryList', 6)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 7)


class PySparkJob(_messages.Message):
  """A Cloud Dataproc job for running PySpark applications on YARN.

  Messages:
    PropertiesValue: [Optional] A mapping of property names to values, used to
      configure PySpark. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.

  Fields:
    archiveUris: [Optional] HCFS URIs of archives to be extracted in the
      working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
    args: [Optional] The arguments to pass to the driver.  Do not include
      arguments, such as `--conf`, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: [Optional] HCFS URIs of files to be copied to the working
      directory of Python drivers and distributed tasks. Useful for naively
      parallel tasks.
    jarFileUris: [Optional] HCFS URIs of jar files to add to the CLASSPATHs of
      the Python driver and tasks.
    loggingConfig: [Optional] The runtime log config for job execution.
    mainPythonFileUri: [Required] The HCFS URI of the main Python file to use
      as the driver. Must be a .py file.
    properties: [Optional] A mapping of property names to values, used to
      configure PySpark. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.
    pythonFileUris: [Optional] HCFS file URIs of Python files to pass to the
      PySpark framework. Supported file types: .py, .egg, and .zip.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names to values, used to configure
    PySpark. Properties that conflict with values set by the Cloud Dataproc
    API may be overwritten. Can include properties set in /etc/spark/conf
    /spark-defaults.conf and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainPythonFileUri = _messages.StringField(6)
  properties = _messages.MessageField('PropertiesValue', 7)
  pythonFileUris = _messages.StringField(8, repeated=True)


class QueryList(_messages.Message):
  """A list of queries to run on a cluster.

  Fields:
    queries: [Required] The queries to execute. You do not need to terminate a
      query with a semicolon. Multiple queries can be specified in one string
      by separating each with a semicolon. Here is an example of an Cloud
      Dataproc API snippet that uses a QueryList to specify a HiveJob:
      "hiveJob": {       "queryList": {         "queries": [
      "query1",           "query2",           "query3;query4",         ]
      }     }
  """

  queries = _messages.StringField(1, repeated=True)


class SoftwareConfig(_messages.Message):
  """Specifies the selection and config of software inside the cluster.

  Messages:
    PropertiesValue: [Optional] The properties to set on daemon config files.
      Property keys are specified in `prefix:property` format, such as
      `core:fs.defaultFS`. The following are supported prefixes and their
      mappings:  * core:   `core-site.xml` * hdfs:   `hdfs-site.xml` * mapred:
      `mapred-site.xml` * yarn:   `yarn-site.xml` * hive:   `hive-site.xml` *
      pig:    `pig.properties` * spark:  `spark-defaults.conf`

  Fields:
    imageVersion: [Optional] The version of software inside the cluster. It
      must match the regular expression `[0-9]+\.[0-9]+`. If unspecified, it
      defaults to the latest version (see [Cloud Dataproc
      Versioning](/dataproc/versioning)).
    properties: [Optional] The properties to set on daemon config files.
      Property keys are specified in `prefix:property` format, such as
      `core:fs.defaultFS`. The following are supported prefixes and their
      mappings:  * core:   `core-site.xml` * hdfs:   `hdfs-site.xml` * mapred:
      `mapred-site.xml` * yarn:   `yarn-site.xml` * hive:   `hive-site.xml` *
      pig:    `pig.properties` * spark:  `spark-defaults.conf`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] The properties to set on daemon config files.  Property keys
    are specified in `prefix:property` format, such as `core:fs.defaultFS`.
    The following are supported prefixes and their mappings:  * core:   `core-
    site.xml` * hdfs:   `hdfs-site.xml` * mapred: `mapred-site.xml` * yarn:
    `yarn-site.xml` * hive:   `hive-site.xml` * pig:    `pig.properties` *
    spark:  `spark-defaults.conf`

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  imageVersion = _messages.StringField(1)
  properties = _messages.MessageField('PropertiesValue', 2)


class SparkJob(_messages.Message):
  """A Cloud Dataproc job for running Spark applications on YARN.

  Messages:
    PropertiesValue: [Optional] A mapping of property names to values, used to
      configure Spark. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.

  Fields:
    archiveUris: [Optional] HCFS URIs of archives to be extracted in the
      working directory of Spark drivers and tasks. Supported file types:
      .jar, .tar, .tar.gz, .tgz, and .zip.
    args: [Optional] The arguments to pass to the driver. Do not include
      arguments, such as `--conf`, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: [Optional] HCFS URIs of files to be copied to the working
      directory of Spark drivers and distributed tasks. Useful for naively
      parallel tasks.
    jarFileUris: [Optional] HCFS URIs of jar files to add to the CLASSPATHs of
      the Spark driver and tasks.
    loggingConfig: [Optional] The runtime log config for job execution.
    mainClass: The name of the driver's main class. The jar file that contains
      the class must be in the default CLASSPATH or specified in
      `jar_file_uris`.
    mainJarFileUri: The HCFS URI of the jar file that contains the main class.
    properties: [Optional] A mapping of property names to values, used to
      configure Spark. Properties that conflict with values set by the Cloud
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names to values, used to configure
    Spark. Properties that conflict with values set by the Cloud Dataproc API
    may be overwritten. Can include properties set in /etc/spark/conf/spark-
    defaults.conf and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainClass = _messages.StringField(6)
  mainJarFileUri = _messages.StringField(7)
  properties = _messages.MessageField('PropertiesValue', 8)


class SparkSqlJob(_messages.Message):
  """A Cloud Dataproc job for running Spark SQL queries.

  Messages:
    PropertiesValue: [Optional] A mapping of property names to values, used to
      configure Spark SQL's SparkConf. Properties that conflict with values
      set by the Cloud Dataproc API may be overwritten.
    ScriptVariablesValue: [Optional] Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET `name="value";`).

  Fields:
    jarFileUris: [Optional] HCFS URIs of jar files to be added to the Spark
      CLASSPATH.
    loggingConfig: [Optional] The runtime log config for job execution.
    properties: [Optional] A mapping of property names to values, used to
      configure Spark SQL's SparkConf. Properties that conflict with values
      set by the Cloud Dataproc API may be overwritten.
    queryFileUri: The HCFS URI of the script that contains SQL queries.
    queryList: A list of queries.
    scriptVariables: [Optional] Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET `name="value";`).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """[Optional] A mapping of property names to values, used to configure
    Spark SQL's SparkConf. Properties that conflict with values set by the
    Cloud Dataproc API may be overwritten.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    """[Optional] Mapping of query variable names to values (equivalent to the
    Spark SQL command: SET `name="value";`).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  jarFileUris = _messages.StringField(1, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 2)
  properties = _messages.MessageField('PropertiesValue', 3)
  queryFileUri = _messages.StringField(4)
  queryList = _messages.MessageField('QueryList', 5)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 6)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SubmitJobRequest(_messages.Message):
  """A request to submit a job.

  Fields:
    job: [Required] The job resource.
  """

  job = _messages.MessageField('Job', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'dataproc')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'dataproc')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'dataproc')
