<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_log_config - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_log_config</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_log_config.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_log_config.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_log_config.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_log_config.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_log_config.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Journalisation des requtes envoyes au
serveur</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>log_config_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_log_config.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module apporte une grande souplesse dans la journalisation des
    requtes des clients. Les journaux sont crits sous un format
    personnalisable, et peuvent tre enregistrs directement dans un
    fichier, ou redirigs vers un programme externe. La journalisation
    conditionnelle est supporte, si bien que des requtes individuelles
    peuvent tre incluses ou exclues des journaux en fonction de leur
    caractristiques.</p>

    <p>Ce module fournit trois directives : <code class="directive"><a href="#transferlog">TransferLog</a></code> cre un fichier
    journal, <code class="directive"><a href="#logformat">LogFormat</a></code>
    dfinit un format personnalis, et <code class="directive"><a href="#customlog">CustomLog</a></code> dfinit un fichier journal et un format en
    une seule tape. Pour journaliser les requtes dans plusieurs
    fichiers, vous pouvez utiliser plusieurs fois les directives
    <code class="directive">TransferLog</code> et
    <code class="directive">CustomLog</code> dans chaque serveur.</p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#formats">Formats de journaux personnaliss</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#security">Considrations concernant la
scurit</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#bufferedlogs">BufferedLogs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#customlog">CustomLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#globallog">GlobalLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#logformat">LogFormat</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#transferlog">TransferLog</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_log_config">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_log_config">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../logs.html">Les fichiers journaux
d'Apache</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="formats" id="formats">Formats de journaux personnaliss</a></h2>

    <p>L'argument format des directives <code class="directive"><a href="#logformat">LogFormat</a></code> et <code class="directive"><a href="#customlog">CustomLog</a></code> est une chane de
    caractres. Cette chane dfinit le format de la journalisation des
    requtes dans le fichier journal. Elle peut contenir des caractres
    littraux qui seront reproduits dans le fichier journal, et les
    caractres de contrle de style C "\n" et "\t" reprsentant
    respectivement une nouvelle ligne et une tabulation. Les guillemets
    et les anti-slashes littraux doivent tre chapps  l'aide
    d'anti-slashes.</p>

    <p>Les caractristiques de la requte en elle-mme sont journalises
    en insrant des directives "<code>%</code>" dans la chane de
    format, celles-ci tant remplaces dans le fichier journal par
    certaines valeurs comme suit :</p>

    <table class="bordered"><tr class="header"><th>Chane&nbsp;de&nbsp;format</th>
        <th>Description</th></tr>
<tr><td><code>%%</code></td>
        <td>Le signe "pourcentage"</td></tr>
<tr class="odd"><td><code>%a</code></td>
        <td>L'adresse IP distante (voir le module
	<code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code>).</td></tr>
<tr><td><code>%{c}a</code></td>
        <td>Adresse IP distante de la connexion(voir le module
	<code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code>)</td></tr>
<tr class="odd"><td><code>%A</code></td>
        <td>L'adresse IP locale</td></tr>
<tr><td><code>%B</code></td>
        <td>La taille de la rponse en octets, en excluant les en-ttes
	HTTP.</td></tr>
<tr class="odd"><td><code>%b</code></td>
        <td>La taille de la rponse en octets, en excluant les en-ttes
	HTTP. Au format CLF , c'est  dire un '<code>-</code>'  la
	place d'un 0 lorsqu'aucun octet n'est renvoy.</td></tr>
<tr><td><code>%{<var>NOMVAR</var>}C</code></td>
        <td>Le contenu du cookie <var>NOMVAR</var> dans la requte
	envoye au serveur. Seuls les cookies version 0 sont pleinement
	supports.</td></tr>
<tr class="odd"><td><code>%D</code></td>
        <td>Le temps mis  servir la requte, en
	microsecondes.</td></tr>
<tr><td><code>%{<var>NOMVAR</var>}e</code></td>
        <td>Le contenu de la variable d'environnement
	<var>NOMVAR</var></td></tr>
<tr class="odd"><td><code>%f</code></td>
        <td>Nom de fichier</td></tr>
<tr><td><code>%h</code></td>
        <td>Serveur distant. Contiendra l'adresse IP si la directive
	<code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code> est dfinie
	 <code>Off</code>, ce qui est sa valeur par dfaut. Si cette
	adresse IP n'est enregistre que pour certains serveurs, vous
	avez probablement dfini des directives de contrle d'accs qui
	mentionnent ces derniers par leurs noms. Voir la <a href="mod_authz_host.html#reqhost">documentation de Require
	host</a>.</td></tr>
<tr class="odd"><td><code>%H</code></td>
        <td>Le protocole de la requte</td></tr>
<tr><td><code>%{<var>NOMVAR</var>}i</code></td>
        <td>Le contenu des lignes d'en-tte
	<code><var>NOMVAR</var>:</code> dans la requte envoye au
	serveur. Ces en-ttes sont ajouts par d'autres modules (par
	exemple <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code>). Si vous tes intress
	par ce qu'tait l'en-tte de la requte avant d'tre modifi
	par la plupart des modules, utilisez
	<code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code> pour copier l'en-tte dans une
	variable d'environnement interne et journaliser sa valeur via
	le champ <code>%{<var>VARNAME</var>}e</code> dcrit plus haut.

        </td></tr>
<tr class="odd"><td><code>%k</code></td>
        <td>Nombre de requtes persistantes en cours pour cette
	connexion. Interessant si la directive <code class="directive"><a href="../mod/core.html#keepalive">KeepAlive</a></code> est utilise ; par exemple,
	'1' signifie la premire requte aprs la requte initiale, '2'
	la seconde, etc... ; autrement, il s'agit toujours de 0
	(indiquant la requte initiale).</td></tr>
<tr><td><code>%l</code></td>
        <td>Le nom de connexion distant (en provenance d'identd, si
	disponible). Affiche un tiret, sauf si
	<code class="module"><a href="../mod/mod_ident.html">mod_ident</a></code> est prsent et si <code class="directive"><a href="../mod/mod_ident.html#identitycheck">IdentityCheck</a></code> est 
	<code>On</code>.</td></tr>
<tr class="odd"><td><code>%L</code></td>
        <td>L'identifiant du message de journalisation de la requte
	dans le journal des erreurs (ou '-' si aucun message n'a
	t enregistr dans le journal des erreurs pour cette requte)</td></tr>
<tr><td><code>%m</code></td>
        <td>La mthode de la requte</td></tr>
<tr class="odd"><td><code>%{<var>NOMVAR</var>}n</code></td>
        <td>Le contenu de la note <var>NOMVAR</var> en provenance d'un
	autre module.</td></tr>
<tr><td><code>%{<var>NOMVAR</var>}o</code></td>
        <td>Le contenu de la ligne d'en-tte
	<code><var>NOMVAR</var>:</code> de la rponse.</td></tr>
<tr class="odd"><td><code>%p</code></td>
        <td>Le port canonique du serveur servant la requte</td></tr>
<tr><td><code>%{<var>format</var>}p</code></td>
        <td>Le port canonique du serveur servant la requte ou le
	vritable port du serveur ou le vritable port du client. les
	formats valides sont <code>canonical</code>, <code>local</code>,
	ou <code>remote</code>.
        </td></tr>
<tr class="odd"><td><code>%P</code></td>
        <td>Le numro de processus du processus enfant qui a servi la
	requte.</td></tr>
<tr><td><code>%{<var>format</var>}P</code></td>
        <td>Le numro de processus ou le numro de thread du processus
	enfant qui a servi la requte. Les formats valides sont
	<code>pid</code>, <code>tid</code>, et <code>hextid</code>.
	<code>hextid</code> ncessite APR version 1.2.0 ou suprieure.
        </td></tr>
<tr class="odd"><td><code>%q</code></td>
        <td>La chane d'arguments (prfixe par un <code>?</code> si une
	chane d'arguments existe, sinon une chane vide)</td></tr>
<tr><td><code>%r</code></td>
        <td>La premire ligne de la requte</td></tr>
<tr class="odd"><td><code>%R</code></td>
        <td>Le gestionnaire qui gnre la rponse (s'il y en a un).</td></tr>
<tr><td><code>%s</code></td>
        <td>Statut. Pour les requtes rediriges en interne, il s'agit
	du statut de la requte *originale* --- <code>%&gt;s</code> pour
	la dernire.</td></tr>
<tr class="odd"><td><code>%t</code></td>
        <td>Date  laquelle la requte a t reue (au format anglais
	standard)</td></tr>
<tr><td><code>%{<var>format</var>}t</code></td>
        <td>La date, sous la forme spcifie par format, qui devrait
	tre au format tendu <code>strftime(3)</code> (ventuellement
	localis). Si le format commence par <code>begin:</code> (valeur
	par dfaut), la date est extraite au dbut du traitement de la
	requte ; s'il commence par <code>end:</code>, la date
	correspond au moment o l'entre du journal est inscrite, par
	consquent vers la fin du traitement de la requte. Hormis les
	formats supports par <code>strftime(3)</code>, les formats
	suivants sont aussi disponibles :
        <table>
        <tr><td><code>sec</code></td><td>nombre de secondes depuis Epoch</td></tr>
        <tr><td><code>msec</code></td><td>nombre de millisecondes depuis  Epoch</td></tr>
        <tr><td><code>usec</code></td><td>nombre de microsecondes depuis Epoch</td></tr>
        <tr><td><code>msec_frac</code></td><td>fraction de milliseconde</td></tr>
        <tr><td><code>usec_frac</code></td><td>fraction de microseconde</td></tr>
        </table>
        Ces symboles ne peuvent pas tre combins entre eux ou avec un
	formatage <code>strftime(3)</code> dans la mme chane de
	format. Par contre, vous pouvez utiliser plusieurs symboles
	<code>%{<var>format</var>}t</code>.</td></tr>
<tr class="odd"><td><code>%T</code></td>
        <td>Le temps mis pour servir la requte, en secondes.</td></tr>
<tr><td><code>%{<var>UNIT</var>}T</code></td>
        <td>Le temps mis pour traiter la requte dans une unit dfinie
	par <code>UNIT</code>. Les valeurs d'unit valides sont
	<code>ms</code> pour millisecondes, <code>us</code> pour
	microsecondes et <code>s</code> pour secondes. Si
	<code>UNIT</code> est omis, la valeur de l'unit par dfaut est
	la seconde ; spcifier la valeur d'unit <code>us</code> revient
	 utiliser le format <code>%D</code>. La possibilit de
	spcifier une valeur d'unit avec le format <code>%T</code> est
	disponible depuis la version 2.4.13 du serveur HTTP Apache.</td></tr>
<tr class="odd"><td><code>%u</code></td>
        <td>L'utilisateur distant (en provenance d'auth ; peut tre faux
	si le statut de retour (<code>%s</code>) est 401).</td></tr>
<tr><td><code>%U</code></td>
        <td>Le chemin de la requte,  l'exclusion de toute chane
	d'arguments.</td></tr>
<tr class="odd"><td><code>%v</code></td>
        <td>Le nom canonique du serveur qui a servi la requte, dfini
	par la directive <code class="directive"><a href="../mod/core.html#servername">ServerName</a></code>.</td></tr>
<tr><td><code>%V</code></td>
        <td>La nom du serveur en tenant compte de la dfinition de la
	directive <code class="directive"><a href="../mod/core.html#usecanonicalname">UseCanonicalName</a></code>.</td></tr>
<tr class="odd"><td><code>%X</code></td>
        <td>Statut de la connexion lorsque la rponse a t renvoye
	:

        <table>
        
        <tr><td><code>X</code> =</td>
            <td>connexion abandonne avant l'envoi de la rponse.</td></tr>
        <tr><td><code>+</code> =</td>
            <td>la connexion peut rester ouverte aprs l'envoi de la
	    rponse.</td></tr>
        <tr><td><code>-</code> = </td>
            <td>la connexion sera ferme aprs l'envoi de la
	    rponse.</td></tr>
        </table>

        </td></tr>
<tr><td><code>%I</code></td>
        <td>Le nombre d'octets reus, en comptant la requte et les
	en-ttes, ne peut tre nul. Ncessite l'activation de
	<code class="module"><a href="../mod/mod_logio.html">mod_logio</a></code>.</td></tr>
<tr class="odd"><td><code>%O</code></td>
        <td>Nombre d'octets envoys, y compris les en-ttes. Peut tre
	nul dans les rares cas o une requte est avorte avant que la
	rponse ne soit envoye. Ncessite l'activation de
	<code class="module"><a href="../mod/mod_logio.html">mod_logio</a></code>.</td></tr>
<tr><td><code>%S</code></td>
        <td>Nombre d'octets transmis (en mission et rception), y
	compris corps et en-ttes de requte. Ce nombre ne peut pas tre
	nul, et il correspond  la combinaison des formats %I et %O.
	<code class="module"><a href="../mod/mod_logio.html">mod_logio</a></code> doit tre charg pour pouvoir
	utiliser ce format.</td></tr>
<tr class="odd"><td><code>%{<var>VARNAME</var>}^ti</code></td>
        <td>Le contenu de <code><var>VARNAME</var>:</code> dans les
	paramtres de la requte envoye au serveur.</td></tr>
<tr><td><code>%{<var>VARNAME</var>}^to</code></td>
        <td>Le contenu de <code><var>VARNAME</var>:</code> dans les
	paramtres de la rponse envoye par le serveur.</td></tr>
</table>

    <h3><a name="modifiers" id="modifiers">Modificateurs</a></h3>

      <p>Il est possible de restreindre l'enregistrement de certains
      lments
      en fonction du code de statut de la rponse, en insrant une liste
      de codes de statut spars par des virgules immdiatement aprs le
      caractre "%". Par exemple, <code>"%400,501{User-agent}i"</code>
      n'enregistrera l'en-tte <code>User-agent</code> que dans le cas
      d'une erreur 400 ou 501. Avec les autres codes de statut, c'est la
      chane littrale <code>"-"</code> qui sera enregistre. La liste
      de codes peut tre prcde d'un "<code>!</code>" pour inverser la
      condition : <code>"%!200,304,302{Referer}i"</code> enregistre
      l'en-tte <code>Referer</code> pour toutes les requtes qui
      <em>ne</em> renvoient <em>pas</em> un des trois codes spcifis.</p>

      <p>Les modificateurs "&lt;" et "&gt;" peuvent tre utiliss pour
      les requtes qui ont t rediriges en interne afin de choisir si
      c'est respectivement la requte originale ou finale qui doit tre
      consulte. Par dfaut, les directives <code>%s, %U, %T, %D,</code>
      et <code>%r</code> consultent la requte originale, alors que
      toutes les autres consultent la requte finale. Ainsi, par
      exemple, on peut utiliser <code>%&gt;s</code> pour enregistrer le
      statut final de la requte, et <code>%&lt;u</code> pour
      enregistrer l'utilisateur authentifi  l'origine pour une requte
      redirige en interne vers une ressource sans authentification.</p>

    

    <h3><a name="format-notes" id="format-notes">Quelques Notes</a></h3>

      <p>Pour des raisons de scurit,  partir de la version 2.0.46,
      les caractres non imprimables et autres caractres spciaux dans
      les directives <code>%r</code>, <code>%i</code> et <code>%o</code>
      doivent tre chapps  l'aide des squences
      <code>\x<var>hh</var></code>,
      o <var>hh</var> est le code hexadcimal du caractre spcial.
      Comme exceptions  cette rgle, les caractres <code>"</code> et
      <code>\</code> doivent tre chapps par un anti-slash, et tous
      les "blancs" doivent tre crits selon leur notation de style C
      (<code>\n</code>, <code>\t</code>, etc...). Avant la version
      2.0.46, aucun chappement n'tait effectu sur ces chanes, et il
      fallait tre trs prudent lors de l'exploitation des journaux
      bruts.</p>

      <p>A la diffrence de la version 1.3, depuis httpd 2.0, les chanes
      de format <code>%b</code> et <code>%B</code> ne reprsentent pas
      le nombre d'octets envoys au client, mais simplement la taille en
      octets de la rponse HTTP (les deux tant diffrents, par exemple,
      si la connexion est abandonne, ou si SSL est utilis). Le format
      <code>%O</code> fourni par <code class="module"><a href="../mod/mod_logio.html">mod_logio</a></code>,
      enregistrera le nombre rel d'octets envoys sur le rseau.</p>

      <p>Note : <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> est implment en tant que
      gestionnaire basique et non en tant que gestionnaire standard.
      C'est pourquoi la chane de format <code>%R</code> ne renverra pas
      d'information  propos du gestionnaire lorsqu'une mise en cache de
      contenu entre en jeu.</p>

    

    <h3><a name="examples" id="examples">Exemples</a></h3>

      <p>Quelques chanes de format couramment utilises :</p>

      <dl>
        <dt>Format de journal courant (CLF)</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal courant avec un serveur virtuel</dt>
        <dd><code>"%v %h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal NCSA tandu/combin</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\"
        \"%{User-agent}i\""</code></dd>

        <dt>Format de journal de la page qui contient le lien vers la
	page concerne (Referer)</dt>
        <dd><code>"%{Referer}i -&gt; %U"</code></dd>

        <dt>Format de journal de l'agent (Navigateur)</dt>
        <dd><code>"%{User-agent}i"</code></dd>
      </dl>

      <p>Vous pouvez utiliser plusieurs fois la directive
      <code>%{format}t</code> pour construire un format de temps
      utilisant les symboles de format tendus tels que
      <code>msec_frac</code> :</p>
      <dl>
<dt>Format de temps prenant en compte les milisecondes</dt>
<dd><code>"%{%d/%b/%Y %T}t.%{msec_frac}t %{%z}t"</code></dd>

      </dl>

    
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Considrations concernant la
scurit</a></h2>
    <p>Voir le document <a href="../misc/security_tips.html#serverroot">conseils  matire de
    scurit</a> pour plus de dtails sur les raisons pour lesquelles
    votre scurit pourrait tre compromise, si le rpertoire o sont
    stocks les fichiers journaux sont inscriptibles par tout autre
    utilisateur que celui qui dmarre le serveur.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="bufferedlogs" id="bufferedlogs">Directive</a> <a name="BufferedLogs" id="BufferedLogs">BufferedLogs</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistre les entres du journal dans un tampon en mmoire
avant de les crire sur disque</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BufferedLogs On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BufferedLogs Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_log_config</td></tr>
</table>
    <p>Lorsque la directive <code class="directive">BufferedLogs</code> est 
    "on", <code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code> stocke de nombreuses entres
    du journal en mmoire, et les crit d'un seul bloc sur disque,
    plutt que de les crire aprs chaque requte. Sur certains
    systmes, ceci peut amliorer l'efficacit des accs disque, et par
    consquent les performances. La directive ne peut tre dfinie
    qu'une seule fois pour l'ensemble du serveur ; elle ne peut pas tre
    dfinie au niveau d'un serveur virtuel.</p>

    <div class="note">Cette directive doit tre utilise avec
    prcautions car un crash peut provoquer la perte de donnes de
    journalisation.</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="customlog" id="customlog">Directive</a> <a name="CustomLog" id="CustomLog">CustomLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom et le format du fichier
journal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CustomLog  <var>fichier</var>|<var>pipe</var>
<var>format</var>|<var>alias</var>
[env=[!]<var>variable-environnement</var>|
expr=<var>expression</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_log_config</td></tr>
</table>
    <p>La directive <code class="directive">CustomLog</code> permet de contrler
    la journalisation des requtes destines au serveur. Un format de
    journal est spcifi, et la journalisation peut s'effectuer de
    manire conditionnelle en fonction des caractristiques de la
    requte en utilisant des variables d'environnement.</p>

    <p>Le premier argument, qui spcifie l'emplacement o les journaux
    seront crits, accepte deux types de valeurs :</p>

    <dl>
      <dt><var>fichier</var></dt>
      <dd>Un nom de fichier, relatif au rpertoire dfini par la
      directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>.</dd>

      <dt><var>pipe</var></dt>
      <dd>Le caractre pipe "<code>|</code>", suivi du chemin vers un
      programme qui recevra les informations de la journalisation sur
      son entre standard. Voir les notes  propos de la <a href="../logs.html#piped">journalisation redirige</a> pour plus
      d'informations.

      <div class="warning"><h3>Scurit :</h3>
      <p>Si les journaux sont redirigs vers un programme, ce dernier
      s'excutera sous l'utilisateur qui a dmarr
      <code class="program"><a href="../programs/httpd.html">httpd</a></code>. Ce sera l'utilisateur root si le serveur
      a t dmarr par root ; vrifiez que le programme est
      scuris.</p>
      </div>
      <div class="warning"><h3>Note</h3>
        <p>Lors de la spcification d'un chemin de fichier sur les
	plate-formes non-Unix, il faut prendre soin de ne pas oublier
	que seuls les slashes directs doivent tre utiliss, mme si la
	plate-forme autorise l'emploi d'anti-slashes. D'une manire
	gnrale, c'est une bonne ide que de n'utiliser que des slashes
	directs dans les fichiers de configuration.</p>
      </div></dd>
    </dl>

    <p>Le second argument permet de dfinir ce qui va tre crit dans le
    fichier journal. Il peut contenir soit un <var>alias</var> prdfini
    par une directive <code class="directive"><a href="#logformat">LogFormat</a></code>, soit une chane de
    <var>format</var> explicite comme dcrit dans la section <a href="#formats">formats de journaux</a>.</p>

    <p>Par exemple, les deux blocs de directives suivants produisent le
    mme effet :</p>

    <pre class="prettyprint lang-config"># Journal personnalis avec alias de format
LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common
CustomLog "logs/access_log" common

# Journal personnalis avec chane de format explicite
CustomLog "logs/access_log" "%h %l %u %t \"%r\" %&gt;s %b"</pre>


    <p>Le troisime argument est optionnel et permet de contrler si une
    requte doit tre ou non journalise. Dans le cas d'une clause
    '<code>env=!<var>nom</var></code>', la condition peut tre la
    prsence ou l'absence d'une variable particulire dans
    l'<a href="../env.html">environnement du serveur</a>. Dans le cas
    d'une clause 'expr=<var>expression</var>', la condition consiste
    en une <a href="../expr.html">expression</a> boolenne
    quelconque. Si la condition n'est pas vrifie, la requte ne sera
    pas journalise. D'ventuelles rfrences  des en-ttes HTTP dans
    l'expression rationnelle n'entraneront pas l'ajout des noms
    d'en-tte correspondants  l'en-tte Vary.</p>

    <p>Les variables d'environnement peuvent tre dfinies au niveau de
    chaque requte en utilisant les modules
    <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code> et/ou <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>.
    Par exemple, si vous voulez enregistrer les requtes pour toutes les
    images GIF sur votre serveur dans un fichier journal spar, et pas
    dans votre journal principal, vous pouvez utiliser :</p>

    <pre class="prettyprint lang-config">SetEnvIf Request_URI \.gif$ gif-image
CustomLog "gif-requests.log" common env=gif-image
CustomLog "nongif-requests.log" common env=!gif-image</pre>


    <p>Ou, pour reproduire le comportement de l'ancienne directive
    RefererIgnore, vous pouvez utiliser :</p>

    <pre class="prettyprint lang-config">SetEnvIf Referer example\.com localreferer
CustomLog "referer.log" referer env=!localreferer</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="globallog" id="globallog">Directive</a> <a name="GlobalLog" id="GlobalLog">GlobalLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom et le format du fichier journal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>GlobalLog<var>file</var>|<var>pipe</var>
<var>format</var>|<var>nickname</var>
[env=[!]<var>environment-variable</var>|
expr=<var>expression</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_log_config</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.19 du serveur HTTP Apache</td></tr>
</table>

    <p>La directive <code class="directive">GlobalLog</code> permet de spcifier un
    journal partag entre le serveur principal et tous les serveurs virtuels
    dfinis.</p>

    <p>Elle est identique  la directive <code class="directive">CustomLog</code>  ces
    diffrences prs : </p>
    <ul>
       <li>Elle n'est pas valide dans un contexte de serveur virtuel.</li>
       <li>A la diffrence d'une directive <code class="directive">CustomLog</code>
       dfinie globalement, elle est prise en compte par les serveurs virtuels
       qui dfinissent leur propre directive <code class="directive">CustomLog</code>.</li>
    </ul>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="logformat" id="logformat">Directive</a> <a name="LogFormat" id="LogFormat">LogFormat</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dcrit un format utilisable dans un fichier
journal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LogFormat <var>format</var>|<var>alias</var>
[<var>alias</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LogFormat "%h %l %u %t \"%r\" %&gt;s %b"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_log_config</td></tr>
</table>
    <p>Cette directive permet de spcifier le format du fichier journal
    des accs.</p>

    <p>La directive <code class="directive">LogFormat</code> se prsente sous
    deux formes. Sous la premire forme, qui ne possde qu'un seul
    argument, la directive dfinit le format qui sera utilis dans les
    journaux spcifis par les directives
    <code class="directive">TransferLog</code> ultrieures. L'argument unique
    peut contenir un <var>format</var> explicite comme dcrit dans la
    section <a href="#formats">formats de journaux personnaliss</a>
    ci-dessus. Il peut aussi contenir un <var>alias</var> faisant
    rfrence  un format de journal prdfini par une directive
    <code class="directive">LogFormat</code> comme dcrit plus loin.</p>

    <p>Sous sa seconde forme, la directive
    <code class="directive">LogFormat</code> associe un <var>format</var>
    explicite  un <var>alias</var>. Cet <var>alias</var> peut
    ensuite s'utiliser dans les directives
    <code class="directive">LogFormat</code> ou <code class="directive"><a href="#customlog">CustomLog</a></code> ultrieures, ce qui
    vite d'avoir  rpter l'ensemble de la chane de format. Une
    directive <code class="directive">LogFormat</code> qui dfinit un alias
    <strong>ne fait rien d'autre</strong> -- c'est  dire qu'<em>elle ne
    fait que</em> dfinir l'alias, elle n'applique pas le format et n'en
    fait pas le format par dfaut. Par consquent, elle n'affecte pas
    les directives <code class="directive"><a href="#transferlog">TransferLog</a></code> ultrieures. En
    outre, la directive <code class="directive">LogFormat</code> ne peut pas
    utiliser un alias pour en dfinir un autre. Notez que l'alias ne
    doit pas contenir de caractre pourcent (<code>%</code>).</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" serveur_virtuel_commun</pre>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="transferlog" id="transferlog">Directive</a> <a name="TransferLog" id="TransferLog">TransferLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie l'emplacement d'un fichier journal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TransferLog <var>fichier</var>|<var>pipe</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_log_config</td></tr>
</table>
    <p>Cette directive possde exactement les mmes arguments et produit
    les mmes effets que la directive <code class="directive"><a href="#customlog">CustomLog</a></code>,  l'exception qu'elle
    ne permet pas de spcifier un format de journal explicite ou la
    journalisation conditionnelle des requtes. En l'occurrence, le
    format de journal est dtermin par la dernire dfinition d'une
    directive <code class="directive"><a href="#logformat">LogFormat</a></code>
    qui ne dfinit pas d'alias. Si aucun format particulier n'a t
    spcifi, c'est le Common Log Format qui sera utilis.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">LogFormat "%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\" \"%{User-agent}i\""
TransferLog logs/access_log</pre>
</div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_log_config.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_log_config.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_log_config.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_log_config.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_log_config.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_log_config.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>