/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Transforms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalBorders;

public final class TransformAnim
extends AnimatingControlsSurface {
    private static final TexturePaint texturePaint;
    private static BasicStroke bs;
    private static Font[] fonts;
    private static String[] strings;
    private static String[] imgs;
    private static Paint[] paints;
    private List<ObjData> objDatas = new ArrayList<ObjData>(13);
    private int numShapes;
    private int numStrings;
    private int numImages;
    protected boolean doRotate = true;
    protected boolean doTranslate = true;
    protected boolean doScale = true;
    protected boolean doShear;

    public TransformAnim() {
        this.setBackground(Color.BLACK);
        this.setStrings(1);
        this.setImages(2);
        this.setShapes(10);
        this.setControls(new Component[]{new DemoControls(this)});
        this.setConstraints(new String[]{"East"});
    }

    public void setImages(int num) {
        if (num < this.numImages) {
            ArrayList<ObjData> v = new ArrayList<ObjData>(this.objDatas.size());
            for (ObjData objData : this.objDatas) {
                if (!(objData.object instanceof Image)) continue;
                v.add(objData);
            }
            this.objDatas.removeAll(v.subList(num, v.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numImages; i < num; ++i) {
                Image obj = this.getImage(imgs[i % imgs.length]);
                ObjData objData = new ObjData(obj, Color.BLACK);
                objData.reset(d.width, d.height);
                this.objDatas.add(objData);
            }
        }
        this.numImages = num;
    }

    public void setStrings(int num) {
        if (num < this.numStrings) {
            ArrayList<ObjData> v = new ArrayList<ObjData>(this.objDatas.size());
            for (ObjData objData : this.objDatas) {
                if (!(objData.object instanceof TextData)) continue;
                v.add(objData);
            }
            this.objDatas.removeAll(v.subList(num, v.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numStrings; i < num; ++i) {
                int j = i % fonts.length;
                int k = i % strings.length;
                TextData obj = new TextData(strings[k], fonts[j]);
                ObjData objData = new ObjData(obj, paints[i % paints.length]);
                objData.reset(d.width, d.height);
                this.objDatas.add(objData);
            }
        }
        this.numStrings = num;
    }

    public void setShapes(int num) {
        if (num < this.numShapes) {
            ArrayList<ObjData> v = new ArrayList<ObjData>(this.objDatas.size());
            for (ObjData objData : this.objDatas) {
                if (!(objData.object instanceof Shape)) continue;
                v.add(objData);
            }
            this.objDatas.removeAll(v.subList(num, v.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numShapes; i < num; ++i) {
                Shape obj = null;
                switch (i % 7) {
                    case 0: {
                        obj = new GeneralPath();
                        break;
                    }
                    case 1: {
                        obj = new Rectangle2D.Double();
                        break;
                    }
                    case 2: {
                        obj = new Ellipse2D.Double();
                        break;
                    }
                    case 3: {
                        obj = new Arc2D.Double();
                        break;
                    }
                    case 4: {
                        obj = new RoundRectangle2D.Double();
                        break;
                    }
                    case 5: {
                        obj = new CubicCurve2D.Double();
                        break;
                    }
                    case 6: {
                        obj = new QuadCurve2D.Double();
                    }
                }
                ObjData objData = new ObjData(obj, paints[i % paints.length]);
                objData.reset(d.width, d.height);
                this.objDatas.add(objData);
            }
        }
        this.numShapes = num;
    }

    @Override
    public void reset(int w, int h) {
        for (ObjData objData : this.objDatas) {
            objData.reset(w, h);
        }
    }

    @Override
    public void step(int w, int h) {
        for (ObjData objData : this.objDatas) {
            objData.step(w, h, this);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        for (ObjData objData : this.objDatas) {
            g2.setTransform(objData.at);
            g2.setPaint(objData.paint);
            if (objData.object instanceof Image) {
                g2.drawImage((Image)objData.object, 0, 0, this);
                continue;
            }
            if (objData.object instanceof TextData) {
                g2.setFont(((TextData)objData.object).font);
                g2.drawString(((TextData)objData.object).string, 0, 0);
                continue;
            }
            if (objData.object instanceof QuadCurve2D || objData.object instanceof CubicCurve2D) {
                g2.setStroke(bs);
                g2.draw((Shape)objData.object);
                continue;
            }
            if (!(objData.object instanceof Shape)) continue;
            g2.fill((Shape)objData.object);
        }
    }

    public static void main(String[] argv) {
        TransformAnim.createDemoFrame(new TransformAnim());
    }

    static {
        BufferedImage bi = new BufferedImage(10, 10, 1);
        Graphics2D gi = bi.createGraphics();
        gi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gi.setColor(Color.RED);
        gi.fillOval(0, 0, 9, 9);
        texturePaint = new TexturePaint(bi, new Rectangle(0, 0, 10, 10));
        bs = new BasicStroke(6.0f);
        fonts = new Font[]{new Font("Serif", 0, 48), new Font("Serif", 3, 24), new Font("Monospaced", 1, 36), new Font("SansSerif", 3, 64), new Font("SansSerif", 0, 52)};
        strings = new String[]{"Transformation", "Rotate", "Translate", "Shear", "Scale"};
        imgs = new String[]{"duke.png"};
        paints = new Paint[]{Color.RED, Color.BLUE, texturePaint, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.CYAN, new Color(0, 255, 0, 128), new Color(0, 0, 255, 128), Color.YELLOW, Color.LIGHT_GRAY, Color.WHITE};
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener,
    ChangeListener {
        TransformAnim demo;
        JSlider shapeSlider;
        JSlider stringSlider;
        JSlider imageSlider;
        Font font = new Font("Serif", 1, 10);
        JToolBar toolbar;
        MetalBorders.ButtonBorder buttonBorder = new MetalBorders.ButtonBorder();

        public DemoControls(TransformAnim demo) {
            super(demo.name);
            this.demo = demo;
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalStrut(5));
            JToolBar bar = new JToolBar(1);
            bar.setFloatable(false);
            this.shapeSlider = new JSlider(0, 0, 20, demo.numShapes);
            this.shapeSlider.addChangeListener(this);
            TitledBorder tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numShapes) + " Shapes");
            this.shapeSlider.setBorder(tb);
            this.shapeSlider.setOpaque(true);
            this.shapeSlider.setPreferredSize(new Dimension(80, 44));
            bar.add(this.shapeSlider);
            bar.addSeparator();
            this.stringSlider = new JSlider(0, 0, 10, demo.numStrings);
            this.stringSlider.addChangeListener(this);
            tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numStrings) + " Strings");
            this.stringSlider.setBorder(tb);
            this.stringSlider.setOpaque(true);
            this.stringSlider.setPreferredSize(new Dimension(80, 44));
            bar.add(this.stringSlider);
            bar.addSeparator();
            this.imageSlider = new JSlider(0, 0, 10, demo.numImages);
            this.imageSlider.addChangeListener(this);
            tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numImages) + " Images");
            this.imageSlider.setBorder(tb);
            this.imageSlider.setOpaque(true);
            this.imageSlider.setPreferredSize(new Dimension(80, 44));
            bar.add(this.imageSlider);
            bar.addSeparator();
            this.add(bar);
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.addButton("T", "translate", demo.doTranslate);
            this.addButton("R", "rotate", demo.doRotate);
            this.addButton("SC", "scale", demo.doScale);
            this.addButton("SH", "shear", demo.doShear);
            this.add(this.toolbar);
        }

        public void addButton(String s, String tt, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(s));
            b.setFont(this.font);
            b.setSelected(state);
            b.setToolTipText(tt);
            b.setFocusPainted(false);
            b.setBorder(this.buttonBorder);
            b.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            if (b.getText().equals("T")) {
                this.demo.doTranslate = b.isSelected();
            } else if (b.getText().equals("R")) {
                this.demo.doRotate = b.isSelected();
            } else if (b.getText().equals("SC")) {
                this.demo.doScale = b.isSelected();
            } else if (b.getText().equals("SH")) {
                this.demo.doShear = b.isSelected();
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            int value = slider.getValue();
            TitledBorder tb = (TitledBorder)slider.getBorder();
            if (slider.equals(this.shapeSlider)) {
                tb.setTitle(String.valueOf(value) + " Shapes");
                this.demo.setShapes(value);
            } else if (slider.equals(this.stringSlider)) {
                tb.setTitle(String.valueOf(value) + " Strings");
                this.demo.setStrings(value);
            } else if (slider.equals(this.imageSlider)) {
                tb.setTitle(String.valueOf(value) + " Images");
                this.demo.setImages(value);
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
            slider.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(80, 38);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 1; i < this.toolbar.getComponentCount(); ++i) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    ((AbstractButton)this.toolbar.getComponentAtIndex(i)).doClick();
                }
            }
            this.thread = null;
        }
    }

    static class ObjData {
        Object object;
        Paint paint;
        static final int UP = 0;
        static final int DOWN = 1;
        double x;
        double y;
        double ix = 5.0;
        double iy = 3.0;
        int rotate;
        double scale;
        double shear;
        int scaleDirection;
        int shearDirection;
        AffineTransform at = new AffineTransform();

        public ObjData(Object object, Paint paint) {
            this.object = object;
            this.paint = paint;
            this.rotate = (int)(Math.random() * 360.0);
            this.scale = Math.random() * 1.5;
            this.scaleDirection = Math.random() > 0.5 ? 0 : 1;
            this.shear = Math.random() * 0.5;
            this.shearDirection = Math.random() > 0.5 ? 0 : 1;
        }

        public void reset(int w, int h) {
            this.x = Math.random() * (double)w;
            this.y = Math.random() * (double)h;
            double ww = 20.0 + Math.random() * (double)((w == 0 ? 400 : w) / 4);
            double hh = 20.0 + Math.random() * (double)((h == 0 ? 300 : h) / 4);
            if (this.object instanceof Ellipse2D) {
                ((Ellipse2D)this.object).setFrame(0.0, 0.0, ww, hh);
            } else if (this.object instanceof Rectangle2D) {
                ((Rectangle2D)this.object).setRect(0.0, 0.0, ww, ww);
            } else if (this.object instanceof RoundRectangle2D) {
                ((RoundRectangle2D)this.object).setRoundRect(0.0, 0.0, hh, hh, 20.0, 20.0);
            } else if (this.object instanceof Arc2D) {
                ((Arc2D)this.object).setArc(0.0, 0.0, hh, hh, 45.0, 270.0, 2);
            } else if (this.object instanceof QuadCurve2D) {
                ((QuadCurve2D)this.object).setCurve(0.0, 0.0, (double)w * 0.2, (double)h * 0.4, (double)w * 0.4, 0.0);
            } else if (this.object instanceof CubicCurve2D) {
                ((CubicCurve2D)this.object).setCurve(0.0, 0.0, 30.0, -60.0, 60.0, 60.0, 90.0, 0.0);
            } else if (this.object instanceof GeneralPath) {
                GeneralPath p = new GeneralPath();
                float size = (float)ww;
                p.moveTo(-size / 2.0f, -size / 8.0f);
                p.lineTo(size / 2.0f, -size / 8.0f);
                p.lineTo(-size / 4.0f, size / 2.0f);
                p.lineTo(0.0f, -size / 2.0f);
                p.lineTo(size / 4.0f, size / 2.0f);
                p.closePath();
                this.object = p;
            }
        }

        public void step(int w, int h, TransformAnim demo) {
            this.at.setToIdentity();
            if (demo.doRotate) {
                if ((this.rotate += 5) == 360) {
                    this.rotate = 0;
                }
                this.at.rotate(Math.toRadians(this.rotate), this.x, this.y);
            }
            this.at.translate(this.x, this.y);
            if (demo.doTranslate) {
                this.x += this.ix;
                this.y += this.iy;
                if (this.x > (double)w) {
                    this.x = w - 1;
                    this.ix = Math.random() * (double)(-w) / 32.0 - 1.0;
                }
                if (this.x < 0.0) {
                    this.x = 2.0;
                    this.ix = Math.random() * (double)w / 32.0 + 1.0;
                }
                if (this.y > (double)h) {
                    this.y = h - 2;
                    this.iy = Math.random() * (double)(-h) / 32.0 - 1.0;
                }
                if (this.y < 0.0) {
                    this.y = 2.0;
                    this.iy = Math.random() * (double)h / 32.0 + 1.0;
                }
            }
            if (demo.doScale && this.scaleDirection == 0) {
                double d;
                this.scale += 0.05;
                if (d > 1.5) {
                    this.scaleDirection = 1;
                }
            } else if (demo.doScale && this.scaleDirection == 1) {
                double d;
                this.scale -= 0.05;
                if (d < 0.5) {
                    this.scaleDirection = 0;
                }
            }
            if (demo.doScale) {
                this.at.scale(this.scale, this.scale);
            }
            if (demo.doShear && this.shearDirection == 0) {
                double d;
                this.shear += 0.05;
                if (d > 0.5) {
                    this.shearDirection = 1;
                }
            } else if (demo.doShear && this.shearDirection == 1) {
                double d;
                this.shear -= 0.05;
                if (d < -0.5) {
                    this.shearDirection = 0;
                }
            }
            if (demo.doShear) {
                this.at.shear(this.shear, this.shear);
            }
        }
    }

    static class TextData {
        public String string;
        public Font font;

        public TextData(String str, Font font) {
            this.string = str;
            this.font = font;
        }
    }
}

