/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.input.LimitInputStream;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.scp.ScpModuleProperties;
import org.apache.sshd.scp.common.ScpException;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpReceiveLineHandler;
import org.apache.sshd.scp.common.ScpSourceStreamResolver;
import org.apache.sshd.scp.common.ScpTargetStreamResolver;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.DefaultScpFileOpener;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.apache.sshd.scp.common.helpers.ScpIoUtils;
import org.apache.sshd.scp.common.helpers.ScpPathCommandDetailsSupport;
import org.apache.sshd.scp.common.helpers.ScpReceiveDirCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpReceiveFileCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public class ScpHelper
extends AbstractLoggingBean
implements SessionHolder<Session> {
    public static final String SCP_COMMAND_PREFIX = "scp";
    public static final int DEFAULT_COPY_BUFFER_SIZE = 8192;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 8192;
    public static final int DEFAULT_SEND_BUFFER_SIZE = 8192;
    public static final int MIN_COPY_BUFFER_SIZE = 127;
    public static final int MIN_RECEIVE_BUFFER_SIZE = 127;
    public static final int MIN_SEND_BUFFER_SIZE = 127;
    protected final InputStream in;
    protected final Charset csIn;
    protected final OutputStream out;
    protected final Charset csOut;
    protected final FileSystem fileSystem;
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    private final Session sessionInstance;

    public ScpHelper(Session session, InputStream in, OutputStream out, FileSystem fileSystem, ScpFileOpener opener, ScpTransferEventListener eventListener) {
        this(session, in, (Charset)ScpModuleProperties.SCP_INCOMING_ENCODING.getRequired((PropertyResolver)session), out, (Charset)ScpModuleProperties.SCP_OUTGOING_ENCODING.getRequired((PropertyResolver)session), fileSystem, opener, eventListener);
    }

    public ScpHelper(Session session, InputStream in, Charset csIn, OutputStream out, Charset csOut, FileSystem fileSystem, ScpFileOpener opener, ScpTransferEventListener eventListener) {
        this.sessionInstance = Objects.requireNonNull(session, "No session");
        this.in = Objects.requireNonNull(in, "No input stream");
        this.csIn = Objects.requireNonNull(csIn, "No input charset");
        this.out = Objects.requireNonNull(out, "No output stream");
        this.csOut = Objects.requireNonNull(csOut, "No output charset");
        this.fileSystem = fileSystem;
        this.opener = opener == null ? DefaultScpFileOpener.INSTANCE : opener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    public Session getSession() {
        return this.sessionInstance;
    }

    public void receiveFileStream(String command, final OutputStream local, int bufferSize) throws IOException {
        this.receive(command, (session, line, isDir, timestamp) -> {
            if (isDir) {
                throw new StreamCorruptedException("Cannot download a directory into a file stream: " + line);
            }
            MockPath path = new MockPath(line);
            this.receiveStream(line, new ScpTargetStreamResolver(){
                final /* synthetic */ Path val$path;
                final /* synthetic */ String val$line;
                {
                    this.val$path = path;
                    this.val$line = string;
                }

                @Override
                public OutputStream resolveTargetStream(Session session, String name, long length, Set<PosixFilePermission> perms, OpenOption ... options) throws IOException {
                    if (ScpHelper.this.log.isDebugEnabled()) {
                        ScpHelper.this.log.debug("resolveTargetStream({}) name={}, perms={}, len={} - started local stream download", new Object[]{ScpHelper.this, name, perms, length});
                    }
                    return local;
                }

                @Override
                public Path getEventListenerFilePath() {
                    return this.val$path;
                }

                @Override
                public void postProcessReceivedData(String name, boolean preserve, Set<PosixFilePermission> perms, ScpTimestampCommandDetails time) throws IOException {
                    if (ScpHelper.this.log.isDebugEnabled()) {
                        ScpHelper.this.log.debug("postProcessReceivedData({}) name={}, perms={}, preserve={} time={}", new Object[]{ScpHelper.this, name, perms, preserve, time});
                    }
                }

                public String toString() {
                    return this.val$line;
                }
            }, timestamp, false, bufferSize);
        });
    }

    public void receive(String cmd, Path local, boolean recursive, boolean shouldBeDir, boolean preserve, int bufferSize) throws IOException {
        Path localPath = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        Path path = this.opener.resolveIncomingReceiveLocation(this.getSession(), localPath, recursive, shouldBeDir, preserve);
        this.receive(cmd, (session, line, isDir, time) -> {
            if (recursive && isDir) {
                this.receiveDir(line, path, time, preserve, bufferSize);
            } else {
                this.receiveFile(line, path, time, preserve, bufferSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(String cmd, ScpReceiveLineHandler handler) throws IOException {
        this.sendOk();
        boolean debugEnabled = this.log.isDebugEnabled();
        Session session = this.getSession();
        ScpTimestampCommandDetails time = null;
        while (true) {
            block17: {
                ScpAckInfo ackInfo;
                if ((ackInfo = this.receiveNextCmd()) == null) {
                    return;
                }
                int c = ackInfo.getStatusCode();
                String line = ackInfo.getLine();
                switch (c) {
                    case 0: {
                        if (debugEnabled) {
                            this.log.debug("receive({})[{}] ack={}", new Object[]{this, cmd, ackInfo});
                        }
                        this.listener.handleReceiveCommandAckInfo(session, cmd, ackInfo);
                        break block17;
                    }
                    case 1: {
                        this.log.warn("receive({})[{}] ack={}", new Object[]{this, cmd, ackInfo});
                        this.listener.handleReceiveCommandAckInfo(session, cmd, ackInfo);
                        break block17;
                    }
                    case 2: {
                        this.log.error("receive({})[{}] bad ack: {}", new Object[]{this, cmd, ackInfo});
                        this.listener.handleReceiveCommandAckInfo(session, cmd, ackInfo);
                        break block17;
                    }
                    case 68: {
                        if (!debugEnabled) break;
                        this.log.debug("receive({}) - Received 'D' header: {}", (Object)this, (Object)line);
                        break;
                    }
                    case 67: {
                        if (!debugEnabled) break;
                        this.log.debug("receive({}) - Received 'C' header: {}", (Object)this, (Object)line);
                        break;
                    }
                    case 84: {
                        if (debugEnabled) {
                            this.log.debug("receive({}) - Received 'T' header: {}", (Object)this, (Object)line);
                        }
                        time = ScpTimestampCommandDetails.parse(line);
                        cmd = line;
                        this.sendOk();
                        break block17;
                    }
                    case 69: {
                        if (debugEnabled) {
                            this.log.debug("receive({}) - Received 'E' header: {}", (Object)this, (Object)line);
                        }
                        this.sendOk();
                        return;
                    }
                    default: {
                        this.log.error("receive({}) - Unsupported command: {}", (Object)this, (Object)line);
                        throw new ScpException("Unsupported command: " + line, (Integer)2);
                    }
                }
                try {
                    boolean isDir = c == 68;
                    cmd = line;
                    handler.process(session, line, isDir, time);
                }
                finally {
                    time = null;
                }
            }
            debugEnabled = this.log.isDebugEnabled();
        }
    }

    protected ScpAckInfo receiveNextCmd() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return null;
        }
        if (c == 0) {
            return ScpAckInfo.OK_ACK_INFO;
        }
        if (c == 1 || c == 2) {
            String line = ScpIoUtils.readLine(this.in, this.csIn, true);
            return new ScpAckInfo(c, line);
        }
        String line = ScpIoUtils.readLine(this.in, this.csIn, false);
        return new ScpAckInfo(c, Character.toString((char)c) + line);
    }

    public void receiveDir(String header, Path local, ScpTimestampCommandDetails time, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("receiveDir({})[{}] Receiving directory {} - preserve={}, time={}, buffer-size={}", new Object[]{this, header, path, preserve, time, bufferSize});
        }
        ScpReceiveDirCommandDetails details = new ScpReceiveDirCommandDetails(header);
        String name = details.getName();
        long length = details.getLength();
        if (length != 0L) {
            throw new IOException("Expected 0 length for directory=" + name + " but got " + length);
        }
        Session session = this.getSession();
        Set<PosixFilePermission> perms = details.getPermissions();
        Path file = this.opener.resolveIncomingFilePath(session, path, name, preserve, perms, time);
        this.sendOk();
        time = null;
        this.listener.startFolderEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, path, perms);
        try {
            block8: {
                while (true) {
                    char cmdChar;
                    header = this.readLine();
                    if (debugEnabled) {
                        this.log.debug("receiveDir({})[{}] Received header: {}", new Object[]{this, file, header});
                    }
                    if ((cmdChar = header.charAt(0)) == 'C') {
                        this.receiveFile(header, file, time, preserve, bufferSize);
                        time = null;
                        continue;
                    }
                    if (cmdChar == 'D') {
                        this.receiveDir(header, file, time, preserve, bufferSize);
                        time = null;
                        continue;
                    }
                    if (cmdChar == 'E') break block8;
                    if (cmdChar != 'T') break;
                    time = ScpTimestampCommandDetails.parse(header);
                    this.sendOk();
                }
                throw new IOException("Unexpected message: '" + header + "'");
            }
            this.sendOk();
        }
        catch (IOException | RuntimeException e) {
            this.listener.endFolderEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, path, perms, e);
            throw e;
        }
        this.listener.endFolderEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, path, perms, null);
    }

    public void receiveFile(String header, Path local, ScpTimestampCommandDetails time, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("receiveFile({})[{}] Receiving file {} - preserve={}, time={}, buffer-size={}", new Object[]{this, header, path, preserve, time, bufferSize});
        }
        ScpTargetStreamResolver targetStreamResolver = this.opener.createScpTargetStreamResolver(this.getSession(), path);
        this.receiveStream(header, targetStreamResolver, time, preserve, bufferSize);
    }

    public void receiveStream(String header, ScpTargetStreamResolver resolver, ScpTimestampCommandDetails time, boolean preserve, int bufferSize) throws IOException {
        Path file;
        int bufSize;
        if (bufferSize < 127) {
            throw new IOException("receiveStream(" + resolver + ") buffer size (" + bufferSize + ") below minimum (" + 127 + ")");
        }
        ScpReceiveFileCommandDetails details = new ScpReceiveFileCommandDetails(header);
        long length = details.getLength();
        if (length < 0L) {
            this.log.warn("receiveStream({})[{}] bad length in header: {}", new Object[]{this, resolver, header});
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (length == 0L) {
            if (debugEnabled) {
                this.log.debug("receiveStream({})[{}] zero file size (perhaps special file) using copy buffer size={}", new Object[]{this, resolver, 127});
            }
            bufSize = 127;
        } else {
            bufSize = (int)Math.min(length, (long)bufferSize);
        }
        if (bufSize < 0) {
            this.log.warn("receiveStream({})[{}] bad buffer size ({}) using default ({})", new Object[]{this, resolver, bufSize, 127});
            bufSize = 127;
        }
        Session session = this.getSession();
        String name = details.getName();
        Set<PosixFilePermission> perms = details.getPermissions();
        try (LimitInputStream is = new LimitInputStream(this.in, length);
             OutputStream os = resolver.resolveTargetStream(session, name, length, perms, IoUtils.EMPTY_OPEN_OPTIONS);){
            file = resolver.getEventListenerFilePath();
            this.listener.startFileEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms);
            this.sendOk();
            try {
                IoUtils.copy((InputStream)is, (OutputStream)os, (int)bufSize);
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFileEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms, e);
                throw e;
            }
            this.listener.endFileEvent(session, ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms, null);
            resolver.closeTargetStream(session, name, length, perms, os);
        }
        resolver.postProcessReceivedData(name, preserve, perms, time);
        this.sendOk();
        ScpAckInfo ackInfo = this.readAck(false);
        if (debugEnabled) {
            this.log.debug("receiveStream({})[{}] ACK={}", new Object[]{this, resolver, ackInfo});
        }
        this.validateFileOperationAckReplyCode(header, session, ScpTransferEventListener.FileOperation.RECEIVE, file, length, perms, ackInfo);
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean canEof) throws IOException {
        return ScpIoUtils.readLine(this.in, this.csIn, canEof);
    }

    public void send(Collection<String> paths, boolean recursive, boolean preserve, int bufferSize) throws IOException {
        ScpAckInfo ackInfo = this.readAck(false);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("send({}) ACK={}", paths, (Object)ackInfo);
        }
        this.validateOperationReadyCode("send", "Paths", ackInfo);
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        for (String pattern : paths) {
            int idx = (pattern = pattern.replace('/', File.separatorChar)).indexOf(42);
            if (idx >= 0) {
                String basedir = "";
                String fixedPart = pattern.substring(0, idx);
                int lastSep = fixedPart.lastIndexOf(File.separatorChar);
                if (lastSep >= 0) {
                    basedir = pattern.substring(0, lastSep);
                    pattern = pattern.substring(lastSep + 1);
                }
                Session session = this.getSession();
                Path basePath = this.resolveLocalPath(basedir);
                Iterable<Path> included = this.opener.getMatchingFilesToSend(session, basePath, pattern);
                for (Path file : included) {
                    String path;
                    if (this.opener.sendAsRegularFile(session, file, options)) {
                        this.sendFile(file, preserve, bufferSize);
                        continue;
                    }
                    if (this.opener.sendAsDirectory(session, file, options)) {
                        if (!recursive) {
                            if (debugEnabled) {
                                this.log.debug("send({}) {}: not a regular file", (Object)this, (Object)file);
                            }
                            path = basePath.relativize(file).toString();
                            this.sendWarning(path.replace(File.separatorChar, '/') + " not a regular file");
                            continue;
                        }
                        this.sendDir(file, preserve, bufferSize);
                        continue;
                    }
                    if (debugEnabled) {
                        this.log.debug("send({}) {}: unknown file type", (Object)this, (Object)file);
                    }
                    path = basePath.relativize(file).toString();
                    this.sendWarning(path.replace(File.separatorChar, '/') + " unknown file type");
                }
                continue;
            }
            this.send(this.resolveLocalPath(pattern), recursive, preserve, bufferSize, options);
        }
    }

    public void sendPaths(Collection<? extends Path> paths, boolean recursive, boolean preserve, int bufferSize) throws IOException {
        ScpAckInfo ackInfo = this.readAck(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPaths({}) ACK={}", paths, (Object)ackInfo);
        }
        this.validateOperationReadyCode("sendPaths", "Paths", ackInfo);
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        for (Path path : paths) {
            this.send(path, recursive, preserve, bufferSize, options);
        }
    }

    protected void send(Path local, boolean recursive, boolean preserve, int bufferSize, LinkOption ... options) throws IOException {
        Path file;
        Path localPath = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        Session session = this.getSession();
        if (this.opener.sendAsRegularFile(session, file = this.opener.resolveOutgoingFilePath(session, localPath, options), options)) {
            this.sendFile(file, preserve, bufferSize);
        } else if (this.opener.sendAsDirectory(session, file, options)) {
            if (!recursive) {
                throw new IOException(file + " not a regular file");
            }
            this.sendDir(file, preserve, bufferSize);
        } else {
            throw new IOException(file + ": unknown file type");
        }
    }

    public Path resolveLocalPath(String basedir, String subpath) throws IOException {
        if (GenericUtils.isEmpty((CharSequence)basedir)) {
            return this.resolveLocalPath(subpath);
        }
        return this.resolveLocalPath(basedir + File.separator + subpath);
    }

    public Path resolveLocalPath(String commandPath) throws IOException, InvalidPathException {
        Path p = this.opener.resolveLocalPath(this.getSession(), this.fileSystem, commandPath);
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveLocalPath({}) {}: {}", new Object[]{this, commandPath, p});
        }
        return p;
    }

    public void sendFile(Path local, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendFile({})[preserve={},buffer-size={}] Sending file {}", new Object[]{this, preserve, bufferSize, path});
        }
        ScpSourceStreamResolver sourceStreamResolver = this.opener.createScpSourceStreamResolver(this.getSession(), path);
        this.sendStream(sourceStreamResolver, preserve, bufferSize);
    }

    public void sendStream(ScpSourceStreamResolver resolver, boolean preserve, int bufferSize) throws IOException {
        Path path;
        int bufSize;
        if (bufferSize < 127) {
            throw new IOException("sendStream(" + resolver + ") buffer size (" + bufferSize + ") below minimum (" + 127 + ")");
        }
        long fileSize = resolver.getSize();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (fileSize <= 0L) {
            if (debugEnabled) {
                this.log.debug("sendStream({})[{}] unknown file size ({}) perhaps special file - using copy buffer size={}", new Object[]{this, resolver, fileSize, 127});
            }
            bufSize = 127;
        } else {
            bufSize = (int)Math.min(fileSize, (long)bufferSize);
        }
        if (bufSize < 0) {
            this.log.warn("sendStream({})[{}] bad buffer size ({}) using default ({})", new Object[]{this, resolver, bufSize, 127});
            bufSize = 127;
        }
        ScpTimestampCommandDetails time = resolver.getTimestamp();
        if (preserve && time != null) {
            ScpAckInfo ackInfo = ScpIoUtils.sendAcknowledgedCommand(time, this.in, this.csIn, this.out, this.csOut);
            String cmd = time.toHeader();
            if (debugEnabled) {
                this.log.debug("sendStream({})[{}] command='{}' ACK={}", new Object[]{this, resolver, cmd, ackInfo});
            }
            this.validateAckReplyCode(cmd, resolver, ackInfo);
        }
        EnumSet<PosixFilePermission> perms = EnumSet.copyOf(resolver.getPermissions());
        String octalPerms = !preserve || GenericUtils.isEmpty(perms) ? "0644" : ScpPathCommandDetailsSupport.getOctalPermissions(perms);
        String fileName = resolver.getFileName();
        String cmd = 'C' + octalPerms + " " + fileSize + " " + fileName;
        if (debugEnabled) {
            this.log.debug("sendStream({})[{}] send 'C' command: {}", new Object[]{this, resolver, cmd});
        }
        ScpAckInfo ackInfo = this.sendAcknowledgedCommand(cmd);
        if (debugEnabled) {
            this.log.debug("sendStream({})[{}] command='{}' ACK={}", new Object[]{this, resolver, cmd.substring(0, cmd.length() - 1), ackInfo});
        }
        this.validateAckReplyCode(cmd, resolver, ackInfo);
        Session session = this.getSession();
        try (InputStream in = resolver.resolveSourceStream(session, fileSize, perms, IoUtils.EMPTY_OPEN_OPTIONS);){
            path = resolver.getEventListenerFilePath();
            this.listener.startFileEvent(session, ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms);
            try {
                IoUtils.copy((InputStream)in, (OutputStream)this.out, (int)bufSize);
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFileEvent(session, ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms, e);
                throw e;
            }
            this.listener.endFileEvent(session, ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms, null);
            resolver.closeSourceStream(session, fileSize, perms, in);
        }
        this.sendOk();
        ackInfo = this.readAck(false);
        if (debugEnabled) {
            this.log.debug("sendStream({})[{}] command='{}' ACK={}", new Object[]{this, resolver, cmd, ackInfo});
        }
        this.validateFileOperationAckReplyCode(cmd, session, ScpTransferEventListener.FileOperation.SEND, path, fileSize, perms, ackInfo);
    }

    protected void validateOperationReadyCode(String command, Object location, ScpAckInfo ackInfo) throws IOException {
        this.validateCommandStatusCode(command, location, ackInfo, false);
    }

    protected void validateFileOperationAckReplyCode(String command, Session session, ScpTransferEventListener.FileOperation op, Path file, long fileSize, Set<PosixFilePermission> perms, ScpAckInfo ackInfo) throws IOException {
        this.listener.handleFileEventAckInfo(session, op, file, fileSize, perms, ackInfo);
        this.validateAckReplyCode(command, file, ackInfo);
    }

    protected void validateAckReplyCode(String command, Object location, ScpAckInfo ackInfo) throws IOException {
        this.validateCommandStatusCode(command, location, ackInfo, false);
    }

    protected void validateCommandStatusCode(String command, Object location, ScpAckInfo ackInfo, boolean eofAllowed) throws IOException {
        if (ackInfo == null) {
            if (eofAllowed) {
                return;
            }
            this.log.error("validateCommandStatusCode({})[{}] unexpected EOF while waiting on ACK for command={}", new Object[]{this, location, command});
            throw new EOFException("EOF while waiting on ACK for command=" + command + " at " + location);
        }
        int statusCode = ackInfo.getStatusCode();
        switch (statusCode) {
            case 0: {
                break;
            }
            case 1: {
                this.log.warn("validateCommandStatusCode({})[{}] advisory ACK={} for command={}", new Object[]{this, location, ackInfo, command});
                break;
            }
            default: {
                this.log.error("validateCommandStatusCode({})[{}] bad ACK={} for command={}", new Object[]{this, location, ackInfo, command});
                ackInfo.validateCommandStatusCode(command, location);
            }
        }
    }

    public void sendDir(Path local, boolean preserve, int bufferSize) throws IOException {
        Path path = Objects.requireNonNull(local, "No local path").normalize().toAbsolutePath();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("sendDir({}) Sending directory {} - preserve={}, buffer-size={}", new Object[]{this, path, preserve, bufferSize});
        }
        LinkOption[] options = IoUtils.getLinkOptions((boolean)true);
        Session session = this.getSession();
        if (preserve) {
            BasicFileAttributes basic = this.opener.getLocalBasicFileAttributes(session, path, options);
            FileTime lastModified = basic.lastModifiedTime();
            FileTime lastAccess = basic.lastAccessTime();
            ScpTimestampCommandDetails time = new ScpTimestampCommandDetails(lastModified, lastAccess);
            String cmd = time.toHeader();
            if (debugEnabled) {
                this.log.debug("sendDir({})[{}] send last-modified={}, last-access={} command: {}", new Object[]{this, path, lastModified, lastAccess, cmd});
            }
            ScpAckInfo ackInfo = this.sendAcknowledgedCommand(cmd);
            if (debugEnabled) {
                this.log.debug("sendDir({})[{}] command='{}' ACK={}", new Object[]{this, path, cmd, ackInfo});
            }
            this.validateAckReplyCode(cmd, path, ackInfo);
        }
        Set<PosixFilePermission> perms = this.opener.getLocalFilePermissions(session, path, options);
        String octalPerms = !preserve || GenericUtils.isEmpty(perms) ? "0755" : ScpPathCommandDetailsSupport.getOctalPermissions(perms);
        String cmd = 'D' + octalPerms + " 0 " + Objects.toString(path.getFileName(), null);
        if (debugEnabled) {
            this.log.debug("sendDir({})[{}] send 'D' command: {}", new Object[]{this, path, cmd});
        }
        ScpAckInfo ackInfo = this.sendAcknowledgedCommand(cmd);
        if (debugEnabled) {
            this.log.debug("sendDir({})[{}] command='{}' ACK={}", new Object[]{this, path, cmd, ackInfo});
        }
        this.validateAckReplyCode(cmd, path, ackInfo);
        try (DirectoryStream<Path> children = this.opener.getLocalFolderChildren(session, path);){
            this.listener.startFolderEvent(session, ScpTransferEventListener.FileOperation.SEND, path, perms);
            try {
                for (Path child : children) {
                    if (this.opener.sendAsRegularFile(session, child, options)) {
                        this.sendFile(child, preserve, bufferSize);
                        continue;
                    }
                    if (!this.opener.sendAsDirectory(session, child, options)) continue;
                    this.sendDir(child, preserve, bufferSize);
                }
            }
            catch (IOException | RuntimeException e) {
                this.listener.endFolderEvent(session, ScpTransferEventListener.FileOperation.SEND, path, perms, e);
                throw e;
            }
            this.listener.endFolderEvent(session, ScpTransferEventListener.FileOperation.SEND, path, perms, null);
        }
        if (debugEnabled) {
            this.log.debug("sendDir({})[{}] send 'E' command", (Object)this, (Object)path);
        }
        ackInfo = this.sendAcknowledgedCommand("E");
        if (debugEnabled) {
            this.log.debug("sendDir({})[{}] 'E' command ACK={}", new Object[]{this, path, ackInfo});
        }
        this.validateAckReplyCode(cmd, path, ackInfo);
    }

    protected ScpAckInfo sendAcknowledgedCommand(String cmd) throws IOException {
        return ScpIoUtils.sendAcknowledgedCommand(cmd, this.in, this.csIn, this.out, this.csOut);
    }

    public void sendOk() throws IOException {
        this.sendResponseMessage(0, null);
    }

    protected void sendWarning(String message) throws IOException {
        this.sendResponseMessage(1, message);
    }

    protected void sendError(String message) throws IOException {
        this.sendResponseMessage(2, message);
    }

    protected void sendResponseMessage(int level, String message) throws IOException {
        ScpAckInfo.sendAck(this.out, this.csOut, level, message);
    }

    public ScpAckInfo readAck(boolean canEof) throws IOException {
        return ScpAckInfo.readAck(this.in, this.csIn, canEof);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getSession() + "]";
    }
}

