/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.beaninfo.editors.ExtensionListCustomEditor;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.loaders.ExtensionList;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

public class ExtensionListEditor
implements PropertyEditor,
ExPropertyEditor {
    private ExtensionList value;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean editable = true;

    public void setValue(Object object) {
        this.value = object != null ? (ExtensionList)((ExtensionList)object).clone() : null;
        this.support.firePropertyChange(null, null, null);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getStringArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            if (NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values").equals(string)) {
                this.setValue(new String[]{string});
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",. \n\t");
                this.setAs(stringTokenizer);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.getMessage());
            String string2 = exception.getLocalizedMessage();
            if (string2 == null) {
                string2 = MessageFormat.format(NbBundle.getMessage(ExtensionListEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), string);
            }
            UIExceptions.annotateUser(illegalArgumentException, illegalArgumentException.getMessage(), string2, exception, new Date());
            throw illegalArgumentException;
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return new ExtensionListCustomEditor(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String[] getStringArray() {
        if (this.value == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.value.extensions();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        enumeration = this.value.mimeTypes();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setStringArray(String[] stringArray) {
        this.setAs(Enumerations.array((Object[])stringArray));
    }

    private void setAs(Enumeration enumeration) {
        ExtensionList extensionList = new ExtensionList();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(47) >= 0) {
                extensionList.addMimeType(string);
                continue;
            }
            extensionList.addExtension(string);
        }
        this.value = extensionList;
        this.support.firePropertyChange(null, null, null);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
        }
    }
}

