/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public class NbinstURLMapper
extends URLMapper {
    public static final String PROTOCOL = "nbinst";
    private static final Logger LOG = Logger.getLogger(NbinstURLMapper.class.getName());

    public FileObject[] getFileObjects(URL uRL) {
        File file;
        if (PROTOCOL.equals(uRL.getProtocol()) && (file = NbinstURLMapper.decodeURL(uRL)) != null) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                return new FileObject[]{fileObject};
            }
            LOG.log(Level.WARNING, "could find no FileObject for {0}", file);
        }
        return null;
    }

    public URL getURL(FileObject fileObject, int n) {
        return null;
    }

    static File decodeURL(URL uRL) {
        assert (uRL != null);
        try {
            URI uRI = new URI(uRL.toExternalForm());
            String string = uRI.getScheme();
            if (PROTOCOL.equals(string)) {
                String string2 = uRI.getAuthority();
                String string3 = uRI.getPath();
                if (string3.length() > 0) {
                    String string4 = string3.substring(1).replaceFirst("/$", "");
                    return InstalledFileLocator.getDefault().locate(string4, string2, false);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.log(Level.WARNING, null, uRISyntaxException);
        }
        return null;
    }
}

