/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.ui.FileObjectPropertySet;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.provider.SearchComposition;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class GraphicalSearchListener
extends SearchListener {
    private static final int INFO_EVENT_LIMIT = 100;
    private static final Logger LOG = Logger.getLogger(GraphicalSearchListener.class.getName());
    private static final int PATH_LENGTH_LIMIT = 153;
    private SearchComposition<?> searchComposition;
    private ProgressHandle progressHandle;
    private String longTextMiddle = null;
    private ResultViewPanel resultViewPanel;
    private RootInfoNode rootInfoNode;
    private EventChildren eventChildren;

    public GraphicalSearchListener(SearchComposition<?> searchComposition, ResultViewPanel resultViewPanel) {
        this.searchComposition = searchComposition;
        this.resultViewPanel = resultViewPanel;
        this.rootInfoNode = new RootInfoNode();
    }

    public void searchStarted() {
        this.progressHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"), () -> {
            this.searchComposition.terminate();
            return true;
        }, null);
        this.progressHandle.start();
        this.resultViewPanel.searchStarted();
        this.searchComposition.getSearchResultsDisplayer().searchStarted();
        Collection collection = Savable.REGISTRY.lookupAll(Savable.class);
        if (collection.size() > 0) {
            String string = NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_WARNING_UNSAVED");
            this.eventChildren.addEvent(new EventNode(EventType.WARNING, string));
        }
    }

    public void searchFinished() {
        if (this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressHandle = null;
        }
        this.resultViewPanel.searchFinished();
        this.searchComposition.getSearchResultsDisplayer().searchFinished();
    }

    @Override
    public void directoryEntered(String string) {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.shortenPath(string));
        }
    }

    @Override
    public void fileContentMatchingStarted(String string) {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.shortenPath(string));
        }
    }

    private String shortenPath(String string) {
        if (string.length() <= 153) {
            return string;
        }
        String string2 = this.getLongTextMiddle();
        int n = (153 - string2.length()) / 2;
        return string.substring(0, n) + string2 + string.substring(string.length() - n);
    }

    private String getLongTextMiddle() {
        if (this.longTextMiddle == null) {
            this.longTextMiddle = NbBundle.getMessage(SearchTask.class, (String)"TEXT_SEARCH_LONG_STRING_MIDDLE");
        }
        return this.longTextMiddle;
    }

    @Override
    public void generalError(Throwable throwable) {
        String string = NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_ERROR", (Object)throwable.getMessage());
        this.eventChildren.addEvent(new EventNode(EventType.ERROR, string));
        LOG.log(Level.INFO, throwable.getMessage(), throwable);
    }

    @Override
    public void fileContentMatchingError(String string, Throwable throwable) {
        String string2 = NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_ERROR_MATCHING", (Object)this.fileName(string), (Object)throwable.getMessage());
        String string3 = NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_ERROR_MATCHING", (Object)string, (Object)throwable.getMessage());
        this.eventChildren.addEvent(new PathEventNode(EventType.ERROR, string2, string, string3));
        String string4 = string + ": " + throwable.getMessage();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, string4, throwable);
        } else {
            LOG.log(Level.INFO, string4);
        }
    }

    private String fileName(String string) {
        Pattern pattern = Pattern.compile("(/|\\\\)([^/\\\\]+)(/|\\\\)?$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return string;
    }

    @Override
    public void fileSkipped(FileObject fileObject, SearchFilterDefinition searchFilterDefinition, String string) {
        this.fileSkipped(fileObject.toURI(), searchFilterDefinition, string);
    }

    @Override
    public void fileSkipped(URI uRI, SearchFilterDefinition searchFilterDefinition, String string) {
        LOG.log(Level.FINE, "{0} skipped {1} {2}", new Object[]{uRI.toString(), searchFilterDefinition != null ? searchFilterDefinition.getClass().getName() : "", string != null ? string : ""});
    }

    public Node getInfoNode() {
        return this.rootInfoNode;
    }

    private static String getIconForEventType(EventType eventType) {
        String string;
        String string2 = "org/netbeans/modules/search/res/";
        switch (eventType) {
            case INFO: {
                string = "info.png";
                break;
            }
            case WARNING: {
                string = "warning.gif";
                break;
            }
            case ERROR: {
                string = "error.gif";
                break;
            }
            default: {
                string = "info.png";
            }
        }
        return string2 + string;
    }

    private class EventNode
    extends AbstractNode {
        private Node.PropertySet[] propertySets;
        private EventType type;

        public EventNode(EventType eventType, String string) {
            super(Children.LEAF);
            this.type = eventType;
            this.setDisplayName(string);
            this.setIconBaseWithExtension(GraphicalSearchListener.getIconForEventType(eventType));
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.propertySets == null) {
                this.propertySets = this.createPropertySets();
            }
            return this.propertySets;
        }

        protected Node.PropertySet[] createPropertySets() {
            return new Node.PropertySet[0];
        }

        public EventType getType() {
            return this.type;
        }
    }

    private class PathEventNode
    extends EventNode {
        private String path;
        private String tooltip;

        public PathEventNode(EventType eventType, String string, String string2, String string3) {
            super(eventType, string);
            this.path = string2;
            this.tooltip = string3;
        }

        public String getShortDescription() {
            return this.tooltip;
        }

        @Override
        public Node.PropertySet[] createPropertySets() {
            Node.Property<String> property = new Node.Property<String>(String.class){

                public boolean canRead() {
                    return true;
                }

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return PathEventNode.this.path;
                }

                public boolean canWrite() {
                    return false;
                }

                public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    throw new UnsupportedOperationException();
                }

                public String getName() {
                    return "path";
                }
            };
            final Node.Property[] propertyArray = new Node.Property[]{property};
            Node.PropertySet[] propertySetArray = new Node.PropertySet[]{new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    return propertyArray;
                }
            }};
            return propertySetArray;
        }
    }

    private class FileObjectEventNode
    extends EventNode {
        private FileObject fileObject;

        public FileObjectEventNode(EventType eventType, String string, FileObject fileObject) {
            super(eventType, string);
            this.fileObject = fileObject;
        }

        @Override
        public Node.PropertySet[] createPropertySets() {
            Node.PropertySet[] propertySetArray = new Node.PropertySet[]{new FileObjectPropertySet(this.fileObject)};
            return propertySetArray;
        }
    }

    private class EventChildren
    extends Children.Keys<EventNode> {
        private List<EventNode> events = new ArrayList<EventNode>();
        EventType worstType = EventType.INFO;

        private EventChildren() {
        }

        public synchronized void addEvent(EventNode eventNode) {
            if (this.events.size() < 100) {
                this.events.add(eventNode);
                this.setKeys(this.events);
                if (eventNode.getType().worseThan(this.worstType)) {
                    this.worstType = eventNode.getType();
                }
                GraphicalSearchListener.this.rootInfoNode.setIconBaseWithExtension(GraphicalSearchListener.getIconForEventType(this.worstType));
            } else if (this.events.size() == 100) {
                this.events.add(new EventNode(EventType.INFO, UiUtils.getText("TEXT_INFO_LIMIT_REACHED")));
                this.setKeys(this.events);
            }
        }

        protected Node[] createNodes(EventNode eventNode) {
            return new Node[]{eventNode};
        }
    }

    private static enum EventType {
        INFO(1),
        WARNING(2),
        ERROR(3);

        private int badness;

        private EventType(int n2) {
            this.badness = n2;
        }

        public boolean worseThan(EventType eventType) {
            return this.badness > eventType.badness;
        }
    }

    private class RootInfoNode
    extends AbstractNode {
        public RootInfoNode() {
            this(graphicalSearchListener.new EventChildren());
        }

        private RootInfoNode(EventChildren eventChildren) {
            super((Children)eventChildren);
            GraphicalSearchListener.this.eventChildren = eventChildren;
            this.setDisplayName(UiUtils.getText("TEXT_INFO_TITLE"));
            this.setIcon(EventType.INFO);
        }

        public final void setIcon(EventType eventType) {
            this.setIconBaseWithExtension(GraphicalSearchListener.getIconForEventType(eventType));
        }

        public void fireUpdate() {
        }
    }
}

