/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.PrintStream;
import java.io.PrintWriter;

public class XMLException
extends Exception {
    private String msg;
    private String systemID;
    private int lineNr;
    private Exception encapsulatedException;

    public XMLException(String string) {
        this(null, -1, null, string, false);
    }

    public XMLException(Exception exception) {
        this(null, -1, exception, "Nested Exception", false);
    }

    public XMLException(String string, int n, Exception exception) {
        this(string, n, exception, "Nested Exception", true);
    }

    public XMLException(String string, int n, String string2) {
        this(string, n, null, string2, true);
    }

    public XMLException(String string, int n, Exception exception, String string2, boolean bl) {
        super(XMLException.buildMessage(string, n, exception, string2, bl));
        this.systemID = string;
        this.lineNr = n;
        this.encapsulatedException = exception;
        this.msg = XMLException.buildMessage(string, n, exception, string2, bl);
    }

    private static String buildMessage(String string, int n, Exception exception, String string2, boolean bl) {
        String string3 = string2;
        if (bl) {
            if (string != null) {
                string3 = string3 + ", SystemID='" + string + "'";
            }
            if (n >= 0) {
                string3 = string3 + ", Line=" + n;
            }
            if (exception != null) {
                string3 = string3 + ", Exception: " + exception;
            }
        }
        return string3;
    }

    protected void finalize() throws Throwable {
        this.systemID = null;
        this.encapsulatedException = null;
        super.finalize();
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Exception getException() {
        return this.encapsulatedException;
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.encapsulatedException != null) {
            printWriter.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(printWriter);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.encapsulatedException != null) {
            printStream.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(printStream);
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.encapsulatedException != null) {
            System.err.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace();
        }
    }

    public String toString() {
        return this.msg;
    }
}

