/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Collection;
import java.util.HashSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;

public class JRExpressionCollector {
    private Collection expressions = new HashSet();

    private void addExpression(JRExpression expression) {
        if (expression != null) {
            this.expressions.add(expression);
        }
    }

    public Collection collect(JRReport report) {
        this.collect(report.getParameters());
        this.collect(report.getVariables());
        this.collect(report.getGroups());
        this.collect(report.getBackground());
        this.collect(report.getTitle());
        this.collect(report.getPageHeader());
        this.collect(report.getColumnHeader());
        this.collect(report.getDetail());
        this.collect(report.getColumnFooter());
        this.collect(report.getPageFooter());
        this.collect(report.getLastPageFooter());
        this.collect(report.getSummary());
        return this.expressions;
    }

    private void collect(JRParameter[] parameters) {
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.addExpression(parameters[i].getDefaultValueExpression());
            }
        }
    }

    private void collect(JRVariable[] variables) {
        if (variables != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                JRVariable variable = variables[i];
                this.addExpression(variable.getExpression());
                this.addExpression(variable.getInitialValueExpression());
            }
        }
    }

    private void collect(JRGroup[] groups) {
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                JRGroup group = groups[i];
                this.addExpression(group.getExpression());
                this.collect(group.getGroupHeader());
                this.collect(group.getGroupFooter());
            }
        }
    }

    private void collect(JRBand band) {
        if (band != null) {
            this.addExpression(band.getPrintWhenExpression());
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].collectExpressions(this);
                }
            }
        }
    }

    private void collectElement(JRElement element) {
        this.addExpression(element.getPrintWhenExpression());
    }

    private void collectAnchor(JRAnchor anchor) {
        this.addExpression(anchor.getAnchorNameExpression());
    }

    private void collectHyperlink(JRHyperlink hyperlink) {
        this.addExpression(hyperlink.getHyperlinkReferenceExpression());
        this.addExpression(hyperlink.getHyperlinkAnchorExpression());
        this.addExpression(hyperlink.getHyperlinkPageExpression());
    }

    public void collect(JRLine line) {
        this.collectElement(line);
    }

    public void collect(JRRectangle rectangle) {
        this.collectElement(rectangle);
    }

    public void collect(JREllipse ellipse) {
        this.collectElement(ellipse);
    }

    public void collect(JRImage image) {
        this.collectElement(image);
        this.addExpression(image.getExpression());
        this.collectAnchor(image);
        this.collectHyperlink(image);
    }

    public void collect(JRStaticText staticText) {
        this.collectElement(staticText);
    }

    public void collect(JRTextField textField) {
        this.collectElement(textField);
        this.addExpression(textField.getExpression());
        this.collectAnchor(textField);
        this.collectHyperlink(textField);
    }

    public void collect(JRSubreport subreport) {
        this.collectElement(subreport);
        this.addExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int j = 0; j < parameters.length; ++j) {
                this.addExpression(parameters[j].getExpression());
            }
        }
        this.addExpression(subreport.getConnectionExpression());
        this.addExpression(subreport.getDataSourceExpression());
        this.addExpression(subreport.getExpression());
    }

    public void collect(JRChart chart) {
        this.collectElement(chart);
        this.collectAnchor(chart);
        this.collectHyperlink(chart);
        this.addExpression(chart.getTitleExpression());
        this.addExpression(chart.getSubtitleExpression());
        chart.getDataset().collectExpressions(this);
        chart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset pieDataset) {
        this.addExpression(pieDataset.getKeyExpression());
        this.addExpression(pieDataset.getValueExpression());
        this.addExpression(pieDataset.getLabelExpression());
    }

    public void collect(JRCategoryDataset categoryDataset) {
        JRCategorySeries[] categorySeries = categoryDataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int j = 0; j < categorySeries.length; ++j) {
                this.collect(categorySeries[j]);
            }
        }
    }

    public void collect(JRXyDataset xyDataset) {
        JRXySeries[] xySeries = xyDataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            for (int j = 0; j < xySeries.length; ++j) {
                this.collect(xySeries[j]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset timeSeriesDataset) {
        JRTimeSeries[] timeSeries = timeSeriesDataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            for (int i = 0; i < timeSeries.length; ++i) {
                this.collect(timeSeries[i]);
            }
        }
    }

    public void collect(JRTimePeriodDataset timePeriodDataset) {
        JRTimePeriodSeries[] timePeriodSeries = timePeriodDataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                this.collect(timePeriodSeries[i]);
            }
        }
    }

    private void collect(JRXySeries xySeries) {
        this.addExpression(xySeries.getSeriesExpression());
        this.addExpression(xySeries.getXValueExpression());
        this.addExpression(xySeries.getYValueExpression());
        this.addExpression(xySeries.getLabelExpression());
    }

    private void collect(JRCategorySeries categorySeries) {
        this.addExpression(categorySeries.getSeriesExpression());
        this.addExpression(categorySeries.getCategoryExpression());
        this.addExpression(categorySeries.getValueExpression());
        this.addExpression(categorySeries.getLabelExpression());
    }

    public void collect(JRBarPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
    }

    public void collect(JRBar3DPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
    }

    public void collect(JRLinePlot linePlot) {
        this.addExpression(linePlot.getCategoryAxisLabelExpression());
        this.addExpression(linePlot.getValueAxisLabelExpression());
    }

    public void collect(JRTimeSeriesPlot timeSeriesPlot) {
        this.addExpression(timeSeriesPlot.getTimeAxisLabelExpression());
        this.addExpression(timeSeriesPlot.getValueAxisLabelExpression());
    }

    public void collect(JRScatterPlot scatterPlot) {
        this.addExpression(scatterPlot.getXAxisLabelExpression());
        this.addExpression(scatterPlot.getYAxisLabelExpression());
    }

    public void collect(JRAreaPlot areaPlot) {
        this.addExpression(areaPlot.getCategoryAxisLabelExpression());
        this.addExpression(areaPlot.getValueAxisLabelExpression());
    }

    private void collect(JRTimeSeries timeSeries) {
        this.addExpression(timeSeries.getSeriesExpression());
        this.addExpression(timeSeries.getTimePeriodExpression());
        this.addExpression(timeSeries.getValueExpression());
        this.addExpression(timeSeries.getLabelExpression());
    }

    private void collect(JRTimePeriodSeries timePeriodSeries) {
        this.addExpression(timePeriodSeries.getSeriesExpression());
        this.addExpression(timePeriodSeries.getStartDateExpression());
        this.addExpression(timePeriodSeries.getEndDateExpression());
        this.addExpression(timePeriodSeries.getValueExpression());
        this.addExpression(timePeriodSeries.getLabelExpression());
    }

    public void collect(JRXyzDataset xyzDataset) {
        JRXyzSeries[] xyzSeries = xyzDataset.getSeries();
        if (xyzSeries != null && xyzSeries.length > 0) {
            for (int j = 0; j < xyzSeries.length; ++j) {
                this.collect(xyzSeries[j]);
            }
        }
    }

    private void collect(JRXyzSeries xyzSeries) {
        this.addExpression(xyzSeries.getSeriesExpression());
        this.addExpression(xyzSeries.getXValueExpression());
        this.addExpression(xyzSeries.getYValueExpression());
        this.addExpression(xyzSeries.getZValueExpression());
    }

    public void collect(JRBubblePlot bubblePlot) {
        this.addExpression(bubblePlot.getXAxisLabelExpression());
        this.addExpression(bubblePlot.getYAxisLabelExpression());
    }

    public void collect(JRHighLowPlot highLowPlot) {
        this.addExpression(highLowPlot.getTimeAxisLabelExpression());
        this.addExpression(highLowPlot.getValueAxisLabelExpression());
    }

    public void collect(JRHighLowDataset highLowDataset) {
        this.addExpression(highLowDataset.getSeriesExpression());
        this.addExpression(highLowDataset.getDateExpression());
        this.addExpression(highLowDataset.getHighExpression());
        this.addExpression(highLowDataset.getLowExpression());
        this.addExpression(highLowDataset.getOpenExpression());
        this.addExpression(highLowDataset.getCloseExpression());
        this.addExpression(highLowDataset.getVolumeExpression());
    }

    public void collect(JRCandlestickPlot candlestickPlot) {
        this.addExpression(candlestickPlot.getTimeAxisLabelExpression());
        this.addExpression(candlestickPlot.getValueAxisLabelExpression());
    }
}

