/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.plaf.metal.BumpBuffer;
import sun.awt.AppContext;

class MetalBumps
implements Icon {
    static final Color ALPHA = new Color(0, 0, 0, 0);
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    private static final Object METAL_BUMPS = new Object();
    protected BumpBuffer buffer;

    public MetalBumps(int n, int n2, Color color, Color color2, Color color3) {
        this.setBumpArea(n, n2);
        this.setBumpColors(color, color2, color3);
    }

    private static BumpBuffer createBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        AppContext appContext = AppContext.getAppContext();
        ArrayList<Object> arrayList = (ArrayList<Object>)appContext.get(METAL_BUMPS);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            appContext.put(METAL_BUMPS, arrayList);
        }
        for (BumpBuffer bumpBuffer : arrayList) {
            if (!bumpBuffer.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) continue;
            return bumpBuffer;
        }
        BumpBuffer bumpBuffer = new BumpBuffer(graphicsConfiguration, color, color2, color3);
        arrayList.add(bumpBuffer);
        return bumpBuffer;
    }

    public void setBumpArea(Dimension dimension) {
        this.setBumpArea(dimension.width, dimension.height);
    }

    public void setBumpArea(int n, int n2) {
        this.xBumps = n / 2;
        this.yBumps = n2 / 2;
    }

    public void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3 == null ? ALPHA : color3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfiguration graphicsConfiguration2 = graphicsConfiguration = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getDeviceConfiguration() : null;
        if (this.buffer == null || !this.buffer.hasSameConfiguration(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor)) {
            this.buffer = MetalBumps.createBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
        }
        int n3 = 64;
        int n4 = 64;
        int n5 = this.getIconWidth();
        int n6 = this.getIconHeight();
        int n7 = n + n5;
        int n8 = n2 + n6;
        int n9 = n;
        while (n2 < n8) {
            int n10 = Math.min(n8 - n2, n4);
            for (n = n9; n < n7; n += n3) {
                int n11 = Math.min(n7 - n, n3);
                graphics.drawImage(this.buffer.getImage(), n, n2, n + n11, n2 + n10, 0, 0, n11, n10, null);
            }
            n2 += n4;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

