/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public class JavaException
extends LispError {
    private final Throwable throwable;
    protected static final Primitive JAVA_EXCEPTION_CAUSE = new Primitive(Symbol.JAVA_EXCEPTION_CAUSE, "java-exception", "Returns the cause of JAVA-EXCEPTION. (The cause is the Java Throwable\n  object that caused JAVA-EXCEPTION to be signalled.)"){

        @Override
        public LispObject execute(LispObject arg) {
            return Symbol.STD_SLOT_VALUE.execute(arg, Symbol.CAUSE);
        }
    };

    public JavaException(Throwable throwable) {
        super(StandardClass.JAVA_EXCEPTION);
        Debug.assertTrue(this.slots.length == 3);
        Debug.assertTrue(throwable != null);
        this.throwable = throwable;
        this.setInstanceSlotValue(Symbol.CAUSE, new JavaObject(throwable));
        this.setFormatControl("Java exception: ~A.");
        this.setFormatArguments(new Cons(new JavaObject(throwable)));
    }

    @Override
    public LispObject typeOf() {
        return Symbol.JAVA_EXCEPTION;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.JAVA_EXCEPTION;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.JAVA_EXCEPTION) {
            return Lisp.T;
        }
        if (type == StandardClass.JAVA_EXCEPTION) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public String getMessage() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.throwable.printStackTrace(pw);
        String s = sw.toString();
        String separator = System.getProperty("line.separator");
        if (s.endsWith(separator)) {
            s = s.substring(0, s.length() - separator.length());
        }
        return s;
    }
}

