/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Appendable;
import org.jruby.RubyString;
import org.jruby.api.Create;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.builder.StringStyle;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.ChilledString;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class BuildCompoundStringInstr
extends NOperandResultBaseInstr {
    private final Encoding encoding;
    private final StringStyle stringStyle;
    private final String file;
    private final int line;
    private final int estimatedSize;

    public BuildCompoundStringInstr(Variable result2, Operand[] pieces, Encoding encoding2, int estimatedSize, StringStyle stringStyle, String file2, int line) {
        super(Operation.BUILD_COMPOUND_STRING, result2, pieces);
        this.encoding = encoding2;
        this.stringStyle = stringStyle;
        this.file = file2;
        this.line = line;
        this.estimatedSize = estimatedSize;
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public int getInitialSize() {
        return this.estimatedSize * 3 / 2;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildCompoundStringInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.encoding, this.estimatedSize, this.stringStyle, this.file, this.line);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
        e.encode(this.encoding);
        e.encode(this.estimatedSize);
        e.encode(this.stringStyle == StringStyle.Frozen);
        e.encode(this.stringStyle == StringStyle.Mutable);
        e.encode(this.file);
        e.encode(this.line);
    }

    public static BuildCompoundStringInstr decode(IRReaderDecoder d) {
        return new BuildCompoundStringInstr(d.decodeVariable(), d.decodeOperandArray(), d.decodeEncoding(), d.decodeInt(), BuildCompoundStringInstr.decodeStringStyle(d.decodeBoolean(), d.decodeBoolean()), d.decodeString(), d.decodeInt());
    }

    private static StringStyle decodeStringStyle(boolean frozen, boolean mutable) {
        if (frozen) {
            return StringStyle.Frozen;
        }
        if (mutable) {
            return StringStyle.Mutable;
        }
        return StringStyle.Chilled;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyString str = RubyString.newStringLight(context.runtime, this.getInitialSize(), this.encoding);
        for (Operand p2 : this.getOperands()) {
            if (p2 instanceof StringLiteral) {
                StringLiteral strLiteral = (StringLiteral)((Object)p2);
                ByteList byteList = strLiteral.getByteList();
                int cr = strLiteral.getCodeRange();
                str.cat(byteList, cr);
                continue;
            }
            IRubyObject pval = (IRubyObject)p2.retrieve(context, self2, currScope, currDynScope, temp);
            str.appendAsDynamicString(pval);
        }
        return switch (this.stringStyle) {
            case StringStyle.Frozen -> IRRuntimeHelpers.freezeLiteralString(str);
            case StringStyle.Chilled -> IRRuntimeHelpers.chillLiteralString(str);
            default -> str;
        };
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildCompoundStringInstr(this);
    }

    public boolean isFrozen() {
        return this.stringStyle == StringStyle.Frozen;
    }

    public boolean isChilled() {
        return this.stringStyle == StringStyle.Chilled;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public Instr simplifyInstr(IRManager manager) {
        int[] i2;
        ArrayList<Operand> pieces;
        Operand[] piecesArray = this.getOperands();
        if (piecesArray.length == 0) {
            ByteList newByteList = new ByteList(0);
            newByteList.setEncoding(this.encoding);
            Operand string2 = switch (this.stringStyle) {
                case StringStyle.Frozen -> new FrozenString(newByteList, 32, this.file, this.line);
                case StringStyle.Mutable -> new MutableString(newByteList, 32, this.file, this.line);
                default -> new ChilledString(newByteList, 32, this.file, this.line);
            };
            return new CopyInstr(this.getResult(), string2);
        }
        if (piecesArray.length == 1) {
            Instr instr;
            Operand string2 = piecesArray[0];
            if (string2 instanceof FrozenString) {
                FrozenString froz = (FrozenString)string2;
                instr = this.copy(froz);
            } else {
                instr = this;
            }
            return instr;
        }
        ThreadContext context = manager.getRuntime().getCurrentContext();
        FrozenString lastString = this.findNextFrozenString(context, piecesArray, pieces = new ArrayList<Operand>(piecesArray.length), i2 = new int[]{0});
        if (lastString == null) {
            return this;
        }
        i2[0] = i2[0] + 1;
        while (i2[0] < piecesArray.length) {
            block16: {
                Operand piece;
                block15: {
                    piece = piecesArray[i2[0]];
                    if (piece instanceof ImmutableLiteral) {
                        ImmutableLiteral imm = (ImmutableLiteral)piece;
                        try {
                            FrozenString newOperand = this.combine(context, lastString, imm);
                            if (newOperand == null) break block15;
                            lastString = newOperand;
                            break block16;
                        }
                        catch (Exception e) {
                            return this;
                        }
                    }
                }
                pieces.add(lastString);
                pieces.add(piece);
                i2[0] = i2[0] + 1;
                lastString = this.findNextFrozenString(context, piecesArray, pieces, i2);
                if (lastString == null) break;
            }
            i2[0] = i2[0] + 1;
        }
        if (lastString != null) {
            pieces.add(lastString);
        }
        if (pieces.size() != piecesArray.length) {
            return pieces.size() == 1 ? this.copy((FrozenString)pieces.get(0)) : new BuildCompoundStringInstr(this.result, (Operand[])pieces.toArray(Operand[]::new), this.encoding, this.estimatedSize, this.stringStyle, this.file, this.line);
        }
        return this;
    }

    private FrozenString findNextFrozenString(ThreadContext context, Operand[] piecesArray, List<Operand> pieces, int[] i2) {
        while (i2[0] < piecesArray.length) {
            Operand piece = piecesArray[i2[0]];
            if (piece instanceof ImmutableLiteral) {
                ImmutableLiteral imm = (ImmutableLiteral)piece;
                return this.asFrozenString(context, imm);
            }
            pieces.add(piece);
            i2[0] = i2[0] + 1;
        }
        return null;
    }

    private FrozenString combine(ThreadContext context, FrozenString lastString, ImmutableLiteral piece) {
        if (lastString == null) {
            return this.asFrozenString(context, piece);
        }
        IRubyObject obj = (IRubyObject)piece.retrieve(context, null, null, null, null);
        if (obj instanceof Appendable) {
            Appendable app = (Appendable)((Object)obj);
            RubyString last2 = Create.newString(context, lastString.getByteList().dup());
            app.appendIntoString(last2);
            ByteList newByteList = last2.getByteList();
            return this.asOperand(newByteList);
        }
        return null;
    }

    private Instr copy(FrozenString string2) {
        Operand value2 = switch (this.stringStyle) {
            case StringStyle.Frozen -> string2;
            case StringStyle.Mutable -> new MutableString(string2.bytelist, 32, this.file, this.line);
            default -> new ChilledString(string2.bytelist, 32, this.file, this.line);
        };
        return new CopyInstr(this.result, value2);
    }

    private FrozenString asFrozenString(ThreadContext context, ImmutableLiteral piece) {
        if (piece instanceof FrozenString) {
            FrozenString str = (FrozenString)piece;
            return str;
        }
        IRubyObject fix2 = (IRubyObject)piece.retrieve(context, null, null, null, null);
        return this.asOperand(fix2.asString().getByteList());
    }

    private FrozenString asOperand(ByteList bytelist) {
        return new FrozenString(bytelist, 0, this.file, this.line);
    }
}

