/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ClientAuthenticationType;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import de.rub.nds.tlsattacker.core.state.StatePlaintext;
import de.rub.nds.tlsattacker.core.state.serializer.SessionTicketSerializer;
import de.rub.nds.tlsattacker.core.state.serializer.StatePlaintextSerializer;
import de.rub.nds.tlsattacker.core.util.StaticTicketCrypto;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.util.TimeHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketPreparator
extends HandshakeMessagePreparator<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NewSessionTicketMessage msg;

    public NewSessionTicketPreparator(Chooser chooser, NewSessionTicketMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    private long generateTicketLifetimeHint() {
        long ticketLifeTimeHint = this.chooser.getConfig().getSessionTicketLifetimeHint();
        return ticketLifeTimeHint;
    }

    private void prepareTicketLifetimeHint(NewSessionTicketMessage msg) {
        msg.setTicketLifetimeHint(this.generateTicketLifetimeHint());
        LOGGER.debug("TicketLifetimeHint: " + msg.getTicketLifetimeHint().getValue());
    }

    private void prepareTicket(NewSessionTicketMessage msg) {
        byte[] hmac;
        byte[] encryptedState;
        Config cfg = this.chooser.getConfig();
        msg.prepareTicket();
        SessionTicket newticket = msg.getTicket();
        newticket.setKeyName(cfg.getSessionTicketKeyName());
        byte[] keyaes = cfg.getSessionTicketKeyAES();
        byte[] iv = new byte[16];
        RandomHelper.getRandom().nextBytes(iv);
        newticket.setIV(iv);
        StatePlaintext plainstate = this.generateStatePlaintext();
        StatePlaintextSerializer plaintextSerializer = new StatePlaintextSerializer(plainstate);
        byte[] plainstateSerialized = plaintextSerializer.serialize();
        try {
            encryptedState = StaticTicketCrypto.encrypt(CipherAlgorithm.AES_128_CBC, plainstateSerialized, keyaes, (byte[])newticket.getIV().getValue());
        }
        catch (CryptoException E) {
            LOGGER.warn("Could not encrypt SessionState. Using empty byte[]");
            LOGGER.debug((Object)E);
            encryptedState = new byte[]{};
        }
        newticket.setEncryptedState(encryptedState);
        byte[] keyhmac = cfg.getSessionTicketKeyHMAC();
        byte[] macinput = ArrayConverter.concatenate((byte[][])new byte[][]{cfg.getSessionTicketKeyName(), iv, ArrayConverter.intToBytes((int)encryptedState.length, (int)2), encryptedState});
        try {
            hmac = StaticTicketCrypto.generateHMAC(MacAlgorithm.HMAC_SHA256, macinput, keyhmac);
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could generate HMAC. Using empty byte[]");
            LOGGER.debug((Object)ex);
            hmac = new byte[]{};
        }
        newticket.setMAC(hmac);
        SessionTicketSerializer sessionTicketSerializer = new SessionTicketSerializer(newticket);
        byte[] sessionTicketSerialized = sessionTicketSerializer.serialize();
        msg.setTicketLength(sessionTicketSerialized.length);
        LOGGER.debug("Ticket: " + msg.getTicket().toString());
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing NewSessionTicketMessage");
        this.prepareTicketLifetimeHint(this.msg);
        if (this.chooser.getSelectedProtocolVersion().isTLS13()) {
            this.prepareTicketTls13(this.msg);
        } else {
            this.prepareTicket(this.msg);
        }
    }

    private StatePlaintext generateStatePlaintext() {
        StatePlaintext plainstate = new StatePlaintext();
        plainstate.setCipherSuite(this.chooser.getSelectedCipherSuite().getValue());
        plainstate.setCompressionMethod(this.chooser.getSelectedCompressionMethod().getValue());
        plainstate.setMasterSecret(this.chooser.getMasterSecret());
        plainstate.setProtocolVersion(this.chooser.getSelectedProtocolVersion().getValue());
        long timestamp = TimeHelper.getTime() / 1000L;
        plainstate.setTimestamp(timestamp);
        switch (this.chooser.getConfig().getClientAuthenticationType()) {
            case ANONYMOUS: {
                plainstate.setClientAuthenticationType(ClientAuthenticationType.ANONYMOUS.getValue());
                plainstate.setClientAuthenticationData(new byte[0]);
                plainstate.setClientAuthenticationDataLength(0);
                break;
            }
            case CERTIFICATE_BASED: {
                throw new UnsupportedOperationException("Certificate based ClientAuthentication is not supported");
            }
            case PSK: {
                throw new UnsupportedOperationException("PSK ClientAuthentication is not supported");
            }
            default: {
                throw new UnsupportedOperationException("Unknown ClientAuthenticationType");
            }
        }
        return plainstate;
    }

    private void prepareTicketTls13(NewSessionTicketMessage msg) {
        msg.prepareTicket();
        this.prepareTicketAgeAdd(msg);
        this.prepareNonce(msg);
        this.prepareIdentity(msg);
        this.prepareExtensions();
        this.prepareExtensionLength();
    }

    private void prepareTicketAgeAdd(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketAgeAdd(this.chooser.getConfig().getDefaultSessionTicketAgeAdd());
    }

    private void prepareIdentity(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentity(this.chooser.getConfig().getDefaultSessionTicketIdentity());
        msg.getTicket().setIdentityLength(((byte[])msg.getTicket().getIdentity().getValue()).length);
    }

    private void prepareNonce(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonce(this.chooser.getConfig().getDefaultSessionTicketNonce());
        msg.getTicket().setTicketNonceLength(((byte[])msg.getTicket().getTicketNonce().getValue()).length);
    }
}

