/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.FlatMap;
import javax.help.HelpBroker;
import javax.help.HelpSetException;
import javax.help.HelpSetFactory;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TryMap;
import javax.help.event.EventListenerList;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;

public class HelpSet {
    protected EventListenerList listenerList = new EventListenerList();
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN";
    public static final Object implRegistry = new StringBuffer("HelpSet.implRegistry");
    public static final String helpBrokerClass = "helpBroker/class";
    public static final String helpBrokerLoader = "helpBroker/loader";
    public static final Object kitTypeRegistry = new StringBuffer("JHelpViewer.kitTypeRegistry");
    public static final Object kitLoaderRegistry = new StringBuffer("JHelpViewer.kitLoaderRegistry");
    private String title;
    private Map map;
    private TryMap combinedMap;
    private URL helpset;
    private String homeID;
    private Locale locale = Locale.getDefault();
    private ClassLoader loader;
    private Vector views = new Vector();
    private Vector helpsets;
    private static HelpBroker defaultHelpBroker;
    private Vector subHelpSets = new Vector();
    private static Hashtable defaultKeys;
    private Hashtable localKeys = new Hashtable();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$HelpSet;
    static /* synthetic */ Class class$javax$help$event$HelpSetListener;

    static {
        HelpSet.setDefaultKeyData(implRegistry, helpBrokerClass, "javax.help.DefaultHelpBroker");
        HelpSet.setDefaultKeyData(kitTypeRegistry, "text/html", "com.sun.java.help.impl.CustomKit");
        ClassLoader classLoader = (class$javax$help$HelpSet != null ? class$javax$help$HelpSet : (class$javax$help$HelpSet = HelpSet.class$("javax.help.HelpSet"))).getClassLoader();
        if (classLoader != null) {
            HelpSet.setDefaultKeyData(implRegistry, helpBrokerLoader, classLoader);
            HelpSet.setDefaultKeyData(kitLoaderRegistry, "text/html", classLoader);
        }
        defaultHelpBroker = null;
    }

    public HelpSet() {
        this.helpsets = new Vector();
        this.loader = null;
    }

    public HelpSet(ClassLoader classLoader) {
        this.helpsets = new Vector();
        this.loader = classLoader;
    }

    public HelpSet(ClassLoader classLoader, URL uRL) throws HelpSetException {
        this(classLoader);
        this.helpset = uRL;
        DefaultHelpSetFactory defaultHelpSetFactory = new DefaultHelpSetFactory();
        this.parseInto(uRL, defaultHelpSetFactory);
        HelpSet helpSet = defaultHelpSetFactory.parsingEnded(this);
        if (helpSet == null) {
            throw new HelpSetException("Could not parse");
        }
    }

    public void add(HelpSet helpSet) {
        HelpSet.debug("add(" + helpSet + ")");
        this.helpsets.addElement(helpSet);
        this.fireHelpSetAdded(this, helpSet);
        this.combinedMap = null;
    }

    public void addHelpSetListener(HelpSetListener helpSetListener) {
        HelpSet.debug("addHelpSetListener(" + helpSetListener + ")");
        this.listenerList.add(class$javax$help$event$HelpSetListener != null ? class$javax$help$event$HelpSetListener : (class$javax$help$event$HelpSetListener = HelpSet.class$("javax.help.event.HelpSetListener")), helpSetListener);
    }

    protected void addSubHelpSet(HelpSet helpSet) {
        this.subHelpSets.addElement(helpSet);
    }

    protected void addView(NavigatorView navigatorView) {
        this.views.addElement(navigatorView);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean contains(HelpSet helpSet) {
        if (helpSet == this) {
            return true;
        }
        Enumeration enumeration = this.helpsets.elements();
        while (enumeration.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
            if (!helpSet2.contains(helpSet)) continue;
            return true;
        }
        return false;
    }

    public HelpBroker createHelpBroker() {
        HelpBroker helpBroker = null;
        String string = (String)this.getKeyData(implRegistry, helpBrokerClass);
        ClassLoader classLoader = (ClassLoader)this.getKeyData(implRegistry, helpBrokerLoader);
        if (classLoader == null) {
            classLoader = this.getLoader();
        }
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            helpBroker = (HelpBroker)clazz.newInstance();
        }
        catch (Throwable throwable) {
            helpBroker = null;
        }
        if (helpBroker != null) {
            helpBroker.setHelpSet(this);
        }
        return helpBroker;
    }

    private static void debug(String string) {
    }

    public static URL findHelpSet(ClassLoader classLoader, String string) {
        return HelpSet.findHelpSet(classLoader, string, Locale.getDefault());
    }

    public static URL findHelpSet(ClassLoader classLoader, String string, String string2, Locale locale) {
        return HelpUtilities.getLocalizedResource(classLoader, string, string2, locale, true);
    }

    public static URL findHelpSet(ClassLoader classLoader, String string, Locale locale) {
        String string2;
        String string3;
        if (string.endsWith(".hs")) {
            string3 = string.substring(0, string.length() - 3);
            string2 = ".hs";
        } else {
            string3 = string;
            string2 = ".hs";
        }
        return HelpSet.findHelpSet(classLoader, string3, string2, locale);
    }

    protected void fireHelpSetAdded(Object object, HelpSet helpSet) {
        Object[] objectArray = this.listenerList.getListenerList();
        HelpSetEvent helpSetEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$help$event$HelpSetListener != null ? class$javax$help$event$HelpSetListener : HelpSet.class$("javax.help.event.HelpSetListener"))) {
                if (helpSetEvent == null) {
                    helpSetEvent = new HelpSetEvent(this, helpSet, 0);
                }
                ((HelpSetListener)objectArray[n + 1]).helpSetAdded(helpSetEvent);
            }
            n -= 2;
        }
    }

    protected void fireHelpSetRemoved(Object object, HelpSet helpSet) {
        Object[] objectArray = this.listenerList.getListenerList();
        HelpSetEvent helpSetEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$help$event$HelpSetListener != null ? class$javax$help$event$HelpSetListener : HelpSet.class$("javax.help.event.HelpSetListener"))) {
                if (helpSetEvent == null) {
                    helpSetEvent = new HelpSetEvent(this, helpSet, 1);
                }
                ((HelpSetListener)objectArray[n + 1]).helpSetRemoved(helpSetEvent);
            }
            n -= 2;
        }
    }

    public Map getCombinedMap() {
        if (this.combinedMap == null) {
            this.combinedMap = new TryMap();
            this.combinedMap.add(this.map);
            Enumeration enumeration = this.helpsets.elements();
            while (enumeration.hasMoreElements()) {
                HelpSet helpSet = (HelpSet)enumeration.nextElement();
                this.combinedMap.add(helpSet.getLocalMap());
            }
        }
        return this.combinedMap;
    }

    public URL getHelpSetURL() {
        return this.helpset;
    }

    public Enumeration getHelpSets() {
        return this.helpsets.elements();
    }

    public Map.ID getHomeID() {
        if (this.homeID == null) {
            return null;
        }
        try {
            return Map.ID.create(this.homeID, this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getKeyData(Object object, String string) {
        Object var3_3 = null;
        Hashtable hashtable = (Hashtable)this.localKeys.get(object);
        if (hashtable != null) {
            var3_3 = hashtable.get(string);
        }
        if (var3_3 == null && (hashtable = (Hashtable)defaultKeys.get(object)) != null) {
            var3_3 = hashtable.get(string);
        }
        return var3_3;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Map getLocalMap() {
        return this.map;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public NavigatorView getNavigatorView(String string) {
        HelpSet.debug("getNavigatorView(" + string + ")");
        int n = 0;
        while (n < this.views.size()) {
            NavigatorView navigatorView = (NavigatorView)this.views.elementAt(n);
            if (navigatorView.getName().equals(string)) {
                HelpSet.debug("  = " + navigatorView);
                return navigatorView;
            }
            ++n;
        }
        HelpSet.debug("  = null");
        return null;
    }

    public NavigatorView[] getNavigatorViews() {
        Object[] objectArray = new NavigatorView[this.views.size()];
        this.views.copyInto(objectArray);
        return objectArray;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public static HelpSet parse(URL uRL, ClassLoader classLoader, HelpSetFactory helpSetFactory) {
        HelpSet helpSet = new HelpSet(classLoader);
        helpSet.helpset = uRL;
        helpSet.parseInto(uRL, helpSetFactory);
        return helpSetFactory.parsingEnded(helpSet);
    }

    public void parseInto(URL uRL, HelpSetFactory helpSetFactory) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            Reader reader = XmlReader.createReader(uRLConnection);
            helpSetFactory.parsingStarted(uRL);
            new HelpSetParser(helpSetFactory).parseInto(reader, this);
            reader.close();
        }
        catch (Exception exception) {
            helpSetFactory.reportMessage("Got an IOException (" + exception.getMessage() + ")", false);
            exception.printStackTrace();
        }
        int n = 0;
        while (n < this.subHelpSets.size()) {
            HelpSet helpSet = (HelpSet)this.subHelpSets.elementAt(n);
            this.add(helpSet);
            ++n;
        }
    }

    public boolean remove(HelpSet helpSet) {
        if (this.helpsets.removeElement(helpSet)) {
            this.fireHelpSetRemoved(this, helpSet);
            this.combinedMap = null;
            return true;
        }
        return false;
    }

    public void removeHelpSetListener(HelpSetListener helpSetListener) {
        this.listenerList.remove(class$javax$help$event$HelpSetListener != null ? class$javax$help$event$HelpSetListener : (class$javax$help$event$HelpSetListener = HelpSet.class$("javax.help.event.HelpSetListener")), helpSetListener);
    }

    private static void setDefaultKeyData(Object object, String string, Object object2) {
        Hashtable<String, Object> hashtable;
        if (defaultKeys == null) {
            defaultKeys = new Hashtable();
        }
        if ((hashtable = (Hashtable<String, Object>)defaultKeys.get(object)) == null) {
            hashtable = new Hashtable<String, Object>();
            defaultKeys.put(object, hashtable);
        }
        hashtable.put(string, object2);
    }

    public void setHomeID(String string) {
        String string2 = string;
        this.homeID = string;
        this.changes.firePropertyChange("homeID", string2, string);
    }

    public void setKeyData(Object object, String string, Object object2) {
        Hashtable<String, Object> hashtable = (Hashtable<String, Object>)this.localKeys.get(object);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
            this.localKeys.put(object, hashtable);
        }
        hashtable.put(string, object2);
    }

    public void setLocalMap(Map map) {
        this.map = map;
    }

    private void setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        this.changes.firePropertyChange("locale", locale2, this.locale);
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.changes.firePropertyChange("title", string2, string);
    }

    public String toString() {
        return this.getTitle();
    }

    public static class DefaultHelpSetFactory
    implements HelpSetFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        public HelpSet parsingEnded(HelpSet helpSet) {
            HelpSet helpSet2 = helpSet;
            if (!this.validParse) {
                helpSet2 = null;
                System.err.println("Parsing failed for " + this.source);
                Enumeration enumeration = this.messages.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    System.err.println(string);
                }
            }
            return helpSet2;
        }

        private void parsingError(String string) {
            String string2 = HelpUtilities.getText(string);
            this.reportMessage(string2, false);
        }

        private void parsingError(String string, String string2) {
            String string3 = HelpUtilities.getText(string, string2);
            this.reportMessage(string3, false);
        }

        private void parsingError(String string, String string2, String string3) {
            String string4 = HelpUtilities.getText(string, string2, string3);
            this.reportMessage(string4, false);
        }

        public void parsingStarted(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("source");
            }
            this.source = uRL;
        }

        private void parsingWarning(String string, String string2, String string3) {
            String string4 = HelpUtilities.getText(string, string2, string3);
            this.reportMessage(string4, true);
        }

        public void processDOCTYPE(String string, String string2, String string3) {
            if (string2 == null || !string2.equals(HelpSet.publicIDString)) {
                this.parsingError("helpset.wrongPublicID", string2);
            }
        }

        public void processHomeID(HelpSet helpSet, String string) {
            Map.ID iD = helpSet.getHomeID();
            if (iD != null && !iD.equals("")) {
                this.parsingError("helpset.wrongHomeID", string, iD.id);
            }
            helpSet.setHomeID(string);
        }

        public void processMapRef(HelpSet helpSet, Hashtable hashtable) {
            String string = (String)hashtable.get("location");
            URL uRL = helpSet.getHelpSetURL();
            try {
                FlatMap flatMap = new FlatMap(new URL(uRL, string), helpSet);
                Map map = helpSet.getLocalMap();
                if (map == null) {
                    helpSet.setLocalMap(flatMap);
                } else {
                    this.parsingError("helpset.oneMapOnly");
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.parsingError("helpset.malformedURL", string);
            }
            catch (IOException iOException) {
                this.parsingError("helpset.incorrectURL", string);
            }
            catch (Exception exception) {}
        }

        public void processPI(HelpSet helpSet, String string, String string2) {
        }

        public void processSubHelpSet(HelpSet helpSet, Hashtable hashtable) {
            HelpSet.debug("createSubHelpSet");
            String string = (String)hashtable.get("location");
            URL uRL = helpSet.getHelpSetURL();
            HelpSet.debug("  location: " + string);
            HelpSet.debug("  base helpset: " + uRL);
            URL uRL2 = null;
            HelpSet helpSet2 = null;
            try {
                uRL2 = new URL(uRL, string);
                InputStream inputStream = uRL2.openStream();
                if (inputStream != null && (helpSet2 = new HelpSet(helpSet.getLoader(), uRL2)) != null) {
                    helpSet.addSubHelpSet(helpSet2);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (HelpSetException helpSetException) {
                this.parsingError("helpset.subHelpSetTrouble", string);
            }
        }

        public void processTitle(HelpSet helpSet, String string) {
            String string2 = helpSet.getTitle();
            if (string2 != null && !string2.equals("")) {
                this.parsingWarning("helpset.wrongTitle", string, string2);
            }
            helpSet.setTitle(string);
        }

        public void processView(HelpSet helpSet, String string, String string2, String string3, Hashtable hashtable, String string4, Hashtable hashtable2, Locale locale) {
            try {
                NavigatorView navigatorView;
                if (string4 != null) {
                    if (hashtable2 == null) {
                        hashtable2 = new Hashtable<String, String>();
                    }
                    hashtable2.put("data", string4);
                }
                if ((navigatorView = NavigatorView.create(helpSet, string, string2, locale, string3, hashtable2)) != null) {
                    helpSet.addView(navigatorView);
                }
            }
            catch (Exception exception) {}
        }

        public void reportMessage(String string, boolean bl) {
            this.messages.addElement(string);
            this.validParse = this.validParse && bl;
        }
    }

    private static class HelpSetParser
    implements ParserListener {
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private HelpSet myHS;
        private Locale myHSLocale;
        private HelpSetFactory factory;
        private String viewName;
        private String viewLabel;
        private String viewType;
        private String viewEngine;
        private String viewData;
        private Hashtable htData;

        HelpSetParser(HelpSetFactory helpSetFactory) {
            this.factory = helpSetFactory;
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement langElement = new LangElement(tag, locale);
            this.tagStack.push(langElement);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        private void checkNull(String string, String string2) {
            if (!string2.equals("")) {
                this.parsingError("helpset.wrongText", string, string2);
            }
        }

        public void commentFound(ParserEvent parserEvent) {
        }

        public void doctypeFound(ParserEvent parserEvent) {
            this.factory.processDOCTYPE(parserEvent.getRoot(), parserEvent.getPublicId(), parserEvent.getSystemId());
        }

        public void errorFound(ParserEvent parserEvent) {
        }

        synchronized void parseInto(Reader reader, HelpSet helpSet) throws IOException {
            this.tagStack = new Stack();
            this.lastLocale = this.defaultLocale = helpSet.getLocale();
            this.myHS = helpSet;
            this.myHSLocale = helpSet.getLocale();
            Parser parser = new Parser(reader);
            parser.addParserListener(this);
            parser.parse();
        }

        private void parsingError(String string) {
            String string2 = HelpUtilities.getText(string);
            this.factory.reportMessage(string2, false);
        }

        private void parsingError(String string, String string2) {
            String string3 = HelpUtilities.getText(string, string2);
            this.factory.reportMessage(string3, false);
        }

        private void parsingError(String string, String string2, String string3) {
            String string4 = HelpUtilities.getText(string, string2, string3);
            this.factory.reportMessage(string4, false);
        }

        public void piFound(ParserEvent parserEvent) {
            this.factory.processPI(this.myHS, parserEvent.getTarget(), parserEvent.getData());
        }

        protected void removeTag(Tag tag) {
            LangElement langElement;
            String string = tag.name;
            Locale locale = null;
            do {
                if (this.tagStack.empty()) {
                    this.unbalanced(string);
                }
                langElement = (LangElement)this.tagStack.pop();
            } while (!langElement.getTag().name.equals(string));
            if (this.tagStack.empty()) {
                locale = this.defaultLocale;
            } else {
                langElement = (LangElement)this.tagStack.peek();
                locale = langElement.getLocale();
            }
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        public void tagFound(ParserEvent parserEvent) {
            String string;
            Hashtable hashtable;
            Locale locale = null;
            Tag tag = parserEvent.getTag();
            String string2 = tag.name;
            TagProperties tagProperties = tag.atts;
            Hashtable hashtable2 = hashtable = tagProperties == null ? null : tagProperties.getHashtable();
            if (tagProperties != null) {
                string = tagProperties.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(string);
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (string2.equals("helpset")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale) && locale != null) {
                        this.myHS.setLocale(locale);
                        this.defaultLocale = locale;
                    }
                    if (tagProperties != null && (string = tagProperties.getProperty("version")) != null && string.compareTo("1.0") != 0) {
                        this.parsingError("helpset.unknownVersion", string);
                    }
                    this.addTag(tag, locale);
                }
                return;
            }
            if (this.tagStack.empty()) {
                this.parsingError("helpset.wrongTopLevel", string2);
            }
            LangElement langElement = (LangElement)this.tagStack.peek();
            string = langElement.getTag().name;
            if (string2.equals("title")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("helpset")) {
                        this.wrongParent(string2, string);
                    }
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("homeID")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("maps")) {
                        this.wrongParent(string2, string);
                    }
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("mapref")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("maps")) {
                        this.wrongParent(string2, string);
                    }
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processMapRef(this.myHS, hashtable);
                }
            } else if (string2.equals("data")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!string.equals("view")) {
                        this.wrongParent(string2, string);
                    } else {
                        this.addTag(tag, locale);
                    }
                    this.htData = hashtable;
                }
            } else if (string2.equals("name") || string2.equals("type")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!string.equals("view")) {
                    this.wrongParent(string2, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("label")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!string.equals("view")) {
                    this.wrongParent(string2, string);
                } else {
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("view")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    this.factory.processView(this.myHS, this.viewName, this.viewLabel, this.viewType, hashtable, this.viewData, this.htData, locale);
                } else if (!string.equals("helpset")) {
                    this.wrongParent(string2, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("maps")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!string.equals("helpset")) {
                    this.wrongParent(string2, string);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (string2.equals("subhelpset")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processSubHelpSet(this.myHS, hashtable);
                }
            }
        }

        public void textFound(ParserEvent parserEvent) {
            HelpSet.debug("textFound: ");
            HelpSet.debug("  text: " + parserEvent.getText());
            if (this.tagStack.empty()) {
                return;
            }
            LangElement langElement = (LangElement)this.tagStack.peek();
            Tag tag = langElement.getTag();
            TagProperties tagProperties = tag.atts;
            Hashtable hashtable = tagProperties == null ? null : tagProperties.getHashtable();
            String string = parserEvent.getText().trim();
            String string2 = tag.name;
            if (string2.equals("helpset")) {
                this.checkNull("helpset", string);
                return;
            }
            int n = this.tagStack.size();
            String string3 = "";
            if (n >= 2) {
                langElement = (LangElement)this.tagStack.elementAt(n - 2);
                string3 = langElement.getTag().name;
            }
            if (string2.equals("title")) {
                this.factory.processTitle(this.myHS, string);
            } else if (string2.equals("homeID")) {
                this.factory.processHomeID(this.myHS, string);
            } else if (string2.equals("mapref")) {
                this.checkNull("mapref", string);
            } else if (string2.equals("subhelpset")) {
                this.checkNull("subhelpset", string);
            } else if (string2.equals("data")) {
                this.viewData = string.trim();
            } else if (string2.equals("label")) {
                this.viewLabel = string.trim();
            } else if (string2.equals("name")) {
                this.viewName = string.trim();
            } else if (string2.equals("type")) {
                this.viewType = string.trim();
            } else if (string2.equals("view")) {
                this.checkNull("view", string);
            } else if (string2.equals("maps")) {
                this.checkNull("maps", string);
            }
        }

        private void unbalanced(String string) {
            this.parsingError("helpset.unbalanced", string);
        }

        private void wrongLocale(Locale locale, Locale locale2, Locale locale3) {
            String string = HelpUtilities.getText("helpset.wrongLocale", locale.toString(), locale2.toString(), locale3.toString());
            this.factory.reportMessage(string, true);
        }

        private void wrongParent(String string, String string2) {
            this.parsingError("helpset.wrongParent", string, string2);
        }
    }
}

