/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaDatabaseReader;
import net.sf.mpxj.asta.AstaFileReader;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.fasttrack.FastTrackReader;
import net.sf.mpxj.ganttproject.GanttProjectReader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.merlin.MerlinReader;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.phoenix.PhoenixInputStream;
import net.sf.mpxj.phoenix.PhoenixReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.primavera.p3.P3DatabaseReader;
import net.sf.mpxj.primavera.p3.P3PRXFileReader;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.primavera.suretrak.SureTrakSTXFileReader;
import net.sf.mpxj.projectlibre.ProjectLibreReader;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.turboproject.TurboProjectReader;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class UniversalProjectReader
implements ProjectReader {
    private int m_skipBytes;
    private Charset m_charset;
    private List<ProjectListener> m_projectListeners;
    private static final int BUFFER_SIZE = 512;
    private static final byte[] OLE_COMPOUND_DOC_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] XER_FINGERPRINT = new byte[]{69, 82, 77, 72, 68, 82};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final byte[] PHOENIX_FINGERPRINT = new byte[]{80, 80, 88, 33, 33, 33, 33};
    private static final byte[] BINARY_PLIST = new byte[]{98, 112, 108, 105, 115, 116};
    private static final byte[] FASTTRACK_FINGERPRINT = new byte[]{28, 0, 0, 0, -117, 0, 0, 0};
    private static final byte[] PROJECTLIBRE_FINGERPRINT = new byte[]{-84, -19, 0, 5};
    private static final byte[] BTRIEVE_FINGERPRINT = new byte[]{70, 67, 0, 0};
    private static final byte[] STW_FINGERPRINT = new byte[]{83, 84, 87};
    private static final byte[] DOS_EXE_FINGERPRINT = new byte[]{77, 90};
    private static final byte[] WINDOWS_NE_EXE_FINGERPRINT = new byte[]{78, 69};
    private static final byte[] STX_FINGERPRINT = new byte[]{85, -117};
    private static final byte[] UTF8_BOM_FINGERPRINT = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BOM_FINGERPRINT = new byte[]{-2, -1};
    private static final byte[] UTF16LE_BOM_FINGERPRINT = new byte[]{-1, -2};
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*<APIBusinessObjects.*", 32);
    private static final Pattern MSPDI_FINGERPRINT = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*update_mode=\"(true|false)\".*>.*", 32);
    private static final Pattern GANTTPROJECT_FINGERPRINT = Pattern.compile(".*<project.*webLink.*", 32);
    private static final Pattern TURBOPROJECT_FINGERPRINT = Pattern.compile(".*dWBSTAB.*", 32);
    private static final Pattern PRX_FINGERPRINT = Pattern.compile("!Self-Extracting Primavera Project", 32);
    private static final Pattern PRX3_FINGERPRINT = Pattern.compile("PRX3", 32);

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    void setSkipBytes(int n) {
        this.m_skipBytes = n;
    }

    void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjectFile read(File file) throws MPXJException {
        ProjectFile projectFile;
        if (file.isDirectory()) {
            return this.handleDirectory(file);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ProjectFile projectFile2 = this.read(fileInputStream);
            fileInputStream.close();
            projectFile = projectFile2;
        }
        catch (Throwable throwable) {
            try {
                StreamHelper.closeQuietly(fileInputStream);
                throw throwable;
            }
            catch (Exception exception) {
                throw new MPXJException("Invalid file format", exception);
            }
        }
        StreamHelper.closeQuietly(fileInputStream);
        return projectFile;
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.skip(this.m_skipBytes);
            bufferedInputStream.mark(512);
            byte[] byArray = new byte[512];
            int n = bufferedInputStream.read(byArray);
            bufferedInputStream.reset();
            if (n != 512) {
                return null;
            }
            if (this.matchesFingerprint(byArray, UTF8_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bufferedInputStream, UTF8_BOM_FINGERPRINT.length, CharsetHelper.UTF8);
            }
            if (this.matchesFingerprint(byArray, UTF16_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bufferedInputStream, UTF16_BOM_FINGERPRINT.length, CharsetHelper.UTF16);
            }
            if (this.matchesFingerprint(byArray, UTF16LE_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bufferedInputStream, UTF16LE_BOM_FINGERPRINT.length, CharsetHelper.UTF16LE);
            }
            if (this.matchesFingerprint(byArray, BINARY_PLIST)) {
                return this.handleBinaryPropertyList(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, OLE_COMPOUND_DOC_FINGERPRINT)) {
                return this.handleOleCompoundDocument(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MSPDI_FINGERPRINT)) {
                MSPDIReader mSPDIReader = new MSPDIReader();
                mSPDIReader.setCharset(this.m_charset);
                return mSPDIReader.read(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new AstaFileReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MPX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPXReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, XER_FINGERPRINT)) {
                PrimaveraXERFileReader primaveraXERFileReader = new PrimaveraXERFileReader();
                primaveraXERFileReader.setCharset(this.m_charset);
                return this.readProjectFile((ProjectReader)primaveraXERFileReader, bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PLANNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PlannerReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PMXML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraPMFileReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PHOENIX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), new PhoenixInputStream(bufferedInputStream));
            }
            if (this.matchesFingerprint(byArray, PHOENIX_XML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, FASTTRACK_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new FastTrackReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, PROJECTLIBRE_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ProjectLibreReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, GANTTPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttProjectReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, TURBOPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new TurboProjectReader(), bufferedInputStream);
            }
            if (this.matchesFingerprint(byArray, DOS_EXE_FINGERPRINT)) {
                return this.handleDosExeFile(bufferedInputStream);
            }
            return null;
        }
        catch (Exception exception) {
            throw new MPXJException("Invalid file format", exception);
        }
    }

    private boolean matchesFingerprint(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray2, Arrays.copyOf(byArray, byArray2.length));
    }

    private boolean matchesFingerprint(byte[] byArray, Pattern pattern) {
        return pattern.matcher(this.m_charset == null ? new String(byArray) : new String(byArray, this.m_charset)).matches();
    }

    private ProjectFile readProjectFile(ProjectReader projectReader, InputStream inputStream) throws MPXJException {
        this.addListeners(projectReader);
        return projectReader.read(inputStream);
    }

    private ProjectFile readProjectFile(ProjectReader projectReader, File file) throws MPXJException {
        this.addListeners(projectReader);
        return projectReader.read(file);
    }

    private ProjectFile handleOleCompoundDocument(InputStream inputStream) throws Exception {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(POIFSFileSystem.createNonClosingInputStream(inputStream));
        String string = MPPReader.getFileFormat(pOIFSFileSystem);
        if (string.startsWith("MSProject")) {
            MPPReader mPPReader = new MPPReader();
            this.addListeners(mPPReader);
            return mPPReader.read(pOIFSFileSystem);
        }
        return null;
    }

    private ProjectFile handleBinaryPropertyList(InputStream inputStream) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleMDBFile(InputStream inputStream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(inputStream, ".mdb");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String string = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + file.getCanonicalPath();
            Set<String> set = this.populateTableNames(string);
            if (set.contains("MSP_PROJECTS")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MPDDatabaseReader(), file);
                return projectFile;
            }
            if (set.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleSQLiteFile(InputStream inputStream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(inputStream, ".sqlite");
        try {
            Class.forName("org.sqlite.JDBC");
            String string = "jdbc:sqlite:" + file.getCanonicalPath();
            Set<String> set = this.populateTableNames(string);
            if (set.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseFileReader(), file);
                return projectFile;
            }
            if (set.contains("PROJWBS")) {
                try (Connection connection = null;){
                    Properties properties = new Properties();
                    properties.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
                    connection = DriverManager.getConnection(string, properties);
                    PrimaveraDatabaseReader primaveraDatabaseReader = new PrimaveraDatabaseReader();
                    primaveraDatabaseReader.setConnection(connection);
                    this.addListeners(primaveraDatabaseReader);
                    ProjectFile projectFile = primaveraDatabaseReader.read();
                    return projectFile;
                }
            }
            if (set.contains("ZSCHEDULEITEM")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MerlinReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleZipFile(InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = InputStreamHelper.writeZipStreamToTempDir(inputStream);
            ProjectFile projectFile = this.handleDirectory(file);
            if (projectFile != null) {
                ProjectFile projectFile2 = projectFile;
                return projectFile2;
            }
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
        return null;
    }

    private ProjectFile handleDirectory(File file) throws Exception {
        ProjectFile projectFile = this.handleDatabaseInDirectory(file);
        if (projectFile == null) {
            projectFile = this.handleFileInDirectory(file);
        }
        return projectFile;
    }

    private ProjectFile handleDatabaseInDirectory(File file) throws Exception {
        byte[] byArray = new byte[512];
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) continue;
                FileInputStream fileInputStream = new FileInputStream(file2);
                int n = fileInputStream.read(byArray);
                fileInputStream.close();
                if (n != 512) continue;
                if (this.matchesFingerprint(byArray, BTRIEVE_FINGERPRINT)) {
                    return this.handleP3BtrieveDatabase(file);
                }
                if (!this.matchesFingerprint(byArray, STW_FINGERPRINT)) continue;
                return this.handleSureTrakDatabase(file);
            }
        }
        return null;
    }

    private ProjectFile handleFileInDirectory(File file) throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    arrayList.add(file2);
                    continue;
                }
                UniversalProjectReader universalProjectReader = new UniversalProjectReader();
                ProjectFile projectFile = universalProjectReader.read(file2);
                if (projectFile == null) continue;
                return projectFile;
            }
            for (File file3 : arrayList) {
                ProjectFile projectFile = this.handleDirectory(file3);
                if (projectFile == null) continue;
                return projectFile;
            }
        }
        return null;
    }

    private ProjectFile handleP3BtrieveDatabase(File file) throws Exception {
        return P3DatabaseReader.setProjectNameAndRead(file);
    }

    private ProjectFile handleSureTrakDatabase(File file) throws Exception {
        return SureTrakDatabaseReader.setProjectNameAndRead(file);
    }

    private ProjectFile handleByteOrderMark(InputStream inputStream, int n, Charset charset) throws Exception {
        UniversalProjectReader universalProjectReader = new UniversalProjectReader();
        universalProjectReader.setSkipBytes(n);
        universalProjectReader.setCharset(charset);
        return universalProjectReader.read(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleDosExeFile(InputStream inputStream) throws Exception {
        byte[] byArray;
        FileInputStream fileInputStream;
        File file;
        block4: {
            block5: {
                ProjectFile projectFile;
                file = InputStreamHelper.writeStreamToTempFile(inputStream, ".tmp");
                fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    if (((InputStream)fileInputStream).available() <= 1350) break block4;
                    StreamHelper.skip(fileInputStream, 1024L);
                    byArray = new byte[2];
                    ((InputStream)fileInputStream).read(byArray);
                    if (!this.matchesFingerprint(byArray, WINDOWS_NE_EXE_FINGERPRINT)) break block5;
                    StreamHelper.skip(fileInputStream, 286L);
                    byArray = new byte[34];
                    ((InputStream)fileInputStream).read(byArray);
                    if (!this.matchesFingerprint(byArray, PRX_FINGERPRINT)) break block5;
                    ((InputStream)fileInputStream).close();
                    fileInputStream = null;
                    projectFile = this.readProjectFile((ProjectReader)new P3PRXFileReader(), file);
                }
                catch (Throwable throwable) {
                    StreamHelper.closeQuietly(fileInputStream);
                    FileHelper.deleteQuietly(file);
                    throw throwable;
                }
                StreamHelper.closeQuietly(fileInputStream);
                FileHelper.deleteQuietly(file);
                return projectFile;
            }
            if (!this.matchesFingerprint(byArray, STX_FINGERPRINT)) break block4;
            StreamHelper.skip(fileInputStream, 31742L);
            byArray = new byte[4];
            ((InputStream)fileInputStream).read(byArray);
            if (!this.matchesFingerprint(byArray, PRX3_FINGERPRINT)) break block4;
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            ProjectFile projectFile = this.readProjectFile((ProjectReader)new SureTrakSTXFileReader(), file);
            StreamHelper.closeQuietly(fileInputStream);
            FileHelper.deleteQuietly(file);
            return projectFile;
        }
        byArray = null;
        StreamHelper.closeQuietly(fileInputStream);
        FileHelper.deleteQuietly(file);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> populateTableNames(String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection(string);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("TABLE_NAME").toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return hashSet;
    }

    private void addListeners(ProjectReader projectReader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectReader.addProjectListener(projectListener);
            }
        }
    }
}

