from typing import Dict, Union

from ..enums.ClassIDType import ClassIDType as CIT
from . import (
    AimConstraint,
    AnchoredJoint2D,
    Animation,
    AnimationClip,
    Animator,
    AnimatorController,
    AnimatorOverrideController,
    AnimatorState,
    AnimatorStateMachine,
    AnimatorStateTransition,
    AnimatorTransition,
    AnimatorTransitionBase,
    AnnotationManager,
    AreaEffector2D,
    ArticulationBody,
    AssemblyDefinitionAsset,
    AssemblyDefinitionImporter,
    AssemblyDefinitionReferenceAsset,
    AssemblyDefinitionReferenceImporter,
    AssetBundle,
    AssetBundleManifest,
    AssetDatabaseV1,
    AssetImporter,
    AssetImporterLog,
    AssetImportInProgressProxy,
    AssetMetaData,
    AssetServerCache,
    ASTCImporter,
    AudioBehaviour,
    AudioBuildInfo,
    AudioChorusFilter,
    AudioClip,
    AudioDistortionFilter,
    AudioEchoFilter,
    AudioFilter,
    AudioHighPassFilter,
    AudioImporter,
    AudioListener,
    AudioLowPassFilter,
    AudioManager,
    AudioMixer,
    AudioMixerController,
    AudioMixerEffectController,
    AudioMixerGroup,
    AudioMixerGroupController,
    AudioMixerLiveUpdateBool,
    AudioMixerLiveUpdateFloat,
    AudioMixerSnapshot,
    AudioMixerSnapshotController,
    AudioReverbFilter,
    AudioReverbZone,
    AudioSource,
    Avatar,
    AvatarMask,
    BaseAnimationTrack,
    BaseVideoTexture,
    Behaviour,
    BillboardAsset,
    BillboardRenderer,
    BlendTree,
    BoxCollider,
    BoxCollider2D,
    BuildReport,
    BuildSettings,
    BuiltAssetBundleInfoSet,
    BuoyancyEffector2D,
    CachedSpriteAtlas,
    CachedSpriteAtlasRuntimeData,
    Camera,
    Canvas,
    CanvasGroup,
    CanvasRenderer,
    CapsuleCollider,
    CapsuleCollider2D,
    CGProgram,
    CharacterController,
    CharacterJoint,
    CircleCollider2D,
    Cloth,
    ClothRenderer,
    CloudWebServicesManager,
    ClusterInputManager,
    Collider,
    Collider2D,
    Collision,
    Collision2D,
    Component,
    CompositeCollider2D,
    ComputeShader,
    ComputeShaderImporter,
    ConfigurableJoint,
    ConstantForce,
    ConstantForce2D,
    CrashReportManager,
    Cubemap,
    CubemapArray,
    CustomRenderTexture,
    DDSImporter,
    DefaultAsset,
    DefaultImporter,
    DelayedCallManager,
    Derived,
    DistanceJoint2D,
    EdgeCollider2D,
    EditorBuildSettings,
    EditorExtension,
    EditorExtensionImpl,
    EditorProjectAccess,
    EditorSettings,
    EditorUserBuildSettings,
    EditorUserSettings,
    Effector2D,
    EllipsoidParticleEmitter,
    EmptyObject,
    FakeComponent,
    FBXImporter,
    FixedJoint,
    FixedJoint2D,
    Flare,
    FlareLayer,
    Font,
    FrictionJoint2D,
    GameManager,
    GameObject,
    GameObjectRecorder,
    GlobalGameManager,
    GraphicsSettings,
    Grid,
    GridLayout,
    GUIDSerializer,
    GUIElement,
    GUILayer,
    GUIText,
    GUITexture,
    Halo,
    HaloLayer,
    HaloManager,
    HierarchyState,
    HingeJoint,
    HingeJoint2D,
    HumanTemplate,
    IConstraint,
    IHVImageFormatImporter,
    InputManager,
    InspectorExpandedState,
    InteractiveCloth,
    Joint,
    Joint2D,
    KTXImporter,
    LensFlare,
    LevelGameManager,
    LibraryAssetImporter,
    Light,
    LightingDataAsset,
    LightingDataAssetParent,
    LightingSettings,
    LightmapParameters,
    LightmapSettings,
    LightProbeGroup,
    LightProbeProxyVolume,
    LightProbes,
    LineRenderer,
    LocalizationAsset,
    LocalizationImporter,
    LODGroup,
    LookAtConstraint,
    LowerResBlitTexture,
    MasterServerInterface,
    Material,
    Mesh,
    Mesh3DSImporter,
    MeshCollider,
    MeshFilter,
    MeshParticleEmitter,
    MeshRenderer,
    ModelImporter,
    MonoBehaviour,
    MonoImporter,
    MonoManager,
    MonoObject,
    MonoScript,
    Motion,
    MovieImporter,
    MovieTexture,
    MultiArtifactTestImporter,
    NamedObject,
    NativeFormatImporter,
    NativeObjectType,
    NavMeshAgent,
    NavMeshData,
    NavMeshObsolete,
    NavMeshObstacle,
    NavMeshProjectSettings,
    NavMeshSettings,
    NetworkManager,
    NetworkView,
    NewAnimationTrack,
    NScreenBridge,
    Object,
    OcclusionArea,
    OcclusionCullingData,
    OcclusionCullingSettings,
    OcclusionPortal,
    OffMeshLink,
    PackageManifest,
    PackageManifestImporter,
    PackedAssets,
    ParentConstraint,
    ParticleAnimator,
    ParticleEmitter,
    ParticleRenderer,
    ParticleSystem,
    ParticleSystemForceField,
    ParticleSystemRenderer,
    PerformanceReportingManager,
    PhysicMaterial,
    Physics2DSettings,
    PhysicsManager,
    PhysicsMaterial2D,
    PhysicsUpdateBehaviour2D,
    Pipeline,
    PlatformEffector2D,
    PlatformModuleSetup,
    PlayableDirector,
    PlayerSettings,
    PluginBuildInfo,
    PluginImporter,
    PointEffector2D,
    Polygon2D,
    PolygonCollider2D,
    PositionConstraint,
    PrefabImporter,
    PrefabInstance,
    PreloadData,
    Preset,
    PresetManager,
    PreviewAnimationClip,
    ProceduralMaterial,
    ProceduralTexture,
    Projector,
    PropertyModificationsTargetTestObject,
    PVRImporter,
    QualitySettings,
    RaycastCollider,
    RayTracingShader,
    RayTracingShaderImporter,
    RectTransform,
    ReferencesArtifactGenerator,
    ReflectionProbe,
    RelativeJoint2D,
    Renderer,
    RendererFake,
    RenderPassAttachment,
    RenderSettings,
    RenderTexture,
    ResourceManager,
    Rigidbody,
    Rigidbody2D,
    RootMotionData,
    RotationConstraint,
    RuntimeAnimatorController,
    RuntimeInitializeOnLoadManager,
    SampleClip,
    ScaleConstraint,
    SceneAsset,
    ScenesUsingAssets,
    SceneVisibilityState,
    ScriptableCamera,
    ScriptedImporter,
    ScriptMapper,
    SerializableManagedHost,
    SerializableManagedRefTestClass,
    Shader,
    ShaderImporter,
    ShaderVariantCollection,
    SiblingDerived,
    SketchUpImporter,
    SkinnedCloth,
    SkinnedMeshRenderer,
    Skybox,
    SliderJoint2D,
    SortingGroup,
    SparseTexture,
    SpeedTreeImporter,
    SpeedTreeWindAsset,
    SphereCollider,
    SpringJoint,
    SpringJoint2D,
    Sprite,
    SpriteAtlas,
    SpriteAtlasAsset,
    SpriteAtlasDatabase,
    SpriteAtlasImporter,
    SpriteMask,
    SpriteRenderer,
    SpriteShapeRenderer,
    StreamingController,
    StreamingManager,
    SubDerived,
    SubstanceArchive,
    SubstanceImporter,
    SurfaceEffector2D,
    TagManager,
    TargetJoint2D,
    Terrain,
    TerrainCollider,
    TerrainData,
    TerrainLayer,
    TestObjectVectorPairStringBool,
    TestObjectWithSerializedAnimationCurve,
    TestObjectWithSerializedArray,
    TestObjectWithSerializedMapStringBool,
    TestObjectWithSerializedMapStringNonAlignedStruct,
    TestObjectWithSpecialLayoutOne,
    TestObjectWithSpecialLayoutTwo,
    TextAsset,
    TextMesh,
    TextScriptImporter,
    Texture,
    Texture2D,
    Texture2DArray,
    Texture3D,
    TextureImporter,
    Tilemap,
    TilemapCollider2D,
    TilemapRenderer,
    TimeManager,
    TrailRenderer,
    Transform,
    Tree,
    TrueTypeFontImporter,
    UnityAdsManager,
    UnityAnalyticsManager,
    UnityConnectSettings,
    Vector3f,
    VersionControlSettings,
    VFXManager,
    VFXRenderer,
    VideoClip,
    VideoClipImporter,
    VideoPlayer,
    VisualEffect,
    VisualEffectAsset,
    VisualEffectImporter,
    VisualEffectObject,
    VisualEffectResource,
    VisualEffectSubgraph,
    VisualEffectSubgraphBlock,
    VisualEffectSubgraphOperator,
    WebCamTexture,
    WheelCollider,
    WheelJoint2D,
    WindZone,
    WorldAnchor,
    WorldParticleCollider,
)

ClassIDTypeToClassMapValueType = Union[
    AimConstraint,
    AnchoredJoint2D,
    Animation,
    AnimationClip,
    Animator,
    AnimatorController,
    AnimatorOverrideController,
    AnimatorState,
    AnimatorStateMachine,
    AnimatorStateTransition,
    AnimatorTransition,
    AnimatorTransitionBase,
    AnnotationManager,
    AreaEffector2D,
    ArticulationBody,
    AssemblyDefinitionAsset,
    AssemblyDefinitionImporter,
    AssemblyDefinitionReferenceAsset,
    AssemblyDefinitionReferenceImporter,
    AssetBundle,
    AssetBundleManifest,
    AssetDatabaseV1,
    AssetImporter,
    AssetImporterLog,
    AssetImportInProgressProxy,
    AssetMetaData,
    AssetServerCache,
    ASTCImporter,
    AudioBehaviour,
    AudioBuildInfo,
    AudioChorusFilter,
    AudioClip,
    AudioDistortionFilter,
    AudioEchoFilter,
    AudioFilter,
    AudioHighPassFilter,
    AudioImporter,
    AudioListener,
    AudioLowPassFilter,
    AudioManager,
    AudioMixer,
    AudioMixerController,
    AudioMixerEffectController,
    AudioMixerGroup,
    AudioMixerGroupController,
    AudioMixerLiveUpdateBool,
    AudioMixerLiveUpdateFloat,
    AudioMixerSnapshot,
    AudioMixerSnapshotController,
    AudioReverbFilter,
    AudioReverbZone,
    AudioSource,
    Avatar,
    AvatarMask,
    BaseAnimationTrack,
    BaseVideoTexture,
    Behaviour,
    BillboardAsset,
    BillboardRenderer,
    BlendTree,
    BoxCollider,
    BoxCollider2D,
    BuildReport,
    BuildSettings,
    BuiltAssetBundleInfoSet,
    BuoyancyEffector2D,
    CachedSpriteAtlas,
    CachedSpriteAtlasRuntimeData,
    Camera,
    Canvas,
    CanvasGroup,
    CanvasRenderer,
    CapsuleCollider,
    CapsuleCollider2D,
    CGProgram,
    CharacterController,
    CharacterJoint,
    CircleCollider2D,
    Cloth,
    ClothRenderer,
    CloudWebServicesManager,
    ClusterInputManager,
    Collider,
    Collider2D,
    Collision,
    Collision2D,
    Component,
    CompositeCollider2D,
    ComputeShader,
    ComputeShaderImporter,
    ConfigurableJoint,
    ConstantForce,
    ConstantForce2D,
    CrashReportManager,
    Cubemap,
    CubemapArray,
    CustomRenderTexture,
    DDSImporter,
    DefaultAsset,
    DefaultImporter,
    DelayedCallManager,
    Derived,
    DistanceJoint2D,
    EdgeCollider2D,
    EditorBuildSettings,
    EditorExtension,
    EditorExtensionImpl,
    EditorProjectAccess,
    EditorSettings,
    EditorUserBuildSettings,
    EditorUserSettings,
    Effector2D,
    EllipsoidParticleEmitter,
    EmptyObject,
    FakeComponent,
    FBXImporter,
    FixedJoint,
    FixedJoint2D,
    Flare,
    FlareLayer,
    Font,
    FrictionJoint2D,
    GameManager,
    GameObject,
    GameObjectRecorder,
    GlobalGameManager,
    GraphicsSettings,
    Grid,
    GridLayout,
    GUIDSerializer,
    GUIElement,
    GUILayer,
    GUIText,
    GUITexture,
    Halo,
    HaloLayer,
    HaloManager,
    HierarchyState,
    HingeJoint,
    HingeJoint2D,
    HumanTemplate,
    IConstraint,
    IHVImageFormatImporter,
    InputManager,
    InspectorExpandedState,
    InteractiveCloth,
    Joint,
    Joint2D,
    KTXImporter,
    LensFlare,
    LevelGameManager,
    LibraryAssetImporter,
    Light,
    LightingDataAsset,
    LightingDataAssetParent,
    LightingSettings,
    LightmapParameters,
    LightmapSettings,
    LightProbeGroup,
    LightProbeProxyVolume,
    LightProbes,
    LineRenderer,
    LocalizationAsset,
    LocalizationImporter,
    LODGroup,
    LookAtConstraint,
    LowerResBlitTexture,
    MasterServerInterface,
    Material,
    Mesh,
    Mesh3DSImporter,
    MeshCollider,
    MeshFilter,
    MeshParticleEmitter,
    MeshRenderer,
    ModelImporter,
    MonoBehaviour,
    MonoImporter,
    MonoManager,
    MonoObject,
    MonoScript,
    Motion,
    MovieImporter,
    MovieTexture,
    MultiArtifactTestImporter,
    NamedObject,
    NativeFormatImporter,
    NativeObjectType,
    NavMeshAgent,
    NavMeshData,
    NavMeshObsolete,
    NavMeshObstacle,
    NavMeshProjectSettings,
    NavMeshSettings,
    NetworkManager,
    NetworkView,
    NewAnimationTrack,
    NScreenBridge,
    Object,
    OcclusionArea,
    OcclusionCullingData,
    OcclusionCullingSettings,
    OcclusionPortal,
    OffMeshLink,
    PackageManifest,
    PackageManifestImporter,
    PackedAssets,
    ParentConstraint,
    ParticleAnimator,
    ParticleEmitter,
    ParticleRenderer,
    ParticleSystem,
    ParticleSystemForceField,
    ParticleSystemRenderer,
    PerformanceReportingManager,
    PhysicMaterial,
    Physics2DSettings,
    PhysicsManager,
    PhysicsMaterial2D,
    PhysicsUpdateBehaviour2D,
    Pipeline,
    PlatformEffector2D,
    PlatformModuleSetup,
    PlayableDirector,
    PlayerSettings,
    PluginBuildInfo,
    PluginImporter,
    PointEffector2D,
    Polygon2D,
    PolygonCollider2D,
    PositionConstraint,
    PrefabImporter,
    PrefabInstance,
    PreloadData,
    Preset,
    PresetManager,
    PreviewAnimationClip,
    ProceduralMaterial,
    ProceduralTexture,
    Projector,
    PropertyModificationsTargetTestObject,
    PVRImporter,
    QualitySettings,
    RaycastCollider,
    RayTracingShader,
    RayTracingShaderImporter,
    RectTransform,
    ReferencesArtifactGenerator,
    ReflectionProbe,
    RelativeJoint2D,
    Renderer,
    RendererFake,
    RenderPassAttachment,
    RenderSettings,
    RenderTexture,
    ResourceManager,
    Rigidbody,
    Rigidbody2D,
    RootMotionData,
    RotationConstraint,
    RuntimeAnimatorController,
    RuntimeInitializeOnLoadManager,
    SampleClip,
    ScaleConstraint,
    SceneAsset,
    ScenesUsingAssets,
    SceneVisibilityState,
    ScriptableCamera,
    ScriptedImporter,
    ScriptMapper,
    SerializableManagedHost,
    SerializableManagedRefTestClass,
    Shader,
    ShaderImporter,
    ShaderVariantCollection,
    SiblingDerived,
    SketchUpImporter,
    SkinnedCloth,
    SkinnedMeshRenderer,
    Skybox,
    SliderJoint2D,
    SortingGroup,
    SparseTexture,
    SpeedTreeImporter,
    SpeedTreeWindAsset,
    SphereCollider,
    SpringJoint,
    SpringJoint2D,
    Sprite,
    SpriteAtlas,
    SpriteAtlasAsset,
    SpriteAtlasDatabase,
    SpriteAtlasImporter,
    SpriteMask,
    SpriteRenderer,
    SpriteShapeRenderer,
    StreamingController,
    StreamingManager,
    SubDerived,
    SubstanceArchive,
    SubstanceImporter,
    SurfaceEffector2D,
    TagManager,
    TargetJoint2D,
    Terrain,
    TerrainCollider,
    TerrainData,
    TerrainLayer,
    TestObjectVectorPairStringBool,
    TestObjectWithSerializedAnimationCurve,
    TestObjectWithSerializedArray,
    TestObjectWithSerializedMapStringBool,
    TestObjectWithSerializedMapStringNonAlignedStruct,
    TestObjectWithSpecialLayoutOne,
    TestObjectWithSpecialLayoutTwo,
    TextAsset,
    TextMesh,
    TextScriptImporter,
    Texture,
    Texture2D,
    Texture2DArray,
    Texture3D,
    TextureImporter,
    Tilemap,
    TilemapCollider2D,
    TilemapRenderer,
    TimeManager,
    TrailRenderer,
    Transform,
    Tree,
    TrueTypeFontImporter,
    UnityAdsManager,
    UnityAnalyticsManager,
    UnityConnectSettings,
    Vector3f,
    VersionControlSettings,
    VFXManager,
    VFXRenderer,
    VideoClip,
    VideoClipImporter,
    VideoPlayer,
    VisualEffect,
    VisualEffectAsset,
    VisualEffectImporter,
    VisualEffectObject,
    VisualEffectResource,
    VisualEffectSubgraph,
    VisualEffectSubgraphBlock,
    VisualEffectSubgraphOperator,
    WebCamTexture,
    WheelCollider,
    WheelJoint2D,
    WindZone,
    WorldAnchor,
    WorldParticleCollider,
]

ClassIDTypeToClassMap: Dict[CIT, ClassIDTypeToClassMapValueType] = {
    CIT.Object: Object,
    CIT.GameObject: GameObject,
    CIT.Component: Component,
    CIT.LevelGameManager: LevelGameManager,
    CIT.Transform: Transform,
    CIT.TimeManager: TimeManager,
    CIT.GlobalGameManager: GlobalGameManager,
    CIT.Behaviour: Behaviour,
    CIT.GameManager: GameManager,
    CIT.AudioManager: AudioManager,
    CIT.ParticleAnimator: ParticleAnimator,
    CIT.InputManager: InputManager,
    CIT.EllipsoidParticleEmitter: EllipsoidParticleEmitter,
    CIT.Pipeline: Pipeline,
    CIT.EditorExtension: EditorExtension,
    CIT.Physics2DSettings: Physics2DSettings,
    CIT.Camera: Camera,
    CIT.Material: Material,
    CIT.MeshRenderer: MeshRenderer,
    CIT.Renderer: Renderer,
    CIT.ParticleRenderer: ParticleRenderer,
    CIT.Texture: Texture,
    CIT.Texture2D: Texture2D,
    CIT.OcclusionCullingSettings: OcclusionCullingSettings,
    CIT.GraphicsSettings: GraphicsSettings,
    CIT.MeshFilter: MeshFilter,
    CIT.OcclusionPortal: OcclusionPortal,
    CIT.Mesh: Mesh,
    CIT.Skybox: Skybox,
    CIT.QualitySettings: QualitySettings,
    CIT.Shader: Shader,
    CIT.TextAsset: TextAsset,
    CIT.Rigidbody2D: Rigidbody2D,
    CIT.Physics2DManager: Physics2DSettings,
    CIT.Collider2D: Collider2D,
    CIT.Rigidbody: Rigidbody,
    CIT.PhysicsManager: PhysicsManager,
    CIT.Collider: Collider,
    CIT.Joint: Joint,
    CIT.CircleCollider2D: CircleCollider2D,
    CIT.HingeJoint: HingeJoint,
    CIT.PolygonCollider2D: PolygonCollider2D,
    CIT.BoxCollider2D: BoxCollider2D,
    CIT.PhysicsMaterial2D: PhysicsMaterial2D,
    CIT.MeshCollider: MeshCollider,
    CIT.BoxCollider: BoxCollider,
    CIT.CompositeCollider2D: CompositeCollider2D,
    CIT.EdgeCollider2D: EdgeCollider2D,
    CIT.CapsuleCollider2D: CapsuleCollider2D,
    CIT.ComputeShader: ComputeShader,
    CIT.AnimationClip: AnimationClip,
    CIT.ConstantForce: ConstantForce,
    CIT.WorldParticleCollider: WorldParticleCollider,
    CIT.TagManager: TagManager,
    CIT.AudioListener: AudioListener,
    CIT.AudioSource: AudioSource,
    CIT.AudioClip: AudioClip,
    CIT.RenderTexture: RenderTexture,
    CIT.CustomRenderTexture: CustomRenderTexture,
    CIT.MeshParticleEmitter: MeshParticleEmitter,
    CIT.ParticleEmitter: ParticleEmitter,
    CIT.Cubemap: Cubemap,
    CIT.Avatar: Avatar,
    CIT.AnimatorController: AnimatorController,
    CIT.GUILayer: GUILayer,
    CIT.RuntimeAnimatorController: RuntimeAnimatorController,
    CIT.ScriptMapper: ScriptMapper,
    CIT.Animator: Animator,
    CIT.TrailRenderer: TrailRenderer,
    CIT.DelayedCallManager: DelayedCallManager,
    CIT.TextMesh: TextMesh,
    CIT.RenderSettings: RenderSettings,
    CIT.Light: Light,
    CIT.CGProgram: CGProgram,
    CIT.BaseAnimationTrack: BaseAnimationTrack,
    CIT.Animation: Animation,
    CIT.MonoBehaviour: MonoBehaviour,
    CIT.MonoScript: MonoScript,
    CIT.MonoManager: MonoManager,
    CIT.Texture3D: Texture3D,
    CIT.NewAnimationTrack: NewAnimationTrack,
    CIT.Projector: Projector,
    CIT.LineRenderer: LineRenderer,
    CIT.Flare: Flare,
    CIT.Halo: Halo,
    CIT.LensFlare: LensFlare,
    CIT.FlareLayer: FlareLayer,
    CIT.HaloLayer: HaloLayer,
    CIT.NavMeshProjectSettings: NavMeshProjectSettings,
    CIT.HaloManager: HaloManager,
    CIT.Font: Font,
    CIT.PlayerSettings: PlayerSettings,
    CIT.NamedObject: NamedObject,
    CIT.GUITexture: GUITexture,
    CIT.GUIText: GUIText,
    CIT.GUIElement: GUIElement,
    CIT.PhysicMaterial: PhysicMaterial,
    CIT.SphereCollider: SphereCollider,
    CIT.CapsuleCollider: CapsuleCollider,
    CIT.SkinnedMeshRenderer: SkinnedMeshRenderer,
    CIT.FixedJoint: FixedJoint,
    CIT.RaycastCollider: RaycastCollider,
    CIT.BuildSettings: BuildSettings,
    CIT.AssetBundle: AssetBundle,
    CIT.CharacterController: CharacterController,
    CIT.CharacterJoint: CharacterJoint,
    CIT.SpringJoint: SpringJoint,
    CIT.WheelCollider: WheelCollider,
    CIT.ResourceManager: ResourceManager,
    CIT.NetworkView: NetworkView,
    CIT.NetworkManager: NetworkManager,
    CIT.PreloadData: PreloadData,
    CIT.MovieTexture: MovieTexture,
    CIT.ConfigurableJoint: ConfigurableJoint,
    CIT.TerrainCollider: TerrainCollider,
    CIT.MasterServerInterface: MasterServerInterface,
    CIT.TerrainData: TerrainData,
    CIT.LightmapSettings: LightmapSettings,
    CIT.WebCamTexture: WebCamTexture,
    CIT.EditorSettings: EditorSettings,
    CIT.InteractiveCloth: InteractiveCloth,
    CIT.ClothRenderer: ClothRenderer,
    CIT.EditorUserSettings: EditorUserSettings,
    CIT.SkinnedCloth: SkinnedCloth,
    CIT.AudioReverbFilter: AudioReverbFilter,
    CIT.AudioHighPassFilter: AudioHighPassFilter,
    CIT.AudioChorusFilter: AudioChorusFilter,
    CIT.AudioReverbZone: AudioReverbZone,
    CIT.AudioEchoFilter: AudioEchoFilter,
    CIT.AudioLowPassFilter: AudioLowPassFilter,
    CIT.AudioDistortionFilter: AudioDistortionFilter,
    CIT.SparseTexture: SparseTexture,
    CIT.AudioBehaviour: AudioBehaviour,
    CIT.AudioFilter: AudioFilter,
    CIT.WindZone: WindZone,
    CIT.Cloth: Cloth,
    CIT.SubstanceArchive: SubstanceArchive,
    CIT.ProceduralMaterial: ProceduralMaterial,
    CIT.ProceduralTexture: ProceduralTexture,
    CIT.Texture2DArray: Texture2DArray,
    CIT.CubemapArray: CubemapArray,
    CIT.OffMeshLink: OffMeshLink,
    CIT.OcclusionArea: OcclusionArea,
    CIT.Tree: Tree,
    CIT.NavMeshObsolete: NavMeshObsolete,
    CIT.NavMeshAgent: NavMeshAgent,
    CIT.NavMeshSettings: NavMeshSettings,
    CIT.LightProbesLegacy: LightProbes,
    CIT.ParticleSystem: ParticleSystem,
    CIT.ParticleSystemRenderer: ParticleSystemRenderer,
    CIT.ShaderVariantCollection: ShaderVariantCollection,
    CIT.LODGroup: LODGroup,
    CIT.BlendTree: BlendTree,
    CIT.Motion: Motion,
    CIT.NavMeshObstacle: NavMeshObstacle,
    CIT.SortingGroup: SortingGroup,
    CIT.SpriteRenderer: SpriteRenderer,
    CIT.Sprite: Sprite,
    CIT.CachedSpriteAtlas: CachedSpriteAtlas,
    CIT.ReflectionProbe: ReflectionProbe,
    CIT.ReflectionProbes: ReflectionProbe,
    CIT.Terrain: Terrain,
    CIT.LightProbeGroup: LightProbeGroup,
    CIT.AnimatorOverrideController: AnimatorOverrideController,
    CIT.CanvasRenderer: CanvasRenderer,
    CIT.Canvas: Canvas,
    CIT.RectTransform: RectTransform,
    CIT.CanvasGroup: CanvasGroup,
    CIT.BillboardAsset: BillboardAsset,
    CIT.BillboardRenderer: BillboardRenderer,
    CIT.SpeedTreeWindAsset: SpeedTreeWindAsset,
    CIT.AnchoredJoint2D: AnchoredJoint2D,
    CIT.Joint2D: Joint2D,
    CIT.SpringJoint2D: SpringJoint2D,
    CIT.DistanceJoint2D: DistanceJoint2D,
    CIT.HingeJoint2D: HingeJoint2D,
    CIT.SliderJoint2D: SliderJoint2D,
    CIT.WheelJoint2D: WheelJoint2D,
    CIT.ClusterInputManager: ClusterInputManager,
    CIT.BaseVideoTexture: BaseVideoTexture,
    CIT.NavMeshData: NavMeshData,
    CIT.AudioMixer: AudioMixer,
    CIT.AudioMixerController: AudioMixerController,
    CIT.AudioMixerGroupController: AudioMixerGroupController,
    CIT.AudioMixerEffectController: AudioMixerEffectController,
    CIT.AudioMixerSnapshotController: AudioMixerSnapshotController,
    CIT.PhysicsUpdateBehaviour2D: PhysicsUpdateBehaviour2D,
    CIT.ConstantForce2D: ConstantForce2D,
    CIT.Effector2D: Effector2D,
    CIT.AreaEffector2D: AreaEffector2D,
    CIT.PointEffector2D: PointEffector2D,
    CIT.PlatformEffector2D: PlatformEffector2D,
    CIT.SurfaceEffector2D: SurfaceEffector2D,
    CIT.BuoyancyEffector2D: BuoyancyEffector2D,
    CIT.RelativeJoint2D: RelativeJoint2D,
    CIT.FixedJoint2D: FixedJoint2D,
    CIT.FrictionJoint2D: FrictionJoint2D,
    CIT.TargetJoint2D: TargetJoint2D,
    CIT.LightProbes: LightProbes,
    CIT.LightProbeProxyVolume: LightProbeProxyVolume,
    CIT.SampleClip: SampleClip,
    CIT.AudioMixerSnapshot: AudioMixerSnapshot,
    CIT.AudioMixerGroup: AudioMixerGroup,
    CIT.NScreenBridge: NScreenBridge,
    CIT.AssetBundleManifest: AssetBundleManifest,
    CIT.UnityAdsManager: UnityAdsManager,
    CIT.RuntimeInitializeOnLoadManager: RuntimeInitializeOnLoadManager,
    CIT.CloudWebServicesManager: CloudWebServicesManager,
    CIT.UnityAnalyticsManager: UnityAnalyticsManager,
    CIT.CrashReportManager: CrashReportManager,
    CIT.PerformanceReportingManager: PerformanceReportingManager,
    CIT.UnityConnectSettings: UnityConnectSettings,
    CIT.AvatarMask: AvatarMask,
    CIT.PlayableDirector: PlayableDirector,
    CIT.VideoPlayer: VideoPlayer,
    CIT.VideoClip: VideoClip,
    CIT.ParticleSystemForceField: ParticleSystemForceField,
    CIT.SpriteMask: SpriteMask,
    CIT.WorldAnchor: WorldAnchor,
    CIT.OcclusionCullingData: OcclusionCullingData,
    # CIT.SmallestEditorClassID: SmallestEditorClassID,
    CIT.PrefabInstance: PrefabInstance,
    CIT.EditorExtensionImpl: EditorExtensionImpl,
    CIT.AssetImporter: AssetImporter,
    CIT.AssetDatabaseV1: AssetDatabaseV1,
    CIT.Mesh3DSImporter: Mesh3DSImporter,
    CIT.TextureImporter: TextureImporter,
    CIT.ShaderImporter: ShaderImporter,
    CIT.ComputeShaderImporter: ComputeShaderImporter,
    CIT.AudioImporter: AudioImporter,
    CIT.HierarchyState: HierarchyState,
    CIT.GUIDSerializer: GUIDSerializer,
    CIT.AssetMetaData: AssetMetaData,
    CIT.DefaultAsset: DefaultAsset,
    CIT.DefaultImporter: DefaultImporter,
    CIT.TextScriptImporter: TextScriptImporter,
    CIT.SceneAsset: SceneAsset,
    CIT.NativeFormatImporter: NativeFormatImporter,
    CIT.MonoImporter: MonoImporter,
    CIT.AssetServerCache: AssetServerCache,
    CIT.LibraryAssetImporter: LibraryAssetImporter,
    CIT.ModelImporter: ModelImporter,
    CIT.FBXImporter: FBXImporter,
    CIT.TrueTypeFontImporter: TrueTypeFontImporter,
    CIT.MovieImporter: MovieImporter,
    CIT.EditorBuildSettings: EditorBuildSettings,
    CIT.DDSImporter: DDSImporter,
    CIT.InspectorExpandedState: InspectorExpandedState,
    CIT.AnnotationManager: AnnotationManager,
    CIT.PluginImporter: PluginImporter,
    CIT.EditorUserBuildSettings: EditorUserBuildSettings,
    CIT.PVRImporter: PVRImporter,
    CIT.ASTCImporter: ASTCImporter,
    CIT.KTXImporter: KTXImporter,
    CIT.IHVImageFormatImporter: IHVImageFormatImporter,
    CIT.AnimatorStateTransition: AnimatorStateTransition,
    CIT.AnimatorState: AnimatorState,
    CIT.HumanTemplate: HumanTemplate,
    CIT.AnimatorStateMachine: AnimatorStateMachine,
    CIT.PreviewAnimationClip: PreviewAnimationClip,
    CIT.AnimatorTransition: AnimatorTransition,
    CIT.SpeedTreeImporter: SpeedTreeImporter,
    CIT.AnimatorTransitionBase: AnimatorTransitionBase,
    CIT.SubstanceImporter: SubstanceImporter,
    CIT.LightmapParameters: LightmapParameters,
    CIT.LightingDataAsset: LightingDataAsset,
    # CIT.GISRaster: GISRaster,
    # CIT.GISRasterImporter: GISRasterImporter,
    # CIT.CadImporter: CadImporter,
    CIT.SketchUpImporter: SketchUpImporter,
    CIT.BuildReport: BuildReport,
    CIT.PackedAssets: PackedAssets,
    CIT.VideoClipImporter: VideoClipImporter,
    # CIT.ActivationLogComponent: ActivationLogComponent,
    # CIT.int: int,
    # CIT.bool: bool,
    # CIT.float: float,
    CIT.MonoObject: MonoObject,
    CIT.Collision: Collision,
    CIT.Vector3f: Vector3f,
    CIT.RootMotionData: RootMotionData,
    CIT.Collision2D: Collision2D,
    CIT.AudioMixerLiveUpdateFloat: AudioMixerLiveUpdateFloat,
    CIT.AudioMixerLiveUpdateBool: AudioMixerLiveUpdateBool,
    CIT.Polygon2D: Polygon2D,
    # CIT.void: void,
    CIT.TilemapCollider2D: TilemapCollider2D,
    CIT.AssetImporterLog: AssetImporterLog,
    CIT.VFXRenderer: VFXRenderer,
    CIT.SerializableManagedRefTestClass: SerializableManagedRefTestClass,
    CIT.Grid: Grid,
    CIT.ScenesUsingAssets: ScenesUsingAssets,
    CIT.ArticulationBody: ArticulationBody,
    CIT.Preset: Preset,
    CIT.EmptyObject: EmptyObject,
    CIT.IConstraint: IConstraint,
    CIT.TestObjectWithSpecialLayoutOne: TestObjectWithSpecialLayoutOne,
    CIT.AssemblyDefinitionReferenceImporter: AssemblyDefinitionReferenceImporter,
    CIT.SiblingDerived: SiblingDerived,
    CIT.TestObjectWithSerializedMapStringNonAlignedStruct: TestObjectWithSerializedMapStringNonAlignedStruct,
    CIT.SubDerived: SubDerived,
    CIT.AssetImportInProgressProxy: AssetImportInProgressProxy,
    CIT.PluginBuildInfo: PluginBuildInfo,
    CIT.EditorProjectAccess: EditorProjectAccess,
    CIT.PrefabImporter: PrefabImporter,
    CIT.TestObjectWithSerializedArray: TestObjectWithSerializedArray,
    CIT.TestObjectWithSerializedAnimationCurve: TestObjectWithSerializedAnimationCurve,
    CIT.TilemapRenderer: TilemapRenderer,
    CIT.ScriptableCamera: ScriptableCamera,
    CIT.SpriteAtlasAsset: SpriteAtlasAsset,
    CIT.SpriteAtlasDatabase: SpriteAtlasDatabase,
    CIT.AudioBuildInfo: AudioBuildInfo,
    CIT.CachedSpriteAtlasRuntimeData: CachedSpriteAtlasRuntimeData,
    CIT.RendererFake: RendererFake,
    CIT.AssemblyDefinitionReferenceAsset: AssemblyDefinitionReferenceAsset,
    CIT.BuiltAssetBundleInfoSet: BuiltAssetBundleInfoSet,
    CIT.SpriteAtlas: SpriteAtlas,
    CIT.RayTracingShaderImporter: RayTracingShaderImporter,
    CIT.RayTracingShader: RayTracingShader,
    CIT.LightingSettings: LightingSettings,
    CIT.PlatformModuleSetup: PlatformModuleSetup,
    CIT.VersionControlSettings: VersionControlSettings,
    CIT.AimConstraint: AimConstraint,
    CIT.VFXManager: VFXManager,
    CIT.VisualEffectSubgraph: VisualEffectSubgraph,
    CIT.VisualEffectSubgraphOperator: VisualEffectSubgraphOperator,
    CIT.VisualEffectSubgraphBlock: VisualEffectSubgraphBlock,
    CIT.LocalizationImporter: LocalizationImporter,
    CIT.Derived: Derived,
    CIT.PropertyModificationsTargetTestObject: PropertyModificationsTargetTestObject,
    CIT.ReferencesArtifactGenerator: ReferencesArtifactGenerator,
    CIT.AssemblyDefinitionAsset: AssemblyDefinitionAsset,
    CIT.SceneVisibilityState: SceneVisibilityState,
    CIT.LookAtConstraint: LookAtConstraint,
    CIT.SpriteAtlasImporter: SpriteAtlasImporter,
    CIT.MultiArtifactTestImporter: MultiArtifactTestImporter,
    CIT.GameObjectRecorder: GameObjectRecorder,
    CIT.LightingDataAssetParent: LightingDataAssetParent,
    CIT.PresetManager: PresetManager,
    CIT.TestObjectWithSpecialLayoutTwo: TestObjectWithSpecialLayoutTwo,
    CIT.StreamingManager: StreamingManager,
    CIT.LowerResBlitTexture: LowerResBlitTexture,
    CIT.StreamingController: StreamingController,
    CIT.RenderPassAttachment: RenderPassAttachment,
    CIT.TestObjectVectorPairStringBool: TestObjectVectorPairStringBool,
    CIT.GridLayout: GridLayout,
    CIT.AssemblyDefinitionImporter: AssemblyDefinitionImporter,
    CIT.ParentConstraint: ParentConstraint,
    CIT.FakeComponent: FakeComponent,
    CIT.PositionConstraint: PositionConstraint,
    CIT.RotationConstraint: RotationConstraint,
    CIT.ScaleConstraint: ScaleConstraint,
    CIT.Tilemap: Tilemap,
    CIT.PackageManifest: PackageManifest,
    CIT.PackageManifestImporter: PackageManifestImporter,
    CIT.TerrainLayer: TerrainLayer,
    CIT.SpriteShapeRenderer: SpriteShapeRenderer,
    CIT.NativeObjectType: NativeObjectType,
    CIT.TestObjectWithSerializedMapStringBool: TestObjectWithSerializedMapStringBool,
    CIT.SerializableManagedHost: SerializableManagedHost,
    CIT.VisualEffectAsset: VisualEffectAsset,
    CIT.VisualEffectImporter: VisualEffectImporter,
    CIT.VisualEffectResource: VisualEffectResource,
    CIT.VisualEffectObject: VisualEffectObject,
    CIT.VisualEffect: VisualEffect,
    CIT.LocalizationAsset: LocalizationAsset,
    CIT.ScriptedImporter: ScriptedImporter,
}

__all__ = ["ClassIDTypeToClassMap"]
