# step fish shell completion

function __fish_step_no_subcommand --description 'Test if there has been any subcommand yet'
    for i in (commandline -opc)
        if contains -- $i help h base64 path certificate bundle create format inspect fingerprint lint needs-renewal sign verify key install uninstall p12 completion context current list remove select crl inspect crypto change-pass keypair jwk create keyset add remove list find public thumbprint jwt sign verify inspect jwe encrypt decrypt jws sign inspect verify jose format hash digest compare kdf hash compare key format public inspect fingerprint sign verify nacl auth digest verify box keypair open seal secretbox open seal sign keypair open sign otp generate verify rand winpe extract oauth version ca health init bootstrap token certificate rekey renew revoke provisioner list jwe-key add update remove webhook add update remove sign root roots federation acme eab list add remove policy authority view remove x509 allow cn dns email ip uri deny cn dns email ip uri wildcards allow deny ssh host allow dns email principal deny dns email principal user allow email principal deny email principal provisioner view remove x509 allow cn dns email ip uri deny cn dns email ip uri wildcards allow deny ssh host allow dns email principal deny dns email principal user allow email principal deny email principal acme view remove x509 allow cn dns email ip uri deny cn dns email ip uri wildcards allow deny admin list add remove update beta ca acme eab list add remove ssh certificate check-host config fingerprint hosts inspect list login logout needs-renewal proxycommand rekey renew revoke
            return 1
        end
    end
    return 0
end

complete -c step -n '__fish_step_no_subcommand' -f -l help -s h -d 'show help'
complete -c step -n '__fish_step_no_subcommand' -f -l config -r -d 'path to the config file to use for CLI flags'
complete -c step -n '__fish_step_no_subcommand' -f -l version -s v -d 'print the version'
complete -c step -n '__fish_step_no_subcommand' -f -l help -s h -d 'show help'
complete -c step -n '__fish_step_no_subcommand' -f -l version -s v -d 'print the version'
complete -c step -n '__fish_seen_subcommand_from help h' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'help h' -d 'display help for the specified command or command group'
complete -c step -n '__fish_seen_subcommand_from help h' -f -l http -r -d 'HTTP service address (e.g., \':8080\')'
complete -c step -n '__fish_seen_subcommand_from help h' -f -l html -r -d 'The export <directory> for HTML docs.'
complete -c step -n '__fish_seen_subcommand_from help h' -f -l markdown -r -d 'The export <directory> for Markdown docs.'
complete -c step -n '__fish_seen_subcommand_from help h' -f -l report -d 'Writes a JSON report to the HTML docs directory.'
complete -c step -n '__fish_seen_subcommand_from base64' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'base64' -d 'encodes and decodes using base64 representation'
complete -c step -n '__fish_seen_subcommand_from base64' -f -l d -s decode -d 'decode base64 input'
complete -c step -n '__fish_seen_subcommand_from base64' -f -l r -s raw -d 'use the unpadded base64 encoding'
complete -c step -n '__fish_seen_subcommand_from base64' -f -l u -s url -d 'use the encoding format typically used in URLs and file names'
complete -c step -n '__fish_seen_subcommand_from path' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'path' -d 'print the configured step path and exit'
complete -c step -n '__fish_seen_subcommand_from path' -f -l base -d 'Return the base of the step path'
complete -c step -n '__fish_seen_subcommand_from path' -f -l profile -d 'Return the base path of the currently configured default profile'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'certificate' -d 'create, revoke, validate, bundle, and otherwise manage certificates'
complete -c step -n '__fish_seen_subcommand_from bundle' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'bundle' -d 'bundle a certificate with intermediate certificate(s) needed for certificate path validation'
complete -c step -n '__fish_seen_subcommand_from bundle' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'create' -d 'create a certificate or certificate signing request'
complete -c step -n '__fish_seen_subcommand_from create' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from create' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from create' -f -l csr -d 'Generate a certificate signing request (CSR) instead of a certificate.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l profile -r -d 'The certificate profile sets various certificate details such as
  certificate use and expiration. The default profile is \'leaf\' which is suitable
  for a client or server using TLS.

: <profile> is a case-sensitive string and must be one of:

    **leaf**
	:  Generate a leaf x.509 certificate suitable for use with TLS.

    **intermediate-ca**
    :  Generate a certificate that can be used to sign additional leaf certificates.

    **root-ca**
    :  Generate a new self-signed root certificate suitable for use as a root CA.

    **self-signed**
    :  Generate a new self-signed leaf certificate suitable for use with TLS.
	This profile requires the **--subtle** flag because the use of self-signed leaf
	certificates is discouraged unless absolutely necessary.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l template -r -d 'The certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l not-before -r -d 'The <time|duration> set in the NotBefore property of the certificate. If a
<time> is used it is expected to be in RFC 3339 format. If a <duration> is
used, it is a sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from create' -f -l not-after -r -d 'The <time|duration> set in the NotAfter property of the certificate. If a
<time> is used it is expected to be in RFC 3339 format. If a <duration> is
used, it is a sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from create' -f -l san -r -d 'Add DNS or IP Address Subjective Alternative Names (SANs). Use the \'--san\'
flag multiple times to configure multiple SANs.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l ca -r -d 'The certificate authority used to issue the new certificate (PEM file).'
complete -c step -n '__fish_seen_subcommand_from create' -f -l ca-kms -r -d 'The <uri> to configure the KMS used for signing the certificate'
complete -c step -n '__fish_seen_subcommand_from create' -f -l ca-key -r -d 'The certificate authority private key used to sign the new certificate (PEM file).'
complete -c step -n '__fish_seen_subcommand_from create' -f -l ca-password-file -r -d 'The path to the <file> containing the password to
decrypt the CA private key.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l key -r -d 'The <file> of the private key to use instead of creating a new one (PEM file).'
complete -c step -n '__fish_seen_subcommand_from create' -f -l password-file -r -d 'The path to the <file> containing the password to
encrypt the new private key or decrypt the user submitted private key.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l no-password -d 'Do not ask for a password to encrypt the private key.
Sensitive key material will be written to disk unencrypted. This is not
recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l bundle -d 'Bundle the new leaf certificate with the signing certificate. This flag requires
the **--ca** flag.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l skip-csr-signature -d 'Skip creating and signing a CSR.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l subtle -d 'Allow delicate operations.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from format' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'format' -d 'reformat certificate'
complete -c step -n '__fish_seen_subcommand_from format' -f -l out -r -d 'Path to write the reformatted result.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'inspect' -d 'print certificate or CSR details in human readable format'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l format -r -d 'The output format for printing the introspection details.

: <format> is a string and must be one of:

    **text**
    :  Print output in unstructured text suitable for a human to read.

    **json**
    :  Print output in JSON format.

    **pem**
    :  Print output in PEM format.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l servername -r -d 'TLS Server Name Indication that should be sent to request a specific certificate from the server.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l bundle -d 'Print all certificates in the order in which they appear in the bundle.
If the output format is \'json\' then output a list of certificates, even if
the bundle only contains one certificate. This flag will result in an error
if the input bundle includes any PEM that does not have type CERTIFICATE.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l short -d 'Print the certificate or CSR details in shorter and more friendly format.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l insecure -d 'Use an insecure client to retrieve a remote peer certificate. Useful for
debugging invalid certificates remotely.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'fingerprint' -d 'print the fingerprint of a certificate'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l bundle -d 'Print all fingerprints in the order in which they appear in the bundle.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l insecure -d 'Use an insecure client to retrieve a remote peer certificate. Useful for
debugging invalid certificates remotely.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l servername -r -d 'TLS Server Name Indication that should be sent to request a specific certificate from the server.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l format -r -d 'The <format> of the fingerprint, it must be "hex", "base64", "base64-url", "base64-raw", "base64-url-raw" or "emoji".'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l sha1 -d 'Use the SHA-1 hash algorithm to hash the certificate. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from lint' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'lint' -d 'lint certificate details'
complete -c step -n '__fish_seen_subcommand_from lint' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from lint' -f -l insecure -d 'Use an insecure client to retrieve a remote peer certificate. Useful for
debugging invalid certificates remotely.'
complete -c step -n '__fish_seen_subcommand_from lint' -f -l servername -r -d 'TLS Server Name Indication that should be sent to request a specific certificate from the server.'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'needs-renewal' -d 'Check if a certificate needs to be renewed'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l expires-in -r -d 'Check if the certificate expires within the given time window
using <percent|duration>. If using <percent>, the input must be followed by a "%"
character. If using <duration>, the input must be a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l bundle -d 'Check all certificates in the order in which they appear in the bundle.'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l verbose -s v -d 'Print human readable affirmation if certificate requires renewal.'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l servername -r -d 'TLS Server Name Indication that should be sent to request a specific certificate from the server.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'sign' -d 'sign a certificate signing request (CSR)'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l profile -r -d 'The certificate profile sets various certificate details such as
  certificate use and expiration. The default profile is \'leaf\' which is suitable
  for a client or server using TLS.

: <profile> is a case-sensitive string and must be one of:

    **leaf**
    :  Signs a leaf x.509 certificate suitable for use with TLS.

    **intermediate-ca**
    :  Signs a certificate that can be used to sign additional leaf certificates.

    **csr**
    :  Signs a x.509 certificate without modifying the CSR.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l template -r -d 'The certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l omit-cn-san -d 'Do not add CSR Common Name as SAN extension in resulting certificate.
By default, the CSR Common Name will be added as a SAN extension only if the CSR
does not contain any SANs. Note that if the Common Name is already captured as a
SAN extension in the CSR then it will still appear as a SAN extension in the
certificate.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l not-before -r -d 'The <time|duration> set in the NotBefore property of the certificate. If a
<time> is used it is expected to be in RFC 3339 format. If a <duration> is
used, it is a sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l not-after -r -d 'The <time|duration> set in the NotAfter property of the certificate. If a
<time> is used it is expected to be in RFC 3339 format. If a <duration> is
used, it is a sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l path-len -r -d 'The <maximum> path length to set in the pathLenConstraint of an intermediate-ca.
Defaults to 0. If it\'s set to -1 no path length limit is imposed.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l bundle -d 'Bundle the new leaf certificate with the signing certificate.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'verify' -d 'verify a certificate'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l host -r -d 'Check whether the certificate is for the specified host.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l issuing-ca -r -d 'The certificate issuer CA <file> needed to communicate with OCSP and verify a CRL. By default the issuing CA will be taken from the cert Issuing Certificate URL extension.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l verify-ocsp -d 'Verify the certificate against it\'s OCSP.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l ocsp-endpoint -r -d 'The OCSP endpoint to use. If not provided step will attempt to check it against the certificate\'s OCSPServer AIA extension endpoints.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l verify-crl -d 'Verify the certificate against it\'s CRL.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l crl-endpoint -r -d 'The CRL endpoint to use. If not provided step will attempt to check it against the certificate\'s CRLDistributionPoints extension endpoints.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l verbose -s v -d 'Print result of certificate verification to stdout on success'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l servername -r -d 'TLS Server Name Indication that should be sent to request a specific certificate from the server.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from key' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'key' -d 'print public key embedded in a certificate'
complete -c step -n '__fish_seen_subcommand_from key' -f -l out -s output-file -r -d 'The destination <file> of the public key.'
complete -c step -n '__fish_seen_subcommand_from key' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from install' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'install' -d 'install a root certificate in the supported trust stores'
complete -c step -n '__fish_seen_subcommand_from install' -f -l prefix -r -d 'The prefix used to <name> the CA in the trust store. Defaults to the
certificate common name.'
complete -c step -n '__fish_seen_subcommand_from install' -f -l java -d 'install on the Java key store'
complete -c step -n '__fish_seen_subcommand_from install' -f -l firefox -d 'install on the Firefox NSS security database'
complete -c step -n '__fish_seen_subcommand_from install' -f -l no-system -d 'disables the install on the system\'s default trust store'
complete -c step -n '__fish_seen_subcommand_from install' -f -l all -d 'install in Firefox\'s, Java\'s, and the system\'s default trust store'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'uninstall' -d 'uninstall a root certificate from the supported trust stores'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l prefix -r -d 'The prefix used to <name> the CA in the trust store. Defaults to the
certificate common name.'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l java -d 'uninstall from the Java key store'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l firefox -d 'uninstall from the Firefox NSS security database'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l no-system -d 'disables the uninstall from the system\'s default trust store'
complete -c step -n '__fish_seen_subcommand_from uninstall' -f -l all -d 'uninstall from Firefox\'s, Java\'s, and the system\'s default trust store'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from certificate' -a 'p12' -d 'package a certificate and keys into a .p12 file'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l ca -r -d 'The path to the <file> containing a CA or intermediate certificate to
add to the .p12 file. Use the \'--ca\' flag multiple times to add
multiple CAs or intermediates.'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt the .p12 file.'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l legacy -d 'Encodes PKCS#12 files using the algorithms that were traditionally used, PBE+SHA1+RC2 for certificates and PBE+SHA1+3DES for keys.'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from p12' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from completion' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'completion' -d 'print the shell completion script'
complete -c step -n '__fish_seen_subcommand_from completion' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from context' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'context' -d 'manage certificate authority contexts'
complete -c step -n '__fish_seen_subcommand_from current' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from context' -a 'current' -d 'current returns the name of the current context'
complete -c step -n '__fish_seen_subcommand_from current' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from current' -f -l json -d 'Return stringified JSON containing the main attributes of a context.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from context' -a 'list' -d 'list available certificate authority contexts'
complete -c step -n '__fish_seen_subcommand_from list' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from context' -a 'remove' -d 'remove a context and all associated configuration'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from select' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from context' -a 'select' -d 'select the default certificate authority context'
complete -c step -n '__fish_seen_subcommand_from select' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from crl' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'crl' -d 'initialize and manage a certificate revocation list'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crl' -a 'inspect' -d 'print certificate revocation list (CRL) details in human-readable format'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l format -r -d 'The output format for printing the introspection details.

: <format> is a string and must be one of:

    **text**
    :  Print output in unstructured text suitable for a human to read.
	   This is the default format.

    **json**
    :  Print output in JSON format.

    **pem**
    :  Print output in PEM format.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l ca -r -d 'The certificate <file> used to validate the CRL.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l from -d 'Extract CRL and CA from the URL passed as argument.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l roots -r -d 'Root certificate(s) that will be used to verify the
authenticity of the remote server.

: <roots> is a case-sensitive string and may be one of:

    **file**
	:  Relative or full path to a file. All certificates in the file will be used for path validation.

    **list of files**
	:  Comma-separated list of relative or full file paths. Every PEM encoded certificate from each file will be used for path validation.

    **directory**
	:  Relative or full path to a directory. Every PEM encoded certificate from each file in the directory will be used for path validation.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from crypto' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'crypto' -d 'useful cryptographic plumbing'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'change-pass' -d 'change password of an encrypted private key (PEM or JWK format)'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l password-file -r -d 'The path to the <file> containing the password to decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l new-password-file -r -d 'The path to the <file> containing the password to encrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l out -s output-file -r -d 'The <file> new encrypted key path. Default to overwriting the <key> positional argument'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from change-pass' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'keypair' -d 'generate a public / private keypair in PEM format'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l from-jwk -r -d 'Create a PEM representing the key encoded in an
existing <jwk-file> instead of creating a new key.'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from jwk' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'jwk' -d 'create JWKs (JSON Web Keys) and manage JWK Key Sets'
complete -c step -n '__fish_seen_subcommand_from create' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwk' -a 'create' -d 'create a JWK (JSON Web Key)'
complete -c step -n '__fish_seen_subcommand_from create' -f -l kty -s type -r -d 'The <type> of key to create. Corresponds to the **"kty"** JWK parameter.
If unset, default is EC.

: <type> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **oct**
    :  Create a **symmetric key** (octet stream)

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair
'
complete -c step -n '__fish_seen_subcommand_from create' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from create' -f -l alg -s algorithm -r -d 'The <algorithm> intended for use with this key. Corresponds to the
**"alg"** JWK parameter. <algorithm> is case-sensitive. If unset, the default
depends on the key use, key type, and curve (for EC and OKP keys). Defaults are:

: | key type | use | curve   | default algorithm |
  |----------|-----|---------|-------------------|
  | EC       | sig | P-256   | ES256             |
  | EC       | sig | P-384   | ES384             |
  | EC       | sig | P-521   | ES512             |
  | oct      | sig | N/A     | HS256             |
  | RSA      | sig | N/A     | RS256             |
  | OKP      | sig | Ed25519 | EdDSA             |
  | EC       | enc | P-256   | ECDH-ES           |
  | EC       | enc | P-384   | ECDH-ES           |
  | EC       | enc | P-521   | ECDH-ES           |
  | oct      | enc | N/A     | A256GCMKW         |
  | RSA      | enc | N/A     | RSA-OAP-256       |

: If the key **"use"** is **"sig"** (signing) <algorithm> must be one of:

    **HS256**
    :  HMAC using SHA-256

    **HS384**
    :  HMAC using SHA-384

    **HS512**
    :  HMAC using SHA-512

    **RS256**
    :  RSASSA-PKCS1-v1_5 using SHA-256

    **RS384**
    :  RSASSA-PKCS1-v1_5 using SHA-384

    **RS512**
    :  RSASSA-PKCS1-v1_5 using SHA-512

    **ES256**
    :  ECDSA using P-256 and SHA-256

    **ES384**
    :  ECDSA using P-384 and SHA-384

    **ES512**
    :  ECDSA using P-521 and SHA-512

    **PS256**
    :  RSASSA-PSS using SHA-256 and MGF1 with SHA-256

    **PS384**
    :  RSASSA-PSS using SHA-384 and MGF1 with SHA-384

    **PS512**
    :  RSASSA-PSS using SHA-512 and MGF1 with SHA-512

    **EdDSA**
    :  EdDSA signature algorithm

: If the key **"use"** is **"enc"** (encryption) <algorithm> must be one of:

    **RSA1_5**
    :  RSAES-PKCS1-v1_5

    **RSA-OAEP**
    :  RSAES OAEP using default parameters

    **RSA-OAEP-256**
    :  RSAES OAEP using SHA-256 and MGF1 with SHA-256

    **A128KW**
    :  AES Key Wrap with default initial value using 128-bit key

    **A192KW**
    :  AES Key Wrap with default initial value using 192-bit key

    **A256KW**
    :  AES Key Wrap with default initial value using 256-bit key

    **dir**
    :  Direct use of a shared symmetric key as the content encryption key (CEK)

    **ECDH-ES**
    :  Elliptic Curve Diffie-Hellman Ephemeral Static key agreement

    **ECDH-ES+A128KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A128KW"

    **ECDH-ES+A192KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A192KW"

    **ECDH-ES+A256KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A256KW"

    **A128GCMKW**
    :  Key wrapping with AES GCM using 128-bit key

    **A192GCMKW**
    :  Key wrapping with AES GCM using 192-bit key

    **A256GCMKW**
    :  Key wrapping with AES GCM using 256-bit key

    **PBES2-HS256+A128KW**
    :  PBES2 with HMAC SHA-256 and "A128KW" wrapping

    **PBES2-HS384+A192KW**
    :  PBES2 with HMAC SHA-256 and "A192KW" wrapping

    **PBES2-HS512+A256KW**
    :  PBES2 with HMAC SHA-256 and "A256KW" wrapping'
complete -c step -n '__fish_seen_subcommand_from create' -f -l use -r -d 'The intended <use> of the public key. Corresponds to the "use" JWK parameter.
The "use" parameter indicates whether the public key is used for encrypting
data or verifying the signature on data.

: <use> is a case-sensitive string and may be one of:

    **sig**
	:  The public key is used for verifying signatures.

    **enc**
	:  The public key is used for encrypting data.

: Other values may be used but the generated JWKs will not work for signing or
encryption with this tool.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l kid -r -d 'The <kid> (key ID) for this JWK. Corresponds to the
"kid" JWK parameter. Used to identify an individual key in a JWK Set, for
example. <kid> is a case-sensitive string. If unset, the JWK Thumbprint
[RFC7638] is used as <kid>. See **step help crypto jwk thumbprint** for more
information on JWK Thumbprints.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l key-ops -r -d 'The operation(s) for which the key is intended to be used. Corresponds to
the "key_ops" JWK parameter. The \'--key-ops\' flag can be used multiple times
to indicate multiple intended operations.

  <key-op> can be one of the values defined in RFC7517:
    sign
      Compute digital signature or MAC
    verify
      Verify digital signature or MAC
    encrypt
      Encrypt content
    decrypt
      Decrypt content and validate decryption, if applicable
    wrapKey
      Encrypt key
    unwrapKey
      Decrypt key and validate decryption, if applicable
    deriveKey
      Derive key
    deriveBits
      Derive bits not to be used as a key

  The key operation values are case-sensitive strings. Other values may be
used, but values must not be duplicated.

  The \'--use\' and \'--key-ops\' flags cannot be used together without also
passing the \'--subtle\' flag. The \'--subtle\' flag allows both flags to be used
in a consistent way (e.g., \'--key-ops=encrypt --key-ops=decrypt --use=enc\').
Multiple unrelated operations (e.g., \'--key-ops=encrypt --key-ops=sign\') or
inconsistent combinations of \'--use\' and \'--key-ops\' (e.g., \'--use=enc
--key-ops=sign\') are not allowed without also passing the \'--insecure\' flag
because of potential vulnerabilities associated with using the same key with
multiple algorithms.

  Related operations include:
    sign + verify
    encrypt + decrypt
    wrapKey + unwrapKey
  If multiple values are passed and at least one is a non-standard value the
\'--subtle\' flag is required as you must verify that the operations are
related.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l from-pem -r -d 'Create a JWK representing the key encoded in an
existing <pem-file> instead of creating a new key.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l subtle -d 'Allow delicate operations.'
complete -c step -n '__fish_seen_subcommand_from create' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from keyset' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwk' -a 'keyset' -d 'add, remove, and find JWKs in JWK Sets'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from keyset' -a 'add' -d 'a JWK to a JWK Set'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from keyset' -a 'remove' -d 'a JWK from a JWK Set'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l kid -r -d 'The key ID of the JWK to remove from the JWK Set. <kid> is a case-sensitive
string.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from keyset' -a 'list' -d 'key IDs of JWKs in a JWK Set'
complete -c step -n '__fish_seen_subcommand_from find' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from keyset' -a 'find' -d 'a JWK in a JWK Set'
complete -c step -n '__fish_seen_subcommand_from find' -f -l kid -r -d 'The key ID of the JWK to locate from the JWK Set. <kid> is a case-sensitive
string.'
complete -c step -n '__fish_seen_subcommand_from public' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwk' -a 'public' -d 'extract a public JSON Web Key (JWK) from a private JWK'
complete -c step -n '__fish_seen_subcommand_from thumbprint' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwk' -a 'thumbprint' -d 'compute thumbprint for a JWK'
complete -c step -n '__fish_seen_subcommand_from jwt' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'jwt' -d 'sign and verify data using JSON Web Tokens (JWT)'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwt' -a 'sign' -d 'create a signed JWT data structure'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l alg -s algorithm -r -d 'The signature or MAC algorithm to use. Algorithms are case-sensitive strings
defined in RFC7518. The selected algorithm must be compatible with the key
type. This flag is optional. If not specified, the "alg" member of the JWK is
used. If the JWK has no "alg" member then a default is selected depending on
the JWK key type. If the JWK has an "alg" member and the "alg" flag is passed
the two options must match unless the \'--subtle\' flag is also passed.

: <algorithm> is a case-sensitive string and must be one of:

    **HS256**
    :  HMAC using SHA-256 (default for "oct" key type)

    **HS384**
    :  HMAC using SHA-384

    **HS512**
    :  HMAC using SHA-512

    **RS256**
    :  RSASSA-PKCS1-v1_5 using SHA-256 (default for "RSA" key type)

    **RS384**
    :  RSASSA-PKCS1-v1_5 using SHA-384

    **RS512**
    :  RSASSA-PKCS1-v1_5 using SHA-512

    **ES256**
    :  ECDSA using P-256 and SHA-256 (default for "EC" key type)

    **ES384**
    :  ECDSA using P-384 and SHA-384

    **ES512**
    :  ECDSA using P-521 and SHA-512

    **PS256**
    :  RSASSA-PSS using SHA-256 and MGF1 with SHA-256

    **PS384**
    :  RSASSA-PSS using SHA-384 and MGF1 with SHA-384

    **PS512**
    :  RSASSA-PSS using SHA-512 and MGF1 with SHA-512

    **EdDSA**
    :  EdDSA signature algorithm'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l iss -s issuer -r -d 'The issuer of this JWT. The processing of this claim is generally
application specific. Typically, the issuer must match the name of some
trusted entity (e.g., an identity provider like "https://accounts.google.com")
and identify which key(s) to use for JWT verification and/or decryption (e.g.,
the keys at "https://www.googleapis.com/oauth2/v3/certs").

: <issuer> is a case-sensitive string.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l aud -s audience -r -d 'The intended recipient(s) of the JWT, encoded as the **"aud"** claim in the
JWT. Recipient(s) must identify themselves with one or more of the values in
the **"aud"** claim. The **"aud"** claim can be a string (indicating a single
recipient) or an array (indicating multiple potential recipients). This flag
can be used multiple times to generate a JWK with multiple intended
recipients.

: Each <audience> is a case-sensitive string.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l sub -s subject -r -d 'The subject of this JWT. The "claims" are normally interpreted as statements
about this subject. The subject must either be locally unique in the context
of the issuer or globally unique. The processing of this claim is generally
application specific.

: <subject> is a case-sensitive string.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l exp -s expiration -r -d 'The expiration time on or after which the JWT must not be accepted.
<expiration> must be a numeric value representing a Unix timestamp.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l nbf -s not-before -r -d 'The time before which the JWT must not be accepted. <not-before> must be a
numeric value representing a Unix timestamp. If not provided, the current time
is used.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l iat -s issued-at -r -d 'The time at which the JWT was issued, used to determine the age of the JWT.
ISSUED_AT must be a numeric value representing a Unix timestamp. If not
provided, the current time is used.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l jti -s jwt-id -r -d 'A unique identifier for the JWT. The identifier must be assigned in a manner
that ensures that there is a negligible probability that the same value will
be accidentally assigned to multiple JWTs. The JTI claim can be used to
prevent a JWT from being replayed (i.e., recipient(s) can use <jti> to make a
JWT one-time-use). The <jti> argument is a case-sensitive string. If the
**--jti** flag is used without an argument a <jti> will be generated randomly
with sufficient entropy to satisfy the collision-resistance criteria.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l header -r -d 'The <key=value> used as a header in the JWT token. Use the flag multiple
times to set multiple headers.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l key -s x5c-key -s x5t-key -r -d 'The <file> containing the key with which to sign the JWT.
JWTs can be signed using a private JWK (or a JWK encrypted as a JWE payload) or
a PEM encoded private key (or a private key encrypted using the modes described
on RFC 1423 or with PBES2+PBKDF2 described in RFC 2898).'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l jwks -r -d 'The JWK Set containing the key to use to sign the JWT. The <jwks> argument
should be the name of a file. The file contents should be a JWK Set or a JWE
with a JWK Set payload. The **--jwks** flag requires the use of the **--kid**
flag to specify which key to use.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l kid -r -d 'The ID of the key used to sign the JWT. The <kid> argument is a case-sensitive
string. When used with \'--jwk\' the <kid> value must match the **"kid"** member
of the JWK. When used with **--jwks** (a JWK Set) the <kid> value must match
the **"kid"** member of one of the JWKs in the JWK Set.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l password-file -r -d 'The path to the <file> containing the password to decrypt the key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l no-kid
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5t-cert -r -d 'Certificate <file> in PEM format to use for the \'x5t\' header of a JWS or JWT'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-insecure -d 'Use the JWT header \'x5cInsecure\' instead of \'x5c\'.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l subtle
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwt' -a 'verify' -d 'verify a signed JWT data structure and return the payload'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l iss -s issuer -r -d 'The issuer of this JWT. The <issuer> must match the value of the **"iss"** claim in
the JWT. <issuer> is a case-sensitive string. Required unless disabled with the **--subtle** flag.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l aud -s audience -r -d 'The identity of the principal running this command. The <audience> specified
must match one of the values in the **"aud"** claim, indicating the intended
recipient(s) of the JWT. <audience> is a case-sensitive string. Required unless disabled with the
**--subtle** flag.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l alg -s algorithm -r -d 'The signature or MAC <algorithm> to use. Algorithms are case-sensitive strings
defined in RFC7518. If the key used do verify the JWT is not a JWK, or if it
is a JWK but does not have an **"alg"** member indicating its the intended
algorithm for use with the key, then the **--alg** flag is required to prevent
algorithm downgrade attacks. To disable this protection you can pass the
**--insecure** flag and omit the **--alg** flag.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l key -r -d 'The <file> containing the key to use to verify the JWT.
The contents of the file can be a public or private JWK (or a JWK
encrypted as a JWE payload) or a public or private PEM (or a private key
encrypted using the modes described on RFC 1423 or with PBES2+PBKDF2 described
in RFC 2898).'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l jwks -r -d 'The JWK Set containing the key to use to verify the JWS. The <jwks> argument
should be the name of a file. The file contents should be a JWK Set or a JWE
with a JWK Set payload. The JWS being verified should have a "kid" member that
matches the "kid" of one of the JWKs in the JWK Set. If the JWS does not have
a "kid" member the \'--kid\' flag can be used.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l kid -r -d 'The ID of the key used to sign the JWK, used to select a JWK from a JWK Set.
The KID argument is a case-sensitive string. If the input JWS has a "kid"
member its value must match <kid> or verification will fail.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l password-file -r -d 'The path to the <file> containing the password to decrypt the key.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l no-exp-check
complete -c step -n '__fish_seen_subcommand_from verify' -f -l subtle
complete -c step -n '__fish_seen_subcommand_from verify' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwt' -a 'inspect' -d 'return the decoded JWT without verification'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from jwe' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'jwe' -d 'encrypt and decrypt data and keys using JSON Web Encryption (JWE)'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwe' -a 'encrypt' -d 'encrypt a payload using JSON Web Encryption (JWE)'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l alg -s algorithm -r -d 'The cryptographic algorithm used to encrypt or determine the value of the
content encryption key (CEK). Algorithms are case-sensitive strings defined in
RFC7518. The selected algorithm must be compatible with the key type. This
flag is optional. If not specified, the **"alg"** member of the JWK is used. If
the JWK has no **"alg"** member then a default is selected depending on the JWK
key type. If the JWK has an **"alg"** member and the **--alg** flag is passed the two
options must match unless the **--subtle** flag is also passed.

: <key-enc-algorithm> is a case-sensitive string and must be one of:

    **RSA1_5**
    :  RSAES-PKCS1-v1_5

    **RSA-OAEP**
    :  RSAES OAEP using default parameters

    **RSA-OAEP-256** (default for RSA keys)
    :  RSAES OAEP using SHA-256 and MGF1 with SHA-256

    **A128KW**
    :  AES Key Wrap with default initial value using 128-bit key

    **A192KW**
    :  AES Key Wrap with default initial value using 192-bit key

    **A256KW**
    :  AES Key Wrap with default initial value using 256-bit key

    **dir**
    :  Direct use of a shared symmetric key as the content encryption key (CEK)

    **ECDH-ES** (default for EC keys)
    :  Elliptic Curve Diffie-Hellman Ephemeral Static key agreement

    **ECDH-ES+A128KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A128KW

    **ECDH-ES+A192KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A192KW

    **ECDH-ES+A256KW**
    :  ECDH-ES using Concat KDF and CEK wrapped with "A256KW

    **A128GCMKW**
    :  Key wrapping with AES GCM using 128-bit key

    **A192GCMKW**
    :  Key wrapping with AES GCM using 192-bit key

    **A256GCMKW** (default for oct keys)
    :  Key wrapping with AES GCM using 256-bit key

    **PBES2-HS256+A128KW**
    :  PBES2 with HMAC SHA-256 and "A128KW" wrapping

    **PBES2-HS384+A192KW**
    :  PBES2 with HMAC SHA-256 and "A192KW" wrapping

    **PBES2-HS512+A256KW**
	:  PBES2 with HMAC SHA-256 and "A256KW" wrapping'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l enc -s encryption-algorithm -r -d 'The cryptographic content encryption algorithm used to perform authenticated
encryption on the plaintext payload (the content) to produce ciphertext and
the authentication tag.

: <content-enc-algorithm> is a case-sensitive string and must be one of:

    **A128CBC-HS256**
    :  AES_128_CBC_HMAC_SHA_256 authenticated encryption algorithm

    **A192CBC-HS384**
    :  AES_192_CBC_HMAC_SHA_384 authenticated encryption algorithm

    **A256CBC-HS512**
    :  AES_256_CBC_HMAC_SHA_512 authenticated encryption algorithm

    **A128GCM**
    :  AES GCM using 128-bit key

    **A192GCM**
    :  AES GCM using 192-bit key

    **A256GCM** (default)
	:  AES GCM using 256-bit key'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l key -r -d 'The <file> containing the JWE recipient\'s public key.
JWEs can be encrypted for a recipient using a public JWK or a PEM encoded public key.'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l jwks -r -d 'The JWK Set containing the recipient\'s public key. The <jwks> argument should
be the name of a file. The file contents should be a JWK Set. The **--jwks**
flag requires the use of the **--kid** flag to specify which key to use.'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l kid -r -d 'The ID of the recipient\'s public key. <kid> is a case-sensitive string. When
used with **--key** the <kid> value must match the **"kid"** member of the JWK. When
used with **--jwks** (a JWK Set) the <kid> value must match the **"kid"** member of
one of the JWKs in the JWK Set.'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l typ -s type -r -d 'The media type of the JWE, used for disambiguation in applications where
more than one type of JWE may be processed. While this parameter might be
useful to applications, it is ignored by JWE implementations.'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l cty -s content-type -r -d 'The media type of the JWE payload, used for disambiguation of JWE objects in
applications where more than one JWE payload type may be present. This
parameter is ignored by JWE implementations, but may be processed by
applications that use JWE.'
complete -c step -n '__fish_seen_subcommand_from encrypt' -f -l subtle
complete -c step -n '__fish_seen_subcommand_from decrypt' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jwe' -a 'decrypt' -d 'verify a JWE and decrypt ciphertext'
complete -c step -n '__fish_seen_subcommand_from decrypt' -f -l key -r -d 'The argument should be the name of a <file>
containing a private JWK (or a JWK encrypted as a JWE payload) or a PEM encoded
private key (or a private key encrypted using the modes described on RFC 1423 or
with PBES2+PBKDF2 described in RFC 2898).'
complete -c step -n '__fish_seen_subcommand_from decrypt' -f -l jwks -r -d 'The JWK Set containing the recipient\'s private key. The <jwks> argument should
be the name of a file. The file contents should be a JWK Set or a JWE with a
JWK Set payload. The **--jwks** flag requires the use of the **--kid** flag to
specify which key to use.'
complete -c step -n '__fish_seen_subcommand_from decrypt' -f -l kid -r -d 'The ID of the recipient\'s private key. <kid> is a case-sensitive string. When
used with **--key** the <kid> value must match the **"kid"** member of the JWK. When
used with **--jwks** (a JWK Set) the KID value must match the **"kid"** member of
one of the JWKs in the JWK Set.'
complete -c step -n '__fish_seen_subcommand_from decrypt' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt the keys.'
complete -c step -n '__fish_seen_subcommand_from jws' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'jws' -d 'sign and verify data using JSON Web Signature (JWS)'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jws' -a 'sign' -d 'create a signed JWS data structure'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l alg -s algorithm -r -d 'The signature or MAC algorithm to use. Algorithms are case-sensitive strings
defined in RFC7518. The selected algorithm must be compatible with the key
type. This flag is optional. If not specified, the "alg" member of the JWK is
used. If the JWK has no "alg" member then a default is selected depending on
the JWK key type. If the JWK has an "alg" member and the "alg" flag is passed
the two options must match unless the \'--subtle\' flag is also passed.

: <algorithm> is a case-sensitive string and must be one of:

    **HS256**
    :  HMAC using SHA-256 (default for "oct" key type)

    **HS384**
    :  HMAC using SHA-384

    **HS512**
    :  HMAC using SHA-512

    **RS256**
    :  RSASSA-PKCS1-v1_5 using SHA-256 (default for "RSA" key type)

    **RS384**
    :  RSASSA-PKCS1-v1_5 using SHA-384

    **RS512**
    :  RSASSA-PKCS1-v1_5 using SHA-512

    **ES256**
    :  ECDSA using P-256 and SHA-256 (default for "EC" key type)

    **ES384**
    :  ECDSA using P-384 and SHA-384

    **ES512**
    :  ECDSA using P-521 and SHA-512

    **PS256**
    :  RSASSA-PSS using SHA-256 and MGF1 with SHA-256

    **PS384**
    :  RSASSA-PSS using SHA-384 and MGF1 with SHA-384

    **PS512**
    :  RSASSA-PSS using SHA-512 and MGF1 with SHA-512

    **EdDSA**
    :  EdDSA signature algorithm'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l jku -r -d 'The "jku" (JWK Set URL) Header Parameter is a URI that refers to a resource
for a set of JSON-encoded public keys, one of which corresponds to the key
used to digitally sign the JWS. The keys MUST be encoded as a JWK Set (JWK).
The protocol used to acquire the resource MUST provide integrity protection;
an HTTP GET request to retrieve the JWK Set MUST use Transport Layer Security
(TLS); and the identity of the server MUST be validated. Use of <jwk-url> is
optional.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l jwk -d 'The "jwk" (JSON Web Key) Header Parameter is the public key that corresponds
to the key used to digitally sign the JWS. This key is represented as a JSON
Web Key (JWK). Use of <jwk> is optional.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l typ -s type -r -d 'The "typ" (type) Header Parameter is used by JWS applications to declare the
media type of this complete JWS. This is intended for use by the application
when more than one kind of object could be present in an application data
structure that can contain a JWS; the application can use this value to
disambiguate among the different kinds of objects that might be present. It
will typically not be used by applications when the kind of object is already
known. This parameter is ignored by JWS implementations; any processing of
this parameter is performed by the JWS application. Use of <type> is
optional.

The "typ" value "JOSE" can be used by applications to indicate that this
object is a JWS or JWE using the JWS Compact Serialization or the JWE Compact
Serialization. The "typ" value "JOSE+JSON" can be used by applications to
indicate that this object is a JWS or JWE using the JWS JSON Serialization or
the JWE JSON Serialization. Other type values can also be used by
applications.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l cty -r -d 'The "cty" (content type) Header Parameter is used by JWS applications to
declare the media type of the secured content (the payload). This is intended
for use by the application when more than one kind of object could be present
in the JWS Payload; the application can use this value to disambiguate among
the different kinds of objects that might be present. It will typically not be
used by applications when the kind of object is already known. This parameter
is ignored by JWS implementations; any processing of this parameter is
performed by the JWS application. Use of <content-type> is optional.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l key -s x5c-key -s x5t-key -r -d 'The <file> containing the key with which to sign the JWS.
JWSs can be signed using a private JWK (or a JWK encrypted as a JWE payload) or
a PEM encoded private key (or a private key encrypted using the modes described
on RFC 1423 or with PBES2+PBKDF2 described in RFC 2898).'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l jwks -r -d 'The JWK Set containing the key to use to sign the JWS. The <jwks> argument
should be the name of a file. The file contents should be a JWK Set or a JWE
with a JWK Set payload. The **--jwks** flag requires the use of the **--kid**
flag to specify which key to use.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l kid -r -d 'The ID of the key used to sign the JWS. The <kid> argument is a case-sensitive
string. When used with \'--jwk\' the <kid> value must match the **"kid"** member
of the JWK. When used with **--jwks** (a JWK Set) the <kid> value must match
the **"kid"** member of one of the JWKs in the JWK Set.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l no-kid
complete -c step -n '__fish_seen_subcommand_from sign' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5t-cert -r -d 'Certificate <file> in PEM format to use for the \'x5t\' header of a JWS or JWT'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l subtle
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jws' -a 'inspect' -d 'return the decoded JWS without verification'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l json -d 'Displays the header, payload and signature as a JSON object. The payload will
be encoded using Base64.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jws' -a 'verify' -d 'verify a signed JWS data structure and return the payload'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l alg -s algorithm -r -d 'The signature or MAC <algorithm> to use. Algorithms are case-sensitive strings
defined in RFC7518. If the key used do verify the JWS is not a JWK, or if it
is a JWK but does not have an **"alg"** member indicating its the intended
algorithm for use with the key, then the **--alg** flag is required to prevent
algorithm downgrade attacks. To disable this protection you can pass the
**--insecure** flag and omit the **--alg** flag.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l key -r -d 'The <file> containing the key with which to verify the JWS.
The contents of the file can be a public or private JWK (or a JWK
encrypted as a JWE payload) or a public or private PEM (or a private key
encrypted using the modes described on RFC 1423 or with PBES2+PBKDF2 described
in RFC 2898).'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l jwks -r -d 'The JWK Set containing the key to use to verify the JWS. The <jwks> argument
should be the name of a file. The file contents should be a JWK Set or a JWE
with a JWK Set payload. The JWS being verified should have a "kid" member that
matches the "kid" of one of the JWKs in the JWK Set. If the JWS does not have
a "kid" member the \'--kid\' flag can be used.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l kid -r -d 'The ID of the key used to sign the JWK, used to select a JWK from a JWK Set.
The KID argument is a case-sensitive string. If the input JWS has a "kid"
member its value must match <kid> or verification will fail.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l json -d 'Displays the header, payload and signature as a JSON object. The payload will
be encoded using Base64.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l subtle
complete -c step -n '__fish_seen_subcommand_from verify' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from jose' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'jose' -d 'collection of JOSE utilities'
complete -c step -n '__fish_seen_subcommand_from format' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from jose' -a 'format' -d 'swap serialization format'
complete -c step -n '__fish_seen_subcommand_from hash' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'hash' -d 'generate and check hashes of files and directories'
complete -c step -n '__fish_seen_subcommand_from digest' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from hash' -a 'digest' -d 'generate a hash digest of a file or directory'
complete -c step -n '__fish_seen_subcommand_from digest' -f -l alg -r -d 'The hash algorithm to use.

: <algorithm> must be one of:

		**sha1** (or sha)
		:  SHA-1 produces a 160-bit hash value

		**sha224**
		:  SHA-224 produces a 224-bit hash value

		**sha256** (default)
		:  SHA-256 produces a 256-bit hash value

		**sha384**
		:  SHA-384 produces a 384-bit hash value

		**sha512**
		:  SHA-512 produces a 512-bit hash value

		**sha512-224**
		:  SHA-512/224 uses SHA-512 and truncates the output to 224 bits

		**sha512-256**
		:  SHA-512/256 uses SHA-512 and truncates the output to 256 bits

		**md5** (requires --insecure)
		:  MD5 produces a 128-bit hash value
'
complete -c step -n '__fish_seen_subcommand_from digest' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from compare' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from hash' -a 'compare' -d 'verify the hash digest for a file or directory matches an expected value'
complete -c step -n '__fish_seen_subcommand_from compare' -f -l alg -r -d 'The hash algorithm to use.

: <algorithm> must be one of:

		**sha1** (or sha)
		:  SHA-1 produces a 160-bit hash value

		**sha224**
		:  SHA-224 produces a 224-bit hash value

		**sha256** (default)
		:  SHA-256 produces a 256-bit hash value

		**sha384**
		:  SHA-384 produces a 384-bit hash value

		**sha512**
		:  SHA-512 produces a 512-bit hash value

		**sha512-224**
		:  SHA-512/224 produces a 224-bit hash value

		**sha512-256**
		:  SHA-512/256 produces a 256-bit hash value

		**md5** (requires --insecure)
		:  MD5 produces a 128-bit hash value
'
complete -c step -n '__fish_seen_subcommand_from compare' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from kdf' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'kdf' -d 'key derivation functions for password hashing and verification'
complete -c step -n '__fish_seen_subcommand_from hash' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from kdf' -a 'hash' -d 'derive a secret key from a secret value (e.g., a password)'
complete -c step -n '__fish_seen_subcommand_from hash' -f -l alg -r -d 'The KDF algorithm to use.

:  <algorithm> must be one of:

		**scrypt**
		:  A password-based KDF designed to use exponential time and memory.

		**bcrypt**
		:  A password-based KDF designed to use exponential time.

		**argon2i**
		: A password-based KDF optimized to resist side-channel attacks.

		**argon2id**
		: A password-based KDF optimized to resist GPU and side-channel attacks.
'
complete -c step -n '__fish_seen_subcommand_from hash' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from compare' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from kdf' -a 'compare' -d 'compare a plaintext value (e.g., a password) and a hash'
complete -c step -n '__fish_seen_subcommand_from compare' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from key' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'key' -d 'manage keys'
complete -c step -n '__fish_seen_subcommand_from format' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'format' -d 'reformat a public or private key'
complete -c step -n '__fish_seen_subcommand_from format' -f -l pkcs8 -d 'Convert RSA and ECDSA private keys to PKCS#8 PEM/DER format.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l pem -d 'Uses PEM as the result encoding format. If neither **--pem** nor **--der** nor
**--ssh** nor **--jwk** are set it will always switch to the DER format.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l der -d 'Uses DER as the result enconfig format. If neither **--pem** nor **--der** nor
**--ssh** nor **--jwk** are set it will always switch to the PEM format.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l ssh -d 'Uses OpenSSH as the result encoding format.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l jwk -d 'Uses JSON Web Key as the result encoding format.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l out -r -d 'Path to write the reformatted result.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l password-file -r -d 'Location of file containing passphrase to decrypt private key.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l no-password -d 'Do not ask for a password to encrypt a private key with PEM format. Sensitive
key material will be written to disk unencrypted. This is not recommended.
Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from format' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from format' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from public' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'public' -d 'print the public key from a private key or certificate'
complete -c step -n '__fish_seen_subcommand_from public' -f -l out -r -d 'The <file> to write the public key.'
complete -c step -n '__fish_seen_subcommand_from public' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from public' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'inspect' -d 'print key details in human readable format'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l password-file -r -d 'The path to the <file> containing passphrase to decrypt private key.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'fingerprint' -d 'print the fingerprint of a public key'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l sha1 -d 'Use the SHA-1 hash with hexadecimal format. The result will be equivalent to the Subject Key Identifier in a X.509 certificate.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l ssh -d 'Use the SSH marshaling format instead of X.509.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l password-file -r -d 'The path to the <file> containing passphrase to decrypt a private key.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l raw -d 'Print the raw bytes instead of the fingerprint. These bytes can be piped to a different hash command.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l format -r -d 'The <format> of the fingerprint, it must be "hex", "base64", "base64-url", "base64-raw", "base64-url-raw" or "emoji".'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'sign' -d 'sign a message using an asymmetric key'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l key -r -d 'The path to the <file> containing the private key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l alg -r -d 'The hash algorithm to use on RSA PKCS #1 1.5 and RSA-PSS signatures.

: <algorithm> must be one of:

		**sha1** (or sha)
		:  SHA-1 produces a 160-bit hash value

		**sha224**
		:  SHA-224 produces a 224-bit hash value

		**sha256** (default)
		:  SHA-256 produces a 256-bit hash value

		**sha384**
		:  SHA-384 produces a 384-bit hash value

		**sha512**
		:  SHA-512 produces a 512-bit hash value

		**sha512-224**
		:  SHA-512/224 uses SHA-512 and truncates the output to 224 bits

		**sha512-256**
		:  SHA-512/256 uses SHA-512 and truncates the output to 256 bits

		**md5**
		:  MD5 produces a 128-bit hash value
'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l pss -d 'Use RSA-PSS signature scheme.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l raw -d 'Print the raw bytes instead of the base64 format.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l password-file -r -d 'The path to the <file> containing passphrase to decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from key' -a 'verify' -d 'verify a signed message'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l key -r -d 'The path to the <file> containing the public key.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l signature -s sig -r -d 'The <base64> version of the signature.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l alg -r -d 'The hash algorithm to use on RSA PKCS #1 1.5 and RSA-PSS signatures.

: <algorithm> must be one of:

		**sha1** (or sha)
		:  SHA-1 produces a 160-bit hash value

		**sha224**
		:  SHA-224 produces a 224-bit hash value

		**sha256** (default)
		:  SHA-256 produces a 256-bit hash value

		**sha384**
		:  SHA-384 produces a 384-bit hash value

		**sha512**
		:  SHA-512 produces a 512-bit hash value

		**sha512-224**
		:  SHA-512/224 uses SHA-512 and truncates the output to 224 bits

		**sha512-256**
		:  SHA-512/256 uses SHA-512 and truncates the output to 256 bits

		**md5**
		:  MD5 produces a 128-bit hash value
'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l pss -d 'Verify using the RSA-PSS signature scheme.'
complete -c step -n '__fish_seen_subcommand_from nacl' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'nacl' -d 'easy-to-use high-speed tools for encryption and signing'
complete -c step -n '__fish_seen_subcommand_from auth' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from nacl' -a 'auth' -d 'authenticate a message using a secret key'
complete -c step -n '__fish_seen_subcommand_from digest' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from auth' -a 'digest' -d 'generate a 32-byte digest for a message'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from auth' -a 'verify' -d 'validate a digest for a message'
complete -c step -n '__fish_seen_subcommand_from box' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from nacl' -a 'box' -d 'authenticate and encrypt small messages using public-key cryptography'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from box' -a 'keypair' -d 'generate a key for use with seal and open'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from open' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from box' -a 'open' -d 'authenticate and decrypt a box produced by seal'
complete -c step -n '__fish_seen_subcommand_from open' -f -l raw -d 'Indicates that input is not base64 encoded'
complete -c step -n '__fish_seen_subcommand_from seal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from box' -a 'seal' -d 'produce an authenticated and encrypted ciphertext'
complete -c step -n '__fish_seen_subcommand_from seal' -f -l raw -d 'Do not base64 encode output'
complete -c step -n '__fish_seen_subcommand_from secretbox' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from nacl' -a 'secretbox' -d 'encrypt and authenticate small messages using secret-key cryptography'
complete -c step -n '__fish_seen_subcommand_from open' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from secretbox' -a 'open' -d 'authenticate and decrypt a box produced by seal'
complete -c step -n '__fish_seen_subcommand_from open' -f -l raw -d 'Indicates that input is not base64 encoded'
complete -c step -n '__fish_seen_subcommand_from seal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from secretbox' -a 'seal' -d 'produce an encrypted ciphertext'
complete -c step -n '__fish_seen_subcommand_from seal' -f -l raw -d 'Do not base64 encode output'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from nacl' -a 'sign' -d 'sign small messages using public-key cryptography'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from sign' -a 'keypair' -d 'generate a pair for use with sign and open'
complete -c step -n '__fish_seen_subcommand_from keypair' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from open' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from sign' -a 'open' -d 'verify a signed message produced by sign'
complete -c step -n '__fish_seen_subcommand_from open' -f -l raw -d 'Indicates that input is not base64 encoded'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from sign' -a 'sign' -d 'sign a message using Ed25519'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l raw -d 'Do not base64 encode output'
complete -c step -n '__fish_seen_subcommand_from otp' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'otp' -d 'generate and verify one-time passwords'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from otp' -a 'generate' -d 'generate a one-time password'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l issuer -s iss -r -d 'Name of the issuing organization (e.g., smallstep.com)'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l account -r -d 'Name of the user\'s account (e.g., a username or email
address)'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l period -r -d 'Number of seconds a TOTP hash is valid. Defaults to 30
seconds.'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l length -s digits -r -d 'Length of one-time passwords. Defaults to 6.'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l secret-size -r -d 'Size of generated TOTP secret. Defaults to 20.'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l alg -s algorithm -r -d 'Algorithm to use for HMAC. Defaults to SHA1. Must be
one of: SHA1, SHA256, SHA512'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l url -d 'Output a TOTP Key URI. See
https://github.com/google/google-authenticator/wiki/Key-Uri-Format'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l qr -r -d 'Write a QR code to the specified path'
complete -c step -n '__fish_seen_subcommand_from generate' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from otp' -a 'verify' -d 'verify a one-time password'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l secret -r -d 'The <file> containing TOTP secret.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l period -r -d 'Number of seconds a TOTP hash is valid. Defaults to 30
seconds.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l skew -r -d 'Periods before or after current time to allow. Defaults
to 0. Values greater than 1 require \'--insecure\' flag.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l length -s digits -r -d 'Length of one-time passwords. Defaults to 6 digits.'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l alg -s algorithm -r -d 'Algorithm to use for HMAC. Defaults to SHA1. Must be
one of: SHA1, SHA256, SHA512'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l time -r -d 'The <time|duration> to use for TOTP validation. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h". A <duration> value is added to the current time. An empty
<time|duration> defaults to "time.Now()".'
complete -c step -n '__fish_seen_subcommand_from verify' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from rand' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'rand' -d 'generate random strings'
complete -c step -n '__fish_seen_subcommand_from rand' -f -l format -r -d 'The <format> of the output string. See help for list of available formats.'
complete -c step -n '__fish_seen_subcommand_from rand' -f -l dictionary -s dict -r -d 'The <file> to use as a dictionary to get random words.'
complete -c step -n '__fish_seen_subcommand_from winpe' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from crypto' -a 'winpe' -d 'extract certificates and verify Windows Portable Executable files'
complete -c step -n '__fish_seen_subcommand_from extract' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from winpe' -a 'extract' -d 'extract certificates from Windows Portable Executable files'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'oauth' -d 'authorization and single sign-on using OAuth & OIDC'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l provider -s idp -r -d 'OAuth provider for authentication'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l email -s e -r -d 'Email to authenticate'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l console -s c -d 'Complete the flow while remaining only inside the terminal.
This flag defaults to use the Device Authorization Grant flow.'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l console-flow -r -d 'The alternative OAuth <flow> to use for input constrained devices.

: <console-flow> is a case-insensitive string and must be one of:

    **device**
    :  Use the Device Authorization Grant (https://datatracker.ietf.org/doc/html/rfc8628#section-3.2) flow

    **oob**
    :  Use the Out of Band (OOB) flow'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l client-id -r -d 'OAuth Client ID'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l client-secret -r -d 'OAuth Client Secret'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l account -r -d 'JSON file containing account details'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l authorization-endpoint -r -d 'OAuth Authorization Endpoint'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l device-authorization-endpoint -r -d 'OAuth Device Authorization Endpoint'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l token-endpoint -r -d 'OAuth Token Endpoint'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l header -d 'Output HTTP Authorization Header (suitable for use with curl)'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l oidc -d 'Output OIDC Token instead of OAuth Access Token'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l bare -d 'Only output the token'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l scope -r -d 'OAuth scopes'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l auth-param -r -d 'OAuth additional authentication parameters to include as part of the URL query.
Use this flag multiple times to add multiple parameters. This flag expects a
\'key\' and \'value\' in the format \'--auth-param "key=value"\'.'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l prompt -r -d 'Whether the Authorization Server prompts the End-User for reauthentication and consent.
OpenID standard defines the following values, but your provider may support some or none of them:

    **none**
    :   The Authorization Server MUST NOT display any authentication or consent user interface pages.
        An error is returned if an End-User is not already authenticated or the Client does not have
        pre-configured consent for the requested Claims or does not fulfill other conditions for
        processing the request.

    **login**
    :   The Authorization Server SHOULD prompt the End-User for reauthentication. If it cannot
        reauthenticate the End-User, it MUST return an error, typically login_required.

    **consent**
    :   The Authorization Server SHOULD prompt the End-User for consent before returning information
        to the Client. If it cannot obtain consent, it MUST return an error, typically consent_required.

    **select_account**
    :   The Authorization Server SHOULD prompt the End-User to select a user account. This enables an
        End-User who has multiple accounts at the Authorization Server to select amongst the multiple
        accounts that they might have current sessions for. If it cannot obtain an account selection
        choice made by the End-User, it MUST return an error, typically account_selection_required.
'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l jwt -d 'Generate a JWT Auth token instead of an OAuth Token (only works with service accounts)'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l listen -r -d 'Callback listener <address> (e.g. ":10000")'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l listen-url -r -d 'The redirect_uri <url> in the authorize request (e.g. "http://127.0.0.1:10000")'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l implicit -d 'Uses the implicit flow to authenticate the user. Requires **--insecure** and **--client-id** flags.'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l browser -r -d 'Path to browser for OAuth flow (macOS only).'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l redirect-url -r -d 'The <url> to open in the system browser when the OAuth flow is successful.'
complete -c step -n '__fish_seen_subcommand_from oauth' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from version' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'version' -d 'display the current version of the cli'
complete -c step -n '__fish_seen_subcommand_from version' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from ca' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'ca' -d 'initialize and manage a certificate authority'
complete -c step -n '__fish_seen_subcommand_from health' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'health' -d 'get the status of the CA'
complete -c step -n '__fish_seen_subcommand_from health' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from health' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from health' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'init' -d 'initialize the CA PKI'
complete -c step -n '__fish_seen_subcommand_from init' -f -l root -r -d 'The path of an existing PEM <file> to be used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l key -r -d 'The path of an existing key <file> of the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l key-password-file -r -d 'The path to the <file> containing the password to decrypt the existing root certificate key.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l pki -d 'Generate only the PKI without the CA configuration.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l ssh -d 'Create keys to sign SSH certificates.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l helm -d 'Generates a Helm values YAML to be used with step-certificates chart.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l deployment-type -r -d 'The <name> of the deployment type to use. Options are:
    **standalone**
    :  An instance of step-ca that does not connect to any cloud services. You
    manage authority keys and configuration yourself.
    Choose standalone if you\'d like to run step-ca yourself and do not want
    cloud services or commercial support.

    **linked**
    :  An instance of step-ca with locally managed keys that connects to your
    Certificate Manager account for provisioner management, alerting,
    reporting, revocation, and other managed services.
    Choose linked if you\'d like cloud services and support, but need to
    control your authority\'s signing keys.

    **hosted**
    :  A highly available, fully-managed instance of step-ca run by smallstep
    just for you.
    Choose hosted if you\'d like cloud services and support.

: More information and pricing at: https://u.step.sm/cm'
complete -c step -n '__fish_seen_subcommand_from init' -f -l name -r -d 'The <name> of the new PKI.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l dns -r -d 'The DNS <name> or IP address of the new CA.
Use the \'--dns\' flag multiple times to configure multiple DNS names.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l address -r -d 'The <address> that the new CA will listen at.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l provisioner -r -d 'The <name> of the first provisioner.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt the keys.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to encrypt the provisioner key.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l with-ca-url -r -d '<URI> of the Step Certificate Authority to write in defaults.json'
complete -c step -n '__fish_seen_subcommand_from init' -f -l ra -r -d 'The registration authority <type> to use. Currently "StepCAS" and "CloudCAS" are supported.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l kms -r -d 'The key manager service <type> to use to manage keys. Options are:
	**azurekms**
    :  Use Azure Key Vault to manage X.509 and SSH keys. The key URIs have
	the following format <azurekms:name=key-name;vault=vault-name>.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l kms-root -r -d 'The kms <URI> used to generate the root certificate key. Examples are:
	**azurekms**
	:  azurekms:name=my-root-key;vault=my-vault'
complete -c step -n '__fish_seen_subcommand_from init' -f -l kms-intermediate -r -d 'The kms <URI> used to generate the intermediate certificate key. Examples are:
	**azurekms**
	:  azurekms:name=my-intermediate-key;vault=my-vault'
complete -c step -n '__fish_seen_subcommand_from init' -f -l kms-ssh-host -r -d 'The kms <URI> used to generate the key used to sign SSH host certificates. Examples are:
	**azurekms**
	:  azurekms:name=my-host-key;vault=my-vault'
complete -c step -n '__fish_seen_subcommand_from init' -f -l kms-ssh-user -r -d 'The kms <URI> used to generate the key used to sign SSH user certificates. Examples are:
	**azurekms**
	:  azurekms:name=my-user-key;vault=my-vault'
complete -c step -n '__fish_seen_subcommand_from init' -f -l issuer -r -d 'The registration authority issuer <url> to use.

: If StepCAS is used, this flag should be the URL of the CA to connect
to, e.g https://ca.smallstep.com:9000

: If CloudCAS is used, this flag should be the resource name of the
intermediate certificate to use. This has the format
\'projects/\\*/locations/\\*/caPools/\\*/certificateAuthorities/\\*\'.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l issuer-fingerprint -r -d 'The root certificate <fingerprint> of the issuer CA.
This flag is supported in "StepCAS", and it should be the result of running:
\'\'\'
$ step certificate fingerprint root_ca.crt
4fe5f5ef09e95c803fdcb80b8cf511e2a885eb86f3ce74e3e90e62fa3faf1531
\'\'\''
complete -c step -n '__fish_seen_subcommand_from init' -f -l issuer-provisioner -r -d 'The <name> of an existing provisioner in the issuer CA.
This flag is supported in "StepCAS".'
complete -c step -n '__fish_seen_subcommand_from init' -f -l credentials-file -r -d 'The registration authority credentials <file> to use.

: If CloudCAS is used, this flag should be the path to a service account key.
It can also be set using the \'GOOGLE_APPLICATION_CREDENTIALS=path\'
environment variable or the default service account in an instance in Google
Cloud.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l no-db -d 'Generate a CA configuration without the DB stanza. No persistence layer.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l context -r -d 'The <name> of the context for the new authority.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l remote-management -d 'Enable Remote Management. Defaults to false.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l acme -d 'Create a default ACME provisioner. Defaults to false.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l profile -r -d 'The <name> that will serve as the profile name for the context.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l authority -r -d 'The <name> that will serve as the authority name for the context.'
complete -c step -n '__fish_seen_subcommand_from init' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'bootstrap' -d 'initialize the environment to use the CA commands'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l fingerprint -r -d 'The <fingerprint> of the targeted root certificate.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l install -d 'Install the root certificate into the system\'s default trust store.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l team -r -d 'The team <ID> used to bootstrap the environment.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l team-authority -r -d 'The <sub-domain> of the certificate authority to bootstrap. E.g., for an authority with
domain name \'certs.example-team.ca.smallstep.com\' the value would be \'certs\'.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l team-url -r -d 'The <url> step queries to retrieve initial team configuration. Only used with
the **--team** option. If the url contains <\<\>> placeholders, they are replaced with the team ID.
Replacing the authority-id section of the url is not supported with placeholders.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l redirect-url -r -d 'The <url> to open in the system browser when the OAuth flow is successful.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l profile -r -d 'The <name> that will serve as the profile name for the context.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l authority -r -d 'The <name> that will serve as the authority name for the context.'
complete -c step -n '__fish_seen_subcommand_from bootstrap' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'token' -d 'generate an OTT granting access to the CA'
complete -c step -n '__fish_seen_subcommand_from token' -f -l kid -r -d 'The provisioner <kid> to use.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l san -r -d 'Add <dns|ip|email|uri> Subject Alternative Name(s) (SANs)
that should be authorized. A certificate signing request using this token must
match the complete set of SANs in the token 1:1. Use the \'--san\' flag multiple
times to configure multiple SANs.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l principal -s n -r -d 'Add the principals (user or host <name>s) that the token is authorized to
request. The signing request using this token won\'t be able to add
extra names. Use the \'--principal\' flag multiple times to configure
multiple principals.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l host -d 'Create a host certificate instead of a user certificate.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from token' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l not-before -r -d 'The <time|duration> when the token\'s validity period starts. If a <time> is
		used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
		sequence of decimal numbers, each with optional fraction and a unit suffix, such
		as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
		"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from token' -f -l not-after -r -d 'The <time|duration> when the token\'s validity period ends. If a <time> is
		used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
		sequence of decimal numbers, each with optional fraction and a unit suffix, such
		as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
		"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from token' -f -l cert-not-after -r -d 'The <time|duration> when the certificate validity period ends. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h". This flag is only supported on SSH certificates.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l cert-not-before -r -d 'The <time|duration> when the certificate validity period starts. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h". This flag is only supported on SSH certificates.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l x5c-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l x5c-insecure -d 'Use the JWT header \'x5cInsecure\' instead of \'x5c\'.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l sshpop-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'sshpop\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l sshpop-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'sshpop\' header.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l nebula-cert -r -d 'Certificate <file> in PEM format to store in the \'nebula\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l nebula-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'nebula\' header.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l cnf -r -d 'The <fingerprint> of the CSR to restrict this token for.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l cnf-file -r -d 'The CSR <file> to restrict this token for.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l key -r -d 'The private key <file> used to sign the JWT. This is usually downloaded from
the certificate authority.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l output-file -r -d 'The destination <file> of the generated one-time token.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l revoke -d 'Create a token for authorizing \'Revoke\' requests. The audience will
be invalid for any other API request.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l renew -d 'Create a token for authorizing \'renew\' requests. The audience will
be invalid for any other API request.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l rekey -d 'Create a token for authorizing \'rekey\' requests. The audience will
be invalid for any other API request.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l ssh -d 'Create a token for authorizing an SSH certificate signing request.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l k8ssa-token-path -r -d 'Configure the <file> from which to read the kubernetes service account token.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from token' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'certificate' -d 'generate a new private key and certificate signed by the root certificate'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l san -r -d 'Add <dns|ip|email|uri> Subject Alternative Name(s) (SANs)
that should be authorized. Use the \'--san\' flag multiple times to configure
multiple SANs. The \'--san\' flag and the \'--token\' flag are mutually exclusive.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l attestation-ca-url -r -d 'The base url of the Attestation CA to use'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l attestation-ca-root -r -d 'The path to the PEM <file> with trusted roots when connecting to the Attestation CA'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l attestation-ca-insecure -d 'Disables TLS server validation when connecting to the Attestation CA'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l tpm-storage-directory -r -d 'The directory where TPM keys and certificates will be stored'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l not-after -r -d 'The <time|duration> when the certificate validity period ends. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l not-before -r -d 'The <time|duration> when the certificate validity period starts. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l attestation-uri -r -d 'The KMS <uri> used for attestation.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-chain -r -d 'Certificate <file>, in PEM format'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l nebula-cert -r -d 'Certificate <file> in PEM format to store in the \'nebula\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l nebula-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'nebula\' header.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l acme -r -d 'ACME directory <url> to be used for requesting certificates via the ACME protocol.
Use this flag to define an ACME server other than the Step CA. If this flag is
absent and an ACME provisioner has been selected then the \'--ca-url\' flag must be defined.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l standalone -d 'Get a certificate using the ACME protocol and standalone mode for validation.
Standalone is a mode in which the step process will run a server that will
will respond to ACME challenge validation requests. Standalone is the default
mode for serving challenge validation requests.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l webroot -r -d 'Specify a <file> to use as a \'web root\' for validation in the ACME protocol.
Webroot is a mode in which the step process will write a challenge file to a
location being served by an existing fileserver in order to respond to ACME
challenge validation requests.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l contact -r -d 'The <email-address> used for contact as part of the ACME protocol. These contacts
may be used to warn of certificate expiration or other certificate lifetime events.
Use the \'--contact\' flag multiple times to configure multiple contacts.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l http-listen -r -d 'Use a non-standard http <address>, behind a reverse proxy or load balancer, for
serving ACME challenges. The default address is :80, which requires super user
(sudo) privileges. This flag must be used in conjunction with the \'--standalone\'
flag.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l k8ssa-token-path -r -d 'Configure the <file> from which to read the kubernetes service account token.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'rekey' -d 'rekey a certificate'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l out-cert -r -d 'The <file> where the new certificate will be saved to.
Defaults to overwriting the <crt-file> positional argument.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l out-key -r -d 'The <file> to store the new private key.
Defaults to overwriting the <key-file> positional argument.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l private-key -r -d 'The <file> containing the private key for rekey-ing the certificate.
By default, a new random key pair will be generated.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l expires-in -r -d 'The amount of time remaining before certificate expiration,
at which point a rekey should be attempted. The certificate rekey will not
be performed if the time to expiration is greater than the **--expires-in** value.
A random jitter (duration/20) will be added to avoid multiple services hitting the
rekey endpoint at the same time. The <duration> is a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l pid -r -d 'The process id to signal after the certificate has been rekeyed. By default the
the SIGHUP (1) signal will be used, but this can be configured with the **--signal**
flag.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l pid-file -r -d 'The <file> from which to read the process id that will be signaled after the certificate
has been rekeyed. By default the SIGHUP (1) signal will be used, but this can be configured with the **--signal**
flag.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l signal -r -d 'The signal <number> to send to the selected PID, so it can reload the
configuration and load the new certificate. Default value is SIGHUP (1)'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l exec -r -d 'The <command> to run after the certificate has been rekeyed.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l daemon -d 'Run the rekey command as a daemon, rekeying and overwriting the certificate
periodically. By default the daemon will rekey a certificate before 2/3 of the
time to expiration has elapsed. The period can be configured using the
**--rekey-period** or **--expires-in** flags.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l rekey-period -r -d 'The period with which to schedule rekeying of the certificate in daemon mode.
Requires the **--daemon** flag. The <duration> is a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "1.5h", or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'renew' -d 'renew a certificate'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l mtls -d 'Use mTLS to renew a certificate. Use --mtls=false to force the token
authorization flow instead.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l out -s output-file -r -d 'The new certificate <file> path. Defaults to overwriting the <crt-file> positional argument'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l expires-in -r -d 'The amount of time remaining before certificate expiration,
at which point a renewal should be attempted. The certificate renewal will not
be performed if the time to expiration is greater than the **--expires-in** value.
A random jitter (duration/20) will be added to avoid multiple services hitting the
renew endpoint at the same time. The <duration> is a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l pid -r -d 'The process id to signal after the certificate has been renewed. By default the
the SIGHUP (1) signal will be used, but this can be configured with the **--signal**
flag.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l pid-file -r -d 'The <file> from which to read the process id that will be signaled after the certificate
has been renewed. By default the SIGHUP (1) signal will be used, but this can be configured with the **--signal**
flag.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l signal -r -d 'The signal <number> to send to the selected PID, so it can reload the
configuration and load the new certificate. Default value is SIGHUP (1)'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l exec -r -d 'The <command> to run after the certificate has been renewed.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l daemon -d 'Run the renew command as a daemon, renewing and overwriting the certificate
periodically. By default the daemon will renew a certificate before 2/3 of the
time to expiration has elapsed. The period can be configured using the
**--renew-period** or **--expires-in** flags.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l renew-period -r -d 'The period with which to schedule renewals of the certificate in daemon mode.
Requires the **--daemon** flag. The <duration> is a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "1.5h", or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'revoke' -d 'revoke a certificate'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l cert -r -d 'The <file> containing the cert that should be revoked.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l key -r -d 'The <file> containing the key corresponding to the cert that should be revoked.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l reason -r -d 'The <string> representing the reason for which the cert is being revoked.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l reasonCode -r -d 'The <reasonCode> specifies the reason for revocation - chose from a list of
common revocation reasons. If unset, the default is Unspecified.

: <reasonCode> can be a number from 0-9 or a case insensitive string matching
one of the following options:

    **Unspecified**
    :  No reason given (Default -- reasonCode=0).

    **KeyCompromise**
    :  The key is believed to have been compromised (reasonCode=1).

    **CACompromise**
    :  The issuing Certificate Authority itself has been compromised (reasonCode=2).

    **AffiliationChanged**
    :  The certificate contained affiliation information, for example, it may
have been an EV certificate and the associated business is no longer owned by
the same entity (reasonCode=3).

    **Superseded**
    :  The certificate is being replaced (reasonCode=4).

    **CessationOfOperation**
    :  If a CA is decommissioned, no longer to be used, the CA\'s certificate
should be revoked with this reason code. Do not revoke the CA\'s certificate if
the CA no longer issues new certificates, yet still publishes CRLs for the
currently issued certificates (reasonCode=5).

    **CertificateHold**
    :  A temporary revocation that indicates that a CA will not vouch for a
certificate at a specific point in time. Once a certificate is revoked with a
CertificateHold reason code, the certificate can then be revoked with another
Reason Code, or unrevoked and returned to use (reasonCode=6).

    **RemoveFromCRL**
    :  If a certificate is revoked with the CertificateHold reason code, it is
possible to "unrevoke" a certificate. The unrevoking process still lists the
certificate in the CRL, but with the reason code set to RemoveFromCRL.
Note: This is specific to the CertificateHold reason and is only used in DeltaCRLs
(reasonCode=8).

    **PrivilegeWithdrawn**
    :  The right to represent the given entity was revoked for some reason
(reasonCode=9).

    **AACompromise**
    :   It is known or suspected that aspects of the AA validated in the
attribute certificate have been compromised (reasonCode=10).
'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from provisioner' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'provisioner' -d 'create and manage the certificate authority provisioners'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'list' -d 'list provisioners configured in the CA'
complete -c step -n '__fish_seen_subcommand_from list' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from jwe-key' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'jwe-key' -d 'retrieve and print a provisioning key in the CA'
complete -c step -n '__fish_seen_subcommand_from jwe-key' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from jwe-key' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from jwe-key' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'add' -d 'add a provisioner'
complete -c step -n '__fish_seen_subcommand_from add' -f -l type -r -d 'The <type> of provisioner to create.

: <type> is a case-insensitive string and must be one of:

**JWK**
: Uses an JWK key pair to sign provisioning tokens. (default)

**OIDC**
: Uses an OpenID Connect provider to sign provisioning tokens.

**AWS**
: Uses Amazon AWS instance identity documents.

**GCP**
: Use Google instance identity tokens.

**Azure**
: Uses Microsoft Azure identity tokens.

**ACME**
: Uses the ACME protocol to create certificates.

**X5C**
: Uses an X509 certificate / private key pair to sign provisioning tokens.

**K8SSA**
: Uses Kubernetes Service Account tokens.

**SSHPOP**
: Uses an SSH certificate / private key pair to sign provisioning tokens.

**SCEP**
: Uses the SCEP protocol to create certificates.

**Nebula**
: Uses a Nebula certificate / private key pair to sign provisioning tokens.
'
complete -c step -n '__fish_seen_subcommand_from add' -f -l public-key -r -d 'The <file> containing the JWK public key. Or, a <file>
containing one or more PEM formatted keys, if used with the K8SSA provisioner.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l create -d 'Create the JWK key pair for the provisioner.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l private-key -r -d 'The <file> containing the JWK private key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l client-id -r -d 'The <id> used to validate the audience in an OpenID Connect token.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l client-secret -r -d 'The <secret> used to obtain the OpenID Connect tokens.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l listen-address -r -d 'The callback <address> used in the OpenID Connect flow (e.g. \":10000\")'
complete -c step -n '__fish_seen_subcommand_from add' -f -l configuration-endpoint -r -d 'OpenID Connect configuration <url>.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin -r -d 'The <email> of an admin user in an OpenID Connect provisioner, this user
will not have restrictions in the certificates to sign. Use the
\'--admin\' flag multiple times to configure multiple administrators.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l domain -r -d 'The <domain> used to validate the email claim in an OpenID Connect provisioner.
Use the \'--domain\' flag multiple times to configure multiple domains.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l group -r -d 'The <group> list used to validate the groups extension in an OpenID Connect token.
Use the \'--group\' flag multiple times to configure multiple groups.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l tenant-id -r -d 'The <tenant-id> used to replace the templatized tenantid value in the OpenID Configuration.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x5c-roots -s x5c-root -r -d 'PEM-formatted root certificate(s) <file> used to validate the signature on X5C
provisioning tokens.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l nebula-root -r -d 'Root certificate (chain) <file> used to validate the signature on Nebula
provisioning tokens.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l require-eab -d 'Require (and enable) External Account Binding (EAB) for Account creation.
If this flag is set to false, then disable EAB.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l force-cn -d 'Always set the common name in provisioned certificates.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l challenge -r -d 'With a SCEP provisioner the <challenge> is a shared secret between a
client and the CA.

With an ACME provisioner, this flag specifies the <challenge> or challenges to
enable. Use the flag multiple times to configure multiple challenges.

The supported ACME challenges are:

**http-01**
: With the HTTP challenge, the client in an ACME transaction proves its control
over a domain name by proving that it can provision HTTP resources on a server
accessible under that domain name.

**dns-01**
: With the DNS challenge, the client can prove control of a domain by
provisioning a TXT resource record containing a designated value for a specific
validation domain name.

**tls-alpn-01**
: With the TLS with Application-Layer Protocol Negotiation (TLS ALPN) challenge,
the client can prove control over a domain name by configuring a TLS server to
respond to specific connection attempts using the ALPN extension with
identifying information.

**device-attest-01**
: With the device attestation challenge, the client can prove control over a
permanent identifier of a device by providing an attestation statement
containing the identifier of the device.

If the provisioner has no challenges configured, http-01, dns-01 and tls-alpn-01
will be automatically enabled.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l attestation-format -r -d 'Enable an ACME attestation statement <format> in the provisioner. Use the flag
multiple times to configure multiple challenges.

The supported ACME attestation formats are:

**apple**
: With the apple format, Apple devices can use the device-attest-01 challenge to
get a new certificate.

**step**
: With the step format, devices like YubiKeys that can generate an attestation
certificate can use the device-attest-01 challenge to get a new certificate.

**tpm**
: With the tpm format, devices with TPMs can use the device-attest-01 challenge
to get a new certificate.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l attestation-roots -r -d 'PEM-formatted root certificate(s) <file> used to validate the attestation
certificates. Use the flag multiple times to read from multiple files.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l capabilities -r -d 'The SCEP <capabilities> to advertise'
complete -c step -n '__fish_seen_subcommand_from add' -f -l include-root -d 'Include the CA root certificate in the SCEP CA certificate chain'
complete -c step -n '__fish_seen_subcommand_from add' -f -l exclude-intermediate -d 'Exclude the CA intermediate certificate in the SCEP CA certificate chain'
complete -c step -n '__fish_seen_subcommand_from add' -f -l min-public-key-length -r -d 'The minimum public key <length> of the SCEP RSA encryption key'
complete -c step -n '__fish_seen_subcommand_from add' -f -l encryption-algorithm-identifier -r -d 'The <id> for the SCEP encryption algorithm to use.
		Valid values are 0 - 4, inclusive. The values correspond to:
		0: DES-CBC,
		1: AES-128-CBC,
		2: AES-256-CBC,
		3: AES-128-GCM,
		4: AES-256-GCM.
		Defaults to DES-CBC (0) for legacy clients.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l scep-decrypter-certificate-file -r -d 'The path to a PEM certificate <file> for the SCEP decrypter'
complete -c step -n '__fish_seen_subcommand_from add' -f -l scep-decrypter-key-file -r -d 'The path to a PEM private key <file> for the SCEP decrypter'
complete -c step -n '__fish_seen_subcommand_from add' -f -l scep-decrypter-key-uri -r -d 'The key <uri> for the SCEP decrypter. Should be a valid value for the KMS type used.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l scep-decrypter-key-password-file -r -d 'The path to a <file> containing the password for the SCEP decrypter key'
complete -c step -n '__fish_seen_subcommand_from add' -f -l aws-account -r -d 'The AWS account <id> used to validate the identity documents.
Use the flag multiple times to configure multiple accounts.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l azure-tenant -r -d 'The Microsoft Azure tenant <id> used to validate the identity tokens.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l azure-resource-group -r -d 'The Microsoft Azure resource group <name> used to validate the identity tokens.
Use the flag multiple times to configure multiple resource groups'
complete -c step -n '__fish_seen_subcommand_from add' -f -l azure-audience -r -d 'The Microsoft Azure audience <name> used to validate the identity tokens.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l azure-subscription-id -r -d 'The Microsoft Azure subscription <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple subscription IDs'
complete -c step -n '__fish_seen_subcommand_from add' -f -l azure-object-id -r -d 'The Microsoft Azure AD object <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple object IDs'
complete -c step -n '__fish_seen_subcommand_from add' -f -l gcp-service-account -r -d 'The Google service account <email> or <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple service accounts.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l gcp-project -r -d 'The Google project <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple projects'
complete -c step -n '__fish_seen_subcommand_from add' -f -l instance-age -r -d 'The maximum <duration> to grant a certificate in AWS and GCP provisioners.
A <duration> is sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-custom-sans -d 'On cloud provisioners, if enabled only the internal DNS and IP will be added as a SAN.
By default it will accept any SAN in the CSR.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-trust-on-first-use -s disable-tofu -d 'On cloud provisioners, if enabled multiple sign request for this provisioner
with the same instance will be accepted. By default only the first request
will be accepted.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-ssh-ca-user -d 'Disable ability to sign SSH user certificates'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-ssh-ca-host -d 'Disable ability to sign SSH host certificates'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x509-template -r -d 'The x509 certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x509-template-data -r -d 'The x509 certificate template data <file>, a JSON map of data that can be used by the certificate template.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-template -r -d 'The x509 certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-template-data -r -d 'The ssh certificate template data <file>, a JSON map of data that can be used by the certificate template.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x509-min-dur -r -d 'The minimum <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x509-max-dur -r -d 'The maximum <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l x509-default-dur -r -d 'The default <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-user-min-dur -r -d 'The minimum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-user-max-dur -r -d 'The maximum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-user-default-dur -r -d 'The maximum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-host-min-dur -r -d 'The minimum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-host-max-dur -r -d 'The maximum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh-host-default-dur -r -d 'The maximum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-renewal -d 'Disable renewal for all certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l allow-renewal-after-expiry -d 'Allow renewals for expired certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-smallstep-extensions -d 'Disable the Smallstep extension for all certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ssh -d 'Enable provisioning of ssh certificates. The default value is true. To
disable ssh use \'--ssh=false\'.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'update' -d 'update a provisioner'
complete -c step -n '__fish_seen_subcommand_from update' -f -l name -r -d 'The new <name> for the provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l public-key -r -d 'The <file> containing the JWK public key. Or, a <file>
containing one or more PEM formatted keys, if used with the K8SSA provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l create -d 'Create the JWK key pair for the provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l private-key -r -d 'The <file> containing the JWK private key.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l client-id -r -d 'The <id> used to validate the audience in an OpenID Connect token.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l client-secret -r -d 'The <secret> used to obtain the OpenID Connect tokens.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l listen-address -r -d 'The callback <address> used in the OpenID Connect flow (e.g. \":10000\")'
complete -c step -n '__fish_seen_subcommand_from update' -f -l configuration-endpoint -r -d 'OpenID Connect configuration <url>.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin -r -d 'The <email> of an admin user in an OpenID Connect provisioner, this user
will not have restrictions in the certificates to sign. Use the
\'--admin\' flag multiple times to configure multiple administrators.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-admin -r -d 'Remove the <email> of an admin user in an OpenID Connect provisioner, this user
will not have restrictions in the certificates to sign. Use the
\'--remove-admin\' flag multiple times to remove multiple administrators.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l domain -r -d 'The <domain> used to validate the email claim in an OpenID Connect provisioner.
Use the \'--domain\' flag multiple times to configure multiple domains.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-domain -r -d 'Remove the <domain> used to validate the email claim in an OpenID Connect provisioner.
Use the \'--remove-domain\' flag multiple times to remove multiple domains.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l group -r -d 'The <group> list used to validate the groups extension in an OpenID Connect token.
Use the \'--group\' flag multiple times to configure multiple groups.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l tenant-id -r -d 'The <tenant-id> used to replace the templatized tenantid value in the OpenID Configuration.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l scope -r -d 'The <scope> list used to validate the scopes extension in an OpenID Connect token.
Use the \'--scope\' flag multiple times to configure multiple scopes.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-scope -r -d 'Remove the <scope> used to validate the scopes extension in an OpenID Connect token.
Use the \'--remove-scope\' flag multiple times to remove multiple scopes.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l auth-param -r -d 'The <auth-param> list used to validate the auth-params extension in an OpenID Connect token.
Use the \'--auth-param\' flag multiple times to configure multiple auth-params.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x5c-roots -s x5c-root -r -d 'PEM-formatted root certificate(s) <file> used to validate the signature on X5C
provisioning tokens.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l nebula-root -r -d 'Root certificate (chain) <file> used to validate the signature on Nebula
provisioning tokens.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l require-eab -d 'Require (and enable) External Account Binding (EAB) for Account creation.
If this flag is set to false, then disable EAB.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l force-cn -d 'Always set the common name in provisioned certificates.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l challenge -r -d 'With a SCEP provisioner the <challenge> is a shared secret between a
client and the CA.

With an ACME provisioner, this flag specifies the <challenge> or challenges to
enable. Use the flag multiple times to configure multiple challenges.

The supported ACME challenges are:

**http-01**
: With the HTTP challenge, the client in an ACME transaction proves its control
over a domain name by proving that it can provision HTTP resources on a server
accessible under that domain name.

**dns-01**
: With the DNS challenge, the client can prove control of a domain by
provisioning a TXT resource record containing a designated value for a specific
validation domain name.

**tls-alpn-01**
: With the TLS with Application-Layer Protocol Negotiation (TLS ALPN) challenge,
the client can prove control over a domain name by configuring a TLS server to
respond to specific connection attempts using the ALPN extension with
identifying information.

**device-attest-01**
: With the device attestation challenge, the client can prove control over a
permanent identifier of a device by providing an attestation statement
containing the identifier of the device.

If the provisioner has no challenges configured, http-01, dns-01 and tls-alpn-01
will be automatically enabled.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-challenge -r -d 'Remove an ACME <challenge> from the list configured in the provisioner.
Use the flag multiple times to remove multiple challenges.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l attestation-format -r -d 'Enable an ACME attestation statement <format> in the provisioner. Use the flag
multiple times to configure multiple challenges.

The supported ACME attestation formats are:

**apple**
: With the apple format, Apple devices can use the device-attest-01 challenge to
get a new certificate.

**step**
: With the step format, devices like YubiKeys that can generate an attestation
certificate can use the device-attest-01 challenge to get a new certificate.

**tpm**
: With the tpm format, devices with TPMs can use the device-attest-01 challenge
to get a new certificate.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-attestation-format -r -d 'Remove an ACME attestation statement <format> from the list configured in the provisioner.
Use the flag multiple times to remove multiple formats.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l attestation-roots -r -d 'PEM-formatted root certificate(s) <file> used to validate the attestation
certificates. Use the flag multiple times to read from multiple files.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l capabilities -r -d 'The SCEP <capabilities> to advertise'
complete -c step -n '__fish_seen_subcommand_from update' -f -l include-root -d 'Include the CA root certificate in the SCEP CA certificate chain'
complete -c step -n '__fish_seen_subcommand_from update' -f -l exclude-intermediate -d 'Exclude the CA intermediate certificate in the SCEP CA certificate chain'
complete -c step -n '__fish_seen_subcommand_from update' -f -l min-public-key-length -r -d 'The minimum public key <length> of the SCEP RSA encryption key'
complete -c step -n '__fish_seen_subcommand_from update' -f -l encryption-algorithm-identifier -r -d 'The <id> for the SCEP encryption algorithm to use.
		Valid values are 0 - 4, inclusive. The values correspond to:
		0: DES-CBC,
		1: AES-128-CBC,
		2: AES-256-CBC,
		3: AES-128-GCM,
		4: AES-256-GCM.
		Defaults to DES-CBC (0) for legacy clients.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l scep-decrypter-certificate-file -r -d 'The path to a PEM certificate <file> for the SCEP decrypter'
complete -c step -n '__fish_seen_subcommand_from update' -f -l scep-decrypter-key-file -r -d 'The path to a PEM private key <file> for the SCEP decrypter'
complete -c step -n '__fish_seen_subcommand_from update' -f -l scep-decrypter-key-uri -r -d 'The key <uri> for the SCEP decrypter. Should be a valid value for the KMS type used.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l scep-decrypter-key-password-file -r -d 'The path to a <file> containing the password for the SCEP decrypter key'
complete -c step -n '__fish_seen_subcommand_from update' -f -l aws-account -r -d 'The AWS account <id> used to validate the identity documents.
Use the flag multiple times to configure multiple accounts.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-aws-account -r -d 'Remove an AWS account <id> used to validate the identity documents.
Use the flag multiple times to remove multiple accounts.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l azure-tenant -r -d 'The Microsoft Azure tenant <id> used to validate the identity tokens.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l azure-resource-group -r -d 'The Microsoft Azure resource group <name> used to validate the identity tokens.
Use the flag multiple times to configure multiple resource groups'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-azure-resource-group -r -d 'Remove a Microsoft Azure resource group <name> used to validate the identity tokens.
Use the flag multiple times to configure multiple resource groups'
complete -c step -n '__fish_seen_subcommand_from update' -f -l azure-audience -r -d 'The Microsoft Azure audience <name> used to validate the identity tokens.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l azure-subscription-id -r -d 'The Microsoft Azure subscription <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple subscription IDs'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-azure-subscription-id -r -d 'Remove a Microsoft Azure subscription <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple subscription IDs'
complete -c step -n '__fish_seen_subcommand_from update' -f -l azure-object-id -r -d 'The Microsoft Azure AD object <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple object IDs'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-azure-object-id -r -d 'Remove a Microsoft Azure AD object <id> used to validate the identity tokens.
Use the flag multiple times to remove multiple object IDs'
complete -c step -n '__fish_seen_subcommand_from update' -f -l gcp-service-account -r -d 'The Google service account <email> or <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple service accounts.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-gcp-service-account -r -d 'Remove a Google service account <email> or <id> used to validate the identity tokens.
Use the flag multiple times to remove multiple service accounts.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l gcp-project -r -d 'The Google project <id> used to validate the identity tokens.
Use the flag multiple times to configure multiple projects'
complete -c step -n '__fish_seen_subcommand_from update' -f -l remove-gcp-project -r -d 'Remove a Google project <id> used to validate the identity tokens.
Use the flag multiple times to remove multiple projects'
complete -c step -n '__fish_seen_subcommand_from update' -f -l instance-age -r -d 'The maximum <duration> to grant a certificate in AWS and GCP provisioners.
A <duration> is sequence of decimal numbers, each with optional fraction and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-custom-sans -d 'On cloud provisioners, if enabled only the internal DNS and IP will be added as a SAN.
By default it will accept any SAN in the CSR.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-trust-on-first-use -s disable-tofu -d 'On cloud provisioners, if enabled multiple sign request for this provisioner
with the same instance will be accepted. By default only the first request
will be accepted.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-ssh-ca-user -d 'Disable ability to sign SSH user certificates'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-ssh-ca-host -d 'Disable ability to sign SSH host certificates'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x509-template -r -d 'The x509 certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x509-template-data -r -d 'The x509 certificate template data <file>, a JSON map of data that can be used by the certificate template.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-template -r -d 'The x509 certificate template <file>, a JSON representation of the certificate to create.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-template-data -r -d 'The ssh certificate template data <file>, a JSON map of data that can be used by the certificate template.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x509-min-dur -r -d 'The minimum <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x509-max-dur -r -d 'The maximum <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l x509-default-dur -r -d 'The default <duration> for an x509 certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-user-min-dur -r -d 'The minimum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-user-max-dur -r -d 'The maximum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-user-default-dur -r -d 'The maximum <duration> for an ssh user certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-host-min-dur -r -d 'The minimum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-host-max-dur -r -d 'The maximum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh-host-default-dur -r -d 'The maximum <duration> for an ssh host certificate generated by this provisioner.
Value must be a sequence of decimal numbers, each with optional fraction, and a
unit suffix, such as "300ms", "-1.5h" or "2h45m". Valid time units are "ns",
"us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-renewal -d 'Disable renewal for all certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l allow-renewal-after-expiry -d 'Allow renewals for expired certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-smallstep-extensions -d 'Disable the Smallstep extension for all certificates generated by this provisioner.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ssh -d 'Enable provisioning of ssh certificates. The default value is true. To
disable ssh use \'--ssh=false\'.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'remove' -d 'remove a provisioner from the CA configuration'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from webhook' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'webhook' -d 'create and manage webhooks for a provisioner'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from webhook' -a 'add' -d 'add a webhook to a provisioner'
complete -c step -n '__fish_seen_subcommand_from add' -f -l url -r -d 'The url of the webhook server.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l kind -r -d 'The kind of webhook. Default is ENRICHING.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l bearer-token-file -r -d 'The token to be set in the Authorization header of the request to the webhook server.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l basic-auth-username -r -d 'The username portion of the Authorization header of the request to the webhook server when using basic authentication.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l basic-auth-password-file -r -d 'The password porition of the Authorization header of the request to the webhook server when using basic authentication.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l disable-tls-client-auth -d 'The CA will not send a client certificate when requested by the webhook server.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l cert-type -r -d 'Whether to call this webhook when signing X509 certificates, SSH certificates, or ALL certificates. Default is ALL.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from webhook' -a 'update' -d 'update a webhook attached to a provisioner'
complete -c step -n '__fish_seen_subcommand_from update' -f -l url -r -d 'The url of the webhook server.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l kind -r -d 'The kind of webhook. Default is ENRICHING.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l bearer-token-file -r -d 'The token to be set in the Authorization header of the request to the webhook server.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l basic-auth-username -r -d 'The username portion of the Authorization header of the request to the webhook server when using basic authentication.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l basic-auth-password-file -r -d 'The password porition of the Authorization header of the request to the webhook server when using basic authentication.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l disable-tls-client-auth -d 'The CA will not send a client certificate when requested by the webhook server.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l cert-type -r -d 'Whether to call this webhook when signing X509 certificates, SSH certificates, or ALL certificates. Default is ALL.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from webhook' -a 'remove' -d 'remove a webhook from a provisioner'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'sign' -d 'generate a new certificate from signing a certificate request'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l not-before -r -d 'The <time|duration> when the certificate validity period starts. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l not-after -r -d 'The <time|duration> when the certificate validity period ends. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt or decrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l x5c-chain -r -d 'Certificate <file>, in PEM format'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l nebula-cert -r -d 'Certificate <file> in PEM format to store in the \'nebula\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l nebula-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'nebula\' header.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l acme -r -d 'ACME directory <url> to be used for requesting certificates via the ACME protocol.
Use this flag to define an ACME server other than the Step CA. If this flag is
absent and an ACME provisioner has been selected then the \'--ca-url\' flag must be defined.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l standalone -d 'Get a certificate using the ACME protocol and standalone mode for validation.
Standalone is a mode in which the step process will run a server that will
will respond to ACME challenge validation requests. Standalone is the default
mode for serving challenge validation requests.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l webroot -r -d 'Specify a <file> to use as a \'web root\' for validation in the ACME protocol.
Webroot is a mode in which the step process will write a challenge file to a
location being served by an existing fileserver in order to respond to ACME
challenge validation requests.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l contact -r -d 'The <email-address> used for contact as part of the ACME protocol. These contacts
may be used to warn of certificate expiration or other certificate lifetime events.
Use the \'--contact\' flag multiple times to configure multiple contacts.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l http-listen -r -d 'Use a non-standard http <address>, behind a reverse proxy or load balancer, for
serving ACME challenges. The default address is :80, which requires super user
(sudo) privileges. This flag must be used in conjunction with the \'--standalone\'
flag.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l k8ssa-token-path -r -d 'Configure the <file> from which to read the kubernetes service account token.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from sign' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from root' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'root' -d 'download and validate the root certificate'
complete -c step -n '__fish_seen_subcommand_from root' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from root' -f -l fingerprint -r -d 'The <fingerprint> of the targeted root certificate.'
complete -c step -n '__fish_seen_subcommand_from root' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from root' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from roots' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'roots' -d 'download all the root certificates'
complete -c step -n '__fish_seen_subcommand_from roots' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from roots' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from roots' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from roots' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from federation' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'federation' -d 'download all the federated certificates'
complete -c step -n '__fish_seen_subcommand_from federation' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from federation' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from federation' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from federation' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from acme' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'acme' -d 'manage ACME settings'
complete -c step -n '__fish_seen_subcommand_from eab' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from acme' -a 'eab' -d 'create and manage ACME External Account Binding Keys'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'list' -d 'list all ACME External Account Binding Keys'
complete -c step -n '__fish_seen_subcommand_from list' -f -l limit -r -d 'The number of entities to return per (paging) API request.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l no-pager -d 'Disables usage of $PAGER for paging purposes'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'add' -d 'add ACME External Account Binding Key'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'remove' -d 'remove an ACME EAB Key from the CA'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from policy' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'policy' -d 'manage certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from authority' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from policy' -a 'authority' -d 'manage certificate issuance policies for authorities'
complete -c step -n '__fish_seen_subcommand_from view' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from authority' -a 'view' -d 'view current certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from view' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from authority' -a 'remove' -d 'remove certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from x509' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from authority' -a 'x509' -d 'manage X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'allow' -d 'manage allowed names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'deny' -d 'manage denied names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from wildcards' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'wildcards' -d 'manage wildcard name settings for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'allow' -d 'allow wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'deny' -d 'deny wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ssh' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from authority' -a 'ssh' -d 'manage SSH certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from host' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'host' -d 'manage SSH host certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from host' -a 'allow' -d 'manage allowed SSH host certificate principals'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from host' -a 'deny' -d 'manage denied dSSH host certificate principals'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from user' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'user' -d 'manage SSH user certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from user' -a 'allow' -d 'manage allowed SSH user certificate principals'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from user' -a 'deny' -d 'manage denied SSH user certificate principals'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from provisioner' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from policy' -a 'provisioner' -d 'manage certificate issuance policies for provisioners'
complete -c step -n '__fish_seen_subcommand_from view' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'view' -d 'view current certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from view' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'remove' -d 'remove certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from x509' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'x509' -d 'manage X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'allow' -d 'manage allowed names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'deny' -d 'manage denied names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from wildcards' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'wildcards' -d 'manage wildcard name settings for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'allow' -d 'allow wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'deny' -d 'deny wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ssh' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from provisioner' -a 'ssh' -d 'manage SSH certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from host' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'host' -d 'manage SSH host certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from host' -a 'allow' -d 'manage allowed SSH host certificate principals'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from host' -a 'deny' -d 'manage denied dSSH host certificate principals'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from user' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'user' -d 'manage SSH user certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from user' -a 'allow' -d 'manage allowed SSH user certificate principals'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from user' -a 'deny' -d 'manage denied SSH user certificate principals'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'principal' -d 'add or remove principals'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l remove -d 'removes the provided Principals from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from principal' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from acme' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from policy' -a 'acme' -d 'manage certificate issuance policies for ACME accounts.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from acme' -a 'view' -d 'view current certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from view' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from view' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from acme' -a 'remove' -d 'remove certificate issuance policy'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from x509' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from acme' -a 'x509' -d 'manage X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'allow' -d 'manage allowed names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from allow' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'deny' -d 'manage denied names for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'cn' -d 'add or remove common names'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l remove -d 'removes the provided Common Names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from cn' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'dns' -d 'add or remove DNS domains'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l remove -d 'removes the provided DNS names from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from dns' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'email' -d 'add or remove email addresses'
complete -c step -n '__fish_seen_subcommand_from email' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l remove -d 'removes the provided emails from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from email' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'ip' -d 'add or remove ip addresses'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l remove -d 'removes the provided IPs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from ip' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from deny' -a 'uri' -d 'add or remove URI domains'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l remove -d 'removes the provided URIs from the policy instead of adding them'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from uri' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from wildcards' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from x509' -a 'wildcards' -d 'manage wildcard name settings for X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'allow' -d 'allow wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from allow' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from wildcards' -a 'deny' -d 'deny wildcard names in X.509 certificate issuance policies'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l provisioner -r -d 'The provisioner <name>'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-id -r -d 'An ACME EAB Key ID.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l eab-key-reference -r -d 'An ACME EAB Key Reference.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from deny' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from admin' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'admin' -d 'create and manage the certificate authority admins'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from admin' -a 'list' -d 'list all admins in the CA configuration'
complete -c step -n '__fish_seen_subcommand_from list' -f -l super -d 'Only return super-admins.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l provisioner -r -d 'The provisioner <name> by which to filter admins.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from admin' -a 'add' -d 'add an admin to the CA configuration'
complete -c step -n '__fish_seen_subcommand_from add' -f -l super -d 'Give administrator SuperAdmin privileges.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from admin' -a 'remove' -d 'remove an admin from the CA configuration'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l provisioner -r -d 'The provisioner <name> by which to filter admins.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from admin' -a 'update' -d 'update an admin'
complete -c step -n '__fish_seen_subcommand_from update' -f -l super -d 'Update the admin with super-admin privileges.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l provisioner -r -d 'The provisioner <name> by which to filter admins.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from update' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from beta' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'beta' -d 'commands that are being tested; these APIs are likely to change'
complete -c step -n '__fish_seen_subcommand_from ca' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from beta' -a 'ca' -d 'commands that are made available for testing new features and APIs'
complete -c step -n '__fish_seen_subcommand_from acme' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ca' -a 'acme' -d 'manage ACME settings'
complete -c step -n '__fish_seen_subcommand_from eab' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from acme' -a 'eab' -d 'create and manage ACME External Account Binding Keys'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'list' -d 'list all ACME External Account Binding Keys'
complete -c step -n '__fish_seen_subcommand_from list' -f -l limit -r -d 'The number of entities to return per (paging) API request.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l no-pager -d 'Disables usage of $PAGER for paging purposes'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'add' -d 'add ACME External Account Binding Key'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from add' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from eab' -a 'remove' -d 'remove an ACME EAB Key from the CA'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-cert -r -d 'Admin certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the admin certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-subject -s admin-name -r -d 'The admin <subject> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-provisioner -s admin-issuer -r -d 'The provisioner <name> to use for generating admin credentials.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l admin-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from remove' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from ssh' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_step_no_subcommand' -a 'ssh' -d 'create and manage ssh certificates'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'certificate' -d 'sign a SSH certificate using the SSH CA'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l not-before -r -d 'The <time|duration> when the certificate validity period starts. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l not-after -r -d 'The <time|duration> when the certificate validity period ends. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l add-user -d 'Create a user provisioner certificate used to create a new user.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l host -d 'Create a host certificate instead of a user certificate.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l host-id -r -d 'Specify a <UUID> to identify the host rather than using an auto-generated UUID.
		If "machine" is passed, derive a UUID from "/etc/machine-id."'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l password-file -r -d 'The path to the <file> containing the password to encrypt the private key.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l principal -s n -r -d 'Add the specified principal (user or host <name>s) to the certificate request.
		This flag can be used multiple times. However, it cannot be used in conjunction
		with \'--token\' when requesting certificates from OIDC, JWK, and X5C provisioners, or
		from any provisioner with \'disableCustomSANs\' set to \'true\'. These provisioners will
		use the contents of the token to determine the principals.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l private-key -r -d 'When signing an existing public key, use this flag to specify the corresponding
private key so that the pair can be added to an SSH Agent.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
		generating key.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l sign -d 'Sign the public key passed as an argument instead of creating one.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l comment -r -d 'The comment used when adding the certificate to an agent. Defaults to the subject if not provided.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l kms -r -d 'The <uri> to configure a Cloud KMS or an HSM.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'x5c\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'x5c\' header.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l x5c-chain -r -d 'Certificate <file>, in PEM format'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l nebula-cert -r -d 'Certificate <file> in PEM format to store in the \'nebula\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l nebula-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'nebula\' header.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l k8ssa-token-path -r -d 'Configure the <file> from which to read the kubernetes service account token.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l no-agent -d 'Do not add the generated certificate and associated private key to the SSH agent.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l min-password-length -r -d 'Set minimum required length for password used to encrypt private key. The default value is \'0\'. Values <=0 are interpreted as if no minimum value is set.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from certificate' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'check-host' -d 'checks if a certificate has been issued for a host'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l verbose -s v -d 'Return "true" or "false" in the terminal.'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from check-host' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'config' -d 'configures ssh to be used with certificates'
complete -c step -n '__fish_seen_subcommand_from config' -f -l host -d 'Configures a SSH server instead of a client.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l team -r -d 'The team <ID> used to bootstrap the environment.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l team-authority -r -d 'The <sub-domain> of the certificate authority to bootstrap. E.g., for an authority with
domain name \'certs.example-team.ca.smallstep.com\' the value would be \'certs\'.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l team-url -r -d 'The <url> step queries to retrieve initial team configuration. Only used with
the **--team** option. If the url contains <\<\>> placeholders, they are replaced with the team ID.
Replacing the authority-id section of the url is not supported with placeholders.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l roots -d 'Prints the public keys used to verify user or host certificates.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l federation -d 'Prints all the public keys in the federation. These keys are used to verify
user or host certificates'
complete -c step -n '__fish_seen_subcommand_from config' -f -l set -r -d 'The <key=value> used as a variable in the templates. Use the flag multiple
times to set multiple variables.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l dry-run -d 'Executes the command without changing any file.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from config' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l context -r -d 'The <name> of the context for the new authority.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l profile -r -d 'The <name> that will serve as the profile name for the context.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l authority -r -d 'The <name> that will serve as the authority name for the context.'
complete -c step -n '__fish_seen_subcommand_from config' -f -l no-context -d 'Do not apply context specific environment for this command.'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'fingerprint' -d 'print the fingerprint of an SSH public key or certificate'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l format -r -d 'The <format> of the fingerprint, it must be "hex", "base64", "base64-url", "base64-raw", "base64-url-raw" or "emoji".'
complete -c step -n '__fish_seen_subcommand_from fingerprint' -f -l certificate -d 'Include SSH certificate bytes in fingerprint'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'hosts' -d 'returns a list of all valid hosts'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from hosts' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'inspect' -d 'print the contents of an ssh certificate'
complete -c step -n '__fish_seen_subcommand_from inspect' -f -l format -r -d 'The output format for printing the introspection details.

: <format> is a string and must be one of:

    **text**
    :  Print output in unstructured text suitable for a human to read.

    **json**
    :  Print output in JSON format.'
complete -c step -n '__fish_seen_subcommand_from list' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'list' -d 'list public keys known to the ssh agent'
complete -c step -n '__fish_seen_subcommand_from list' -f -l raw -d 'List public keys instead of fingerprints.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'login' -d 'adds a SSH certificate into the authentication agent'
complete -c step -n '__fish_seen_subcommand_from login' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l add-user -d 'Create a user provisioner certificate used to create a new user.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l principal -s n -r -d 'Add the specified principal (username) to the certificate request.
		This flag can be used multiple times. However, it cannot be used in conjunction
		with \'--token\' when requesting certificates from OIDC, JWK, and X5C provisioners, or
		from any provisioner with \'disableCustomSANs\' set to \'true\'. These provisioners will
		use the contents of the token to determine the principals.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l identity -r -d 'The certificate identity. It is usually passed as a positional argument, but a
flag exists so it can be configured in $STEPPATH/config/defaults.json.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l provisioner-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l not-before -r -d 'The <time|duration> when the certificate validity period starts. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from login' -f -l not-after -r -d 'The <time|duration> when the certificate validity period ends. If a <time> is
used it is expected to be in RFC 3339 format. If a <duration> is used, it is a
sequence of decimal numbers, each with optional fraction and a unit suffix, such
as "300ms", "-1.5h" or "2h45m". Valid time units are "ns", "us" (or "µs"), "ms",
"s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from login' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from login' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l comment -r -d 'The comment used when adding the certificate to an agent. Defaults to the subject if not provided.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l kty -r -d 'The <kty> to build the certificate upon.
If unset, default is EC.

: <kty> is a case-sensitive string and must be one of:

    **EC**
    :  Create an **elliptic curve** keypair

    **OKP**
    :  Create an octet key pair (for **"Ed25519"** curve)

    **RSA**
    :  Create an **RSA** keypair'
complete -c step -n '__fish_seen_subcommand_from login' -f -l crv -s curve -r -d 'The elliptic <curve> to use for EC and OKP key types. Corresponds
to the **"crv"** JWK parameter. Valid curves are defined in JWA [RFC7518]. If
unset, default is P-256 for EC keys and Ed25519 for OKP keys.

: <curve> is a case-sensitive string and must be one of:

		**P-256**
		:  NIST P-256 Curve

		**P-384**
		:  NIST P-384 Curve

		**P-521**
		:  NIST P-521 Curve

		**Ed25519**
		:  Ed25519 Curve'
complete -c step -n '__fish_seen_subcommand_from login' -f -l size -r -d 'The <size> (in bits) of the key for RSA and oct key types. RSA keys require a
minimum key size of 2048 bits. If unset, default is 2048 bits for RSA keys and 128 bits for oct keys.'
complete -c step -n '__fish_seen_subcommand_from login' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from logout' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'logout' -d 'removes a private key from the ssh-agent'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l all -d 'Removes all the keys stored in the SSH agent.'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l identity -r -d 'The certificate identity. It is usually passed as a positional argument, but a
flag exists so it can be configured in $STEPPATH/config/defaults.json.'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from logout' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'needs-renewal' -d 'Check if an SSH certificate needs to be renewed'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l expires-in -r -d 'Check if the certificate expires within the given time window
using <percent|duration>. If using <percent>, the input must be followed by a "%"
character. If using <duration>, the input must be a sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
complete -c step -n '__fish_seen_subcommand_from needs-renewal' -f -l verbose -s v -d 'Print human readable affirmation if certificate requires renewal.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'proxycommand' -d 'proxy ssh connections according to the host registry'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l provisioner-password-file -s password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
generating key.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l console -d 'Complete the flow while remaining inside the terminal.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from proxycommand' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'rekey' -d 'rekey a SSH certificate using the SSH CA'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l out -r -d 'The new key <file>. Defaults to overwriting the <ssh-key> positional argument.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
		generating key.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l no-password -d 'Do not ask for a password to encrypt a private key. Sensitive key material will
be written to disk unencrypted. This is not recommended. Requires **--insecure** flag.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l insecure
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l sshpop-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'sshpop\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l sshpop-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'sshpop\' header.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from rekey' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'renew' -d 'renew a SSH certificate using the SSH CA'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l out -s output-file -r -d 'The new certificate <file>. Defaults to overwriting the <ssh-cert> positional argument'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
		generating key.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l sshpop-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'sshpop\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l sshpop-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'sshpop\' header.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l f -s force -d 'Force the overwrite of files without asking.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from renew' -f -l context -r -d 'The context <name> to apply for the given command.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l help -s h -d 'show help'
complete -r -c step -n '__fish_seen_subcommand_from ssh' -a 'revoke' -d 'revoke a SSH certificate using the SSH CA'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l token -r -d 'The one-time <token> used to authenticate with the CA in order to create the
certificate.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l provisioner-password-file -r -d 'The path to the <file> containing the password to decrypt the one-time token
		generating key.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l provisioner -s issuer -r -d 'The provisioner <name> to use.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l set -r -d 'The <key=value> pair with template data variables. Use the **--set** flag multiple times to add multiple variables.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l set-file -r -d 'The JSON <file> with the template data variables.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l sshpop-cert -r -d 'Certificate (<chain>) in PEM format to store in the \'sshpop\' header of a JWT.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l sshpop-key -r -d 'Private key <file>, used to sign a JWT, corresponding to the certificate that will
be stored in the \'sshpop\' header.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l reason -r -d 'The <string> representing the reason for which the cert is being revoked.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l reasonCode -r -d 'The <reasonCode> specifies the reason for revocation - chose from a list of
common revocation reasons. If unset, the default is Unspecified.

: <reasonCode> can be a number from 0-9 or a case insensitive string matching
one of the following options:

    **Unspecified**
    :  No reason given (Default -- reasonCode=0).

    **KeyCompromise**
    :  The key is believed to have been compromised (reasonCode=1).

    **CACompromise**
    :  The issuing Certificate Authority itself has been compromised (reasonCode=2).

    **AffiliationChanged**
    :  The certificate contained affiliation information, for example, it may
have been an EV certificate and the associated business is no longer owned by
the same entity (reasonCode=3).

    **Superseded**
    :  The certificate is being replaced (reasonCode=4).

    **CessationOfOperation**
    :  If a CA is decommissioned, no longer to be used, the CA\'s certificate
should be revoked with this reason code. Do not revoke the CA\'s certificate if
the CA no longer issues new certificates, yet still publishes CRLs for the
currently issued certificates (reasonCode=5).

    **CertificateHold**
    :  A temporary revocation that indicates that a CA will not vouch for a
certificate at a specific point in time. Once a certificate is revoked with a
CertificateHold reason code, the certificate can then be revoked with another
Reason Code, or unrevoked and returned to use (reasonCode=6).

    **RemoveFromCRL**
    :  If a certificate is revoked with the CertificateHold reason code, it is
possible to "unrevoke" a certificate. The unrevoking process still lists the
certificate in the CRL, but with the reason code set to RemoveFromCRL.
Note: This is specific to the CertificateHold reason and is only used in DeltaCRLs
(reasonCode=8).

    **PrivilegeWithdrawn**
    :  The right to represent the given entity was revoked for some reason
(reasonCode=9).

    **AACompromise**
    :   It is known or suspected that aspects of the AA validated in the
attribute certificate have been compromised (reasonCode=10).
'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l offline -d 'Creates a certificate without contacting the certificate authority. Offline mode
uses the configuration, certificates, and keys created with **step ca init**,
but can accept a different configuration file using **--ca-config** flag.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l ca-config -r -d 'The certificate authority configuration <file>. Defaults to
$(step path)/config/ca.json'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l ca-url -r -d '<URI> of the targeted Step Certificate Authority.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l root -r -d 'The path to the PEM <file> used as the root certificate authority.'
complete -c step -n '__fish_seen_subcommand_from revoke' -f -l context -r -d 'The context <name> to apply for the given command.'
