--QUERY:
----------------------------------------------------------------------------------
--Add connection (id 1)
SELECT PQConnectdb('host=localhost dbname=template1 user=postgres');
--Add connection (id 2)
SELECT PQsetdbLogin('localhost','5432', '', '','template1','postgres','');
--Try to add invalid connection - must return 0
SELECT PQsetdbLogin('localhost','5432', '', '','template11','postgres','');


--Status of connections 1 i 2
SELECT PQStatus(1);
SELECT PQStatus(2);
SELECT PQStatusStr(1);
SELECT PQStatusStr(2);
--Status of invalid connection id must result with an error
SELECT PQStatusStr(10000);

--Reset the connection 2 and check if ok 
SELECT PQReset(2);
SELECT PQStatusStr(2);

--Finish connection 2 - after closing this connection, any call with this id must result with an error
SELECT PQFinish(2);
SELECT PQStatusStr(2);

--Some information about connection 1
SELECT PQdb (1);
SELECT PQuser (1);
SELECT PQpass (1);
SELECT PQhost (1);
SELECT PQport (1);
SELECT PQtty (1);
SELECT PQerrorMessage(1);
SELECT PQbackendPID (1);

--Create result id 1 and id 2
SELECT PQExec(1,'SELECT * FROM pg_database;');
SELECT PQExec(1,'SELECT * FROM pg_class;');
--Status of result id 1 and id 2
SELECT PQresStatus(PQresultStatus(1));
SELECT PQresStatus(PQresultStatus(2));
SELECT PQresultErrorMessage(1);

--Create bogus result (try to get error information)
SELECT PQExec(1,'SELECT * FROM pg_classXXX;');
SELECT PQresStatus(PQresultStatus(3));
SELECT PQresultErrorMessage(3);

--Now try to clear result 3, and get error information - must raise an error
SELECT PQClear(3);
SELECT PQresultErrorMessage(3);

--Escape string test
SELECT '\\' as original;
SELECT PQescapeString('\\') as escaped;

--Now try to get information about result id 1
SELECT PQntuples(1);
SELECT PQnfields(1);
SELECT PQfname(1,0);
SELECT PQfname(1,1);
SELECT PQfnumber(1,'datdba');
SELECT PQfnumber(1,'datname');
SELECT PQftype(1,0);
SELECT PQfsize(1,0);
SELECT PQfmod(1,0);
SELECT PQBinaryTuples(1);
SELECT PQgetvalue(1,0,0);
SELECT PQgetvalue(1,0,1);
SELECT PQgetisnull(1,0,0);
SELECt PQgetlength(1,0,0);
SELECT PQcmdStatus(1);
SELECT PQcmdTuples(1);
SELECT PQoidValue(1);
SELECT PQoidStatus(1);

--Now try to get information about invalid result - must raise error 
SELECT PQntuples(3);
SELECT PQnfields(3);
SELECT PQfname(3,0);
SELECT PQfname(3,1);
SELECT PQfnumber(3,'datdba');
SELECT PQfnumber(3,'datname');
SELECT PQftype(3,0);
SELECT PQfsize(3,0);
SELECT PQfmod(3,0);
SELECT PQBinaryTuples(3);
SELECT PQgetvalue(3,0,0);
SELECT PQgetvalue(3,0,1);
SELECT PQgetisnull(3,0,0);
SELECt PQgetlength(3,0,0);
SELECT PQcmdStatus(3);
SELECT PQcmdTuples(3);
SELECT PQoidValue(3);
SELECT PQoidStatus(3);

/*
--RESULTS:
----------------------------------------------------------------------------------

 pqconnectdb 
-------------
           1
(1 row)
 pqsetdblogin 
--------------
            2
(1 row)
 pqsetdblogin 
--------------
            0
(1 row)
 pqstatus 
----------
        0
(1 row)
 pqstatus 
----------
        0
(1 row)
  pqstatusstr  
---------------
 CONNECTION_OK
(1 row)
  pqstatusstr  
---------------
 CONNECTION_OK
(1 row)
ERROR:  dblink_pq_StatusStr: function called with invalid connection id
 pqreset 
---------
       0
(1 row)
  pqstatusstr  
---------------
 CONNECTION_OK
(1 row)
 pqfinish 
----------
        0
(1 row)
   pqdb    
-----------
 template1
(1 row)
 pquser 
--------
 postgres
(1 row)
 pqpass 
--------
 
(1 row)
ERROR:  dblink_pq_StatusStr: function called with invalid connection id
     pqhost     
----------------
 localhost
(1 row)
 pqport 
--------
 5432
(1 row)
 pqtty 
-------
 
(1 row)
 pqerrormessage 
----------------
 
(1 row)
 pqbackendpid 
--------------
        10976
(1 row)
 pqexec 
--------
      1
(1 row)
 pqexec 
--------
      2
(1 row)
   pqresstatus   
-----------------
 PGRES_TUPLES_OK
(1 row)
   pqresstatus   
-----------------
 PGRES_TUPLES_OK
(1 row)
 pqresulterrormessage 
----------------------
 
(1 row)
 pqexec 
--------
      3
(1 row)
    pqresstatus    
-------------------
 PGRES_FATAL_ERROR
(1 row)
              pqresulterrormessage              
------------------------------------------------
 ERROR:  Relation "pg_classxxx" does not exist
(1 row)
 pqclear 
---------
       0
(1 row)
ERROR:  dblink_pq_ResultErrorMessage: function called with invalid resource id
 original 
----------
 \
(1 row)
 escaped 
---------
 \\
(1 row)
 pqntuples 
-----------
         6
(1 row)
 pqnfields 
-----------
        11
(1 row)
 pqfname 
---------
 datname
(1 row)
 pqfname 
---------
 datdba
(1 row)
 pqfnumber 
-----------
         1
(1 row)
 pqfnumber 
-----------
         0
(1 row)
 pqftype 
---------
      19
(1 row)
 pqfsize 
---------
      64
(1 row)
 pqfmod 
--------
     -1
(1 row)
 pqbinarytuples 
----------------
              0
(1 row)
 pqgetvalue  
-------------
 app_setings
(1 row)
 pqgetvalue 
------------
 100
(1 row)
 pqgetisnull 
-------------
           0
(1 row)
 pqgetlength 
-------------
          11
(1 row)
 pqcmdstatus 
-------------
 SELECT
(1 row)
 pqcmdtuples 
-------------
           0
(1 row)
 pqoidvalue 
------------
          0
(1 row)
 pqoidstatus 
-------------
 
(1 row)
ERROR:  dblink_pq_Ntuples: function called with invalid resource id
ERROR:  dblink_pq_Nfields: function called with invalid resource id
ERROR:  dblink_pq_Fname: function called with invalid resource id
ERROR:  dblink_pq_Fname: function called with invalid resource id
ERROR:  dblink_pq_Fnumber: function called with invalid resource id
ERROR:  dblink_pq_Fnumber: function called with invalid resource id
ERROR:  dblink_pq_Ftype: function called with invalid resource id
ERROR:  dblink_pq_Fsize: function called with invalid resource id
ERROR:  dblink_pq_Fmod: function called with invalid resource id
ERROR:  dblink_pq_BinaryTuples: function called with invalid resource id
ERROR:  dblink_pq_GetValue: function called with invalid resource id
ERROR:  dblink_pq_GetValue: function called with invalid resource id
ERROR:  dblink_pq_Getisnull: function called with invalid resource id
ERROR:  dblink_pq_Getlength: function called with invalid resource id
ERROR:  dblink_pq_CmdStatus: function called with invalid resource id
ERROR:  dblink_pq_CmdTuples: function called with invalid resource id
ERROR:  dblink_pq_OidValue: function called with invalid resource id
ERROR:  dblink_pq_OidStatus: function called with invalid resource id
*/