
typedef	list<struct DnsRecord *>	DnsRecordsByDate;
typedef	DnsRecordsByDate::iterator	DnsRecordsByDateIter;
typedef	DnsRecordsByDate::reverse_iterator	DnsRecordsByDateReverseIter;

struct DnsRecord {
	struct in_addr ip_m;
	string	hostName_m;
	int	serial_m;
	time_t last_access_m;
	DnsRecordsByDateIter	byDate_m;
public:
	DnsRecord(struct in_addr ip, string& hostName, int serial, time_t last_access);
	DnsRecord(struct in_addr ip, string hostName);
    friend ostream& operator<<(ostream &os, const DnsRecord *cr) {
		os << "src " << inet_ntoa(cr->ip_m)
			<< " host " << cr->hostName_m
			<< " serial " << cr->serial_m
			<< " last " << ctime(&cr->last_access_m);
		return os;
	}
	friend class DnsCache;
};

struct CompareDnsRecord  {
    bool operator()(const DnsRecord *s1, const DnsRecord* s2) const {
		if (s1->ip_m.s_addr == s2->ip_m.s_addr) {
			return s1->hostName_m < s2->hostName_m;
		} else {
			return s1->ip_m.s_addr < s2->ip_m.s_addr;
		}
    }
};


typedef map<DnsRecord *, DnsRecord *, CompareDnsRecord> DnsRecordMap;
typedef DnsRecordMap::iterator DnsRecordMapIter;


class DnsCache {
	DnsRecordMap	ipToRecord_m;
	DnsRecordsByDate	recordsByDate_m;
	int	expiryTime_m;
public:
	DnsCache(int expiryTime) : expiryTime_m(expiryTime) { }
	// find the host from the IP 
	int	FindHostFromIP(const struct in_addr& ip);
	int	ResolveDns(const struct in_addr& ip) {
		return FindHostFromIP(ip);
	}
	void FlushOld();
};
	

