%--------------------------------*-SLang-*--------------------------------
% wmark.sl
% Implements Windows style of marking - for Windows users
% Author: Luchesar Ionkov
%
% Modified By JED
% modified by mj olesen
%
% Holding down Shift key and using arrow keys selects text
% Delete Key cuts the block of text.
% Inserting a character will replace the block with the character.
% Yanking will replace the block with the text in the yank buffer

!if (is_defined ("Key_F1"))
  () = evalfile ("keydefs");

!if (is_defined ("Wmark_Del_Region_Exec_Funs"))
{
   variable Wmark_Del_Region_Exec_Funs = ",self_insert_cmd,yank,yp_yank";
}

!if (is_defined ("Wmark_Del_Region_Funs"))
{
   variable
     Wmark_Del_Region_Funs = strcat (",backward_delete_char_untabify,",
				     "delete_char_cmd,",
				     "backward_delete_char,");
}

static variable Wmark_Movement_Flag = 0;
static variable Wmark_Selection_Mode = 0;

static define wmark_prefix ()
{
   !if (is_visible_mark ()) push_visible_mark ();
   Wmark_Movement_Flag = 1;
}

static define wmark_suffix ()
{
   variable f, fstr;
   variable type;

   if (Wmark_Selection_Mode)
     return;

   Wmark_Selection_Mode = 1;

   do
     {
	update_sans_update_hook (1);

	forever
	  {
	     (type, f) = get_key_binding ();
	     if (f != NULL)
	       break;
	     beep ();
	  }

	if (strncmp (f, "wmark_", 6))
	  {
	     fstr = sprintf (",%s,", f);

	     if (is_substr (Wmark_Del_Region_Funs, fstr))
	       {
		  call ("kill_region");
		  break;
	       }

	     if (is_substr (Wmark_Del_Region_Exec_Funs, fstr))
	       del_region ();
	     else
	       Wmark_Selection_Mode = 0; % allow function to act on region

	     Wmark_Movement_Flag = 0;
	  }


	ERROR_BLOCK
	  _clear_error ();

	if (type)
	  call (f);
	else
	  eval (f);

	% Test to see whether or not function acted on region.
	if (not (Wmark_Selection_Mode) and is_visible_mark ())
	  pop_mark_0 ();
     }
   while (Wmark_Movement_Flag);

   Wmark_Selection_Mode = 0;
}

% regular functions
static define wmark (fun)
{
   variable mf = Wmark_Movement_Flag;

   ERROR_BLOCK
     {
	!if (mf)
	  pop_mark_0 ();
	Wmark_Movement_Flag = mf;
     }

   wmark_prefix ();
   @fun ();
   wmark_suffix ();
}

% internal functions - using `call'
static define wmark_call (fun)
{
   variable mf = Wmark_Movement_Flag;
   ERROR_BLOCK
     {
	!if (mf)
	  pop_mark_0 ();
	Wmark_Movement_Flag = mf;
     }

   wmark_prefix ();
   call (fun);
   wmark_suffix ();
}

% the various functions

define wmark_up () { wmark_call ("previous_line_cmd"); }
define wmark_down () { wmark_call ("next_line_cmd"); }
define wmark_left () { wmark_call ("previous_char_cmd"); }
define wmark_right () { wmark_call ("next_char_cmd"); }
define wmark_page_up () { wmark_call ("page_up"); }
define wmark_page_down () { wmark_call ("page_down"); }
define wmark_bol () { wmark (&bol); }
define wmark_eol () { wmark (&eol); }
define wmark_bob () { wmark (&bob); }
define wmark_eob () { wmark (&eob); }
define wmark_skip_word () { wmark (&skip_word); }
define wmark_bskip_word () { wmark (&bskip_word); }

setkey ("wmark_up",	Key_Shift_Up);	% S-Up
setkey ("wmark_down",	Key_Shift_Down);	% S-Down
setkey ("wmark_left",	Key_Shift_Left);	% S-Left
setkey ("wmark_right",	Key_Shift_Right);	% S-Right
setkey ("wmark_page_up", Key_Shift_PgUp);	% S-PageUp
setkey ("wmark_page_down",Key_Shift_PgDn);	% S-PageDown
setkey ("wmark_bol",	Key_Shift_Home);	% S-Home
setkey ("wmark_eol",	Key_Shift_End);	% S-End
setkey ("yank",		Key_Shift_Ins);	% S-Insert
setkey ("kill_region",	Key_Shift_Del);	% S-Delete
setkey ("copy_region",	Key_Ctrl_Ins);	% C-Insert
setkey ("del_region",	Key_Ctrl_Del);	% C-Delete

#ifndef IBMPC_SYSTEM
static define wmark_reset_display_hook ()
{
   tt_send("\e[?35h");
}

static define wmark_init_display_hook ()
{
   tt_send("\e[?35l");
}

$1 = getenv ("TERM"); if ($1 == NULL) $1 = "";

if (string_match ($1, "^xterm.color", 1)
    or string_match ($1, "^rxvt", 1))
{
   % rxvt: bypass XTerm shift keys and allow S-Prior, S-Next, S-Insert
   add_to_hook ("_jed_reset_display_hooks", &wmark_reset_display_hook);
   add_to_hook ("_jed_init_display_hooks", &wmark_init_display_hook);
   setkey ("wmark_bol",	"\e[7$");	% S-Home
   setkey ("wmark_eol",	"\e[8$");	% S-End
}
#endif

