/*
** Copyright (c) 2025 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

#ifndef VULKAN_REPLAY_DUMP_RESOURCES_COPY_ARRAY_OF_POINTERS_H
#define VULKAN_REPLAY_DUMP_RESOURCES_COPY_ARRAY_OF_POINTERS_H

#include <stdint.h>

// Original GLSL code
#if 0
#version 450

#extension GL_EXT_buffer_reference : require

struct ASInstanceKHR
{
    uint data[16];
};

layout(std430, buffer_reference, buffer_reference_align = 8) buffer ASInstanceKHR_ptr
{
    ASInstanceKHR instance[];
};

layout(std430, buffer_reference, buffer_reference_align = 8) readonly buffer ArrayOfPointers
{
    ASInstanceKHR_ptr pointers[];
};

layout(push_constant) uniform Registers
{
    ArrayOfPointers   array_of_pointers_base_address;
    ASInstanceKHR_ptr out_buffer_base_address;
    uint              count;
}
registers;

void main(void)
{
    for (int i = 0; i < registers.count; ++i)
    {
        registers.out_buffer_base_address.instance[i].data = registers.array_of_pointers_base_address.pointers[i].instance[0].data;
    }
}
#endif

// Human readable form of SPIRV
#if 0
// Module Version 10000
// Generated by (magic number): 8000b
// Id's are bound by 54

                              Capability Shader
                              Capability PhysicalStorageBufferAddressesEXT
                              Extension  "SPV_KHR_physical_storage_buffer"
               1:             ExtInstImport  "GLSL.std.450"
                              MemoryModel PhysicalStorageBuffer64EXT GLSL450
                              EntryPoint GLCompute 4  "main"
                              ExecutionMode 4 LocalSize 1 1 1
                              Source GLSL 450
                              SourceExtension  "GL_EXT_buffer_reference"
                              Name 4  "main"
                              Name 8  "i"
                              Name 20  "Registers"
                              MemberName 20(Registers) 0  "array_of_pointers_base_address"
                              MemberName 20(Registers) 1  "out_buffer_base_address"
                              MemberName 20(Registers) 2  "count"
                              Name 22  "ArrayOfPointers"
                              MemberName 22(ArrayOfPointers) 0  "pointers"
                              Name 25  "ASInstanceKHR"
                              MemberName 25(ASInstanceKHR) 0  "data"
                              Name 27  "ASInstanceKHR_ptr"
                              MemberName 27(ASInstanceKHR_ptr) 0  "instance"
                              Name 29  "registers"
                              Decorate 20(Registers) Block
                              MemberDecorate 20(Registers) 0 Offset 0
                              MemberDecorate 20(Registers) 1 Offset 8
                              MemberDecorate 20(Registers) 2 Offset 16
                              Decorate 21 ArrayStride 8
                              Decorate 22(ArrayOfPointers) Block
                              MemberDecorate 22(ArrayOfPointers) 0 NonWritable
                              MemberDecorate 22(ArrayOfPointers) 0 Offset 0
                              Decorate 24 ArrayStride 4
                              MemberDecorate 25(ASInstanceKHR) 0 Offset 0
                              Decorate 26 ArrayStride 64
                              Decorate 27(ASInstanceKHR_ptr) Block
                              MemberDecorate 27(ASInstanceKHR_ptr) 0 Offset 0
               2:             TypeVoid
               3:             TypeFunction 2
               6:             TypeInt 32 1
               7:             TypePointer Function 6(int)
               9:      6(int) Constant 0
              16:             TypeInt 32 0
                              TypeForwardPointer 18 PhysicalStorageBufferEXT
                              TypeForwardPointer 19 PhysicalStorageBufferEXT
   20(Registers):             TypeStruct 18 19 16(int)
              21:             TypeRuntimeArray 19
22(ArrayOfPointers):             TypeStruct 21
              18:             TypePointer PhysicalStorageBufferEXT 22(ArrayOfPointers)
              23:     16(int) Constant 16
              24:             TypeArray 16(int) 23
25(ASInstanceKHR):             TypeStruct 24
              26:             TypeRuntimeArray 25(ASInstanceKHR)
27(ASInstanceKHR_ptr):             TypeStruct 26
              19:             TypePointer PhysicalStorageBufferEXT 27(ASInstanceKHR_ptr)
              28:             TypePointer PushConstant 20(Registers)
   29(registers):     28(ptr) Variable PushConstant
              30:      6(int) Constant 2
              31:             TypePointer PushConstant 16(int)
              34:             TypeBool
              36:      6(int) Constant 1
              37:             TypePointer PushConstant 19(ptr)
              41:             TypePointer PushConstant 18(ptr)
              45:             TypePointer PhysicalStorageBufferEXT 19(ptr)
              48:             TypePointer PhysicalStorageBufferEXT 24
         4(main):           2 Function None 3
               5:             Label
            8(i):      7(ptr) Variable Function
                              Store 8(i) 9
                              Branch 10
              10:             Label
                              LoopMerge 12 13 None
                              Branch 14
              14:             Label
              15:      6(int) Load 8(i)
              17:     16(int) Bitcast 15
              32:     31(ptr) AccessChain 29(registers) 30
              33:     16(int) Load 32
              35:    34(bool) ULessThan 17 33
                              BranchConditional 35 11 12
              11:               Label
              38:     37(ptr)   AccessChain 29(registers) 36
              39:     19(ptr)   Load 38
              40:      6(int)   Load 8(i)
              42:     41(ptr)   AccessChain 29(registers) 9
              43:     18(ptr)   Load 42
              44:      6(int)   Load 8(i)
              46:     45(ptr)   AccessChain 43 9 44
              47:     19(ptr)   Load 46 Aligned 8
              49:     48(ptr)   AccessChain 47 9 9 9
              50:          24   Load 49 Aligned 8
              51:     48(ptr)   AccessChain 39 9 40 9
                                Store 51 50 Aligned 8
                                Branch 13
              13:               Label
              52:      6(int)   Load 8(i)
              53:      6(int)   IAdd 52 36
                                Store 8(i) 53
                                Branch 10
              12:             Label
                              Return
                              FunctionEnd
#endif

static constexpr uint32_t g_CompShaderMain[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x00000036, 0x00000000, 0x00020011, 0x00000001, 0x00020011, 0x000014e3,
    0x0009000a, 0x5f565053, 0x5f52484b, 0x73796870, 0x6c616369, 0x6f74735f, 0x65676172, 0x6675625f, 0x00726566,
    0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e, 0x00000000, 0x0003000e, 0x000014e4, 0x00000001,
    0x0005000f, 0x00000005, 0x00000004, 0x6e69616d, 0x00000000, 0x00060010, 0x00000004, 0x00000011, 0x00000001,
    0x00000001, 0x00000001, 0x00030003, 0x00000002, 0x000001c2, 0x00070004, 0x455f4c47, 0x625f5458, 0x65666675,
    0x65725f72, 0x65726566, 0x0065636e, 0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00030005, 0x00000008,
    0x00000069, 0x00050005, 0x00000014, 0x69676552, 0x72657473, 0x00000073, 0x000b0006, 0x00000014, 0x00000000,
    0x61727261, 0x666f5f79, 0x696f705f, 0x7265746e, 0x61625f73, 0x615f6573, 0x65726464, 0x00007373, 0x00090006,
    0x00000014, 0x00000001, 0x5f74756f, 0x66667562, 0x625f7265, 0x5f657361, 0x72646461, 0x00737365, 0x00050006,
    0x00000014, 0x00000002, 0x6e756f63, 0x00000074, 0x00060005, 0x00000016, 0x61727241, 0x50664f79, 0x746e696f,
    0x00737265, 0x00060006, 0x00000016, 0x00000000, 0x6e696f70, 0x73726574, 0x00000000, 0x00060005, 0x00000019,
    0x6e495341, 0x6e617473, 0x484b6563, 0x00000052, 0x00050006, 0x00000019, 0x00000000, 0x61746164, 0x00000000,
    0x00070005, 0x0000001b, 0x6e495341, 0x6e617473, 0x484b6563, 0x74705f52, 0x00000072, 0x00060006, 0x0000001b,
    0x00000000, 0x74736e69, 0x65636e61, 0x00000000, 0x00050005, 0x0000001d, 0x69676572, 0x72657473, 0x00000073,
    0x00030047, 0x00000014, 0x00000002, 0x00050048, 0x00000014, 0x00000000, 0x00000023, 0x00000000, 0x00050048,
    0x00000014, 0x00000001, 0x00000023, 0x00000008, 0x00050048, 0x00000014, 0x00000002, 0x00000023, 0x00000010,
    0x00040047, 0x00000015, 0x00000006, 0x00000008, 0x00030047, 0x00000016, 0x00000002, 0x00040048, 0x00000016,
    0x00000000, 0x00000018, 0x00050048, 0x00000016, 0x00000000, 0x00000023, 0x00000000, 0x00040047, 0x00000018,
    0x00000006, 0x00000004, 0x00050048, 0x00000019, 0x00000000, 0x00000023, 0x00000000, 0x00040047, 0x0000001a,
    0x00000006, 0x00000040, 0x00030047, 0x0000001b, 0x00000002, 0x00050048, 0x0000001b, 0x00000000, 0x00000023,
    0x00000000, 0x00020013, 0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00040015, 0x00000006, 0x00000020,
    0x00000001, 0x00040020, 0x00000007, 0x00000007, 0x00000006, 0x0004002b, 0x00000006, 0x00000009, 0x00000000,
    0x00040015, 0x00000010, 0x00000020, 0x00000000, 0x00030027, 0x00000012, 0x000014e5, 0x00030027, 0x00000013,
    0x000014e5, 0x0005001e, 0x00000014, 0x00000012, 0x00000013, 0x00000010, 0x0003001d, 0x00000015, 0x00000013,
    0x0003001e, 0x00000016, 0x00000015, 0x00040020, 0x00000012, 0x000014e5, 0x00000016, 0x0004002b, 0x00000010,
    0x00000017, 0x00000010, 0x0004001c, 0x00000018, 0x00000010, 0x00000017, 0x0003001e, 0x00000019, 0x00000018,
    0x0003001d, 0x0000001a, 0x00000019, 0x0003001e, 0x0000001b, 0x0000001a, 0x00040020, 0x00000013, 0x000014e5,
    0x0000001b, 0x00040020, 0x0000001c, 0x00000009, 0x00000014, 0x0004003b, 0x0000001c, 0x0000001d, 0x00000009,
    0x0004002b, 0x00000006, 0x0000001e, 0x00000002, 0x00040020, 0x0000001f, 0x00000009, 0x00000010, 0x00020014,
    0x00000022, 0x0004002b, 0x00000006, 0x00000024, 0x00000001, 0x00040020, 0x00000025, 0x00000009, 0x00000013,
    0x00040020, 0x00000029, 0x00000009, 0x00000012, 0x00040020, 0x0000002d, 0x000014e5, 0x00000013, 0x00040020,
    0x00000030, 0x000014e5, 0x00000018, 0x00050036, 0x00000002, 0x00000004, 0x00000000, 0x00000003, 0x000200f8,
    0x00000005, 0x0004003b, 0x00000007, 0x00000008, 0x00000007, 0x0003003e, 0x00000008, 0x00000009, 0x000200f9,
    0x0000000a, 0x000200f8, 0x0000000a, 0x000400f6, 0x0000000c, 0x0000000d, 0x00000000, 0x000200f9, 0x0000000e,
    0x000200f8, 0x0000000e, 0x0004003d, 0x00000006, 0x0000000f, 0x00000008, 0x0004007c, 0x00000010, 0x00000011,
    0x0000000f, 0x00050041, 0x0000001f, 0x00000020, 0x0000001d, 0x0000001e, 0x0004003d, 0x00000010, 0x00000021,
    0x00000020, 0x000500b0, 0x00000022, 0x00000023, 0x00000011, 0x00000021, 0x000400fa, 0x00000023, 0x0000000b,
    0x0000000c, 0x000200f8, 0x0000000b, 0x00050041, 0x00000025, 0x00000026, 0x0000001d, 0x00000024, 0x0004003d,
    0x00000013, 0x00000027, 0x00000026, 0x0004003d, 0x00000006, 0x00000028, 0x00000008, 0x00050041, 0x00000029,
    0x0000002a, 0x0000001d, 0x00000009, 0x0004003d, 0x00000012, 0x0000002b, 0x0000002a, 0x0004003d, 0x00000006,
    0x0000002c, 0x00000008, 0x00060041, 0x0000002d, 0x0000002e, 0x0000002b, 0x00000009, 0x0000002c, 0x0006003d,
    0x00000013, 0x0000002f, 0x0000002e, 0x00000002, 0x00000008, 0x00070041, 0x00000030, 0x00000031, 0x0000002f,
    0x00000009, 0x00000009, 0x00000009, 0x0006003d, 0x00000018, 0x00000032, 0x00000031, 0x00000002, 0x00000008,
    0x00070041, 0x00000030, 0x00000033, 0x00000027, 0x00000009, 0x00000028, 0x00000009, 0x0005003e, 0x00000033,
    0x00000032, 0x00000002, 0x00000008, 0x000200f9, 0x0000000d, 0x000200f8, 0x0000000d, 0x0004003d, 0x00000006,
    0x00000034, 0x00000008, 0x00050080, 0x00000006, 0x00000035, 0x00000034, 0x00000024, 0x0003003e, 0x00000008,
    0x00000035, 0x000200f9, 0x0000000a, 0x000200f8, 0x0000000c, 0x000100fd, 0x00010038
};

#endif // VULKAN_REPLAY_DUMP_RESOURCES_COPY_ARRAY_OF_POINTERS_H
