.\" Automatically generated by Pandoc
.\"
.TH "CWEB" "1" "Marxch 10, 2024" "Web2c @VERSION@" "General Commands Manual"
.SH NAME
ctangle, cweave \- translate CWEB to C/C++ and/or TeX
.SH SYNOPSIS
\f[B]ctangle\f[R] [\f[I]options\f[R]] \f[I]webfile\f[R][.w]
[{\f[I]changefile\f[R][.ch]|\-} [\f[I]outfile\f[R][.c]]]
.PD 0
.P
.PD
\f[B]cweave\f[R] [\f[I]options\f[R]] \f[I]webfile\f[R][.w]
[{\f[I]changefile\f[R][.ch]|\-} [\f[I]outfile\f[R][.tex]]]
.SH DESCRIPTION
The \f[B]ctangle\f[R] program converts a CWEB source document into a
C/C++\ program that may be compiled in the usual way.
The output file includes \f[B]#line\f[R] specifications so that
debugging can be done in terms of the CWEB source file.
.PP
The \f[B]cweave\f[R] program converts the same CWEB file into a
TeX\ file that may be formatted and printed in the usual way.
It takes appropriate care of typographic details like page layout and
the use of indentation, \f[I]italics\f[R], \f[B]boldface\f[R], etc., and
it supplies extensive cross-index information that it gathers
automatically.
.PP
CWEB allows you to prepare a single document containing all the
information that is needed both to produce a compilable C/C++\ program
and to produce a well-formatted document describing the program in as
much detail as the writer may desire.
The user of CWEB ought to be familiar with TeX as well as C/C++.
.SH USAGE
The command line should have one, two, or three names on it.
The first is taken as the CWEB input file (and \f[B].w\f[R] is added if
there is no extension).
If there is a second name, it is a change file (and \f[B].ch\f[R] is
added if there is no extension).
The change file overrides parts of the CWEB file, as described in the
documentation.
If there is a third name, it overrides the default name of the output
file, which is ordinarily the same as the name of the input file (but on
the current directory) with the extension \f[B].tex\f[R].
If you just want to change the output file name, but don\[cq]t have a
change file to apply, you can use `\f[B]\-\f[R]' as the second argument.
.SH DIFFERENCES TO ORIGINAL CWEB
CWEBbin tries hard to be a drop-in replacement for CWEB, so in general
you should not notice any differences in invoking the programs nor in
the resulting output.
There are, however, a few differences worth noting:
.IP \[bu] 2
Options \f[B]\-\-help\f[R], \f[B]\-\-quiet\f[R], \f[B]\-\-verbose\f[R],
\f[B]\-\-version\f[R], and flags \f[B]+c\f[R], \f[B]\-i\f[R],
\f[B]\-o\f[R], \f[B]+u\f[R], and \f[B]+lX\f[R] are new in CWEBbin and
TeX\ Live.
.IP \[bu] 2
Option \f[B]+lX\f[R] is accompanied by several wrapper files for
\f[B]cwebmac.tex\f[R] with translated captions for German
(\f[B]+ld\f[R]), French (\f[B]+lf\f[R]), and Italian (\f[B]+li\f[R]).
.IP \[bu] 2
CWEB in TeX\ Live operates silently by default (as of 2019); use the
\f[B]\-\-verbose\f[R] option to get the original behavior.
.IP \[bu] 2
File lookup with the environment variable CWEBINPUTS is extended to
permit several, colon-separated, paths; see ENVIRONMENT below.
.IP \[bu] 2
If properly configured, the main programs \f[B]ctangle\f[R] and
\f[B]cweave\f[R] are localized with the \[lq]GNU gettext utilities\[rq].
.SH OPTIONS
Options on the command line may be either turned off with `\f[B]\-\f[R]'
(if they are on by default) or turned on with `\f[B]+\f[R]' (if they are
off by default).
In fact, the options are processed from left to right, so a sequence
like \f[B]\-\-verbose \-h\f[R] will only show the \f[B]banner line\f[R]
(\f[B]+b\f[R]) and the \f[B]progress report\f[R] (\f[B]+p\f[R]), but
leave out the \f[B]happy message\f[R] (\f[B]\-h\f[R]).
.PP
The first batch of options are common to both \f[B]ctangle\f[R] and
\f[B]cweave\f[R]:
.IP \[bu] 2
\f[B]+b\f[R]: print banner line on terminal
.IP \[bu] 2
\f[B]+h\f[R]: print success message on completion
.IP \[bu] 2
\f[B]+p\f[R]: print progress report messages
.IP \[bu] 2
\f[B]+q\f[R]/\f[B]\-q\f[R]: shortcut for \f[B]\-bhp\f[R]; also
\f[B]\-\-quiet\f[R] (default)
.IP \[bu] 2
\f[B]+v\f[R]/\f[B]\-v\f[R]: shortcut for \f[B]+bhp\f[R]; also
\f[B]\-\-verbose\f[R]
.IP \[bu] 2
\f[B]+c\f[R]: check temporary output for changes
.IP \[bu] 2
\f[B]+s\f[R]: print usage statistics
.IP \[bu] 2
\f[B]\-\-help\f[R]: display help message and exit
.IP \[bu] 2
\f[B]\-\-version\f[R]: output version information and exit
.PP
There are two other options applicable to \f[B]ctangle\f[R] only:
.IP \[bu] 2
\f[B]+k\f[R]: keep separators in numeric literals in the output
.IP \[bu] 2
\f[B]+u\f[R]: transliterate UTF-8 characters in C code
.PP
There are eight other options applicable to \f[B]cweave\f[R] only:
.IP \[bu] 2
\f[B]\-e\f[R]: do not enclose C/C++\ material in
\f[B]\[rs]PB{\&...}\f[R]
.IP \[bu] 2
\f[B]\-f\f[R]: do not force a newline after every C/C++\ statement in
output
.IP \[bu] 2
\f[B]\-F\f[R]: do not force a compound statement to start on a new line
.IP \[bu] 2
\f[B]\-i\f[R]: suppress indentation of parameter declarations
.IP \[bu] 2
\f[B]\-o\f[R]: suppress separation of declarations and statements
.IP \[bu] 2
\f[B]\-x\f[R]: omit indices, section names, table of contents
.IP \[bu] 2
\f[B]+lX\f[R]/\f[B]\-lX\f[R]: use macros for language \f[I]X\f[R] as of
\f[I]X\f[R]\f[B]cwebmac.tex\f[R]
.IP \[bu] 2
\f[B]+t\f[R]: treat \f[B]typename\f[R] in a template like
\f[B]typedef\f[R]
.SH ENVIRONMENT
The environment variable CWEBINPUTS is used to search for the input
files, or the system default if CWEBINPUTS is not set.
See tex(1) for the details of the searching.
To avoid conflicts with other programs that also use the CWEBINPUTS
environment, you can be more specific and use CWEBINPUTS_cweb for
special requirements in CWEB.
.PP
If prepared for NLS support, \f[B]ctangle\f[R] and \f[B]cweave\f[R] use
the environment variable TEXMFLOCALEDIR to configure the parent
directory where the \[lq]GNU gettext utilities\[rq] search for
translation catalogs.
.PP
These variables are preconfigured in TeX\ Live\[cq]s
\f[B]texmf.cnf\f[R].
.SH FILES
The location of the files mentioned below varies from system to system.
Use the \f[B]kpsewhich\f[R] utility to find their locations.
.IP \[bu] 2
\f[B]cwebmac.tex\f[R]: The default TeX\ macros \f[B]\[rs]input\f[R] in
the first line of the \f[B]cweave\f[R] output file.
.IP \[bu] 2
\f[B]cwebman.tex\f[R]: The CWEB user manual, available in PDF from \c
.UR https://ctan.org/pkg/cweb
CTAN
.UE \c
\&.
.SH SEE ALSO
.IP \[bu] 2
The CWEB System of Structured Documentation: by Donald E.\ Knuth and
Silvio Levy (hardcopy version of \f[B]cwebman.tex\f[R] and the source
code listings of \f[B]common.w\f[R], \f[B]ctangle.w\f[R], and
\f[B]cweave.w\f[R]).
.IP \[bu] 2
Literate Programming: by D.\ E.\ Knuth.
.IP \[bu] 2
Weaving a Program: by Wayne Sewell.
.PP
cweb(1), tex(1), cc(1)
.SH AUTHORS
Don Knuth wrote WEB for TeX and Pascal.
.PD 0
.P
.PD
Silvio Levy designed and developed CWEB by adapting the WEB conventions
to C and by recoding everything in CWEB.
Knuth began using CWEB and made further refinements.
.PD 0
.P
.PD
Many other helpers are acknowledged in the CWEB manual.
.PD 0
.P
.PD
Contemporary development on https://github.com/ascherer/cweb.
