// Copyright 2011-2017 Software Freedom Conservancy
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

const EXPORTED_SYMBOLS = ["atom"];

/** @namespace */
this.atom = {};

// https://github.com/SeleniumHQ/selenium/blob/master/javascript/atoms/dom.js#L979
atom.getElementText = function(element, window){return function(){var g,l=this;function n(a){return void 0!==a}function p(a){return"string"==typeof a}function aa(a){return"number"==typeof a}function ba(a,b){a=a.split(".");var c=l;a[0]in c||!c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)!a.length&&n(b)?c[d]=b:c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}}
function ca(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b}function da(a,b,c){return a.call.apply(a.bind,arguments)}function ea(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}
function fa(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?fa=da:fa=ea;return fa.apply(null,arguments)}function ha(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}
function q(a,b){function c(){}c.prototype=b.prototype;a.U=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.S=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function ia(a,b){this.code=a;this.a=u[a]||ja;this.message=b||"";a=this.a.replace(/((?:^|\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\s\xa0]+/g,"")});b=a.length-5;if(0>b||a.indexOf("Error",b)!=b)a+="Error";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||""}q(ia,Error);var ja="unknown error",u={15:"element not selectable",11:"element not visible"};u[31]=ja;u[30]=ja;u[24]="invalid cookie domain";u[29]="invalid element coordinates";u[12]="invalid element state";
u[32]="invalid selector";u[51]="invalid selector";u[52]="invalid selector";u[17]="javascript error";u[405]="unsupported operation";u[34]="move target out of bounds";u[27]="no such alert";u[7]="no such element";u[8]="no such frame";u[23]="no such window";u[28]="script timeout";u[33]="session not created";u[10]="stale element reference";u[21]="timeout";u[25]="unable to set cookie";u[26]="unexpected alert open";u[13]=ja;u[9]="unknown command";ia.prototype.toString=function(){return this.name+": "+this.message};var ka={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",
darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",
ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",
lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",
moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",
seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};function la(a,b){this.width=a;this.height=b}g=la.prototype;g.toString=function(){return"("+this.width+" x "+this.height+")"};g.ceil=function(){this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};g.floor=function(){this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};g.round=function(){this.width=Math.round(this.width);this.height=Math.round(this.height);return this};g.scale=function(a,b){b=aa(b)?b:a;this.width*=a;this.height*=b;return this};function ma(a){var b=a.length-1;return 0<=b&&a.indexOf(" ",b)==b}function na(a){return String(a).replace(/\-([a-z])/g,function(a,c){return c.toUpperCase()})};
function v(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function oa(a){this.b=a;this.a=0}function pa(a){a=a.match(qa);for(var b=0;b<a.length;b++)ra.test(a[b])&&a.splice(b,1);return new oa(a)}var qa=/\$?(?:(?![0-9-\.])(?:\*|[\w-\.]+):)?(?![0-9-\.])(?:\*|[\w-\.]+)|\/\/|\.\.|::|\d+(?:\.\d*)?|\.\d+|"[^"]*"|'[^']*'|[!<>]=|\s+|./g,ra=/^\s/;function w(a,b){return a.b[a.a+(b||0)]}oa.prototype.next=function(){return this.b[this.a++]};function sa(a){return a.b.length<=a.a};var ta;a:{var ua=l.navigator;if(ua){var va=ua.userAgent;if(va){ta=va;break a}}ta=""};function x(a,b){this.j=a;this.c=n(b)?b:null;this.b=null;switch(a){case "comment":this.b=8;break;case "text":this.b=3;break;case "processing-instruction":this.b=7;break;case "node":break;default:throw Error("Unexpected argument");}}function wa(a){return"comment"==a||"text"==a||"processing-instruction"==a||"node"==a}x.prototype.a=function(a){return null===this.b||this.b==a.nodeType};x.prototype.f=function(){return this.j};
x.prototype.toString=function(){var a="Kind Test: "+this.j;null===this.c||(a+=y(this.c));return a};function xa(a,b){this.o=a.toLowerCase();a="*"==this.o?"*":"http://www.w3.org/1999/xhtml";this.b=b?b.toLowerCase():a}xa.prototype.a=function(a){var b=a.nodeType;if(1!=b&&2!=b)return!1;b=n(a.localName)?a.localName:a.nodeName;return"*"!=this.o&&this.o!=b.toLowerCase()?!1:"*"==this.b?!0:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():"http://www.w3.org/1999/xhtml")};xa.prototype.f=function(){return this.o};
xa.prototype.toString=function(){return"Name Test: "+("http://www.w3.org/1999/xhtml"==this.b?"":this.b+":")+this.o};function ya(a){switch(a.nodeType){case 1:return ha(za,a);case 9:return ya(a.documentElement);case 11:case 10:case 6:case 12:return Aa;default:return a.parentNode?ya(a.parentNode):Aa}}function Aa(){return null}function za(a,b){if(a.prefix==b)return a.namespaceURI||"http://www.w3.org/1999/xhtml";var c=a.getAttributeNode("xmlns:"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?za(a.parentNode,b):null};function Ba(a,b){if(p(a))return p(b)&&1==b.length?a.indexOf(b,0):-1;for(var c=0;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1}function z(a,b){for(var c=a.length,d=p(a)?a.split(""):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function A(a,b,c){var d=c;z(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function Ca(a,b){for(var c=a.length,d=p(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}
function Da(a,b){for(var c=a.length,d=p(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&!b.call(void 0,d[e],e,a))return!1;return!0}function Ea(a){return Array.prototype.concat.apply([],arguments)}function Fa(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var Ga="backgroundColor borderTopColor borderRightColor borderBottomColor borderLeftColor color outlineColor".split(" "),Ha=/#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])/,Ia=/^#(?:[0-9a-f]{3}){1,2}$/i,Ja=/^(?:rgba)?\((\d{1,3}),\s?(\d{1,3}),\s?(\d{1,3}),\s?(0|1|0\.\d*)\)$/i,Ka=/^(?:rgb)?\((0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2})\)$/i;function La(a,b){this.x=n(a)?a:0;this.y=n(b)?b:0}g=La.prototype;g.toString=function(){return"("+this.x+", "+this.y+")"};g.ceil=function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);return this};g.floor=function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);return this};g.round=function(){this.x=Math.round(this.x);this.y=Math.round(this.y);return this};g.scale=function(a,b){b=aa(b)?b:a;this.x*=a;this.y*=b;return this};var Ma=-1!=ta.indexOf("Macintosh"),Na=-1!=ta.indexOf("Windows");function Oa(a,b,c,d){this.c=a;this.a=b;this.b=c;this.f=d}g=Oa.prototype;g.toString=function(){return"("+this.c+"t, "+this.a+"r, "+this.b+"b, "+this.f+"l)"};g.contains=function(a){return this&&a?a instanceof Oa?a.f>=this.f&&a.a<=this.a&&a.c>=this.c&&a.b<=this.b:a.x>=this.f&&a.x<=this.a&&a.y>=this.c&&a.y<=this.b:!1};g.ceil=function(){this.c=Math.ceil(this.c);this.a=Math.ceil(this.a);this.b=Math.ceil(this.b);this.f=Math.ceil(this.f);return this};
g.floor=function(){this.c=Math.floor(this.c);this.a=Math.floor(this.a);this.b=Math.floor(this.b);this.f=Math.floor(this.f);return this};g.round=function(){this.c=Math.round(this.c);this.a=Math.round(this.a);this.b=Math.round(this.b);this.f=Math.round(this.f);return this};g.scale=function(a,b){b=aa(b)?b:a;this.f*=a;this.a*=a;this.c*=b;this.b*=b;return this};function Pa(a,b){this.w={};this.m=[];this.a=0;var c=arguments.length;if(1<c){if(c%2)throw Error("Uneven number of arguments");for(var d=0;d<c;d+=2)this.set(arguments[d],arguments[d+1])}else if(a){if(a instanceof Pa){d=Qa(a);Ra(a);var e=[];for(c=0;c<a.m.length;c++)e.push(a.w[a.m[c]])}else{var c=[],f=0;for(d in a)c[f++]=d;d=c;c=[];f=0;for(e in a)c[f++]=a[e];e=c}for(c=0;c<d.length;c++)this.set(d[c],e[c])}}function Qa(a){Ra(a);return a.m.concat()}
function Ra(a){var b,c;if(a.a!=a.m.length){for(b=c=0;c<a.m.length;){var d=a.m[c];Object.prototype.hasOwnProperty.call(a.w,d)&&(a.m[b++]=d);c++}a.m.length=b}if(a.a!=a.m.length){var e={};for(b=c=0;c<a.m.length;)d=a.m[c],Object.prototype.hasOwnProperty.call(e,d)||(a.m[b++]=d,e[d]=1),c++;a.m.length=b}}Pa.prototype.get=function(a,b){return Object.prototype.hasOwnProperty.call(this.w,a)?this.w[a]:b};
Pa.prototype.set=function(a,b){Object.prototype.hasOwnProperty.call(this.w,a)||(this.a++,this.m.push(a));this.w[a]=b};function B(a,b,c,d){this.a=a;this.b=b;this.width=c;this.height=d}g=B.prototype;g.toString=function(){return"("+this.a+", "+this.b+" - "+this.width+"w x "+this.height+"h)"};g.contains=function(a){return a instanceof La?a.x>=this.a&&a.x<=this.a+this.width&&a.y>=this.b&&a.y<=this.b+this.height:this.a<=a.a&&this.a+this.width>=a.a+a.width&&this.b<=a.b&&this.b+this.height>=a.b+a.height};
g.ceil=function(){this.a=Math.ceil(this.a);this.b=Math.ceil(this.b);this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};g.floor=function(){this.a=Math.floor(this.a);this.b=Math.floor(this.b);this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};g.round=function(){this.a=Math.round(this.a);this.b=Math.round(this.b);this.width=Math.round(this.width);this.height=Math.round(this.height);return this};
g.scale=function(a,b){b=aa(b)?b:a;this.a*=a;this.width*=a;this.b*=b;this.height*=b;return this};var Sa,Ta,Ua=function(){var a=l.Components;if(!a)return!1;try{if(!a.classes)return!1}catch(f){return!1}var b=a.classes,a=a.interfaces,c=b["@mozilla.org/xpcom/version-comparator;1"].getService(a.nsIVersionComparator),b=b["@mozilla.org/xre/app-info;1"].getService(a.nsIXULAppInfo),d=b.platformVersion,e=b.version;Sa=function(a){c.compare(d,""+a)};Ta=function(a){c.compare(e,""+a)};return!0}();function Va(a){for(;a&&1!=a.nodeType;)a=a.previousSibling;return a}function Wa(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if("undefined"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}
function Xa(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if("sourceIndex"in a||a.parentNode&&"sourceIndex"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?Ya(a,b):!c&&Wa(e,b)?-1*Za(a,b):!d&&Wa(f,a)?Za(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}d=D(a);c=d.createRange();c.selectNode(a);c.collapse(!0);a=d.createRange();a.selectNode(b);
a.collapse(!0);return c.compareBoundaryPoints(l.Range.START_TO_END,a)}function Za(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return Ya(b,a)}function Ya(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1}function D(a){return 9==a.nodeType?a:a.ownerDocument||a.document}function $a(a,b){a&&(a=a.parentNode);for(var c=0;a;){if(b(a))return a;a=a.parentNode;c++}return null}function ab(a){this.a=a||l.document||document}
ab.prototype.getElementsByTagName=function(a,b){return(b||this.a).getElementsByTagName(String(a))};ab.prototype.contains=Wa;function E(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?"":b);if("string"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;for(var c=0,d=[],b="";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return""+b}
function F(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function bb(a,b,c,d,e){return cb.call(null,a,b,p(c)?c:null,p(d)?d:null,e||new G)}
function cb(a,b,c,d,e){b.getElementsByName&&d&&"name"==c?(b=b.getElementsByName(d),z(b,function(b){a.a(b)&&H(e,b)})):b.getElementsByClassName&&d&&"class"==c?(b=b.getElementsByClassName(d),z(b,function(b){b.className==d&&a.a(b)&&H(e,b)})):a instanceof x?db(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),z(b,function(a){F(a,c,d)&&H(e,a)}));return e}function db(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)F(b,c,d)&&a.a(b)&&H(e,b),db(a,b,c,d,e)};function I(a,b){b&&"string"!==typeof b&&(b=b.toString());return!!a&&1==a.nodeType&&(!b||a.tagName.toUpperCase()==b)};function G(){this.b=this.a=null;this.s=0}function eb(a){this.node=a;this.next=this.a=null}function fb(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.node==b.node?(e=c,c=c.next,b=b.next):0<Xa(c.node,b.node)?(e=b,b=b.next):(e=c,c=c.next),(e.a=d)?d.next=e:a.a=e,d=e,f++;for(e=c||b;e;)e.a=d,d=d.next=e,f++,e=e.next;a.b=d;a.s=f;return a}function gb(a,b){b=new eb(b);b.next=a.a;a.b?a.a.a=b:a.a=a.b=b;a.a=b;a.s++}
function H(a,b){b=new eb(b);b.a=a.b;a.a?a.b.next=b:a.a=a.b=b;a.b=b;a.s++}function hb(a){return(a=a.a)?a.node:null}function ib(a){return(a=hb(a))?E(a):""}G.prototype.iterator=function(a){return new jb(this,!!a)};function jb(a,b){this.f=a;this.b=(this.A=b)?a.b:a.a;this.a=null}jb.prototype.next=function(){var a=this.b;if(a){var b=this.a=a;this.b=this.A?a.a:a.next;return b.node}return null};function J(a){this.l=a;this.b=this.i=!1;this.f=null}function y(a){return"\n  "+a.toString().split("\n").join("\n  ")}function kb(a,b){a.i=b}function lb(a,b){a.b=b}function K(a,b){a=a.a(b);return a instanceof G?+ib(a):+a}function M(a,b){a=a.a(b);return a instanceof G?ib(a):""+a}function N(a,b){a=a.a(b);return a instanceof G?!!a.s:!!a};function mb(a,b,c){J.call(this,a.l);this.c=a;this.j=b;this.v=c;this.i=b.i||c.i;this.b=b.b||c.b;this.c==nb&&(c.b||c.i||4==c.l||0==c.l||!b.f?b.b||b.i||4==b.l||0==b.l||!c.f||(this.f={name:c.f.name,B:b}):this.f={name:b.f.name,B:c})}q(mb,J);
function O(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=b.iterator();for(d=b.next();d;d=b.next())for(e=c.iterator(),f=e.next();f;f=e.next())if(a(E(d),E(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=e.iterator();for(var h=typeof d,k=f.next();k;k=f.next()){switch(h){case "number":k=+E(k);break;case "boolean":k=!!E(k);break;case "string":k=E(k);break;default:throw Error("Illegal primitive type for comparison.");}if(e==b&&a(k,
d)||e==c&&a(d,k))return!0}return!1}return e?"boolean"==typeof b||"boolean"==typeof c?a(!!b,!!c):"number"==typeof b||"number"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}mb.prototype.a=function(a){return this.c.u(this.j,this.v,a)};mb.prototype.toString=function(){var a="Binary Expression: "+this.c,a=a+y(this.j);return a+=y(this.v)};function ob(a,b,c,d){this.O=a;this.K=b;this.l=c;this.u=d}ob.prototype.toString=function(){return this.O};var pb={};
function P(a,b,c,d){if(pb.hasOwnProperty(a))throw Error("Binary operator already created: "+a);a=new ob(a,b,c,d);return pb[a.toString()]=a}P("div",6,1,function(a,b,c){return K(a,c)/K(b,c)});P("mod",6,1,function(a,b,c){return K(a,c)%K(b,c)});P("*",6,1,function(a,b,c){return K(a,c)*K(b,c)});P("+",5,1,function(a,b,c){return K(a,c)+K(b,c)});P("-",5,1,function(a,b,c){return K(a,c)-K(b,c)});P("<",4,2,function(a,b,c){return O(function(a,b){return a<b},a,b,c)});
P(">",4,2,function(a,b,c){return O(function(a,b){return a>b},a,b,c)});P("<=",4,2,function(a,b,c){return O(function(a,b){return a<=b},a,b,c)});P(">=",4,2,function(a,b,c){return O(function(a,b){return a>=b},a,b,c)});var nb=P("=",3,2,function(a,b,c){return O(function(a,b){return a==b},a,b,c,!0)});P("!=",3,2,function(a,b,c){return O(function(a,b){return a!=b},a,b,c,!0)});P("and",2,2,function(a,b,c){return N(a,c)&&N(b,c)});P("or",1,2,function(a,b,c){return N(a,c)||N(b,c)});function qb(a,b){if(b.a.length&&4!=a.l)throw Error("Primary expression must evaluate to nodeset if filter has predicate(s).");J.call(this,a.l);this.c=a;this.j=b;this.i=a.i;this.b=a.b}q(qb,J);qb.prototype.a=function(a){a=this.c.a(a);return rb(this.j,a)};qb.prototype.toString=function(){var a="Filter:"+y(this.c);return a+=y(this.j)};function sb(a,b){if(b.length<a.J)throw Error("Function "+a.o+" expects at least"+a.J+" arguments, "+b.length+" given");if(null!==a.F&&b.length>a.F)throw Error("Function "+a.o+" expects at most "+a.F+" arguments, "+b.length+" given");a.N&&z(b,function(b,d){if(4!=b.l)throw Error("Argument "+d+" to function "+a.o+" is not of type Nodeset: "+b);});J.call(this,a.l);this.C=a;this.c=b;kb(this,a.i||Ca(b,function(a){return a.i}));lb(this,a.M&&!b.length||a.L&&!!b.length||Ca(b,function(a){return a.b}))}
q(sb,J);sb.prototype.a=function(a){return this.C.u.apply(null,Ea(a,this.c))};sb.prototype.toString=function(){var a="Function: "+this.C;if(this.c.length)var b=A(this.c,function(a,b){return a+y(b)},"Arguments:"),a=a+y(b);return a};function tb(a,b,c,d,e,f,h,k,r){this.o=a;this.l=b;this.i=c;this.M=d;this.L=e;this.u=f;this.J=h;this.F=n(k)?k:h;this.N=!!r}tb.prototype.toString=function(){return this.o};var ub={};
function Q(a,b,c,d,e,f,h,k){if(ub.hasOwnProperty(a))throw Error("Function already created: "+a+".");ub[a]=new tb(a,b,c,d,!1,e,f,h,k)}Q("boolean",2,!1,!1,function(a,b){return N(b,a)},1);Q("ceiling",1,!1,!1,function(a,b){return Math.ceil(K(b,a))},1);Q("concat",3,!1,!1,function(a,b){return A(Fa(arguments,1),function(b,d){return b+M(d,a)},"")},2,null);Q("contains",2,!1,!1,function(a,b,c){b=M(b,a);a=M(c,a);return-1!=b.indexOf(a)},2);Q("count",1,!1,!1,function(a,b){return b.a(a).s},1,1,!0);
Q("false",2,!1,!1,function(){return!1},0);Q("floor",1,!1,!1,function(a,b){return Math.floor(K(b,a))},1);Q("id",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=M(b,a).split(/\s+/);var e=[];z(a,function(a){a=d.getElementById(a);!a||0<=Ba(e,a)||e.push(a)});e.sort(Xa);var f=new G;z(e,function(a){H(f,a)});return f},1);Q("lang",2,!1,!1,function(){return!1},1);Q("last",1,!0,!1,function(a){if(1!=arguments.length)throw Error("Function last expects ()");return a.f},0);
Q("local-name",3,!1,!0,function(a,b){return(a=b?hb(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():""},0,1,!0);Q("name",3,!1,!0,function(a,b){return(a=b?hb(b.a(a)):a.a)?a.nodeName.toLowerCase():""},0,1,!0);Q("namespace-uri",3,!0,!1,function(){return""},0,1,!0);Q("normalize-space",3,!1,!0,function(a,b){return(b?M(b,a):E(a.a)).replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")},0,1);Q("not",2,!1,!1,function(a,b){return!N(b,a)},1);Q("number",1,!1,!0,function(a,b){return b?K(b,a):+E(a.a)},0,1);
Q("position",1,!0,!1,function(a){return a.b},0);Q("round",1,!1,!1,function(a,b){return Math.round(K(b,a))},1);Q("starts-with",2,!1,!1,function(a,b,c){b=M(b,a);a=M(c,a);return!b.lastIndexOf(a,0)},2);Q("string",3,!1,!0,function(a,b){return b?M(b,a):E(a.a)},0,1);Q("string-length",1,!1,!0,function(a,b){return(b?M(b,a):E(a.a)).length},0,1);
Q("substring",3,!1,!1,function(a,b,c,d){c=K(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return"";d=d?K(d,a):Infinity;if(isNaN(d)||-Infinity===d)return"";c=Math.round(c)-1;var e=Math.max(c,0);a=M(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);Q("substring-after",3,!1,!1,function(a,b,c){b=M(b,a);a=M(c,a);c=b.indexOf(a);return-1==c?"":b.substring(c+a.length)},2);
Q("substring-before",3,!1,!1,function(a,b,c){b=M(b,a);a=M(c,a);a=b.indexOf(a);return-1==a?"":b.substring(0,a)},2);Q("sum",1,!1,!1,function(a,b){a=b.a(a).iterator();b=0;for(var c=a.next();c;c=a.next())b+=+E(c);return b},1,1,!0);Q("translate",3,!1,!1,function(a,b,c,d){b=M(b,a);c=M(c,a);var e=M(d,a);d={};for(var f=0;f<c.length;f++)a=c.charAt(f),a in d||(d[a]=e.charAt(f));c="";for(f=0;f<b.length;f++)a=b.charAt(f),c+=a in d?d[a]:a;return c},3);Q("true",2,!1,!1,function(){return!0},0);function vb(a){J.call(this,3);this.c=a.substring(1,a.length-1)}q(vb,J);vb.prototype.a=function(){return this.c};vb.prototype.toString=function(){return"Literal: "+this.c};function wb(a){J.call(this,1);this.c=a}q(wb,J);wb.prototype.a=function(){return this.c};wb.prototype.toString=function(){return"Number: "+this.c};function xb(a,b){J.call(this,a.l);this.j=a;this.c=b;this.i=a.i;this.b=a.b;1==this.c.length&&(a=this.c[0],a.D||a.c!=yb||(a=a.v,"*"!=a.f()&&(this.f={name:a.f(),B:null})))}q(xb,J);function zb(){J.call(this,4)}q(zb,J);zb.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?H(b,a):H(b,a.ownerDocument);return b};zb.prototype.toString=function(){return"Root Helper Expression"};function Ab(){J.call(this,4)}q(Ab,J);Ab.prototype.a=function(a){var b=new G;H(b,a.a);return b};Ab.prototype.toString=function(){return"Context Helper Expression"};
function Bb(a){return"/"==a||"//"==a}xb.prototype.a=function(a){var b=this.j.a(a);if(!(b instanceof G))throw Error("Filter expression must evaluate to nodeset.");a=this.c;for(var c=0,d=a.length;c<d&&b.s;c++){var e=a[c],f=b.iterator(e.c.A);if(e.i||e.c!=Cb)if(e.i||e.c!=Db){var h=f.next();for(b=e.a(new v(h));h=f.next();)h=e.a(new v(h)),b=fb(b,h)}else h=f.next(),b=e.a(new v(h));else{for(h=f.next();(b=f.next())&&(!h.contains||h.contains(b))&&b.compareDocumentPosition(h)&8;h=b);b=e.a(new v(h))}}return b};
xb.prototype.toString=function(){var a="Path Expression:"+y(this.j);if(this.c.length){var b=A(this.c,function(a,b){return a+y(b)},"Steps:");a+=y(b)}return a};function Eb(a,b){this.a=a;this.A=!!b}
function rb(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=b.iterator(),f=b.s,h,k=0;h=e.next();k++){var r=a.A?f-k:k+1;h=d.a(new v(h,r,f));if("number"==typeof h)r=r==h;else if("string"==typeof h||"boolean"==typeof h)r=!!h;else if(h instanceof G)r=0<h.s;else throw Error("Predicate.evaluate returned an unexpected type.");if(!r){r=e;h=r.f;var t=r.a;if(!t)throw Error("Next must be called at least once before remove.");var m=t.a,t=t.next;m?m.next=t:h.a=t;t?t.a=m:h.b=m;h.s--;r.a=null}}return b}
Eb.prototype.toString=function(){return A(this.a,function(a,b){return a+y(b)},"Predicates:")};function Fb(a){J.call(this,1);this.c=a;this.i=a.i;this.b=a.b}q(Fb,J);Fb.prototype.a=function(a){return-K(this.c,a)};Fb.prototype.toString=function(){return"Unary Expression: -"+y(this.c)};function Gb(a){J.call(this,4);this.c=a;kb(this,Ca(this.c,function(a){return a.i}));lb(this,Ca(this.c,function(a){return a.b}))}q(Gb,J);Gb.prototype.a=function(a){var b=new G;z(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error("Path expression must evaluate to NodeSet.");b=fb(b,c)});return b};Gb.prototype.toString=function(){return A(this.c,function(a,b){return a+y(b)},"Union Expression:")};function R(a,b,c,d){J.call(this,4);this.c=a;this.v=b;this.j=c||new Eb([]);this.D=!!d;b=this.j;b=0<b.a.length?b.a[0].f:null;a.R&&b&&(this.f={name:b.name,B:b.B});a:{a=this.j;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.i||1==c.l||0==c.l){a=!0;break a}a=!1}this.i=a}q(R,J);
R.prototype.a=function(a){var b=a.a,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.B?M(c.B,a):null,f=1);if(this.D)if(this.i||this.c!=Hb)if(b=(new R(Ib,new x("node"))).a(a).iterator(),c=b.next())for(a=this.u(c,d,e,f);c=b.next();)a=fb(a,this.u(c,d,e,f));else a=new G;else a=bb(this.v,b,d,e),a=rb(this.j,a,f);else a=this.u(a.a,d,e,f);return a};R.prototype.u=function(a,b,c,d){a=this.c.C(this.v,a,b,c);return a=rb(this.j,a,d)};
R.prototype.toString=function(){var a="Step:"+y("Operator: "+(this.D?"//":"/"));this.c.o&&(a+=y("Axis: "+this.c));a+=y(this.v);if(this.j.a.length){var b=A(this.j.a,function(a,b){return a+y(b)},"Predicates:");a+=y(b)}return a};function Jb(a,b,c,d){this.o=a;this.C=b;this.A=c;this.R=d}Jb.prototype.toString=function(){return this.o};var Kb={};function S(a,b,c,d){if(Kb.hasOwnProperty(a))throw Error("Axis already created: "+a);b=new Jb(a,b,c,!!d);return Kb[a]=b}
S("ancestor",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&gb(c,b);return c},!0);S("ancestor-or-self",function(a,b){var c=new G;do a.a(b)&&gb(c,b);while(b=b.parentNode);return c},!0);
var yb=S("attribute",function(a,b){var c=new G,d=a.f();if(b=b.attributes)if(a instanceof x&&null===a.b||"*"==d)for(d=0;a=b[d];d++)H(c,a);else(a=b.getNamedItem(d))&&H(c,a);return c},!1),Hb=S("child",function(a,b,c,d,e){c=p(c)?c:null;d=p(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)F(b,c,d)&&a.a(b)&&H(e,b);return e},!1,!0);S("descendant",bb,!1,!0);
var Ib=S("descendant-or-self",function(a,b,c,d){var e=new G;F(b,c,d)&&a.a(b)&&H(e,b);return bb(a,b,c,d,e)},!1,!0),Cb=S("following",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)F(f,c,d)&&a.a(f)&&H(e,f),e=bb(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);S("following-sibling",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&H(c,b);return c},!1);S("namespace",function(){return new G},!1);
var Lb=S("parent",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return H(c,b.ownerElement),c;b=b.parentNode;a.a(b)&&H(c,b);return c},!1),Db=S("preceding",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var h=1,k=f.length;h<k;h++){var r=[];for(b=f[h];b=b.previousSibling;)r.unshift(b);for(var t=0,m=r.length;t<m;t++)b=r[t],F(b,c,d)&&a.a(b)&&H(e,b),e=bb(a,b,c,d,e)}return e},!0,!0);
S("preceding-sibling",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&gb(c,b);return c},!0);var Mb=S("self",function(a,b){var c=new G;a.a(b)&&H(c,b);return c},!1);function Nb(a,b){this.a=a;this.b=b}function Ob(a){for(var b,c=[];;){U(a,"Missing right hand side of binary expression.");b=Pb(a);var d=a.a.next();if(!d)break;var e=(d=pb[d]||null)&&d.K;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].K;)b=new mb(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new mb(c.pop(),c.pop(),b);return b}function U(a,b){if(sa(a.a))throw Error(b);}function Qb(a,b){a=a.a.next();if(a!=b)throw Error("Bad token, expected: "+b+" got: "+a);}
function Rb(a){a=a.a.next();if(")"!=a)throw Error("Bad token: "+a);}function Sb(a){a=a.a.next();if(2>a.length)throw Error("Unclosed literal string");return new vb(a)}
function Tb(a){var b=[];if(Bb(w(a.a))){var c=a.a.next();var d=w(a.a);if("/"==c&&(sa(a.a)||"."!=d&&".."!=d&&"@"!=d&&"*"!=d&&!/(?![0-9])[\w]/.test(d)))return new zb;d=new zb;U(a,"Missing next location step.");c=Ub(a,c);b.push(c)}else{a:{c=w(a.a);d=c.charAt(0);switch(d){case "$":throw Error("Variable reference not allowed in HTML XPath");case "(":a.a.next();c=Ob(a);U(a,'unclosed "("');Qb(a,")");break;case '"':case "'":c=Sb(a);break;default:if(isNaN(+c))if(!wa(c)&&/(?![0-9])[\w]/.test(d)&&"("==w(a.a,
1)){c=a.a.next();c=ub[c]||null;a.a.next();for(d=[];")"!=w(a.a);){U(a,"Missing function argument list.");d.push(Ob(a));if(","!=w(a.a))break;a.a.next()}U(a,"Unclosed function argument list.");Rb(a);c=new sb(c,d)}else{c=null;break a}else c=new wb(+a.a.next())}"["==w(a.a)&&(d=new Eb(Vb(a)),c=new qb(c,d))}if(c)if(Bb(w(a.a)))d=c;else return c;else c=Ub(a,"/"),d=new Ab,b.push(c)}for(;Bb(w(a.a));)c=a.a.next(),U(a,"Missing next location step."),c=Ub(a,c),b.push(c);return new xb(d,b)}
function Ub(a,b){if("/"!=b&&"//"!=b)throw Error('Step op should be "/" or "//"');if("."==w(a.a)){var c=new R(Mb,new x("node"));a.a.next();return c}if(".."==w(a.a))return c=new R(Lb,new x("node")),a.a.next(),c;if("@"==w(a.a)){var d=yb;a.a.next();U(a,"Missing attribute name")}else if("::"==w(a.a,1)){if(!/(?![0-9])[\w]/.test(w(a.a).charAt(0)))throw Error("Bad token: "+a.a.next());var e=a.a.next();d=Kb[e]||null;if(!d)throw Error("No axis with name: "+e);a.a.next();U(a,"Missing node name")}else d=Hb;e=
w(a.a);if(/(?![0-9])[\w\*]/.test(e.charAt(0)))if("("==w(a.a,1)){if(!wa(e))throw Error("Invalid node type: "+e);e=a.a.next();if(!wa(e))throw Error("Invalid type name: "+e);Qb(a,"(");U(a,"Bad nodetype");var f=w(a.a).charAt(0),h=null;if('"'==f||"'"==f)h=Sb(a);U(a,"Bad nodetype");Rb(a);e=new x(e,h)}else if(e=a.a.next(),f=e.indexOf(":"),-1==f)e=new xa(e);else{var h=e.substring(0,f);if("*"==h)var k="*";else if(k=a.b(h),!k)throw Error("Namespace prefix not declared: "+h);e=e.substr(f+1);e=new xa(e,k)}else throw Error("Bad token: "+
a.a.next());a=new Eb(Vb(a),d.A);return c||new R(d,e,a,"//"==b)}function Vb(a){for(var b=[];"["==w(a.a);){a.a.next();U(a,"Missing predicate expression.");var c=Ob(a);b.push(c);U(a,"Unclosed predicate expression.");Qb(a,"]")}return b}function Pb(a){if("-"==w(a.a))return a.a.next(),new Fb(Pb(a));var b=Tb(a);if("|"!=w(a.a))a=b;else{for(b=[b];"|"==a.a.next();)U(a,"Missing next union location path."),b.push(Tb(a));a.a.a--;a=new Gb(b)}return a};function Wb(a,b){if(!a.length)throw Error("Empty XPath expression.");a=pa(a);if(sa(a))throw Error("Invalid XPath expression.");b?"function"==ca(b)||(b=fa(b.lookupNamespaceURI,b)):b=function(){return null};var c=Ob(new Nb(a,b));if(!sa(a))throw Error("Bad token: "+a.next());this.evaluate=function(a,b){a=c.a(new v(a));return new V(a,b)}}
function V(a,b){if(!b)if(a instanceof G)b=4;else if("string"==typeof a)b=2;else if("number"==typeof a)b=1;else if("boolean"==typeof a)b=3;else throw Error("Unexpected evaluation result.");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error("value could not be converted to the specified type");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?ib(a):""+a;break;case 1:this.numberValue=a instanceof G?+ib(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.s:!!a;break;case 4:case 5:case 6:case 7:var c=
a.iterator();var d=[];for(var e=c.next();e;e=c.next())d.push(e);this.snapshotLength=a.s;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=hb(a);break;default:throw Error("Unknown XPathResult type.");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error("iterateNext called with wrong result type");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error("snapshotItem called with wrong result type");return a>=d.length||0>a?null:d[a]}}
V.ANY_TYPE=0;V.NUMBER_TYPE=1;V.STRING_TYPE=2;V.BOOLEAN_TYPE=3;V.UNORDERED_NODE_ITERATOR_TYPE=4;V.ORDERED_NODE_ITERATOR_TYPE=5;V.UNORDERED_NODE_SNAPSHOT_TYPE=6;V.ORDERED_NODE_SNAPSHOT_TYPE=7;V.ANY_UNORDERED_NODE_TYPE=8;V.FIRST_ORDERED_NODE_TYPE=9;function Xb(a){this.lookupNamespaceURI=ya(a)}
ba("wgxpath.install",function(a,b){a=a||l;var c=a.Document&&a.Document.prototype||a.document;if(!c.evaluate||b)a.XPathResult=V,c.evaluate=function(a,b,c,h){return(new Wb(a,c)).evaluate(b,h)},c.createExpression=function(a,b){return new Wb(a,b)},c.createNSResolver=function(a){return new Xb(a)}});var W={};W.G=function(){var a={V:"http://www.w3.org/2000/svg"};return function(b){return a[b]||null}}();
W.u=function(a,b,c){var d=D(a);if(!d.documentElement)return null;try{for(var e=d.createNSResolver?d.createNSResolver(d.documentElement):W.G,f={},h=d.getElementsByTagName("*"),k=0;k<h.length;++k){var r=h[k],t=r.namespaceURI;if(t&&!f[t]){var m=r.lookupPrefix(t);if(!m)var C=t.match(".*/(\\w+)/?$"),m=C?C[1]:"xhtml";f[t]=m}}var L={},T;for(T in f)L[f[T]]=T;e=function(a){return L[a]||null};try{return d.evaluate(b,a,e,c,null)}catch(ga){if("TypeError"===ga.name)return e=d.createNSResolver?d.createNSResolver(d.documentElement):
W.G,d.evaluate(b,a,e,c,null);throw ga;}}catch(ga){if("NS_ERROR_ILLEGAL_VALUE"!=ga.name)throw new ia(32,"Unable to locate an element with the xpath expression "+b+" because of the following error:\n"+ga);}};W.H=function(a,b){if(!a||1!=a.nodeType)throw new ia(32,'The result of the xpath expression "'+b+'" is: '+a+". It should be an element.");};
W.P=function(a,b){var c=function(){var c=W.u(b,a,9);return c?c.singleNodeValue||null:b.selectSingleNode?(c=D(b),c.setProperty&&c.setProperty("SelectionLanguage","XPath"),b.selectSingleNode(a)):null}();null===c||W.H(c,a);return c};
W.T=function(a,b){var c=function(){var c=W.u(b,a,7);if(c){for(var e=c.snapshotLength,f=[],h=0;h<e;++h)f.push(c.snapshotItem(h));return f}return b.selectNodes?(c=D(b),c.setProperty&&c.setProperty("SelectionLanguage","XPath"),b.selectNodes(a)):[]}();z(c,function(b){W.H(b,a)});return c};var Yb="function"===typeof ShadowRoot;function Zb(a){for(a=a.parentNode;a&&1!=a.nodeType&&9!=a.nodeType&&11!=a.nodeType;)a=a.parentNode;return I(a)?a:null}
function X(a,b){b=na(b);if("float"==b||"cssFloat"==b||"styleFloat"==b)b="cssFloat";a:{var c=b;var d=D(a);if(d.defaultView&&d.defaultView.getComputedStyle&&(d=d.defaultView.getComputedStyle(a,null))){c=d[c]||d.getPropertyValue(c)||"";break a}c=""}a=c||$b(a,b);if(null===a)a=null;else if(0<=Ba(Ga,b)){b:{var e=a.match(Ja);if(e&&(b=Number(e[1]),c=Number(e[2]),d=Number(e[3]),e=Number(e[4]),0<=b&&255>=b&&0<=c&&255>=c&&0<=d&&255>=d&&0<=e&&1>=e)){b=[b,c,d,e];break b}b=null}if(!b)b:{if(d=a.match(Ka))if(b=Number(d[1]),
c=Number(d[2]),d=Number(d[3]),0<=b&&255>=b&&0<=c&&255>=c&&0<=d&&255>=d){b=[b,c,d,1];break b}b=null}if(!b)b:{b=a.toLowerCase();c=ka[b.toLowerCase()];if(!c&&(c="#"==b.charAt(0)?b:"#"+b,4==c.length&&(c=c.replace(Ha,"#$1$1$2$2$3$3")),!Ia.test(c))){b=null;break b}b=[parseInt(c.substr(1,2),16),parseInt(c.substr(3,2),16),parseInt(c.substr(5,2),16),1]}a=b?"rgba("+b.join(", ")+")":a}return a}
function $b(a,b){var c=a.currentStyle||a.style,d=c[b];!n(d)&&"function"==ca(c.getPropertyValue)&&(d=c.getPropertyValue(b));return"inherit"!=d?n(d)?d:null:(a=Zb(a))?$b(a,b):null}
function ac(a,b,c){function d(a){var b=bc(a);return 0<b.height&&0<b.width?!0:I(a,"PATH")&&(0<b.height||0<b.width)?(a=X(a,"stroke-width"),!!a&&0<parseInt(a,10)):"hidden"!=X(a,"overflow")&&Ca(a.childNodes,function(a){return 3==a.nodeType||I(a)&&d(a)})}function e(a){return cc(a)==Y&&Da(a.childNodes,function(a){return!I(a)||e(a)||!d(a)})}if(!I(a))throw Error("Argument to isShown must be of type Element");if(I(a,"BODY"))return!0;if(I(a,"OPTION")||I(a,"OPTGROUP"))return a=$a(a,function(a){return I(a,"SELECT")}),
!!a&&ac(a,!0,c);var f=dc(a);if(f)return!!f.I&&0<f.rect.width&&0<f.rect.height&&ac(f.I,b,c);if(I(a,"INPUT")&&"hidden"==a.type.toLowerCase()||I(a,"NOSCRIPT"))return!1;f=X(a,"visibility");return"collapse"!=f&&"hidden"!=f&&c(a)&&(b||ec(a))&&d(a)?!e(a):!1}
function fc(a){var b=Yb?function(c){if("none"==X(c,"display"))return!1;do{var d=c.parentNode;if(c.getDestinationInsertionPoints){var e=c.getDestinationInsertionPoints();0<e.length&&(d=e[e.length-1])}if(d instanceof ShadowRoot){if(d.host.shadowRoot!=d)return!1;d=d.host}else!d||9!=d.nodeType&&11!=d.nodeType||(d=null)}while(a&&1!=a.nodeType);return!d||b(d)}:function(a){if("none"==X(a,"display"))return!1;a=Zb(a);return!a||b(a)};return ac(a,!1,b)}var Y="hidden";
function cc(a){function b(a){function b(a){return a==h?!0:!X(a,"display").lastIndexOf("inline",0)||"absolute"==c&&"static"==X(a,"position")?!1:!0}var c=X(a,"position");if("fixed"==c)return t=!0,a==h?null:h;for(a=Zb(a);a&&!b(a);)a=Zb(a);return a}function c(a){var b=a;if("visible"==r)if(a==h&&k)b=k;else if(a==k)return{x:"visible",y:"visible"};b={x:X(b,"overflow-x"),y:X(b,"overflow-y")};a==h&&(b.x="visible"==b.x?"auto":b.x,b.y="visible"==b.y?"auto":b.y);return b}function d(a){if(a==h){var b=(new ab(f)).a;
a=b.scrollingElement?b.scrollingElement:"CSS1Compat"==b.compatMode?b.documentElement:b.body||b.documentElement;b=b.parentWindow||b.defaultView;a=new La(b.pageXOffset||a.scrollLeft,b.pageYOffset||a.scrollTop)}else a=new La(a.scrollLeft,a.scrollTop);return a}var e=gc(a);var f=D(a),h=f.documentElement,k=f.body,r=X(h,"overflow"),t;for(a=b(a);a;a=b(a)){var m=c(a);if("visible"!=m.x||"visible"!=m.y){var C=bc(a);if(!C.width||!C.height)return Y;var L=e.a<C.a,T=e.b<C.b;if(L&&"hidden"==m.x||T&&"hidden"==m.y)return Y;
if(L&&"visible"!=m.x||T&&"visible"!=m.y){L=d(a);T=e.b<C.b-L.y;if(e.a<C.a-L.x&&"visible"!=m.x||T&&"visible"!=m.x)return Y;e=cc(a);return e==Y?Y:"scroll"}L=e.f>=C.a+C.width;C=e.c>=C.b+C.height;if(L&&"hidden"==m.x||C&&"hidden"==m.y)return Y;if(L&&"visible"!=m.x||C&&"visible"!=m.y){if(t&&(m=d(a),e.f>=h.scrollWidth-m.x||e.a>=h.scrollHeight-m.y))return Y;e=cc(a);return e==Y?Y:"scroll"}}}return"none"}
function bc(a){var b=dc(a);if(b)return b.rect;if(I(a,"HTML"))return a=D(a),a=((a?a.parentWindow||a.defaultView:window)||window).document,a="CSS1Compat"==a.compatMode?a.documentElement:a.body,a=new la(a.clientWidth,a.clientHeight),new B(0,0,a.width,a.height);try{var c=a.getBoundingClientRect()}catch(d){return new B(0,0,0,0)}return new B(c.left,c.top,c.right-c.left,c.bottom-c.top)}
function dc(a){var b=I(a,"MAP");if(!b&&!I(a,"AREA"))return null;var c=b?a:I(a.parentNode,"MAP")?a.parentNode:null,d=null,e=null;c&&c.name&&(d=W.P('/descendant::*[@usemap = "#'+c.name+'"]',D(c)))&&(e=bc(d),b||"default"==a.shape.toLowerCase()||(a=hc(a),b=Math.min(Math.max(a.a,0),e.width),c=Math.min(Math.max(a.b,0),e.height),e=new B(b+e.a,c+e.b,Math.min(a.width,e.width-b),Math.min(a.height,e.height-c))));return{I:d,rect:e||new B(0,0,0,0)}}
function hc(a){var b=a.shape.toLowerCase();a=a.coords.split(",");if("rect"==b&&4==a.length){var b=a[0],c=a[1];return new B(b,c,a[2]-b,a[3]-c)}if("circle"==b&&3==a.length)return b=a[2],new B(a[0]-b,a[1]-b,2*b,2*b);if("poly"==b&&2<a.length){for(var b=a[0],c=a[1],d=b,e=c,f=2;f+1<a.length;f+=2)b=Math.min(b,a[f]),d=Math.max(d,a[f]),c=Math.min(c,a[f+1]),e=Math.max(e,a[f+1]);return new B(b,c,d-b,e-c)}return new B(0,0,0,0)}function gc(a){a=bc(a);return new Oa(a.b,a.a+a.width,a.b+a.height,a.a)}
function ic(a){return a.replace(/^[^\S\xa0]+|[^\S\xa0]+$/g,"")}
function jc(a,b,c){if(I(a,"BR"))b.push("");else{var d=I(a,"TD"),e=X(a,"display"),f=!d&&!(0<=Ba(kc,e)),h=n(a.previousElementSibling)?a.previousElementSibling:Va(a.previousSibling),h=h?X(h,"display"):"",k=X(a,"float")||X(a,"cssFloat")||X(a,"styleFloat");!f||"run-in"==h&&"none"==k||/^[\s\xa0]*$/.test(b[b.length-1]||"")||b.push("");var r=fc(a),t=null,m=null;r&&(t=X(a,"white-space"),m=X(a,"text-transform"));z(a.childNodes,function(a){c(a,b,r,t,m)});a=b[b.length-1]||"";!d&&"table-cell"!=e||!a||ma(a)||(b[b.length-
1]+=" ");f&&"run-in"!=e&&!/^[\s\xa0]*$/.test(a)&&b.push("")}}function lc(a,b){jc(a,b,function(a,b,e,f,h){3==a.nodeType&&e?mc(a,b,f,h):I(a)&&lc(a,b)})}var kc="inline inline-block inline-table none table-cell table-column table-column-group".split(" ");
function mc(a,b,c,d){a=a.nodeValue.replace(/[\u200b\u200e\u200f]/g,"");a=a.replace(/(\r\n|\r|\n)/g,"\n");if("normal"==c||"nowrap"==c)a=a.replace(/\n/g," ");a="pre"==c||"pre-wrap"==c?a.replace(/[ \f\t\v\u2028\u2029]/g,"\u00a0"):a.replace(/[\ \f\t\v\u2028\u2029]+/g," ");"capitalize"==d?a=a.replace(/(^|\s)(\S)/g,function(a,b,c){return b+c.toUpperCase()}):"uppercase"==d?a=a.toUpperCase():"lowercase"==d&&(a=a.toLowerCase());c=b.pop()||"";ma(c)&&!a.lastIndexOf(" ",0)&&(a=a.substr(1));b.push(c+a)}
function ec(a){var b=1,c=X(a,"opacity");c&&(b=Number(c));(a=Zb(a))&&(b*=ec(a));return b}
function nc(a,b,c,d,e){var f;if(3==a.nodeType&&c)mc(a,b,d,e);else if(I(a))if(I(a,"CONTENT")){for(f=a;f.parentNode;)f=f.parentNode;f instanceof ShadowRoot?z(a.getDistributedNodes(),function(a){nc(a,b,c,d,e)}):oc(a,b)}else if(I(a,"SHADOW")){for(f=a;f.parentNode;)f=f.parentNode;if(f instanceof ShadowRoot&&(a=f))for(a=a.olderShadowRoot;a;)z(a.childNodes,function(a){nc(a,b,c,d,e)}),a=a.olderShadowRoot}else oc(a,b)}
function oc(a,b){a.shadowRoot&&z(a.shadowRoot.childNodes,function(a){nc(a,b,!0,null,null)});jc(a,b,function(a,b,e,f,h){var c=null;1==a.nodeType?c=a:3==a.nodeType&&(c=a);c&&c.getDestinationInsertionPoints&&0<c.getDestinationInsertionPoints().length||nc(a,b,e,f,h)})};Ua&&Ua&&Ta(3.6);var pc={};function Z(a,b,c){var d=typeof a;("object"==d&&null!=a||"function"==d)&&(a=a.g);a=new qc(a);!b||b in pc&&!c||(pc[b]={key:a,shift:!1},c&&(pc[c]={key:a,shift:!0}));return a}function qc(a){this.code=a}Z(8);Z(9);Z(13);var rc=Z(16),sc=Z(17),tc=Z(18);Z(19);Z(20);Z(27);Z(32," ");Z(33);Z(34);Z(35);Z(36);Z(37);Z(38);Z(39);Z(40);Z(44);Z(45);Z(46);Z(48,"0",")");Z(49,"1","!");Z(50,"2","@");Z(51,"3","#");Z(52,"4","$");Z(53,"5","%");Z(54,"6","^");Z(55,"7","&");Z(56,"8","*");Z(57,"9","(");Z(65,"a","A");
Z(66,"b","B");Z(67,"c","C");Z(68,"d","D");Z(69,"e","E");Z(70,"f","F");Z(71,"g","G");Z(72,"h","H");Z(73,"i","I");Z(74,"j","J");Z(75,"k","K");Z(76,"l","L");Z(77,"m","M");Z(78,"n","N");Z(79,"o","O");Z(80,"p","P");Z(81,"q","Q");Z(82,"r","R");Z(83,"s","S");Z(84,"t","T");Z(85,"u","U");Z(86,"v","V");Z(87,"w","W");Z(88,"x","X");Z(89,"y","Y");Z(90,"z","Z");var uc=Z(Na?{g:91,h:91}:Ma?{g:224,h:91}:{g:0,h:91});Z(Na?{g:92,h:92}:Ma?{g:224,h:93}:{g:0,h:92});Z(Na?{g:93,h:93}:Ma?{g:0,h:0}:{g:93,h:null});
Z({g:96,h:96},"0");Z({g:97,h:97},"1");Z({g:98,h:98},"2");Z({g:99,h:99},"3");Z({g:100,h:100},"4");Z({g:101,h:101},"5");Z({g:102,h:102},"6");Z({g:103,h:103},"7");Z({g:104,h:104},"8");Z({g:105,h:105},"9");Z({g:106,h:106},"*");Z({g:107,h:107},"+");Z({g:109,h:109},"-");Z({g:110,h:110},".");Z({g:111,h:111},"/");Z(144);Z(112);Z(113);Z(114);Z(115);Z(116);Z(117);Z(118);Z(119);Z(120);Z(121);Z(122);Z(123);Z({g:107,h:187},"=","+");Z(108,",");Z({g:109,h:189},"-","_");Z(188,",","<");Z(190,".",">");Z(191,"/","?");
Z(192,"`","~");Z(219,"[","{");Z(220,"\\","|");Z(221,"]","}");Z({g:59,h:186},";",":");Z(222,"'",'"');var vc=new Pa;vc.set(1,rc);vc.set(2,sc);vc.set(4,tc);vc.set(8,uc);(function(a){var b=new Pa;z(Qa(a),function(c){b.set(a.get(c).code,c)});return b})(vc);Ua&&Sa(12);ba("_",function(a){var b=[];Yb?oc(a,b):lc(a,b);a=b;for(var b=a.length,c=Array(b),d=p(a)?a.split(""):a,e=0;e<b;e++)e in d&&(c[e]=ic.call(void 0,d[e],e,a));return ic(c.join("\n")).replace(/\xa0/g," ")});; return this._.apply(null,arguments);}.apply({navigator:typeof window!='undefined'?window.navigator:null,document:typeof window!='undefined'?window.document:null}, arguments);}

// https://github.com/SeleniumHQ/selenium/blob/master/javascript/atoms/dom.js#L189
atom.isElementEnabled = function(element, window){return function(){var h=this;function k(a){return"string"==typeof a}function aa(a,b){a=a.split(".");var c=h;a[0]in c||!c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)a.length||void 0===b?c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}:c[d]=b}
function ba(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b}function ca(a,b,c){return a.call.apply(a.bind,arguments)}function da(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}
function m(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?m=ca:m=da;return m.apply(null,arguments)}function ea(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}
function n(a){var b=p;function c(){}c.prototype=b.prototype;a.K=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.J=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};
function q(a,b,c){this.a=a;this.b=b||1;this.g=c||1};function fa(a){this.b=a;this.a=0}function ga(a){a=a.match(ha);for(var b=0;b<a.length;b++)ia.test(a[b])&&a.splice(b,1);return new fa(a)}var ha=/\$?(?:(?![0-9-\.])(?:\*|[\w-\.]+):)?(?![0-9-\.])(?:\*|[\w-\.]+)|\/\/|\.\.|::|\d+(?:\.\d*)?|\.\d+|"[^"]*"|'[^']*'|[!<>]=|\s+|./g,ia=/^\s/;function r(a,b){return a.b[a.a+(b||0)]}function t(a){return a.b[a.a++]}function u(a){return a.b.length<=a.a};function w(a,b){this.h=a;this.c=void 0!==b?b:null;this.b=null;switch(a){case "comment":this.b=8;break;case "text":this.b=3;break;case "processing-instruction":this.b=7;break;case "node":break;default:throw Error("Unexpected argument");}}function ja(a){return"comment"==a||"text"==a||"processing-instruction"==a||"node"==a}w.prototype.a=function(a){return null===this.b||this.b==a.nodeType};w.prototype.g=function(){return this.h};
w.prototype.toString=function(){var a="Kind Test: "+this.h;null===this.c||(a+=x(this.c));return a};function y(a,b){this.j=a.toLowerCase();a="*"==this.j?"*":"http://www.w3.org/1999/xhtml";this.b=b?b.toLowerCase():a}y.prototype.a=function(a){var b=a.nodeType;if(1!=b&&2!=b)return!1;b=void 0!==a.localName?a.localName:a.nodeName;return"*"!=this.j&&this.j!=b.toLowerCase()?!1:"*"==this.b?!0:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():"http://www.w3.org/1999/xhtml")};y.prototype.g=function(){return this.j};
y.prototype.toString=function(){return"Name Test: "+("http://www.w3.org/1999/xhtml"==this.b?"":this.b+":")+this.j};function ka(a){switch(a.nodeType){case 1:return ea(la,a);case 9:return ka(a.documentElement);case 11:case 10:case 6:case 12:return ma;default:return a.parentNode?ka(a.parentNode):ma}}function ma(){return null}function la(a,b){if(a.prefix==b)return a.namespaceURI||"http://www.w3.org/1999/xhtml";var c=a.getAttributeNode("xmlns:"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?la(a.parentNode,b):null};function z(a,b){for(var c=a.length,d=k(a)?a.split(""):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function B(a,b,c){var d=c;z(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function C(a,b){for(var c=a.length,d=k(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}function na(a){return Array.prototype.concat.apply([],arguments)}function oa(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};(function(){var a=h.Components;if(!a)return!1;try{if(!a.classes)return!1}catch(c){return!1}var b=a.classes,a=a.interfaces;b["@mozilla.org/xpcom/version-comparator;1"].getService(a.nsIVersionComparator);b["@mozilla.org/xre/app-info;1"].getService(a.nsIXULAppInfo);return!0})();function pa(a){for(;a&&1!=a.nodeType;)a=a.previousSibling;return a}function qa(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if("undefined"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}
function ra(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if("sourceIndex"in a||a.parentNode&&"sourceIndex"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?sa(a,b):!c&&qa(e,b)?-1*ta(a,b):!d&&qa(f,a)?ta(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}d=9==a.nodeType?a:a.ownerDocument||a.document;c=d.createRange();c.selectNode(a);c.collapse(!0);
a=d.createRange();a.selectNode(b);a.collapse(!0);return c.compareBoundaryPoints(h.Range.START_TO_END,a)}function ta(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return sa(b,a)}function sa(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1}function ua(a,b){for(var c=0;a;){if(b(a))return a;a=a.parentNode;c++}return null};function D(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?"":b);if("string"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;for(var c=0,d=[],b="";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return""+b}
function E(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function F(a,b,c,d,e){return va.call(null,a,b,k(c)?c:null,k(d)?d:null,e||new G)}
function va(a,b,c,d,e){b.getElementsByName&&d&&"name"==c?(b=b.getElementsByName(d),z(b,function(b){a.a(b)&&H(e,b)})):b.getElementsByClassName&&d&&"class"==c?(b=b.getElementsByClassName(d),z(b,function(b){b.className==d&&a.a(b)&&H(e,b)})):a instanceof w?wa(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.g()),z(b,function(a){E(a,c,d)&&H(e,a)}));return e}function wa(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&H(e,b),wa(a,b,c,d,e)};function I(a,b){b&&"string"!==typeof b&&(b=b.toString());return!!a&&1==a.nodeType&&(!b||a.tagName.toUpperCase()==b)};function G(){this.b=this.a=null;this.l=0}function xa(a){this.node=a;this.a=this.b=null}function ya(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.node==b.node?(e=c,c=c.a,b=b.a):0<ra(c.node,b.node)?(e=b,b=b.a):(e=c,c=c.a),(e.b=d)?d.a=e:a.a=e,d=e,f++;for(e=c||b;e;)e.b=d,d=d.a=e,f++,e=e.a;a.b=d;a.l=f;return a}function za(a,b){b=new xa(b);b.a=a.a;a.b?a.a.b=b:a.a=a.b=b;a.a=b;a.l++}function H(a,b){b=new xa(b);b.b=a.b;a.a?a.b.a=b:a.a=a.b=b;a.b=b;a.l++}
function J(a){return(a=a.a)?a.node:null}function K(a){return(a=J(a))?D(a):""}function L(a,b){return new Aa(a,!!b)}function Aa(a,b){this.g=a;this.b=(this.s=b)?a.b:a.a;this.a=null}function M(a){var b=a.b;if(b){var c=a.a=b;a.b=a.s?b.b:b.a;return c.node}return null};function p(a){this.i=a;this.b=this.f=!1;this.g=null}function x(a){return"\n  "+a.toString().split("\n").join("\n  ")}function Ba(a,b){a.f=b}function Ca(a,b){a.b=b}function N(a,b){a=a.a(b);return a instanceof G?+K(a):+a}function O(a,b){a=a.a(b);return a instanceof G?K(a):""+a}function Q(a,b){a=a.a(b);return a instanceof G?!!a.l:!!a};function R(a,b,c){p.call(this,a.i);this.c=a;this.h=b;this.o=c;this.f=b.f||c.f;this.b=b.b||c.b;this.c==Da&&(c.b||c.f||4==c.i||0==c.i||!b.g?b.b||b.f||4==b.i||0==b.i||!c.g||(this.g={name:c.g.name,u:b}):this.g={name:b.g.name,u:c})}n(R);
function S(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=L(b);for(d=M(b);d;d=M(b))for(e=L(c),f=M(e);f;f=M(e))if(a(D(d),D(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=L(e);for(var g=typeof d,l=M(f);l;l=M(f)){switch(g){case "number":l=+D(l);break;case "boolean":l=!!D(l);break;case "string":l=D(l);break;default:throw Error("Illegal primitive type for comparison.");}if(e==b&&a(l,d)||e==c&&a(d,l))return!0}return!1}return e?"boolean"==
typeof b||"boolean"==typeof c?a(!!b,!!c):"number"==typeof b||"number"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}R.prototype.a=function(a){return this.c.m(this.h,this.o,a)};R.prototype.toString=function(){var a="Binary Expression: "+this.c,a=a+x(this.h);return a+=x(this.o)};function Ea(a,b,c,d){this.H=a;this.C=b;this.i=c;this.m=d}Ea.prototype.toString=function(){return this.H};var Fa={};
function T(a,b,c,d){if(Fa.hasOwnProperty(a))throw Error("Binary operator already created: "+a);a=new Ea(a,b,c,d);return Fa[a.toString()]=a}T("div",6,1,function(a,b,c){return N(a,c)/N(b,c)});T("mod",6,1,function(a,b,c){return N(a,c)%N(b,c)});T("*",6,1,function(a,b,c){return N(a,c)*N(b,c)});T("+",5,1,function(a,b,c){return N(a,c)+N(b,c)});T("-",5,1,function(a,b,c){return N(a,c)-N(b,c)});T("<",4,2,function(a,b,c){return S(function(a,b){return a<b},a,b,c)});
T(">",4,2,function(a,b,c){return S(function(a,b){return a>b},a,b,c)});T("<=",4,2,function(a,b,c){return S(function(a,b){return a<=b},a,b,c)});T(">=",4,2,function(a,b,c){return S(function(a,b){return a>=b},a,b,c)});var Da=T("=",3,2,function(a,b,c){return S(function(a,b){return a==b},a,b,c,!0)});T("!=",3,2,function(a,b,c){return S(function(a,b){return a!=b},a,b,c,!0)});T("and",2,2,function(a,b,c){return Q(a,c)&&Q(b,c)});T("or",1,2,function(a,b,c){return Q(a,c)||Q(b,c)});function Ga(a,b){if(b.a.length&&4!=a.i)throw Error("Primary expression must evaluate to nodeset if filter has predicate(s).");p.call(this,a.i);this.c=a;this.h=b;this.f=a.f;this.b=a.b}n(Ga);Ga.prototype.a=function(a){a=this.c.a(a);return Ha(this.h,a)};Ga.prototype.toString=function(){var a="Filter:"+x(this.c);return a+=x(this.h)};function Ia(a,b){if(b.length<a.B)throw Error("Function "+a.j+" expects at least"+a.B+" arguments, "+b.length+" given");if(null!==a.A&&b.length>a.A)throw Error("Function "+a.j+" expects at most "+a.A+" arguments, "+b.length+" given");a.G&&z(b,function(b,d){if(4!=b.i)throw Error("Argument "+d+" to function "+a.j+" is not of type Nodeset: "+b);});p.call(this,a.i);this.v=a;this.c=b;Ba(this,a.f||C(b,function(a){return a.f}));Ca(this,a.F&&!b.length||a.D&&!!b.length||C(b,function(a){return a.b}))}n(Ia);
Ia.prototype.a=function(a){return this.v.m.apply(null,na(a,this.c))};Ia.prototype.toString=function(){var a="Function: "+this.v;if(this.c.length)var b=B(this.c,function(a,b){return a+x(b)},"Arguments:"),a=a+x(b);return a};function Ja(a,b,c,d,e,f,g,l,v){this.j=a;this.i=b;this.f=c;this.F=d;this.D=e;this.m=f;this.B=g;this.A=void 0!==l?l:g;this.G=!!v}Ja.prototype.toString=function(){return this.j};var Ka={};
function U(a,b,c,d,e,f,g,l){if(Ka.hasOwnProperty(a))throw Error("Function already created: "+a+".");Ka[a]=new Ja(a,b,c,d,!1,e,f,g,l)}U("boolean",2,!1,!1,function(a,b){return Q(b,a)},1);U("ceiling",1,!1,!1,function(a,b){return Math.ceil(N(b,a))},1);U("concat",3,!1,!1,function(a,b){return B(oa(arguments,1),function(b,d){return b+O(d,a)},"")},2,null);U("contains",2,!1,!1,function(a,b,c){b=O(b,a);a=O(c,a);return-1!=b.indexOf(a)},2);U("count",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);
U("false",2,!1,!1,function(){return!1},0);U("floor",1,!1,!1,function(a,b){return Math.floor(N(b,a))},1);U("id",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=O(b,a).split(/\s+/);var e=[];z(a,function(a){a=d.getElementById(a);var b;if(!(b=!a)){a:if(k(e))b=k(a)&&1==a.length?e.indexOf(a,0):-1;else{for(b=0;b<e.length;b++)if(b in e&&e[b]===a)break a;b=-1}b=0<=b}b||e.push(a)});e.sort(ra);var f=new G;z(e,function(a){H(f,a)});return f},1);U("lang",2,!1,!1,function(){return!1},1);
U("last",1,!0,!1,function(a){if(1!=arguments.length)throw Error("Function last expects ()");return a.g},0);U("local-name",3,!1,!0,function(a,b){return(a=b?J(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():""},0,1,!0);U("name",3,!1,!0,function(a,b){return(a=b?J(b.a(a)):a.a)?a.nodeName.toLowerCase():""},0,1,!0);U("namespace-uri",3,!0,!1,function(){return""},0,1,!0);U("normalize-space",3,!1,!0,function(a,b){return(b?O(b,a):D(a.a)).replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")},0,1);
U("not",2,!1,!1,function(a,b){return!Q(b,a)},1);U("number",1,!1,!0,function(a,b){return b?N(b,a):+D(a.a)},0,1);U("position",1,!0,!1,function(a){return a.b},0);U("round",1,!1,!1,function(a,b){return Math.round(N(b,a))},1);U("starts-with",2,!1,!1,function(a,b,c){b=O(b,a);a=O(c,a);return!b.lastIndexOf(a,0)},2);U("string",3,!1,!0,function(a,b){return b?O(b,a):D(a.a)},0,1);U("string-length",1,!1,!0,function(a,b){return(b?O(b,a):D(a.a)).length},0,1);
U("substring",3,!1,!1,function(a,b,c,d){c=N(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return"";d=d?N(d,a):Infinity;if(isNaN(d)||-Infinity===d)return"";c=Math.round(c)-1;var e=Math.max(c,0);a=O(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);U("substring-after",3,!1,!1,function(a,b,c){b=O(b,a);a=O(c,a);c=b.indexOf(a);return-1==c?"":b.substring(c+a.length)},2);
U("substring-before",3,!1,!1,function(a,b,c){b=O(b,a);a=O(c,a);a=b.indexOf(a);return-1==a?"":b.substring(0,a)},2);U("sum",1,!1,!1,function(a,b){a=L(b.a(a));b=0;for(var c=M(a);c;c=M(a))b+=+D(c);return b},1,1,!0);U("translate",3,!1,!1,function(a,b,c,d){b=O(b,a);c=O(c,a);var e=O(d,a);d={};for(var f=0;f<c.length;f++)a=c.charAt(f),a in d||(d[a]=e.charAt(f));c="";for(f=0;f<b.length;f++)a=b.charAt(f),c+=a in d?d[a]:a;return c},3);U("true",2,!1,!1,function(){return!0},0);function La(a){p.call(this,3);this.c=a.substring(1,a.length-1)}n(La);La.prototype.a=function(){return this.c};La.prototype.toString=function(){return"Literal: "+this.c};function Ma(a){p.call(this,1);this.c=a}n(Ma);Ma.prototype.a=function(){return this.c};Ma.prototype.toString=function(){return"Number: "+this.c};function Na(a,b){p.call(this,a.i);this.h=a;this.c=b;this.f=a.f;this.b=a.b;1==this.c.length&&(a=this.c[0],a.w||a.c!=Oa||(a=a.o,"*"!=a.g()&&(this.g={name:a.g(),u:null})))}n(Na);function V(){p.call(this,4)}n(V);V.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?H(b,a):H(b,a.ownerDocument);return b};V.prototype.toString=function(){return"Root Helper Expression"};function Pa(){p.call(this,4)}n(Pa);Pa.prototype.a=function(a){var b=new G;H(b,a.a);return b};Pa.prototype.toString=function(){return"Context Helper Expression"};
function Qa(a){return"/"==a||"//"==a}Na.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof G))throw Error("Filter expression must evaluate to nodeset.");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=L(b,e.c.s);if(e.f||e.c!=Ra)if(e.f||e.c!=Sa){var g=M(f);for(b=e.a(new q(g));g=M(f);)g=e.a(new q(g)),b=ya(b,g)}else g=M(f),b=e.a(new q(g));else{for(g=M(f);(b=M(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new q(g))}}return b};
Na.prototype.toString=function(){var a="Path Expression:"+x(this.h);if(this.c.length){var b=B(this.c,function(a,b){return a+x(b)},"Steps:");a+=x(b)}return a};function Ta(a,b){this.a=a;this.s=!!b}
function Ha(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=L(b),f=b.l,g,l=0;g=M(e);l++){var v=a.s?f-l:l+1;g=d.a(new q(g,v,f));if("number"==typeof g)v=v==g;else if("string"==typeof g||"boolean"==typeof g)v=!!g;else if(g instanceof G)v=0<g.l;else throw Error("Predicate.evaluate returned an unexpected type.");if(!v){v=e;g=v.g;var A=v.a;if(!A)throw Error("Next must be called at least once before remove.");var P=A.b,A=A.a;P?P.a=A:g.a=A;A?A.b=P:g.b=P;g.l--;v.a=null}}return b}
Ta.prototype.toString=function(){return B(this.a,function(a,b){return a+x(b)},"Predicates:")};function Ua(a){p.call(this,1);this.c=a;this.f=a.f;this.b=a.b}n(Ua);Ua.prototype.a=function(a){return-N(this.c,a)};Ua.prototype.toString=function(){return"Unary Expression: -"+x(this.c)};function Va(a){p.call(this,4);this.c=a;Ba(this,C(this.c,function(a){return a.f}));Ca(this,C(this.c,function(a){return a.b}))}n(Va);Va.prototype.a=function(a){var b=new G;z(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error("Path expression must evaluate to NodeSet.");b=ya(b,c)});return b};Va.prototype.toString=function(){return B(this.c,function(a,b){return a+x(b)},"Union Expression:")};function W(a,b,c,d){p.call(this,4);this.c=a;this.o=b;this.h=c||new Ta([]);this.w=!!d;b=this.h;b=0<b.a.length?b.a[0].g:null;a.I&&b&&(this.g={name:b.name,u:b.u});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.f||1==c.i||0==c.i){a=!0;break a}a=!1}this.f=a}n(W);
W.prototype.a=function(a){var b=a.a,c=this.g,d=null,e=null,f=0;c&&(d=c.name,e=c.u?O(c.u,a):null,f=1);if(this.w)if(this.f||this.c!=Wa)if(b=L((new W(Xa,new w("node"))).a(a)),c=M(b))for(a=this.m(c,d,e,f);c=M(b);)a=ya(a,this.m(c,d,e,f));else a=new G;else a=F(this.o,b,d,e),a=Ha(this.h,a,f);else a=this.m(a.a,d,e,f);return a};W.prototype.m=function(a,b,c,d){a=this.c.v(this.o,a,b,c);return a=Ha(this.h,a,d)};
W.prototype.toString=function(){var a="Step:"+x("Operator: "+(this.w?"//":"/"));this.c.j&&(a+=x("Axis: "+this.c));a+=x(this.o);if(this.h.a.length){var b=B(this.h.a,function(a,b){return a+x(b)},"Predicates:");a+=x(b)}return a};function Ya(a,b,c,d){this.j=a;this.v=b;this.s=c;this.I=d}Ya.prototype.toString=function(){return this.j};var Za={};function X(a,b,c,d){if(Za.hasOwnProperty(a))throw Error("Axis already created: "+a);b=new Ya(a,b,c,!!d);return Za[a]=b}
X("ancestor",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&za(c,b);return c},!0);X("ancestor-or-self",function(a,b){var c=new G;do a.a(b)&&za(c,b);while(b=b.parentNode);return c},!0);
var Oa=X("attribute",function(a,b){var c=new G,d=a.g();if(b=b.attributes)if(a instanceof w&&null===a.b||"*"==d)for(d=0;a=b[d];d++)H(c,a);else(a=b.getNamedItem(d))&&H(c,a);return c},!1),Wa=X("child",function(a,b,c,d,e){c=k(c)?c:null;d=k(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&H(e,b);return e},!1,!0);X("descendant",F,!1,!0);
var Xa=X("descendant-or-self",function(a,b,c,d){var e=new G;E(b,c,d)&&a.a(b)&&H(e,b);return F(a,b,c,d,e)},!1,!0),Ra=X("following",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)E(f,c,d)&&a.a(f)&&H(e,f),e=F(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);X("following-sibling",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&H(c,b);return c},!1);X("namespace",function(){return new G},!1);
var $a=X("parent",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return H(c,b.ownerElement),c;b=b.parentNode;a.a(b)&&H(c,b);return c},!1),Sa=X("preceding",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,l=f.length;g<l;g++){var v=[];for(b=f[g];b=b.previousSibling;)v.unshift(b);for(var A=0,P=v.length;A<P;A++)b=v[A],E(b,c,d)&&a.a(b)&&H(e,b),e=F(a,b,c,d,e)}return e},!0,!0);
X("preceding-sibling",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&za(c,b);return c},!0);var ab=X("self",function(a,b){var c=new G;a.a(b)&&H(c,b);return c},!1);function bb(a,b){this.a=a;this.b=b}function cb(a){for(var b,c=[];;){Y(a,"Missing right hand side of binary expression.");b=db(a);var d=t(a.a);if(!d)break;var e=(d=Fa[d]||null)&&d.C;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].C;)b=new R(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new R(c.pop(),c.pop(),b);return b}function Y(a,b){if(u(a.a))throw Error(b);}function eb(a,b){a=t(a.a);if(a!=b)throw Error("Bad token, expected: "+b+" got: "+a);}
function fb(a){a=t(a.a);if(")"!=a)throw Error("Bad token: "+a);}function gb(a){a=t(a.a);if(2>a.length)throw Error("Unclosed literal string");return new La(a)}
function hb(a){var b=[];if(Qa(r(a.a))){var c=t(a.a);var d=r(a.a);if("/"==c&&(u(a.a)||"."!=d&&".."!=d&&"@"!=d&&"*"!=d&&!/(?![0-9])[\w]/.test(d)))return new V;d=new V;Y(a,"Missing next location step.");c=ib(a,c);b.push(c)}else{a:{c=r(a.a);d=c.charAt(0);switch(d){case "$":throw Error("Variable reference not allowed in HTML XPath");case "(":t(a.a);c=cb(a);Y(a,'unclosed "("');eb(a,")");break;case '"':case "'":c=gb(a);break;default:if(isNaN(+c))if(!ja(c)&&/(?![0-9])[\w]/.test(d)&&"("==r(a.a,1)){c=t(a.a);
c=Ka[c]||null;t(a.a);for(d=[];")"!=r(a.a);){Y(a,"Missing function argument list.");d.push(cb(a));if(","!=r(a.a))break;t(a.a)}Y(a,"Unclosed function argument list.");fb(a);c=new Ia(c,d)}else{c=null;break a}else c=new Ma(+t(a.a))}"["==r(a.a)&&(d=new Ta(jb(a)),c=new Ga(c,d))}if(c)if(Qa(r(a.a)))d=c;else return c;else c=ib(a,"/"),d=new Pa,b.push(c)}for(;Qa(r(a.a));)c=t(a.a),Y(a,"Missing next location step."),c=ib(a,c),b.push(c);return new Na(d,b)}
function ib(a,b){if("/"!=b&&"//"!=b)throw Error('Step op should be "/" or "//"');if("."==r(a.a)){var c=new W(ab,new w("node"));t(a.a);return c}if(".."==r(a.a))return c=new W($a,new w("node")),t(a.a),c;if("@"==r(a.a)){var d=Oa;t(a.a);Y(a,"Missing attribute name")}else if("::"==r(a.a,1)){if(!/(?![0-9])[\w]/.test(r(a.a).charAt(0)))throw Error("Bad token: "+t(a.a));var e=t(a.a);d=Za[e]||null;if(!d)throw Error("No axis with name: "+e);t(a.a);Y(a,"Missing node name")}else d=Wa;e=r(a.a);if(/(?![0-9])[\w\*]/.test(e.charAt(0)))if("("==
r(a.a,1)){if(!ja(e))throw Error("Invalid node type: "+e);e=t(a.a);if(!ja(e))throw Error("Invalid type name: "+e);eb(a,"(");Y(a,"Bad nodetype");var f=r(a.a).charAt(0),g=null;if('"'==f||"'"==f)g=gb(a);Y(a,"Bad nodetype");fb(a);e=new w(e,g)}else if(e=t(a.a),f=e.indexOf(":"),-1==f)e=new y(e);else{var g=e.substring(0,f);if("*"==g)var l="*";else if(l=a.b(g),!l)throw Error("Namespace prefix not declared: "+g);e=e.substr(f+1);e=new y(e,l)}else throw Error("Bad token: "+t(a.a));a=new Ta(jb(a),d.s);return c||
new W(d,e,a,"//"==b)}function jb(a){for(var b=[];"["==r(a.a);){t(a.a);Y(a,"Missing predicate expression.");var c=cb(a);b.push(c);Y(a,"Unclosed predicate expression.");eb(a,"]")}return b}function db(a){if("-"==r(a.a))return t(a.a),new Ua(db(a));var b=hb(a);if("|"!=r(a.a))a=b;else{for(b=[b];"|"==t(a.a);)Y(a,"Missing next union location path."),b.push(hb(a));a.a.a--;a=new Va(b)}return a};function kb(a,b){if(!a.length)throw Error("Empty XPath expression.");a=ga(a);if(u(a))throw Error("Invalid XPath expression.");b?"function"==ba(b)||(b=m(b.lookupNamespaceURI,b)):b=function(){return null};var c=cb(new bb(a,b));if(!u(a))throw Error("Bad token: "+t(a));this.evaluate=function(a,b){a=c.a(new q(a));return new Z(a,b)}}
function Z(a,b){if(!b)if(a instanceof G)b=4;else if("string"==typeof a)b=2;else if("number"==typeof a)b=1;else if("boolean"==typeof a)b=3;else throw Error("Unexpected evaluation result.");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error("value could not be converted to the specified type");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?K(a):""+a;break;case 1:this.numberValue=a instanceof G?+K(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var c=
L(a);var d=[];for(var e=M(c);e;e=M(c))d.push(e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=J(a);break;default:throw Error("Unknown XPathResult type.");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error("iterateNext called with wrong result type");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error("snapshotItem called with wrong result type");return a>=d.length||0>a?null:d[a]}}Z.ANY_TYPE=0;
Z.NUMBER_TYPE=1;Z.STRING_TYPE=2;Z.BOOLEAN_TYPE=3;Z.UNORDERED_NODE_ITERATOR_TYPE=4;Z.ORDERED_NODE_ITERATOR_TYPE=5;Z.UNORDERED_NODE_SNAPSHOT_TYPE=6;Z.ORDERED_NODE_SNAPSHOT_TYPE=7;Z.ANY_UNORDERED_NODE_TYPE=8;Z.FIRST_ORDERED_NODE_TYPE=9;function lb(a){this.lookupNamespaceURI=ka(a)}
aa("wgxpath.install",function(a,b){a=a||h;var c=a.Document&&a.Document.prototype||a.document;if(!c.evaluate||b)a.XPathResult=Z,c.evaluate=function(a,b,c,g){return(new kb(a,c)).evaluate(b,g)},c.createExpression=function(a,b){return new kb(a,b)},c.createNSResolver=function(a){return new lb(a)}});var mb="BUTTON INPUT OPTGROUP OPTION SELECT TEXTAREA".split(" ");function nb(a){return C(mb,function(b){return I(a,b)})?a.disabled?!1:a.parentNode&&1==a.parentNode.nodeType&&I(a,"OPTGROUP")||I(a,"OPTION")?nb(a.parentNode):!ua(a,function(a){var b=a.parentNode;if(b&&I(b,"FIELDSET")&&b.disabled){if(!I(a,"LEGEND"))return!0;for(;a=void 0!==a.previousElementSibling?a.previousElementSibling:pa(a.previousSibling);)if(I(a,"LEGEND"))return!0}return!1}):!0};aa("_",nb);; return this._.apply(null,arguments);}.apply({navigator:typeof window!='undefined'?window.navigator:null,document:typeof window!='undefined'?window.document:null}, arguments);}

// https://github.com/SeleniumHQ/selenium/blob/master/javascript/atoms/dom.js#L435
atom.isElementDisplayed = function(element, window){return function(){var aa=this;function h(a){return void 0!==a}function l(a){return"string"==typeof a}function ba(a,b){a=a.split(".");var c=aa;a[0]in c||!c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)!a.length&&h(b)?c[d]=b:c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}}
function ca(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b}function da(a,b,c){return a.call.apply(a.bind,arguments)}function ea(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}
function fa(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?fa=da:fa=ea;return fa.apply(null,arguments)}function ga(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}
function n(a,b){function c(){}c.prototype=b.prototype;a.L=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.K=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function ha(a,b){this.code=a;this.a=p[a]||ia;this.message=b||"";a=this.a.replace(/((?:^|\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\s\xa0]+/g,"")});b=a.length-5;if(0>b||a.indexOf("Error",b)!=b)a+="Error";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||""}n(ha,Error);var ia="unknown error",p={15:"element not selectable",11:"element not visible"};p[31]=ia;p[30]=ia;p[24]="invalid cookie domain";p[29]="invalid element coordinates";p[12]="invalid element state";
p[32]="invalid selector";p[51]="invalid selector";p[52]="invalid selector";p[17]="javascript error";p[405]="unsupported operation";p[34]="move target out of bounds";p[27]="no such alert";p[7]="no such element";p[8]="no such frame";p[23]="no such window";p[28]="script timeout";p[33]="session not created";p[10]="stale element reference";p[21]="timeout";p[25]="unable to set cookie";p[26]="unexpected alert open";p[13]=ia;p[9]="unknown command";ha.prototype.toString=function(){return this.name+": "+this.message};var ja={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",
darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",
ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",
lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",
moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",
seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};function ka(a,b){this.width=a;this.height=b}ka.prototype.toString=function(){return"("+this.width+" x "+this.height+")"};ka.prototype.ceil=function(){this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};ka.prototype.floor=function(){this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};ka.prototype.round=function(){this.width=Math.round(this.width);this.height=Math.round(this.height);return this};function la(a){return String(a).replace(/\-([a-z])/g,function(a,c){return c.toUpperCase()})};
function r(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function ma(a){this.b=a;this.a=0}function na(a){a=a.match(oa);for(var b=0;b<a.length;b++)pa.test(a[b])&&a.splice(b,1);return new ma(a)}var oa=/\$?(?:(?![0-9-\.])(?:\*|[\w-\.]+):)?(?![0-9-\.])(?:\*|[\w-\.]+)|\/\/|\.\.|::|\d+(?:\.\d*)?|\.\d+|"[^"]*"|'[^']*'|[!<>]=|\s+|./g,pa=/^\s/;function t(a,b){return a.b[a.a+(b||0)]}function v(a){return a.b[a.a++]}function qa(a){return a.b.length<=a.a};function w(a,b){this.h=a;this.c=h(b)?b:null;this.b=null;switch(a){case "comment":this.b=8;break;case "text":this.b=3;break;case "processing-instruction":this.b=7;break;case "node":break;default:throw Error("Unexpected argument");}}function ra(a){return"comment"==a||"text"==a||"processing-instruction"==a||"node"==a}w.prototype.a=function(a){return null===this.b||this.b==a.nodeType};w.prototype.f=function(){return this.h};
w.prototype.toString=function(){var a="Kind Test: "+this.h;null===this.c||(a+=x(this.c));return a};function sa(a,b){this.j=a.toLowerCase();a="*"==this.j?"*":"http://www.w3.org/1999/xhtml";this.b=b?b.toLowerCase():a}sa.prototype.a=function(a){var b=a.nodeType;if(1!=b&&2!=b)return!1;b=h(a.localName)?a.localName:a.nodeName;return"*"!=this.j&&this.j!=b.toLowerCase()?!1:"*"==this.b?!0:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():"http://www.w3.org/1999/xhtml")};sa.prototype.f=function(){return this.j};
sa.prototype.toString=function(){return"Name Test: "+("http://www.w3.org/1999/xhtml"==this.b?"":this.b+":")+this.j};function ta(a){switch(a.nodeType){case 1:return ga(ua,a);case 9:return ta(a.documentElement);case 11:case 10:case 6:case 12:return va;default:return a.parentNode?ta(a.parentNode):va}}function va(){return null}function ua(a,b){if(a.prefix==b)return a.namespaceURI||"http://www.w3.org/1999/xhtml";var c=a.getAttributeNode("xmlns:"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?ua(a.parentNode,b):null};function wa(a,b){if(l(a))return l(b)&&1==b.length?a.indexOf(b,0):-1;for(var c=0;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1}function y(a,b){for(var c=a.length,d=l(a)?a.split(""):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function z(a,b,c){var d=c;y(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function xa(a,b){for(var c=a.length,d=l(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}
function ya(a,b){for(var c=a.length,d=l(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&!b.call(void 0,d[e],e,a))return!1;return!0}function za(a){return Array.prototype.concat.apply([],arguments)}function Aa(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var Ba="backgroundColor borderTopColor borderRightColor borderBottomColor borderLeftColor color outlineColor".split(" "),Ca=/#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])/,Da=/^#(?:[0-9a-f]{3}){1,2}$/i,Ea=/^(?:rgba)?\((\d{1,3}),\s?(\d{1,3}),\s?(\d{1,3}),\s?(0|1|0\.\d*)\)$/i,Fa=/^(?:rgb)?\((0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2})\)$/i;function B(a,b){this.x=h(a)?a:0;this.y=h(b)?b:0}B.prototype.toString=function(){return"("+this.x+", "+this.y+")"};B.prototype.ceil=function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);return this};B.prototype.floor=function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);return this};B.prototype.round=function(){this.x=Math.round(this.x);this.y=Math.round(this.y);return this};function Ga(a,b,c,d){this.c=a;this.a=b;this.b=c;this.f=d}Ga.prototype.toString=function(){return"("+this.c+"t, "+this.a+"r, "+this.b+"b, "+this.f+"l)"};Ga.prototype.ceil=function(){this.c=Math.ceil(this.c);this.a=Math.ceil(this.a);this.b=Math.ceil(this.b);this.f=Math.ceil(this.f);return this};Ga.prototype.floor=function(){this.c=Math.floor(this.c);this.a=Math.floor(this.a);this.b=Math.floor(this.b);this.f=Math.floor(this.f);return this};
Ga.prototype.round=function(){this.c=Math.round(this.c);this.a=Math.round(this.a);this.b=Math.round(this.b);this.f=Math.round(this.f);return this};function C(a,b,c,d){this.a=a;this.b=b;this.width=c;this.height=d}C.prototype.toString=function(){return"("+this.a+", "+this.b+" - "+this.width+"w x "+this.height+"h)"};C.prototype.ceil=function(){this.a=Math.ceil(this.a);this.b=Math.ceil(this.b);this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};C.prototype.floor=function(){this.a=Math.floor(this.a);this.b=Math.floor(this.b);this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};
C.prototype.round=function(){this.a=Math.round(this.a);this.b=Math.round(this.b);this.width=Math.round(this.width);this.height=Math.round(this.height);return this};(function(){var a=aa.Components;if(!a)return!1;try{if(!a.classes)return!1}catch(c){return!1}var b=a.classes,a=a.interfaces;b["@mozilla.org/xpcom/version-comparator;1"].getService(a.nsIVersionComparator);b["@mozilla.org/xre/app-info;1"].getService(a.nsIXULAppInfo);return!0})();function Ha(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if("undefined"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}
function Ia(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if("sourceIndex"in a||a.parentNode&&"sourceIndex"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?Ja(a,b):!c&&Ha(e,b)?-1*Ka(a,b):!d&&Ha(f,a)?Ka(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}d=D(a);c=d.createRange();c.selectNode(a);c.collapse(!0);a=d.createRange();a.selectNode(b);
a.collapse(!0);return c.compareBoundaryPoints(aa.Range.START_TO_END,a)}function Ka(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return Ja(b,a)}function Ja(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1}function D(a){return 9==a.nodeType?a:a.ownerDocument||a.document}function La(a,b){a&&(a=a.parentNode);for(var c=0;a;){if(b(a))return a;a=a.parentNode;c++}return null}function Ma(a){this.a=a||aa.document||document}
Ma.prototype.getElementsByTagName=function(a,b){return(b||this.a).getElementsByTagName(String(a))};function E(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?"":b);if("string"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;for(var c=0,d=[],b="";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return""+b}
function F(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function Na(a,b,c,d,e){return Oa.call(null,a,b,l(c)?c:null,l(d)?d:null,e||new G)}
function Oa(a,b,c,d,e){b.getElementsByName&&d&&"name"==c?(b=b.getElementsByName(d),y(b,function(b){a.a(b)&&H(e,b)})):b.getElementsByClassName&&d&&"class"==c?(b=b.getElementsByClassName(d),y(b,function(b){b.className==d&&a.a(b)&&H(e,b)})):a instanceof w?Pa(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),y(b,function(a){F(a,c,d)&&H(e,a)}));return e}function Pa(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)F(b,c,d)&&a.a(b)&&H(e,b),Pa(a,b,c,d,e)};function J(a,b){b&&"string"!==typeof b&&(b=b.toString());return!!a&&1==a.nodeType&&(!b||a.tagName.toUpperCase()==b)};function G(){this.b=this.a=null;this.l=0}function Qa(a){this.node=a;this.a=this.b=null}function Ra(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.node==b.node?(e=c,c=c.a,b=b.a):0<Ia(c.node,b.node)?(e=b,b=b.a):(e=c,c=c.a),(e.b=d)?d.a=e:a.a=e,d=e,f++;for(e=c||b;e;)e.b=d,d=d.a=e,f++,e=e.a;a.b=d;a.l=f;return a}function Sa(a,b){b=new Qa(b);b.a=a.a;a.b?a.a.b=b:a.a=a.b=b;a.a=b;a.l++}function H(a,b){b=new Qa(b);b.b=a.b;a.a?a.b.a=b:a.a=a.b=b;a.b=b;a.l++}
function Ta(a){return(a=a.a)?a.node:null}function Ua(a){return(a=Ta(a))?E(a):""}function K(a,b){return new Va(a,!!b)}function Va(a,b){this.f=a;this.b=(this.s=b)?a.b:a.a;this.a=null}function M(a){var b=a.b;if(b){var c=a.a=b;a.b=a.s?b.b:b.a;return c.node}return null};function N(a){this.i=a;this.b=this.g=!1;this.f=null}function x(a){return"\n  "+a.toString().split("\n").join("\n  ")}function Wa(a,b){a.g=b}function Xa(a,b){a.b=b}function O(a,b){a=a.a(b);return a instanceof G?+Ua(a):+a}function P(a,b){a=a.a(b);return a instanceof G?Ua(a):""+a}function Q(a,b){a=a.a(b);return a instanceof G?!!a.l:!!a};function Ya(a,b,c){N.call(this,a.i);this.c=a;this.h=b;this.o=c;this.g=b.g||c.g;this.b=b.b||c.b;this.c==Za&&(c.b||c.g||4==c.i||0==c.i||!b.f?b.b||b.g||4==b.i||0==b.i||!c.f||(this.f={name:c.f.name,u:b}):this.f={name:b.f.name,u:c})}n(Ya,N);
function R(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=K(b);for(d=M(b);d;d=M(b))for(e=K(c),f=M(e);f;f=M(e))if(a(E(d),E(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=K(e);for(var g=typeof d,k=M(f);k;k=M(f)){switch(g){case "number":k=+E(k);break;case "boolean":k=!!E(k);break;case "string":k=E(k);break;default:throw Error("Illegal primitive type for comparison.");}if(e==b&&a(k,d)||e==c&&a(d,k))return!0}return!1}return e?"boolean"==
typeof b||"boolean"==typeof c?a(!!b,!!c):"number"==typeof b||"number"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}Ya.prototype.a=function(a){return this.c.m(this.h,this.o,a)};Ya.prototype.toString=function(){var a="Binary Expression: "+this.c,a=a+x(this.h);return a+=x(this.o)};function $a(a,b,c,d){this.I=a;this.D=b;this.i=c;this.m=d}$a.prototype.toString=function(){return this.I};var ab={};
function S(a,b,c,d){if(ab.hasOwnProperty(a))throw Error("Binary operator already created: "+a);a=new $a(a,b,c,d);return ab[a.toString()]=a}S("div",6,1,function(a,b,c){return O(a,c)/O(b,c)});S("mod",6,1,function(a,b,c){return O(a,c)%O(b,c)});S("*",6,1,function(a,b,c){return O(a,c)*O(b,c)});S("+",5,1,function(a,b,c){return O(a,c)+O(b,c)});S("-",5,1,function(a,b,c){return O(a,c)-O(b,c)});S("<",4,2,function(a,b,c){return R(function(a,b){return a<b},a,b,c)});
S(">",4,2,function(a,b,c){return R(function(a,b){return a>b},a,b,c)});S("<=",4,2,function(a,b,c){return R(function(a,b){return a<=b},a,b,c)});S(">=",4,2,function(a,b,c){return R(function(a,b){return a>=b},a,b,c)});var Za=S("=",3,2,function(a,b,c){return R(function(a,b){return a==b},a,b,c,!0)});S("!=",3,2,function(a,b,c){return R(function(a,b){return a!=b},a,b,c,!0)});S("and",2,2,function(a,b,c){return Q(a,c)&&Q(b,c)});S("or",1,2,function(a,b,c){return Q(a,c)||Q(b,c)});function bb(a,b){if(b.a.length&&4!=a.i)throw Error("Primary expression must evaluate to nodeset if filter has predicate(s).");N.call(this,a.i);this.c=a;this.h=b;this.g=a.g;this.b=a.b}n(bb,N);bb.prototype.a=function(a){a=this.c.a(a);return cb(this.h,a)};bb.prototype.toString=function(){var a="Filter:"+x(this.c);return a+=x(this.h)};function db(a,b){if(b.length<a.C)throw Error("Function "+a.j+" expects at least"+a.C+" arguments, "+b.length+" given");if(null!==a.A&&b.length>a.A)throw Error("Function "+a.j+" expects at most "+a.A+" arguments, "+b.length+" given");a.H&&y(b,function(b,d){if(4!=b.i)throw Error("Argument "+d+" to function "+a.j+" is not of type Nodeset: "+b);});N.call(this,a.i);this.v=a;this.c=b;Wa(this,a.g||xa(b,function(a){return a.g}));Xa(this,a.G&&!b.length||a.F&&!!b.length||xa(b,function(a){return a.b}))}
n(db,N);db.prototype.a=function(a){return this.v.m.apply(null,za(a,this.c))};db.prototype.toString=function(){var a="Function: "+this.v;if(this.c.length)var b=z(this.c,function(a,b){return a+x(b)},"Arguments:"),a=a+x(b);return a};function eb(a,b,c,d,e,f,g,k,q){this.j=a;this.i=b;this.g=c;this.G=d;this.F=e;this.m=f;this.C=g;this.A=h(k)?k:g;this.H=!!q}eb.prototype.toString=function(){return this.j};var fb={};
function T(a,b,c,d,e,f,g,k){if(fb.hasOwnProperty(a))throw Error("Function already created: "+a+".");fb[a]=new eb(a,b,c,d,!1,e,f,g,k)}T("boolean",2,!1,!1,function(a,b){return Q(b,a)},1);T("ceiling",1,!1,!1,function(a,b){return Math.ceil(O(b,a))},1);T("concat",3,!1,!1,function(a,b){return z(Aa(arguments,1),function(b,d){return b+P(d,a)},"")},2,null);T("contains",2,!1,!1,function(a,b,c){b=P(b,a);a=P(c,a);return-1!=b.indexOf(a)},2);T("count",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);
T("false",2,!1,!1,function(){return!1},0);T("floor",1,!1,!1,function(a,b){return Math.floor(O(b,a))},1);T("id",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=P(b,a).split(/\s+/);var e=[];y(a,function(a){a=d.getElementById(a);!a||0<=wa(e,a)||e.push(a)});e.sort(Ia);var f=new G;y(e,function(a){H(f,a)});return f},1);T("lang",2,!1,!1,function(){return!1},1);T("last",1,!0,!1,function(a){if(1!=arguments.length)throw Error("Function last expects ()");return a.f},0);
T("local-name",3,!1,!0,function(a,b){return(a=b?Ta(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():""},0,1,!0);T("name",3,!1,!0,function(a,b){return(a=b?Ta(b.a(a)):a.a)?a.nodeName.toLowerCase():""},0,1,!0);T("namespace-uri",3,!0,!1,function(){return""},0,1,!0);T("normalize-space",3,!1,!0,function(a,b){return(b?P(b,a):E(a.a)).replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")},0,1);T("not",2,!1,!1,function(a,b){return!Q(b,a)},1);T("number",1,!1,!0,function(a,b){return b?O(b,a):+E(a.a)},0,1);
T("position",1,!0,!1,function(a){return a.b},0);T("round",1,!1,!1,function(a,b){return Math.round(O(b,a))},1);T("starts-with",2,!1,!1,function(a,b,c){b=P(b,a);a=P(c,a);return!b.lastIndexOf(a,0)},2);T("string",3,!1,!0,function(a,b){return b?P(b,a):E(a.a)},0,1);T("string-length",1,!1,!0,function(a,b){return(b?P(b,a):E(a.a)).length},0,1);
T("substring",3,!1,!1,function(a,b,c,d){c=O(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return"";d=d?O(d,a):Infinity;if(isNaN(d)||-Infinity===d)return"";c=Math.round(c)-1;var e=Math.max(c,0);a=P(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);T("substring-after",3,!1,!1,function(a,b,c){b=P(b,a);a=P(c,a);c=b.indexOf(a);return-1==c?"":b.substring(c+a.length)},2);
T("substring-before",3,!1,!1,function(a,b,c){b=P(b,a);a=P(c,a);a=b.indexOf(a);return-1==a?"":b.substring(0,a)},2);T("sum",1,!1,!1,function(a,b){a=K(b.a(a));b=0;for(var c=M(a);c;c=M(a))b+=+E(c);return b},1,1,!0);T("translate",3,!1,!1,function(a,b,c,d){b=P(b,a);c=P(c,a);var e=P(d,a);d={};for(var f=0;f<c.length;f++)a=c.charAt(f),a in d||(d[a]=e.charAt(f));c="";for(f=0;f<b.length;f++)a=b.charAt(f),c+=a in d?d[a]:a;return c},3);T("true",2,!1,!1,function(){return!0},0);function gb(a){N.call(this,3);this.c=a.substring(1,a.length-1)}n(gb,N);gb.prototype.a=function(){return this.c};gb.prototype.toString=function(){return"Literal: "+this.c};function hb(a){N.call(this,1);this.c=a}n(hb,N);hb.prototype.a=function(){return this.c};hb.prototype.toString=function(){return"Number: "+this.c};function ib(a,b){N.call(this,a.i);this.h=a;this.c=b;this.g=a.g;this.b=a.b;1==this.c.length&&(a=this.c[0],a.w||a.c!=jb||(a=a.o,"*"!=a.f()&&(this.f={name:a.f(),u:null})))}n(ib,N);function kb(){N.call(this,4)}n(kb,N);kb.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?H(b,a):H(b,a.ownerDocument);return b};kb.prototype.toString=function(){return"Root Helper Expression"};function lb(){N.call(this,4)}n(lb,N);lb.prototype.a=function(a){var b=new G;H(b,a.a);return b};lb.prototype.toString=function(){return"Context Helper Expression"};
function mb(a){return"/"==a||"//"==a}ib.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof G))throw Error("Filter expression must evaluate to nodeset.");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=K(b,e.c.s);if(e.g||e.c!=nb)if(e.g||e.c!=ob){var g=M(f);for(b=e.a(new r(g));g=M(f);)g=e.a(new r(g)),b=Ra(b,g)}else g=M(f),b=e.a(new r(g));else{for(g=M(f);(b=M(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new r(g))}}return b};
ib.prototype.toString=function(){var a="Path Expression:"+x(this.h);if(this.c.length){var b=z(this.c,function(a,b){return a+x(b)},"Steps:");a+=x(b)}return a};function pb(a,b){this.a=a;this.s=!!b}
function cb(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=K(b),f=b.l,g,k=0;g=M(e);k++){var q=a.s?f-k:k+1;g=d.a(new r(g,q,f));if("number"==typeof g)q=q==g;else if("string"==typeof g||"boolean"==typeof g)q=!!g;else if(g instanceof G)q=0<g.l;else throw Error("Predicate.evaluate returned an unexpected type.");if(!q){q=e;g=q.f;var u=q.a;if(!u)throw Error("Next must be called at least once before remove.");var m=u.b,u=u.a;m?m.a=u:g.a=u;u?u.b=m:g.b=m;g.l--;q.a=null}}return b}
pb.prototype.toString=function(){return z(this.a,function(a,b){return a+x(b)},"Predicates:")};function qb(a){N.call(this,1);this.c=a;this.g=a.g;this.b=a.b}n(qb,N);qb.prototype.a=function(a){return-O(this.c,a)};qb.prototype.toString=function(){return"Unary Expression: -"+x(this.c)};function rb(a){N.call(this,4);this.c=a;Wa(this,xa(this.c,function(a){return a.g}));Xa(this,xa(this.c,function(a){return a.b}))}n(rb,N);rb.prototype.a=function(a){var b=new G;y(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error("Path expression must evaluate to NodeSet.");b=Ra(b,c)});return b};rb.prototype.toString=function(){return z(this.c,function(a,b){return a+x(b)},"Union Expression:")};function U(a,b,c,d){N.call(this,4);this.c=a;this.o=b;this.h=c||new pb([]);this.w=!!d;b=this.h;b=0<b.a.length?b.a[0].f:null;a.J&&b&&(this.f={name:b.name,u:b.u});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.g||1==c.i||0==c.i){a=!0;break a}a=!1}this.g=a}n(U,N);
U.prototype.a=function(a){var b=a.a,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.u?P(c.u,a):null,f=1);if(this.w)if(this.g||this.c!=sb)if(b=K((new U(tb,new w("node"))).a(a)),c=M(b))for(a=this.m(c,d,e,f);c=M(b);)a=Ra(a,this.m(c,d,e,f));else a=new G;else a=Na(this.o,b,d,e),a=cb(this.h,a,f);else a=this.m(a.a,d,e,f);return a};U.prototype.m=function(a,b,c,d){a=this.c.v(this.o,a,b,c);return a=cb(this.h,a,d)};
U.prototype.toString=function(){var a="Step:"+x("Operator: "+(this.w?"//":"/"));this.c.j&&(a+=x("Axis: "+this.c));a+=x(this.o);if(this.h.a.length){var b=z(this.h.a,function(a,b){return a+x(b)},"Predicates:");a+=x(b)}return a};function ub(a,b,c,d){this.j=a;this.v=b;this.s=c;this.J=d}ub.prototype.toString=function(){return this.j};var vb={};function V(a,b,c,d){if(vb.hasOwnProperty(a))throw Error("Axis already created: "+a);b=new ub(a,b,c,!!d);return vb[a]=b}
V("ancestor",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&Sa(c,b);return c},!0);V("ancestor-or-self",function(a,b){var c=new G;do a.a(b)&&Sa(c,b);while(b=b.parentNode);return c},!0);
var jb=V("attribute",function(a,b){var c=new G,d=a.f();if(b=b.attributes)if(a instanceof w&&null===a.b||"*"==d)for(d=0;a=b[d];d++)H(c,a);else(a=b.getNamedItem(d))&&H(c,a);return c},!1),sb=V("child",function(a,b,c,d,e){c=l(c)?c:null;d=l(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)F(b,c,d)&&a.a(b)&&H(e,b);return e},!1,!0);V("descendant",Na,!1,!0);
var tb=V("descendant-or-self",function(a,b,c,d){var e=new G;F(b,c,d)&&a.a(b)&&H(e,b);return Na(a,b,c,d,e)},!1,!0),nb=V("following",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)F(f,c,d)&&a.a(f)&&H(e,f),e=Na(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);V("following-sibling",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&H(c,b);return c},!1);V("namespace",function(){return new G},!1);
var wb=V("parent",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return H(c,b.ownerElement),c;b=b.parentNode;a.a(b)&&H(c,b);return c},!1),ob=V("preceding",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,k=f.length;g<k;g++){var q=[];for(b=f[g];b=b.previousSibling;)q.unshift(b);for(var u=0,m=q.length;u<m;u++)b=q[u],F(b,c,d)&&a.a(b)&&H(e,b),e=Na(a,b,c,d,e)}return e},!0,!0);
V("preceding-sibling",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&Sa(c,b);return c},!0);var xb=V("self",function(a,b){var c=new G;a.a(b)&&H(c,b);return c},!1);function yb(a,b){this.a=a;this.b=b}function zb(a){for(var b,c=[];;){W(a,"Missing right hand side of binary expression.");b=Ab(a);var d=v(a.a);if(!d)break;var e=(d=ab[d]||null)&&d.D;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].D;)b=new Ya(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new Ya(c.pop(),c.pop(),b);return b}function W(a,b){if(qa(a.a))throw Error(b);}function Bb(a,b){a=v(a.a);if(a!=b)throw Error("Bad token, expected: "+b+" got: "+a);}
function Cb(a){a=v(a.a);if(")"!=a)throw Error("Bad token: "+a);}function Db(a){a=v(a.a);if(2>a.length)throw Error("Unclosed literal string");return new gb(a)}
function Eb(a){var b=[];if(mb(t(a.a))){var c=v(a.a);var d=t(a.a);if("/"==c&&(qa(a.a)||"."!=d&&".."!=d&&"@"!=d&&"*"!=d&&!/(?![0-9])[\w]/.test(d)))return new kb;d=new kb;W(a,"Missing next location step.");c=Fb(a,c);b.push(c)}else{a:{c=t(a.a);d=c.charAt(0);switch(d){case "$":throw Error("Variable reference not allowed in HTML XPath");case "(":v(a.a);c=zb(a);W(a,'unclosed "("');Bb(a,")");break;case '"':case "'":c=Db(a);break;default:if(isNaN(+c))if(!ra(c)&&/(?![0-9])[\w]/.test(d)&&"("==t(a.a,1)){c=v(a.a);
c=fb[c]||null;v(a.a);for(d=[];")"!=t(a.a);){W(a,"Missing function argument list.");d.push(zb(a));if(","!=t(a.a))break;v(a.a)}W(a,"Unclosed function argument list.");Cb(a);c=new db(c,d)}else{c=null;break a}else c=new hb(+v(a.a))}"["==t(a.a)&&(d=new pb(Gb(a)),c=new bb(c,d))}if(c)if(mb(t(a.a)))d=c;else return c;else c=Fb(a,"/"),d=new lb,b.push(c)}for(;mb(t(a.a));)c=v(a.a),W(a,"Missing next location step."),c=Fb(a,c),b.push(c);return new ib(d,b)}
function Fb(a,b){if("/"!=b&&"//"!=b)throw Error('Step op should be "/" or "//"');if("."==t(a.a)){var c=new U(xb,new w("node"));v(a.a);return c}if(".."==t(a.a))return c=new U(wb,new w("node")),v(a.a),c;if("@"==t(a.a)){var d=jb;v(a.a);W(a,"Missing attribute name")}else if("::"==t(a.a,1)){if(!/(?![0-9])[\w]/.test(t(a.a).charAt(0)))throw Error("Bad token: "+v(a.a));var e=v(a.a);d=vb[e]||null;if(!d)throw Error("No axis with name: "+e);v(a.a);W(a,"Missing node name")}else d=sb;e=t(a.a);if(/(?![0-9])[\w\*]/.test(e.charAt(0)))if("("==
t(a.a,1)){if(!ra(e))throw Error("Invalid node type: "+e);e=v(a.a);if(!ra(e))throw Error("Invalid type name: "+e);Bb(a,"(");W(a,"Bad nodetype");var f=t(a.a).charAt(0),g=null;if('"'==f||"'"==f)g=Db(a);W(a,"Bad nodetype");Cb(a);e=new w(e,g)}else if(e=v(a.a),f=e.indexOf(":"),-1==f)e=new sa(e);else{var g=e.substring(0,f);if("*"==g)var k="*";else if(k=a.b(g),!k)throw Error("Namespace prefix not declared: "+g);e=e.substr(f+1);e=new sa(e,k)}else throw Error("Bad token: "+v(a.a));a=new pb(Gb(a),d.s);return c||
new U(d,e,a,"//"==b)}function Gb(a){for(var b=[];"["==t(a.a);){v(a.a);W(a,"Missing predicate expression.");var c=zb(a);b.push(c);W(a,"Unclosed predicate expression.");Bb(a,"]")}return b}function Ab(a){if("-"==t(a.a))return v(a.a),new qb(Ab(a));var b=Eb(a);if("|"!=t(a.a))a=b;else{for(b=[b];"|"==v(a.a);)W(a,"Missing next union location path."),b.push(Eb(a));a.a.a--;a=new rb(b)}return a};function Hb(a,b){if(!a.length)throw Error("Empty XPath expression.");a=na(a);if(qa(a))throw Error("Invalid XPath expression.");b?"function"==ca(b)||(b=fa(b.lookupNamespaceURI,b)):b=function(){return null};var c=zb(new yb(a,b));if(!qa(a))throw Error("Bad token: "+v(a));this.evaluate=function(a,b){a=c.a(new r(a));return new X(a,b)}}
function X(a,b){if(!b)if(a instanceof G)b=4;else if("string"==typeof a)b=2;else if("number"==typeof a)b=1;else if("boolean"==typeof a)b=3;else throw Error("Unexpected evaluation result.");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error("value could not be converted to the specified type");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?Ua(a):""+a;break;case 1:this.numberValue=a instanceof G?+Ua(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var c=
K(a);var d=[];for(var e=M(c);e;e=M(c))d.push(e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=Ta(a);break;default:throw Error("Unknown XPathResult type.");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error("iterateNext called with wrong result type");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error("snapshotItem called with wrong result type");return a>=d.length||0>a?null:d[a]}}X.ANY_TYPE=0;
X.NUMBER_TYPE=1;X.STRING_TYPE=2;X.BOOLEAN_TYPE=3;X.UNORDERED_NODE_ITERATOR_TYPE=4;X.ORDERED_NODE_ITERATOR_TYPE=5;X.UNORDERED_NODE_SNAPSHOT_TYPE=6;X.ORDERED_NODE_SNAPSHOT_TYPE=7;X.ANY_UNORDERED_NODE_TYPE=8;X.FIRST_ORDERED_NODE_TYPE=9;function Ib(a){this.lookupNamespaceURI=ta(a)}
ba("wgxpath.install",function(a,b){a=a||aa;var c=a.Document&&a.Document.prototype||a.document;if(!c.evaluate||b)a.XPathResult=X,c.evaluate=function(a,b,c,g){return(new Hb(a,c)).evaluate(b,g)},c.createExpression=function(a,b){return new Hb(a,b)},c.createNSResolver=function(a){return new Ib(a)}});var Jb=function(){var a={M:"http://www.w3.org/2000/svg"};return function(b){return a[b]||null}}();
function Kb(a,b){var c=D(a);if(!c.documentElement)return null;try{for(var d=c.createNSResolver?c.createNSResolver(c.documentElement):Jb,e={},f=c.getElementsByTagName("*"),g=0;g<f.length;++g){var k=f[g],q=k.namespaceURI;if(q&&!e[q]){var u=k.lookupPrefix(q);if(!u)var m=q.match(".*/(\\w+)/?$"),u=m?m[1]:"xhtml";e[q]=u}}var A={},I;for(I in e)A[e[I]]=I;d=function(a){return A[a]||null};try{return c.evaluate(b,a,d,9,null)}catch(L){if("TypeError"===L.name)return d=c.createNSResolver?c.createNSResolver(c.documentElement):
Jb,c.evaluate(b,a,d,9,null);throw L;}}catch(L){if("NS_ERROR_ILLEGAL_VALUE"!=L.name)throw new ha(32,"Unable to locate an element with the xpath expression "+b+" because of the following error:\n"+L);}}
function Lb(a,b){var c=function(){var c=Kb(b,a);return c?c.singleNodeValue||null:b.selectSingleNode?(c=D(b),c.setProperty&&c.setProperty("SelectionLanguage","XPath"),b.selectSingleNode(a)):null}();if(null!==c&&(!c||1!=c.nodeType))throw new ha(32,'The result of the xpath expression "'+a+'" is: '+c+". It should be an element.");return c};var Mb="function"===typeof ShadowRoot;function Nb(a){for(a=a.parentNode;a&&1!=a.nodeType&&9!=a.nodeType&&11!=a.nodeType;)a=a.parentNode;return J(a)?a:null}
function Y(a,b){b=la(b);if("float"==b||"cssFloat"==b||"styleFloat"==b)b="cssFloat";a:{var c=b;var d=D(a);if(d.defaultView&&d.defaultView.getComputedStyle&&(d=d.defaultView.getComputedStyle(a,null))){c=d[c]||d.getPropertyValue(c)||"";break a}c=""}a=c||Ob(a,b);if(null===a)a=null;else if(0<=wa(Ba,b)){b:{var e=a.match(Ea);if(e&&(b=Number(e[1]),c=Number(e[2]),d=Number(e[3]),e=Number(e[4]),0<=b&&255>=b&&0<=c&&255>=c&&0<=d&&255>=d&&0<=e&&1>=e)){b=[b,c,d,e];break b}b=null}if(!b)b:{if(d=a.match(Fa))if(b=Number(d[1]),
c=Number(d[2]),d=Number(d[3]),0<=b&&255>=b&&0<=c&&255>=c&&0<=d&&255>=d){b=[b,c,d,1];break b}b=null}if(!b)b:{b=a.toLowerCase();c=ja[b.toLowerCase()];if(!c&&(c="#"==b.charAt(0)?b:"#"+b,4==c.length&&(c=c.replace(Ca,"#$1$1$2$2$3$3")),!Da.test(c))){b=null;break b}b=[parseInt(c.substr(1,2),16),parseInt(c.substr(3,2),16),parseInt(c.substr(5,2),16),1]}a=b?"rgba("+b.join(", ")+")":a}return a}
function Ob(a,b){var c=a.currentStyle||a.style,d=c[b];!h(d)&&"function"==ca(c.getPropertyValue)&&(d=c.getPropertyValue(b));return"inherit"!=d?h(d)?d:null:(a=Nb(a))?Ob(a,b):null}
function Pb(a,b,c){function d(a){var b=Qb(a);return 0<b.height&&0<b.width?!0:J(a,"PATH")&&(0<b.height||0<b.width)?(a=Y(a,"stroke-width"),!!a&&0<parseInt(a,10)):"hidden"!=Y(a,"overflow")&&xa(a.childNodes,function(a){return 3==a.nodeType||J(a)&&d(a)})}function e(a){return Rb(a)==Z&&ya(a.childNodes,function(a){return!J(a)||e(a)||!d(a)})}if(!J(a))throw Error("Argument to isShown must be of type Element");if(J(a,"BODY"))return!0;if(J(a,"OPTION")||J(a,"OPTGROUP"))return a=La(a,function(a){return J(a,"SELECT")}),
!!a&&Pb(a,!0,c);var f=Sb(a);if(f)return!!f.B&&0<f.rect.width&&0<f.rect.height&&Pb(f.B,b,c);if(J(a,"INPUT")&&"hidden"==a.type.toLowerCase()||J(a,"NOSCRIPT"))return!1;f=Y(a,"visibility");return"collapse"!=f&&"hidden"!=f&&c(a)&&(b||Tb(a))&&d(a)?!e(a):!1}var Z="hidden";
function Rb(a){function b(a){function b(a){return a==g?!0:!Y(a,"display").lastIndexOf("inline",0)||"absolute"==c&&"static"==Y(a,"position")?!1:!0}var c=Y(a,"position");if("fixed"==c)return u=!0,a==g?null:g;for(a=Nb(a);a&&!b(a);)a=Nb(a);return a}function c(a){var b=a;if("visible"==q)if(a==g&&k)b=k;else if(a==k)return{x:"visible",y:"visible"};b={x:Y(b,"overflow-x"),y:Y(b,"overflow-y")};a==g&&(b.x="visible"==b.x?"auto":b.x,b.y="visible"==b.y?"auto":b.y);return b}function d(a){if(a==g){var b=(new Ma(f)).a;
a=b.scrollingElement?b.scrollingElement:"CSS1Compat"==b.compatMode?b.documentElement:b.body||b.documentElement;b=b.parentWindow||b.defaultView;a=new B(b.pageXOffset||a.scrollLeft,b.pageYOffset||a.scrollTop)}else a=new B(a.scrollLeft,a.scrollTop);return a}var e=Ub(a);var f=D(a),g=f.documentElement,k=f.body,q=Y(g,"overflow"),u;for(a=b(a);a;a=b(a)){var m=c(a);if("visible"!=m.x||"visible"!=m.y){var A=Qb(a);if(!A.width||!A.height)return Z;var I=e.a<A.a,L=e.b<A.b;if(I&&"hidden"==m.x||L&&"hidden"==m.y)return Z;
if(I&&"visible"!=m.x||L&&"visible"!=m.y){I=d(a);L=e.b<A.b-I.y;if(e.a<A.a-I.x&&"visible"!=m.x||L&&"visible"!=m.x)return Z;e=Rb(a);return e==Z?Z:"scroll"}I=e.f>=A.a+A.width;A=e.c>=A.b+A.height;if(I&&"hidden"==m.x||A&&"hidden"==m.y)return Z;if(I&&"visible"!=m.x||A&&"visible"!=m.y){if(u&&(m=d(a),e.f>=g.scrollWidth-m.x||e.a>=g.scrollHeight-m.y))return Z;e=Rb(a);return e==Z?Z:"scroll"}}}return"none"}
function Qb(a){var b=Sb(a);if(b)return b.rect;if(J(a,"HTML"))return a=D(a),a=((a?a.parentWindow||a.defaultView:window)||window).document,a="CSS1Compat"==a.compatMode?a.documentElement:a.body,a=new ka(a.clientWidth,a.clientHeight),new C(0,0,a.width,a.height);try{var c=a.getBoundingClientRect()}catch(d){return new C(0,0,0,0)}return new C(c.left,c.top,c.right-c.left,c.bottom-c.top)}
function Sb(a){var b=J(a,"MAP");if(!b&&!J(a,"AREA"))return null;var c=b?a:J(a.parentNode,"MAP")?a.parentNode:null,d=null,e=null;c&&c.name&&(d=Lb('/descendant::*[@usemap = "#'+c.name+'"]',D(c)))&&(e=Qb(d),b||"default"==a.shape.toLowerCase()||(a=Vb(a),b=Math.min(Math.max(a.a,0),e.width),c=Math.min(Math.max(a.b,0),e.height),e=new C(b+e.a,c+e.b,Math.min(a.width,e.width-b),Math.min(a.height,e.height-c))));return{B:d,rect:e||new C(0,0,0,0)}}
function Vb(a){var b=a.shape.toLowerCase();a=a.coords.split(",");if("rect"==b&&4==a.length){var b=a[0],c=a[1];return new C(b,c,a[2]-b,a[3]-c)}if("circle"==b&&3==a.length)return b=a[2],new C(a[0]-b,a[1]-b,2*b,2*b);if("poly"==b&&2<a.length){for(var b=a[0],c=a[1],d=b,e=c,f=2;f+1<a.length;f+=2)b=Math.min(b,a[f]),d=Math.max(d,a[f]),c=Math.min(c,a[f+1]),e=Math.max(e,a[f+1]);return new C(b,c,d-b,e-c)}return new C(0,0,0,0)}function Ub(a){a=Qb(a);return new Ga(a.b,a.a+a.width,a.b+a.height,a.a)}
function Tb(a){var b=1,c=Y(a,"opacity");c&&(b=Number(c));(a=Nb(a))&&(b*=Tb(a));return b};ba("_",function(a,b){var c=Mb?function(b){if("none"==Y(b,"display"))return!1;do{var d=b.parentNode;if(b.getDestinationInsertionPoints){var f=b.getDestinationInsertionPoints();0<f.length&&(d=f[f.length-1])}if(d instanceof ShadowRoot){if(d.host.shadowRoot!=d)return!1;d=d.host}else!d||9!=d.nodeType&&11!=d.nodeType||(d=null)}while(a&&1!=a.nodeType);return!d||c(d)}:function(a){if("none"==Y(a,"display"))return!1;a=Nb(a);return!a||c(a)};return Pb(a,!!b,c)});; return this._.apply(null,arguments);}.apply({navigator:typeof window!='undefined'?window.navigator:null,document:typeof window!='undefined'?window.document:null}, arguments);}
