#!/usr/bin/tclsh
# Code to perform Oz postcode lookup by postcode and by soundex
# initialise the DB subsytem

proc pgquote {string} {
    set string [string trim $string  \"\ ]
    set string [join [split $string '] '']
    return '$string'
}

proc pg_insert {db table rec} {
    upvar $rec record
    set cmd "update $table set"
    foreach {name val} [array get record] {
        append cmd " $name = $val"
    }
    pg_exec $db $cmd
}

# import the Postcode database from the file
proc import {file db} {
    set fd [::open $file r]

    gets $fd	;# discard first line
    set i 0
    while ![eof $fd] {
        set line [gets $fd]
        set line [split $line ,]
        
        if ![llength $line] {
            break
        }
        
        if {[llength $line] != 7} {
            error "Badly formatted $line"
        }
        
        catch {unset record}
        foreach {
            record(pcode)
            record(locality)
            record(state)
            record(comments)
            record(delivery)
            record(presort)
            record(zone)} $line {
            set record(pcode) [string trim $record(pcode) \"]
            set record(locality) [pgquote $record(locality)]
            set record(state) [pgquote $record(state)]
            set record(comments) [pgquote $record(comments)]
            set record(delivery) [pgquote $record(delivery)]
            set record(presort) [string trim $record(presort) \"]
            set record(zone) [pgquote $record(zone)]
        }

        # write the record
        pg_insert $db postcode record
    }
}

load libpgtcl.so

set postcode [pg_connect postcode]

pg_exec $postcode "drop table postcode"

pg_exec $postcode {
    create table postcode (
                  pcode		integer,
                  locality	text,
                  state		char(3),
                  comments	text,
                  delivery	text,
                  presort	integer,
                  zone		char(2)
                  );
}

import Pcodeall.csv $postcode

pg_exec $postcode "create index pcode on postcode (pcode)"
pg_exec $postcode "create index locality on postcode (locality)"
pg_exec $postcode "vacuum verbose analyze postcode"

pg_disconnect $postcode
