/*
 * FILE : tclpq_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/*
 * $Header: /b2/dmb/SWIG/SWIG1.0b3/swig_lib/tcl/RCS/swigtcl.cfg,v 1.1 1996/05/22 19:47:45 beazley Exp $
 * 
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: swigtcl.cfg,v $
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/**************************************************************************
 * $Header:$
 *
 * tcl8ptr.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 * Pointers are installed as new kinds of Tcl 8.0 objects consisting
 * of the following structure
 *
 * typedef struct {
 *         char     *name;            Name of the datatype  
 *         void     *value;           Value of the pointer
 * } Tcl_SwigPtr;
 *
 * While we still need to perform string comparisons on the 
 * type-name, this function no longer needs to convert pointer
 * values to hex so it should be a little faster.
 *
 * New Tcl datatypes are defined by the following data structure.
 * 
 * typedef struct Tcl_ObjType {
 *              char *name;
 *              Tcl_FreeInternalRepProc *freeIntRepProc;      
 *              Tcl_DupInternalRepProc *dupIntRepProc;
 *              Tcl_UpdateStringProc *updateStringProc;
 *              Tcl_SetFromAnyProc *setFromAnyProc;
 *             } Tcl_ObjType;
 *
 * Functions for manipulating SWIG pointers in wrapper code are:
 *
 *     void *SWIG_SetPointerObj(objPtr, ptr, type)
 *     char *SWIG_GetPointerFromObj(objPtr, *ptr, type)
 *
 **********************************************************************/

#ifdef SWIG_GLOBAL
#include <tcl.h>
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  char _temp[20], *_c;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    _c = &_temp[0];
    while (_r >= _result)
      *(_c++) = *(_r--);
    *_c = 0;
    Tcl_SetStringObj(objPtr,_temp,-1);
  } else {
    Tcl_SetStringObj(objPtr,"NULL",-1);
  }
  if (_ptr)
    Tcl_AppendToObj(objPtr,type,-1);
}

/* This is for backwards compatibility */

SWIGSTATIC int 
SWIG_MakePtr(char *_c, const void *_ptr, char *type)
{
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;
  int      l = 0;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
      l++;
    }
    *_r = '_';
    l++;
    while (_r >= _result)
      *(_c++) = *(_r--);
    _r = type;
    while (*_r)
      *(_c++) = *(_r++);
    *(_c) = 0;
  } else {
      strcpy (_c, "NULL");
  }
  return l;
}

/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/

SWIGSTATIC
char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *_t) {
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  char *_c;
  _p = 0;

  /* Extract the pointer value as a string */
  _c = Tcl_GetStringFromObj(objPtr, &i);

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterType() {
  /* Does nothing at the moment */
}
#define SWIG_init    Tclpq_Init
#define SWIG_name    "tclpq"
#define SWIG_prefix  "tclpq::"
#define SWIG_namespace "tclpq"

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int,Tclpq_Init)(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#include <libpq-fe.h>
#include <tclDecls.h>

/* an extra wrapper to make connected db also a channel */
static int _wrap_PQconnectdb(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    PGconn * _result;
    char * _arg0;
    Tcl_Obj * tcl_result;
    int templength;
    int sock;
    Tcl_Channel chan;

    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,
                         "Wrong # args. tclpq::PQconnectdb conninfo ",-1);
        return TCL_ERROR;
    }

    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL)
        return TCL_ERROR;

    _result = (PGconn *)PQconnectdb(_arg0);

    sock = PQsocket(_result);
    chan = Tcl_MakeTcpClientChannel(sock);
    if (chan == (Tcl_Channel) NULL) {
        return TCL_ERROR;
    }
    if (Tcl_SetChannelOption(interp, chan,
                             "-translation", "binary binary") == TCL_ERROR) {
        Tcl_Close((Tcl_Interp *) NULL, chan);
        return TCL_ERROR;
    }
    if (Tcl_SetChannelOption(interp, chan,
                             "-buffering", "none") == TCL_ERROR) {
        Tcl_Close((Tcl_Interp *) NULL, chan);
        return TCL_ERROR;
    }
    Tcl_RegisterChannel(interp, chan);
    /*fprintf(stderr, "socket: %s\n", Tcl_GetChannelName(chan));*/

    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PGconn_p");
    return TCL_OK;
}
static int  _wrap_const_CONNECTION_OK = CONNECTION_OK;
static int  _wrap_const_CONNECTION_BAD = CONNECTION_BAD;
static int  _wrap_const_PGRES_EMPTY_QUERY = PGRES_EMPTY_QUERY;
static int  _wrap_const_PGRES_COMMAND_OK = PGRES_COMMAND_OK;
static int  _wrap_const_PGRES_TUPLES_OK = PGRES_TUPLES_OK;
static int  _wrap_const_PGRES_COPY_OUT = PGRES_COPY_OUT;
static int  _wrap_const_PGRES_COPY_IN = PGRES_COPY_IN;
static int  _wrap_const_PGRES_BAD_RESPONSE = PGRES_BAD_RESPONSE;
static int  _wrap_const_PGRES_NONFATAL_ERROR = PGRES_NONFATAL_ERROR;
static int  _wrap_const_PGRES_FATAL_ERROR = PGRES_FATAL_ERROR;

    PQconninfoOption get_PQconninfo(PQconninfoOption *a, int index) {
        return a[index];
    }
static int _wrap_get_PQconninfo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PQconninfoOption * _result;
    PQconninfoOption * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::get_PQconninfo a index ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PQconninfoOption_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of get_PQconninfo. Expected _PQconninfoOption_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (PQconninfoOption *) malloc(sizeof(PQconninfoOption ));
    *(_result) = get_PQconninfo(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PQconninfoOption_p");
    return TCL_OK;
}
static int _wrap_PQsetdbLogin(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGconn * _result;
    char * _arg0;
    char * _arg1;
    char * _arg2;
    char * _arg3;
    char * _arg4;
    char * _arg5;
    char * _arg6;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 8) || (objc > 8)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQsetdbLogin pghost pgport pgoptions pgtty dbName login pwd ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    if ((_arg3 = Tcl_GetStringFromObj(objv[4], &templength)) == NULL) return TCL_ERROR;
    if ((_arg4 = Tcl_GetStringFromObj(objv[5], &templength)) == NULL) return TCL_ERROR;
    if ((_arg5 = Tcl_GetStringFromObj(objv[6], &templength)) == NULL) return TCL_ERROR;
    if ((_arg6 = Tcl_GetStringFromObj(objv[7], &templength)) == NULL) return TCL_ERROR;
    _result = (PGconn *)PQsetdbLogin(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PGconn_p");
    return TCL_OK;
}
static int _wrap_PQconndefaults(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PQconninfoOption * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQconndefaults ",-1);
        return TCL_ERROR;
    }
    _result = (PQconninfoOption *)PQconndefaults();
    tcl_result = Tcl_GetObjResult(interp);
{
    char temp[20];
    Tcl_DString result;
    PQconninfoOption *option;

    if (_result) {
        Tcl_DStringInit(&result);
        if (_result->keyword) {
            for (option = _result; option->keyword != NULL; option++) {

                Tcl_DStringStartSublist(&result);

                Tcl_DStringAppendElement(&result,option->keyword);
                Tcl_DStringAppendElement(&result,option->envvar);
                Tcl_DStringAppendElement(&result,option->compiled);
                Tcl_DStringAppendElement(&result,option->val);
                Tcl_DStringAppendElement(&result,option->label);
                Tcl_DStringAppendElement(&result,option->dispchar);
                sprintf(temp,"%d",option->dispsize);
                Tcl_DStringAppendElement(&result,temp);
                Tcl_DStringEndSublist(&result);
            }
            Tcl_DStringResult(interp, &result);
        } else {
            Tcl_ResetResult(interp);
        }
    }
}
    return TCL_OK;
}
static int _wrap_PQfinish(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQfinish conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQfinish. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    PQfinish(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_PQreset(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQreset conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQreset. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    PQreset(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_PQrequestCancel(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQrequestCancel conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQrequestCancel. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQrequestCancel(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQdb(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQdb conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQdb. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQdb(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQuser(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQuser conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQuser. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQuser(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQpass(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQpass conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQpass. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQpass(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQhost(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQhost conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQhost. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQhost(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQport(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQport conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQport. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQport(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQtty(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQtty conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQtty. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQtty(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQoptions(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQoptions conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQoptions. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQoptions(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQstatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ConnStatusType  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQstatus conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQstatus. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (ConnStatusType )PQstatus(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQerrorMessage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQerrorMessage conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQerrorMessage. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQerrorMessage(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQsocket(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQsocket conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQsocket. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQsocket(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQbackendPID(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQbackendPID conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQbackendPID. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQbackendPID(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQtrace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGconn * _arg0;
    FILE * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQtrace conn debug_port ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQtrace. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_FILE_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of PQtrace. Expected _FILE_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    PQtrace(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_PQuntrace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQuntrace conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQuntrace. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    PQuntrace(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_PQexec(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGresult * _result;
    PGconn * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQexec conn query ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQexec. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (PGresult *)PQexec(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PGresult_p");
    return TCL_OK;
}
static int _wrap_PQnotifies(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGnotify * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQnotifies conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQnotifies. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (PGnotify *)PQnotifies(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
{
    char temp[20];
    Tcl_DString result;
    PGnotify *notify;

    if (_result) {
        Tcl_DStringInit(&result);
        if (_result) {
            Tcl_DStringStartSublist(&result);
            
            Tcl_DStringAppendElement(&result,notify->relname);
            sprintf(temp,"%d",notify->be_pid);
            Tcl_DStringAppendElement(&result,temp);
            Tcl_DStringEndSublist(&result);
        }
        Tcl_DStringResult(interp, &result);
        free(notify);
    } else {
        Tcl_ResetResult(interp);
    }
}
    return TCL_OK;
}
static int _wrap_PQsendQuery(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQsendQuery conn query ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQsendQuery. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )PQsendQuery(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQgetResult(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGresult * _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetResult conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetResult. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (PGresult *)PQgetResult(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PGresult_p");
    return TCL_OK;
}
static int _wrap_PQisBusy(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQisBusy conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQisBusy. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQisBusy(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQconsumeInput(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQconsumeInput conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQconsumeInput. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQconsumeInput(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQgetline(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    char * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetline conn string length ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetline. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )PQgetline(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQputline(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQputline conn string ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQputline. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )PQputline(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQgetlineAsync(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    char * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetlineAsync conn buffer bufsize ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetlineAsync. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )PQgetlineAsync(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQputnbytes(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    char * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQputnbytes conn buffer nbytes ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQputnbytes. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )PQputnbytes(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQendcopy(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQendcopy conn ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQendcopy. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQendcopy(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQresultStatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ExecStatusType  _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQresultStatus res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQresultStatus. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (ExecStatusType )PQresultStatus(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQresultErrorMessage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQresultErrorMessage res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQresultErrorMessage. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQresultErrorMessage(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQntuples(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQntuples res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQntuples. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQntuples(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQnfields(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQnfields res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQnfields. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQnfields(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQbinaryTuples(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQbinaryTuples res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQbinaryTuples. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )PQbinaryTuples(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQfname(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQfname res field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQfname. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (char *)PQfname(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQfnumber(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQfnumber res field_name ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQfnumber. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (int )PQfnumber(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQftype(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    Oid * _result;
    PGresult * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQftype res field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQftype. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (Oid *) malloc(sizeof(Oid ));
    *(_result) = PQftype(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_Oid_p");
    return TCL_OK;
}
static int _wrap_PQfsize(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQfsize res field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQfsize. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )PQfsize(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQfmod(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQfmod res field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQfmod. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )PQfmod(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQcmdStatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQcmdStatus res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQcmdStatus. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQcmdStatus(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQoidStatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQoidStatus res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQoidStatus. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQoidStatus(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQcmdTuples(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQcmdTuples res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQcmdTuples. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (char *)PQcmdTuples(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQgetvalue(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    PGresult * _arg0;
    int  _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetvalue res tup_num field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetvalue. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (char *)PQgetvalue(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
static int _wrap_PQgetlength(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    int  _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetlength res tup_num field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetlength. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )PQgetlength(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQgetisnull(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGresult * _arg0;
    int  _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQgetisnull res tup_num field_num ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQgetisnull. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )PQgetisnull(_arg0,_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_PQclear(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGresult * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQclear res ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGresult_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQclear. Expected _PGresult_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    PQclear(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_PQmakeEmptyPGresult(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    PGresult * _result;
    PGconn * _arg0;
    ExecStatusType  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::PQmakeEmptyPGresult conn status ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of PQmakeEmptyPGresult. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (ExecStatusType ) tempint;
    _result = (PGresult *)PQmakeEmptyPGresult(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_PGresult_p");
    return TCL_OK;
}
static int _wrap_lo_open(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Oid * _arg1;
    int  _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_open conn lobjId mode ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_open. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_Oid_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of lo_open. Expected _Oid_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    _result = (int )lo_open(_arg0,*_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_close(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_close conn fd ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_close. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )lo_close(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_read(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    int  _arg1;
    char * _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_read conn fd buf len ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_read. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    _result = (int )lo_read(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_write(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    int  _arg1;
    char * _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_write conn fd buf len ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_write. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    _result = (int )lo_write(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_lseek(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_lseek conn fd offset whence ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_lseek. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
    _result = (int )lo_lseek(_arg0,_arg1,_arg2,_arg3);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_creat(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    Oid * _result;
    PGconn * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_creat conn mode ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_creat. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (Oid *) malloc(sizeof(Oid ));
    *(_result) = lo_creat(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_Oid_p");
    return TCL_OK;
}
static int _wrap_lo_tell(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_tell conn fd ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_tell. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    _result = (int )lo_tell(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_unlink(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Oid * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_unlink conn lobjId ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_unlink. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_Oid_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of lo_unlink. Expected _Oid_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    _result = (int )lo_unlink(_arg0,*_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_lo_import(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    Oid * _result;
    PGconn * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_import conn filename ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_import. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    _result = (Oid *) malloc(sizeof(Oid ));
    *(_result) = lo_import(_arg0,_arg1);
    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_Oid_p");
    return TCL_OK;
}
static int _wrap_lo_export(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    PGconn * _arg0;
    Oid * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. tclpq::lo_export conn lobjId filename ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_PGconn_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of lo_export. Expected _PGconn_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_Oid_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of lo_export. Expected _Oid_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    _result = (int )lo_export(_arg0,*_arg1,_arg2);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
SWIGEXPORT(int,Tclpq_Init)(Tcl_Interp *interp) {
#ifdef ITCL_NAMESPACES
	 Itcl_Namespace spaceId;
#endif
	 if (interp == 0) 
		 return TCL_ERROR;
	 SWIG_RegisterType();
#if (TCL_MAJOR_VERSION >= 8)
	 Tcl_Eval(interp,"namespace eval tclpq { }");
#endif

    Tcl_PkgProvide(interp,"tclpq","1.0");
    Tcl_CreateObjCommand(interp, SWIG_prefix "PQconnectdb",
                         _wrap_PQconnectdb,
                         (ClientData) NULL,
                         (Tcl_CmdDeleteProc *) NULL);
	 Tcl_LinkVar(interp, SWIG_prefix "CONNECTION_OK", (char *) &_wrap_const_CONNECTION_OK, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "CONNECTION_BAD", (char *) &_wrap_const_CONNECTION_BAD, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_EMPTY_QUERY", (char *) &_wrap_const_PGRES_EMPTY_QUERY, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_COMMAND_OK", (char *) &_wrap_const_PGRES_COMMAND_OK, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_TUPLES_OK", (char *) &_wrap_const_PGRES_TUPLES_OK, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_COPY_OUT", (char *) &_wrap_const_PGRES_COPY_OUT, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_COPY_IN", (char *) &_wrap_const_PGRES_COPY_IN, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_BAD_RESPONSE", (char *) &_wrap_const_PGRES_BAD_RESPONSE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_NONFATAL_ERROR", (char *) &_wrap_const_PGRES_NONFATAL_ERROR, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, SWIG_prefix "PGRES_FATAL_ERROR", (char *) &_wrap_const_PGRES_FATAL_ERROR, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "get_PQconninfo", _wrap_get_PQconninfo, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQsetdbLogin", _wrap_PQsetdbLogin, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQconndefaults", _wrap_PQconndefaults, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQfinish", _wrap_PQfinish, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQreset", _wrap_PQreset, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQrequestCancel", _wrap_PQrequestCancel, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQdb", _wrap_PQdb, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQuser", _wrap_PQuser, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQpass", _wrap_PQpass, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQhost", _wrap_PQhost, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQport", _wrap_PQport, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQtty", _wrap_PQtty, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQoptions", _wrap_PQoptions, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQstatus", _wrap_PQstatus, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQerrorMessage", _wrap_PQerrorMessage, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQsocket", _wrap_PQsocket, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQbackendPID", _wrap_PQbackendPID, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQtrace", _wrap_PQtrace, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQuntrace", _wrap_PQuntrace, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQexec", _wrap_PQexec, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQnotifies", _wrap_PQnotifies, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQsendQuery", _wrap_PQsendQuery, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetResult", _wrap_PQgetResult, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQisBusy", _wrap_PQisBusy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQconsumeInput", _wrap_PQconsumeInput, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetline", _wrap_PQgetline, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQputline", _wrap_PQputline, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetlineAsync", _wrap_PQgetlineAsync, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQputnbytes", _wrap_PQputnbytes, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQendcopy", _wrap_PQendcopy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQresultStatus", _wrap_PQresultStatus, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQresultErrorMessage", _wrap_PQresultErrorMessage, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQntuples", _wrap_PQntuples, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQnfields", _wrap_PQnfields, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQbinaryTuples", _wrap_PQbinaryTuples, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQfname", _wrap_PQfname, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQfnumber", _wrap_PQfnumber, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQftype", _wrap_PQftype, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQfsize", _wrap_PQfsize, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQfmod", _wrap_PQfmod, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQcmdStatus", _wrap_PQcmdStatus, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQoidStatus", _wrap_PQoidStatus, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQcmdTuples", _wrap_PQcmdTuples, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetvalue", _wrap_PQgetvalue, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetlength", _wrap_PQgetlength, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQgetisnull", _wrap_PQgetisnull, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQclear", _wrap_PQclear, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "PQmakeEmptyPGresult", _wrap_PQmakeEmptyPGresult, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_open", _wrap_lo_open, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_close", _wrap_lo_close, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_read", _wrap_lo_read, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_write", _wrap_lo_write, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_lseek", _wrap_lo_lseek, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_creat", _wrap_lo_creat, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_tell", _wrap_lo_tell, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_unlink", _wrap_lo_unlink, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_import", _wrap_lo_import, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "lo_export", _wrap_lo_export, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 return TCL_OK;
}
