#!/bin/sh
# start itcl shell -*- tcl -*- \
#    exec /usr/bin/itkwish  "$0" "$@" \
exec /usr/bin/itclsh3.0  "$0" "$@"

# Test asynchronous query processing on a postgresql database
# ./test.tcl database table

#source ../error.tcl

#load ./libtclpq.so

#source pgConnection.tcl
#source pgResult.tcl

package require tclpq

set done 0	;# flag indicating query completion
proc async_callback {connection result args} {
    global done
    puts stderr "async $connection $result"
    if {[llength $result] != 0} {
        $result dump
        delete object $result
    } else {
        #puts "conn stat: [$connection status] / [$connection errorMessage]"
        set done [$connection status]
    }
}

proc cancelit {db} {
    puts stderr "Cancelling $db: [$db cancel]"
}

proc sync {db table} {
    puts ">>> Starting synchronous query"
    set sq [$db exec "select * from $table"]
    $sq dump
    puts ">>> synch query status: $sq"
}

proc async_can {db table} {
    global done

    puts ">>> Starting asynch query with timed cancel"
    set aq [$db aexec "select * from $table" async_callback]
    #puts ">>> asynch cancel query status: $aq"
    after 500 cancelit $db

    vwait done
}

proc async_conc {db table} {
    global done

    puts ">>> Starting asynch query"
    set aq [$db aexec "select * from $table" async_callback]
    #puts ">>> asynch query status: $aq"

    vwait done
}

proc async_succ {db table} {
    global done

    puts ">>> Starting asynch query"
    set aq [$db aexec "select * from $table" async_callback]
    #puts ">>> asynch query status: $aq"
    puts ">>> Starting concurrent asynch query (expected to fail)"
    catch {set aq [$db aexec "select * from $table" async_callback]} err
    puts ">>> concurrent asynch query status: $err"

    vwait done
}

proc async_multi {db table} {
    puts ">>> Starting multiple asynch query"
    set aq [$db aexec "select * from $table\;select * from $table" async_callback]
    #puts ">>> asynch query status: $rq"
    vwait done
}

proc rsync_can {db table} {
    global result
    catch {unset result}

    puts ">>> Starting rsynch query with timed cancel"
    set rq [$db rexec "select * from $table" result]
    #puts ">>> asynch query status: $rq"
    after 500 cancelit $db
    vwait result
    foreach r $result {
        $r dump
        delete object $r
    }
}

proc rsync_conc {db table} {
    global result
    catch {unset result}

    puts ">>> Starting rsynch query"
    set rq [$db rexec "select * from $table" result]
    #puts ">>> rsynch query status: $rq"

    puts ">>> Starting concurrent rsynch query (expected to fail)"
    catch {set aq [$db rexec "select * from $table" result1]} err
    puts ">>> concurrent rsynch query status: $err"
    vwait result
    foreach r $result {
        $r dump
        delete object $r
    }
}

proc rsync_succ {db table} {
    global result
    catch {unset result}

    puts ">>> Starting rsynch query"
    set rq [$db rexec "select * from $table" result]
    #puts ">>> asynch query status: $rq"
    vwait result
    foreach r $result {
        $r dump
        delete object $r
    }
}

proc rsync_multi {db table} {
    global result
    catch {unset result}

    puts ">>> Starting multiple rsynch query"
    set rq [$db rexec "select * from $table\;select * from $table" result]
    #puts ">>> asynch query status: $rq"
    vwait result
    foreach r $result {
        $r dump
        delete object $r
    }
}

proc rsync_multi_r {db table} {
    global result
    catch {unset result}

    puts ">>> Starting multiple rsynch query with multiple result vwaits"
    set rq [$db mrexec "select * from $table\;select * from $table" result]
    #puts ">>> asynch query status: $rq"
    vwait result
    while {[lindex $result end] != {}} {
        vwait result
    }

    foreach r $result {
        if {$r != {}} {
            $r dump
            delete object $r
        }
    }
}

set dbname postcode	;# my test db
if {[llength $argv] > 0} {
    set dbname [lindex $argv 0]	;# passed in db name
}

set table postcode
if {[llength $argv] > 1} {
    set table [lindex $argv 1]	;# passed in table name
}

set db [pgConnection \#auto [list host='localhost' port=5432 dbname=$dbname]]

puts ">>> querying $table in $dbname"
rsync_multi $db $table
rsync_multi_r $db $table
rsync_succ $db $table
rsync_can $db $table
rsync_conc $db $table

async_can $db $table
async_succ $db $table
async_multi $db $table
async_conc $db $table

sync $db $table

puts ">>> complete"
exit
