#include <stdio.h>
#include "tcl.h"
/*
 * MOVE_ARGV(argv, argc, srcArray, dstArray, len);
 *
 * Moves an argv pointing into portions of the source string, into the
 * (presumably larger) destination string. It does this by copying
 * the contents of the array, then adjusting each element of the argv.
 * since the two strings may not be in contiguous memory, we have to
 * work with offsets.
 */

move_argv(argv, argc, src, dst, len)
char **argv;
int argc;
char *src;
char *dst;
int len;
{
	int i;
	unsigned off;

	bcopy(src, dst, len);
	for(i = 0; i <= argc; i++) {
		off = argv[i] - src;
		argv[i] = dst + off;
	}
}
