/* 
 * message.c, based on the TCL panic.c
 *
 *	Source code for the "panic" library procedure.
 *
 * Copyright 1988 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>
 
/*
 *----------------------------------------------------------------------
 *
 * message --
 *
 *	Print a message on the browse command line.
 *
 * Results:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifndef lint
void
message(va_alist)
    va_dcl			/* char *format, then any number of additional
				 * values to be printed under the control of
				 * format.  This is all just the same as you'd
				 * pass to printf. */
{
    char *format;
    va_list args;
    extern int display_up;

    cmdline();
    va_start(args);
    format = va_arg(args, char *);
    (void) vfprintf(stdout, format, args);
    if(!display_up) putchar('\n');
    (void) fflush(stdout);
}
#else
/* VARARGS1 */
/* ARGSUSED */
void
message(format)
    char *format;
{
    return;
}
#endif /* lint */

