#include <stdio.h>

#include "system.h"

#ifdef USG
# ifdef M_XENIX
#  include <sys/types.h>
#  include <sys/ioctl.h>
# endif
# include <termio.h>
struct termio rawbuf;
struct termio cookedbuf;
#else
# include <sgtty.h>                     /* terminal modes for tinit(), tend() */
struct sgttyb sgbuf;                        /* buffer for terminal mode info */
int rawflags, cookflags;		  /* flags for raw & cooked tty mode */
#endif
#include <signal.h>

#define TERMBUF 1024		/* Size of term buf for termcap */

extern int nlines;

extern char *tgetstr(), *tgoto();
extern int display_up;
extern int	intrup;				/* Have we been interrupted? */

char *tent;                                               /* Pointer to tbuf */
char PC;                                                    /* Pad character */
char *UP, *BC;                                /* Upline, backsapce character */
short ospeed;                                       /* Terminal output speed */
char termbuf[TERMBUF];				   /* Place to put term info */

char *cm,                                                   /* Cursor motion */
     *cs,                                         /* Change scrolling region */
     *sf,                                         /*  - scroll forward       */
     *sr,                                         /*  - scroll backwards     */
     *ce,                                            /* Clear to end of line */
     *cl,                                                    /* Clear screen */
     *al,                                                     /* Insert line */
     *dl,                                                    /* delete ditto */
     *so,                                                        /* standout */
     *se,                                                    /* standout end */
     *us,                                                       /* underline */
     *ue,                                                   /* underline end */
     *ti,						    /* Init terminal */
     *te;						   /* Reset terminal */
int  li,                                                  /* lines on screen */
     co;                                                    /* columns ditto */
char xn;		/* Magic cookie kludge */

/* Screen manipulation primitives: dumb set for smart terminals */
at(x, y)
int x, y;
{
	outs(tgoto(cm, x, y));
}

nl()
{
	outs(ce);
	outc('\n');
}

/* Scroll lines in window (from:to) n lines */
scroll(from, to, n)
int from, to, n;
{
	if(cs && sf && sr) {
		outs(tgoto(cs, from, to-1));
		if(n<0) {
			at(0, from);
			while(n++)
				outs(sr);
		}
		else {
			at(0, to-1);
			while(n--)
				outs(sf);
		}
		outs(tgoto(cs, 0, li-1));
	} 
	else if(al && dl) {
		if(n<0) {
			int i=n;
			outs(tgoto(cm, 0, to+n));
			while(i++)
				outs(dl);
			outs(tgoto(cm, 0, from));
			while(n++)
				outs(al);
		} 
		else {
			int i=n;
			outs(tgoto(cm, 0, from));
			while(i--)
				outs(dl);
			outs(tgoto(cm, 0, to-n));
			while(n--)
				outs(al);
		}
	}
}

tinit(name)
char *name;
{
	char *termptr;
	char tbuf[TERMBUF], *tmp;
	SIGNAL  intr();
	SIGNAL term();
#ifdef BSD
	SIGNAL  stop();
#endif

	termptr = termbuf;

	tgetent(tbuf, name);

	tmp = tgetstr("pc", &termptr);
	if(tmp) PC = *tmp;
	UP = tgetstr("up", &termptr);
	BC = tgetstr("bc", &termptr);
	cm = tgetstr("cm", &termptr);
	cs = tgetstr("cs", &termptr);
	sf = tgetstr("sf", &termptr);
	sr = tgetstr("sr", &termptr);
	ce = tgetstr("ce", &termptr);
	cl = tgetstr("cl", &termptr);
	al = tgetstr("al", &termptr);
	dl = tgetstr("dl", &termptr);
	us = tgetstr("us", &termptr);
	ue = tgetstr("ue", &termptr);
	so = tgetstr("so", &termptr);
	se = tgetstr("se", &termptr);
	ti = tgetstr("ti", &termptr);
	te = tgetstr("te", &termptr);
	li = tgetnum("li");
	co = tgetnum("co");
	xn = tgetflag("xn");

	nlines=li-3;

#ifdef USG
	ioctl(1, TCGETA, &rawbuf);
	cookedbuf = rawbuf;
	rawbuf.c_lflag &= ~(ICANON|ECHO|ECHOE|ECHOK|ECHONL);
	rawbuf.c_cc[VMIN] = 1;
	rawbuf.c_cc[VTIME] = 0;
#else
	gtty(1, &sgbuf);
	ospeed=sgbuf.sg_ospeed;
	quickmode=ospeed<10;
	cookflags=sgbuf.sg_flags;
	sgbuf.sg_flags = (sgbuf.sg_flags&~ECHO)|CBREAK;
	rawflags=sgbuf.sg_flags;
#endif
	signal(SIGINT, intr);
	signal(SIGTERM, term);
#ifdef BSD
	signal(SIGTSTP, stop);
#endif
	rawtty();
}

int tmode=0;

entty()
{
	if(!tmode)
		outs(ti);
	tmode=1;
}

extty()
{
	if(tmode)
		outs(te);
	tmode=0;
}

rawtty()
{
#ifdef USG
	ioctl(1, TCSETA, &rawbuf);
#else
	sgbuf.sg_flags=rawflags;
	stty(1, &sgbuf);
#endif
	entty();
}

cooktty()
{
#ifdef USG
	ioctl(1, TCSETA, &cookedbuf);
#else
	sgbuf.sg_flags=cookflags;
	stty(1, &sgbuf);
#endif
	extty();
}

SIGNAL intr()
{
	signal(SIGINT, intr);
	intrup=1;
}

SIGNAL term()
{
	tend();
	tcl_end();
	exit(0);
}

#ifdef BSD
SIGNAL stop()
{
	signal(SIGTSTP, stop);
	intrup=1;
	tend();
	kill(getpid(), SIGSTOP);
	rawtty();
	display_up=0;
}
#endif

tend()
{
	end_screenmode();
	cooktty();
	fflush(stdout);
}

outs(s)
char *s;
{
	int  outc();

	if(s)
		tputs(s, 0, outc);
}

outc(c)
char c;
{
	putchar(c);
}

int somode = 0;
int ulmode = 0;

standout()
{
	if(!somode) {
		outs(so);
		somode = 1;
		if(xn) return 1;
	}
	return 0;
}

underline()
{
	if(!ulmode) {
		outs(us);
		ulmode = 1;
		if(xn) return 1;
	}
	return 0;
}

standend()
{
	int cnt = 0;

	if(somode) {
		outs(se);
		somode = 0;
		if(xn) cnt++;
	}
	if(ulmode) {
		outs(ue);
		ulmode = 0;
		if(xn) cnt++;
	}
	return cnt;
}

cmdline()
{
	at(0, li-1);
	outs(ce);
}

end_screenmode()
{
	if(display_up) {
		at(0, li-1);
		outc('\n');
		display_up = 0;
	}
}

end_linemode()
{
	if(!display_up) {
		redraw();
		display_up = 1;
	}
}

clear_screen()
{
	outs(cl);
}

