/* Subcommands for tcl "get" command */
#include <stdio.h>
#include <ctype.h>
#include <tcl.h>
#include "tcl_browse.h"

int getCmds();
int getResponse();
int getKey();
int getKeyname();
int getLine();
int getEnv();
int getFile();
int getError();
int getMode();
int getCwd();

struct subcmd getcmds[] = {
	{ getCmds, "commands", 0, 0, "" },
	{ getResponse, "response", 0, 3, "[prompt [default [term]]]" },
	{ getKey, "key", 0, 1, "[prompt]" },
	{ getKeyname, "keyname", 1, 1, "key" },
	{ getLine, "line", 1, 1, "{home,last,end,*,.}" },
	{ getFile, "file", 1, 1, "{file,*,.}" },
	{ getEnv, "env", 1, 1, "name" },
	{ getError, "error", 0, 0, "" },
	{ getMode, "mode", 0, 0, "" },
	{ getCwd, "cwd", 0, 0, "" },
};
int getcnt = sizeof getcmds / sizeof *getcmds;

int
cmdGet(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
	return Handle(getcnt, getcmds, interp, argc, argv);
}

getCmds(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	return Format(getcnt, getcmds, interp);
}

char *StrToList(s)
char *s;
{
	char *argv[2];
	argv[0] = s;
	argv[1] = 0;
	return Tcl_Merge(1, argv);
}

getEnv(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	char *getenv();
	char *s = getenv(*argv);
	if(!s)
		Tcl_Return(interp, NULL, TCL_STATIC);
	else
		Tcl_Return(interp, s, TCL_STATIC);
	return TCL_OK;
}

getKeyname(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	char *name_of();
	strcpy(interp->result, name_of(**argv));
	return TCL_OK;
}

getCwd(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	extern char *dot;
	strcpy(interp->result, dot);
	return TCL_OK;
}

extern int getFile(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	extern char *file_name();
	extern int curr;

	if(strcmp(*argv, ".") == 0) {
		Tcl_Return(interp, StrToList(file_name(curr)), TCL_DYNAMIC);
	} else if(strcmp(*argv, "*") == 0) {
		extern int nentries;
		char **argv = (char **)ckalloc(sizeof (char *) * nentries);
		int argc = 0;
		int i;

		for(i = 0; i < nentries; i++) {
			if(tagged(i))
				argv[argc++] = file_name(i);
		}
		argv[argc] = 0;
		if(argv)
			Tcl_Return(interp, Tcl_Merge(argc, argv), TCL_DYNAMIC);
		else
			Tcl_Return(interp, NULL, TCL_STATIC);
		ckfree(argv);
	} else if(isdigit(**argv)) {
		Tcl_Return(interp,
			StrToList(file_name(atoi(*argv))),
			TCL_DYNAMIC);
	} else {
		sprintf(interp->result, "bad line number:  should be \"get file {line,*,.}\"");
		return TCL_ERROR;
	}
	return TCL_OK;
}

getResponse(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	char buffer[256];
	char *def = "";
	char term = 0;
	extern int display_up;

	if(argc >= 1 && argv[0][0]) {
		cmdline();
		outs(argv[0]);
	} if(argc >= 2)
		def = argv[1];
	if(argc >= 3)
		term = argv[2][0];
	if(inps(buffer, def, term) == '\033') {
		Tcl_Return(interp, "Command Killed", TCL_STATIC);
		return TCL_ERROR;
	} else {
		Tcl_Return(interp, buffer, TCL_VOLATILE);
		if(display_up == 0)
			outc('\n');
		return TCL_OK;
	}
}

getLine(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	int line;

	extern int curr;
	extern int top;
	extern int nlines;
	extern int nentries;

	if(strcmp(*argv, "home") == 0) line = top;
	else if(strcmp(*argv, "last") == 0) line = top+nlines-1;
	else if(strcmp(*argv, "end") == 0) line = nentries-1;
	else if(strcmp(*argv, ".") == 0) line = curr;
	else if(strcmp(*argv, "*") == 0) {
		extern int nentries;
		char *string = (char *)ckalloc(8 * nentries);
		char *p = string;
		int i;

		for(i = 0; i < nentries; i++) {
			if(tagged(i)) {
				sprintf(p, "%d ", i);
				p += strlen(p) - 1;
			}
		}
		if(p > string) {
			*--p = 0;
			Tcl_Return(interp, string, TCL_DYNAMIC);
		} else {
			ckfree(string);
			Tcl_Return(interp, NULL, TCL_STATIC);
		}
	} else {
		sprintf(interp->result,
			"invalid line type: should be \"get line {home,last,end,*,.}\"");
		return TCL_ERROR;
	}

	sprintf(interp->result, "%d", line);
	return TCL_OK;
}

getKey(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	extern int display_up;

	if(*argv) {
		cmdline();
		outs(*argv);
	}
	interp->result[0] = getch();
	interp->result[1] = 0;
	if(*argv && !display_up)
		outc('\n');
	return TCL_OK;
}

static char *last_errmsg = "No Error";
static char *last_errfile = NULL;
static char filename[BUFSIZ];

save_errmsg(s)
char *s;
{
	last_errfile = 0;
	last_errmsg = s;
}

save_errno(file)
char *file;
{
	extern char *strerror();
	extern int errno;
	last_errmsg = strerror(errno);
	last_errfile = filename;
	strncpy(filename, file, BUFSIZ);
}

getError(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	static char buffer[BUFSIZ];

	if(last_errfile)
		sprintf(buffer, "%s: %s", last_errfile, last_errmsg);
	else
		strcpy(buffer, last_errmsg);
	Tcl_Return(interp, buffer, TCL_VOLATILE);
	return TCL_OK;
}

getMode(interp, argc, argv)
Tcl_Interp *interp;
int argc;
char **argv;
{
	extern int display_up;
	extern int quickmode;
	char buffer[32];

	if(quickmode)
		strcpy(buffer, "narrow");
	else
		strcpy(buffer, "wide");
	if(display_up)
		strcat(buffer, " page");
	else
		strcat(buffer, " line");
	Tcl_Return(interp, buffer, TCL_VOLATILE);
	return TCL_OK;
}

