/* TCL stuff for Browse */
#include <stdio.h>
#include <setjmp.h>
#include <tcl.h>
#include "tcl_browse.h"

Tcl_Interp *interp = NULL;

extern int cmdBrowse();
extern int cmdGet();

Format(cmdc, cmdv, interp)
int cmdc;
struct subcmd *cmdv;
Tcl_Interp *interp;
{
	char buffer[256];

	strcpy(buffer, cmdv->name);
	while(--cmdc) {
		++cmdv;
		strcat(buffer, " ");
		strcat(buffer, cmdv->name);
	}
	Tcl_Return(interp, buffer, TCL_VOLATILE);
	return TCL_OK;
}

Handle(cmdc, cmdv, interp, argc, argv)
int cmdc;
struct subcmd *cmdv;
Tcl_Interp *interp;
int argc;
char **argv;
{
	char *err;
	char *name;
	char *args;

	err = "wrong # args";
	name = "subcommand";
	args = "args";

	if(argc < 2)
		goto error;

	while(cmdc > 0) {
		if(strcmp(argv[1], cmdv->name) == 0) {
			int result;
			extern int intrup;

			name = cmdv->name;
			args = cmdv->args;
			if(argc < cmdv->min+2
			   || (cmdv->max != -1 && argc > cmdv->max+2))
				goto error;
			result = (*cmdv->func)(interp, argc-2, argv+2);
			if(intrup) {
				result = TCL_ERROR;
				Tcl_Return(interp, "Interrupted", TCL_STATIC);
			}
			return result;
		}
		cmdv++;
		cmdc--;
	}
	err = "unknown subcommand";
error:
	sprintf(interp->result, "%s:  should be \"%.50s %s %s\"",
		err, argv[0], name, args);
	return TCL_ERROR;
}

tcl_panic(bytes)
int bytes;
{
	cmdline();
	printf("Out of memory allocating %d bytes\n", bytes);
	tcl_end();
	tend();
	exit(1);
}

#define BACKUP "proc key_'^Z' {} {browse exit 0}"

tcl_init()
{
	int read_browse_rc = 0;

	setalloc(tcl_panic);

	interp = Tcl_CreateInterp();
	Tcl_CreateCommand(interp, "browse",
		cmdBrowse, (ClientData) "browse", NULL);
	Tcl_CreateCommand(interp, "get",
		cmdGet, (ClientData) "get", NULL);

	if(Tcl_Eval(interp, BACKUP, 0, 0) != TCL_OK) {
		fprintf(stderr, "%s\n", interp->result);
		fprintf(stderr, "(error evaluating %s)\n", BACKUP);
		return 0;
	}

	if(Tcl_Eval(interp, "source /etc/browse.rc", 0, 0) == TCL_OK)
		read_browse_rc = 1;

	if(Tcl_Eval(interp, "source [get env BROWSERC]", 0, 0) == TCL_OK)
		read_browse_rc = 1;
	else if(Tcl_Eval(interp, "source [get env HOME]/.browserc", 0, 0) == TCL_OK)
		read_browse_rc = 1;

	if(!read_browse_rc) {
	    fprintf(stderr,
	      "Could not read /etc/browse.rc, $HOME/.browserc, or $BROWSERC!");
	    return 0;
	}

	return 1;
}

tcl_end()
{
	if(interp)
		Tcl_DeleteInterp(interp);
}

tcl_call(buffer, size)
char *buffer;
{
	int result;

	result = Tcl_Eval(interp, buffer, 0, (char **)0) == TCL_OK;
	strncpy(buffer, interp->result, size);
	buffer[size-1] = 0;
	return result;
}
