/*
 * VOID *ckalloc(memory)
 * unsigned memory;
 *
 * Allocate memory using malloc. If it fails, call a user-defined routine.
 * This routine returns one of:
 *
 * ALLOC_FATAL (-1)	Can't free any more memory, abort.
 * ALLOC_RETRY (0)	Try to allocate the memory again.
 */
#include <stdio.h>
#include "ckalloc.h"

static int (*lowmem)() = NULL;

VOID *ckalloc(memory)
unsigned memory;
{
	VOID *result;
	VOID *malloc();

	do {
		result = malloc(memory);
	} while(result == NULL
	     && lowmem
	     && (*lowmem)(memory) == ALLOC_RETRY);

	if(result == NULL)
		panic("Out of memory: can't malloc %u bytes.\n", memory);

	return result;
}

int (*setalloc(func))()
int (*func)();
{
	int (*old_lowmem)();

	old_lowmem = lowmem;
	lowmem = func;
	return old_lowmem;
}

ckfree(memory)
char *memory;
{
	if(memory)
		free(memory);
}
