#
# NeoWebScript - Server Side Programming based on Safe Tcl
#
# Copyright (C) NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# These procs are loaded into safe interpreters
#
# $Id: client.tcl,v 1.12 1997/12/30 22:47:55 tsunami Exp $
#

# proc to import key value pairs of the form "-color blue"
# into an array in the caller's context.
#
# and dialog box thingie that uses it
#
# i am really missing incr tcl
#
#
#neo_dialog -text "This is an alert mesesage... or something."
#
#neo_dialog -text "This is another alert message."
#

proc import_keyvalue_pairs {arrayName string} {
    upvar $arrayName array

    set len [llength $string]
    if {$len % 2 != 0} {
        error "unmatched key-value pair"
    }

    for {set i 0} {$i < $len} {incr i 2} {
        set key [lindex $string $i]
        if {[string index $key 0] != "-"} {
            error "key $key of key-value pairs doesn't start with a dash"
        }
        set array([string range $key 1 end]) [lindex $string [expr $i + 1]]
    }
}

proc emit_standard_yahoo_link {} {
    html {<a href="http://www.yahoo.com"><img src="http://www.yahoo.com/images/recip.gif" alt="Yahoo!" border=0></a>}
}

proc emit_standard_magellan_search_link {} {
    html {<form method=GET action="http://www.mckinley.com/extsearch.cgi">
<IMG SRC="http://images.mckinley.com/img/type.gif" ALIGN=MIDDLE>
<B>Search for:  </B> <input type=text name=query size=30 value="">
<INPUT type=submit value="Search">
</form>}
}

proc search_neosoft {} {
	   html "<form method=post action=/cgi-bin/neowais-neosoft-search>\n"
	   html "<input type=text name=keywords width=20>\n"
	   html "<input type=hidden name=waisdir value=/usr/local/etc/httpd/htdocs/.index/NEOSOFT.src>\n"
	   html {<input type=submit value="Search NeoSoft!"}
	   html "\n"
	   html "</form>\n"
}

#
# convert an integer-seconds-since-1970 click value to
# RFC850 format, with the additional requirement that it be GMT only
# because that's the way netscape decided to do it.
#
proc neo_clock_to_rfc850_gmt {clock} {
    return [clock format $clock -format "%a, %d-%b-%y %T GMT" -gmt 1]
}

#
# Create a cookie (send a browser a little message that you'll get
# back when they retrieve pages.)
#
# neo_make_cookie cookieName cookieValue [-days expireInDays]
#    [-hours expireInHours] [-minutes expireInMinutes]
#    [-path uriPathCookieAppliesTo]
#    [-secure 1|0]
#
proc neo_make_cookie {name value args} {
    import_keyvalue_pairs params $args
    set cookie "<meta http-equiv=\"Set-Cookie\" content=\"$name=$value"

    set expiresIn 0
    if [info exists params(days)] {
	incr expiresIn [expr $params(days) * 86400]
    }

    if [info exists params(hours)] {
	incr expiresIn [expr $params(hours) * 3600]
    }

    if [info exists params(minutes)] {
	incr expiresIn [expr $params(minutes) * 60]
    }

    if {$expiresIn != 0} {
	append cookie "; expires=[neo_clock_to_rfc850_gmt [expr [clock seconds] + $expiresIn]]"
    }

   if [info exists params(path)] {
       append cookie "; path=$params(path)"
   }

   if [info exists params(domain)] {
       append cookie "; domain=$params(domain)"
   }

   if {[info exists params(secure)] && $params(secure) == 1} {
       append cookie "; secure"
   }
   append cookie "\">"
   return $cookie
}

#
# forms1 - neosoft forms1 manager for neowebscript 
#

#
# this package allows you to define forms that will automatically
# fill in the values of the form elements with the contents of an array,
# where the names of the fields are fetched from correspondingly
# named elements of an array.
#
# If there is no corresponding element, a reasonable default
# value is set instead.  (Blank, in most cases.)
#

#
# set_array_defaults arrayName -key value -key value -key value
#
proc set_array_defaults {arrayName args} {
    upvar $arrayName array
    import_keyvalue_pairs array $args
}

#
# neo_form formName "form html parms"
#
proc neo_form {{arrayName {response}} {parms {}}} {
    global neoFormDataName webenv
	set neoFormDataName $arrayName

	if {$parms == {}} {
		set parms "method=post action=\"[quote_string $webenv(DOCUMENT_NAME)]\""
	}
    html "<form $parms>"
}

#
# neo_form_field type name parms
#
# emit a form entry of
#
proc neo_form_field {type name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }

    if ![string match *value=* [string tolower $parms]] {
	append parms " value=\"[escape_attribute $data($name)]\""
    }
    html "<input name=\"[escape_attribute $name]\" type=\"[escape_attribute $type]\" $parms>"
}

proc neo_form_radiobuttons {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    foreach value $values {
	if {$baseValue == $value} {
	    set checked "checked"
	} else {
	    set checked ""
	}
	html "<input name=\"[escape_attribute $name]\" type=\"radio\" $parms value=\"[escape_attribute $value]\" $checked>[escape_attribute $value]"
    }
}

proc neo_form_select {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    html "<select name=\"[escape_attribute $name]\" $parms>"

    foreach value $values {
	if {$baseValue == $value} {
	    set selected "selected"
	} else {
	    set selected ""
	}
	html "<option $selected>[escape_attribute $value]"
    }
    html "</select>"
}

proc neo_form_checkbox {name {parms ""}}  {
    global neoFormDataName
    upvar #0 $neoFormDataName data 
    if ![info exists data($name)] {
        set data($name) "0"
    }
    
    if ![string match *value=* [string tolower $parms]] {
        append parms " value=\"[escape_attribute $data($name)]\""
    } else {
        set valueid [lsearch -glob [string tolower $parms] "*value=*"] 
        set data($name) [lindex [split [lindex $parms $valueid] =] end]
    }
    
    if {$data($name) == "1"} { 
        append parms " checked"
    }
    
    html "<input name=\"[escape_attribute $name]\" type=\"checkbox\" $parms>"
}

proc neo_form_textarea {name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }
    html "<textarea name=\"[escape_attribute $name]\" $parms>[escape_attribute $data($name)]</textarea>"
}

proc neo_form_submit {{text {}} {parms {}}} {
	if {$parms == {} && [string match *=* [string tolower $text]]} {
		set parms $text
	}
    set typeid [lsearch -glob [string tolower $parms] "*type=*"]
    if {$typeid > -1} { 
        set type [lindex [split [lindex $parms $typeid] =] end]
    } else {
        set type submit
    }   
    if {[lempty $text]} {
        html "<input type=\"[escape_attribute $type]\" $parms>"
    } else { 
        html "<input type=\"[escape_attribute $type]\" value=\"[escape_attribute $text]\" $parms>"
    }   
}   

proc neo_form_reset {{text ""}} {
    if {$text == ""} {
	html "<input type=reset>"
    } else {
	html "<input type=reset value=\"[escape_attribute $text]\">"
    }
}

proc neo_form_end {} {
    html "</form>"
}

#
# detect switches from a string (e.g. "-all -regexp -- foo bar args") and
# extracts them into an array
#
proc import_switch_args {arrayName argsList {switchList {}}} {
    upvar $arrayName array
    set array(args) {}
    set array(switches) {}
    set argsIndex 0
    if {[llength $switchList] > 0} {
	set proofSwitches 1
    } else {
	set proofSwitches 0
    }
    foreach arg $argsList {
        if {![string match "-\[a-zA-Z0-9\]*" $arg]} {
            set array(args) [lrange $argsList $argsIndex end]
            break
        } elseif {$arg == "--"} {
	    set array(args) [lrange $argsList [expr $argsIndex+1] end]
	    break
	}
        set switch [crange $arg 1 end]
	if {!$proofSwitches || [lsearch -exact $switchList $switch] >= 0} {
            set array($switch) $argsIndex
	    lappend array(switches) $switch
	}
        incr argsIndex
    }
}

#
# determine whether a Tcl string converts to a Tcl number
#
proc is_num {number} {
    if {[catch {expr $number+1} errorMsg] == 0} {
        return 1
    }
    return 0
}

#
# escapes reserved SGML characters so that they show up properly in an
# HTML document
#
proc escape_attribute {args} {
    set quoteChar ""
    set text ""
    import_switch_args mode $args
    foreach arg $mode(switches) {
        switch -exact -- $arg {
            "-singlequotes"	{set quoteChar {'}}
            "-doublequotes"	{set quoteChar {"}}
            "-noquotes"		{set quoteChar ""}
        }
    }
    set text [lindex $mode(args) 0]
    return $quoteChar[escape_sgml_chars $text]$quoteChar
}
