# 
# internal function used by lremove
# 
proc lremove_by_index {theList patternList} {
    set indexList {}
    set thelistEnd [expr [llength $theList] - 1]
    foreach pat $patternList {
	set ranges [split $pat "-"]
	if {[llength $ranges] > 2} {
	    error "invalid range: should be index1-index2"
	} elseif {[llength $ranges] == 1} {
	    if [cequal [string tolower $ranges] "end"] {
		set pat $thelistEnd
	    }
	    lappend indexList $pat
	    continue
	}
	lassign [split $pat "-"] r1 r2
	if [cequal [string tolower $r1] "end"] {set r1 $thelistEnd}
	if [cequal [string tolower $r2] "end"] {set r2 $thelistEnd}
	if {![is_num $r1] || ![is_num $r2]} {
	    error "invalid range: should be integer1-integer2"
	}
	if {$r1 < 0} {set r1 0}
	if {$r2 > $thelistEnd} {set r2 $thelistEnd}
	while {$r1 <= $r2} {
	    lappend indexList $r1
	    incr r1
	}
    }
    set newList {}
    set rCount 0
    foreach atom $theList {
	if {[lsearch -exact $indexList $rCount] == -1} {
	    lappend newList $atom
	}
	incr rCount
    }
    return $newList
}

#
# internal function used by lremove
#
proc lremove_by_match {theList searchPattern searchFunc find_once} {
    set newList {}
    set atomIndex 0
    foreach atom $theList {
	set found 0
	foreach pat $searchPattern {
	    if [eval "$searchFunc {$pat} \"$atom\""] {
		set found 1
		break
	    }
	}
	incr atomIndex
	if !$found {
	    lappend newList $atom
	} elseif $find_once {
	    eval lappend newList [lrange $theList $atomIndex end]
	    break
	}
    }
    return $newList
}

proc lremove {args} {
    import_switch_args mode $args {exact glob regexp all index}
    set find_once 1
    set find_index 0
    set searchFunc "cequal"
    set searchArgs {}
    foreach option $mode(switches) {
	switch -exact -- $option {
	    exact	{
		set searchFunc "cequal"
		set find_index 0
	    }
	    glob	{
		set searchFunc "string match"
		set find_index 0
	    }
	    regexp	{
		set searchFunc "regexp"
		set find_index 0
	    }
	    all		{
	        set find_once 0
		set find_index 0
	    }
	    index	{
		set find_index 1
	    }
	}
    }
    if {[llength $mode(args)] < 2} {
	error "wrong # args: should be \"lremove\" ?switch? list pattern ?pattern pattern ...?"
    }
    set theList [lindex $mode(args) 0]
    set searchPattern [lrange $mode(args) 1 end]
    if $find_index {
	return [lremove_by_index $theList $searchPattern]
    } else {
	return [lremove_by_match $theList $searchPattern $searchFunc $find_once]
    }
}

