proc visitor_info {args} {
	global webenv info counterName

	if {[cindex $args 0] == "-"} {
		set counterName [lindex $args end]
		set imports [lrange $args 0 [expr [llength $args] - 2]]
		if [catch {import_keyvalue_pairs data $imports}] {
			return -code error "Incorrect keyvalue pairs."
		}
	} else {
		set counterName [lindex $args 0]
	}

	if {$counterName == {}} {
		return -code error "No counter name specified."
	}

	if ![info exists data(function)] {set data(function) record}
	if ![info exists data(show)] {set data(show) "grandTotal,dailyTotals,hosts,referers"}

	switch $data(function) {
		record {	
			set info($counterName-hosts) {}
			set info($counterName-referers) {}
			set info($counterName-grandTotal) 0
			set info($counterName-dailyTotal-[clock format [clock seconds] -format %D]) 0
			set hostName [string tolower [remote_hostname]]
			if [info exists webenv(HTTP_REFERER)] {
					set referer [crange $webenv(HTTP_REFERER) 7 end]
					set split [split $referer ?]
					set referer [lindex $split 0]
			} else {
				set referer {No Referring URL}
			}

			dbfetch RHCounter info info

			if {[lsearch -exact $info($counterName-hosts) $hostName] < 0} {
				lappend info($counterName-hosts) $hostName
				set store(hits) 1
				dbstore RHCounter $counterName-$hostName store
			} else {
				dbfetch RHCounter $counterName-$hostName array
				incr array(hits)
				dbstore RHCounter $counterName-$hostName array
			}

			if {[lsearch -exact $info($counterName-referers) $referer] < 0} {
				lappend info($counterName-referers) $referer
				set store(hits) 1
				dbstore RHCounter $counterName-$referer store
			} else {
				dbfetch RHCounter $counterName-$referer array
				incr array(hits)
				dbstore RHCounter $counterName-$referer array
			}

			incr info($counterName-grandTotal)
			incr info($counterName-dailyTotal-[clock format [clock seconds] -format %D])
			dbstore RHCounter info info
		}

		report {
			if {[dbkeys RHCounter $counterName*] == {}} {
				return -code error "$counterName: counter does not exist."
			}

			if ![dbfetch RHCounter info info] {
				return -code error "You have no remote_host counters."
			}

			foreach report [split $data(show) ,] {
				if [catch report_$report] {
					return -code error "I don't know how to report $report"
				}
				html <hr>
			}
		}
	}
}

proc report_grandTotal {} {
	global info counterName
	html <table>
	html <tr>
	html "<td><center><h3>Grand Total:</td>"
	html "<td>$info($counterName-grandTotal)</td>"
	html </tr>
	html </table>
}

proc report_dailyTotals {} {
	global info counterName
	html <p>
	html "Daily Totals:" h3
	html <hr>
	html <table>
	html <tr>
	html "<td><center>Date</td>"
	html "<td>Total Hits</td>"
	html </tr>
	foreach day [array names info $counterName-dailyTotal-*] {
		html <tr>
		html "<td>[lindex [split $day -] 2]</td>"
		html "<td><center>$info($day)</td>"
		html </tr>
	}
	html </table>
}

proc report_hosts {} {
	global info counterName
	html <p>
	html "Remote Host Count:" h3
	html <hr>
	html <table>
	html <tr>
	html "<td><center>Hostname</td>"
	html "<td>Total Hits</td>"
	html </tr>
	foreach remoteHost $info($counterName-hosts) {
		dbfetch RHCounter $counterName-$remoteHost counterArray
		html <tr>
		html "<td>$remoteHost</td>"
		html "<td><center>$counterArray(hits)</td>"
		html </tr>
	}
	html </table>
}

proc report_referers {} {
	global info counterName
	html <p>
	html "Document Referer Count:" h3
	html <hr>
	html <table>
	html <tr>
	html "<td><center>Referer</td>"
	html "<td>Total Hits</td>"
	html </tr>
	foreach referer $info($counterName-referers) {
		dbfetch RHCounter $counterName-$referer counterArray
		html <tr>
		html "<td>$referer</td>"
		html "<td><center>$counterArray(hits)</td>"
		html </tr>
	}
	html </table>
}
