// MAM - The Modeling and Animation Machine 
// VRS - The Virtual Rendering System 
// Copyright (c) 1994-96 Juergen Doellner
// Institut fuer Informatik, Westfaelische Wilhelms Universitaet Muenster 
// See the LICENSE file in this distribution.

#ifndef MAM_DYNARRAY_H
#define MAM_DYNARRAY_H

#include "base/sharedobj.h"

//- DynArray
template<class T>
class DynArray : public SharedObj {
//. Dynamic Array ADT
public:
    //- DynArray
    DynArray();		
    DynArray(int s);
    DynArray(const DynArray&);
    virtual ~DynArray();
        //. Default array size : 10

    //- operator= 
    DynArray& operator=(const DynArray&);
	//. Target arrray becomes the same size as the source array.

    //- operator[], size
    T& operator[](int);
    const T& operator[](int) const;
    int size() const;
	//. Elements can be accessed by reference and by value.

    //- operator==, operator!= 
    int operator==(const DynArray&) const;
    int operator!=(const DynArray&) const;
	//. Two arrays are equal if they contain the same number of
	//. elements and if all elements are equal.

    //- resize 
    void resize(int);
        //. If the array size is incremented, the original content is not
	//. affected. If the array size is decremented, the content is
	//. cut. 

    T& obj(int i) { return data_[i]; }
        // sgi, should be not necessary if compilers understand the [] op
private:
    T* data_;
    int arrSize_;
    int logSize_; 
};

#include "base/dynarray.cc"

#endif
