// MAM - The Modeling and Animation Machine 
// VRS - The Virtual Rendering System 
// Copyright (c) 1994-96 Juergen Doellner
// Institut fuer Informatik, Westfaelische Wilhelms Universitaet Muenster 
// See the LICENSE file in this distribution.
#ifndef VRS_RENDEROBJ_H
#define VRS_RENDEROBJ_H

#include <iostream.h>
#include "base/sharedobj.h"
#include "base/factory.h"
#include "vrs/rdoc.h"

//- RenderObj 
class RenderObj : public SharedObj {
//. Abstract base class for VRS Rendering Objects
public:
    //- RenderObj
    RenderObj();
    virtual ~RenderObj();
	//. Render objects define the persistency protocol of
	//. of rendering objects.

    //- modified, lastChange
    virtual void modified();
    virtual unsigned long lastChange() const; 
        //. Each render object contains a time stamp. This time is the
	//. time of the last modification applied to that render object.
	//. 'modified' assigns the render object the current time as
	//. new time stamp. 'lastChange' returns the time of the
	//. modification. 
 
    //- write, read 
    virtual void write(RDoc&) const = 0;
    virtual void read(RDoc&) = 0;
	//. Render objects define their persistency management
	//. in the write and read method. 

    RTTI 
private:
    unsigned long timeStamp_;
};

CLASS_NAME(RenderObj)

#endif
