// MAM - The Modeling and Animation Machine 
// VRS - The Virtual Rendering System 
// Copyright (c) 1994-96 Juergen Doellner
// Institut fuer Informatik, Westfaelische Wilhelms Universitaet Muenster 
// See the LICENSE file in this distribution.
#ifndef VRS_RSPHERE_H
#define VRS_RSPHERE_H

#include "base/sharedobj.h"
#include "base/vector.h"
#include "vrs/ranalytic.h"

//- RSphere
class RSphere : public RAnalytic {
//- Sphere Shape.
public:
    //- RSphere 
    RSphere(float r=1, const Vector& = Vector(0,0,0) );
    RSphere(const RSphere&);
    virtual ~RSphere();
      //. The actual sphere representation depends on the rendering device.
      //. The sphere may be tessellated according to the tessellation 
      //. attribute.

    //- setCenter, getCenter, setRadius, getRadius
    virtual void setCenter(const Vector&);
    virtual Vector getCenter() const;
    virtual void setRadius(float);
    virtual float getRadius() const;
      //. The sphere is defined by its midpoint and radius.

    //- boundingBox
    virtual RVolume boundingBox() const;

    //- operator==, operator= 
    RSphere& operator=(const RSphere&);
    int operator==(const RSphere&) const;

    // write, read
    virtual void write(RDoc&) const;
    virtual void read(RDoc&);

    RTTI
private:
    Vector center_;
    float radius_;
};

CLASS_NAME(RSphere)

#endif
